sap.ui.jsview(sluiCore.mod.jsexeCntrl, {
	prevBtn: 		undefined,
	nxtBtn: 		undefined,
	cnlBtn: 		undefined,
	clsBtn: 		undefined,
	oToolbar: 		undefined,
	oExeCntrlLt: 	undefined,
	executionState:	undefined,
	pDesc: 			undefined,
	pImg: 			undefined,
	instBtnColl: 	[],
	hasCustBtn: 	false,
	buttonMode: 	true,
	enterPressed: 	false,
	
	changeExecutionState: function(executionState) {
		if (this.buttonMode) {
			this.executionState = executionState;
			this.prevBtn.setVisible(true);
			this.prevBtn.setEnabled(true);
			this.nxtBtn.setVisible(true);
			this.nxtBtn.setEnabled(true);
			this.cnlBtn.setVisible(true);
			this.cnlBtn.setEnabled(true);
			if (this.executionState === 'ENABLEALL') { 				// Enable ALL
				this.prevBtn.setVisible(true);
				this.prevBtn.setEnabled(true);
				this.nxtBtn.setVisible(true);
				this.nxtBtn.setEnabled(true);
				this.cnlBtn.setVisible(true);
				this.cnlBtn.setEnabled(true);
			} else if (this.executionState === 'ENABLEFINISH') { 	// enable All
				this.prevBtn.setVisible(false);
				this.nxtBtn.setVisible(false);
				this.cnlBtn.setVisible(true);
				this.cnlBtn.setEnabled(true);
			} else if (this.executionState === 'FRESHNEXT') {
				this.prevBtn.setVisible(true);
				this.prevBtn.setEnabled(false);
				this.nxtBtn.setVisible(true);
				this.nxtBtn.setEnabled(true);
				this.cnlBtn.setVisible(true);
				this.cnlBtn.setEnabled(true);
			} else if (this.executionState === 'DISABLEALL') {
				this.prevBtn.setVisible(true);
				this.prevBtn.setEnabled(fasle);
				this.nxtBtn.setVisible(true);
				this.nxtBtn.setEnabled(false);
				this.cnlBtn.setVisible(true);
				this.cnlBtn.setEnabled(false);
			} else if (this.executionState === 'HIDEALL') {
				this.prevBtn.setVisible(false);
				this.nxtBtn.setVisible(false);
				this.cnlBtn.setVisible(false);
			}
		}
	},
	
	createContent: function(oController) {
		var suc = sap.ui.commons;
		this.oExeCntrlLt = new suc.layout.VerticalLayout();
		this.oToolbar = new suc.Toolbar("slui_executionControlBar");
		this.oExeCntrlLt.addContent(new sap.ui.core.HTML("htmlcnt", {	content:			"<div style=\"width:100%; height:10px;\"></div>",
																		sanitizeContent: 	true												}));
		this.oExeCntrlLt.addContent(this.oToolbar);
		this.assignF1KeyForHelp();
		return this.oExeCntrlLt;
	},
	
	assignF1KeyForHelp: function() {
		$(document).keydown(function(e){
			if (e && (e.key === "F1")) {
				window.onhelp = function() {return false;};
				e.cancelable = true;
				e.stopPropagation();
				e.preventDefault();
				e.returnValue = false;
				openHelpWindow();
			}
		}); 
	},

	doSubmitAction: function() {					/* KB: added for usage in SimpleUIRenderer on event "onsapenter" on input fields */
		this.enterPressed = true;
		var oProExe =  oStub.oFather.oProcExe;
		var oUIProDel = oProExe.oUIProc;
		var sSte = oUIProDel.sState;
		var id = null, type = null, bActive = false; 
		var selfRef = oStub.oFather.getView().vExeCont;
		if (sSte && oStub.oFather.oUtil.checkMonitorState(sSte, 3)) {
			for (var x1 = 0; x1 < oUIProDel.actions.length; x1++) {
				var atn = oUIProDel.actions[x1];
				if (atn.getType() === suiCnst.SLP_ACTN_TYPE_SUBMIT) {
						id = atn.getId(); 
						type = atn.getType();
						bActive = atn.getActive();
						if (bActive == null || bActive == undefined) bActive = true;
						break;
				}
			}
			if (bActive && id && type && selfRef && !selfRef.validateAndMoveNext()) {
				if (oProExe && !oProExe.oUIProc.diaInDrtyState) {
					//check for action of type submit 
					oProExe.invokeTagetAction(id, type);
					oStub.oFather.getView().vExeWizd.distroyWizrdContent();
					if (oStub.oFather.execVwProps["showActionsInRunning"] === false) oStub.oFather.getView().vExeCont.destroyAllButtons();
				}
			}
		}
	}, 
	
	generateButtonList: function() {
		this.enterPressed = false;
		var suc = sap.ui.commons;
		if (this.buttonMode) {
			if (this.oToolbar.getItems().length <= 0) {
				this.prevBtn = new suc.Button('slui_preBtn', {	text: 		oBundle.getText("BTN_PREV_TXT"),
																tooltip: 	oBundle.getText("BTN_PREV_TXT"),
																width: 		"75px"								});
				this.nxtBtn = new suc.Button('slui_nxtBtn', {	text: 		oBundle.getText("BTN_NXT_TXT"),
																tooltip: 	oBundle.getText("BTN_NXT_TXT"),
																width: 		"75px"								});
				this.cnlBtn = new suc.Button('slui_canBtn', {	text: 		oBundle.getText("BTN_CAN_TXT"),
																tooltip: 	oBundle.getText("BTN_CAN_TXT"),
																width: 		"75px"								});
				this.cnlBtn.attachPress(this.cancelBtnPress);
				this.nxtBtn.attachPress(this.nextBtnPress);
				this.prevBtn.attachPress(this.preBtnPress);
				this.oToolbar.setWidth("100%");
				this.oToolbar.addItem(this.prevBtn);
				this.oToolbar.addItem(this.nxtBtn);
				this.oToolbar.addItem(new suc.ToolbarSeparator({design: suc.ToolbarSeparatorDesign.Standard}));
				this.oToolbar.addItem(this.cnlBtn);
			}
		} else { 			
			if (oStub.oFather.execVwProps["showActionsInRunning"] === true) this.processActionAsButtons();
			else {
				if (oStub.oFather.oProcExe.oUIProc.sState === suiCnst.SLP_TASK_STATUS_RUNNING ) this.oToolbar.destroyItems();
				else {
					if (oStub.oFather.execVwProps["actionOnDialogOnly"] === true) {
						if (oStub.oFather.oProcExe.oUIProc.isDiaRendered || oStub.oFather.oProcExe.externalDebug) this.processActionAsButtons();	
						else this.oToolbar.destroyItems();
					} 
					else this.processActionAsButtons();
				}
			}
		}
	},
	
	_processHiddenActions: function(e) {
		var oFCntrl = oStub.oFather;
		var oProExe = oFCntrl.oProcExe;
		if (e) e.preventDefault();	
		if ((e.getSource().getText().toLowerCase() === "exit") && (document.getElementsByTagName('html')[0].innerHTML.search("Tool start required") > 0)) {
			oProExe.httpServerExitTriggered = true;
		}
		oFCntrl.getView().vExeWizd.distroyWizrdContent();
		oFCntrl.getView().vExeWizd.busyLayout(true);
		oFCntrl.getView().vExeCont.destroyAllButtons();
		var selectedAtn = e.getSource().getText().toLowerCase();
		if (selectedAtn === "exit") oProExe.invokeTagetAction(selectedAtn, suiCnst.SLP_ACTN_TYPE_ABORT);
		else oProExe.invokeTagetAction(selectedAtn, suiCnst.SLP_ACTN_TYPE_REPEAT);
		oProExe.repeatMonitor = true;
		oProExe.getSLPMonitorWithTimer();
		if (oFCntrl.execVwProps["hideActionsIfTriggerd"] === true) oFCntrl.getView().vExeCont.destroyAllButtons();
	},
	
	processActionAsButtons: function() {
		var oUIProDel = oStub.oFather.oProcExe.oUIProc;
		if (oUIProDel && ((!oUIProDel.isActionRendered) || oStub.oFather.oProcExe.externalDebug)) {
			// in debug mode - remove all existing buttons 
			if (oUIProDel.actions && (oUIProDel.actions.length > 0)) {
				var cActLst = [];
				oUIProDel.isActionRendered = true;
				// remove reset/cleanup action from the 'More'-menu
				oClient.oFather.getRootShell().oParent.enableResetMenu(null, null, false);
				oClient.oFather.getRootShell().oParent.enableCleanupMenu(null, null, false);
				oClient.oFather.getRootShell().oParent.enableExitMenu(null, null, false);
				var iWidth = 75;
				for (var x1 = 0; x1 < oUIProDel.actions.length; x1++) {
					var atn = oUIProDel.actions[x1];
					var bEnable = atn.getActive();
					if (bEnable == null || bEnable == undefined) bEnable = true;
					var exist = false;
					if (this.oToolbar.getItems().length > 0) {
						for (var x2 = 0; x2 < this.oToolbar.getItems().length; x2++) {
							if (this.oToolbar.getItems()[x2].getId() === "_slui_actn_btn_" + atn.getId() + "_btntpe_" + atn.getType()) {
								// do not re render
								this.oToolbar.getItems()[x2].setEnabled(bEnable);
								exist = true;
								cActLst.push(this.oToolbar.getItems()[x2].getId());
							}
						}
						if (exist == false) {
							//hard Code Fix 
							if (atn && (atn.getName() === "Reset"))
							    oClient.oFather.getRootShell().oParent.enableResetMenu(atn.getName(), this._processHiddenActions, bEnable);
							else if (atn && (atn.getName() === "Cleanup"))
							    oClient.oFather.getRootShell().oParent.enableCleanupMenu(atn.getName(), this._processHiddenActions, bEnable);
							else if (atn && (atn.getName() === "Exit"))
							    oClient.oFather.getRootShell().oParent.enableExitMenu(atn.getName(), this._processHiddenActions, bEnable);
							else if (atn && ((atn.getName() === "Immediate Reset") || (atn.getName() === "IMMEDIATERESET")));
							else {
								if (atn && atn.getName() === "Repeat Module") iWidth= 100;
								this.addButtonToToolBar(atn, cActLst, oUIProDel, iWidth);
							}
						}
					} else {
						// hard code fix 
						if (atn && (atn.getName() === "Reset"))
						    oClient.oFather.getRootShell().oParent.enableResetMenu(atn.getName(), this._processHiddenActions, bEnable);
						else if (atn && (atn.getName() === "Cleanup"))
						    oClient.oFather.getRootShell().oParent.enableCleanupMenu(atn.getName(), this._processHiddenActions, bEnable);
						else if (atn && (atn.getName() === "Exit"))
						    oClient.oFather.getRootShell().oParent.enableExitMenu(atn.getName(), this._processHiddenActions, bEnable);                                                
						else if (atn && ((atn.getName() === "Immediate Reset") || (atn.getName() === "IMMEDIATERESET")));
						else {
						    if (atn && atn.getName() === "Repeat Module") iWidth= 100;
						    this.addButtonToToolBar(atn, cActLst, oUIProDel, iWidth);
						}
					}
				}
				// Remove the not used actions from previous list
				for (var i1 = 0; i1 < this.oToolbar.getItems().length; i1++) {
					if (this.oToolbar.getItems()[i1].getId().indexOf("_seperator") === -1) {
						if (cActLst.indexOf(this.oToolbar.getItems()[i1].getId()) === -1) {
							this.oToolbar.getItems()[i1].destroy();
							i1--;
						}
					}
				}
			} 
			else if (oUIProDel.actions && oUIProDel.actions.length == 0) this.oToolbar.destroyItems();
		}
	},
	
	destroyAllButtons: function() {
		if (this.oToolbar) {
			this.oToolbar.destroyItems();	
			oClient.oFather.getRootShell().oParent.enableResetMenu(null, null, false);
			oClient.oFather.getRootShell().oParent.enableCleanupMenu(null, null, false);
			oClient.oFather.getRootShell().oParent.enableExitMenu(null, null, false);
		}
	},
	
	hideOrShowAllButtons: function(buttonVisibility) {
		if (this.oToolbar) for (var i = 0; i < this.oToolbar.getItems().length; i++) if (this.oToolbar.getItems()[i].setVisible) this.oToolbar.getItems()[i].setVisible(buttonVisibility);
	},

	addButtonToToolBar: function(atn, cActLst, oUIProDel, iWidth) {
		var suc = sap.ui.commons;
		cActLst.push("_slui_actn_btn_" + atn.getId() + "_btntpe_" + atn.getType());
		if ((atn.getType() === suiCnst.SLP_ACTN_TYPE_ABORT) || (atn.getType() === suiCnst.SLP_ACTN_TYPE_STOP)) this.oToolbar.addItem(new suc.ToolbarSeparator("_slui_actn_btn_" + atn.getId() + "_btntpe_" + atn.getType() + "_seperator", {design: suc.ToolbarSeparatorDesign.Standard}));
		var bEnable = atn.getActive();
		var actionDesc = atn.getDescription();
		if (bEnable == null || bEnable == undefined) bEnable =true;
		var btn = new suc.Button("_slui_actn_btn_" + atn.getId() + "_btntpe_" + atn.getType(), {
			width: 		iWidth + "px",
			text: 		atn.getName(),
			tooltip: 	atn.getName(),
			enabled: 	bEnable,
			press: function(e) {
				if (e) e.preventDefault();	
				var trigger = true;
				var triggerConfirmPopup = false;
				var oFCntrl = oStub.oFather;
				var oProExe = oFCntrl.oProcExe;
				var selfRef = oStub.oFather.getView().vExeCont;
				var id = this.sId;
				var typ;
				if (oMessagePopover) oMessagePopover.close(); // close Manual Action Dialog if still open
				if (id.indexOf("_btntpe_") > -1) {
					var fnd = id.indexOf("_btntpe_");
					typ = id.substr(fnd, id.length);
					id = id.substr(0, fnd);
				}
				if (id.indexOf("_slui_actn_btn_") > -1) id = id.replace("_slui_actn_btn_", "");
				if (typ.indexOf("_btntpe_") > -1) typ = typ.replace("_btntpe_", "");
				if (typ === suiCnst.SLP_ACTN_TYPE_SUBMIT) {
					trigger = false;
					if ((!selfRef.validateAndMoveNext()) && (!oProExe.oUIProc.diaInDrtyState)) {
						oProExe.invokeTagetAction(id, typ);
						oFCntrl.getView().vExeWizd.distroyWizrdContent();
						if (oStub.oFather.execVwProps["showActionsInRunning"] === false) oFCntrl.getView().vExeCont.destroyAllButtons();
						trigger = true;
					}
				} else if ((typ === suiCnst.SLP_ACTN_TYPE_ABORT) || (typ === suiCnst.SLP_ACTN_TYPE_STOP)) {
					selfRef.cancellation(id, typ, actionDesc);
					trigger = false;
					triggerConfirmPopup = true;
				} else if (typ == suiCnst.SLP_ACTN_TYPE_REPEAT) {
					oFCntrl.getView().vExeWizd.distroyWizrdContent();
					oFCntrl.getView().vExeWizd.busyLayout(true);
					oFCntrl.getView().vExeCont.destroyAllButtons();
					oProExe.invokeTagetAction(id, typ);
					oProExe.repeatMonitor = true;
					oProExe.getSLPMonitorWithTimer();
					trigger = true;
				} 
				else oProExe.invokeTagetAction(id, typ);
				if (trigger && oStub.oFather.execVwProps["hideActionsIfTriggerd"] === true) oFCntrl.getView().vExeCont.destroyAllButtons();
				if (triggerConfirmPopup) oFCntrl.getView().vExeCont.hideOrShowAllButtons(false);
			}
		});
		if ((atn.getType() === suiCnst.SLP_ACTN_TYPE_SUBMIT) && btn) {
			btn.addEventDelegate("keydown", function(e) {
				    if (e && e.keyCode === 13) {
				        e.preventDefault();
				        btn.firePress();
				    }
			});
		}
		if (btn) this.oToolbar.addItem(btn);	
	},
	
	updateContent: function(sMode) {
		var oFCntrl = oStub.oFather;
		var suc = sap.ui.commons;
		if (sMode && (sMode === suiCnst.UI_DIS_EXE_FNSH)) {
			this.oToolbar.destroyRightItems();
			var uibtnClose = new suc.Button("_slui_actn_btn_close", {	width: 	"75px",
																		text: 	oBundle.getText("BTN_CLS_TXT"),
																		press: 	function(e) {window.close();}		});
			uibtnClose.setTooltip(new suc.RichTooltip({text: oBundle.getText("WRN_CLOSE_TXT")}));
			this.oToolbar.addItem(uibtnClose);
		} else if (oFCntrl) {
			this.buttonMode = Boolean(oFCntrl.execVwProps[suiCnst.UI_EXEVW_PRP_UIBTNS]);
			this.generateButtonList();
		}
	},
	
	insertCustomButtonSeperator: function(oCanAdd) {
		if (oCanAdd) this.oToolbar.insertRightItem(new sap.ui.commons.ToolbarSeparator({design: sap.ui.commons.ToolbarSeparatorDesign.Standard}), 2);
	},
	
	insertCustomButton: function(oButton) {
		if (this.oToolbar && oButton) this.oToolbar.insertRightItem(oButton, 3);
	},
	
	cancellation: function(id, typ, desc) {
		var oDia = new SLUIDialogProvider().getDialog("cancelDialog", desc, oBundle.getText("CNF_LBL_TXT"), null);
		if (oStub.oFather.execVwProps["confirmButtons"] == true) {
			oDia.addButton(new sap.ui.commons.Button({
				text: 		oBundle.getText("BTN_YES_TXT"),
				tooltip: 	oBundle.getText("BTN_YES_TXT"),
				width: 		"100px",
				press: function() {
					oDia.close();
					oStub.oFather.oProcExe.invokeTagetAction(id, typ);
					oStub.oFather.stopProcessExecution();
				}
			}));
			oDia.addButton(new sap.ui.commons.Button({
				text: 		oBundle.getText("BTN_NO_CLS_TXT"),
				tooltip: 	oBundle.getText("BTN_NO_CLS_TXT"),
				width: 		"100px",
				press: function() {
					oDia.close();
					oStub.oFather.getView().vExeCont.hideOrShowAllButtons(true);
				}
			}));
		}
		else {
			oDia.addButton(new sap.ui.commons.Button({
				text: 		oBundle.getText("BTN_CNF_TXT"),
				tooltip: 	oBundle.getText("BTN_CNF_TXT"),
				width: 		"75px",
				press: function() {
					oDia.close();
					oStub.oFather.oProcExe.invokeTagetAction(id, typ);
					oStub.oFather.stopProcessExecution();
				}
			}));
		}
		oDia.open();
	},
	
	/*
	 * While moving next - UI need to validate its parameter data etc.
	 */
	validateAndMoveNext: function() {
		var oFCntrl = oStub.oFather;
		var oUIProc = oFCntrl.oProcExe.oUIProc;
		var uiIdColl = [];
		var oValidator = new SLUISimpleUIRenderers(null, oFCntrl);
		var cConfigParams = oUIProc.configParams;
		var cDialogCollection = oUIProc.diaParamMap;
		for (var x = 0; x < cConfigParams.length; x++) {
			var param = cConfigParams[x];
			if (param) {
				var sUIId = cDialogCollection[param.getId()].uiId;
				if (sUIId) {
					uiIdColl.push(sUIId);
					if (sUIId.indexOf("_slui_txtInput_pswd_") > -1) {
						var cntrl = sap.ui.getCore().byId(sUIId);
						if (cntrl && $(cntrl).attr("refConfirmControlId")) {
							 var refId = $(cntrl).attr("refConfirmControlId").toString();
							 if (refId) {
								 uiIdColl.push(refId);
								 cntrl = sap.ui.getCore().byId(refId);
								 if (cntrl && cntrl.getValue().trim() == "") {
									 oValidator._setDirtyExecution(refId, true);
									 cntrl.setTooltip(new sap.ui.commons.RichTooltip({text: oBundle.getText("WRN_EMP_VAL_TXT")}));
									 cntrl.setValueState(sap.ui.core.ValueState.Error);
								 }								 
							 }
						}
					}
				}
			}
		}
		oValidator.checkDialogIsInDirtyState(uiIdColl);
		if (oFCntrl.oProcExe.oUIProc.diaInDrtyState) return true;
		else {
			//trigger new validation errors
			for (var x = 0; x < cConfigParams.length; x++) {
				var param = cConfigParams[x];
				var sUIId = cDialogCollection[param.getId()].uiId;
				oValidator.triggerClientSideValidation(sUIId, null, cDialogCollection[param.getId()].uiAttrMap);
				if (oUIProc.paramInDrtState[sUIId] == false) oValidator.triggerRegExpValidation(sUIId, null, cDialogCollection[param.getId()].uiAttrMap, "", sap.ui.getCore().byId(suiCnst.UI_ID_HOME_SCREEN).vExeWizd.uiRegex);
			}
			oValidator.checkDialogIsInDirtyState(uiIdColl);
			if (oFCntrl.oProcExe.oUIProc.diaInDrtyState) return true; 		// error exists
			else return false; 												// no error
		}
		return false; 														// no error
	},
	/*
	 * Handler on click of 'next' type button
	 */
	nextBtnPress: function(e) {
		if (oStub.oFather.getView().vExeCont.validateAndMoveNext()) oStub.oFather.moveToNextOfProcessExecution();
	},
	
	/*
	 * Handler on click of 'previous' type button
	 */
	preBtnPress: function(e) {
		oStub.oFather.moveTopreviousOfProcessExecution();
	},
	
	/*
	 * Handler of on click of 'cancel' type button
	 */
	cancelBtnPress: function(e) {
		oStub.oFather.getView().vExeCont.cancellation();
	}
});
