sap.ui.jsview(sluiCore.mod.jsprocLst, {
	procLstTbl: 		undefined,
	procExeBtn: 		undefined,
	slctIndx: 			0,
	dataModel: 			undefined,
	
	getControllerName: function() {
		return sluiCore.mod.jsprocLst;
	},
	
	supplyData: function(mod, int) {
		if (int) this.slctIndx = int;
		else this.slctIndx = -1;
		if (mod) this.dataModel.setData(mod);
		this.updateContent();
	},
	
	createContent: function(oController) {
		var sut = sap.ui.table;
		var suc = sap.ui.commons;
		var oFCntrl = oStub.oFather;
		// Process List table
		this.procLstTbl = new sut.Table("_slui_processListTable");
		this.procLstTbl.setSelectionMode(sut.SelectionMode.Single);
		// Tool bar for the process List
		this.procExeBtn = new suc.Button("_slui_toolBarButton");
		this.procExeBtn.setText(oBundle.getText("BTN_STRT_TXT"));
		this.procExeBtn.setEnabled(false);
		this.procLstTbl.setVisibleRowCount(15);
		this.procExeBtn.attachPress(this.executeBtnPress);
		// Execute Button
		var oTBar = new suc.Toolbar("_slui_toolBar");
		oTBar.setDesign(suc.ToolbarDesign.Flat);
		oTBar.addItem(this.procExeBtn);
		this.procLstTbl.setToolbar(oTBar);
		this.procLstTbl.attachRowSelectionChange(this.selectionEvent);
		var oTxtVw = new suc.TextView({text: oBundle.getText("DISP_NME_LBL_TXT")});
		this.procLstTbl.addColumn(new sut.Column({	label: 			new suc.Label({text: oBundle.getText("PRO_LBL_TXT")}),
													template: 		oTxtVw,
													sortProperty: 	"displayName",
													filterProperty:	"displayName",
													width: 			"100%",													}));
		this.procLstTbl.setModel(oFCntrl.oProcRepo.cProcLst);
		this.procLstTbl.bindRows("/Process");
		return this.procLstTbl;
	},
	
	modifyViewContents: function(modifyType) {
		if (modifyType == 1) this.updateContent();
	},
	
	updateModel: function(oModel) {
		if (oModel) this.dataModel.setData(oModel);
		this.updateContent();
	},
	
	updateContent: function() {
		if (oStub.oFather.oProcRepo.cProcLst) {
			this.procExeBtn.setEnabled(true);
			this.procLstTbl.setSelectedIndex(this._data.slctIndx);
		} 
	},
	
	executeBtnPress: function() {
		oStub.oFather.startProcessExecution();
	},
	
	selectionEvent: function(oEvent) {
		oStub.oFather.oProcRepo.leadProcId = oStub.oFather.oProcRepo.cProcLst.getProperty("id", oEvent.getParameter("rowContext"));
	}
});
