//slui.modules.renderers.
sap.ui.jsview(sluiCore.mod.jsproTLst, {
	oFCntrl: undefined,
	subVws: {	_processListTable: 		undefined,
				_processExecuteBtn: 	undefined	},
	data: {		_selectedIndex: 		0			},
	
	getControllerName: function() {
		return "";
	},
	
	supplyData: function(dataModel, sIndex) {
		if (sIndex) this.data._selectedIndex = sIndex;
		else this.data._selectedIndex = -1;
		if (dataModel) this.data._dataModel.setData(dataModel);
		this.updateContent();
	},
	
	createContent: function(oController) {
		oFCntrl = sap.ui.getCore().byId(suiCnst.UI_ID_HOME_SCREEN).getController();
		// Process List table
		this.subVws._processListTable = new sap.ui.table.TreeTable("_slui_processListTable");
		this.subVws._processListTable.setSelectionMode(sap.ui.table.SelectionMode.Single);
		// Tool bar for the process List
		this.subVws._processExecuteBtn = new sap.ui.commons.Button("_slui_toolBarButton");
		this.subVws._processExecuteBtn.setText(oBundle.getText("BTN_STRT_TXT"));
		this.subVws._processExecuteBtn.setEnabled(false);
		this.subVws._processListTable.setVisibleRowCount(15);
		this.subVws._processExecuteBtn.attachPress(this.executeBtnPress);
		// Execute Button
		var oToolBar = new sap.ui.commons.Toolbar("_slui_toolBar");
		oToolBar.setDesign(sap.ui.commons.ToolbarDesign.Flat);
		oToolBar.addItem(this.subVws._processExecuteBtn);
		this.subVws._processListTable.setToolbar(oToolBar);
		this.subVws._processListTable.attachRowSelectionChange(this.selectionEvent);
		var oControl = new sap.ui.commons.TextView({text: oBundle.getText("DISP_NME_LBL_TXT")});
		this.subVws._processListTable.addColumn(new sap.ui.table.Column({
			label: 				new sap.ui.commons.Label({text: oBundle.getText("PRO_LBL_TXT")}),
			template: 			oControl,
			sortProperty: 		"displayName",
			filterProperty: 	"displayName",
			width: 				"100%",
		}));
		this.subVws._processListTable.setModel(oFCntrl.comps.oProcRepo.prProps.repoData.cProcLst);
		this.subVws._processListTable.bindRows("/ProcessDefinitions");
		return this.subVws._processListTable;
	},
	
	modifyViewContents: function(modifyType) {
		if (modifyType === 1) this.updateContent();
	},
	
	updateModel: function(oModel) {
		if (oModel) this.data._dataModel.setData(oModel);
		this.updateContent();
	},
	
	updateContent: function() {
		if (oFCntrl.comps.oProcRepo.prProps.leadProcId) this.subVws._processExecuteBtn.setEnabled(true);
		else this.subVws._processExecuteBtn.setEnabled(false);
	},
	
	executeBtnPress: function() {
		oFCntrl.startProcessExecution();
	},
	
	selectionEvent: function(oEvent) {
		var selectedRowContext = oEvent.getParameter("rowContext");
		var selectedClientId = oFCntrl.comps.oProcRepo.prProps.repoData.cProcLst.getProperty("id", selectedRowContext);
		if (selectedClientId) {
			sap.ui.getCore().byId('_slui_toolBarButton').setEnabled(true);
			oFCntrl.comps.oProcRepo.prProps.leadProcId = selectedClientId;
		} 
		else sap.ui.getCore().byId('_slui_toolBarButton').setEnabled(false);
	}
});
