sap.ui.jsview(sluiCore.mod.jsexeStat, {
	progRdMap: 		undefined,
	progBrVw: 		undefined,
	progMsg: 		undefined,
	progVal: 		undefined,
	sysMsg: 		undefined,
	sid: 			undefined,
	roadMaps: 		undefined,
	stepCount: 		0,
	rdMpTask: 		undefined,
	procTask: 		undefined,
	test: 			0,
	
	createContent: function(oController) {
		var suc = sap.ui.commons;
		var oLyt = new suc.layout.VerticalLayout({width: "100%"});
		this.progRdMap = new suc.RoadMap('_slui_executionRoadMap', {width: '100%'});
		this.progBrVw = new suc.ProgressIndicator('_slui_executionProgress', {width: "450px"});
		this.progRdMap.setNumberOfVisibleSteps(15);
		this.progMsg = new suc.TextView('_slui_executionProgressMsgLabel', {	width: 		"100%",
																				design: 	suc.TextViewDesign.H5,
																				wrapping: 	false					});
		this.progVal = new suc.TextView('_slui_executionProgressValue', {		width: 		"52px",
																				design: 	suc.TextViewDesign.H2,
																				wrapping: 	false					});
		
		this.progVal.addStyleClass("statusValueText");		
		this.sysMsg = new suc.TextView('_slui_executionSID', {					width: 		"100%",
																				design: 	suc.TextViewDesign.H4,
																				wrapping: 	false					});
		// look for URL and updated SID.
		if (window.location && window.location.href) {
			var url = window.location.href;
			url = url.substring(url.indexOf("lmsl"), url.length);
			url = url.replace("lmsl/SUM/", "");
			url = url.substring(0, url.indexOf("/"));
		}
		var oVLayout = new suc.layout.VerticalLayout({width: "100%"});
		var emptyHTML = new sap.ui.core.HTML({	content: 			"<div style=\"height:6px\"></div>",
												sanitizeContent: 	true									});
		oVLayout.addContent(emptyHTML);
		oVLayout.addContent(this.progBrVw);
		var oHlayout = new suc.layout.HorizontalLayout('_slui_progressValDisplay', {	width: 		"100%",
																						content: 	[this.progVal, oVLayout]	});
		oLyt.addContent(this.progRdMap);
		oLyt.addContent(oHlayout);
		oLyt.addContent(this.progMsg);
		return oLyt;
	},
	
	modifyViewContents: function(modifyType) {
		if (modifyType === 1) this.updateContent();
	},
	
	updateContent: function() {
		var oUIProc = oStub.oFather.oProcExe.oUIProc;
		var frstRdMp = false;
		if (oUIProc) {
			//identify process task and road map task
			var enableBucketIcon = false;
			for (var x = 0; x < oUIProc.curMonTskLst.length; x++) {
				if (oUIProc.curMonTskLst[x].getType() === suiCnst.SLP_TASK_TYPE_PROCESS) {
					this.procTask = oUIProc.curMonTskLst[x];
					oUIProc.sState = this.procTask.getStatus();
					oUIProc.sError = this.procTask.getError();
				} else if (oUIProc.curMonTskLst[x].getType() === suiCnst.SLP_TASK_TYPE_SUBSTEP) 
					enableBucketIcon = (oUIProc.curMonTskLst[x].getStatus() === suiCnst.SLP_TASK_STATUS_ACTION_REQUIRED); 
				else if (((oUIProc.curMonTskLst[x].getType() === suiCnst.SLP_TASK_TYPE_TECH_ROADMAP) || (oUIProc.curMonTskLst[x].getType() === suiCnst.SLP_TASK_TYPE_USER_ROADMAP)) && !frstRdMp) {
					frstRdMp = true;
					this.rdMpTask = oUIProc.curMonTskLst[x];
				}
			}
			showBucketIcon(enableBucketIcon);
			frstRdMp = false;
			//update entire collection of road map status from monitor road map task
			if (this.rdMpTask) {
				for (var x = 0; x < oUIProc.roadMaps.length; x++) {
					if (oUIProc.roadMaps[x].getId() == this.rdMpTask.getId()) oUIProc.roadMaps[x].setStatus(this.rdMpTask.getStatus());
					else oUIProc.roadMaps[x].setStatus(suiCnst.SLP_TASK_STATUS_INITIAL);
				}
			}
			oUIProc.roadMapTask = this.rdMpTask;
			oUIProc.processTask = this.procTask;			
			//check for road map step assignment 
			//update individual UI elements
			this._updateRoadMaps(oUIProc);
			this._updateprogressBar(oUIProc);
			this._updateErrorPopup(oUIProc);
			this.launchFeedbackFormDialog(oUIProc);
		}
	},
	
	_updateRoadMaps: function(oUIProc) {
		var tRdmp = sap.ui.getCore().byId('_slui_executionRoadMap');
		if (oUIProc.roadMaps && oUIProc.roadMaps.length > 0) {
			// tRdmp.destroySteps();
			if (tRdmp) {
				tRdmp.setVisible(true);
				if (tRdmp && tRdmp.getSteps().length < 1) $.each(oUIProc.roadMaps, function(ind, tsk) {
						var tMap = new sap.ui.commons.RoadMapStep('_slui_roadmap_step_' + tsk.getId(), {	label: 		tsk.getName(),
																											tooltip: 	tsk.getName()  });
						tRdmp.addStep(tMap);
						if (oStub.oFather.oUtil.checkMonitorState(tsk.getStatus(), 4)) {
							tRdmp.setSelectedStep('_slui_roadmap_step_' + tsk.getId());
							sap.ui.getCore().byId('_slui_roadmap_step_' + tsk.getId()).setEnabled(true);
						}
						else sap.ui.getCore().byId('_slui_roadmap_step_' + tsk.getId()).setEnabled(false);
					});
				else $.each(oUIProc.roadMaps, function (ind, tsk) {
						if (oStub.oFather.oUtil.checkMonitorState(tsk.getStatus(), 4)) {
							tRdmp.setSelectedStep('_slui_roadmap_step_' + tsk.getId());
							sap.ui.getCore().byId('_slui_roadmap_step_' + tsk.getId()).setEnabled(true);
						} 
						else sap.ui.getCore().byId('_slui_roadmap_step_' + tsk.getId()).setEnabled(false);
					});
			}
		} 
		else if (tRdmp) tRdmp.setVisible(false);
	},
	
	_updateprogressBar: function(oUIProc) {
		if (oUIProc.curMonTskLst) {
			var sapCore = sap.ui.getCore();
			var sucr = sap.ui.core;
			var suc = sap.ui.commons;
			var tProcTask;
			var tPgBar = sapCore.byId('_slui_executionProgress');
			var tPgBarLbl = sapCore.byId('_slui_executionProgressMsgLabel');
			var tPgBarVal = sapCore.byId('_slui_executionProgressValue');
			var lngth = oUIProc.curMonTskLst.length;
			if (tPgBar) {
				//check for monitor resource config resource 
				if (oStub.oFather.execVwProps["useRoadMapTaskForProgress"] === true) tProcTask = this.rdMpTask;
				else tProcTask = this.procTask;
				//set progress bar width
				var map = sap.ui.getCore().byId('_slui_executionRoadMap');
				if (map && map.getSteps().length > 0) tPgBar.setWidth(((map.getSteps().length * 98) - 30) + "px");
				//manipulate status and progress value 
				if (tProcTask && lngth > 0) {
					if (tProcTask.getType() && ((tProcTask.getType() === suiCnst.SLP_TASK_TYPE_PROCESS) || (tProcTask.getType() === suiCnst.SLP_TASK_TYPE_TECH_ROADMAP))) {
						var iProgressValue = tProcTask.getProgress();
						var stus = tProcTask.getStatus();					
						if (stus) {
							if (stus === suiCnst.SLP_TASK_STATUS_INITIAL) {
								tPgBar.setBarColor(sucr.BarColor.NEUTRAL);
								tPgBarVal.setSemanticColor(suc.TextViewColor.Default);
							} else if (stus === suiCnst.SLP_TASK_STATUS_RUNNING) {
								tPgBar.setBarColor(sucr.BarColor.NEUTRAL);
								tPgBarVal.setSemanticColor(suc.TextViewColor.Neutral);
							} else if (stus === suiCnst.SLP_TASK_STATUS_DIALOG) {
								tPgBar.setBarColor(sucr.BarColor.CRITICAL);
								tPgBarVal.setSemanticColor(suc.TextViewColor.Critical);
							} else if (stus === suiCnst.SLP_TASK_STATUS_ERROR) {
								tPgBar.setBarColor(sucr.BarColor.NEGATIVE);
								tPgBarVal.setSemanticColor(suc.TextViewColor.Negative);
							} else if (stus === suiCnst.SLP_TASK_STATUS_FINISHED) {
								tPgBar.setBarColor(sucr.BarColor.POSITIVE);
								tPgBarVal.setSemanticColor(suc.TextViewColor.Positive);
							} else if (stus === suiCnst.SLP_TASK_STATUS_SKIPPED) {
								tPgBar.setBarColor(sucr.BarColor.CRITICAL);
								tPgBarVal.setSemanticColor(suc.TextViewColor.Critical);
							} else if (stus === suiCnst.SLP_TASK_STATUS_ABORTED) {
								tPgBar.setBarColor(sucr.BarColor.NEGATIVE);
								tPgBarVal.setSemanticColor(suc.TextViewColor.Negative);
							} else if (stus === suiCnst.SLP_TASK_STATUS_ACTION_REQUIRED) {
								tPgBar.setBarColor(sucr.BarColor.CRITICAL);
								tPgBarVal.setSemanticColor(suc.TextViewColor.Critical);
							} else if (stus === suiCnst.SLP_TASK_STATUS_BREAKPOINT) {
								tPgBar.setBarColor(sucr.BarColor.CRITICAL);
								tPgBarVal.setSemanticColor(suc.TextViewColor.Critical);
							} else {
								tPgBar.setBarColor(sucr.BarColor.NEUTRAL);
								tPgBarVal.setSemanticColor(suc.TextViewColor.Neutral);
							}
							var oTooltipText = (new sap.ui.commons.Label({text: oPSEViewHelper.generateStatusTooltip(stus)})).addStyleClass("tooltipText");
						    var oIcon = new sap.ui.core.Icon( {  
						        src: 					oPSEViewHelper.generateStatusIcon(stus),  
						        size: 					"15px",  
						        color: 					oPSEViewHelper.generateStatusIconColor(stus),
						        activeColor: 			"white",  
						        activeBackgroundColor: 	"transparent", 
						        width: 					"15px"
						    });
							tPgBar.setTooltip(new suc.Callout({content: [oIcon, oTooltipText]}));							
							tPgBar.setDisplayValue(oPSEViewHelper.generateStatusTooltip(stus));
						} else {
							tPgBar.setBarColor(sucr.BarColor.NEUTRAL);
							tPgBarVal.setSemanticColor(suc.TextViewColor.Neutral);
						}
						tPgBarVal.setText(parseInt(iProgressValue, 10) + "%");
						tPgBarVal.setTooltip(oBundle.getText("PROG_LBL_TXT") + " " + parseInt(iProgressValue, 10));
						tPgBar.setPercentValue(parseInt(iProgressValue, 10));
						tPgBarVal.setVisible(true);
						tPgBar.setVisible(true);
						tPgBarLbl.setVisible(true);
						var curPhase = $($(tProcTask.baseModel.getModel().getXML()).find("progressMessages")[0]).find("message").text();
						if (curPhase === "SUM ABAP process started") curPhase = "Software Update Manager";
						tPgBarLbl.setText(curPhase);
					}
				} else {
					tPgBarLbl.setVisible(false);
					tPgBar.setVisible(false);
					tPgBarVal.setVisible(false);
					tPgBarLbl.setText(oBundle.getText("LOAD_INFO_LBL_TXT"));
				}
			}
		}
	},
        
	checkFileExists: function(url) {
		var httpRequest = new XMLHttpRequest();
		httpRequest.open('GET', url, false);
		httpRequest.send();
		if (httpRequest.status == 404) return false;
		else return true;
	},

	launchFeedbackFormDialog : function() {
		if (this.procTask) {
			var iProgressValue = this.procTask.getProgress();
			var stus = this.procTask.getStatus();	
			if (stus && (stus === suiCnst.SLP_TASK_STATUS_FINISHED) && (iProgressValue == 100) && this.checkFileExists(oStub.oFather.globProps["feedbackURL"])) {
//				big problem when UI starting when SAPup is in FINISHED state			    
//				oStub.oFather.oProcExe.stopMonitoring();
				oStub.oFather.oProcExe.oUIProc.sState = suiCnst.SLP_TASK_STATUS_FINISHED;
				// throw feedback form 
				if ((!oStub.oFather.oProcExe.isFeedbackDisplayed) && oStub.oFather.globProps["feedbackURL"] != "") {
					var feedbackURL = oStub.oFather.globProps["feedbackURL"];
					new SLUIDialogProvider().getFeedbackDialog(oBundle.getText("DIA_HDR_FEEDBACK"), feedbackURL).open();
					//ACC FIX
					if (navigator.userAgent.toLowerCase().indexOf('chrome') < 0) $( "#feedbackDialog-cont" ).css( "height", "600px" );
					else $( "#feedbackDialog-cont" ).css( "height", "600px" );
					oStub.oFather.oProcExe.isFeedbackDisplayed = true;
				}
				oStub.oFather.oProcExe.getSLPMonitorWithTimer();
			}		
		}
	},
	
	_updateErrorPopup: function(oUIProc) {
		if (oUIProc && (oUIProc.errElm.length > 0)) {
			var oDia = new SLUIDialogProvider().getSLPErrorDialog(oBundle.getText("DIA_HDR_ERR_STP_TXT") + " " + this.procTask.getName(), oUIProc.errElm[0]);
			for (var x = 0; x < oUIProc.actions.length; x++) {
				var atn = oUIProc.actions[x];
				if (atn) {
					oDia.addButton(new sap.ui.commons.Button("_slui_dia_actn_btn_" + atn.getId() + "_btntpe_" + atn.getType(), {
						text: atn.getName(),
						press: function() {
							var id = this.sId;
							var typ;
							if (id.indexOf("_btntpe_") > -1) {
								var fnd = id.indexOf("_btntpe_");
								typ = id.substr(fnd, id.length);
								id = id.substr(0, fnd);
							}
							if (id.indexOf("_slui_dia_actn_btn_") > -1) id = id.replace("_slui_dia_actn_btn_", "");
							if (typ.indexOf("_btntpe_") > -1) typ = typ.replace("_btntpe_", "");
							oStub.oFather.oProcExe.invokeTagetAction(id, typ);
							oDia.destroyContent();
							oDia.destroyButtons();
							oDia.close();
						}
					}));
				}
			}
			oDia.open();
		}
	}
});

var oPSEViewHelper = {
	generateStatusTooltip: function(oValue) {
		var imgSrc = oBundle.getText("PRC_LBL_NO_DES_TXT");
		switch (oValue) {
		case suiCnst.SLP_TASK_STATUS_ABORTED:
			imgSrc = oBundle.getText("PRC_LBL_ABRT_TXT");
			break;
		case suiCnst.SLP_TASK_STATUS_FINISHED:
			imgSrc = oBundle.getText("PRC_LBL_FIN_TXT");
			break;
		case suiCnst.SLP_TASK_STATUS_SKIPPED:
			imgSrc = oBundle.getText("PRC_LBL_SKI_TXT");
			break;
		case suiCnst.SLP_TASK_STATUS_ERROR:
			imgSrc = oBundle.getText("PRC_LBL_ERR_TXT");
			break;
		case suiCnst.SLP_TASK_STATUS_RUNNING:
			imgSrc = oBundle.getText("PRC_LBL_RUN_TXT");
			break;
		case suiCnst.SLP_TASK_STATUS_DIALOG:
			imgSrc = oBundle.getText("PRC_LBL_DIA_TXT");
			break;
		case suiCnst.SLP_TASK_STATUS_ACTION_REQUIRED:
			imgSrc = oBundle.getText("PRC_LBL_ACN_TXT");
			break;
		case suiCnst.SLP_TASK_STATUS_BREAKPOINT:
			imgSrc = oBundle.getText("PRC_LBL_BRK_TXT");
			break;
		case suiCnst.SLP_TASK_STATUS_INITIAL:
			imgSrc = oBundle.getText("PRC_LBL_INI_TXT");
			break;
		default:
			imgSrc = oBundle.getText("PRC_LBL_INI_TXT");
			break;
		}
		return imgSrc;
	},

	generateStatusIcon: function(oValue) {
		var iconSrc = "sap-icon://";
		switch (oValue) {
		case suiCnst.SLP_TASK_STATUS_ABORTED:
			iconSrc = iconSrc + "sys-cancel";
			break;
		case suiCnst.SLP_TASK_STATUS_FINISHED:
			iconSrc = iconSrc + "status-completed";
			break;
		case suiCnst.SLP_TASK_STATUS_SKIPPED:
			iconSrc = iconSrc + "overlay";
			break;
		case suiCnst.SLP_TASK_STATUS_ERROR:
			iconSrc = iconSrc + "message-error";
			break;
		case suiCnst.SLP_TASK_STATUS_RUNNING:
			iconSrc = iconSrc + "media-play";
			break;
		case suiCnst.SLP_TASK_STATUS_DIALOG:
			iconSrc = iconSrc + "status-inactive";
			break;
		case suiCnst.SLP_TASK_STATUS_ACTION_REQUIRED:
			iconSrc = iconSrc + "to-be-reviewed";
			break;
		case suiCnst.SLP_TASK_STATUS_BREAKPOINT:
			iconSrc = iconSrc + "navigation-right-arrow";
			break;
		case suiCnst.SLP_TASK_STATUS_INITIAL:
			iconSrc = iconSrc + "status-negative";
			break;
		default:
			iconSrc = iconSrc + "status-negative";
			break;
		}
		return iconSrc;
	},
	
	generateStatusIconColor: function(oValue) {
		var iconColor = "#000000";
		switch (oValue) {
		case suiCnst.SLP_TASK_STATUS_ABORTED:
			iconColor = "#cc0000";
			break;
		case suiCnst.SLP_TASK_STATUS_FINISHED:
			iconColor = "#008b00";
			break;
		case suiCnst.SLP_TASK_STATUS_SKIPPED:
			iconColor = "#007dc0";
			break;
		case suiCnst.SLP_TASK_STATUS_ERROR:
			iconColor = "#cc0000";
			break;
		case suiCnst.SLP_TASK_STATUS_RUNNING:
			iconColor = "#007dc0";
			break;
		case suiCnst.SLP_TASK_STATUS_DIALOG:
			iconColor = "#fdc411";
			break;
		case suiCnst.SLP_TASK_STATUS_ACTION_REQUIRED:
			iconColor = "#007dc0";
			break;
		case suiCnst.SLP_TASK_STATUS_BREAKPOINT:
			iconColor = "#fdc411";
			break;
		case suiCnst.SLP_TASK_STATUS_INITIAL:
			iconColor = "#8F8F8F";
			break;
		default:
			iconColor = "#8F8F8F";
			break;
		}
		return iconColor;
	}
};