sap.ui.jsview(sluiCore.mod.jsstepLst, {
    iCurrStpPos: 				-1,
    processStepListContainer: 	undefined,
    stepListTable: 				undefined,
    stepListBox: 				undefined,
    tskLst: 					undefined,
    visibleRow: 				-12,
    autoScroll: 				true,
    firstVisibleRow: 			-1,
    dataRetrived: 				false,
    noRoadmapData: 				undefined,
    
    supplyData: function() {
    	this.updateContent();
    },
    
    createContent: function(oController) {
        this.processStepListContainer = new sap.ui.commons.layout.VerticalLayout({width: "100%"});
        this.createTaskListTable();
        return this.processStepListContainer;
    },
    
    updateContent: function(updateModel, retrieveData) {
    	if (updateModel || !this.stepListTable.getModel('TaskList'))
    		if (oStub.oFather.execVwProps.taskListFromJson) {
    			if (globals.abapTasklistModel) {
    				this.stepListTable.setModel(globals.abapTasklistModel, 'TaskList');
    				if (!this.stepListTable.getBinding()) this.stepListTable.bindRows("TaskList>/tasklist/Task");
    				this.stepListTable.getModel('TaskList').refresh();
    			}
    		} else {
    			if (oStub.oFather.oProcExe.oUIProc && oStub.oFather.oProcExe.oUIProc.tskLst) {
    				this.stepListTable.setModel(oStub.oFather.oProcExe.oUIProc.tskLst, 'TaskList');
    				if (!this.stepListTable.getBinding()) this.stepListTable.bindRows("TaskList>/Task");
    				this.stepListTable.getModel('TaskList').refresh();
    			}
    		}         
    	if (    		oStub.oFather.execVwProps["showRoadMapBasedTaskList"] 
    				&& oStub.oFather.oProcExe.oUIProc && oStub.oFather.oProcExe.oUIProc.roadMapTask 
    				&& this.stepListTable.getModel('TaskList') 
    				&& this.stepListTable.getModel('TaskList').getData().tasklist     
    				&& (this.stepListTable.getModel('TaskList').getData().tasklist != "")     
    				&& this.stepListTable.getModel('TaskList').getData().tasklist.Task.length			) {
    		var taskIdAct = oStub.oFather.oProcExe.oUIProc.roadMapTask.getId();
    		var taskIdList = (this.stepListTable.getModel('TaskList').getMetadata().getName().indexOf("JSON") > -1) ? this.stepListTable.getModel('TaskList').getData().tasklist.Task[0].technicalName : $(this.stepListTable.getModel('TaskList').getData()).find("Task").get(0).getElementsByTagName(suiCnst.SLP_TASK_TECH_NAME)[0].textContent;
    		if (taskIdAct != taskIdList) {retrieveData = true; updateModel = true; oStub.oFather.getView().vExeStpList.autoScroll = true; }
    	}
    	if (retrieveData) { 
    		if (oStub.oFather.execVwProps["showRoadMapBasedTaskList"] === true) { 
    			if (oStub.oFather.oProcExe.oUIProc.roadMapTask) {
    				var taskId = oStub.oFather.oProcExe.oUIProc.roadMapTask.getId();
    				if (taskId) oStub.oFather.oProcExe.getSLPTaskListByRoadMap(taskId);
    			}
    		} 
    		else oStub.oFather.oProcExe.getSLPTaskList();
    		return;
    	}
    	if (!$(this.stepListTable)[0].bOutput) return;  // just leave in case Tasklist has not yet been displayed - nothing to do 	
    	//calculate table visible row depends on document
    	this.resizeTableHeightForVerticalScroll();
		this.stepListTable.rerender();
    	if (oStub.oFather.globProps["enablePhasesLogViewer"] === true) {				//open log viewer upon click on step in phase list
    		$("td[id$='-col2']").each(function(){$(this).css("cursor", "pointer");});
    		this.stepListTable.fireCellClick = function(p) {
    			if (p.cellControl.mBindingInfos.text) {
    				var step = p.cellControl.mBindingInfos.text.binding.oValue;
    				var file = p.cellControl.mBindingInfos.text.binding.oContext.getProperty("logs");
    				$.ajax({
    					type: 		"GET",
    					url: 		"../log/" + encodeURIComponent(file),
    					dataType: 	'text',
    					cache: 		false,
    					success: function(response) {
    						var oDialog1 = new sap.ui.commons.Dialog({modal: true});
    						oDialog1.setTitle("Step: " + step + " / Log: " + file);
    						oDialog1.setWidth("800px");
    						oDialog1.setHeight("600px");
    						oDialog1.setMinWidth("500px");
    						oDialog1.setMinHeight("300px");
    						var oTextView = new sap.ui.commons.TextView({text: response});
    						oTextView.setDesign(sap.ui.commons.TextViewDesign.Monospace);
    						oTextView.setTooltip("Logfile content...");
    						oDialog1.addContent(oTextView);
    						var oBtnOk = new sap.ui.commons.Button({text: "Close", press: closeDialog});
    						oDialog1.addButton(oBtnOk);
    						oDialog1.open();
    					},
    					error: function(xhr, options, errorText) {
    						sap.m.MessageBox.error("Log file "+file+" does not yet exist.");
    					}
    				});
    			}
    		};
    	}  
    },
    
    createTaskListTable: function() {
        var suc = sap.ui.commons;
        var sut = sap.ui.table;
        var oNoDataLbl = new suc.Label("_slui_lbl_taskList_loading", {text: oBundle.getText("TSK_LOAD_LBL_TXT")});
        oNoDataLbl.addStyleClass("displayNoDataLabelInCenter");
        this.stepListTable = new sut.Table("_slui_table_taskList", {noData: oNoDataLbl});
        var oTxtVw1 = new suc.TextView("sluilbltaskListdescription", {width: "100%"});
        oTxtVw1.bindProperty(suiCnst.UI5_ATTR_TEXT, "TaskList>"+suiCnst.SLP_TASK_DISP_NAME);
        var tasklistTooltip = new suc.RichTooltip({});
        oTxtVw1.setTooltip(tasklistTooltip);
        tasklistTooltip.bindProperty(suiCnst.UI5_ATTR_TEXT, "TaskList>"+suiCnst.SLP_TASK_DISP_NAME, function(oValue) {return oViewHelper.generateNameTooltip(oValue);});
        var oColumn2 = new sut.Column('slui_column_taskListDisplayName', {
            label: 		new suc.Label({text: oBundle.getText("TBL_CLMN_HDR_DEC_TXT")}),
            template: 	oTxtVw1,
            width: 		"100%"
        });
        var oStatusIcon = new sap.ui.core.Icon({
            size: 					"15px",
            activeColor: 			"white",
            activeBackgroundColor: 	"transparent",
			decorative: 			false,											//SUM_DMO_SAPUI5_ACC_SP19_ACC-264             
            width: 					"15px"
        });
        oStatusIcon.bindProperty(suiCnst.UI5_ATTR_ISRC, "TaskList>"+suiCnst.SLP_TASK_STATUS, function(oValue) {return oViewHelper.generateStatusIcon(oValue);});
        oStatusIcon.bindProperty(suiCnst.UI5_ATTR_COLOR, "TaskList>"+suiCnst.SLP_TASK_STATUS, function(oValue) {return oViewHelper.generateStatusIconColor(oValue);});
        oStatusIcon.bindProperty(suiCnst.UI5_ATTR_TTIP, "TaskList>"+suiCnst.SLP_TASK_STATUS, function(oValue) {return oViewHelper.generateStatusTooltip(oValue);});
        oStatusIcon.bindProperty(suiCnst.UI5_ATTR_ALT, "TaskList>"+suiCnst.SLP_TASK_STATUS, function(oValue) {return oViewHelper.generateStatusTooltip(oValue);});		//SUM_DMO_SAPUI5_ACC_SP19_ACC-264
        var oColumn1 = new sut.Column('slui_column_taskListStatusImg', {
            label: 		new suc.Label({text: oBundle.getText("TBL_CLMN_HDR_STS_TXT")}),
            template: 	oStatusIcon,
            width: 		"60px",
            hAlign: 	"Center"
        });
        var oImg2 = new suc.Image({decorative: false});
        oImg2.bindProperty(suiCnst.UI5_ATTR_ISRC, "TaskList>"+suiCnst.SLP_TASK_TYPE, function(oValue) {return oViewHelper.generateTypeImage(oValue);});
        oImg2.bindProperty(suiCnst.UI5_ATTR_TTIP, "TaskList>"+suiCnst.SLP_TASK_TYPE, function(oValue) {return oViewHelper.generateTypeTooltip(oValue);});
        oImg2.bindProperty(suiCnst.UI5_ATTR_ALT, "TaskList>"+suiCnst.SLP_TASK_TYPE, function(oValue) {return oViewHelper.generateTypeTooltip(oValue);});				//SUM_DMO_SAPUI5_ACC_SP19_ACC-264
        var oColumn0 = new sut.Column('slui_column_taskType', {
            label: 		new suc.Label({text: oBundle.getText("TBL_CLMN_HDR_TYP_TXT")}),
            template: 	oImg2,
            width: 		"90px",
            hAlign: 	"Center"
        });
        this.stepListTable.addColumn(oColumn0);
        this.stepListTable.addColumn(oColumn1);
        this.stepListTable.addColumn(oColumn2);
        this.stepListTable.setSelectionMode(sut.SelectionMode.None);
        this.stepListTable.setVisibleRowCount(15);
        this.stepListTable.setEnableColumnReordering(false);
        this.stepListTable.setShowNoData(true);
        this.stepListTable.setColumnHeaderVisible(true);
        this.stepListTable.setToolbar(new suc.Toolbar({
            rightItems: [(new suc.Button("_slui_tbl_tasklist_tbar_refresh_btn", {
                    icon: 		"sap-icon://refresh",
                    text: 		oBundle.getText("BTN_REF_TXT"),
                    tooltip: 	oBundle.getText("REF_TSK_TIP_TXT"),
                    press: function() { 
                    	oStub.oFather.getView().vExeStpList.updateContent(true, true);
                    	oStub.oFather.getView().vExeStpList.autoScroll = true;
                    } 
            })).addStyleClass("refBtnIcon")]
        }));
        this.processStepListContainer.addContent(this.stepListTable);
        this.stepListTable.addEventDelegate({
			onAfterRendering: function() {
	    		var idx = -1;
	    		var oUIProc = oStub.oFather.oProcExe.oUIProc;
	    		if (this.getModel('TaskList')) {
	    			$("#"+this.getId()+"-vsb").scroll($.proxy(function() {
	    				if (oStub.oFather.getView().vExeStpList.firstVisibleRow != this.getFirstVisibleRow()) {
	    					oStub.oFather.getView().vExeStpList.firstVisibleRow = this.getFirstVisibleRow();  
	    					oStub.oFather.getView().vExeStpList.autoScroll = false;
	    				}
	    			}, this));
	    			var objLst = $(this.getModel('TaskList').getData()).find("Task").get();
	    			if (this.getModel('TaskList').getMetadata().getName().indexOf("JSON") > -1) objLst = this.getModel('TaskList').getData().tasklist.Task;
	    			if (objLst && (objLst.length > 1) && oUIProc.curMonTskLst && (oUIProc.curMonTskLst.length > 1)) {
	    				oStub.oFather.getView().vExeStpList.iCurrStpPos = -1;
	    				var stepTaskID;
	    				var roadMapId;
	    				var isRoadMapRef = false;
	    				// identify the Id step Id and a road map type task
	    				for (var x = 0; x < oUIProc.curMonTskLst.length; x++) {
	    					var objTask = oUIProc.curMonTskLst[x];
	    					if (objTask.getType() === suiCnst.SLP_TASK_TYPE_STEP) stepTaskID = objTask.getId();
	    					else if (objTask.getType() === suiCnst.SLP_TASK_TYPE_TECH_ROADMAP) roadMapId = objTask.getId();
	    				}                    
	    				//if Step ID is empty in monitor resource
	    				if (stepTaskID === undefined) isRoadMapRef = true;
	    				//identify step or roadmap  position in the entire tasklist 
	    				for (var t = 0; t < objLst.length; t++) {
	    					var tsk = objLst[t];
	    					var tskId;
	    					var tskType;
	    					if (tsk) {
	    						if (this.getModel('TaskList').getMetadata().getName().indexOf("JSON") > -1) {
	    							tskId = objLst[t].id;
	    							tskType = objLst[t].type;
	    						} else {
	    							tskId = tsk.getElementsByTagName(suiCnst.SLP_COMMON_ID)[0].textContent;
	    							tskType = tsk.getElementsByTagName(suiCnst.SLP_TASK_TYPE)[0].textContent;                        	
	    						}
	    						if (oStub.oFather.getView().vExeStpList.iCurrStpPos < 0) {
	    							if (isRoadMapRef) {
	    								if (tskId === roadMapId && tskType === suiCnst.SLP_TASK_TYPE_TECH_ROADMAP) {
	    									oStub.oFather.getView().vExeStpList.iCurrStpPos = t;
	    									break;
	    								}
	    							} else if (((tskId === stepTaskID) || ((tskId.split(stepTaskID).length > 1) && (tskId.split(stepTaskID)[1] === ""))) && (tskType === suiCnst.SLP_TASK_TYPE_STEP)) {
	    								oStub.oFather.getView().vExeStpList.iCurrStpPos = t;
	    								break;
	    							}
	    						}
	    					}
	    				}
	    				//when the step id hit is empty
	    				if ((oStub.oFather.getView().vExeStpList.iCurrStpPos < 0) && !isRoadMapRef) {
	    					isRoadMapRef = true;
	    					for (var t = 0; t < objLst.length; t++) {
	    						var tsk = objLst[t];
	    						if (tsk) {
	    							if (this.getModel('TaskList').getMetadata().getName().indexOf("JSON") > -1) {
	    								tskId = objLst[t].id;
	    								tskType = objLst[t].type;
	    							} else {
	    								tskId = tsk.getElementsByTagName(suiCnst.SLP_COMMON_ID)[0].textContent;
	    								tskType = tsk.getElementsByTagName(suiCnst.SLP_TASK_TYPE)[0].textContent;                        	
	    							}
	    							if ((oStub.oFather.getView().vExeStpList.iCurrStpPos < 0) && isRoadMapRef && (tskId === roadMapId && tskType === suiCnst.SLP_TASK_TYPE_TECH_ROADMAP)) {
	   									oStub.oFather.getView().vExeStpList.iCurrStpPos = t;
	   									break;
	    							}
	    						}
	    					}
	    				}
	    				if (oStub.oFather.getView().vExeStpList.iCurrStpPos > -1) {                                     
	    					if (this.getModel('TaskList').getMetadata().getName().indexOf("JSON") > -1) {
	    						if (this.getModel('TaskList').getData().tasklist.Task[oStub.oFather.getView().vExeStpList.iCurrStpPos].status === suiCnst.SLP_TASK_STATUS_INITIAL) {
	    							this.getModel('TaskList').getData().tasklist.Task[oStub.oFather.getView().vExeStpList.iCurrStpPos].status = suiCnst.SLP_TASK_STATUS_RUNNING;
	    							for (i = oStub.oFather.getView().vExeStpList.iCurrStpPos-1; i >= 0; i--) {
	    								if (    (this.getModel('TaskList').getData().tasklist.Task[i].status === suiCnst.SLP_TASK_STATUS_INITIAL)
	    										|| (this.getModel('TaskList').getData().tasklist.Task[i].status === suiCnst.SLP_TASK_STATUS_RUNNING)
	    										|| (this.getModel('TaskList').getData().tasklist.Task[i].status === suiCnst.SLP_TASK_STATUS_DIALOG))  
	    									this.getModel('TaskList').getData().tasklist.Task[i].status = suiCnst.SLP_TASK_STATUS_UNKNOWN;
	    								else if (    (this.getModel('TaskList').getData().tasklist.Task[i].status === suiCnst.SLP_TASK_STATUS_FINISHED)
	    										|| (this.getModel('TaskList').getData().tasklist.Task[i].status === suiCnst.SLP_TASK_STATUS_UNKNOWN) ) break;
	    							}
	    						}
	    					} else {
	    						if ($(this.getModel('TaskList').getData()).find("Task").get(oStub.oFather.getView().vExeStpList.iCurrStpPos).getElementsByTagName(suiCnst.SLP_TASK_STATUS)[0].textContent === suiCnst.SLP_TASK_STATUS_INITIAL) {
	    							$(this.getModel('TaskList').getData()).find("Task").get(oStub.oFather.getView().vExeStpList.iCurrStpPos).getElementsByTagName(suiCnst.SLP_TASK_STATUS)[0].textContent = suiCnst.SLP_TASK_STATUS_RUNNING;
	    							for (i=oStub.oFather.getView().vExeStpList.iCurrStpPos-1; i>=0; i--) {
	    								if (    ($(this.getModel('TaskList').getData()).find("Task").get(i).getElementsByTagName(suiCnst.SLP_TASK_STATUS)[0].textContent === suiCnst.SLP_TASK_STATUS_INITIAL)
	    										|| ($(this.getModel('TaskList').getData()).find("Task").get(i).getElementsByTagName(suiCnst.SLP_TASK_STATUS)[0].textContent === suiCnst.SLP_TASK_STATUS_RUNNING)
	    										|| ($(this.getModel('TaskList').getData()).find("Task").get(i).getElementsByTagName(suiCnst.SLP_TASK_STATUS)[0].textContent === suiCnst.SLP_TASK_STATUS_DIALOG))  
	    									$(this.getModel('TaskList').getData()).find("Task").get(i).getElementsByTagName(suiCnst.SLP_TASK_STATUS)[0].textContent = suiCnst.SLP_TASK_STATUS_UNKNOWN;
	    								else if (    ($(this.getModel('TaskList').getData()).find("Task").get(i).getElementsByTagName(suiCnst.SLP_TASK_STATUS)[0].textContent === suiCnst.SLP_TASK_STATUS_FINISHED)
	    										|| ($(this.getModel('TaskList').getData()).find("Task").get(i).getElementsByTagName(suiCnst.SLP_TASK_STATUS)[0].textContent === suiCnst.SLP_TASK_STATUS_UNKNOWN) ) break;
	    							}
	    						}
	    					}
	    				}
	    			}  
	    		};
	    		idx = oStub.oFather.getView().vExeStpList.iCurrStpPos - 3;
	    		if (oStub.oFather.getView().vExeStpList.autoScroll) {
	    			this.setFirstVisibleRow((idx < 0) ? 0 : idx); 
	    			oStub.oFather.getView().vExeStpList.firstVisibleRow = this.getFirstVisibleRow();
	    		}
	        }
        }, this.stepListTable);            
    },
    
    resizeTableHeightForVerticalScroll: function() {
    	var iWidth = $(document).height() - 210;
    	iWidth = Math.round(iWidth / 32);					// was: 28 - needed to be adjusted for SAPUI5 V1.46.0
    	this.stepListTable.setVisibleRowCount(iWidth);
    	$(window).resize(function() {
    		var iWidth = $(document).height() - 210;
    		iWidth = Math.round(iWidth / 32);				// was: 28 - needed to be adjusted for SAPUI5 V1.46.0
    		sap.ui.getCore().byId("_slui_table_taskList").setVisibleRowCount(iWidth);
    	});
    }
});

var oViewHelper = {
    generateStatusTooltip: function(oValue) {
        var imgSrc = oBundle.getText("PRC_LBL_NO_DES_TXT");
        switch (oValue) {
            case suiCnst.SLP_TASK_STATUS_ABORTED:
                imgSrc = oBundle.getText("ABR_LBL_TXT");
                break;
            case suiCnst.SLP_TASK_STATUS_FINISHED:
                imgSrc = oBundle.getText("FIN_LBL_TXT");
                break;
            case suiCnst.SLP_TASK_STATUS_SKIPPED:
                imgSrc = oBundle.getText("SKP_LBL_TXT");
                break;
            case suiCnst.SLP_TASK_STATUS_ERROR:
                imgSrc = oBundle.getText("ERR_LBL_TXT");
                break;
            case suiCnst.SLP_TASK_STATUS_RUNNING:
                imgSrc = oBundle.getText("RUN_LBL_TXT");
                break;
            case suiCnst.SLP_TASK_STATUS_DIALOG:
                imgSrc = oBundle.getText("DIA_LBL_TXT");
                break;
            case suiCnst.SLP_TASK_STATUS_ACTION_REQUIRED:
                imgSrc = oBundle.getText("ACN_LBL_TXT");
                break;
            case suiCnst.SLP_TASK_STATUS_BREAKPOINT:
                imgSrc = oBundle.getText("BRK_LBL_TXT");
                break;
            case suiCnst.SLP_TASK_STATUS_INITIAL:
                imgSrc = oBundle.getText("INI_LBL_TXT");
                break;
            default:
                imgSrc = oBundle.getText("INI_LBL_TXT");
                break;
        }
        return imgSrc;
    },

    generateTypeTooltip: function(oValue) {
        var imgSrc = oBundle.getText("PRC_LBL_NO_DES_TXT");
        switch (oValue) {
            case suiCnst.SLP_TASK_TYPE_PROCESS:
                imgSrc = oBundle.getText("PRO_LBL_TXT");
                break;
            case suiCnst.SLP_TASK_TYPE_STEP:
                imgSrc = oBundle.getText("TSK_STP_LBL_TXT");
                break;
            case suiCnst.SLP_TASK_TYPE_TECH_ROADMAP:
                imgSrc = oBundle.getText("RDM_LBL_TXT");
                break;
            case suiCnst.SLP_TASK_TYPE_USER_ROADMAP:
                imgSrc = oBundle.getText("USR_RDM_LBL_TXT");
                break;
            case suiCnst.SLP_TASK_TYPE_TASK:
                imgSrc = oBundle.getText("TAK_LBL_TXT");
                break;
            case suiCnst.SLP_TASK_TYPE_SERVICE:
                imgSrc = oBundle.getText("SER_LBL_TXT");
                break;
            default:
                imgSrc = oBundle.getText("TSK_STP_LBL_TXT");
                break;
        }
        return imgSrc;
    },
    
    generateTypeImage: function(oValue) {
        var imgSrc = suiCnst.UI_FILE_PATH_SLUI_ROOTPATH + suiCnst.UI_FILE_PATH_TASK_TYPE;
        switch (oValue) {
            case suiCnst.SLP_TASK_TYPE_PROCESS:
                imgSrc = imgSrc + "/process.png";
                break;
            case suiCnst.SLP_TASK_TYPE_STEP:
                imgSrc = imgSrc + "/step.png";
                break;
            case suiCnst.SLP_TASK_TYPE_TECH_ROADMAP:
                imgSrc = imgSrc + "/roadmaptech.png";
                break;
            case suiCnst.SLP_TASK_TYPE_USER_ROADMAP:
                imgSrc = imgSrc + "/roadmapuser.png";
                break;
            case suiCnst.SLP_TASK_TYPE_TASK:
                imgSrc = imgSrc + "/task.png";
                break;
            case suiCnst.SLP_TASK_TYPE_SERVICE:
                imgSrc = imgSrc + "/service.png";
                break;
            default:
                imgSrc = imgSrc + "/step.png";
                break;
        }
        return imgSrc;
    },
    
    generateNameTooltip: function(oValue) {
        if (!oValue) return "No description available";
        else return oValue;
    },
    
    generateStatusIcon: function(oValue) {
        var iconSrc = "sap-icon://";
        switch (oValue) {
            case suiCnst.SLP_TASK_STATUS_ABORTED:
                iconSrc += "sys-cancel";
                break;
            case suiCnst.SLP_TASK_STATUS_FINISHED:
                iconSrc += "status-completed";
                break;
            case suiCnst.SLP_TASK_STATUS_SKIPPED:
                iconSrc += "overlay";
                break;
            case suiCnst.SLP_TASK_STATUS_ERROR:
                iconSrc += "message-error";
                break;
            case suiCnst.SLP_TASK_STATUS_RUNNING:
                iconSrc += "media-play";
                break;
            case suiCnst.SLP_TASK_STATUS_DIALOG:
                iconSrc += "status-inactive";
                break;
            case suiCnst.SLP_TASK_STATUS_ACTION_REQUIRED:
                iconSrc += "to-be-reviewed";
                break;
            case suiCnst.SLP_TASK_STATUS_BREAKPOINT:
                iconSrc += "navigation-right-arrow";
                break;
            case suiCnst.SLP_TASK_STATUS_INITIAL:
                iconSrc += "status-negative";
                break;
            case suiCnst.SLP_TASK_STATUS_UNKNOWN:
                iconSrc += "refresh";
                break;
            default:
                iconSrc += "status-negative";
                break;
        }
        return iconSrc;
    },
    
    generateStatusIconColor: function(oValue) {
        var iconColor = "#000000";
        switch (oValue) {
            case suiCnst.SLP_TASK_STATUS_ABORTED:
                iconColor = "#cc0000";
                break;
            case suiCnst.SLP_TASK_STATUS_FINISHED:
                iconColor = "#008b00";
                break;
            case suiCnst.SLP_TASK_STATUS_SKIPPED:
                iconColor = "#007dc0";
                break;
            case suiCnst.SLP_TASK_STATUS_ERROR:
                iconColor = "#cc0000";
                break;
            case suiCnst.SLP_TASK_STATUS_RUNNING:
                iconColor = "#007dc0";
                break;
            case suiCnst.SLP_TASK_STATUS_DIALOG:
                iconColor = "#fdc411";
                break;
            case suiCnst.SLP_TASK_STATUS_ACTION_REQUIRED:
                iconColor = "#007dc0";
                break;
            case suiCnst.SLP_TASK_STATUS_BREAKPOINT:
                iconColor = "#fdc411";
                break;
            case suiCnst.SLP_TASK_STATUS_INITIAL:
                iconColor = "#8F8F8F";
                break;
            case suiCnst.SLP_TASK_STATUS_UNKNOWN:
                iconColor = "#70c070";
                break;
            default:
                iconColor = "#8F8F8F";
                break;
        }
        return iconColor;
    }
};
