sap.ui.jsview(sluiCore.mod.jsexeWizd, {
	parentContainer: 	undefined,
	uiRegex: 			undefined,
	containerText: 		undefined,
	UIElmIDColl: 		undefined,
	progBrVw: 			undefined,
	progMsg: 			undefined,
	progVal: 			undefined,
	stepTask: 			undefined,
	
	supplyData: function(cText) {
		if (cText) this.containerText = cText;
		this.updateContent();
	},
	
	createContent: function(oController) {
		this.parentContainer = new sap.ui.commons.layout.VerticalLayout();
		this.parentContainer.setWidth("100%");
		this.createBusyLayout();
		this.UIElmIDColl = new Array();
		this.UIElmIDColl = [];
		return this.parentContainer;
	},
	
	updateContent: function(sMode) {
		this.onBeforeDialogRendering();
		var oFCntrl = oStub.oFather;
		var suc = sap.ui.commons;
		var sucr = sap.ui.core;
		if (sMode && sMode === suiCnst.UI_DIS_EXE_FNSH) {
			var sapCore = sap.ui.getCore();
			var proBar = sapCore.byId('_slui_executionProgress');
			var iWidth = "150px";
			var oUIProc = oFCntrl.oProcExe.oUIProc;
			oFCntrl.getView().vExeCont.destroyAllButtons();
			oFCntrl.oProcExe.getSLPAction();
			var oVLayout = new suc.layout.VerticalLayout({width: "100%"});
			if (proBar) {
				iWidth = proBar.getWidth();
				iWidth = iWidth.replace("px", "");
				iWidth = parseInt(iWidth) + 54 + "px";
				oVLayout.setWidth(iWidth);
			}	
			var oHLayout = new suc.layout.HorizontalLayout({width: "100%"});
			var oIcon = new sap.ui.core.Icon({		size: 					"30px",  
	            									activeColor: 			"white",  
	            									activeBackgroundColor: 	"transparent",  
	            									width: 					"30px"			});
			var oTextView = new suc.TextView('statusMsgText', {	design: 	suc.TextViewDesign.H5,
																textAlign: 	sucr.TextAlign.Left		});
			oTextView.addStyleClass("displayTextAtCenter");
			oHLayout.addContent(new sucr.HTML({content: "<div style=\"width:30px; height:100%\"></div>"}));
			oHLayout.addContent(oIcon);
			oHLayout.addContent(new sucr.HTML({content: "<div style=\"width:15px; height:100%\"></div>"}));
			oHLayout.addContent(oTextView);
			oVLayout.addContent(new sucr.HTML({content: "<div style=\"width:100%; height:40px\"></div>"}));
			oVLayout.addContent(oHLayout);
			oVLayout.addContent(new sucr.HTML({content: "<div style=\"width:100%; height:40px\"></div>"}));
			if (oUIProc && oUIProc.sState === suiCnst.SLP_TASK_STATUS_FINISHED) {
				oTextView.setText(oBundle.getText("PRO_EXE_SUC_LBL_TXT"));
				oIcon.setSrc("sap-icon://message-success");
				oIcon.setColor("#008B00");
				oIcon.setTooltip(oBundle.getText("PRO_EXE_SUC_LBL_TXT"));
				oTextView.setSemanticColor(suc.TextViewColor.Positive);
				oVLayout.addStyleClass("containerForSuccess");
			} else if (oUIProc && oUIProc.sState === suiCnst.SLP_TASK_STATUS_ABORTED) {
				oTextView.setText(oBundle.getText("PRO_EXE_ERR_LBL_TXT"));
				oIcon.setSrc("sap-icon://error");
				oIcon.setColor("#CC0000");
				oIcon.setTooltip(oBundle.getText("PRO_EXE_ERR_LBL_TXT"));
				oTextView.setSemanticColor(suc.TextViewColor.Negative);
				oVLayout.addStyleClass("containerForAborted");
			} else if (oUIProc && oUIProc.sState === suiCnst.SLP_TASK_STATUS_SKIPPED) {
				oTextView.setText(oBundle.getText("PRO_EXE_WRN_LBL_TXT"));
				oIcon.setSrc("sap-icon://warning2");
				oIcon.setColor("#FED659");
				oIcon.setTooltip(oBundle.getText("PRO_EXE_WRN_LBL_TXT"));
				oTextView.setSemanticColor(suc.TextViewColor.Critical);
				oVLayout.addStyleClass("containerForSkipped");
			} else {
				oTextView.setText(oBundle.getText("PRO_EXE_FIN_LBL_TXT"));
				oIcon.setSrc("sap-icon://message-information");
				oIcon.setColor("#007DC0");
				oIcon.setTooltip(oBundle.getText("PRO_EXE_FIN_LBL_TXT"));
				oTextView.setSemanticColor(suc.TextViewColor.Default);
				oVLayout.addStyleClass("containerForNormal");
			}
			this.busyLayout(false);
			this.destroyLongRunningStatus();
			this.parentContainer.addContent(oVLayout);
		} else {
			var oUIProc = oFCntrl.oProcExe.oUIProc;
			if (oUIProc && (oStub.oFather.oUtil.checkMonitorState(oUIProc.sState, 5) || (oUIProc.sState === suiCnst.SLP_TASK_STATUS_FINISHED && oStub.oFather.execVwProps["displayDialogOnFinish"] == true))) {
				var oRenderer = new SLUISimpleUIRenderers(null, oFCntrl);
				var dialogResponse;
				if (oUIProc.diaColl && (oUIProc.diaColl.length > 0)) dialogResponse = oUIProc.diaColl[0];
				if (dialogResponse && !oUIProc.isDiaRendered && (oUIProc.diaColl && oUIProc.diaColl.length > 0)) {
					oRenderer = new SLUISimpleUIRenderers(dialogResponse.getDialogBody(), oFCntrl);
					this.parentContainer.destroyContent();
                    var oDialogForm = new sap.ui.layout.form.Form({width: "90%"});	//SUM_DMO_SAPUI5_ACC_SP19_ACC-264
                    var newDB = dialogResponse.getDocDB();		 					//get DB from metadialog
                    var newOpt = dialogResponse.getDocOpt(); 						//get option from metadialog
					if (newDB && newDB.trim()) { 
						if (newOpt && newOpt.trim()) {
							globals.lastGuide = newDB + "/" + newOpt;
							if (newOpt === "std") globals.lastStdDB = newDB;		//when opt is "dmo" we still must remember the source db for the guide! 
						}
						else {
							globals.lastGuide = newDB + "/std";						//no opt given -> std guide
							globals.lastStdDB = newDB;								//remember this db for later std guide 
						}
					}
					else if (newOpt && newOpt.trim()) globals.lastGuide = newOpt; 	//only option is given --> must be zdo!
					else if (globals.lastStdDB && globals.lastStdDB.trim()) globals.lastGuide = globals.lastStdDB + "/std";
					else globals.lastGuide = "";
					globals.lastLOIO = dialogResponse.getDocRef(); //get LOIO from metadialog and store it in global variable 
					if (dialogResponse.getDialogHeader()) {
						var title = dialogResponse.getDialogHeader().getCaption();
						if (title) {
							title = title.replace(/^<!\[CDATA\[|\]\]>$/g, "");
							oDialogForm.setTitle(new suc.Title({	text:		title,
																	tooltip: 	title,
																	level: 		suc.TitleLevel.H6	}));
						}
					}
					if((dialogResponse.getId() === "UnitWizard") && (dialogResponse.getDialogBody().getGroupViews().find("[id^='ChecksLogGroup']").length != 0)) pollChecksLog(true);
					oDialogForm.setLayout(new sap.ui.layout.form.ResponsiveGridLayout({	columnsL: 	1,
																						columnsM: 	1	}));
					this.UIElmIDColl = [];
					var cFC = oRenderer.renderDialog(oUIProc.diaParamMap, oDialogForm);
					this.UIElmIDColl = oRenderer.UIElmIDColl;
					oDialogForm.removeAllFormContainers();
					for (var xCount = 0; xCount < cFC.length; xCount++) oDialogForm.addFormContainer(cFC[xCount]);
					this.busyLayout(false);
					this.destroyLongRunningStatus();
					// add the error status
					this.displayErrors(this.parentContainer,oUIProc);
					//add the dialog form
					this.parentContainer.addContent(oDialogForm);
					oUIProc.isDiaRendered = true;
					if (!oUIProc.isActionRendered) oStub.oFather.updateView(suiCnst.UI_VW_UPDATE_ACTION);
				} else if (!dialogResponse && !oUIProc.isDiaRendered) {
				} else if (oUIProc.valErr.length > 0) {
					var oVLayout = new suc.layout.VerticalLayout({width: "100%"});
					for (var x = 0; x < oUIProc.valErr.length; x++) oRenderer.triggerServerSideValidation(oUIProc.diaParamMap[oUIProc.valErr[x].paramId].uiId, oUIProc.valErr[x].message, oUIProc.valErr[x].status);
				}
			} else if (oUIProc && oUIProc.sState === suiCnst.SLP_TASK_STATUS_FINISHED) {
				this.busyLayout(false);
				this.destroyLongRunningStatus();
				this.updateContent(suiCnst.UI_DIS_EXE_FNSH);
			}
			else this.busyLayout(true);
		}
		this.onAfterDialogRendering();
	},
	
	displayErrors : function(rootContainer,oUIProc) {
		var suc = sap.ui.commons;
		var sucr = sap.ui.core;
		if (oUIProc && oUIProc.valErr && (oUIProc.valErr.length > 0)) {
			var oVLayout = new suc.layout.VerticalLayout({width: "100%"});
			for (var x = 0; x < oUIProc.valErr.length; x++) {
				var sStatus = oUIProc.valErr[x].status;
				var sMsg = oUIProc.valErr[x].message;
				var prId = oUIProc.valErr[x].paramId;
				var oHLayout = new suc.layout.HorizontalLayout({width: "100%"});
				var oIcon = new sap.ui.core.Icon({   
		            size: 					"15px",  
		            activeColor: 			"white",  
		            activeBackgroundColor: 	"transparent",  
		            width: 					"15px"
		        });
				var oTextView = new suc.TextView({textAlign: sap.ui.core.TextAlign.Left});
				oHLayout.addContent(new sucr.HTML({content: "<div style=\"width:10px;height:100%\"></div>"}));
				oHLayout.addContent(oIcon);
				oHLayout.addContent(new sucr.HTML({content: "<div style=\"width:10px;height:100%\"></div>"}));
				oHLayout.addContent(oTextView);
				oVLayout.addContent(new sucr.HTML({content: "<div style=\"width:100%;height:10px;\"></div>"}));
				oVLayout.addContent(oHLayout);
				if (sMsg) oTextView.setText(sMsg);
				if (sStatus === suiCnst.SLP_PARAM_VAL_STS_ERROR) {
					oIcon.setSrc("sap-icon://error");
					oIcon.setColor("#CC0000");
					oTextView.setSemanticColor(suc.TextViewColor.Negative);
				} else if (sStatus ===suiCnst.SLP_PARAM_VAL_STS_WARN) {
					oIcon.setSrc("sap-icon://warning2");
					oIcon.setColor("#FED659");
					oTextView.setSemanticColor(suc.TextViewColor.Critical);
				} 
				else oTextView.setSemanticColor(suc.TextViewColor.Default);
				oTextView.setDesign(sap.ui.commons.TextViewDesign.H6);
				if (prId) {
					var uuid = oUIProc.diaParamMap[prId].uiId;
					if (uuid) {
						var uiElm = sap.ui.getCore().byId(uuid);
						if (uiElm) {
							if (typeof uiElm.setValueState === "function") uiElm.setValueState(sap.ui.core.ValueState.Error);
							var oRtp = new sap.ui.commons.RichTooltip({text : sMsg});
							uiElm.setTooltip(oRtp);
						}
					}
				}
			}
			rootContainer.addContent(oVLayout);
		} else if (oUIProc && Boolean(oUIProc.sError)) {
			var oVLayout = new suc.layout.VerticalLayout({width: "100%"});
			var oHLayout = new suc.layout.HorizontalLayout({width: "100%"});
			var oIcon = new sap.ui.core.Icon({	src: 					"sap-icon://error",
												color: 					"#CC0000",
												size: 					"15px",  
												activeColor: 			"white",  
												activeBackgroundColor: 	"transparent",   
												width: 					"15px"				});
			var oTextView = new suc.TextView({textAlign: sap.ui.core.TextAlign.Left});
			oHLayout.addContent(new sucr.HTML({content: "<div style=\"width:10px;height:100%\"></div>"}));
			oHLayout.addContent(oIcon);
			oHLayout.addContent(new sucr.HTML({content: "<div style=\"width:10px;height:100%\"></div>"}));
			oHLayout.addContent(oTextView);
			oVLayout.addContent(new sucr.HTML({content: "<div style=\"width:100%;height:10px;\"></div>"}));
			oVLayout.addContent(oHLayout);
			oTextView.setText(oUIProc.sError);
			oTextView.setDesign(sap.ui.commons.TextViewDesign.H6);
			oTextView.setSemanticColor(suc.TextViewColor.Negative); 
			rootContainer.addContent(oVLayout);
		}
	},
	
	distroyWizrdContent: function() {
		this.parentContainer.destroyContent();
		if (oStub.oFather.oProcExe) this.setDialogDestroyed();
	},
	
	displayBusyLoader: function() {
		this.busyLayout(true);
	},
	
	setDialogDestroyed: function() {
		oStub.oFather.oProcExe.oUIProc.isDiaRendered = false;
		oStub.oFather.oProcExe.oUIProc.diaColl = undefined;
	},
	
	createBusyLayout: function() {
		var suc = sap.ui.commons;
		var busyLabelText = oBundle.getText("PRO_EXE_PROC_TXT");
		var oLabel = new suc.Label("_slui_busyLayoutLabel", {text: busyLabelText, design: sap.ui.commons.LabelDesign.Bold});
		var oImage = new suc.Image();
		oImage.setSrc("slui/resources/logo/busy.gif");
		oImage.setAlt("busy indicator");
		oImage.addStyleClass("displayImageLeft");
		var emptyBox = new sap.ui.core.HTML({content: "<div style=\"padding-left: 65px\"></div>", sanitizeContent: true});
		var oHLyt = new suc.layout.MatrixLayout({layoutFixed: false});
		oHLyt.createRow(emptyBox,oImage,emptyBox);	
		var verSpc = new sap.ui.core.HTML({content: "<div style=\"margin-top: 50px\"></div>", sanitizeContent: true});
		var oLayout = new sap.ui.layout.VerticalLayout({content: [verSpc,oHLyt,oLabel]});
		var indent = new sap.ui.core.HTML({content: "<div style=\"padding-left: 230px;padding-top: 25px;\"></div>", sanitizeContent: true});
		var oHLyt = new sap.ui.layout.HorizontalLayout("_slui_busyLayout", {visible: true, content: [indent,oLayout]});
		this.parentContainer.addContent(oHLyt);
	},
	
	updateBusyLayoutLabel: function() {
		//IN CASE OF DUAL STACK SCENARIOS AND PHASE READ_SHAREDINPUT ON ABAP SIDE:
		//WE TELL THE USER THAT ABAP WAITS FOR JAVA RATHER THAN JUST "IN PROGRESS"
		//IM 1670249298
		if (oStub) {
			var oUIProc = oStub.oFather.oProcExe.oUIProc;
			var blLabel = sap.ui.getCore().byId("_slui_busyLayoutLabel");
			if ((oUIProc.curMonTskLst.length >= 3) && (oUIProc.curMonTskLst[2].objData.textContent.indexOf("READ_SHAREDINPUT") !== -1)) blLabel.setText(oBundle.getText("PRO_EXE_PROC_TXT_WAITING4J"));
			else blLabel.setText(oBundle.getText("PRO_EXE_PROC_TXT"));
		}                                
	},
	
	busyLayout: function(bVal) {
		var oBsLyt = sap.ui.getCore().byId("_slui_busyLayout");
		if (oBsLyt) {
			this.updateBusyLayoutLabel();
			oBsLyt.setVisible(bVal);
			this.longRunningProcessStatus();
		} else {
			this.createBusyLayout();
			this.busyLayout(bVal);
			this.longRunningProcessStatus();
		}
	},
	
	onAfterRendering: function() {
		// set focus on [Next]-button if available
		var btnNext = document.getElementById("_slui_actn_btn_next_btntpe_slp.action.SUBMIT");
		if (btnNext) btnNext.focus();
	},
	
    longRunningProcessStatus: function() {
        var sapCore = sap.ui.getCore();
        var sucr = sap.ui.core;
        var suc = sap.ui.commons;
        var oUIProc = oStub.oFather.oProcExe.oUIProc;
        var iProgressVal = -1;
    	var proStatus;
        var tPgBar = sapCore.byId('_slui_longRunningExeProgress');
        var tPgBarLbl = sapCore.byId('_slui_longRunningExeProgressMsgLabel');
        var tPgBarVal = sapCore.byId('_slui_longRunningExeProgressValue');
        if (!tPgBar) this.progBrVw = new suc.ProgressIndicator('_slui_longRunningExeProgress', {width: "300px", visible: false});
        if (!tPgBarLbl) this.progMsg = new suc.TextView('_slui_longRunningExeProgressMsgLabel', {
        		width: 		"30%",
                design: 	suc.TextViewDesign.Standard,
                wrapping: 	true,
                visible: 	false,
        });
        if (!tPgBarVal) this.progVal = new suc.TextView('_slui_longRunningExeProgressValue', {
                width: 		"55px",
                design: 	suc.TextViewDesign.Standard,
                wrapping: 	false,
                visible: 	false,
        });
        if (oUIProc) {
            //identify step and check if it is long running
            for (var x = 0; x < oUIProc.curMonTskLst.length; x++)
            	switch (oUIProc.curMonTskLst[x].getType()) { 
            		case suiCnst.SLP_TASK_TYPE_PROCESS:
            			proStatus = oUIProc.curMonTskLst[x].getStatus();
            			break;
            		case suiCnst.SLP_TASK_TYPE_STEP:
            			this.stepTask = oUIProc.curMonTskLst[x];
            			iProgressVal = this.stepTask.getProgress();
            	}
            if ((iProgressVal != null) && (iProgressVal >= 0) && (iProgressVal <= 100)) {
                var tPgBar = sapCore.byId('_slui_longRunningExeProgress');
                var tPgBarLbl = sapCore.byId('_slui_longRunningExeProgressMsgLabel');
                tPgBarLbl.addStyleClass("displayElementInCenter");
                var tPgBarVal = sapCore.byId('_slui_longRunningExeProgressValue');
                tPgBarVal.addStyleClass("displayElementInCenter");
                tPgBar.setVisible(true);
                tPgBarLbl.setVisible(true);
                tPgBarVal.setVisible(true);
                //set progress bar width
                if (proStatus) {
                    tPgBar.setBarColor(sucr.BarColor.NEUTRAL);
                    tPgBarVal.setSemanticColor(suc.TextViewColor.Neutral);
                    var oTooltipText = (new sap.ui.commons.Label({text: oBundle.getText("TSK_LBL_RUN_TXT")})).addStyleClass("tooltipText");
                    var oIcon = new sap.ui.core.Icon({
                        src: 					"sap-icon://media-play",
                        size: 					"15px",
                        color: 					"#007dc0",
                        activeColor: 			"white",
                        activeBackgroundColor: 	"transparent",
                        width: 					"15px"
                    });
                    tPgBar.setTooltip(new suc.Callout({content: [oIcon, oTooltipText]}));
                    tPgBar.setDisplayValue(oBundle.getText("TSK_LBL_RUN_TXT"));
                } else {
                    tPgBar.setBarColor(sucr.BarColor.NEUTRAL);
                    tPgBarVal.setSemanticColor(suc.TextViewColor.Neutral);
                }
                tPgBarVal.setText(parseInt(iProgressVal, 10) + "%");
                tPgBarVal.setTooltip(oBundle.getText("PROG_LBL_TXT") + " " + parseInt(iProgressVal, 10));
                tPgBar.setPercentValue(parseInt(iProgressVal, 10));
                tPgBarLbl.setText($($(this.stepTask.baseModel.getModel().getXML()).find("progressMessages")[0]).find("message").text());
                var oLyt = sapCore.byId('_slui_longProgressValDisplay1');
                if (!oLyt) oLyt = new suc.layout.VerticalLayout('_slui_longProgressValDisplay1', {width: "100%"});
                var oVLayout = sapCore.byId('_slui_longProgressValDisplay2');
                if (!oVLayout) oVLayout = new suc.layout.VerticalLayout('_slui_longProgressValDisplay2', {width: "100%"});
                if (oVLayout.indexOfContent(this.progBrVw) == -1) oVLayout.addContent(this.progBrVw);
                var oHlayout = sapCore.byId('_slui_longProgressValDisplay3');
                if (!oHlayout) {
                    var oBox1 = new sap.m.VBox({ height: "40px"});
                    var oBox2 = new sap.m.VBox({ height: "30px"});
                    var oLytBox1 = new suc.layout.VerticalLayout('_slui_box1', {	width: 		"100%",
                    																content: 	[oBox1]		});
                    var oLytBox2 = new suc.layout.VerticalLayout('_slui_box2', {	width: 		"100%",
                    																content:	[oBox2]		});
                    oHlayout = new suc.layout.HorizontalLayout('_slui_longProgressValDisplay3', {	width: 		"100%",
                    																				content: 	[this.progVal, oVLayout]	});
                }
                if (oLyt.indexOfContent(oHlayout) === -1) {
                    oLyt.addContent(oLytBox1);
                    oLyt.addContent(oHlayout);
                }
                if (oLyt.indexOfContent(this.progMsg) === -1) oLyt.addContent(this.progMsg);
                if (this.parentContainer.indexOfContent(oLyt) === -1) {
                    oLyt.addContent(oLytBox2);
                    oLyt.addStyleClass("containerForSubProcess");                    
                    this.parentContainer.addContent(oLyt);
                }
            } else {
                var oLyt = sap.ui.getCore().byId('_slui_longProgressValDisplay1');
                if (oLyt && (this.parentContainer.indexOfContent(oLyt) !== -1)) this.parentContainer.removeContent(oLyt);
            }
        }
    },
    
	destroyLongRunningStatus: function() {
		var oLyt = sap.ui.getCore().byId('_slui_longProgressValDisplay1');
		if (oLyt && (this.parentContainer.indexOfContent(oLyt) !== -1)) this.parentContainer.removeContent(oLyt);
	},
	
	onBeforeDialogRendering: function() {
    	if (functionsBeforeDialogRendering) for (var i = 0; i < functionsBeforeDialogRendering.length; i++) if (functionsBeforeDialogRendering[i]) functionsBeforeDialogRendering[i]();
    },
    
    onAfterDialogRendering: function() {
    	if (functionsAfterDialogRendering) for (var i = 0; i < functionsAfterDialogRendering.length; i++) if (functionsAfterDialogRendering[i]) functionsAfterDialogRendering[i]();
    }
});
