sap.ui.jsview(sluiCore.mod.jsproGLst, {
	processListTable: 	undefined,
	processExecuteBtn: 	undefined,
	selectedIndex: 		0,
	
	supplyData: function(dataModel, sIndex) {
		if (sIndex) this.selectedIndex = sIndex;
		else this.selectedIndex = -1;
		if (dataModel) this.dataModel.setData(dataModel);
		this.updateContent();
	},
	
	createContent: function(oController) {
		this.processListTable = new sap.ui.commons.layout.HorizontalLayout('slui_parentOfgroupedcontianer', {width: "100%"});
		this.processListTable.addContent(new sap.ui.core.HTML({content: "<div style=\"width:50px\"/>", sanitizeContent: true}));
		return this.processListTable;
	},
	
	modifyViewContents: function(modifyType) {
		if (modifyType == 1) this.updateContent();
	},
	
	updateModel: function(oModel) {
		if (oModel) this.dataModel.setData(oModel);
		this.updateContent();
	},
	
	updateContent: function() {
		var suc = sap.ui.commons;
		var rfl = suc.layout.ResponsiveFlowLayout;
		var rflLD = suc.layout.ResponsiveFlowLayoutData;
		var vLayt1 = new suc.layout.VerticalLayout({width: "100%"});
		vLayt1.addContent(new sap.ui.core.HTML({content: "<div style=\"height:50px\"/>", sanitizeContent: true}));
		var oFCntrl = oStub.oFather;
		var oProRep = oFCntrl.oProcRepo;
		var oModel = oProRep.cProcLst; //NEED2CHANGE
		if (oModel.getData()) {
			var oRFL = new rfl('slui_groupedcontianer', {width: "100%"});
			var pds = oModel.getData()["ProcessDefinitions"];
			if (pds) {
				var grpObjs = pds["ProcessDefinitionGroup"];
				for (var i = 0; i < grpObjs.length; i++) {
					var hLayt = new suc.layout.HorizontalLayout({width: "100%"});
					var grpObj = grpObjs[i];
					var headerText = new suc.TextView({design: suc.TextViewDesign.H6});
					headerText.setText(grpObj["displayName"]);
					hLayt.addContent(new sap.ui.core.HTML({content: "<div style=\"width:15px\"/>", sanitizeContent: true}));
					hLayt.addContent(new suc.Image({src: CNSTUIFILEPATHSLUIROOTPATH + CNSTUIFILEPATHTASKTYPE + "/slprocess.png"}));
					hLayt.addContent(new sap.ui.core.HTML({content: "<div style=\"width:15px\"/>", sanitizeContent: true}));
					var pdObjs = grpObj["ProcessDefinition"];
					var vLayt = new suc.layout.VerticalLayout({width: "100%"});
					vLayt.addContent(headerText);
					vLayt.addContent(new sap.ui.core.HTML({content: "<div style=\"height:10px\"/>", sanitizeContent: true}));
					for (var j = 0; j < pdObjs.length; j++) {
						var linkText = new suc.Link();
						linkText.setText((pdObjs[j])["displayName"]);
						vLayt.addContent(linkText);
						vLayt.addContent(new sap.ui.core.HTML({content: "<div style=\"height:5px\"/>", sanitizeContent: true}));
					}
					vLayt.addContent(new sap.ui.core.HTML({content: "<div style=\"height:10px\"/>", sanitizeContent: true}));
					hLayt.addContent(vLayt);
					hLayt.addContent(new sap.ui.core.HTML({content: "<div style=\"width:10px\"/>", sanitizeContent: true}));
					hLayt.setLayoutData(new rflLD({minWidth: 400}));
					oRFL.addContent(hLayt);
				}
			}
		}
		vLayt1.addContent(oRFL);
		this.processListTable.addContent(vLayt1);
	},
	
	executeBtnPress: function() {
		oStub.oFather.startProcessExecution();
	},
	
	selectionEvent: function(oEvent) {
		var oFCntrl = oStub.oFather;
		var selectedRowContext = oEvent.getParameter("rowContext");
		var selectedClientId = oFCntrl.oProcRepo.cProcLst.getProperty("id", selectedRowContext);
		oFCntrl.oProcRepo.leadProcId = selectedClientId;
	}
});