jQuery.sap.declare(sluiCore.mod.jsrendr);
jQuery.sap.require("sap.ui.core.util.Export");
jQuery.sap.require("sap.ui.core.util.ExportTypeCSV");

var oThis;
var cCliEveRefsInitial;
var cCliRef = new Array();
var refIds = new Array();
var childGrpsIds;
//I306705
var UIElmIDColl;

SLUISimpleUIRenderers = function(oRootData, controller) {
	if (oRootData) {
		this.sDataFormat = oRootData.sDataFormat;
		this.oDialogObject = oRootData;
	}
	if (controller) {
		oThis = this;
		this.oFather = controller;
	}	
	this.cnfObj = undefined;
};

SLUISimpleUIRenderers.prototype.getModel = function() {
	return this.oDialogObject;
};

SLUISimpleUIRenderers.prototype.renderDialog = function(paramMap) {
	cCliRef.length = 0;
	refIds.length = 0;
	var suc = sap.ui.commons;
	var cFC = new Array();
	cCliEveRefsInitial = new Array();
	cCliEveRefsInitial.length = 0;
	childGrpsIds = new Array();
	childGrpsIds.length = 0;
	this.UIElmIDColl = new Array();
	this.oFather.getView().vExeWizd.uiRegex = [];
	var oUIObject;
	if (this.oDialogObject) {
		oUIObject = new suc.form.FormContainer({width: "100%"});
		cFC.push(oUIObject);
		var groupCollection = this.oDialogObject.getGroupsViewAt(0);
		if (groupCollection) {
			var childUIElements = $(groupCollection).children(suiCnst.SLP_DIA_BODY_CHILD);
			if (childUIElements && childUIElements.length > 0) {
				var addData = {	labelWidth: 	this._calculateLabelWidth(childUIElements),
								parentVisible:	true											};
				childUIElements = childUIElements[0].childNodes;
				for (var i = 0; i < childUIElements.length; i++) {
					var childElementdata = childUIElements[i];
					if (childElementdata) {
						var sUItype = childElementdata.localName ? childElementdata.localName : childElementdata.nodeName;
						if (sUItype === suiCnst.SLP_DIA_CONTROL_GRP_VIEW) this._renderUIFactory(childElementdata, paramMap, addData, cFC);
						else {
							oUIObject.addFormElement(this._renderUIFactory(childElementdata, paramMap, addData, cFC));
							if (this.cnfObj) {
								oUIObject.addFormElement(this.cnfObj);	
								this.cnfObj = undefined;
							}
						}
					}
				}
			}
		}
	} else {
		this.oFather.oLogger.logD("No dialog rendering information in dialog resource, hence default rendering begins!");
		oUIObject = new suc.form.FormContainer({width: "800px"});
		var configParams = paramMap;
		for (var i = 0; i < configParams.length; i++) {
			var oUIElement = new suc.form.FormElement();
			var attrMap = null;
			var sUIElmId = null;
			var oUIControl = null;
			var oConfigParams = configParams[i];
			var sId = oConfigParams.getId();
			var sSecure = oConfigParams.getSecure();
			var sRequired = oConfigParams.getRequired();
			var sDisplayName = oConfigParams.getDisplayName();
			var bSecure = (sSecure === "true");
			var bRequired = (sRequired === "true");
			if (bSecure) {
				sUIElmId = "_slui_txtInput_pswd_" + sId;
				oUIControl = new suc.PasswordField(sUIElmId, {layoutData: new sap.ui.layout.GridData({span: "L11 M12 S12"})});
			} else {
				sUIElmId = "_slui_txtInput_norm_" + sId;
				oUIControl = new suc.TextField(sUIElmId, {layoutData: new sap.ui.layout.GridData({span: "L11 M12 S12"})});
			}
			oUIControlLabel = new suc.Label(sUIElmId + "_lbl");
			oUIControlLabel.setText(sDisplayName);
			if (bRequired) oUIControlLabel.addStyleClass("sapUiLblReq sapUiLblReqEnd"); 
			else oUIControlLabel.removeStyleClass("sapUiLblReq sapUiLblReqEnd");
			oUIElement.setLabel(oUIControlLabel);
			oUIElement.insertField(oUIControl);
			oUIControlLabel.setTooltip(sDisplayName);
			oUIObject.addFormElement(oUIElement);
			oUIProc.diaParamMap[oConfigParams.getId()].uiId = sUIElmId;
		}
	}
	return cFC;
};

SLUISimpleUIRenderers.prototype._renderUIFactory = function(dataModel, paramMap, addData, cFC) {
	switch (dataModel.localName ? dataModel.localName : dataModel.nodeName) {
		case suiCnst.SLP_DIA_CONTROL_TXT_INPUT:
			return this._renderTextInputView(dataModel, paramMap, addData);
			break;
		case suiCnst.SLP_DIA_CONTROL_CNFRM_INPUT:
			return this._renderConfirmInputView(dataModel, paramMap, addData);
			break;
		case suiCnst.SLP_DIA_CONTROL_TXT_VIEW:
			return this._renderTextView(dataModel, paramMap,addData);
			break;
		case suiCnst.SLP_DIA_CONTROL_REL_LINK:
			return this._renderRelatedLinks(dataModel, paramMap,addData);
			break;
		case suiCnst.SLP_DIA_CONTROL_FIL_BROW:
			return this._renderFileBrowseView(dataModel, paramMap,addData);
			break;
		case suiCnst.SLP_DIA_CONTROL_VAL_SELE:
			return this._renderValueSelectorGroupView(dataModel, paramMap,addData);
			break;
		case suiCnst.SLP_DIA_CONTROL_TBL_VIEW:
			return this._renderTableView(dataModel, paramMap,addData);
			break;
		case suiCnst.SLP_DIA_CONTROL_GRP_VIEW:
			return this._renderGroupView(dataModel, paramMap, cFC,addData);
	}
};

SLUISimpleUIRenderers.prototype._renderGroupView = function(oUIElmModel, paramMap, cFC,aData) {
	var suc = sap.ui.commons;
	var attrMap = oUIElmModel.attributes;
	var sRefId;
	var grpChildren = new Array();
	var sId = null,
		sParentId = null,
		sUIElmId = null;
	var oCrypto = window.crypto || window.msCrypto;
	sId = this._checkForId(attrMap);
	sParentId = this._checkForParentId(attrMap);
	if (!sId) {
		if (oCrypto) sId = oCrypto.getRandomValues(new Uint32Array(1))[0];
		else sId = Math.random();
	}
	if (!sParentId) {
		if (oCrypto) sParentId = oCrypto.getRandomValues(new Uint32Array(1))[0];
		else sId = Math.random();
	}
	if (cCliEveRefsInitial && cCliEveRefsInitial.length > 0) for (var i = 0; i < cCliEveRefsInitial.length; i++) if (cCliEveRefsInitial[i].oRef) sRefId =cCliEveRefsInitial[i].oRef.refParIds[0];
	grpChildren = oUIElmModel.getElementsByTagName("groupView");
	for (var i = 0; i < grpChildren.length; i++) {
		var grpsId = grpChildren[i].getAttribute("id");
		if (childGrpsIds.indexOf(grpsId) === -1) childGrpsIds.push(grpsId);
	}
	for (var x = 0, i = 0; i < childGrpsIds.length; i++) if ((sId === childGrpsIds[i]) && (sParentId === sRefId)) {x = 1; break;}

	var iVisible = 0; 
	for (var i = 0 ; i < cCliRef.length ; i++) {
		var oReference = cCliRef[i].cliRefs;
		for (var j = 0; j < oReference.length ; j++) {
			if (refIds.indexOf(oReference[j].oRef.refParIds[0]) === -1) refIds.push(oReference[j].oRef.refParIds[0]);
			if ((oReference[j].oRef.refParIds[0] === sId ) && (oReference[j].sCheckValue === oReference[j].sEveState && oReference[j].oRef.refVal === "true")) iVisible = 1;
		}
	}
	if (refIds.indexOf(sId) === -1) iVisible = 1;
	if (sId && sParentId) {
		sUIElmId = "_slui_grp_view_" + sId;
		var oUIObject = new suc.form.FormContainer(sUIElmId, {width: "100%"});
		this._makeControlVisible(oUIObject, null, null, null, attrMap,aData.parentVisible);
		cFC.push(oUIObject);
		if ((sRefId === sId) || ((x === 1) && (iVisible === 1))) sap.ui.getCore().byId(sUIElmId).setVisible(true);
		if (oUIElmModel) {
			var cap = $(oUIElmModel).children("groupcaption");
			if (cap && (cap.length > 0)) {
				var str = cap[0].textContent;
				if (str) oUIObject.setTitle(new sap.ui.core.Title({level: sap.ui.core.TitleLevel.H4, text: str}));
			}
			var cChild = $(oUIElmModel).children(suiCnst.SLP_DIA_BODY_CHILD);
			if (cChild && (cChild.length > 0)) {
				cChild = cChild[0];
				var addData = {
					labelWidth: 	this._calculateLabelWidth(cChild),
					parentVisible:	aData ? aData.parentVisible && this._convertStringToBoolean(attrMap, "visible", true) : this._convertStringToBoolean(attrMap, "visible", true)
				};
				var childGrpIds = "";
				var hasImmChild = false;
				var childObj = null;
				if (cChild.children===undefined) childObj = cChild.childNodes;
				else childObj = cChild.children;
				for (var x = 0; x < childObj.length; x++) {
					var childElementdata = childObj[x];
					var sUItype = childElementdata.localName ? childElementdata.localName : childElementdata.nodeName;
					if (sUItype === suiCnst.SLP_DIA_CONTROL_GRP_VIEW) this._renderUIFactory(childElementdata, paramMap, addData, cFC);
					else {
						oUIObject.addFormElement(this._renderUIFactory(childElementdata, paramMap, addData, cFC));
						hasImmChild = true;
						if (this.cnfObj) {
							oUIObject.addFormElement(this.cnfObj);	
							this.cnfObj = undefined;
						}
					}
					if (!hasImmChild) oUIObject.setExpanded(false);
					if (childElementdata && childElementdata.attributes) {
						var id = this._checkForId(childElementdata.attributes);
						if (id) childGrpIds = childGrpIds+"|_sluigrpchild|"+id;
					}
				}
				//add child group reference ID to handle client event reference .
				$(oUIObject).attr("childGrpIds", childGrpIds);
			}
		}
	}
};

SLUISimpleUIRenderers.prototype._renderTextInputView = function(oUIElmModel, paramMap, addData) {
	if (oUIElmModel) {
		var suc = sap.ui.commons;
		var attrMap = oUIElmModel.attributes;
		var sId = null,
			sParentId = null,
			sUIElmId = null,
			sType = null,
			endswith = null,
			filter = null,
			bSecure = null;
			bWin = false;
		var iNoOfLines = null,
			iMaxCharLength = null,
			sToolTip = null,
			sLabel = null;
		var oUIObject = null,
			oUIControl = null,
			oUIControlLink = null,
			oUIControlLabel = null,
			oUIControlInfoBtn = null,
			oUIControlInfoPopUp = null,
			oERef = null;
		var bShftLft = false;
		var cnfInput = false;
		sId = this._checkForId(attrMap);
		sParentId = this._checkForParentId(attrMap);
		if (sId && sParentId) {
			oUIObject = new suc.form.FormElement();
			sType = this._checkAttributeExistence(attrMap, "type") ? attrMap["type"].value : suiCnst.SLP_DIA_ATTR_TXTINP_STANDARD;
			endswith = this._checkAttributeExistence(attrMap, "endswith") ? attrMap["endswith"].value : null;
			if (this._convertStringToBoolean(attrMap, "bwslash", false)) globals.osDirSeparator = "\\";
			switch (sType) {
				case suiCnst.SLP_DIA_ATTR_TXTINP_CNFINP:
				case suiCnst.SLP_DIA_ATTR_TXTINP_STANDARD:
				case suiCnst.SLP_DIA_ATTR_TXTINP_STRING:
					if (sType && (sType === suiCnst.SLP_DIA_ATTR_TXTINP_CNFINP)) cnfInput = true;
					bSecure = this._convertStringToBoolean(attrMap, "secure", false);
					iNoOfLines = this._convertStringToInteger(attrMap, "noOfLines");
					bShftLft = this._convertStringToBoolean(attrMap, "leftShift", false);
					if (bSecure) {
						sUIElmId = "_slui_txtInput_pswd_" + sParentId + "_p_" + sId;
						oUIControl = new suc.PasswordField(sUIElmId, {layoutData: new sap.ui.layout.GridData({span: "L6 M6 S12", linebreak: false})});
					} else if (iNoOfLines > 1) {
						sUIElmId = "_slui_txtInput_txtara_" + sParentId + "_p_" + sId;
						oUIControl = new suc.TextArea(sUIElmId, {layoutData: new sap.ui.layout.GridData({span: "L6 M6 S12", linebreak: false})});
						oUIControl.setRows(iNoOfLines);
					} else {
						sUIElmId = "_slui_txtInput_norm_" + sParentId + "_p_" + sId;
						oUIControl = new suc.TextField(sUIElmId, {layoutData: new sap.ui.layout.GridData({span: "L6 M6 S12", linebreak: false})});
					}
					iMaxCharLength = this._convertStringToInteger(attrMap, "maxCharLength", 900);
					oUIControl.setMaxLength(iMaxCharLength);
					break;
				case suiCnst.SLP_DIA_ATTR_TXTINP_DATE:
					sUIElmId = "_slui_txtInput_date_" + sParentId + "_p_" + sId;
					oUIControl = new suc.DatePicker(sUIElmId, {layoutData: new sap.ui.layout.GridData({span: "L6 M6 S12"})});
					break;
				case suiCnst.SLP_DIA_ATTR_TXTINP_NUMB:
					sUIElmId = "_slui_txtInput_num_" + sParentId + "_p_" + sId;
					oUIControl = new suc.TextField(sUIElmId, {layoutData: new sap.ui.layout.GridData({span: "L6 M6 S12"})});
					break;
				case suiCnst.SLP_DIA_ATTR_TXTINP_HTML:
					//Change id
					sUIElmId = "_slui_txtInput_html_" + sParentId + "_p_" + sId;
					oUIControl = new suc.TextField(sUIElmId, {layoutData: new sap.ui.layout.GridData({span: "L6 M6 S12"})});
					break;
				case suiCnst.SLP_DIA_ATTR_TXTINP_TIME:
					sUIElmId = "_slui_txtInput_time_" + sParentId + "_p_" + sId;
					oUIControl = new suc.TextField(sUIElmId, {layoutData: new sap.ui.layout.GridData({span: "L6 M6 S12"})});
					break;
				case suiCnst.SLP_DIA_ATTR_TXTINP_DIRECTORY:
					filter = "$filter=type%20eq%20%27slp.fileSystemEntryType.DIRECTORY%27";
				case suiCnst.SLP_DIA_ATTR_TXTINP_FILE:
					if (endswith) {
						filter = (filter ? filter + "%20and" : "$filter=type%20eq%20%27slp.fileSystemEntryType.DIRECTORY%27%20or");
						endswith.split("/").forEach(function(elem, idx){filter += (idx ? "%20or" : "") + "%20endswith(name,%27" + elem + "%27)";});
					}
					bShftLft = this._convertStringToBoolean(attrMap, "leftShift", false);
					sUIElmId = "_slui_txtInput_norm_" + sParentId + "_p_" + sId;
					var sItem = sType.slice(0, sType.length-5);
					oUIControl = new SLUIFileBrowser(sUIElmId, sType, new sap.ui.layout.GridData({span: "L6 M6 S12", linebreak: false}), "Select a "+sItem, filter);
					iMaxCharLength = this._convertStringToInteger(attrMap, "maxCharLength", 900);
					oUIControl.setMaxLength(iMaxCharLength);				
					break;				
			}
			// attach SUBMIT action on ENTER key event if appropriate
			if (typeof oUIControl.onsapenter === "function") oUIControl.addEventDelegate({onsapenter: function() {oStub.oFather.getView().vExeCont.doSubmitAction();}});
			
			var childElements = oUIElmModel.childNodes;
			for (var j = 0; j < childElements.length; j++) {
				var obj = childElements[j];
				switch (obj.localName ? obj.localName : obj.nodeName) {
					case suiCnst.SLP_DIA_ATTR_TOOLTIP:
						oUIControl.setTooltip(this._replaceCDATA(obj.textContent));
						break;
					case suiCnst.SLP_DIA_ATTR_INFO_DESC:
						oUIControlInfoPopUp = new suc.RichTooltip({	text: 	this._replaceCDATA(obj.textContent),
																	title: 	suiCnst.SLP_DIA_ATTR_INFO_MORE			});
						oUIControlInfoBtn = new suc.Image({			width: 	"20px",
																	src: 	suiCnst.UI_FILE_PATH_SLUI_ROOTPATH + suiCnst.UI_FILE_PATH_TASK_STATE + "/info.png"	});
						oUIControlInfoBtn.setTooltip(oUIControlInfoPopUp);
						break;
					case suiCnst.SLP_DIA_CAPTION:
						sLabel = this._replaceCDATA(obj.textContent);
						if (bShftLft) oUIControlLabel = new suc.Label(sUIElmId + "_lbl", {	
															width: 			addData.labelWidth,
															layoutData: 	new sap.ui.layout.GridData({span: "L3 M4 S6", linebreak:true})
														}).setWrapping(true);
						else oUIControlLabel = new suc.Label(sUIElmId + "_lbl", {
															width: 			addData.labelWidth,
															layoutData: 	new sap.ui.layout.GridData({span: "L3 M4 S6", linebreak:true})
														}).setWrapping(true);
						oUIControlLabel.addStyleClass("displayLabelInLeft");
						oUIControlLabel.setText(sLabel);
						break;
					case suiCnst.SLP_DIA_DEF_VALUE:
						var sStr = this._replaceCDATA(obj.textContent);
						oUIControl.setValue(sStr);
						break;
					case suiCnst.SLP_DIA_VALUE:
						sStr = this._replaceCDATA(obj.textContent);
						oUIControl.setValue(sStr);
						break;
					case suiCnst.SLP_DIA_VAL_MSG:
						break;
					case suiCnst.SLP_DIA_ATTR_CLIENT_REG_EXP:
						sap.ui.getCore().byId(suiCnst.UI_ID_HOME_SCREEN).vExeWizd._uiRegex[sUIElmId] = {
							"label": 	sLabel,
							"regex": 	obj.textContent,
							"id":		sUIElmId
						};
						break;
					case suiCnst.SLP_DIA_ATTR_CLIENT_EVENT_REF:
						oERef = obj;
						break;
					case suiCnst.SLP_DIA_DEF_PATTERN :
						sap.ui.getCore().byId(sUIElmId).setLayoutData(new sap.ui.layout.GridData({span: "L3 M2 S6"}));
						oUIControlLink = new suc.Link(sUIElmId + "_refLink", {
							text: "Default Path",
							press: function(e) {
								if (e) {e.preventDefault();}
								sap.ui.getCore().byId(sUIElmId).setValue(obj.textContent);
							},
							layoutData: new sap.ui.layout.GridData({span: "L1 M2 S6"})
						});
						break;
				}
			}
			sToolTip = oUIControl.getTooltip();
			oUIControl.attachChange(function() {
				oThis.triggerClientSideValidation(sUIElmId, oUIControl, attrMap, sToolTip);
				if (oStub.oFather.oProcExe.oUIProc.paramInDrtState[sUIElmId] == false) oThis.triggerRegExpValidation(sUIElmId, oUIControl, attrMap, sToolTip, sap.ui.getCore().byId(suiCnst.UI_ID_HOME_SCREEN).vExeWizd.uiRegex);
				oThis.triggerClientEventReference(sUIElmId, oERef);
			});
			this._setControlWidth(oUIControl, attrMap, "300px");
			this._makeControlVisible(oUIControl, oUIControlLabel, oUIObject, oUIControlInfoPopUp, attrMap);
			this._makeControlEnable(oUIControl, attrMap);
			this._makeControlEditable(oUIControl, attrMap);
			if (oUIControlLabel) {
				oUIObject.setLabel(oUIControlLabel);
				oUIControlLabel.setLabelFor(oUIControl);
			}
			if (oUIControl) {
				if (bShftLft) {
					var oLytH = new sap.ui.layout.HorizontalLayout({
						width: 			"100%",
						allowWrapping: 	false,
						layoutData: 	new sap.ui.layout.GridData({span: "L12 M12 S12", linebreak: false})
					});
					oLytH.addContent(oUIControlLabel);
					oLytH.addContent(oUIControl);
					if (oUIControlInfoBtn) oLytH.addContent(oUIControlInfoBtn);
					if (oUIControlLink) oLytH.addContent(oUIControlLink);
					oUIObject.insertField(oLytH);
				} else {
					if (oUIControlInfoBtn) oUIObject.insertField(oUIControlInfoBtn);
					if (oUIControlLink) oUIObject.insertField(oUIControlLink);
					oUIObject.insertField(oUIControl);
				}
			}
            if (attrMap.getNamedItem("required") && (attrMap.getNamedItem("required").value === "false")) oUIControl.setRequired(false);
            else {
                            attrMap.getNamedItem("required").value = true;
                            oUIControl.setRequired(true);
            }
            if (cnfInput && this._convertStringToBoolean(attrMap, "visible", true)) {
                            //render another duplicate object and attach validation 
                            var obj = this._renderDuplicateField(sLabel, oUIControl, addData, attrMap);
                            if (obj) this.cnfObj = obj;
            }
            this._mapUIControlIdToParamId(paramMap, sId, sUIElmId, attrMap);
            return oUIObject;
		} 
		else this.oFather.oLogger.logE("SLUITextinput::Without parent id or self id - It's not possible to render the control.");
	}
	return null;
};

SLUISimpleUIRenderers.prototype._renderDuplicateField = function(sLabel, oSourceControl, addData,attrMap) {
	if (oSourceControl) {
		var suc = sap.ui.commons;
		var oUIObject = new suc.form.FormElement();
		sUIElmId = "_slui_cnfInput_p_"+oSourceControl.getId();
		$(oSourceControl).attr("refConfirmControlId", sUIElmId);
		var oUIControl = new suc.PasswordField(sUIElmId, {layoutData: new sap.ui.layout.GridData({span: "L6 M6 S12", linebreak: false})});
		// if this clone is a secure field (e.g. password), copy the value from the source
		if (this._convertStringToBoolean(attrMap, "secure", false)) {
		    oUIControl.setValue(oSourceControl.getValue());
		    oSourceControl.onfocusin = function(e) {oSourceControl.setValue(""); oUIControl.setValue("");};
		    oUIControl.onfocusin = function(e) {oUIControl.setValue("");};
		}
		oUIControl.setTooltip(oSourceControl.getTooltip_AsString());
	        var oUIControlLabel = new suc.Label(sUIElmId + "_lbl", {layoutData: new sap.ui.layout.GridData({span: "L3 M4 S6", linebreak: true})}).setWrapping(true); 	// gap between label and field will be less,
	        oUIControlLabel.addStyleClass("displayLabelInLeft");
			oUIControlLabel.setText(oBundle.getText("CNF_LBL_TXT") + " : " + sLabel);
			if (oUIControlLabel) {
				$(oUIControl).attr("lblValue", sLabel);
				oUIObject.setLabel(oUIControlLabel);
			}
			oUIControl.attachLiveChange(function(e) {								//live validation 
				if (e) {
					var tarId = e.getSource().sId;
					var tarVal  = e.getParameters().liveValue;
					if (tarId) {
						var srcId = tarId.replace("_slui_cnfInput_p_","");
						if (srcId) {
							var srcCntrl =  sap.ui.getCore().byId(srcId);
							if (srcCntrl) {
								var lblVal = $(e.getSource()).attr("lblValue").toString();
								var srcVal = srcCntrl.getValue();
								if (srcVal === tarVal) {
									e.getSource().setValueState(sap.ui.core.ValueState.None);
									e.getSource().setTooltip(lblVal);
									oThis._setDirtyExecution(srcId, false);
									oThis._setDirtyExecution(tarId, false);
								} else {
									e.getSource().setTooltip(new suc.RichTooltip({text: oBundle.getText("CNF_OF_LBL_TXT") + " " + lblVal + " " + oBundle.getText("INVALID_LBL_TXT")}));
									e.getSource().setValueState(sap.ui.core.ValueState.Error);
									oThis._setDirtyExecution(srcId, true);
									oThis._setDirtyExecution(tarId, true);
								}
							}
						}
					}
				}
			});
			oUIControl.setWidth(oSourceControl.getWidth());
			if (attrMap.getNamedItem("required")) {
				attrMap.getNamedItem("required").value = true;
				oUIControl.setRequired(true);
			}
			oUIControl.addEventDelegate({onsapenter: function() {oStub.oFather.getView().vExeCont.doSubmitAction();}}); 	// attach SUBMIT action on ENTER key event
			oUIObject.insertField(oUIControl);
			return oUIObject;
		} 
		else this.oFather.oLogger.logE("SLUIConfirmInput::Without parent object control.");
	return null;
};

SLUISimpleUIRenderers.prototype._renderTextView = function(oUIElmModel, paramMap, addData) {
	var suc = sap.ui.commons;
	if (oUIElmModel) {
		var attrMap = oUIElmModel.attributes;
		var sId = 					null,
			sParentId = 			null,
			sUIElmId = 				null,
			sType = 				null,
			sBehaviour = 			null,
			bHTMLEnabled = 			null,
			sLabel = 				null;
		var oUIObject = 			null,
			oUIControl = 			null,
			oUIControlLabel = 		null,
			oUIControlInfoBtn = 	null,
			oUIControlInfoPopUp = 	null;
		var oCrypto = window.crypto || window.msCrypto;
		sId = this._checkForId(attrMap);
		if (!sId) {
			if (oCrypto) sId = oCrypto.getRandomValues(new Uint32Array(1))[0];
			else sId = Math.random();
		}
		sParentId = this._checkForParentId(attrMap);
		if (sParentId) {
			oUIObject = new suc.form.FormElement();
			oUIObject.setLayoutData(new sap.ui.layout.GridData({span: "L11 M12 S12"}));
			sType = this._checkAttributeExistence(attrMap, "type") ? attrMap["type"].value : "standardTextView";
			bHTMLEnabled = this._convertStringToBoolean(attrMap, "htmlEnabled", false);
			if (bHTMLEnabled) {
				sUIElmId = "_slui_txtView_html_" + sParentId + "_p_" + sId;
				oUIControl = new sap.ui.core.HTML(sUIElmId);
				oUIControl.setSanitizeContent(true);
			} else {
				sUIElmId = "_slui_txtView_norm_" + sParentId + "_p_" + sId;
				oUIControl = new suc.TextView(sUIElmId).setTextAlign(sap.ui.core.TextAlign.Left);
				oUIControl.setLayoutData(new sap.ui.layout.GridData({span: "L8 M10 S12"}));
				switch (sType) {
					case "standardTextView":
						oUIControl.setSemanticColor(suc.TextViewColor.Default);
						break;
					case "informationView":
						oUIControl.setSemanticColor(suc.TextViewColor.Default);
						break;
					case "errorView":
						oUIControl.setSemanticColor(suc.TextViewColor.Negative);
						break;
					case "warningView":
						oUIControl.setSemanticColor(suc.TextViewColor.Critical);
						break;
					case "successView":
						oUIControl.setSemanticColor(suc.TextViewColor.Positive);
				}
				sBehaviour = this._checkAttributeExistence(attrMap, "behaviour") ? attrMap["behaviour"].value : "normal";
				switch (sBehaviour) {
					case "normal":
						oUIControl.setDesign(suc.TextViewDesign.Standard);
						break;
					case "h1":
						oUIControl.setDesign(suc.TextViewDesign.H1);
						break;
					case "h2":
						oUIControl.setDesign(suc.TextViewDesign.H2);
						break;
					case "h3":
						oUIControl.setDesign(suc.TextViewDesign.H3);
						break;
					case "h4":
						oUIControl.setDesign(suc.TextViewDesign.H4);
						break;
					case "h5":
						oUIControl.setDesign(suc.TextViewDesign.H5);
						break;
					case "h6":
						oUIControl.setDesign(suc.TextViewDesign.H6);
						break;
					case "bold":
						oUIControl.setDesign(suc.TextViewDesign.Bold);
						break;
					case "italics":
						oUIControl.setDesign(suc.TextViewDesign.Italic);
						break;
					case "underlined":
						oUIControl.setDesign(suc.TextViewDesign.Underline);
				}
				this._makeControlEnable(oUIControl, attrMap);
				this._makeControlWraped(oUIControl, attrMap);
			}
			var childElements = oUIElmModel.childNodes;
			if (childElements.length > 0) {
				for (var j = 0; j < childElements.length; j++) {
					var obj = childElements[j];
					switch ((obj.localName) ? obj.localName : obj.nodeName) {
						case suiCnst.SLP_DIA_ATTR_TOOLTIP:
							oUIControl.setTooltip(this._replaceCDATA(obj.textContent));
							break;
						case suiCnst.SLP_DIA_CAPTION:
							sLabel = this._replaceCDATA(obj.textContent);
							oUIControlLabel = new suc.Label(sUIElmId + "_lbl", {layoutData: new sap.ui.layout.GridData({span: "L11 M12 S12", linebreak: false})});
							oUIControlLabel.setText(sLabel); 
							break;
						case suiCnst.SLP_DIA_VALUE:
							var sStr;
							if (bHTMLEnabled) {
				                if (obj.innerHTML === undefined && oStub.oFather.execVwProps["executionWithPost"] != true) {
	                                var oXMlSerializer =  new XMLSerializer();
	                                sStr = oXMlSerializer.serializeToString(obj);
	                                str = sStr.replace("<value>","");
	                                str = sStr.replace("</value>","");
				                } 
				                else sStr = this._replaceCDATA(obj.innerHTML);
								if (!sStr) sStr = this._replaceCDATA(obj.textContent);
								if (sStr) {
									while (sStr.indexOf("]]>") > -1) sStr = sStr.replace("]]>", "");
									while (sStr.indexOf("&amp;nbsp;") > -1) sStr = sStr.replace("&amp;nbsp;", " ");
									if (sStr.indexOf("<html>") == -1) sStr = "<html><div>" + sStr + "</div></html>";
									else sStr = sStr.replace("<html>", "<html><div>").replace("</html>", "</div><html>");
									while (sStr.indexOf("<br/>") > -1) sStr = sStr.replace("<br/>", "<br></br>");
									while (sStr.indexOf("<p/>") > -1) sStr = sStr.replace("<p/>", "<p></p>");
									sStr = this._generateNoteAsLink(sStr);
									oUIControl.setContent(sStr);
									txtVal = sStr;
								}
							} else {
								sStr = this._replaceCDATA(obj.textContent);
								oUIControl.setText(sStr);
								txtVal = sStr;
							}
					}
				}
			}
			if (bHTMLEnabled) {
				this._makeControlVisible(null, oUIControlLabel, oUIObject, oUIControlInfoPopUp, attrMap);	
				var bVisible = this._convertStringToBoolean(attrMap, "visible", true);		//handling custom visiblity
			}
			else this._makeControlVisible(oUIControl, oUIControlLabel, oUIObject, oUIControlInfoPopUp, attrMap);	
			if (oUIControlLabel) oUIObject.setLabel(oUIControlLabel);
			if (oUIControlInfoBtn) oUIObject.insertField(oUIControlInfoBtn);
			if (oUIControl) oUIObject.insertField(oUIControl);
			this._mapUIControlIdToParamId(paramMap, sId, sUIElmId, attrMap);
			return oUIObject;
		} 
		else this.oFather.oLogger.logE("SLUITextview: It's not possible to render the control without parent id.");
	}
	return null;
};

SLUISimpleUIRenderers.prototype._renderRelatedLinks = function(oUIElmModel, paramMap,addData) {
	var suc = sap.ui.commons;
	if (oUIElmModel) {
		var attrMap = 				oUIElmModel.attributes;
		var oUIObject = 			null,
			oUIControl = 			null,
			oUIControlLabel = 		null,
			oUIControlInfoBtn = 	null,
			oUIControlInfoPopUp = 	null;
		var sId = 					null,
			sParentId = 			null,
			sUIElmId = 				null,
			sType = 				null,
			sLabel = 				null;
		var sUrlStore;

		var oCrypto = window.crypto || window.msCrypto;
		sId = this._checkForId(attrMap);
		if (!sId) {
			if (oCrypto) sId = oCrypto.getRandomValues(new Uint32Array(2))[0];
			else sId = Math.random();
		}
		sParentId = this._checkForParentId(attrMap);
		if (sParentId) {
			oUIObject = new suc.form.FormElement();
			sType = this._checkAttributeExistence(attrMap, "type") ? attrMap["type"].value : "link";
			//Change id
			sUIElmId = "_slui_rellink_" + sParentId + "_p_" + sId;
			oUIControl = new suc.Link(sUIElmId);
			var childElements = oUIElmModel.childNodes;
			if (childElements.length > 0) {
				for (var j = 0; j < childElements.length; j++) {
					var obj = childElements[j];
					switch ((obj.localName) ? obj.localName : obj.nodeName) {
						case suiCnst.SLP_DIA_ATTR_TOOLTIP:
							oUIControl.setTooltip(this._replaceCDATA(obj.textContent));
							break;
						case suiCnst.SLP_DIA_ATTR_INFO_DESC:
							oUIControlInfoPopUp = new suc.RichTooltip({text: this._replaceCDATA(obj.textContent), title: suiCnst.SLP_DIA_ATTR_INFO_MORE});
							oUIControlInfoBtn = new sap.ui.commons.Image({width: "20px", src: suiCnst.UI_FILE_PATH_SLUI_ROOTPATH + suiCnst.UI_FILE_PATH_TASK_STATE + "/info.png"});
							oUIControlInfoBtn.setTooltip(oUIControlInfoPopUp);
							break;
						case suiCnst.SLP_DIA_CAPTION:								//LabelCheck
							sLabel = this._replaceCDATA(obj.textContent);
							oUIControlLabel = new suc.Label(sUIElmId + "_lbl", {wrapping: true, layoutData: new sap.ui.layout.GridData({span: "L8 M10 S12", linebreak: false})});
							oUIControlLabel.setText(this._replaceCDATA(obj.textContent));
							break;
						case suiCnst.SLP_DIA_VALUE:
							sStr = this._replaceCDATA(obj.textContent);
							oUIControl = SLUISimpleUIRenderers.prototype.generic.setLnkType(oUIControl, sType, sStr);
							break;
						case "urlSource":
							var sStr = this._replaceCDATA(obj.textContent);
							if (obj.textContent.indexOf("http") < 0) obj.textContent = "http://" + sStr;
							sUrlStore = obj.textContent;
							oUIControl.attachPress(function() {window.open(sUrlStore);});
					}
				}
			}
			this._makeControlEnable(oUIControl, attrMap);
			this._setControlWidth(oUIControl, attrMap, "100%");
			this._makeControlVisible(oUIControl, oUIControlLabel, oUIObject, oUIControlInfoPopUp, attrMap); 	// check for visibility of the control
			if (oUIControlLabel) oUIObject.setLabel(oUIControlLabel);
			if (oUIControlInfoBtn) oUIObject.insertField(oUIControlInfoBtn);
			oUIObject = SLUISimpleUIRenderers.prototype.generic.prefixLnkLogo(oUIObject, oUIControl, sType, "insert");
			this._mapUIControlIdToParamId(paramMap, sId, sUIElmId, attrMap);
			return oUIObject;
		} 
		else this.oFather.oLogger.logE("SLUIRelatedLink::With out parent id or self id - Its not possible to render the control.");
	}
	return null;
};

SLUISimpleUIRenderers.prototype.generic = {
	prefixLnkLogo: function(oUIObject, oUIControl, sType, layoutType) {
		switch (sType) {
			case suiCnst.SLP_DIA_ATTR_LINK_RENDERER_REPORT:
			case suiCnst.SLP_DIA_ATTR_LINK_RENDERER_LINK:
				if (oUIControl) {
					if (layoutType == "add") oUIObject.addContent(oUIControl);
					else oUIObject.insertField(oUIControl);
				}
				break;
			case suiCnst.SLP_DIA_ATTR_LINK_RENDERER_SAPNOTE:
				var oHlayt = new sap.ui.commons.layout.HorizontalLayout();
				oHlayt.addContent(new sap.ui.commons.Image({width: "16px", src: suiCnst.UI_FILE_PATH_SLUI_ROOTPATH + suiCnst.UI_FILE_PATH_UILINK + "/sapnote.png"}));
				if (oUIControl) oHlayt.addContent(oUIControl);
				if (oHlayt) {
					if (layoutType == "add") oUIObject.addContent(oHlayt);
					else oUIObject.insertField(oHlayt);
				}
				break;
			case suiCnst.SLP_DIA_ATTR_LINK_RENDERER_SAPHELP:
				var oHlayt = new sap.ui.commons.layout.HorizontalLayout();
				oHlayt.addContent(new sap.ui.commons.Image({width: "16px", src: suiCnst.UI_FILE_PATH_SLUI_ROOTPATH + suiCnst.UI_FILE_PATH_UILINK + "/saphelp.png"}));
				if (oUIControl != undefined) oHlayt.addContent(oUIControl);
				if (oHlayt) {
					if (layoutType == "add") oUIObject.addContent(oHlayt);
					else oUIObject.insertField(oHlayt);
				}
				break;
			case suiCnst.SLP_DIA_ATTR_LINK_RENDERER_DOWNLOAD:
				var oHlayt = new sap.ui.commons.layout.HorizontalLayout();
				oHlayt.addContent(new sap.ui.commons.Image({width: "16px", src: suiCnst.UI_FILE_PATH_SLUI_ROOTPATH + suiCnst.UI_FILE_PATH_UILINK + "/download.png"}));
				if (oUIControl != undefined) oHlayt.addContent(oUIControl);
				if (oHlayt) {
					if (layoutType == "add") oUIObject.addContent(oHlayt);
					else oUIObject.insertField(oHlayt);
				}
		}
		return oUIObject;
	},
	setLnkType: function(oUIControl, sType, text) {
		switch (sType) {
			case suiCnst.SLP_DIA_ATTR_LINK_RENDERER_REPORT:
			case suiCnst.SLP_DIA_ATTR_LINK_RENDERER_LINK:
				oUIControl.setText(text);
				break;
			case suiCnst.SLP_DIA_ATTR_LINK_RENDERER_SAPNOTE:
				oUIControl.setText(oBundle.getText("NOTE_LINK_TXT")+ " " + text);
				break;
			case suiCnst.SLP_DIA_ATTR_LINK_RENDERER_SAPHELP:
				oUIControl.setText(oBundle.getText("HELP_LINK_TXT")+ " " + text);
				break;
			case suiCnst.SLP_DIA_ATTR_LINK_RENDERER_DOWNLOAD:
				oUIControl.setText(oBundle.getText("DLOAD_LINK_TXT")+ " " + text);
		}
		return oUIControl;
	}
};

SLUISimpleUIRenderers.prototype._renderValueSelectorGroupView = function(oUIElmModel, paramMap, addData) {
	var suc = sap.ui.commons;
	if (oUIElmModel) {
		var attrMap = 			oUIElmModel.attributes;
		var sId = 					null,
			sParentId = 			null,
			sUIElmId = 				null,
			sSelectionType = 		null,
			sChildType = 			null,
			sLayoutType = 			null,
			sLabel = 				null;
		var groupName = 			null,
			iSelectedIndex = 		null,
			sParentEnable =		 	null,
			iColumnCount = 			0,
			oEvRef = 				null;
		var oUIObject = 			null,
			oUIControl = 			null,
			oUIControlLabel = 		null,
			oUIControlInfoBtn = 	null,
			oUIControlInfoPopUp = 	null;
		var bShftLft = this._convertStringToBoolean(attrMap, "leftShift", false);
		sId = this._checkForId(attrMap);
		sParentId = this._checkForParentId(attrMap);
		if (sId && sParentId) {
			oUIObject = new suc.form.FormElement();
			sSelectionType = this._checkAttributeExistence(attrMap, "selectionType") ? attrMap["selectionType"].value : "singleSelection";
			sChildType = this._checkAttributeExistence(attrMap, "childType") ? attrMap["childType"].value : sSelectionType === "singleSelection" ? "radioButton" : "checkBox";
			iSelectedIndex = this._convertStringToInteger(attrMap, "selectedIndex", 0);
			sParentEnable = this._convertStringToBoolean(attrMap, "enable", true);
			sLayoutType = this._checkAttributeExistence(attrMap, "layoutType") ? attrMap["layoutType"].value : "horizontal";
			if (sLayoutType === "horizontal") iColumnCount = this._convertStringToInteger(attrMap, "noOfColumns", 1);
			else if (sLayoutType === "vertical") iColumnCount = 1;
			else iColumnCount = this._convertStringToInteger(attrMap, "noOfColumns", 1);
			switch (sChildType) {
				case "radioButton":
					sUIElmId = "_slui_valSelGrp_radioBtn_" + sParentId + "_p_" + sId;
					oUIControl = new suc.RadioButtonGroup(sUIElmId, {
						width: 				"100%",
						layoutData: 		new sap.ui.layout.GridData({span: "L11 M12 S12"}),
						ariaDescribedBy: 	oBundle.getText("F2_LBL_TXT"),
						layoutFixed: 		false,
						select: function(event) {
							$(oUIControl).attr("selectedValue", event.oSource.getSelectedItem().getKey());
							oThis.triggerClientEventReference(sUIElmId, oEvRef);
						}
					});
					var selIndx = oUIControl.getSelectedIndex();
					this.UIElmIDColl.push(sUIElmId);
//					if ($(oUIControl).is(':checked') == true) oThis.triggerClientEventReference(sUIElmId, oEvRef);
					oUIControl.addEventDelegate({
						onAfterRendering: function(evt) {
							this.triggerClientEventReference(sUIElmId, oEvRef); 
					}}, oThis);
					break;
				case "dropDown":
					sUIElmId = "_slui_valSelGrp_dropDown_" + sParentId + "_p_" + sId;
					oUIControl = new suc.DropdownBox(sUIElmId, {layoutData: new sap.ui.layout.GridData({span: "L6 M6 S12"})});
					this.UIElmIDColl.push(sUIElmId);
					break;
				case "checkBox":
					sUIElmId = "_slui_valSelGrp_checkBtn_" + sParentId + "_p_" + sId;
					oUIControl = new suc.layout.MatrixLayout(sUIElmId, {layoutData: new sap.ui.layout.GridData({span: "L11 M12 S12"})});
					this.UIElmIDColl.push(sUIElmId);
					if (iColumnCount != -1) oUIControl.setColumns(iColumnCount);
					groupName = "_slui_valSelGrp_checkBtn_" + sParentId + "_p_" + sId;
					break;
				case "listBox":
					sUIElmId = "_slui_valSelGrp_listDown_" + sParentId + "_p_" + sId;
					oUIControl = new suc.ListBox(sUIElmId, {layoutData: new sap.ui.layout.GridData({span: "L11 M12 S12"})});
					this.UIElmIDColl.push(sUIElmId);
					oUIControl.setAllowMultiSelect(true);
					oUIControl.setSelectedIndex(iSelectedIndex);
			}
			var childElements = oUIElmModel.childNodes;
			if (childElements.length > 0) {
				for (var j = 0; j < childElements.length; j++) {
					var obj = childElements[j];
					switch (obj.localName ? obj.localName : obj.nodeName) {
						case suiCnst.SLP_DIA_ATTR_TOOLTIP:
							oUIControl.setTooltip(this._replaceCDATA(obj.textContent));
							break;
						case suiCnst.SLP_DIA_ATTR_INFO_DESC:
							oUIControlInfoPopUp = new sap.ui.commons.RichTooltip({text: this._replaceCDATA(obj.textContent), title: suiCnst.SLP_DIA_ATTR_INFO_MORE});
							oUIControlInfoBtn = new sap.ui.commons.Image({width: "20px", src: suiCnst.UI_FILE_PATH_SLUI_ROOTPATH + suiCnst.UI_FILE_PATH_TASK_STATE + "/info.png"});
							oUIControlInfoBtn.setTooltip(oUIControlInfoPopUp);
							break;
						case suiCnst.SLP_DIA_CAPTION:
							if (obj.textContent != "") {
								sLabel = this._replaceCDATA(obj.textContent);
								if (sChildType === "radioButton" || sChildType === "checkBox") oUIControlLabel = new sap.ui.commons.Label(sUIElmId + "_lbl", {wrapping:true, layoutData: new sap.ui.layout.GridData({span: "L12 M12 S12", linebreak: true})}).setWrapping(true);
								else {
									if (bShftLft === true) oUIControlLabel = new sap.ui.commons.Label(sUIElmId + "_lbl", {wrapping:true, layoutData: new sap.ui.layout.GridData({span: "L1 M12 S12", linebreak: false})}).setWrapping(true);
									else oUIControlLabel = new sap.ui.commons.Label(sUIElmId + "_lbl", {wrapping:true, layoutData: new sap.ui.layout.GridData({span: "L2 M12 S12", linebreak: false})}).setWrapping(true);
								}
								oUIControlLabel.setText(this._replaceCDATA(obj.textContent));
							}
							break;
						case suiCnst.SLP_DIA_VAL_MSG:
							break;
						case suiCnst.SLP_DIA_ATTR_CLIENT_REG_EXP:
							break;
						case suiCnst.SLP_DIA_ATTR_CLIENT_EVENT_REF:
							oEvRef = obj;
							break;
						case "selectorValueProvider":
							var valueProviders = obj.childNodes;
							var cUiObjs = [];
							var oSelIndx = {};
							var iNodeCnt = 0;
							if (valueProviders && valueProviders.length > 0) {
								for (var i = 0; i < valueProviders.length; i++) {
									var sname = (valueProviders[i].localName) ? valueProviders[i].localName : valueProviders[i].nodeName;
									if (sname === "#text") continue;
									var instances = valueProviders[i].childNodes;
									var bItemEnable = this._convertStringToBoolean(valueProviders[i].attributes, "enable", true);
									var sText = null,
										sValue = null,
										sInfoDescription = null;
									for (var k = 0; k < instances.length; k++) {
										obj = instances[k];
										switch (obj.localName ? obj.localName : obj.nodeName) {
											case suiCnst.SLP_DIA_CAPTION:
												sText = this._replaceCDATA(obj.textContent);
												break;
											case suiCnst.SLP_DIA_VALUE:
												sValue = this._replaceCDATA(obj.textContent);
												break;
											case suiCnst.SLP_DIA_ATTR_INFO_DESC:
												sInfoDescription = this._replaceCDATA(obj.textContent);
										}
									}
									if (sValue == null || sValue.trim() === "") sValue = valueProviders[i]["id"];
									if ((iSelectedIndex < 0) && valueProviders[i]) {
										var attrColl = valueProviders[i].attributes;
										if (attrColl && attrColl.length > 0) {
											var selNde = valueProviders[i].attributes["selected"];
											if (selNde && (selNde.textContent === "true")) iSelectedIndex = i;
										}
									}								
									if (oUIControl.sId.indexOf("_slui_valSelGrp_radioBtn_") > -1) {
										var oPopUp;
										if (sInfoDescription) oPopUp = new sap.ui.commons.RichTooltip({text: sInfoDescription, title: oBundle.getText("DIA_HDR_INFO_TXT")});
										oUIControl.addItem(new sap.ui.core.Item({
											text: 		sText,
											tooltip: 	sInfoDescription ? oPopUp : sText,
											key: 		sValue,
											enabled: 	sParentEnable
										}));
										oUIControl.setSelectedIndex(iSelectedIndex);
										$(oUIControl).trigger("select");
									} else if (oUIControl.sId.indexOf("_slui_valSelGrp_checkBtn_") > -1) {
										var cell = new sap.ui.commons.layout.MatrixLayoutCell();
										sUIElmId = groupName + "_k_" + sValue;
										var elmId = sUIElmId.replace(/\s+/g, "");
										cell.addContent(new sap.ui.commons.CheckBox(elmId, {
											text: 		sText,
											tooltip: 	sText,
											groupName: 	groupName,
											checked: 	(iSelectedIndex === i),
											enabled: 	sParentEnable,
											change: function(event) {
												var valueString = "";
												if ($(oUIControl).attr("selectedValue")) {
													var pVal = $(oUIControl).attr("selectedValue").toString();
													if (pVal.indexOf(event.oSource.getText()) > -1) {
														if (!event.oSource.getChecked()) valueString = pVal.replace(event.oSource.getText() + "|", "");
													} 
													else if (event.oSource.getChecked()) valueString = pVal + event.oSource.getText() + "|";
												} 
												else if (event.oSource.getChecked()) valueString = event.oSource.getChecked();
												$(oUIControl).attr("selectedValue", valueString);
												oThis.triggerClientEventReference(sUIElmId, oEvRef, event);
											}
										}));
										var childElm = oUIControl.childElements ? (oUIControl.childElements) : "";
										childElm += "|" + elmId;
										$(oUIControl).attr("childElements", childElm);
										cUiObjs.push(cell);
									} else if (oUIControl.sId.indexOf("_slui_valSelGrp_dropDown_") > -1) {
										oUIControl.addItem(new sap.ui.core.ListItem({
											text: 		sText,
											enabled: 	bItemEnable,
											tooltip: 	sText,
											key: 		sValue
										}));
										if (iSelectedIndex == i) oUIControl.setSelectedKey(sValue);
									} else if (oUIControl.sId.indexOf("_slui_valSelGrp_listDown_") > -1) {
										oUIControl.addItem(new sap.ui.core.ListItem({
											text: 		sText,
											tooltip: 	sText,
											key: 		sValue
										}));
										if (iSelectedIndex == i) oUIControl.setSelectedIndex(i);
									}
									iNodeCnt++;
								}
							}
							// render into Layout
							if ((cUiObjs.length > 0) && (oUIControl.sId.indexOf("_slui_valSelGrp_checkBtn_") > -1)) {
								var mover = iColumnCount;
								var row = null;
								for (var l = 0; l < cUiObjs.length; l++) {
									if (l % iColumnCount === 0) row = new sap.ui.commons.layout.MatrixLayoutRow({});
									row.addCell(cUiObjs[l]);
									if (!(--mover) || (cUiObjs.length == l + 1)) {
										oUIControl.addRow(row);
										mover = iColumnCount;
									}
								}
							}
					}
				}
			}
			if (oUIControl.sId.indexOf("radioBtn") > -1) {
				var oUISelControl = oUIControl.getSelectedItem(); 
				if (oUISelControl && oEvRef) oThis.triggerClientEventReferenceInitial(sUIElmId, oEvRef, oUISelControl, addData.parentVisible);
			}
			if (oUIControl.sId.indexOf("checkBtn") > -1) {
				var oUISelControl = sap.ui.getCore().byId(elmId);	 
				if (oUISelControl != null && oEvRef != null) oThis.triggerClientEventReferenceInitial(sUIElmId, oEvRef, oUISelControl, addData.parentVisible);
			}
			this._setControlWidth(oUIControl, attrMap, "100%");
			this._makeControlVisible(oUIControl, oUIControlLabel, oUIObject, oUIControlInfoPopUp, attrMap);
			this._makeControlEnable(oUIControl, attrMap);
			this._makeControlRequired(oUIControlLabel, attrMap);
			if (oUIControlLabel) oUIObject.setLabel(oUIControlLabel);
			if (oUIControl) {
				if (bShftLft === true) {
					var oLytH = new sap.ui.layout.HorizontalLayout({allowWrapping: true, layoutData: new sap.ui.layout.GridData({span: "L11 M12 S12", linebreak: true})});
					oLytH.addContent(oUIControlLabel);
					if (oUIControlInfoBtn) oLytH.addContent(oUIControlInfoBtn);
					oLytH.addContent(oUIControl);
					oUIObject.insertField(oLytH);
				} else {
					if (oUIControlInfoBtn) oUIObject.insertField(oUIControlInfoBtn);
					oUIObject.insertField(oUIControl);
				}
			}
			this._mapUIControlIdToParamId(paramMap, sId, sUIElmId, attrMap);
			return oUIObject;
		} 
		else this.oFather.oLogger.logE("SLUIValueSelectorGroupView:With out parent id or self id - Its not possible to render the control.");
	}
	return null;
};

SLUISimpleUIRenderers.prototype._renderTableView = function(oUIElmModel, paramMap,addData) {
	var suc = sap.ui.commons;
	var sut = sap.ui.table;
	if (oUIElmModel) {
		var attrMap = 					oUIElmModel.attributes;
		var sId = 						null,
			sParentId = 				null,
			sUIElmId = 					null,
			sSelectionType = 			null,
			iSelectionIndex = 			null;
		var sDynamic = 					null,
			iVisibleRowCount = 			null,
			sRowBinding = 				null,
			sRootTag;
		var sExport = 					null;
		var oTableModel = 				null;
		var oUIObject = 				null,
			oUIControl = 				null,
			oUIControlToolBar = 		null,
			oUIControlAddButton = 		null;
		var oUIControlRemoveButton = 	null,
			oUIControlInfoPopUp = 		null;
		var bTblEdit = 					false;
		var cEdtblAttr = 				["textInput", "fileInput", "directoryInput", "radioButton", "checkBox", "dropDown", "secureInput"];
		sId = this._checkForId(attrMap);
		sParentId = this._checkForParentId(attrMap);
		if (sId && sParentId) {
			oUIObject = new suc.form.FormElement();
			sSelectionType = this._checkAttributeExistence(attrMap, "selectionType") ? attrMap["selectionType"].value : "noSelection";
			sDynamic = this._checkAttributeExistence(attrMap, "dynamic") ? attrMap["dynamic"].value : "none";
			sExport = this._checkAttributeExistence(attrMap, "export") ? attrMap["export"].value : "none";
			iSelectionIndex = this._convertStringToInteger(attrMap, "selectedIndex", 0);
			sRowBinding = this._checkAttributeExistence(attrMap, "rowBinding") ? attrMap["rowBinding"].value : "";
			sRootTag = sRowBinding;
			sUIElmId = "_slui_table" + sParentId + "_p_" + sId;
			oUIControl = new sut.Table(sUIElmId);
			if 		(sSelectionType === "noSelection") 		oUIControl.setSelectionMode(sut.SelectionMode.None);
			else if (sSelectionType === "singleSelection") 	oUIControl.setSelectionMode(sut.SelectionMode.Single);
			else if (sSelectionType === "multiSelection") {
				oUIControl.setSelectionMode(sut.SelectionMode.Multi);
				oUIControl.addEventDelegate({
					onAfterRendering: function(evt) {
						$(this.getModel().getData()).find("Selected").each($.proxy(function(a,b){if ($(b).text()==="true") this.addSelectionInterval(a, a);}, this));
					}
				}, oUIControl);
				oUIControl.attachRowSelectionChange(function(evt) {
					if (evt.getParameter("userInteraction")) {
						var selectArray = this.getModel().getData();
						for (var i = 0; i < selectArray.firstChild.childNodes.length; i++) {$($(selectArray).find("Selected")[i]).text((this.isIndexSelected(i))? "true" : "false");}
						this.getModel().setData(selectArray);						
					}
				});
			}
			if (sSelectionType != "noSelection") oUIControl.setSelectedIndex(parseInt(iSelectionIndex));
			if (sDynamic != "none") {
				oUIControl.setSelectionMode(sut.SelectionMode.Single);
				oUIControlToolBar = new suc.Toolbar("_slui_toolbar" + sParentId + "_p_" + sId);
				oUIControlAddButton = new suc.Button("_slui_toolbar_addbtn" + sParentId + "_p_" + sId, {
					text: 	oBundle.getText("BTN_ADD_TXT"),
					lite: 	true,
					icon: 	suiCnst.UI_FILE_PATH_SLUI_ROOTPATH + suiCnst.UI_FILE_PATH_UITABLE + "/addrow.png",
					press: function() {
						// Code to add a new row
						var iLength = $(oUIControl.getModel().getXML()).find(sRootTag).length;
						oUIControl.setSelectedIndex(iLength - 1);
						oUIControl.setFirstVisibleRow(iLength ? iLength - 1 : 0);
						var cDataXML = oUIControl.getModel().getData();
						var cNode = cDataXML.createElement(sRootTag);
						cDataXML.firstChild.appendChild(cNode);
						oUIControl.getModel().setXML(new XMLSerializer().serializeToString(cDataXML));
						// get All columns
						var cColumns = oUIControl.getColumns();
						var cPath = [];
						for (var c = 0; c < cColumns.length; c++) {
							if 		(cColumns[c].mAggregations.template.mBindingInfos.value != undefined) 		cPath.push(cColumns[c].mAggregations.template.mBindingInfos.value.parts[0].path);
							else if (cColumns[c].mAggregations.template.mBindingInfos.text != undefined) 		cPath.push(cColumns[c].mAggregations.template.mBindingInfos.text.parts[0].path);
							else if (cColumns[c].mAggregations.template.mBindingInfos.checked != undefined) 	cPath.push(cColumns[c].mAggregations.template.mBindingInfos.checked.parts[0].path);
							else if (cColumns[c].mAggregations.template.mBindingInfos.selected != undefined) 	cPath.push(cColumns[c].mAggregations.template.mBindingInfos.selected.parts[0].path);
							else if (cColumns[c].mAggregations.template.mBindingInfos.href != undefined) 		cPath.push(cColumns[c].mAggregations.template.mBindingInfos.href.parts[0].path);
						}
						var cTagList = "";
						for (var p = 0; p < cPath.length; p++) cTagList += "<" + cPath[p] + ">" + "</" + cPath[p] + ">";
						var cXML = oUIControl.getModel().getXML();
						cXML = cXML.replace(new XMLSerializer().serializeToString(jQuery.parseXML("<" + sRootTag + ">" + "</" + sRootTag + ">")), "<" + sRootTag + ">" + cTagList + "</" + sRootTag + ">");
						oUIControl.getModel().setXML(cXML);
						iLength = $(oUIControl.getModel().getXML()).find(sRootTag).length;
						oUIControl.setVisibleRowCount(iLength);
						oUIControl.setFirstVisibleRow(iLength ? iLength - 1 : 0);
						oUIControl.setSelectedIndex(iLength - 1);
					}
				}).setVisible(false);
				oUIControlRemoveButton = new sap.ui.commons.Button("_slui_toolbar_removeBtn" + sParentId + "_p_" + sId, {
					text: 	oBundle.getText("BTN_REM_TXT"),
					lite: 	true,
					icon: 	suiCnst.UI_FILE_PATH_SLUI_ROOTPATH + suiCnst.UI_FILE_PATH_UITABLE + "/removerow.png",
					press: function() {
						var cDataXML = oUIControl.getModel().getData();
						var iIndex = oUIControl.getSelectedIndex();
						if (iIndex === -1) {
							var tmpErr = new SLUIDialogProvider;
							tmpErr.getDialog("infoDialog", oBundle.getText("DIA_DEL_SEL_TXT"), oBundle.getText("DIA_NO_ROW_TXT")).open();
							tmpErr = undefined;
						} else {
							cDataXML.firstChild.removeChild(cDataXML.firstChild.childNodes[iIndex]);
							oUIControl.getModel().setData(cDataXML);
						}
						var iLength = $(oUIControl.getModel().getData()).find("table").length;
						oUIControl.setVisibleRowCount(iLength);
						oUIControl.setFirstVisibleRow(iLength ? iLength - 1 : 0);
						oUIControl.setSelectedIndex(-1);
					}
				}).setVisible(false);
				oUIControlToolBar.addRightItem(oUIControlAddButton);
				oUIControlToolBar.addRightItem(oUIControlRemoveButton);
				oUIControl.setToolbar(oUIControlToolBar);
			}
			if (sExport != "none") {
				if (!oUIControlToolBar) oUIControlToolBar = new suc.Toolbar("_slui_toolbar" + sParentId + "_p_" + sId);
				oUIControlDwnldButton = new suc.Button("_slui_toolbar_dwnldbtn" + sParentId + "_p_" + sId, {
					lite: 	true,
					icon: 	"sap-icon://download",
					press: function() {
						// Code to export table content					    
					    var aColumns = oUIControl.getColumns();
					    var aItems = oUIControl.getRows();
					    var aTemplate = [];
					    for (var i = 0; i < aColumns.length; i++) {
					        var oColumn = {name: aColumns[i].getLabel().getText(), template: {content: {path: null}}};
					        if (aItems.length > 0) oColumn.template.content.path = aItems[0].getCells()[i].getBinding("text") ? aItems[0].getCells()[i].getBinding("text").getPath() : (aItems[0].getCells()[i].getBinding("value") ? aItems[0].getCells()[i].getBinding("value").getPath() : undefined);
					    	aTemplate.push(oColumn);
					    }					    					    
						var oExport = new sap.ui.core.util.Export({  
						    exportType: new sap.ui.core.util.ExportTypeCSV({ separatorChar: ";", charset : "utf-8" }), 	// Type that will be used to generate the content. Own ExportType's can be created to support other formats    
						    models: 	oUIControl.getModel(),
						    rows: 		{path: oUIControl.getBinding("rows").getPath()},
						    columns: 	aTemplate
						});  
						oExport.saveFile().catch(function(oError) {							// download exported file 
							sap.m.MessageBox.error("Error when downloading data. Browser might not be supported!\n\n" + oError);  
						}).then(function() {oExport.destroy();});  
					}
				}).setVisible(false);
				oUIControlToolBar.addRightItem(oUIControlDwnldButton);
				oUIControl.setToolbar(oUIControlToolBar);
			}
			this._setControlWidth(oUIControl, attrMap, "100%");
			var childElements = oUIElmModel.childNodes;
			if (childElements.length > 0) {
				for (var j = 0; j < childElements.length; j++) {
					var obj = childElements[j];
					switch (obj.localName ? obj.localName : obj.nodeName) {
						case suiCnst.SLP_DIA_ATTR_TOOLTIP:
							oUIControl.setTooltip(this._replaceCDATA(obj.textContent));
							break;
						case suiCnst.SLP_DIA_ATTR_INFO_DESC:
							oUIControlInfoPopUp = new sap.ui.commons.RichTooltip({text: this._replaceCDATA(obj.textContent), title: suiCnst.SLP_DIA_ATTR_INFO_MORE});
							oUIControl.setTooltip(oUIControlInfoPopUp);
							break;
						case suiCnst.SLP_DIA_CAPTION:
							oUIControl.setTitle(this._replaceCDATA(obj.textContent));
							break;
						case "tableValueProvider":
							oTableModel = new sap.ui.model.xml.XMLModel();
							var xml = null;
							if (obj && obj.childNodes && (obj.childNodes.length > 0)) for (var i = 0; i < obj.childNodes.length; i++) if ((obj.childNodes[i].localName ? obj.childNodes[i].localName : obj.childNodes[i].nodeName) !== "#text") xml = new XMLSerializer().serializeToString(obj.childNodes[i]);
							var strRmSpce = xml.replace(/>\n[ ]+</g, "><");
							oTableModel.setXML(strRmSpce);
							oUIControl.setModel(oTableModel);
							sap.ui.getCore().setModel(oTableModel);
							if (sRowBinding.trim() == "") sRowBinding = obj.childNodes[0].childNodes[0].nodeName;
							if (sRowBinding.indexOf("/")) sRowBinding = "/" + sRowBinding;
							oUIControl.bindRows(sRowBinding);
							break;
						case "tableColumns":
							var cTableColum = [];
							if (obj.childNodes.length > 0) {
								cTableColum = obj.childNodes;
								for (var x = 0; x < cTableColum.length; x++) {
									if ((cTableColum[x].localName ? cTableColum[x].localName : cTableColum[x].nodeName) !== "#text") {
										oUIControl.addColumn(this._renderTableColumnView(cTableColum[x], paramMap, null, oUIControl));
										if (cEdtblAttr.indexOf(cTableColum[x].attributes.renderType.value) >= 0) {
											bTblEdit = true;
											oUIControl.getColumns()[oUIControl.getColumns().length - 1].getTemplate().addStyleClass('TableEntryField');
										}
									}
								}
							}
					}
				}
			}
			iVisibleRowCount = Math.min($(oUIControl.getModel().getData()).find("table").length, this._convertStringToInteger(attrMap, "visibleNoOfRows", 200));
			oUIControl.setVisibleRowCount(iVisibleRowCount);
			// enable the dynamic Add and Remove Button
			if (oUIControl.getToolbar() && bTblEdit) for (var i = 0; i < oUIControl.getToolbar().getRightItems().length; i++) oUIControl.getToolbar().getRightItems()[i].setVisible(true);
			if 		(sDynamic === "addOnly") 		oUIControlRemoveButton.setVisible(false);
			else if (sDynamic === "removeOnly") 	oUIControlAddButton.setVisible(false);
			this._makeControlVisible(oUIControl, oUIControlToolBar, oUIObject, oUIControlInfoPopUp, attrMap);
			oUIObject.insertField(oUIControl);
			this._mapUIControlIdToParamId(paramMap, sId, sUIElmId, attrMap);
			return oUIObject;
		} 
		else this.oFather.oLogger.logE("SLUITableView:With out parent id or self id - Its not possible to render the control.");
	}
	return null;
};

SLUISimpleUIRenderers.prototype._renderTableColumnView = function(oUIElmModel, paramMap, parentProperties, parentControl) {
	var suc = sap.ui.commons;
	var sut = sap.ui.table;
	if (oUIElmModel) {
		var attrMap = 			oUIElmModel.attributes;
		var sId = 				null,
			sParentId = 		null,
			sUIElmId = 			null;
		var sRenderType = 		null,
			bSortable = 		false,
			sSortingOrder = 	null,
			bFilterable = 		false;
		var oUIControl = 		null;
		var filter = 			null,
			endswith = 			null;
		var cbFunc = 			function(oEvt) {oUIControl.getModel().setProperty(sBingindValue, oEvt.getSource().getValue(), oEvt.getSource().getBindingContext());};
		sId = this._checkForId(attrMap);
		sParentId = this._checkForParentId(attrMap);
		if (sId && sParentId) {
			sUIElmId = sParentId + "_p_" + sId;
			oUIControl = new sut.Column(sUIElmId, {hAlign: "Center"});
			sRenderType = this._checkAttributeExistence(attrMap, "renderType") ? attrMap["renderType"].value : suiCnst.SLP_DIA_CONTROL_TXT_VIEW;
			endswith = this._checkAttributeExistence(attrMap, "endswith") ? attrMap["endswith"].value : null;
			if (this._convertStringToBoolean(attrMap, "bwslash", false)) globals.osDirSeparator = "\\";
			bSortable = this._convertStringToBoolean(attrMap, "sortable", false);
			bFilterable = this._convertStringToBoolean(attrMap, "filter", false);
			if (bSortable) {
				oUIControl.setSorted(bSortable);
				sSortingOrder = this._checkAttributeExistence(attrMap, "") ? attrMap["sortingOrder"].value : "asending";
				if (sSortingOrder === "ascending") oUIControl.setSortOrder(sut.SortOrder.Ascending);
				else oUIControl.setSortOrder(sut.SortOrder.Descending);
			}
			oUIControl.setFlexible(true);
			oUIControl.setFiltered(bFilterable);
			var childElements = oUIElmModel.childNodes;
			if (childElements.length > 0) {
				var sBingindValue = null;
				for (var j = 0; j < childElements.length; j++) {
					var obj = childElements[j];
					switch (obj.localName ? obj.localName : obj.nodeName) {
						case suiCnst.SLP_DIA_ATTR_TOOLTIP:
							oUIControl.setTooltip(this._replaceCDATA(obj.textContent));
							break;
						case suiCnst.SLP_DIA_CAPTION:
							oUIControl.setLabel(new sap.ui.commons.Label({text: this._replaceCDATA(obj.textContent)}));
							break;
						case "tableColumnValueProvider":
							var instaneChilds = obj.childNodes;
							var bDynamic = false;
							if (obj.attributes[0].localName === "dynamic") bDynamic = obj.attributes[0].value;
							switch (sRenderType) {
								case suiCnst.SLP_DIA_CONTROL_TXT_VIEW:
									oUIControl.setTemplate(new suc.TextView().bindProperty("text", sBingindValue));
									break;
								case "textInput":
									oUIControl.setTemplate(new suc.TextField({change: cbFunc}).bindProperty(suiCnst.UI5_ATTR_VALUE, sBingindValue));
									break;
								case "directoryInput":
									filter = "$filter=type%20eq%20%27slp.fileSystemEntryType.DIRECTORY%27";
									oUIControl.setTemplate(new SLUIFileBrowser(null, suiCnst.SLP_DIA_ATTR_TXTINP_DIRECTORY, null, "Select a Directory", filter, cbFunc).bindProperty(suiCnst.UI5_ATTR_VALUE, sBingindValue));
									break;
								case "fileInput":
									if (endswith) {
										filter = "$filter=type%20eq%20%27slp.fileSystemEntryType.DIRECTORY%27%20or";
										endswith.split("/").forEach(function(elem, idx){filter += (idx ? "%20or" : "") + "%20endswith(name,%27" + elem + "%27)";});
									}
									oUIControl.setTemplate(new SLUIFileBrowser(null, suiCnst.SLP_DIA_ATTR_TXTINP_FILE, null, "Select a File", filter, cbFunc).bindProperty(suiCnst.UI5_ATTR_VALUE, sBingindValue));
									break;
								case "secureInput":
									oUIControl.setTemplate(new suc.PasswordField({change: cbFunc}).bindProperty(suiCnst.UI5_ATTR_VALUE, sBingindValue));
									break;
								case "radioButton":
									oUIControl.setTemplate(new suc.RadioButton({
										select: function(oEvent) {
											oUIControl.getModel().setProperty(sBingindValue, oEvent.getSource().getSelected(), oEvent.getSource().getBindingContext());
										},
										selected: {
											path: 		sBingindValue, // "{Selected}",
											type: 		new sap.ui.model.type.Boolean(),
											formatter: 	function (value) {if (value == "true") return true; else return false;}
										},
										enabled: true
									}));
									break;
								case "checkBox":
									oUIControl.setTemplate(new suc.CheckBox({
										change: function (oEvent) {
											oUIControl.getModel().setProperty(sBingindValue, oEvent.getSource().getChecked(), oEvent.getSource().getBindingContext());
										},
										checked: {
											path: 		sBingindValue, // "{Selected}",
											type: 		new sap.ui.model.type.Boolean(),
											formatter: 	function (value) {if (value == "true") return true; else return false;}
										},
										enabled: true
									}));
									break;
								case "dropDown":
									if (bDynamic === "true") {
										var oItemTemplate1 = new sap.ui.core.ListItem();
										oItemTemplate1.bindProperty("text", "name");
										oItemTemplate1.bindProperty("key", "name");
										var oComBoBox = new suc.ComboBox({change: cbFunc});
										oComBoBox.bindItems(instaneChilds[0].data, oItemTemplate1);
										oComBoBox.bindProperty(suiCnst.UI5_ATTR_VALUE, sBingindValue);
										oUIControl.setTemplate(oComBoBox);
									} else {
										if (instaneChilds && instaneChilds.length > 0) {
											var tItems = [];
											for (var x = 0; x < instaneChilds.length; x++) {
												var tText = null,
													tKey = null;
												var intValuProvider = instaneChilds[x];
												for (var x1 = 0; x1 < intValuProvider.childNodes.length; x1++) {
													var obj = intValuProvider.childNodes[x1];
													switch (obj.localName ? obj.localName : obj.nodeName) {
														case suiCnst.SLP_DIA_CAPTION:
															tText = this._replaceCDATA(obj.textContent);
															break;
														case suiCnst.SLP_DIA_VALUE:
															tKey = this._replaceCDATA(obj.textContent);
													}
												}
												tItems.push(new sap.ui.core.ListItem({text: tText, key: tKey}));
											}
										}
										oUIControl.setTemplate(new suc.ComboBox({
											items: 	tItems,
											change: cbFunc
										}).bindProperty(suiCnst.UI5_ATTR_VALUE, sBingindValue));
									}
									break;
								case "link":
									oUIControl.setTemplate(new suc.Link({text: oBundle.getText("CLK_LINK_TXT"), href: sBingindValue, target: "_blank"}));
									break;
								case "button":
									break;
								case "image":
									oUIControl.setTemplate(new suc.Image().bindProperty(suiCnst.UI5_ATTR_ISRC, obj.textContent.replace(/^<!\[CDATA\[|\]\]>$/g, "")));
							}
							break;
						case "dataBinding":
							sBingindValue = this._replaceCDATA(obj.textContent);;
							if (bSortable) oUIControl.setSortProperty(sBingindValue);
							if (bFilterable) oUIControl.setSortProperty(sBingindValue);
							switch (sRenderType) {
								case suiCnst.SLP_DIA_CONTROL_TXT_VIEW:
									oUIControl.setTemplate(new sap.ui.commons.TextView().bindProperty("text", sBingindValue));
									break;
								case "textInput":
									oUIControl.setTemplate(new suc.TextField({change: cbFunc}).bindProperty(suiCnst.UI5_ATTR_VALUE, sBingindValue));
									break;
								case "directoryInput":
									filter = "$filter=type%20eq%20%27slp.fileSystemEntryType.DIRECTORY%27";
									oUIControl.setTemplate(new SLUIFileBrowser(null, suiCnst.SLP_DIA_ATTR_TXTINP_DIRECTORY, null, "Select a Directory", filter, cbFunc).bindProperty(suiCnst.UI5_ATTR_VALUE, sBingindValue));
									break;
								case "fileInput":
									if (endswith) {
										filter = "$filter=type%20eq%20%27slp.fileSystemEntryType.DIRECTORY%27%20or";
										endswith.split("/").forEach(function(elem, idx){filter += (idx ? "%20or" : "") + "%20endswith(name,%27" + elem + "%27)";});
									}
									oUIControl.setTemplate(new SLUIFileBrowser(null, suiCnst.SLP_DIA_ATTR_TXTINP_FILE, null, "Select a File", filter, cbFunc).bindProperty(suiCnst.UI5_ATTR_VALUE, sBingindValue));
									break;
								case "secureInput":
									oUIControl.setTemplate(new suc.PasswordField({change: cbFunc}).bindProperty(suiCnst.UI5_ATTR_VALUE, sBingindValue));
									break;
								case "radioButton":
									oUIControl.setTemplate(new suc.RadioButton({
										selected: {
											path: 		sBingindValue, // "{Selected}",
											type: 		new sap.ui.model.type.Boolean(),
											formatter: 	function (value) {if (value === "true") return true; else return false;}
										},
										enabled: true,
										select: function(oEvent) {
											oUIControl.getModel().setProperty(sBingindValue, oEvent.getSource().getSelected(), oEvent.getSource().getBindingContext());
										}
									}));
									break;
								case "checkBox":
									oUIControl.setTemplate(new suc.CheckBox({
										checked: {
											path: 		sBingindValue, // "{Selected}",
											type: 		new sap.ui.model.type.Boolean(),
											formatter: 	function (value) {if (value == "true") return true; else return false;}
										},
										enabled: true,
										change: function (oEvent) {
											oUIControl.getModel().setProperty(sBingindValue, oEvent.getSource().getChecked(), oEvent.getSource().getBindingContext());
										}
									}));
									break;
								case "dropDown":
									if (obj.childNodes && obj.childNodes.length > 0) {
										var tItems = [];
										for (var x = 0; x < obj.childNodes.length; x++) {
											var tText = null,
												tKey = null;
											var intValuProvider = obj.childNodes[x];
											for (var x1 = 0; x1 < intValuProvider.childNodes.length; x1++) {
												var obj = intValuProvider.childNodes[x1];
												switch (obj.localName ? obj.localName : obj.nodeName) {
													case suiCnst.SLP_DIA_CAPTION:
														tText = this._replaceCDATA(obj.textContent);
														break;
													case suiCnst.SLP_DIA_VALUE:
														tKey = this._replaceCDATA(obj.textContent);
												}
											}
											tItems.push(new sap.ui.core.ListItem({text: tText, key: tKey}));
										}
									}
									oUIControl.setTemplate(new suc.ComboBox({
										items: tItems,
										change: cbFunc
									}).bindProperty(suiCnst.UI5_ATTR_VALUE, sBingindValue));
									break;
								case "link":
									oUIControl.setTemplate(new suc.Link({text: oBundle.getText("CLK_LINK_TXT"), href: sBingindValue, target: "_blank"}));
									break;
								case "button":
									break;
								case "image":
									oUIControl.setTemplate(new suc.Image().bindProperty(suiCnst.UI5_ATTR_ISRC, sBingindValue));
							}
					}
				}
			}
			this._makeControlVisible(oUIControl, null, null, null, attrMap);
			this._mapUIControlIdToParamId(paramMap, sId, sUIElmId, attrMap);
			return oUIControl;
		} 
		else this.oFather.oLogger.logE("SLUITableColumn: It's not possible to render the control without parent id or self id.");
	}
	return null;
};

SLUISimpleUIRenderers.prototype._mapUIControlIdToParamId = function(paramMap, paramId, uiControlId, attrMap, sValue) {
	if (paramMap && paramMap[paramId]) {
		paramMap[paramId].uiId = uiControlId;
		paramMap[paramId].uiAttrMap = attrMap;
		paramMap[paramId].currentValue = sValue;
	}
};

SLUISimpleUIRenderers.prototype._checkForId = function(attrMap) {
	if (attrMap) {
		if (this._checkAttributeExistence(attrMap, "id")) return attrMap["id"].value;
		else return null;
	}
};

SLUISimpleUIRenderers.prototype._checkForParentId = function(attrMap) {
	if (attrMap) {
		if (this._checkAttributeExistence(attrMap, "parentId")) return attrMap["parentId"].value;
		else return null;
	}
};

SLUISimpleUIRenderers.prototype._checkAttributeExistence = function(attrMap, attrName) {
	if (attrMap && attrMap[attrName] && attrMap[attrName].value) return true;
	else return false;
};

SLUISimpleUIRenderers.prototype._convertStringToBoolean = function(attrMap, attrName, reverseBit) {
	var returnResult = this._checkAttributeExistence(attrMap, attrName);
	if (returnResult) {
		if (attrMap[attrName].value === "true") return true;
		else return false;
	} else {
		if (reverseBit) return true;
		else return false;
	}
};

SLUISimpleUIRenderers.prototype._convertStringToInteger = function(attrMap, attrName, defaultNo) {
	var returnResult = this._checkAttributeExistence(attrMap, attrName);
	if (returnResult) return parseInt(attrMap[attrName].value);
	else {if (defaultNo) return defaultNo; else return -1;}
};

SLUISimpleUIRenderers.prototype._makeControlEnable = function(oControl, attrMap) {
	if (oControl && attrMap) oControl.setEnabled(this._convertStringToBoolean(attrMap, "enable", true));
};

SLUISimpleUIRenderers.prototype._makeControlVisible = function(oControl, oLabel, oFormElement, oInfoButton, attrMap, parentVisible) {
	if (parentVisible  === undefined) parentVisible = true;
	if (oControl && attrMap) oControl.setVisible(parentVisible && this._convertStringToBoolean(attrMap, "visible", true));
	if (oLabel && attrMap) oLabel.setVisible( parentVisible && this._convertStringToBoolean(attrMap, "visible", true));
	if (oFormElement && attrMap) oFormElement.setVisible( parentVisible && this._convertStringToBoolean(attrMap, "visible", true));
};

SLUISimpleUIRenderers.prototype._makeControlRequired = function(oControl, attrMap) {
	if (oControl && attrMap) {
		if (this._convertStringToBoolean(attrMap, "required", false)) oControl.addStyleClass("sapUiLblReq sapUiLblReqEnd"); else oControl.removeStyleClass("sapUiLblReq sapUiLblReqEnd");
	}
};

SLUISimpleUIRenderers.prototype._makeControlEditable = function(oControl, attrMap) {
	if (oControl && attrMap) oControl.setEditable(this._convertStringToBoolean(attrMap, "editable", true));
};

SLUISimpleUIRenderers.prototype._makeControlWraped = function(oControl, attrMap) {
	if (oControl && attrMap) oControl.setWrapping(this._convertStringToBoolean(attrMap, "wrap", false));
};

SLUISimpleUIRenderers.prototype._replaceCDATA = function(sText) {
	if (sText) sText = sText.replace(/^<!\[CDATA\[|\]\]>$/g, "");
	return sText;
};

SLUISimpleUIRenderers.prototype._makeControlWraped = function(oControl, attrMap) {
	if (oControl && attrMap) oControl.setWrapping(this._convertStringToBoolean(attrMap, "wrap", false));
};

SLUISimpleUIRenderers.prototype._setControlWidth = function(oControl, attrMap, defaultWidth) {
	if (oControl && attrMap) {
		var sWidth = "200px";
		if (this._checkAttributeExistence(attrMap, "width")) {
			sWidth = attrMap["width"].value;
			if (sWidth.indexOf("px") < 0) sWidth += "px";
		} 
		else if (defaultWidth) sWidth = defaultWidth;
		oControl.setWidth(sWidth);
	}
};

SLUISimpleUIRenderers.prototype._displayValidationToolTip = function(sText, sValue, bSecure) {
	if ((!bSecure) && (sValue !== "")) sText += ": <strong>" + sValue + "</strong>.";
	return new sap.ui.commons.RichTooltip({text: sText});
};

SLUISimpleUIRenderers.prototype._setDirtyExecution = function(sUIElmId, bIsDirty) {
	if (oStub.oFather) oStub.oFather.oProcExe.oUIProc.paramInDrtState[sUIElmId] = bIsDirty;
};

SLUISimpleUIRenderers.prototype._calculateLabelWidth = function(oData) {
	var len = "100%";
	if (oData) {
		var oCaps = $($(oData).find("textInputView")).find(suiCnst.SLP_DIA_CAPTION);
		if (oCaps && oCaps.length > 0) {
			var cLen = 0;
			for (var x = 0; x < oCaps.length; x++) if (cLen < oCaps[x].textContent.length) cLen = oCaps[x].textContent.length;
			if (cLen <= 35) len = (cLen * 10 + 1) + "px";
		}
	}
	return len;
};

SLUISimpleUIRenderers.prototype._generateNoteAsLink = function(sOrgText) {
	if (sOrgText) {
		if (oBundle) suiCnst.UI_GEN_SAPNOTE_SERVICE = oBundle.getText("URL_SAP_SERVICE");
		var sURLText = suiCnst.UI_GEN_SAPNOTE_SERVICE;
		var sCopyText = sOrgText;
		var iOcc = 0;
		// for SAP Note
		while (sCopyText.indexOf(" SAP Note ") > -1) {
			sCopyText = sCopyText.substring(sCopyText.indexOf("SAP Note ") + 9, sCopyText.length);
			iOcc++;
		}
		sCopyText = sOrgText;
		for (var i = 0; i < iOcc; i++) {
			var iOccStrt = sCopyText.indexOf("SAP Note ");
			var sTempStr = sCopyText.substring(iOccStrt + 9, sCopyText.length);
			var sNoteNo = "";
			var x = 0;
			while ((x < sTempStr.length) && (sTempStr[x] >= '0') && (sTempStr[x] <= '9')) sNoteNo += sTempStr[x++];
			sCopyText = sTempStr;
			if ((sNoteNo.length > 0) && (sNoteNo != "")) {
				var sNoteText = "SAP Note " + sNoteNo;
				var sTarText = "<img src=\"" + suiCnst.UI_FILE_PATH_SLUI_ROOTPATH + suiCnst.UI_FILE_PATH_UILINK +
					"/sapnote.png\" style=\"width: 16px; height: 16px\"/><a target=\"_blank\" href=\"" + sURLText + sNoteNo + "\">SAP Note " + sNoteNo + " </a>";				
				sOrgText = sOrgText.replace(sNoteText, sTarText);
			}
		}
		sCopyText = sOrgText;
		iOcc = 0;
		// for SAP Note
		while (sCopyText.indexOf(" SAP note ") > -1) {
			sCopyText = sCopyText.substring(sCopyText.indexOf("SAP note ") + 9, sCopyText.length);
			iOcc++;
		}
		sCopyText = sOrgText;
		for (var i = 0; i < iOcc; i++) {
			var iOccStrt = sCopyText.indexOf("SAP note ");
			var sTempStr = sCopyText.substring(iOccStrt + 9, sCopyText.length);
			var sNoteNo = "";
			var x = 0;
			while ((x < sTempStr.length) && (sTempStr[x] >= '0') && (sTempStr[x] <= '9')) sNoteNo += sTempStr[x++];
			sCopyText = sTempStr;
			if ((sNoteNo.length > 0) && (sNoteNo != "")) {
				var sNoteText = "SAP Note " + sNoteNo;
				var sTarText = "<img src=\"" + suiCnst.UI_FILE_PATH_SLUI_ROOTPATH + suiCnst.UI_FILE_PATH_UILINK +
					"/sapnote.png\" style=\"width:16px;height:16px\"/><a target=\"_blank\" href=\"" + sURLText + sNoteNo + "\">SAP Note " + sNoteNo + " </a>";
				sOrgText = sOrgText.replace(sNoteText, sTarText);
			}
		}
	}
	return sOrgText;
};


SLUISimpleUIRenderers.prototype.checkDialogIsInDirtyState = function(uiIdColl) {
	var oFather = oStub.oFather;
	if (oFather) {
		var dirtyColl = oFather.oProcExe.oUIProc.paramInDrtState;
		for (var x = 0; x < uiIdColl.length; x++) {
			if (dirtyColl[uiIdColl[x]]) {
				oFather.oProcExe.oUIProc.diaInDrtyState = true;
				return;
			} 
			else oFather.oProcExe.oUIProc.diaInDrtyState = false;
		}
	}
};

// Client Event Reference
SLUISimpleUIRenderers.prototype.triggerClientEventReference = function(sUiElmId, evRef, oChckBox) {
	if (sUiElmId && evRef) {
		var iScr = $(document).scrollTop();
		$(document).scrollTop(0);
		var oFather = oStub.oFather;
		var cConfigParams = oFather.oProcExe.oUIProc.configParams;
		var cDialogCollection = oFather.oProcExe.oUIProc.diaParamMap;
		var cCliEveRefs = new Array();
		var oUIControl = sap.ui.getCore().byId(sUiElmId);
		if (oUIControl) {
			var cEveRefNodes = evRef.childNodes;
			for (var x = 0; x < cEveRefNodes.length; x++) {
				var oEveRefNode = cEveRefNodes[x].childNodes;
				if (oEveRefNode.length > 0) {
					var oEveRef = {	sEveTyp: 	undefined,
									sEveState: 	undefined,
									oRef: 		undefined	};
					for (var j = 0; j < oEveRefNode.length; j++) {
						var obj = oEveRefNode[j];
						switch ((obj.localName) ? obj.localName : obj.nodeName) {
							case "eventType":
								oEveRef.sEveTyp = obj.textContent;
								break;
							case "stateValue":
								oEveRef.sEveState = obj.textContent;
								break;
							case "reference":
								var refObj = {refParIds: new Array()};
								var cEveDet = obj.childNodes;
								if (cEveDet.length > 0) {
									for (var j = 0; j < cEveDet.length; j++) {
										var obj = cEveDet[j];
										switch (obj.localName ? obj.localName : obj.nodeName) {
											case "refProperty":
												refObj.refPro = obj.textContent;
												break;
											case "refValue":
												refObj.refVal = obj.textContent;
												break;
											case "refControlType":
												refObj.uiType = obj.textContent;
												break;
											case "refParamIds":
												for (var z = 0; z < obj.childNodes.length; z++) refObj.refParIds.push(obj.childNodes[z].textContent);
										}
									}
								}
								oEveRef.oRef = refObj;
						}
					}
					cCliEveRefs.push(oEveRef);
				}
			}
		} 
		else this.oFather.oLogger.logE("UI control is empty - unable to trigger client event reference.");
		if (cCliEveRefs && (cCliEveRefs.length > 0)) {
			var sChckVal = null;
			for (var i = 0; i < cCliEveRefs.length; i++) {
				switch (cCliEveRefs[i].sEveTyp) {
					case "onChange":
						if (sUiElmId.indexOf("_slui_valSelGrp_checkBtn_") > -1) {
							sChckVal = oChckBox.oSource.getChecked();
							if (sChckVal == true) sChckVal = "true";
							else sChckVal = "false";
						} 
						else if (sUiElmId.indexOf("_slui_txtInput_") > -1) sChckVal = oUIControl.getValue();
						break;
					case "onSelect":
						sChckVal = oUIControl.getSelectedItem().getKey();
				}
				cCliEveRefs[i].sCheckValue = sChckVal;
			}
		}
		for (var i = 0 ; i < cCliRef.length; i++ ) 
			if (sUiElmId === cCliRef[i].sId) 
				for (var j = 0; j < cCliRef[i].cliRefs.length; j++) {
					if 		(sUiElmId.indexOf("_slui_valSelGrp_radioBtn_") > -1) cCliRef[i].cliRefs[j].sCheckValue = oUIControl.getSelectedItem().getKey();
					else if (sUiElmId.indexOf("_slui_valSelGrp_checkBtn_") > -1) cCliRef[i].cliRefs[j].sCheckValue = oUIControl.getChecked();
				}
		if (cCliEveRefs && (cCliEveRefs.length > 0)) 
			for (var i = 0; i < cCliEveRefs.length; i++) 
				if (cCliEveRefs[i].sCheckValue === cCliEveRefs[i].sEveState) {
					var oReference = cCliEveRefs[i].oRef;
					if (oReference) {
						var cRefObjs = oReference.refParIds;
						var sProName = oReference.refPro;
						var sProValue = oReference.refVal;
						var suiType = oReference.uiType;
						if (sProName && sProValue && cRefObjs && (cRefObjs.length > 0)) {
							for (var t = 0; t < cRefObjs.length; t++) {
								var oUIControl = sap.ui.getCore().byId("_slui_grp_view_" + cRefObjs[t]);
								//access all children and apply the property recursively.
								//do for parent
								if (oUIControl) {
									switch (sProName) {
										case "visible":
											if (sProValue === "true") oUIControl.setVisible(true);
											else if (sProValue === "false") oUIControl.setVisible(false);
											break;
										case "enable":
											if (sProValue === "true") oUIControl.setEnabled(true);
											else if (sProValue === "false") oUIControl.setEnabled(false);
									}
									this.applyProsForCERef(oUIControl, sProName, sProValue);
								}
							}
						}
					}
				}
		//scroll properly
		$(document).scrollTop(iScr);
	}
};

SLUISimpleUIRenderers.prototype.triggerClientEventReferenceInitial = function(sUiId, evRef, oUIControl, parentVisible) {
	if (evRef) {
		var oFather = oStub.oFather;
		var cConfigParams = oFather.oProcExe.oUIProc.configParams;
		var cDialogCollection = oFather.oProcExe.oUIProc.diaParamMap;
		var cCliEveRefs = new Array();
		var oCliRef = {	type: 		undefined,
						sId: 		undefined,
						cliRefs: 	new Array()	};
		if (sUiId.indexOf("valSelGrp") > -1) oCliRef.type = "valueSelectorGroupView";
		oCliRef.sId = sUiId;
		var cEveRefNodes = evRef.childNodes;
		for (var x = 0; x < cEveRefNodes.length; x++) {
			var oEveRefNode = cEveRefNodes[x].childNodes;
			if (oEveRefNode.length > 0) {
				var oEveRef = {	sEveTyp: 	undefined,
								sEveState: 	undefined,
								oRef: 		undefined	};
				for (var j = 0; j < oEveRefNode.length; j++) {
					var obj = oEveRefNode[j];
					switch (obj.localName ? obj.localName : obj.nodeName) {
						case "eventType":
							oEveRef.sEveTyp = obj.textContent;
							break;
						case "stateValue":
							oEveRef.sEveState = obj.textContent;
							break;
						case "reference":
							var refObj = {refParIds: new Array()};
							var cEveDet = obj.childNodes;
							if (cEveDet.length > 0) {
								for (var j = 0; j < cEveDet.length; j++) {
									var obj = cEveDet[j];
									switch (obj.localName ? obj.localName : obj.nodeName) {
										case "refProperty":
											refObj.refPro = obj.textContent;
											break;
										case "refValue":
											refObj.refVal = obj.textContent;
											break;
										case "refControlType":
											refObj.uiType = obj.textContent;
											break;
										case "refParamIds":
											for (var z = 0; z < obj.childNodes.length; z++) refObj.refParIds.push(obj.childNodes[z].textContent);
									}
								}
							}
							oEveRef.oRef = refObj;
					}
				}
				cCliEveRefs.push(oEveRef);
			}
		}
		if (cCliEveRefs && (cCliEveRefs.length > 0)) {
			var sChckVal = null;
			for (var i = 0; i < cCliEveRefs.length; i++) {
				switch (cCliEveRefs[i].sEveTyp) {
					case "onChange":
						if (sUiId.indexOf("_slui_valSelGrp_checkBtn_") > -1) {
							sChckVal = sap.ui.getCore().byId(sUiId).getChecked();
							if (sChckVal == true) sChckVal = "true";
							else sChckVal = "false";
						} 
						else if (sUiId.indexOf("_slui_txtInput_") > -1) sChckVal = oUIControl.getValue();
						break;
					case "onSelect":
						sChckVal = oUIControl.getKey();
				}
				cCliEveRefs[i].sCheckValue = sChckVal;
			}
			var k = 0, j = 0;
			for (var i = 0; i < cCliEveRefs.length; i++) {
				oCliRef.cliRefs.push(cCliEveRefs[i]);
				if (cCliEveRefs[i].sCheckValue === cCliEveRefs[i].sEveState) {
					var oReference = cCliEveRefs[i].oRef;
					if (oReference) {
						var cRefObjs = oReference.refParIds;
						var sProName = oReference.refPro;
						var sProValue = oReference.refVal;
						var suiType = oReference.uiType;
						if (sProName && sProValue && cRefObjs && cRefObjs.length) 
							for (var t = 0; t < cRefObjs.length; t++) 
								switch (sProName) {
									case "visible":
									case "enable":
										if (sProValue === "true" && parentVisible) {
											cCliEveRefsInitial[k] = cCliEveRefs[i];
											k++;
										} 
								}
					}
				}
			}
			var c = 0;
			for (var r = 0; r < cCliRef.length; r++) if (cCliRef[r].sId === oCliRef.sId) c++;
			if (c === 0) cCliRef.push(oCliRef);
		}
		//scroll properly
	}
};

SLUISimpleUIRenderers.prototype.applyProsForCERef = function(oCntrl, sPrpName, SPrpValue) {
	if (oCntrl && sPrpName && SPrpValue) {
		var grpIds = $(oCntrl).attr("childGrpIds");
	    var sProperty, sValue, oReference, cRefObjs;
	    sProperty = sPrpName;
	    sValue = SPrpValue; 
	    if (grpIds) {
	    	var grpIdsColl = grpIds.split("|_sluigrpchild|");
	        if (grpIdsColl && grpIdsColl.length) {
	        	for (var m = 0; m < grpIdsColl.length; m++) {
	            	var str = grpIdsColl[m];
	                if (str.indexOf("Group") > -1) {
	                	for (var i = 0; i < cCliRef.length; i++) 
	                        for (var j = 0; j < cCliRef[i].cliRefs.length; j++) 
	                        	if ((cCliRef[i].cliRefs[j].oRef.refParIds[0] === str) && (cCliRef[i].cliRefs[j].sCheckValue === cCliRef[i].cliRefs[j].sEveState)) {
	                        		oReference = cCliRef[i].cliRefs[j].oRef;
	                                cRefObjs = oReference.refParIds;
	                                sProperty = oReference.refPro;
	                                if (SPrpValue === "true") sValue = oReference.refVal;
	                                else sValue = "false";
	                        	}
	                	var childCntrl = sap.ui.getCore().byId("_slui_grp_view_"+ str);
	                	if (childCntrl) {
	                    	 switch (sProperty) {
	                     		case "visible":
	                     		case "enable":
	                     			if 		(sValue === "true") 	childCntrl.setVisible(true);
	                     			else if (sValue === "false") 	childCntrl.setVisible(false);
	                    	 }
	                    	 this.applyProsForCERef(childCntrl, sProperty, sValue);
	                    }
	                 }
	        	}
	        }                                                                                                                                                     
	    }
	}                             
};

// client side validation techniques
SLUISimpleUIRenderers.prototype.triggerClientSideValidation = function(sUiElmId, oUIControl, cAttrMap, sDefaultToolTip, sLabel) {
	if (sUiElmId && cAttrMap) {
		if (sUiElmId.indexOf("_slui_table") > -1) {
			//no client side validation for table
		} else {
			if (!oUIControl) oUIControl = sap.ui.getCore().byId(sUiElmId);
			if (sap.ui.getCore().byId(sUiElmId + "_lbl")) sLabel = sap.ui.getCore().byId(sUiElmId + "_lbl").getText();
			if 		(!sLabel) 				sLabel = "";
			else if (sLabel.trim() === "") 	sLabel = "";
			if (!sDefaultToolTip ) sDefaultToolTip = oBundle.getText("TOOL_TIP_LBL_TXT") + " " + sLabel;
			if (oUIControl) {
				var oCntrl = oUIControl;
				var flag = 1;
				while (oCntrl) {
					if ((oCntrl.getVisible != undefined) && (oCntrl.getVisible() == false)) {flag = 0; break;}
					oCntrl = oCntrl.getParent();
				}
				if (flag == 1) {
					if (sUiElmId.indexOf("_slui_valSelGrp_") > -1) {
						var bRequired = oThis._convertStringToBoolean(cAttrMap, "required", false);
						if (sUiElmId.indexOf("_slui_valSelGrp_radioBtn_") > -1 || sUiElmId.indexOf("_slui_valSelGrp_checkBtn_") > -1) {
							if (bRequired && (!oUIControl.selectedValue || (oUIControl.selectedValue.trim() === ""))) {
								var childElm = oUIControl.childElements ? oUIControl.childElements : "";
								if (childElm != "") {
									var childElmCols = childElm.split("|");
									for (var z = 0; z < childElmCols.length; z++) 
										if (childElmCols[z] != "") {
											var oChildControl = sap.ui.getCore().byId(childElmCols[z]);
											oChildControl.setValueState(sap.ui.core.ValueState.Error);
											oChildControl.setTooltip(oThis._displayValidationToolTip(" " + sLabel + " " + oBundle.getText("WRN_EMP_TXT"), "", false));
											oThis._setDirtyExecution(sUiElmId, true);
										}
								}
								oUIControl.setTooltip(oThis._displayValidationToolTip(" " + sLabel + " " + oBundle.getText("WRN_EMP_TXT"), "", false));
								oThis._setDirtyExecution(sUiElmId, true);
								return;
							} else {
								var childElm = oUIControl.childElements ? oUIControl.childElements : "";
								if (childElm != "") {
									var childElmCols = childElm.split("|");
									for (var z = 0; z < childElmCols.length; z++) 
										if (childElmCols[z] != "") {
											var oChildControl = sap.ui.getCore().byId(childElmCols[z]);
											oChildControl.setValueState(sap.ui.core.ValueState.None);
											oChildControl.setTooltip(sDefaultToolTip);
										}
								}
								oUIControl.setTooltip(sDefaultToolTip);
								oThis._setDirtyExecution(sUiElmId, false);
								return;
							}
						} else if (sUiElmId.indexOf("_slui_valSelGrp_dropDown_") > -1) {
							if (bRequired && (!oUIControl.getValue() || (oUIControl.getValue().trim() === ""))) {
								oUIControl.setValueState(sap.ui.core.ValueState.Error);
								oUIControl.setTooltip(oThis._displayValidationToolTip(" " + sLabel + " " + oBundle.getText("WRN_EMP_TXT"), oUIControl.getValue(), bSecure));
								oThis._setDirtyExecution(sUiElmId, true);
								return;
							} else {
								oUIControl.setValueState(sap.ui.core.ValueState.None);
								oUIControl.setTooltip(sDefaultToolTip);
								oThis._setDirtyExecution(sUiElmId, false);
							}
						} 
						else if (sUiElmId.indexOf("_slui_valSelGrp_checkBtn_") > -1) {} 
						else if (sUiElmId.indexOf("_slui_valSelGrp_listDown_") > -1) {}
					} else if (sUiElmId.indexOf("_slui_txtInput_") > -1) {
						var bSecure = oThis._convertStringToBoolean(cAttrMap, "secure", false);
						var bRequired = oThis._convertStringToBoolean(cAttrMap, "required", false);
						if (bRequired && (!oUIControl.getValue() || (oUIControl.getValue().trim() === ""))) {
							oUIControl.setValueState(sap.ui.core.ValueState.Error);
							oUIControl.setTooltip(oThis._displayValidationToolTip(" " + sLabel + " " + oBundle.getText("WRN_EMP_TXT"), oUIControl.getValue(), bSecure));
							oUIControl.setRequired(bRequired);
							oThis._setDirtyExecution(sUiElmId, true);
							return;
						} else {
							oUIControl.setValueState(sap.ui.core.ValueState.None);
							oUIControl.setTooltip(sDefaultToolTip);
							oUIControl.setRequired(bRequired);
							oThis._setDirtyExecution(sUiElmId, false);
						}
						var iMaxCharLength = oThis._convertStringToInteger(cAttrMap, "maxCharLength", 10000);
						var iMinCharLength = oThis._convertStringToInteger(cAttrMap, "minCharLength", 0);
						var sStringcase = oThis._checkAttributeExistence(cAttrMap, "stringCase") ? cAttrMap["stringCase"].value : "none";
						var sType_ = this._checkAttributeExistence(cAttrMap, "type") ? cAttrMap["type"].value : suiCnst.SLP_DIA_ATTR_TXTINP_STANDARD;
						if (sType_ === suiCnst.SLP_DIA_ATTR_TXTINP_NUMB) {
							var iMaxValue = oThis._convertStringToInteger(cAttrMap, "maxValue", 9999999);
							var iMinValue = oThis._convertStringToInteger(cAttrMap, "minValue", -9999999);
							if (!isNaN(oUIControl.getLiveValue())) {
								if ((parseInt(oUIControl.getValue()) <= iMaxValue) && (parseInt(oUIControl.getValue()) >= iMinValue)) {
									oUIControl.setValueState(sap.ui.core.ValueState.None);
									oUIControl.setTooltip(sDefaultToolTip);
									oThis._setDirtyExecution(sUiElmId, false);
									return;
								} else {
									oUIControl.setValueState(sap.ui.core.ValueState.Error);
									oUIControl.setTooltip(oThis._displayValidationToolTip(" " + sLabel + " " + oBundle.getText("WRN_NUM_RNG_TXT") + " " + iMinValue + " " + oBundle.getText("TO_TXT") + " " + iMaxValue +
											" !.", oUIControl.getValue(), bSecure));
									oThis._setDirtyExecution(sUiElmId, true);
									return;
								}
							} else {
								oUIControl.setValueState(sap.ui.core.ValueState.Error);
								oUIControl.setTooltip(oThis._displayValidationToolTip(" " + sLabel + " " + oBundle.getText("WRN_NUM_TXT"), oUIControl.getValue(), bSecure));
								oThis._setDirtyExecution(sUiElmId, true);
								return;
							}
						} else if ((sType_ === suiCnst.SLP_DIA_ATTR_TXTINP_STRING) || (sType_ === suiCnst.SLP_DIA_ATTR_TXTINP_STANDARD)) {
							if (sStringcase != "none") {
								var sValue = oUIControl.getValue();
								if (sValue && sStringcase == "lower") {
									if (sValue === sValue.toLowerCase()) {
										oUIControl.setValueState(sap.ui.core.ValueState.None);
										oUIControl.setTooltip(sDefaultToolTip);
										oThis._setDirtyExecution(sUiElmId, false);
									} else {
										oUIControl.setValueState(sap.ui.core.ValueState.Error);
										oUIControl.setTooltip(oThis._displayValidationToolTip(" " + sLabel + " " + oBundle.getText("WRN_LWCASE_TXT"), oUIControl.getValue(), bSecure));
										oThis._setDirtyExecution(sUiElmId, true);
										return;
									}
								} else if (sValue && (sStringcase == "upper")) {
									if (sValue === sValue.toUpperCase()) {
										oUIControl.setValueState(sap.ui.core.ValueState.None);
										oUIControl.setTooltip(sDefaultToolTip);
										oThis._setDirtyExecution(sUiElmId, false);
									} else {
										oUIControl.setValueState(sap.ui.core.ValueState.Error);
										oUIControl.setTooltip(oThis._displayValidationToolTip(" " + sLabel + " " + oBundle.getText("WRN_UPCASE_TXT"), oUIControl.getValue(), bSecure));
										oThis._setDirtyExecution(sUiElmId, true);
										return;
									}
								}
							} else {
								oUIControl.setValueState(sap.ui.core.ValueState.None);
								oUIControl.setTooltip(sDefaultToolTip);
								oThis._setDirtyExecution(sUiElmId, false);
							}
						}
						if ((sType_ === suiCnst.SLP_DIA_ATTR_TXTINP_STRING) || (sType_ === suiCnst.SLP_DIA_ATTR_TXTINP_STANDARD) || (sType_ === suiCnst.SLP_DIA_ATTR_TXTINP_NUMB)) {
							if ((oUIControl.getValue().length <= iMaxCharLength) && (oUIControl.getValue().length >= iMinCharLength)) {
								oUIControl.setValueState(sap.ui.core.ValueState.None);
								oUIControl.setTooltip(sDefaultToolTip);
								oThis._setDirtyExecution(sUiElmId, false);
								return;
							} else {
								oUIControl.setValueState(sap.ui.core.ValueState.Error);
								oUIControl.setTooltip(oThis._displayValidationToolTip(" " + oBundle.getText("VAL_OF_TXT") + " " + sLabel + " " + oBundle.getText("WRN_RNG_TXT") + " " + iMinCharLength + " " + oBundle.getText("TO_TXT") + " " + iMaxCharLength +
										" !.", oUIControl.getValue(), bSecure));
								oThis._setDirtyExecution(sUiElmId, true);
							}
						}
					}
				}
			}
		}
	}
};

SLUISimpleUIRenderers.prototype.triggerRegExpValidation = function(sUiElmId, oUIControl, cAttrMap, sDefaultToolTip, oRExp) {
	var sLabel;
	var bSecure = oThis._convertStringToBoolean(cAttrMap, "secure");
	var sRegEx = "";
	if (sUiElmId) {
		if (sUiElmId.indexOf("_slui_table") === -1) {
			if (!oUIControl) oUIControl = sap.ui.getCore().byId(sUiElmId);
			if (sap.ui.getCore().byId(sUiElmId + "_lbl")) sLabel = sap.ui.getCore().byId(sUiElmId + "_lbl").getText();
			if (!sLabel || (sLabel.trim() === "")) sLabel = "";
			if ((oRExp[sUiElmId] != undefined) && (oRExp[sUiElmId].label == sLabel)) sRegEx = oRExp[sUiElmId].regex;
			if (oUIControl && (sUiElmId.indexOf("_slui_txtInput_")) > -1) {
				var oRegEx = new RegExp(sRegEx);
				if ((oRegEx.test(oUIControl.getValue())) == false) {
					oUIControl.setValueState(sap.ui.core.ValueState.Error);
					oUIControl.setTooltip(oThis._displayValidationToolTip(" " + oBundle.getText("VAL_OF_TXT")+ " " + sLabel + " "+oBundle.getText("WRN_CLVAL_TXT"), oUIControl.getValue(), bSecure));
					oThis._setDirtyExecution(sUiElmId, true);
					return;
				} else {
					oUIControl.setValueState(sap.ui.core.ValueState.None);
					oUIControl.setTooltip(sDefaultToolTip);
					oThis._setDirtyExecution(sUiElmId, false);
					return;
				}
			}
		}
	}
};

SLUISimpleUIRenderers.prototype.triggerServerSideValidation = function(sUiElmId, sText, sStatus) {
	if (sUiElmId && sUiElmId.indexOf("_slui_fileUpload") < 0) {
		var oUIControl = sap.ui.getCore().byId(sUiElmId);
		var sLabel = sap.ui.getCore().byId(sUiElmId + "_lbl").getText();
		if (!sLabel || (sLabel.trim() === "")) sLabel = "";
		if (oUIControl) {
			if ((sUiElmId.indexOf("_slui_valSelGrp_radioBtn_") > -1) || (sUiElmId.indexOf("_slui_valSelGrp_checkBtn_") > -1)) {
				var childElm = oUIControl.childElements ? oUIControl.childElements : "";
				if (childElm != "") {
					var childElmCols = childElm.split("|");
					for (var z = 0; z < childElmCols.length; z++) 
						if (childElmCols[z] != "") {
							var oChildControl = sap.ui.getCore().byId(childElmCols[z]);
							if (sStatus) {
								if (sStatus === "Error") oChildControl.setValueState(sap.ui.core.ValueState.Error);
								else if (sStatus === "Warning") oChildControl.setValueState(sap.ui.core.ValueState.Warning);
							} 
							else oChildControl.setValueState(sap.ui.core.ValueState.Error);
							oChildControl.setTooltip(oThis._displayValidationToolTip(" " + sLabel + ":" + sText, "", false));
						}
				}
				oUIControl.setTooltip(oThis._displayValidationToolTip(" " + sLabel + ":" + sText, "", false));
				oThis._setDirtyExecution(sUiElmId, true);
				return;
			} else {
				if (sStatus) {
					if 		(sStatus === "Error") 	oUIControl.setValueState(sap.ui.core.ValueState.Error);
					else if (sStatus === "Warning")	oUIControl.setValueState(sap.ui.core.ValueState.Warning);
				} 
				else oUIControl.setValueState(sap.ui.core.ValueState.Error);
				if (oUIControl.sId && oUIControl.sId.indexOf("pswd") > -1) oUIControl.setTooltip(oThis._displayValidationToolTip(" " + sLabel + ":" + sText, oUIControl.getValue(), true));
				else oUIControl.setTooltip(oThis._displayValidationToolTip(" " + sLabel + ":" + sText, oUIControl.getValue(), false));
				oThis._setDirtyExecution(sUiElmId, true);
			}
		}
	}
};
