sap.ui.jsview(sluiCore.mod.jsproSng, {
	processForm: 		undefined,
	processTitle: 		undefined,
	processDecription: 	undefined,
	selectedIndex: 		0,
	
	supplyData: function(dataModel, sIndex) {
		if (sIndex) this.selectedIndex = sIndex;
		else this.selectedIndex = -1;
		if (dataModel) this.dataModel.setData(dataModel);
		this.updateContent();
	},
	
	createContent: function(oController) {
		var oFCntrl = oStub.oFather;
		var suc = sap.ui.commons;
		this.processsTitle = new suc.TextView("_slui_proTtlTxt");
		this.processsTitle.setText(oBundle.getText("PRO_TTL_SNG_LBL_TXT"));
		this.processsTitle.setDesign(suc.TextViewDesign.H3);
		this.processsDescription = new suc.TextView("_slui_proDesTxt");
		this.processsDescription.setText(oBundle.getText("PRO_DESC_LBL_TXT"));
		this.processForm = new suc.layout.VerticalLayout();
		// Execute Button
		var oToolBar = new suc.Toolbar("_slui_toolBar");
		oToolBar.setDesign(suc.ToolbarDesign.Flat);
		var _childVerticalLayout = new suc.layout.VerticalLayout("_slui_childvarticallayout");
		_childVerticalLayout.addContent(new sap.ui.core.HTML({content: "<div style=\"height:100px\"/>", sanitizeContent: true}));
		var _childVerticalLayout1 = new suc.layout.VerticalLayout("_slui_childvarticallayout1");
		_childVerticalLayout1.addContent(new sap.ui.core.HTML({content: "<div style=\"height:10px\"/>", sanitizeContent: true}));
		this.processForm.addContent(this.processsTitle);
		this.processForm.addContent(_childVerticalLayout1);
		this.processForm.addContent(this.processsDescription);
		this.processForm.addContent(_childVerticalLayout);
		this.processForm.addContent(oToolBar);
		this.processsTitle.setModel(oFCntrl.oProcRepo.cProcLst);
		this.processsDescription.setModel(oFCntrl.oProcRepo.cProcLst);
		this.processsTitle.bindText("/Process/displayName");
		this.processsDescription.bindText("/processes/Process/description");
		return this.processForm;
	},
	
	modifyViewContents: function(modifyType) {
		if (modifyType === 1) this.updateContent();
	},
	
	updateModel: function(oModel) {
		if (oModel) this.dataModel.setData(oModel);
		this.updateContent();
	},
	
	updateContent: function() {
		var oFCntrl = oStub.oFather;
		if (oFCntrl) {
			var data = oFCntrl.oProcRepo.cProcLst;
			if (data) {
				this.processsTitle.setModel(data);
				this.processsDescription.setModel(data);
				this.processsTitle.bindText("/Process/displayName");
				this.processsDescription.bindText("/Process/description");
				var currentID = $(data.getData()).find("id")[0].textContent;
				if (currentID) oFCntrl.oProcRepo.leadProcId = currentID;
			}
		}
	},
	
	executeBtnPress: function() {
		var oFCntrl = oStub.oFather;
		sap.ui.core.BusyIndicator.show(1);
		oFCntrl.startProcessExecution();
		window.setTimeout(sap.ui.core.BusyIndicator.hide(), 4000);
	},
	
	selectionEvent: function(oEvent) {
		var selectedRowContext = oEvent.getParameter("rowContext");
		var selectedClientId = oFCntrl.oProcRepo.cProcLst.getProperty("id", selectedRowContext);
		oFCntrl.oProcRepo.leadProcId = selectedClientId;
	}
});
