jQuery.sap.declare(sluiCore.mod.jsutil);
jQuery.sap.require("sap.m.MessageBox");

//this is to extend the Array functionality by the .find() method which might be missing in some browsers
if (typeof Array.prototype.find !== 'function') {
	Array.prototype.find = function(funct) {
		var array = Object(this);
		for (var i = 0; i < array.length; i++) if (funct.call(arguments[1], array[i], i, array)) return array[i];
		return undefined;
	};
}

//other missing functions
if (typeof String.prototype.startsWith !== 'function') {
	String.prototype.startsWith = function(str){
		return this.slice(0, str.length) === str;
	};
}

if (typeof String.prototype.endsWith !== 'function') {
	String.prototype.endsWith = function(str){
		return this.slice(-str.length) === str;
	};
}

if (typeof String.prototype.capitalizeFirstLetter !== 'function') {
	String.prototype.capitalizeFirstLetter = function() {
		return this.charAt(0).toUpperCase() + this.slice(1);
	};
}

SLUIUtility = function() {};

SLUIUtility.prototype.checkClientProperties = function(oSettings) {
	if(oSettings["showSLPLogsinSB"] === undefined) oSettings["showSLPLogsinSB"] = true;
	if(oSettings["showSLPBreakPointsinSB"] === undefined) oSettings["showSLPBreakPointsinSB"] = true;
	if(oSettings["showSLPTasklistinSB"] === undefined) oSettings["showSLPTasklistinSB"] = true;
};

// returns true if the state is of desired kind, return false otherwise
// modes:
// 0: returns true if state is slp.task.state.DIALOG
// 1: returns true if state is slp.task.state.ERROR
// 2: returns true if state is slp.task.state.DIALOG or slp.task.state.BREAKPOINT
// 3: returns true if state is slp.task.state.DIALOG or slp.task.state.ERROR or slp.task.state.BREAKPOINT
// 4: returns true if state is slp.task.state.DIALOG or slp.task.state.ERROR or slp.task.state.BREAKPOINT or slp.task.state.ACTION_REQUIRED or slp.task.state.RUNNING
// 5: returns true if state is slp.task.state.DIALOG or slp.task.state.ERROR or slp.task.state.BREAKPOINT or slp.task.state.ABORTED
SLUIUtility.prototype.checkMonitorState = function(state, mode) {
    if 		(mode === 0) return state === suiCnst.SLP_TASK_STATUS_DIALOG;
    else if (mode === 1) return state === suiCnst.SLP_TASK_STATUS_ERROR;
    else if (mode === 2) return (state === suiCnst.SLP_TASK_STATUS_DIALOG) || (state === suiCnst.SLP_TASK_STATUS_BREAKPOINT);
    else if (mode === 3) return (state === suiCnst.SLP_TASK_STATUS_DIALOG) || (state === suiCnst.SLP_TASK_STATUS_ERROR) || (state === suiCnst.SLP_TASK_STATUS_BREAKPOINT);
    else if (mode === 4) return (state === suiCnst.SLP_TASK_STATUS_DIALOG) || (state === suiCnst.SLP_TASK_STATUS_ERROR) || (state === suiCnst.SLP_TASK_STATUS_BREAKPOINT) || (state === suiCnst.SLP_TASK_STATUS_ACTION_REQUIRED) || (state === suiCnst.SLP_TASK_STATUS_RUNNING);
    else if (mode === 5) return (state === suiCnst.SLP_TASK_STATUS_DIALOG) || (state === suiCnst.SLP_TASK_STATUS_ERROR) || (state === suiCnst.SLP_TASK_STATUS_BREAKPOINT) || (state === suiCnst.SLP_TASK_STATUS_ABORTED);
    return false;
};

SLUILogger = function(bTrace) {
	if (sluiCore.inDebug) this.trace = true;	
	else {if(bTrace!=undefined || bTrace !="") this.trace = bTrace; else this.trace = false;}
	if (window.console === undefined) this.console = {log: function() {}};
	else this.console = console;
};

SLUILogger.prototype.logI = function(msg, mod, mtd) {
    this._log2con(msg, suiCnst.UI_LOG_TYPE_INFO, mod, mtd);
};

SLUILogger.prototype.logE = function(msg, mod, mtd) {
    this._log2con(msg, suiCnst.UI_LOG_TYPE_ERROR, mod, mtd);
    this._log2User(msg, suiCnst.UI_LOG_TYPE_ERROR);
};

SLUILogger.prototype.logSE = function(errObj) {
    this._log2conErr(errObj);
};

SLUILogger.prototype.logW = function(msg, mod, mtd) {
    this._log2con(msg, suiCnst.UI_LOG_TYPE_WARN, mod, mtd);
};

SLUILogger.prototype.logD = function(msg, mod, mtd) {
    this._log2con(msg, suiCnst.UI_LOG_TYPE_DEBUG, mod, mtd);
};

SLUILogger.prototype.logO = function(msg, mod, mtd) {
    this._log2con(msg, suiCnst.UI_LOG_TYPE_OTR, mod, mtd);
};

SLUILogger.prototype._log2con = function(msg, typ, mod, mtd) {
	if (this.trace) {
		if (msg && typ && mtd && mod) this.console.log("SLUI:" + typ + ".@" + msg + ".@mod:" + mod + ".@mtd:" + mtd);
		else if (msg && typ) this.console.log("SLUI:" + typ + " - @ -" + msg);
		else if (msg) this.console.log("SLUI:" + msg);
	}
};

SLUILogger.prototype._log2User = function(msg, type) {
    var obj = new SLUIDialogProvider();
    if (!obj) sap.m.MessageBox.error("Severe Error: SLUIDialogProvider not available.");
    if (type === suiCnst.UI_LOG_TYPE_ERROR) obj.getDialog("errorDialog", msg + '\n' + suiCnst.UI_TEXT_ERROR_ADDINFO, suiCnst.UI_TEXT_ERROR_HEAD, {showButtons: true}).open();
};

SLUILogger.prototype._log2conErr = function (errObj) {
	if (errObj) {
		this.console.log("----------------------------------------");
		this.console.log("   ERROR OCCURED :  Details as follows  ");
		this.console.log("----------------------------------------");
	    if (errObj.resourceName) 	this.console.log("Resource name: "+errObj.resourceName);
	    if (errObj.statusCode) 		this.console.log("Status Code: "+errObj.statusCode); 
	    if (errObj.statusTxt) 		this.console.log("Status text: "+errObj.statusTxt);
	    if (errObj.occurdAt) 		this.console.log("Occured At : "+errObj.occurdAt);
	    if (errObj.devMsg) {
	    	this.console.log("Detailed Message: "+errObj.devMsg);
	    	this.console.log("\n ");
	    	this.console.log(errObj.devMsg);
	    }
	    this.console.log("----------------------------------------");
	}
};

//htmlencode and htmldecode stuff
function htmlEncode(str) {
    return String(str)
            .replace(/&/g, '&amp;')
            .replace(/"/g, '&quot;')
            .replace(/'/g, '&#39;')
            .replace(/</g, '&lt;')
            .replace(/>/g, '&gt;');
};

function htmlDecode(value) {
    return String(value)
        .replace(/&quot;/g, '"')
        .replace(/&#39;/g, "'")
        .replace(/&lt;/g, '<')
        .replace(/&gt;/g, '>')
        .replace(/&amp;/g, '&');
};

// global utility functions
function closeDialog(oControlEvent) {
	oControlEvent.getSource().getParent().close();
};

function isIE() {
    try {
        var agt = navigator.userAgent.toLowerCase();
        if 		(agt.indexOf("msie") != -1)  return true;  		//IE 10
        else if (agt.indexOf("trident") != -1) return true;		//IE 11
        else if (agt.indexOf("edge") != -1) return true;		//Edge
    }
    catch (e) {return false;}
};

function logout() {
	var mozMessage = "<div><b>Logout done...<br/>Firefox users be advised to restart the browser to be able to logon again successfully.</b><br/><a href=\"javascript:void(0);\" onclick=\"document.location.reload();\" >Reload Page</a></div>";
	var ieMessage = "<div><b>Logout done...<br/>You can re-logon by entering your credentials again.</b><br/><a href=\"javascript:void(0);\" onclick=\"document.location.reload();\" >Reload Page</a></div>";
	if (isIE()) {
		document.getElementById("id-content-div").innerHTML = ieMessage;
		setTimeout(function() {
			document.execCommand("ClearAuthenticationCache");
			location.reload();
		});
	} else {
		document.getElementById("id-content-div").innerHTML = mozMessage;
		//default: logout for abap realm
		var url = document.URL.split("//")[0] + "//" + "logout:logout@" + document.URL.split("//")[1];
		$.ajax({
			type: 		"GET",
			url: 		url,
			dataType: 	"text",
			async: 		false,
			cache: 		false,
			success: 	function() {sap.m.MessageBox.error("Error Logout: The server could not terminate the session, you might still be logged on!");},
			error: 		function(xhr, options, errorText) {location.reload();}
		});
	}
};

function slpxml2json(xmlObj) {
	// Create the return object
	var retObj = {};
	if (xmlObj.nodeType === 3) retObj = xmlObj.nodeValue;   // text
	// do children
	if (xmlObj.hasChildNodes()) {
		for (var i = 0; i < xmlObj.childNodes.length; i++) {
			var item = xmlObj.childNodes.item(i);
			var nodeName = item.nodeName;
			if (nodeName === "#text") return item.nodeValue;
			if (typeof(retObj[nodeName]) === "undefined") retObj[nodeName] = slpxml2json(item);
			else {
				if (typeof(retObj[nodeName].push) === "undefined") {
					var old = retObj[nodeName];
					retObj[nodeName] = [];
					retObj[nodeName].push(old);
				}
				retObj[nodeName].push(slpxml2json(item));
			}
		}
	}
	else if (xmlObj.nodeValue === null) return "";            
	return retObj;
};

function saveFile(fileName) {
	var that = {};
	that.file = fileName;
	var xhr = new XMLHttpRequest(); 
	xhr.open("GET", oStub.oFather.oProcExe.oUIProc.urls.logsUrl + '/' + encodeURIComponent(fileName)); 
	xhr.responseType = "blob";
	xhr.onload = $.proxy(function() { 
		if (window.navigator.msSaveOrOpenBlob) window.navigator.msSaveBlob(xhr.response, this.file);
		else {
			var elem = window.document.createElement('a');
			elem.href = window.URL.createObjectURL(xhr.response);
			elem.download = this.file;        
			document.body.appendChild(elem);
			elem.click();        
			document.body.removeChild(elem);
		}    		
	}, that);
	xhr.send();          	
};

function openHelpWindow() {
    var SID = document.URL.split("/")[5];
    var TOOL = document.URL.split("/")[4];
	var myWindow = window.open("/lmsl/" + TOOL + "/" + SID + "/guide/" + (globals.lastGuide ? globals.lastGuide : "HDB/std") + "/" + (globals.lastLOIO ? globals.lastLOIO : "index") + ".html", "_blank");	
}
