jQuery.sap.declare("support.modules.renderers.EnterDebugXMLDialog");
jQuery.sap.require("support.modules.communicator.DebugSLUIServiceCommunicator");

support.modules.renderers.EnterDebugXMLDialog = function(oClient){
	this.oClient = oClient;
};

support.modules.renderers.EnterDebugXMLDialog.prototype.openDialog = function(){
	if(this.oDialog == null){
	var oBtnOk = new sap.ui.commons.Button({
		text : "OK",
		press : [this.okButtonPressed, this]
	});
	
	this.oView = sap.ui.jsview("support.modules.renderers.DebugXMLView");
	
	this.oDialog = new sap.ui.commons.Dialog({
        modal : true,
        title: "Enter the XML",
        buttons : [ oBtnOk ],
        content : [ this.oView ]
	});
}
	this.oDialog.open();

};

support.modules.renderers.EnterDebugXMLDialog.prototype.okButtonPressed = function(){
	var modelChanged = this.oView.getController().changeModel(this.oView.getController());
	if(modelChanged){
		var currProcess = this.oClient. getCurrentProcess();
		this.oClient.setMockServiceConnector(new support.modules.communicator.DebugSLUIServiceCommunicator(currProcess.urls.rootURL));
		this.oClient.getProcessExecutor().externalExecute(true,true,true,true);
	}
	this.oDialog.close();
};