jQuery.sap.declare("support.modules.utility.ResourceCollector");
jQuery.sap.require("support.modules.utility.File");
jQuery.sap.require(sluiCore.mod.jsdiaProv);

support.modules.utility.ResourceCollector = {

	/**
	 * Collect all SLP resources and save them in one XML file
	 */
	collectResourcesAndSave: function(sSlpUrl){	
		var resources = ["monitor", "actions", "dialogs", "roadmap", "config","breakpoints","logs","tasklist"];
		var oTransObject = {
			resources: resources,
			xmlDocument: $.parseXML("<slpDebug></slpDebug>"),
			slpUrl: sSlpUrl
		};
		support.modules.utility.ResourceCollector._performGetResourcesAndWait(oTransObject, support.modules.utility.ResourceCollector._loadMetadialogs);
	},
	
	_performGetResourcesAndWait: function(oTransObject, doneFunction, failFunction){	
		var deferreds = [];	
	    $.each(oTransObject.resources, function(i, resource) {
	    	deferreds.push($.ajax({
	    		url: oTransObject.slpUrl +'/'+resource,
	    		success: function(xml){
	    	    	var oRoot = $(oTransObject.xmlDocument).find("slpDebug");
	    	    	var resourceElement = $($.parseXML("<resource></resource>")).find("resource");
	    	    	$(resourceElement).attr("id", resource);
	    	    	$(resourceElement).append($(xml).children());	
	    	    	$(oRoot).append(resourceElement);		  	
	    		}
	    	}));  
	    });
	
		$.when.apply($, deferreds).done( function(){
			if(doneFunction){
				doneFunction(oTransObject);
			}
		} ).fail( function(){
			if(failFunction){
				failFunction(oTransObject);
			}
		} );
		
	},
	
	_saveXML: function(oTransObject){	
		var serializer = new XMLSerializer(); 
		support.modules.utility.File.save(serializer.serializeToString(oTransObject.xmlDocument), "supportFile", "xml", "application/xml", "UTF-8"); 
	},
	
	_loadMetadialogs: function(oTransObject){	
		//read the metadialog
		var metadialogs = $(oTransObject.xmlDocument).find('Dialog > metadialog'); 
		var resources = [];
		$.each(metadialogs, function(i, metadialog) {
			resources.push("dialogs/"+ $(metadialog).text());
		});
		oTransObject.resources = resources;
		support.modules.utility.ResourceCollector._performGetResourcesAndWait(oTransObject, support.modules.utility.ResourceCollector._saveXML, function () {
	    	new SLUIDialogProvider().getDialog("errorDialog", "The support file cannot be created. Some of the needed resources cannot be retireved.", "Failed to create support file").open();
		});
	}

};
