/*!
 * SAPUI5

(c) Copyright 2009-2019 SAP SE. All rights reserved
 */
sap.ui.define(['sap/chart/library','sap/viz/ui5/controls/VizFrame','sap/viz/ui5/controls/common/BaseControl','sap/viz/ui5/data/Dataset','sap/viz/ui5/data/FlattenedDataset','sap/viz/ui5/data/DimensionDefinition','sap/viz/ui5/data/MeasureDefinition','sap/chart/data/Dimension','sap/chart/data/TimeDimension','sap/chart/data/HierarchyDimension','sap/chart/data/Measure','sap/ui/model/analytics/ODataModelAdapter','sap/chart/utils/RoleFitter','sap/chart/utils/ChartUtils','sap/chart/utils/ChartTypeAdapterUtils','sap/chart/utils/DateFormatUtil','sap/chart/utils/DataSourceUtils','sap/chart/utils/SelectionAPIUtils','sap/chart/utils/MeasureSemanticsUtils','sap/viz/ui5/controls/common/feeds/FeedItem','sap/ui/model/Filter','sap/ui/model/FilterOperator','sap/ui/model/FilterType','sap/ui/model/analytics/odata4analytics','sap/ui/Device','sap/chart/TimeUnitType','sap/chart/coloring/Colorings','sap/chart/ChartLog','sap/chart/pagination/PagingController','sap/ui/core/LocaleData','sap/ui/core/Control','sap/ui/core/BusyIndicatorUtils','sap/ui/core/theming/Parameters','sap/chart/SeriesColorTracker','sap/viz/ui5/format/ChartFormatter','sap/chart/utils/ValueAxisScaleUtils','sap/chart/AutoScaleMode','sap/chart/ScaleBehavior','sap/viz/ui5/utils/CommonUtil',"sap/base/Log","sap/ui/thirdparty/jquery"],function(l,V,B,D,F,a,M,b,T,H,c,O,R,C,f,g,h,S,n,q,r,s,t,u,w,x,y,z,P,L,A,E,G,I,J,K,N,Q,U,W,X){"use strict";var Y=B.extend("sap.chart.Chart",{metadata:{library:"sap.chart",designtime:"sap/chart/designtime/Chart.designtime",properties:{chartType:{type:"string",defaultValue:"bar"},uiConfig:{type:"object",group:"Misc"},visibleDimensions:{type:"string[]",defaultValue:[]},inResultDimensions:{type:"string[]",defaultValue:[]},visibleMeasures:{type:"string[]",defaultValue:[]},vizProperties:{type:"object",group:"Misc"},vizScales:{type:"object[]",group:"Misc"},isAnalytical:{type:"boolean"},selectionBehavior:{type:"sap.chart.SelectionBehavior",defaultValue:sap.chart.SelectionBehavior.DataPoint},selectionMode:{type:"sap.chart.SelectionMode",defaultValue:sap.chart.SelectionMode.Multi},enablePagination:{type:"boolean",defaultValue:false},enableStableColor:{type:"boolean",defaultValue:false},enableScalingFactor:{type:"boolean",defaultValue:false},customMessages:{type:"object",defaultValue:null},colorings:{type:"object",defaultValue:null},activeColoring:{type:"object",defaultValue:null},valueAxisScale:{type:"object",defaultValue:null}},aggregations:{data:{type:"sap.ui.core.Element",multiple:true,bindable:"bindable"},_vizFrame:{type:"sap.viz.ui5.controls.VizFrame",multiple:false,visibility:"hidden"},dimensions:{type:"sap.chart.data.Dimension",multiple:true},measures:{type:"sap.chart.data.Measure",multiple:true}},events:{drilledDown:{parameters:{dimensions:{type:"string[]"}}},drilledUp:{parameters:{dimensions:{type:"string[]"}}},renderComplete:{},selectData:{},deselectData:{},valueAxisFixedScaleTurnedOff:{},drillStackChanged:{}}},renderer:function(o,d){o.write("<div");o.writeControlData(d);o.addStyle("width",d.getWidth());o.addStyle("height",d.getHeight());o.writeStyles();o.write(">");o.renderControl(d.getAggregation("_vizFrame"));o.write("</div>");}});Y.getMetadata().getAggregation("data")._doesNotRequireFactory=true;function Z(v){return v.indexOf("%")!==-1?"100%":v;}Y.prototype.setHeight=function(v){this.setProperty("height",v);var o=this._getVizFrame();if(o){o.setHeight(Z(this.getProperty("height")));}return this;};Y.prototype.setWidth=function(v){this.setProperty("width",v);var o=this._getVizFrame();if(o){o.setWidth(Z(this.getProperty("width")));}return this;};Y.prototype.setChartType=function(d,e){this.setProperty("chartType",d,e);this._bIsPagingChartType=C.CONFIG.pagingChartTypes.indexOf(d)>-1;if(this._isEnablePaging()){this._getPagingController().init(false);}else{var o=this._getDataset();if(o){o.setPagingOption(null);o.setRange(-1,-1);}}this._invalidateBy({source:this,keys:{vizFrame:true}});this._bNeedToApplyDefaultProperties=true;return this;};Y.prototype.setColorings=function(v){this.setProperty("colorings",v);this._invalidateBy({source:this,keys:{vizFrame:true,checkBinding:true}});return this;};Y.prototype.setActiveColoring=function(v){this.setProperty("activeColoring",v);this._invalidateBy({source:this,keys:{vizFrame:true,checkBinding:true}});return this;};Y.prototype.setValueAxisScale=function(v){this._bEnbableValueAxisScale=true;this.setProperty("valueAxisScale",v);if(this._oValueScaleSetting&&this._oValueScaleSetting.fireValueAxisFixedScaleTurnedOff){this._oValueScaleSetting.fireValueAxisFixedScaleTurnedOff=false;this._oValueScaleSetting.resetValueAxisScale=true;}this._invalidateBy({source:this,keys:{vizFrame:true}});return this;};Y.prototype._setValueAxisScale=function(){var v=this.getValueAxisScale(),d=!this._rendered&&!!v,e=!(this._mNeedToUpdate['binding']&&this._oValueScaleSetting)&&this._bEnbableValueAxisScale;if(d||e){if(!this._bEnbableValueAxisScale){this._bEnbableValueAxisScale=true;}this._oValueScaleSetting=K.getValueAxisScaleSetting(this.getChartType(),v,this.getMeasures(),this.getVisibleMeasures());}};Y.prototype._getValueAxisScaleSetting=function(){return this._bEnbableValueAxisScale?this._oValueScaleSetting||{}:{};};Y.prototype._validateValueScaleOnDimChange=function(d,o){if(o&&this._oValueScaleSetting){var v=this.getValueAxisScale();if(v&&v.scaleBehavior===Q.FixedScale){var e=[];d.forEach(function(k){var m=o.indexOf(k);if(m<0){e.push(k);}else{o.splice(m,1);}});e=e.concat(o);if(e.length>0){var i=false,j=this.getChartType();if(C.isStackedLikeChart(j)){i=true;e.forEach(function(k){if(k._getFixedRole()!=='series'){i=false;}});}if(!i){this._oValueScaleSetting.fireValueAxisFixedScaleTurnedOff=true;v.scaleBehavior=Q.AutoScale;this.setProperty('valueAxisScale',v);this.fireValueAxisFixedScaleTurnedOff();if(this._oValueScaleSetting.resetValueAxisScale){v=this.getValueAxisScale();this.setProperty('valueAxisScale',v);}this._oValueScaleSetting=K.getValueAxisScaleSetting(j,v,this.getMeasures(),this.getVisibleMeasures());}}else{this._oValueScaleSetting=K.getValueAxisScaleSetting(this.getChartType(),v,this.getMeasures(),this.getVisibleMeasures());}}}};Y.prototype.removeDimension=function(d){var v=this._getVisibleDimensions()||[];var i;if(this.getIsAnalytical()===false&&d&&d.getName()){i=v.indexOf(d.getName());if(i!==-1){W.error('Data source does not support aggregation. The method "removeDimension" therefore cannot be used!');return;}}var o=this.removeAggregation("dimensions",d);if(o){i=v.indexOf(o.getName());if(i!==-1){v.splice(i,1);this.setVisibleDimensions(v);}var e=this.getInResultDimensions()||[];i=e.indexOf(o.getName());if(i!==-1){e.splice(i,1);this.setInResultDimensions(e);}}return o;};Y.prototype.removeAllDimensions=function(){var o;if(this.getIsAnalytical()===false){W.error('Data source does not support aggregation. The method "removeAllDimensions" therefore cannot be used!');}else{o=this.removeAllAggregation("dimensions");this.setVisibleDimensions([]);this.setInResultDimensions([]);}return o;};Y.prototype.destroyDimensions=function(){var o;if(this.getIsAnalytical()===false){W.error('Data source does not support aggregation. The method "destroyDimensions" therefore cannot be used!');}else{o=this.destroyAggregation("dimensions");this.setVisibleDimensions([]);this.setInResultDimensions([]);}return o;};Y.prototype.removeMeasure=function(m){var o=this.removeAggregation("measures",m);if(o){var v=this._getVisibleMeasures()||[],i=v.indexOf(o.getName());if(i!==-1){v.splice(i,1);this.setVisibleMeasures(v);}}return o;};Y.prototype.removeAllMeasures=function(){var o=this.removeAllAggregation("measures");this.setVisibleMeasures([]);return o;};Y.prototype.destroyMeasures=function(){var o=this.destroyAggregation("measures");this.setVisibleMeasures([]);return o;};Y.prototype._getVisibleDimensions=function(d){var o=this._getDrillStateTop();var e=o?o.dimensions:this.getProperty("visibleDimensions");return d?this._normalizeDorM(e,true):e;};Y.prototype.getVisibleDimensions=function(){var v=this._getVisibleDimensions();return this._aFeeds?v.filter(function(d){return this._aFeeds._unused.indexOf(d)===-1;},this):v;};Y.prototype._getVisibleMeasures=function(d){var o=this._getDrillStateTop();var m=o?o.measures:this.getProperty("visibleMeasures");return d?this._normalizeDorM(m):m;};Y.prototype.getVisibleMeasures=function(){var v=this._getVisibleMeasures();return this._aFeeds?v.filter(function(d){return this._aFeeds._unused.indexOf(d)===-1;},this):v;};Y.prototype.setVisibleDimensions=function(v,d){var m=this._dimensionSanityCheck({visible:v});this.setProperty("visibleDimensions",v,d);this.setProperty("inResultDimensions",m.inResult,d);this._createDrillStack();this._invalidateBy({source:this,keys:{binding:true,dataSet:true,vizFrame:true}});return this;};Y.prototype.setInResultDimensions=function(i,d){var m=this._dimensionSanityCheck({inResult:i});this.setProperty("inResultDimensions",i,d);this.setProperty("visibleDimensions",m.visible,d);this._createDrillStack();this._invalidateBy({source:this,keys:{binding:true,dataSet:true,vizFrame:true}});return this;};Y.prototype.setVisibleMeasures=function(m,d){this.setProperty("visibleMeasures",m,d);var o=this._getDrillStateTop();if(!this._bIsInitialized){this._createDrillStack();}else{o.measures=this.getProperty("visibleMeasures");}this._invalidateBy({source:this,keys:{binding:true,dataSet:true,vizFrame:true}});return this;};Y.prototype.setEnableStableColor=function(v){v=!!v;if(this.getProperty("enableStableColor")!==v){this.setProperty("enableStableColor",v);this._invalidateBy({source:this,keys:{vizFrame:true}});}return this;};Y.prototype.setEnablePagination=function(e,d){if(!this._bIsInitialized){this.setProperty("enablePagination",e,d);this._createDrillStack();this._invalidateBy({source:this,keys:{binding:true,dataSet:true,vizFrame:true}});}return this;};Y.prototype._dimensionSanityCheck=function(d){var v=d.visible||this.getVisibleDimensions()||[],i=d.inResult||this.getInResultDimensions()||[];var m=[].concat(v).concat(i).reduce(function(e,j){var k=v.indexOf(j)!==-1,o=i.indexOf(j)!==-1;if(k&&o){e.common[j]=true;}else if(k){e.visible[j]=true;}else if(o){e.inResult[j]=true;}return e;},{visible:{},inResult:{},common:{}});m.visible=Object.keys(m.visible);m.inResult=Object.keys(m.inResult);m.common=Object.keys(m.common);return m;};Y.prototype._prepareFeeds=function(){if(!this._aFeeds){var d=this._normalizeDorM(this._getVisibleDimensions(),true),m=this._normalizeDorM(this._getVisibleMeasures(),false),i=this._normalizeDorM(this.getInResultDimensions(),true),e;this._sAdapteredChartType=this.getEnablePagination()?this.getChartType():f.adaptChartType(this.getChartType(),d);var v=this._getVisibleMeasures();e=this._normalizeDorM(this.getMeasures().filter(function(j){return v.indexOf(j.getName())===-1;}),false);this._aFeeds=R.fit(this._sAdapteredChartType,d,m,i,this._enableSemanticPattern(),e);if((!this._aFeeds._valid||this._aFeeds._unused.length)&&this._sAdapteredChartType!==this.getChartType()){this._sAdapteredChartType=this.getChartType();this._aFeeds=R.fit(this._sAdapteredChartType,d,m,i,this._enableSemanticPattern());}if(this._sAdapteredChartType!==this.getChartType()){this._bNeedToApplyDefaultProperties=true;}}return this._aFeeds;};Y.prototype._normalizeDorM=function(m,i){var d=i?this.getDimensions():this.getMeasures(),e=d.reduce(function(p,v){p[v.getName()]=v;return p;},{}),j=i?b:c;var o=m.reduce(function(o,p){var v;if(typeof p==="string"){v=p;}else if(p instanceof j){v=p.getName();}else{o.errors.push(p);}if(e[v]){o.normalized.push(e[v]);}else{o.errors.push(p);}return o;},{normalized:[],errors:[]});var k=o.normalized;if(o.errors.length>0){k.errors=o.errors;}return k;};Y.prototype._redundantsFromSelection=function(){var d=this._getVizFrame().vizSelection();if(!d||d.length===0){return{measureNames:{}};}var o=this._getContinuesSemanticTuples();var m=d.reduce(function(i,j){var p=[];for(var g1 in o){if(o.hasOwnProperty(g1)){var h1=o[g1];if(j.data[g1]){p.push((j.data[h1.timeAxis]<h1.projectedValueStartTime)?h1.projected:h1.actual);}else{p.push(h1.actual);p.push(h1.projected);}}}X.each(j.data,function(k,v){if(!(p.length>0&&p.indexOf(k)>-1)){if(!i[k]){i[k]=[];}if(i[k].indexOf(v)===-1){i[k].push(v);}}});return i;},{});var e=this._getVisibleDimensions().reduce(function(i,j){var v=m[j];if(v.length===1){i[j]=v[0];}return i;},{});e.measureNames=this._getVisibleMeasures().reduce(function(i,j){if(!m[j]){i[j]=true;}return i;},{});return e;};Y.prototype._deriveFilterFromSelection=function(){var v=this._getVisibleDimensions();var d=this;var e=this._getVizFrame().vizSelection();if(this.getSelectionBehavior().toUpperCase()===sap.chart.SelectionBehavior.Category){e=e.category;}else if(this.getSelectionBehavior().toUpperCase()===sap.chart.SelectionBehavior.Series){e=e.series;}var i=false;var j=e.map(function(k){var p=v.reduce(function(g1,h1){var i1=d.getDimensionByName(h1);var j1;j1=k.data[h1];if(j1!=null){if(C.CONFIG.timeChartTypes.indexOf(d._sAdapteredChartType)>-1&&i1 instanceof T){var k1=g.getInstance(i1.getTimeUnit());if(k1){var l1=k1.format.bind(k1);j1=l1(new Date(k.data[h1]));}}var m1=new r({path:h1,operator:s.EQ,value1:j1});if(i1 instanceof H){g1.hierarchyFilters.push(m1);i=true;}else{g1.filters.push(m1);}g1.signature.push(h1+"="+k.data[h1]);}return g1;},{filters:[],hierarchyFilters:[],signature:[]});p.signature=p.signature.join(";");return p;});var m=j.reduce(function(k,p){if(!k[p.signature]&&(p.filters.length+p.hierarchyFilters.length>0)){k[p.signature]={filters:p.filters.length?new r(p.filters,true):null,hierarchyFilters:p.hierarchyFilters.length?new r(p.hierarchyFilters,true):null};}return k;},{});var o=Object.keys(m).map(function(k){return{filters:m[k].filters,hierarchyFilters:m[k].hierarchyFilters};});if(o.length>1){if(i){return{hierarchyFilters:new r(o.map(function(k){return k.hierarchyFilters;}),false)};}else{return{filters:new r(o.map(function(k){return k.filters;}),false)};}}else if(o.length===1){return{filters:o[0].filters,hierarchyFilters:o[0].hierarchyFilters};}else{return{filters:null,hierarchyFilters:null};}};function $(){var d=this.getSelectionBehavior();var e=this._getVisibleDimensions().concat(this.getInResultDimensions()).filter(function(k){var o=this.getDimensionByName(k);if(d.toUpperCase()===sap.chart.SelectionBehavior.Category){return o._getFixedRole()==="category"||o._getFixedRole()==="category2";}else if(d.toUpperCase()===sap.chart.SelectionBehavior.Series){return o._getFixedRole()==="series";}return true;}.bind(this));var i=e.some(function(k){var o=this.getDimensionByName(k);return o instanceof H;}.bind(this));var j;if(d.toUpperCase()===sap.chart.SelectionBehavior.Category){j=this.getSelectedCategories().categories;}else if(d.toUpperCase()===sap.chart.SelectionBehavior.Series){j=this.getSelectedSeries().series;}else{j=this.getSelectedDataPoints().dataPoints;}if(i&&Object.keys(e).length>1&&j.length>1){return false;}return true;}Y.prototype._checkDrilldownValid=function(d){if(this._bEmptyData){W.error("Drill down not possible, because there is already no data available!");return false;}var e=this.getInResultDimensions();var v=this._getVisibleDimensions().concat(e).reduce(function(g1,h1){g1[h1]=true;return g1;},{});if(!$.call(this)){W.error("Drill down not possible, because multiple selections on hierarchy/regular mixed dimension is not supported in backend service!");return false;}function j(g1,h1){var i1=true;if(h1[g1.getName()]){if(!(g1 instanceof H)){W.error("Drill down not possible, because one of the given dimensions is already drilled down!");i1=false;}else{if(e.indexOf(g1.getName())>-1){W.error("Drill down not possible, because one of the given dimensions is inResult!");i1=false;}}}return i1;}for(var i=0;i<d.length;++i){if(!j(d[i],v)){return false;}}var m=d.reduce(function(g1,h1){g1[h1.getName()]=h1;return g1;},{});var k=this;function o(g1){if(Array.isArray(g1.aFilters)){return g1.aFilters.some(o);}else{return!j(k.getDimensionByName(g1.sPath),m);}}var p=this._getDrillStateTop();if(p&&p.filter&&o(p.filter)){return false;}return true;};Y.prototype._createDrillStack=function(){this._drillStateStack=_.call(this);var v=this.getProperty("visibleDimensions")||[];this._aUnavailableDims=v.filter(function(d){return!this.getDimensionByName(d);}.bind(this));if(this._aUnavailableDims.length){this._invalidateBy({source:this,keys:{drillStack:true}});}else{this.fireDrillStackChanged(this.getDrillStack());}};Y.prototype._updateDrillStack=function(){var d=this._aUnavailableDims.some(function(e){return this.getDimensionByName(e)instanceof H;}.bind(this));if(d){this._drillStateStack=_.call(this);}this._aUnavailableDims=[];this.fireDrillStackChanged(this.getDrillStack());};function _(){var v=this.getProperty("visibleDimensions")||[],d=this.getProperty("visibleMeasures")||[],e=[{dimensions:[],measures:d,filter:undefined,nonHierarchyFilters:undefined,hierarchyFilters:undefined,hierarchylevel:{}}],j=[];var o={};for(var i=0;i<v.length;i++){var k=v[i];j.push(k);var m=this.getDimensionByName(k);if(m&&m instanceof H){o[k]=m.getLevel();}e.push({dimensions:j.slice(),measures:d,filter:undefined,nonHierarchyFilters:undefined,hierarchyFilters:undefined,hierarchylevel:X.extend(true,{},o)});}return e;}Y.prototype._invalidateBy=function(o){var d=o.source;var e=this._oCandidateColoringSetting?(this._oCandidateColoringSetting.additionalDimensions||[]):[];if(d===this){X.each(o.keys||{},function(k,v){this._markForUpdate(k,v);}.bind(this));}else if(d instanceof c&&this._getVisibleMeasures().indexOf(d.getName())!==-1){this._markForUpdate("dataSet",true);this._markForUpdate("vizFrame",true);if(o.property==="unitBinding"||(this.getColorings()&&(o.property==='semantics'||o.property==='semanticallyRelatedMeasures'))){this._markForUpdate("binding",true);}}else if(d instanceof b&&this._getVisibleDimensions().concat(e).indexOf(d.getName())!==-1){this._markForUpdate("dataSet",true);this._markForUpdate("vizFrame",true);if((d.getDisplayText()&&(o.property==="textProperty"||o.property==="displayText"))){this._markForUpdate("binding",true);}else if(o.property==='level'&&this.getProperty('visibleDimensions').indexOf(d.getName())>-1){this._createDrillStack();this._markForUpdate("binding",true);}}else if(d instanceof b&&this.getProperty('inResultDimensions').indexOf(d.getName())>-1){if(o.property==='level'){this._markForUpdate("dataSet",true);this._markForUpdate("binding",true);this._markForUpdate("vizFrame",true);}}this.invalidate(o);};Y.prototype._handleNonAnalyticalFeeding=function(){var d=this;var i=this.getInResultDimensions();var v=this._getVisibleDimensions(),e=this.getDimensions().map(function(o){return o.getName();});var j=[];e.forEach(function(m){if(d.getDimensionByName(m)){var o=d.getDimensionByName(m).getTextProperty();if(o){j.push(o);}}});var k=v.concat(e.filter(function(m){return(v.indexOf(m)<0);})).filter(function(m){return(j.indexOf(m)<0)&&(i.indexOf(m)<0);});this.setProperty("visibleDimensions",k);this._createDrillStack();};Y.prototype._markForUpdate=function(k,d){if(!this._mNeedToUpdate){this._mNeedToUpdate={};}this._mNeedToUpdate[k]=d;var o=this._updaters.onInvalidate[k];if(o){o.call(this);}};Y.prototype._updaters=(function(){return{onInvalidate:{vizFrame:function(){this._aFeeds=null;this._bColoringParsed=null;},checkBinding:function(){this._bColoringParsed=null;},binding:function(){this._bColoringParsed=null;},loopData:function(){this._bColoringParsed=null;}},checkBinding:function(){var o=this._getCandidateColoringSetting();var d=o.additionalDimensions;var e=o.additionalMeasures;if((d&&d.length)||(e&&e.length)){this._mNeedToUpdate["binding"]=true;}},drillStack:function(){this._updateDrillStack();},dataSet:function(){this._getDataset().invalidate();},binding:function(){var o=this._getDataset().getBinding("data"),i=this.getInResultDimensions();if(!o){return;}var d=this._getVisibleDimensions(true).concat(this._normalizeDorM(i,true));var m=this._getVisibleMeasures(true);this._oMeasureRangePromise=h.updateModel(this.getIsAnalytical())(this,d,m);var e=this._getDrillStateTop();if(d.length>0||m.length>0){this._getVizFrame()._readyToRender(false);this.setBusy(true);}this._bFilterCalledByChart=true;o.filter((e&&e.filter)?e.filter:undefined,t.Control);var j=sap.ui.require("sap/ui/model/odata/v4/ODataModel");if(j&&(this.getModel()instanceof j)){o.resume();}if(this._bEnbableValueAxisScale){this._validateValueScaleOnDimChange(d,this._aDimensions);}this._aDimensions=d;},vizFrame:function(){var d=this,o=this._getDataset(),v=this._getVizFrame();if(this._mNeedToUpdate['binding']){var i=sap.ui.require("sap/ui/model/odata/v4/ODataModel");var j=this._getDataset().getBinding("data");if(i&&(this.getModel()instanceof i)){j.suspend();}if(this._isEnablePaging()){this._getPagingController().reset();this._oColoringStatus={};}else{this._getDataset().setPagingOption(null);}}else{this._markForUpdate('loopData',true);}if(this.getEnableStableColor()){this._oColorTracker.add(v._runtimeScales());v._runtimeScales(this._oColorTracker.get(),true);}else{this._resetRuntimeScale();}var m=this._isEnablePaging()?this._getPagingController().getMeasureRange():{};o.removeAllAggregation("dimensions",true);o.removeAllAggregation("measures",true);v.removeAllAggregation("feeds",true);if(this.getIsAnalytical()===false){this._handleNonAnalyticalFeeding();}var k={};try{k=this._prepareFeeds();k._def.dim.forEach(function(j1){o.addAggregation("dimensions",j1,true);},this);k._def.msr.forEach(function(j1){if(j1){var k1=m[j1.getIdentity()];if(k1){j1.setRange([k1.min,k1.max]);}if(!d.getDimensionByName(j1.getUnit())){j1.setUnit(null);}o.addAggregation("measures",j1,true);}},this);k.forEach(function(j1){v.addFeed(j1);});}catch(e){}this._semanticTuples=k._semanticTuples;var p=this._getCandidateColoringSetting();var g1=k._context||[];var h1=p.additionalMeasures||[];var i1=p.additionalDimensions||[];h1.forEach(function(j1){g1.push({id:j1,showInTooltip:false});o.addMeasure(new M({name:j1,identity:j1,value:'{'+j1+'}'}));});i1.forEach(function(j1){g1.push({id:j1,showInTooltip:false});o.addDimension(new a({name:j1,identity:j1,value:'{'+j1+'}'}));});o.setContext(g1);v.invalidate();o.invalidate();v.setVizType(this._reset100DonutChartType(this._sAdapteredChartType));v._setCustomMessages(this.getCustomMessages());this._setValueAxisScale();if(!this._mNeedToUpdate['loopData']){this._setEffectiveScales();v.setVizProperties(this._getEffectiveProperties());}},loopData:function(){var v=this._getVizFrame();try{this._prepareData();}catch(e){if(e instanceof z){e.display();}else{throw e;}}var o=this._getEffectiveProperties();this._usingDisplayNameForSemantics(o);v.setVizProperties(o);this._setEffectiveScales();}};})();Y.prototype._getDrillStateTop=function(){return this._drillStateStack?this._drillStateStack[this._drillStateStack.length-1]:null;};Y.prototype._getVizFrame=function(){return this.getAggregation("_vizFrame");};Y.prototype._getDataset=function(){var v=this._getVizFrame();return v?v.getDataset():null;};Y.prototype._prepareData=function(){var d=this._getContexts();if(d){this._bEmptyData=d.length?false:true;var o=this._getCandidateColoringSetting().contextHandler;var i=[];if(o){i.push(o);try{this._loopContext(i);}catch(e){if(e instanceof z){e.display();this._oCandidateColoringSetting={};}else{throw e;}}}this._oSemanticVizSettings=n.getSemanticVizSettings(this._sAdapteredChartType,this._semanticTuples,this._oCandidateColoringSetting,this._enableSemanticPattern(),this._bDataPointStyleSetByUser,this._bLegendSetByUser);}};Y.prototype._getContexts=function(){return this._getDataset()._getDataContexts();};Y.prototype._loopContext=function(d){var e=this._getContexts();if(e.length>0&&!e.dataRequested){var i=this;e.forEach(function(o){d.forEach(function(j){j.call(i,o);});});}};Y.prototype._filterHandler=function(){if(!this._bFilterCalledByChart){this._bFilterCalledByCustomer=true;this._bColoringParsed=false;}this._bFilterCalledByChart=false;};Y.prototype._dataRefreshListener=function(e){if(e.getParameters().reason==='filter'){this._filterHandler();}if(this.getIsAnalytical()&&e.getParameters().updateAnalyticalInfo){h.updateModel(true)(this);}};Y.prototype._bindingChangeListener=function(o){var v=this._getVizFrame();if(o.getParameters().reason==='filter'){this._filterHandler();}if(this.getEnableStableColor()){this._oColorTracker.add(v._runtimeScales());v._runtimeScales(this._oColorTracker.get(),true);}v.invalidate();this.setBusy(false);if(this._isEnablePaging()){this._getPagingController().bindingChanged();}else{v._readyToRender(true);}try{this._prepareData();}catch(e){if(e instanceof z){e.display();}}var d=this._getEffectiveProperties();this._usingDisplayNameForSemantics(d);v.setVizProperties(d);this._setEffectiveScales();this._bFilterCalledByChart=false;this._bFilterCalledByCustomer=false;};Y.prototype._resetRuntimeScale=function(){this._oColorTracker.clear();this._getVizFrame()._runtimeScales(this._oColorTracker.get(),true);};Y.prototype._hasUserSemanticProps=function(){var v=this.getProperty("vizProperties");if(v&&v.plotArea){if(v.plotArea.dataPointStyle||v.plotArea.seriesStyle){return true;}}return false;};Y.prototype._enableSemanticColoring=function(){var d=true;if(this._sAdapteredChartType==="heatmap"){var v=this.getProperty("vizScales")||[];var o=v.filter(function(e){return e.feed==="color";})[0];if(o){d=false;}}else{if(this._hasUserSemanticProps()){d=false;}}return d;};Y.prototype._enableSemanticPattern=function(){return!this._hasUserSemanticProps()&&C.CONFIG.nonSemanticPatternChartType.indexOf(this._sAdapteredChartType)===-1;};Y.prototype._hasSemanticPattern=function(){return this._enableSemanticPattern()&&n.hasSemanticRelation(this._semanticTuples);};Y.prototype._getContinuesSemanticTuples=function(){var d={};if(this._hasSemanticPattern()){d=this._semanticTuples.reduce(function(e,i){if(i.semanticMsrName){e[i.semanticMsrName]=i;}return e;},{});}return d;};Y.prototype._getContinuesSemanticMap=function(){var d=[];if(this._hasSemanticPattern()){d=this._semanticTuples.filter(function(e){return e.projectedValueStartTime;});}return d;};Y.prototype._getInternalVisibleMeasures=function(){var m=this._getVisibleMeasures();if(this._hasSemanticPattern()){m=m.concat(this._getContinuesSemanticMap().map(function(d){return d.semanticMsrName;}));}return m;};Y.prototype._buildSelectedDataPoints=function(o,d){var m=this._getInternalVisibleMeasures(),e=this._getVisibleDimensions().concat(this.getInResultDimensions()),i=this._getEffectiveContinuesDataPoints(d);return S.buildSelectionVizCtx(m,e,o,i);};Y.prototype._getEffectiveContinuesSeries=function(d){var e=d.slice(),i=this._getContinuesSemanticMap();if(this._hasSemanticPattern()){var m=e.map(function(j){return j.measures;});i.forEach(function(j){if(m.indexOf(j.actual)>-1||m.indexOf(j.projected)>-1){e=e.filter(function(k){return k.measures!==j.actual&&k.measures!==j.projected;});if(m.indexOf(j.actual)>-1&&m.indexOf(j.projected)>-1){e.push({measures:j.semanticMsrName});}}});}return e;};Y.prototype._getEffectiveContinuesDataPoints=function(d){var e=d.slice(),k=this._getContinuesSemanticMap();if(this._hasSemanticPattern()){var m,p,o,v;for(var i=0;i<e.length;i++){o=e[i].measures;for(var j=0;j<k.length;j++){v=k[j];m=o.indexOf(v.actual);if(m>-1){o.splice(m,1);}p=o.indexOf(v.projected);if(p>-1){o.splice(p,1);}if(m>-1||p>-1){o.push(v.semanticMsrName);}}}}return e;};Y.prototype._buildSelectEventData=function(d){if(d&&d.length>0&&this._hasSemanticPattern()){var v,e;var k=this._getContinuesSemanticMap();for(var i=0;i<d.length;i++){v=X.extend(true,{},d[i].data);for(var j=0;j<k.length;j++){e=k[j];if(v.measureNames===e.semanticMsrName){if(v[e.timeAxis]<e.projectedValueStartTime){v.measureNames=e.actual;delete v[e.projected];delete v[e.semanticMsrName];}else{v.measureNames=e.projected;delete v[e.actual];delete v[e.semanticMsrName];}}else{if(v[e.actual]&&v.measureNames!==e.actual){delete v[e.actual];}if(v[e.projected]&&v.measureNames!==e.projected){delete v[e.projected];}}}d[i].data=v;}}};Y.prototype.addData=function(){W.error('Chart manages the "data" aggregation only via data binding. The method "addData" therefore cannot be used programmatically!');};Y.prototype.destroyData=function(){W.error('Chart manages the "data" aggregation only via data binding. The method "destroyData" therefore cannot be used programmatically!');};Y.prototype.getData=function(){W.error('Chart manages the "data" aggregation only via data binding. The method "getData" therefore cannot be used programmatically!');};Y.prototype.indexOfData=function(){W.error('Chart manages the "data" aggregation only via data binding. The method "indexOfData" therefore cannot be used programmatically!');};Y.prototype.insertData=function(){W.error('Chart manages the "data" aggregation only via data binding. The method "insertData" therefore cannot be used programmatically!');};Y.prototype.removeData=function(){W.error('Chart manages the "data" aggregation only via data binding. The method "removeData" therefore cannot be used programmatically!');};Y.prototype.removeAllData=function(){W.error('Chart manages the "data" aggregation only via data binding. The method "removeAllData" therefore cannot be used programmatically!');};Y.prototype._createOData4SAPAnalyticsModel=function(m){var o=null;try{o=new u.Model(new u.Model.ReferenceByModel(m));}catch(e){return undefined;}return o;};Y.prototype.getIsAnalytical=function(){return this.getProperty("isAnalytical");};Y.prototype.setIsAnalytical=function(v,d){if(this._bIsInitialized){W.error('The proeprty isAnalytical will programmatically set according to data source. The method "setIsAnalytical" therefore cannot be used!');}else{this.setProperty("isAnalytical",v,d);}return this;};Y.prototype._setIsAnalyticalProperty=function(o,d){var v=o.findQueryResultByName(h.getEntitySet(this.getIsAnalytical())(d))!==undefined;if(this.getIsAnalytical()!==v){this.setProperty("isAnalytical",v);}};Y.prototype.bindAggregation=function(d,o){if(d==="data"){this._oBindingInfo=X.extend(true,{},o);var m=this.getModel(o.model);var e;if(m){var i=sap.ui.require("sap/ui/model/odata/v4/ODataModel");var j=sap.ui.require("sap/ui/model/json/JSONModel");if(j&&m instanceof j){if(this.getIsAnalytical()!==false){this.setProperty("isAnalytical",false);}}else if(i&&m instanceof i){this.setProperty("isAnalytical",true);if(o){o.parameters=X.extend(true,{$count:o.length!=undefined||this._isEnablePaging()},o.parameters);}}else{e=this._createOData4SAPAnalyticsModel(m);this._setIsAnalyticalProperty(e,o);if(this.getIsAnalytical()){if(o){var k=true;if(o.length!=undefined||this._isEnablePaging()){k=false;}o.parameters=X.extend(true,{analyticalInfo:[],useBatchRequests:true,provideGrandTotals:false,reloadSingleUnitMeasures:true,noPaging:k},o.parameters);}O.apply(m);if(e){m.setAnalyticalExtensions(e);}}}}}return B.prototype.bindAggregation.apply(this,arguments);};Y.prototype._bindAggregation=function(d,o){if(d==="data"){var m=this.getModel(o.model);var e;if(m){var i=sap.ui.require("sap/ui/model/odata/v4/ODataModel");var j=sap.ui.require("sap/ui/model/json/JSONModel");if(j&&m instanceof j){if(this.getIsAnalytical()!==false){this.setProperty("isAnalytical",false);}this._deriveColumns(m,o);}else if(i&&m instanceof i){this.setProperty("isAnalytical",true);if(o){o.parameters=X.extend(true,{$count:o.length!=undefined||this._isEnablePaging()},o.parameters);}}else{e=this._createOData4SAPAnalyticsModel(m);this._setIsAnalyticalProperty(e,o);if(this.getIsAnalytical()){if(o){var k=true;if(o.length!=undefined||this._isEnablePaging()){k=false;}o.parameters=X.extend(true,{analyticalInfo:[],useBatchRequests:true,provideGrandTotals:false,reloadSingleUnitMeasures:true,noPaging:k},o.parameters);}O.apply(m);if(e){m.setAnalyticalExtensions(e);}}this._deriveColumns(m,o);}}var p=this._getDataset();p.bindAggregation("data",o);this._invalidateBy({source:this,keys:{binding:true,vizFrame:true}});}else{B.prototype._bindAggregation.apply(this,arguments);}};Y.prototype._dataErrorListener=function(e){var v=this._getVizFrame();if(v){v._readyToRender(true);v.invalidate();this.setBusy(false);}};Y.prototype.unbindAggregation=function(d,e){if(d==="data"){var o=this._getDataset();if(o){o.unbindAggregation.apply(o,arguments);}e=true;}return B.prototype.unbindAggregation.apply(this,[d,e]);};Y.prototype.unbindData=function(){if(!this.getIsAnalytical()){this.removeAllAggregation("dimensions");this.removeAllAggregation("measures");this.setProperty("visibleDimensions",[]);this.setProperty("inResultDimensions",[]);this.setProperty("visibleMeasures",[]);this._createDrillStack();}this.unbindAggregation("data");};Y.prototype._deriveColumns=function(m,o){var d=this.getAggregation("dimensions");var e=this.getAggregation("measures");if((d===null||d.length===0)&&(e===null||e.length===0)){var i=h.deriveColumns(this.getIsAnalytical())(m,o);i.dimensions.forEach(this.addDimension.bind(this));i.measures.forEach(this.addMeasure.bind(this));}};Y.prototype.onBeforeRendering=function(){this._bIsInitialized=true;B.prototype.onBeforeRendering.apply(this,arguments);var o=["onInvalidate","drillStack","dataSet","vizFrame","checkBinding","binding","loopData"];o.forEach(function(k){if(this._mNeedToUpdate[k]){this._updaters[k].call(this);}}.bind(this));X.each(this._mNeedToUpdate,function(k){this._mNeedToUpdate[k]=false;}.bind(this));};Y.prototype.onAfterRendering=function(){this._showLoading(this._bLoading);this._rendered=true;};Y.prototype.onlocalizationChanged=function(){this._invalidateBy({source:this,keys:{vizFrame:true}});};Y.prototype.exit=function(){this._getDataset().unbindAggregation('data',true);this._oColorTracker.clear();B.prototype.exit.apply(this,arguments);var v=this._getVizFrame();if(this._delegateEventHandlers){this._delegateEventHandlers.forEach(function(o){v["detach"+o.name](o.handler,this);delete o.handler;},this);delete this._delegateEventHandlers;}v.detachRenderComplete(this._vizFrameRenderCompleteHandler,this);v.detachEvent("_zoomDetected",e1.bind(this),this);v.detachEvent("_selectionDetails",f1.bind(this),this);};Y.prototype.applySettings=function(){this._mNeedToUpdate={};A.prototype.applySettings.apply(this,arguments);var d=new F();d.attachEvent("dataChange",{},this._bindingChangeListener,this);d.attachEvent("dataRefresh",{},this._dataRefreshListener,this);d.attachEvent("dataError",{},this._dataErrorListener,this);var i=X.extend(true,{},{'applicationSet':'fiori'},this.getUiConfig());this.setUiConfig(i);this._bNeedToApplyDefaultProperties=true;this._oSemanticVizSettings={};var v=new V({width:Z(this.getWidth()),height:Z(this.getHeight()),vizType:this.getChartType(),uiConfig:this.getUiConfig(),vizProperties:X.extend(true,{'title':{'visible':false}},this._getEffectiveProperties())});v.setDataset(d);v.attachRenderComplete(null,this._updateLoadingIndicator.bind(this));v.attachEvent("_zoomDetected",e1.bind(this));v.attachEvent("renderFail",null,function(e){var p=this._getPagingController();if(p._sLoadingTimer){clearTimeout(p._sLoadingTimer);p._sLoadingTimer=null;}this._showLoading(false);},this);this._rendered=false;v._readyToRender(false);this.setAggregation("_vizFrame",v);this._delegateEvents();this._sAdapteredChartType=this.getChartType();this._oCandidateColoringSetting={};this._oColoringStatus={};this._oColorTracker=new I();if(this._isEnablePaging()){this._getPagingController();}};Y.prototype.setCustomMessages=function(o){this.setProperty("customMessages",o);var v=this._getVizFrame();if(v){v._setCustomMessages(o);}return this;};Y.prototype.getZoomInfo=function(){return this._getZoomInfo();};Y.prototype._getZoomInfo=function(){var v=this._getVizFrame();if(v){return v._getZoomInfo();}};Y.prototype.resetLayout=function(){this._createDrillStack();this._invalidateBy({source:this,keys:{binding:true,vizFrame:true,dataSet:true}});return this;};Y.prototype.setSelectedDataPoints=function(d){if(this.getSelectionMode()!==l.SelectionMode.None){var o=this.getBinding("data"),v=this._getVizFrame();if(!o||!v||this.getSelectionBehavior().toUpperCase()!=="DATAPOINT"){return this;}v.vizSelection([],{clearSelection:true});v.vizSelection(this._buildSelectedDataPoints(o,d),{selectionMode:this.getSelectionMode()});}return this;};Y.prototype.addSelectedDataPoints=function(d){if(this.getSelectionMode()!==l.SelectionMode.None){var o=this.getBinding("data"),v=this._getVizFrame();if(!o||!v||this.getSelectionBehavior().toUpperCase()!=="DATAPOINT"){return this;}v.vizSelection(this._buildSelectedDataPoints(o,d),{selectionMode:l.SelectionMode.Multi});}return this;};Y.prototype.getSelectedDataPoints=function(){var v=this._getVizFrame();if(!v||this.getSelectionBehavior().toUpperCase()!=="DATAPOINT"){return{count:0,dataPoints:[]};}var o=this._getContinuesSemanticTuples();var m=this._getVisibleMeasures(),d=this._getDataset(),e=v.vizSelection()||[],j={};for(var i=0,k=e.length;i<k;i++){var p=e[i],g1=p.data._context_row_number;if(!j[g1]){j[g1]={index:g1,measures:[],context:d.findContext({"_context_row_number":g1})};}p.measures=S.filterVisibleMsr(p.data,m);if(!X.isEmptyObject(o)){S.filterSemMsr(o,m,p);}j[g1].measures=j[g1].measures.concat(p.measures);if(p.unit){j[g1].unit=X.extend(true,j[g1].unit,p.unit);}if(p.dataName){j[g1].dataName=X.extend(true,j[g1].dataName,p.dataName);}}return{count:e.length,dataPoints:Object.keys(j).map(function(id){return j[id];})};};Y.prototype.removeSelectedDataPoints=function(d){if(this.getSelectionMode()!==l.SelectionMode.None){var o=this.getBinding("data"),v=this._getVizFrame();if(!v||this.getSelectionBehavior().toUpperCase()!=="DATAPOINT"){return this;}var e=this._buildSelectedDataPoints(o,d);v.vizSelection(e,{deselection:true});}return this;};Y.prototype.setSelectedCategories=function(d){if(this.getSelectionMode()!==l.SelectionMode.None){var v=this._getVizFrame(),e=this.getSelectionBehavior().toUpperCase();if(!v||e!=="CATEGORY"){return this;}v.vizSelection([],{clearSelection:true});v.vizSelection(d.map(S.toVizCSCtx),{selectionMode:this.getSelectionMode()});}return this;};Y.prototype.addSelectedCategories=function(d){if(this.getSelectionMode()!==l.SelectionMode.None){var v=this._getVizFrame(),e=this.getSelectionBehavior().toUpperCase();if(!v||e!=="CATEGORY"){return this;}v.vizSelection(d.map(S.toVizCSCtx),{selectionMode:l.SelectionMode.Multi});}return this;};Y.prototype.removeSelectedCategories=function(d){if(this.getSelectionMode()!==l.SelectionMode.None){var v=this._getVizFrame(),e=this.getSelectionBehavior().toUpperCase();if(!v||e!=="CATEGORY"){return this;}v.vizSelection(d.map(S.toVizCSCtx),{deselection:true});}return this;};Y.prototype.getSelectedCategories=function(){var v=this._getVizFrame(),d=this.getSelectionBehavior().toUpperCase();if(!v||d!=="CATEGORY"){return{count:0,categories:[]};}else{var e=v.vizSelection()||[];return{count:e.length,categories:(e.category||[]).map(S.fromVizCSCtx)};}};Y.prototype.setSelectedSeries=function(d){if(this.getSelectionMode()!==l.SelectionMode.None){var v=this._getVizFrame(),e=this.getSelectionBehavior().toUpperCase();if(!v||e!=="SERIES"){return this;}v.vizSelection([],{clearSelection:true});var i=this._getEffectiveContinuesSeries(d);v.vizSelection(i.map(S.toVizCSCtx),{selectionMode:this.getSelectionMode()});}return this;};Y.prototype.addSelectedSeries=function(d){if(this.getSelectionMode()!==l.SelectionMode.None){var v=this._getVizFrame(),e=this.getSelectionBehavior().toUpperCase();if(!v||e!=="SERIES"){return this;}var i=this._getEffectiveContinuesSeries(d);v.vizSelection(i.map(S.toVizCSCtx),{selectionMode:l.SelectionMode.Multi});}return this;};Y.prototype.removeSelectedSeries=function(d){if(this.getSelectionMode()!==l.SelectionMode.None){var v=this._getVizFrame(),e=this.getSelectionBehavior().toUpperCase();if(!v||e!=="SERIES"){return this;}var i=this._getEffectiveContinuesSeries(d);v.vizSelection(i.map(S.toVizCSCtx),{deselection:true});}return this;};Y.prototype.getSelectedSeries=function(){var v=this._getVizFrame(),d=this.getSelectionBehavior().toUpperCase();if(!v||d!=="SERIES"){return{count:0,series:[]};}else{var e=v.vizSelection()||[],i=(e.series||[]).map(S.fromVizCSCtx),j=[],k=this._getContinuesSemanticTuples();i=i.filter(function(m){var o=true;if(m&&m.measures){var p=k[m.measures];if(p&&p.semanticMsrName===m.measures){j.push({measures:p.actual});j.push({measures:p.projected});o=false;}}return o;});i=i.concat(j);return{count:e.length,series:i};}};function a1(d){var e=d.filter(function(o){return o;});if(e.length===0){return null;}else if(e.length===1){return e[0];}else{return new r(e,true);}}Y.prototype.drillDown=function(d){if(this.getIsAnalytical()===false){W.error('Data source does not support drillDown/drillUp. The method "drillDown" therefore cannot be used!');return;}if(d&&!(d instanceof Array)){d=[d];}var e=this._normalizeDorM(d,true);if(e.length===0){return;}if(!this._checkDrilldownValid(e)){return;}var o=this._getDrillStateTop(),m=this._redundantsFromSelection(),i=this._deriveFilterFromSelection();var j,k,p;if(i){j=a1([i.filters,o.nonHierarchyFilters]);k=i.hierarchyFilters||o.hierarchyFilters;p=a1([j,k])||undefined;}var v=X.extend(true,{},o.hierarchylevel);e.forEach(function(i1){if(i1 instanceof H){if(v[i1.getName()]==null){v[i1.getName()]=i1.getLevel();}else{v[i1.getName()]+=1;}}});var g1=o.dimensions.slice().filter(function(i1){return!m[i1];});g1=g1.concat(e.filter(function(i1){return g1.indexOf(i1.getName())===-1;}).map(function(i1){return i1.getName();}));this._drillStateStack.push({dimensions:g1,measures:o.measures.filter(function(i1){return!m.measureNames[i1];}),filter:p,hierarchylevel:v,nonHierarchyFilters:j,hierarchyFilters:k,redundant:m});if(this._aUnavailableDims.length===0){this.fireDrillStackChanged(this.getDrillStack());}var h1=e.map(function(i1){return i1.getName();});this.fireDrilledDown({dimensions:h1});this._invalidateBy({source:this,keys:{binding:true,vizFrame:true}});};Y.prototype.drillUp=function(i){if(this.getIsAnalytical()===false){W.error('Data source does not support drillDown/drillUp. The method "drillUp" therefore cannot be used!');return;}if(arguments.length===0){i=this._drillStateStack.length-2;}var o=this._drillStateStack[i];if(o&&i!=this._drillStateStack.length-1){var p=this._drillStateStack.pop();this._drillStateStack.splice(i+1);if(this._aUnavailableDims.length===0){this.fireDrillStackChanged(this.getDrillStack());}this.fireDrilledUp({dimensions:p.dimensions.filter(function(d){return o.dimensions.indexOf(d)===-1;})});this._invalidateBy({source:this,keys:{binding:true,vizFrame:true}});}};Y.prototype.getDrillStack=function(){if(this.getIsAnalytical()===false){W.error('Data source does not support drillDown/drillUp. The method "getDrillStack" therefore cannot be used!');return;}return X.map(this._drillStateStack||[],function(o,i){return{dimension:o.dimensions.slice(),measure:o.measures.slice(),filter:o.filter,hierarchylevel:X.extend(true,{},o.hierarchylevel)};});};Y.prototype.setUiConfig=function(o){this.setProperty("uiConfig",o);if(this._getVizFrame()){this._getVizFrame().setUiConfig(o);}return this;};var b1=(function(){var d=["interaction.selectability.mode","interaction.selectability.behavior"];function e(o,p){var j=o,v;v=p.reduce(function(m,g1){if(j.hasOwnProperty(g1)){m.push({parent:j,val:j[g1],key:g1});j=j[g1];}return m;},[]);if(v.length!==p.length){return;}var k=v.pop();delete k.parent[k.key];while(v.length>0){k=v.pop();if(Object.keys(k.val).length>0){return;}else{delete k.parent[k.key];}}}function i(v,j){var o=X.extend(true,{},v);d.forEach(function(p){delete o[p];e(o,p.split("."));});return o;}return{sanitize:i,modify:function(p,k,j){var m=k.split("."),o=p;while(m.length>1&&o.hasOwnProperty(m[0])){o=o[m.shift()];}var v=m[0];if(m.length===1&&o.hasOwnProperty(v)){o[v]=j(o[v]);}}};})();Y.prototype.setVizProperties=function(v){v=b1.sanitize(v);this.setProperty("vizProperties",v);if(v.plotArea&&v.plotArea.dataPointStyle){this._bDataPointStyleSetByUser=true;this._invalidateBy({source:this,keys:{vizFrame:true,loopData:true}});}if(v.legend&&v.legend.title){this._bLegendSetByUser=true;}if(this._getVizFrame()){this._getVizFrame().setVizProperties(this._getEffectiveProperties());}return this;};Y.prototype.getVizProperties=function(){var o=this._getVizFrame();var d=b1.sanitize(o?o.getVizProperties():this.getProperty("vizProperties"));function e(i){var j=sap.viz.api.env.Format.numericFormatter();if(!j||X.type(j.stripUnit)!=="function"){return i;}if(X.type(i)==="string"){return j.stripUnit(i);}else if(X.type(i)==="object"){X.each(i,function(k,v){i[k]=j.stripUnit(v);});return i;}else{return i;}}b1.modify(d,"plotArea.dataLabel.formatString",e);b1.modify(d,"tooltip.formatString",e);return d;};Y.prototype.setVizScales=function(v){this.setProperty("vizScales",v);this._aVizValueScales=v.filter(function(o){return o.feed==="valueAxis"||o.feed==="valueAxis2"||o.feed==="actualValues";});if(this._aVizValueScales&&this._aVizValueScales.length>0){this._bEnbableValueAxisScale=false;}if(this._getVizFrame()){this._getVizFrame().setVizScales(v);}return this;};Y.prototype.getVizScales=function(){var v=this._getVizFrame();return v?v.getVizScales():this.getProperty("vizScales");};Y.prototype.getVizUid=function(){return this._getVizFrame().getVizUid();};Y.prototype.zoom=function(o){this._getVizFrame().zoom(o);};var c1=["selectData","deselectData"];Y.prototype._delegateEvents=function(){if(this._delegateEventHandlers){return;}var v=this._getVizFrame();this._delegateEventHandlers=c1.map(function(e){var d=e.charAt(0).toUpperCase()+e.slice(1);var i=function(o){var p=o.getParameters();this._buildSelectEventData(p.data);delete p.id;this.fireEvent(e,p);};i=i.bind(this);v["attach"+d](null,i);return{name:d,handler:i};},this);this._vizFrameRenderCompleteHandler=d1.bind(this);v.attachRenderComplete(null,this._vizFrameRenderCompleteHandler);v.attachEvent("_selectionDetails",f1.bind(this));};Y.getChartTypes=sap.chart.api.getChartTypes;Y.prototype.getAvailableChartTypes=function(){var d=this._getVisibleDimensions(true),m=this._getVisibleMeasures(true);return C.CONFIG.chartTypes.reduce(function(o,e){var i=R.compatible(e,d,m);if(i.compatible){o.available.push({chart:e});}else{var j={};if(i.error.missing.dim){j.Dimension=i.error.missing.dim;}if(i.error.missing.time){j.DateTimeDimension=i.error.missing.time;}if(i.error.missing.msr){j.Measure=i.error.missing.msr;}o.unavailable.push({chart:e,error:j});}return o;},{available:[],unavailable:[]});};Y.prototype._getDynamicScaleProp=function(){return{general:{enableScalingFactor:this.getEnableScalingFactor()}};};Y.prototype._getEffectiveProperties=function(){var v={};if(this._bNeedToApplyDefaultProperties){v=X.extend(true,v,this._getDefaultVizProperties());this._bNeedToApplyDefaultProperties=false;}var d=this.getChartType();v=X.extend(true,v,this._get100DonutProperty(d),this._oSemanticVizSettings.properties||{},this.getProperty("vizProperties"),this._getHostedVizProperties(),this._getPagingVizProperties(),this._getTimeProperties(),this._getValueAxisScaleSetting().property||{},this._getDynamicScaleProp(),n.getSemanticSettingsForCombination(this._semanticTuples,d));return v;};Y.prototype._get100DonutProperty=function(d){return{'tooltip':{'bodyMeasureValue':{'type':(d.indexOf("100_")===0)?'percentage':'value'}}};};Y.prototype._reset100DonutChartType=function(d){return d.indexOf('donut')>-1?'donut':d;};Y.prototype._setEffectiveScales=function(){var v=this._getVizFrame(),o=this.getProperty('vizScales'),d=this._getValueAxisScaleSetting(),e=(o||[]).filter(function(j){return j.feed==='color';});var i=U.extendScales(o,d.scale||[],this._oSemanticVizSettings.scales||[]);if(this._oSemanticVizSettings.replaceColorScales&&e.length===0){v.setVizScales(i,{replace:true});}else{v.setVizScales(i);}};Y.prototype._usingDisplayNameForSemantics=function(v){var d=function(o){if((typeof(o)==='undefined')||(o===null)){return false;}return true;};if(v.plotArea&&v.plotArea.dataPointStyle&&v.plotArea.dataPointStyle.rules){var e=this._getContexts();if(e.length>0&&!e.hasOwnProperty("dataRequested")){var k=this.getVisibleDimensions(),m=v.plotArea.dataPointStyle.rules;for(var i=0;i<m.length;i++){var p=m[i].dataContext;if(p&&p.length!==0){var g1=Object.keys(p);if(!d(m[i].displayName)&&g1.length===1){var h1=g1[0];if(p[h1].hasOwnProperty("equal")&&k.indexOf(h1)!==-1){var i1=this.getDimensionByName(h1).getTextProperty();for(var j=0;j<e.length;j++){if(e[j].getProperty(h1)===p[h1].equal){var j1=e[j].getProperty(i1);if(!d(i1)||!d(j1)||typeof(j1)==="object"||this.getDimensionByName(h1).getDisplayText()===false){m[i].displayName=p[h1].equal;break;}else{m[i].displayName=j1;break;}}}}}}}}}};Y.prototype._getCandidateColoringSetting=function(){if(!this._bColoringParsed&&this._semanticTuples){if(this._enableSemanticColoring()){this._bColoringParsed=true;this._oCandidateColoringSetting={};var d={},o=this.getColorings(),i=this.getActiveColoring();d.aMsr=this._normalizeDorM(this.getVisibleMeasures());var j=this._getDrillStateTop();var k=[],v;if(j.redundant){var k=Object.keys(j.redundant).filter(function(g1){return g1!=='measureNames';});}v=this._normalizeDorM(this.getVisibleDimensions().concat(k),true);d.aDim=v;d.aInResultDim=this._normalizeDorM(this.getInResultDimensions(),true);d.allMsr=this.getMeasures().map(function(g1){return g1.getName();});d.allDim=this.getDimensions().map(function(g1){return g1.getName();});if(o){try{var m=sap.ui.getCore().getLibraryResourceBundle("sap.chart.messages");var p={bFiltered:this._bFilterCalledByCustomer};this._oCandidateColoringSetting=y.getCandidateSetting(o,i,this._semanticTuples,d,this._oColoringStatus||{},this._sAdapteredChartType||this.getChartType(),m,p);}catch(e){if(e instanceof z){e.display();}else{throw e;}}}}else{this._oCandidateColoringSetting={};}}return this._oCandidateColoringSetting;};Y.prototype._hostedVizProperties={selectionMode:{prop:"interaction.selectability.mode"},selectionBehavior:{prop:"interaction.selectability.behavior"}};Y.prototype._getHostedVizProperties=function(){return Object.keys(this._hostedVizProperties).reduce(function(o,p){var d=this._hostedVizProperties[p].prop.split(".").reverse().reduce(function(o,e){var i={};i[e]=o;return i;},this.getProperty(p));return X.extend(true,o,d);}.bind(this),{});};Y.prototype._getDefaultVizProperties=function(){var d=(this._sAdapteredChartType||this.getChartType());var i=(d.indexOf("100_")===0);var j=(d==="pie"||d.indexOf("donut")>-1);d='info/'+this._reset100DonutChartType(d);var o={interaction:{extraEventInfo:true}};return X.extend(true,o,v({},d,["valueAxis.label.formatString","valueAxis2.label.formatString"],i?'':J.DefaultPattern.SHORTFLOAT),v({},d,["legend.formatString","sizeLegend.formatString"],J.DefaultPattern.SHORTFLOAT_MFD2),v({},d,["plotArea.dataLabel.formatString"],j?'':J.DefaultPattern.SHORTFLOAT_MFD2),v({},d,["tooltip.formatString"],i?'':J.DefaultPattern.STANDARDFLOAT));function k(e,g1,h1){if(g1.length===0){return h1;}e=e||{};var p=e[g1[0]];e[g1[0]]=k(p,g1.slice(1),h1);return e;}function m(p,g1){if(p==null||g1.length===0){return p;}var e=p[g1[0]];if(e&&e.children){return m(e.children,g1.slice(1));}return e;}function v(e,g1,h1,i1){var j1=sap.viz.api.metadata.Viz.get(g1);if(j1){var k1=j1.properties;h1.forEach(function(l1){l1=l1.split(".");var p=m(k1,l1);if(p&&p.hasOwnProperty("defaultValue")){k(e,l1,i1);}});}return e;}};Y.prototype._getPagingVizProperties=function(){if(this._isEnablePaging()){var p={interaction:{zoom:{enablement:false},selectability:{mode:"NONE"}},plotArea:{isFixedDataPointSize:true}};return p;}else{return{};}};Y.prototype._getTimeProperties=function(){var d=["year","month","day"];var o=null;var e=this;var i=this.getVisibleDimensions().filter(function(k1){var l1=e.getDimensionByName(k1);return(l1 instanceof sap.chart.data.TimeDimension&&l1._getFixedRole()==="category");})[0];var j="ISO";var m,k,p;if(i){var v=this.getDimensionByName(i);switch(v.getTimeUnit()){case x.yearmonthday:d=["year","month","day"];break;case x.yearquarter:d=["year","quarter"];break;case x.yearmonth:d=["year","month"];break;case x.yearweek:d=["year","week"];var g1=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale(),h1=L.getInstance(g1),p=g1.getRegion();m=h1.getMinimalDaysInFirstWeek();k=h1.getFirstDayOfWeek();k=k===0?7:k;j="Gregorian";break;case x.fiscalyear:d=["fiscal_year"];break;case x.fiscalyearperiod:d=["fiscal_period","fiscal_year"];break;default:}o=v.getFiscalYearPeriodCount();}var i1=this.getProperty("vizProperties");if(i1&&i1.timeAxis){var j1=i1.timeAxis;if(j1.levels){d=j1.levels;}if(j1.fiscal&&j1.fiscal.periodNumbers){o=j1.fiscal.periodNumbers;}}return{"timeAxis":{"levels":d,"fiscal":{"periodNumbers":o},"levelConfig":{"week":{"type":j,"minDays":m,"firstDayOfWeek":k,"region":p}}}};};Y.prototype.setSelectionMode=function(v){this.setProperty("selectionMode",v);var o=this._getVizFrame();if(o){o.setVizProperties({interaction:{selectability:{mode:v}}});}return this;};Y.prototype.getSelectionMode=function(){var v=this._getVizFrame();if(v){return v.getVizProperties().interaction.selectability.mode;}else{return this.getProperty("selectionMode");}};Y.prototype.setSelectionBehavior=function(v){this.setProperty("selectionBehavior",v);var o=this._getVizFrame();if(o){o.setVizProperties({interaction:{selectability:{behavior:v}}});}return this;};Y.prototype.setEnableScalingFactor=function(v){this.setProperty("enableScalingFactor",v);this._invalidateBy({source:this,keys:{vizFrame:true}});return this;};Y.prototype.getScalingFactor=function(){var v=this._getVizFrame();if(v){var d=v._states()["dynamicScale"];if(d){var e=null;var k=["primaryValues","secondaryValues"];var i=[d.valueAxis,d.valueAxis2];for(var j=0;j<k.length;j++){var m=i[j];if(m&&(m.symbol||m.unit)){e=e||{};var o=k[j];e[o]={scalingFactor:m.symbol};if(m.unit){e[o]["unit"]=m.unit;}}}return e;}}return null;};Y.prototype.getSelectionBehavior=function(){var v=this._getVizFrame();if(v){return v.getVizProperties().interaction.selectability.behavior;}else{return this.getProperty("selectionBehavior");}};Y.prototype.getDimensionByName=function(e){return this.getDimensions().filter(function(d){return d.getName()===e;})[0];};Y.prototype.getMeasureByName=function(d){return this.getMeasures().filter(function(m){return m.getName()===d;})[0];};Y.prototype.getTimeDimensions=function(){return this.getDimensions().filter(function(d){return d instanceof T;});};Y.prototype._isEnablePaging=function(){this._bMobile=(w.system.tablet&&!w.system.desktop)||w.system.phone;var m=this.getModel();var d=sap.ui.require("sap/ui/model/json/JSONModel");var e=!(d&&m instanceof d)&&this.getEnablePagination()&&this._bIsPagingChartType&&!this._bMobile;return e;};function d1(e){var p=e.getParameters();delete p.id;if(this._isEnablePaging()){this._getPagingController().vizFrameRenderCompleted();}this.fireEvent("renderComplete",p);}function e1(e){var p=e.getParameters();delete p.id;this.fireEvent("_zoomDetected",p);}function f1(e){var p=e.getParameters();delete p.id;var d=this._getDataset();p.data.forEach(function(i){i.context=d.findContext({"_context_row_number":i.data._context_row_number});});this.fireEvent("_selectionDetails",p);}Y.prototype._showLoading=function(d){var e=this.$();if(!e){return;}if(!d){if(this._$loadingIndicator){this._$loadingIndicator.remove();}}else{if(!this._$loadingIndicator){this._$loadingIndicator=this._createLoadingIndicator();}this._updateLoadingIndicator();e.append(this._$loadingIndicator);}this._bLoading=d;};Y.prototype._createLoadingIndicator=function(){var d=X(E.getElement());var e=X("<p>").attr("class","loading-text").text("Loading");e.css({"position":"absolute","transform":"translateY(-3em)","width":"100%","text-align":"center"});e.insertBefore(d.children()[0]);d.css({opacity:1});return d;};Y.prototype._updateLoadingIndicator=function(){var d=this.$();if(!d||!this._$loadingIndicator){return;}var e=this._sAdapteredChartType,i=e==="bar"||e.indexOf("horizontal")!==-1;var j=d.find(".v-plot-bound"),o=d.offset(),p={top:o.top,left:o.left,width:d.width(),height:d.height()};if(j.length){var k=j.offset(),m=j[0].getBoundingClientRect();p.top=k.top-1;p.left=k.left;p.width=m.width+1;if(i){p.height=Math.ceil(m.height+1);}else{p.height=Math.floor(m.height+1);}}this._$loadingIndicator.css(p);var v=this._$loadingIndicator.find(".loading-text");v.css({"top":p.height/2,"font-weight":G.get("sapUiChartTitleFontWeight"),"font-size":G.get("sapUiChartMainTitleFontSize"),"color":G.get("sapUiChartMainTitleFontSize")});this._$loadingIndicator.css({"background-color":G.get("sapUiExtraLightBG")});};Y.prototype._getRequiredDimensions=function(){var v=this._getVisibleDimensions(),i=this.getInResultDimensions();return this._normalizeDorM(v.concat(i),true);};Y.prototype._getRequiredMeasures=function(){return this._getVisibleMeasures(true);};Y.prototype.exportToSVGString=function(o){var d="<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"100%\" height=\"100%\"/>",v=this._getVizFrame();if(v){d=v.exportToSVGString(o);}return d;};Y.prototype._getPagingController=function(){if(!this._pagingController){this._pagingController=new P(this);}return this._pagingController;};return Y;});
