/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/ui/util/openWindow","sap/m/Text","sap/m/Link","sap/m/Select","sap/ui/core/Item","sap/ui/core/delegate/ItemNavigation","sap/ui/core/ResizeHandler","sap/ui/core/IconPool","sap/ui/Device","sap/m/library","./BreadcrumbsRenderer"],function(C,o,T,L,S,I,a,R,b,D,l,B){"use strict";var c=l.SelectType,d=l.BreadcrumbsSeparatorStyle;var e=C.extend("sap.m.Breadcrumbs",{metadata:{library:"sap.m",interfaces:["sap.m.IBreadcrumbs"],designtime:"sap/m/designtime/Breadcrumbs.designtime",properties:{currentLocationText:{type:"string",group:"Behavior",defaultValue:null},separatorStyle:{type:"sap.m.BreadcrumbsSeparatorStyle",group:"Appearance",defaultValue:d.Slash}},aggregations:{links:{type:"sap.m.Link",multiple:true,singularName:"link"},_currentLocation:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_select:{type:"sap.m.Select",multiple:false,visibility:"hidden"}},defaultAggregation:"links"}});e.STYLE_MAPPER={Slash:"&#047;",BackSlash:"&#092;",DoubleSlash:"&#047;&#047;",DoubleBackSlash:"&#092;&#092;",GreaterThan:"&gt;",DoubleGreaterThan:"&#187;"};e.prototype.init=function(){this._sSeparatorSymbol=e.STYLE_MAPPER[this.getSeparatorStyle()];};e.prototype.onBeforeRendering=function(){this.bRenderingPhase=true;if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(this._bControlsInfoCached){this._updateSelect(true);}};e.prototype.onAfterRendering=function(){if(!this._sResizeListenerId){this._sResizeListenerId=R.register(this,this._handleScreenResize.bind(this));}if(!this._bControlsInfoCached){this._updateSelect(true);return;}this._configureKeyboardHandling();this.bRenderingPhase=false;};e.prototype.onThemeChanged=function(){this._resetControl();};e.prototype.exit=function(){this._resetControl();this._destroyItemNavigation();};e.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5;e.prototype._getAugmentedId=function(s){return this.getId()+"-"+s;};e.prototype._getSelect=function(){if(!this.getAggregation("_select")){this.setAggregation("_select",this._decorateSelect(new S({id:this._getAugmentedId("select"),change:this._selectChangeHandler.bind(this),forceSelection:false,autoAdjustWidth:true,icon:b.getIconURI("slim-arrow-down"),type:c.IconOnly,tooltip:B._getResourceBundleText("BREADCRUMB_SELECT_TOOLTIP")})),true);}return this.getAggregation("_select");};e.prototype._getCurrentLocation=function(){if(!this.getAggregation("_currentLocation")){this.setAggregation("_currentLocation",new T({id:this._getAugmentedId("currentText"),text:this.getCurrentLocationText(),wrapping:false}).addStyleClass("sapMBreadcrumbsCurrentLocation"));}return this.getAggregation("_currentLocation");};function f(A,g){var h=Array.prototype.slice.apply(g);h.unshift(A);return h;}e.prototype.insertLink=function(g,i){var r=this.insertAggregation.apply(this,f("links",arguments));this._registerControlListener(g);this._resetControl();return r;};e.prototype.addLink=function(g){var r=this.addAggregation.apply(this,f("links",arguments));this._registerControlListener(g);this._resetControl();return r;};e.prototype.removeLink=function(O){var r=this.removeAggregation.apply(this,f("links",arguments));this._deregisterControlListener(r);this._resetControl();return r;};e.prototype.removeAllLinks=function(){var g=this.getAggregation("links",[]);var r=this.removeAllAggregation.apply(this,f("links",arguments));g.forEach(this._deregisterControlListener,this);this._resetControl();return r;};e.prototype.destroyLinks=function(){var g=this.getAggregation("links",[]);var r=this.destroyAggregation.apply(this,f("links",arguments));g.forEach(this._deregisterControlListener,this);this._resetControl();return r;};e.prototype._decorateSelect=function(s){s.getPicker().attachAfterOpen(this._removeItemNavigation,this).attachBeforeClose(this._restoreItemNavigation,this);s._onBeforeOpenDialog=this._onSelectBeforeOpenDialog.bind(this);s._onBeforeOpenPopover=this._onSelectBeforeOpenPopover.bind(this);s.onsapescape=this._onSelectEscPress.bind(this);return s;};e.prototype._removeItemNavigation=function(){this.removeDelegate(this._getItemNavigation());};e.prototype._onSelectBeforeOpenDialog=function(){var s=this._getSelect();if(this.getCurrentLocationText()&&D.system.phone){s.setSelectedIndex(0);}else{s.setSelectedItem(null);}S.prototype._onBeforeOpenDialog.call(s);this._removeItemNavigation();};e.prototype._onSelectBeforeOpenPopover=function(){this._getSelect().setSelectedItem(null);this._removeItemNavigation();};e.prototype._restoreItemNavigation=function(){this.addDelegate(this._getItemNavigation());};e.prototype._onSelectEscPress=function(){this._getSelect().close();};e.prototype._createSelectItem=function(i){return new I({key:i.getId(),text:i.getText()});};e.prototype._selectChangeHandler=function(E){var g,s,h,i=E.getParameter("selectedItem");if(!i){return;}if(!this._getSelect().isOpen()){return;}g=sap.ui.getCore().byId(i.getKey());if(!(g instanceof L)){return;}s=g.getHref();h=g.getTarget();g.firePress();if(s){if(h){o(s,h);}else{window.location.href=s;}}};e.prototype._getItemsForMobile=function(){var i=this.getLinks();if(this.getCurrentLocationText()){i.push(this._getCurrentLocation());}return i;};e.prototype._updateSelect=function(i){var s=this._getSelect(),g,h=this._getControlDistribution();if(!this._bControlDistributionCached||i){s.destroyItems();g=D.system.phone?this._getItemsForMobile():h.aControlsForSelect;g.map(this._createSelectItem).reverse().forEach(s.insertItem,s);this._bControlDistributionCached=true;this.invalidate(this);}s.setVisible(!!h.aControlsForSelect.length);if(!this._sResizeListenerId&&!this.bRenderingPhase){this._sResizeListenerId=R.register(this,this._handleScreenResize.bind(this));}};e.prototype._getControlsForBreadcrumbTrail=function(){var v;if(this._bControlDistributionCached&&this._oDistributedControls){return this._oDistributedControls.aControlsForBreadcrumbTrail;}v=this.getLinks().filter(function(g){return g.getVisible();});if(this.getCurrentLocationText()){return v.concat([this._getCurrentLocation()]);}return v;};e.prototype._getControlInfo=function(g){return{id:g.getId(),control:g,width:g.$().parent().outerWidth(true),bCanOverflow:g instanceof L};};e.prototype._getControlDistribution=function(m){m=m||this._iContainerSize;this._iContainerSize=m;this._oDistributedControls=this._determineControlDistribution(m);return this._oDistributedControls;};e.prototype._getSelectWidth=function(){return this._getSelect().getVisible()&&this._iSelectWidth||0;};e.prototype._determineControlDistribution=function(m){var i,g,h=this._getControlsInfo().aControlInfo,s=this._getSelectWidth(),j=[],k=[],u=s;for(i=h.length-1;i>=0;i--){g=h[i];u+=g.width;if(h.length-1===i){k.push(g.control);continue;}if(i===0){u-=s;}if(u>m&&g.bCanOverflow){j.unshift(g.control);}else{k.unshift(g.control);}}return{aControlsForBreadcrumbTrail:k,aControlsForSelect:j};};e.prototype._getControlsInfo=function(){if(!this._bControlsInfoCached){this._iSelectWidth=this._getSelect().$().parent().outerWidth(true)||0;this._aControlInfo=this._getControlsForBreadcrumbTrail().map(this._getControlInfo);this._iContainerSize=this.$().outerWidth(true);this._bControlsInfoCached=true;}return{aControlInfo:this._aControlInfo,iSelectWidth:this._iSelectWidth,iContentSize:this._iContainerSize};};e.prototype._handleScreenResize=function(E){var i=this._oDistributedControls.aControlsForBreadcrumbTrail.length,g=this._getControlDistribution(E.size.width),h=g.aControlsForBreadcrumbTrail.length;if(i!==h){this._updateSelect(true);}return this;};e.prototype._getItemsToNavigate=function(){var i=this._getControlsForBreadcrumbTrail().slice(),s=this._getSelect();if(s.getVisible()){i.unshift(s);}return i;};e.prototype._getItemNavigation=function(){if(!this._itemNavigation){this._itemNavigation=new a();}return this._itemNavigation;};e.prototype._destroyItemNavigation=function(){if(this._itemNavigation){this.removeEventDelegate(this._itemNavigation);this._itemNavigation.destroy();this._itemNavigation=null;}};e.prototype._configureKeyboardHandling=function(){var i=this._getItemNavigation(),s=-1,g=this._getItemsToNavigate(),n=[];if(g.length===0){return;}g.forEach(function(h,j){if(j===0){h.$().attr("tabindex","0");}h.$().attr("tabindex","-1");n.push(h.getDomRef());});this.addDelegate(i);i.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});i.setCycling(false);i.setPageSize(e.PAGEUP_AND_PAGEDOWN_JUMP_SIZE);i.setRootDomRef(this.getDomRef());i.setItemDomRefs(n);i.setSelectedIndex(s);return this;};e.prototype._registerControlListener=function(g){if(g){g.attachEvent("_change",this._resetControl,this);}};e.prototype._deregisterControlListener=function(g){if(g){g.detachEvent("_change",this._resetControl,this);}};e.prototype.setCurrentLocationText=function(t){var g=this._getCurrentLocation(),r=this.setProperty("currentLocationText",t,true);if(g.getText()!==t){g.setText(t);this._resetControl();}return r;};e.prototype.setSeparatorStyle=function(s){var g=e.STYLE_MAPPER[s];if(!g){return this;}this._sSeparatorSymbol=g;return this.setProperty("separatorStyle",s);};e.prototype._resetControl=function(){this._aControlInfo=null;this._iContainerSize=null;this._bControlsInfoCached=null;this._bControlDistributionCached=null;this._oDistributedControls=null;if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}this.removeDelegate(this._getItemNavigation());this.invalidate(this);return this;};return e;});
