/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/thirdparty/jquery','sap/ui/Device',"sap/ui/core/Element",'./InputBase','./DateTimeField','./Button','./ResponsivePopover','sap/ui/core/date/UniversalDate','./library','sap/ui/core/Control','sap/ui/core/library',"./DatePickerRenderer","sap/base/util/deepEqual","sap/base/assert","sap/base/Log","sap/ui/core/IconPool","./InstanceManager","sap/ui/unified/Calendar","sap/ui/unified/DateRange","sap/ui/unified/calendar/CustomMonthPicker","sap/ui/unified/calendar/CustomYearPicker","sap/ui/core/LabelEnablement","sap/ui/dom/jquery/cursorPos"],function(q,D,E,I,a,B,R,U,l,C,c,b,d,e,L,f,g,h,i,j,k,m){"use strict";var n=c.CalendarType;var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");var o=a.extend("sap.m.DatePicker",{metadata:{library:"sap.m",properties:{displayFormatType:{type:"string",group:"Appearance",defaultValue:""},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},showFooter:{type:"boolean",group:"Misc",defaultValue:false}},aggregations:{specialDates:{type:"sap.ui.core.Element",multiple:true,singularName:"specialDate"},_popup:{type:"sap.m.ResponsivePopover",multiple:false,visibility:"hidden"}},associations:{legend:{type:"sap.ui.core.Control",multiple:false}},events:{navigate:{parameters:{dateRange:{type:"sap.ui.unified.DateRange"},afterPopupOpened:{type:"boolean"}}}},designtime:"sap/m/designtime/DatePicker.designtime",dnd:{draggable:false,droppable:true}}});o.prototype.init=function(){a.prototype.init.apply(this,arguments);this._bIntervalSelection=false;this._bOnlyCalendar=true;this._bValid=true;this._oMinDate=new Date(1,0,1);this._oMinDate.setFullYear(1);this._oMaxDate=new Date(9999,11,31,23,59,59,999);var y=this.addEndIcon({id:this.getId()+"-icon",src:this.getIconSrc(),noTabStop:true,tooltip:r.getText("OPEN_PICKER_TEXT")});this._bShouldClosePicker=false;y.addEventDelegate({onmousedown:function(z){this._bShouldClosePicker=!!this.isOpen();}},this);y.attachPress(function(){this.toggleOpen(this._bShouldClosePicker);},this);};o.prototype.isValidValue=function(){return this._bValid;};o.prototype.isOpen=function(){return this._oPopup&&this._oPopup.isOpen();};o.prototype.toggleOpen=function(O){if(this.getEditable()&&this.getEnabled()){if(O){p.call(this);}else{_.call(this);}}};o.prototype.getIconSrc=function(){return f.getIconURI("appointment-2");};o.prototype.exit=function(){I.prototype.exit.apply(this,arguments);if(this._oPopup){if(this._oPopup.isOpen()){this._oPopup.close();}delete this._oPopup;}if(this._oCalendar){this._oCalendar.destroy();delete this._oCalendar;}if(this._iInvalidateCalendar){clearTimeout(this._iInvalidateCalendar);}this._sUsedDisplayPattern=undefined;this._sUsedDisplayCalendarType=undefined;this._oDisplayFormat=undefined;this._sUsedValuePattern=undefined;this._sUsedValueCalendarType=undefined;this._oValueFormat=undefined;};o.prototype.invalidate=function(O){if(!O||O!=this._oCalendar){C.prototype.invalidate.apply(this,arguments);this._iInvalidateCalendar=setTimeout(x.bind(this),0);}};o.prototype.onBeforeRendering=function(){a.prototype.onBeforeRendering.apply(this,arguments);this._checkMinMaxDate();var V=this._getValueHelpIcon();if(V){V.setProperty("visible",this.getEditable(),true);}};o.prototype.setWidth=function(W){return I.prototype.setWidth.call(this,W||"100%");};o.prototype.getWidth=function(W){return this.getProperty("width")||"100%";};o.prototype.applyFocusInfo=function(F){this._bFocusNoPopup=true;if(!D.support.touch||D.system.desktop){I.prototype.applyFocusInfo.apply(this,arguments);}};o.prototype.onfocusin=function(y){if(!q(y.target).hasClass("sapUiIcon")){I.prototype.onfocusin.apply(this,arguments);}this._bFocusNoPopup=undefined;};o.prototype.onsapshow=function(y){this.toggleOpen(this.isOpen());y.preventDefault();};o.prototype.onsaphide=o.prototype.onsapshow;o.prototype.onsappageup=function(y){s.call(this,1,"day");y.preventDefault();};o.prototype.onsappageupmodifiers=function(y){if(!y.ctrlKey&&y.shiftKey){s.call(this,1,"month");}else{s.call(this,1,"year");}y.preventDefault();};o.prototype.onsappagedown=function(y){s.call(this,-1,"day");y.preventDefault();};o.prototype.onsappagedownmodifiers=function(y){if(!y.ctrlKey&&y.shiftKey){s.call(this,-1,"month");}else{s.call(this,-1,"year");}y.preventDefault();};o.prototype.onkeypress=function(y){if(!y.charCode||y.metaKey||y.ctrlKey){return;}var F=this._getFormatter(true);var z=String.fromCharCode(y.charCode);if(z&&F.sAllowedCharacters&&F.sAllowedCharacters.indexOf(z)<0){y.preventDefault();}};o.prototype._getValueHelpIcon=function(){var V=this.getAggregation("_endIcon");return V&&V[0];};o.prototype._dateValidation=function(y){this._bValid=true;if(y&&(y.getTime()<this._oMinDate.getTime()||y.getTime()>this._oMaxDate.getTime())){this._bValid=false;e(this._bValid,"Date must be in valid range");}this.setProperty("dateValue",y);return y;};o.prototype.setMinDate=function(y){if(this._isValidDate(y)){throw new Error("Date must be a JavaScript date object; "+this);}if(d(this.getMinDate(),y)){return this;}if(y){var Y=y.getFullYear();if(Y<1||Y>9999){throw new Error("Date must be between 0001-01-01 and 9999-12-31; "+this);}this._oMinDate=new Date(y.getTime());var z=this.getDateValue();if(z&&z.getTime()<y.getTime()){this._bValid=false;L.warning("DateValue not in valid date range",this);}}else{this._oMinDate=new Date(1,0,1);this._oMinDate.setFullYear(1);}this.setProperty("minDate",y);if(this._oCalendar){this._oCalendar.setMinDate(y);}this._oMinDate.setHours(0,0,0,0);return this;};o.prototype.setMaxDate=function(y){if(this._isValidDate(y)){throw new Error("Date must be a JavaScript date object; "+this);}if(d(this.getMaxDate(),y)){return this;}if(y){var Y=y.getFullYear();if(Y<1||Y>9999){throw new Error("Date must be between 0001-01-01 and 9999-12-31; "+this);}this._oMaxDate=new Date(y.getTime());var z=this.getDateValue();if(z&&z.getTime()>y.getTime()){this._bValid=false;L.warning("DateValue not in valid date",this);}}else{this._oMaxDate=new Date(9999,11,31,23,59,59,999);}this.setProperty("maxDate",y);if(this._oCalendar){this._oCalendar.setMaxDate(y);}this._oMaxDate.setHours(23,59,59,999);return this;};o.prototype._checkMinMaxDate=function(){if(this._oMinDate.getTime()>this._oMaxDate.getTime()){L.warning("minDate > MaxDate -> dates switched",this);var M=new Date(this._oMinDate.getTime());var y=new Date(this._oMaxDate.getTime());this._oMinDate=new Date(y.getTime());this._oMaxDate=new Date(M.getTime());this.setProperty("minDate",y,true);this.setProperty("maxDate",M,true);if(this._oCalendar){this._oCalendar.setMinDate(y);this._oCalendar.setMaxDate(M);}}var z=this.getDateValue();if(z&&(z.getTime()<this._oMinDate.getTime()||z.getTime()>this._oMaxDate.getTime())){this._bValid=false;L.error("dateValue "+z.toString()+"(value="+this.getValue()+") does not match "+"min/max date range("+this._oMinDate.toString()+" - "+this._oMaxDate.toString()+"). App. "+"developers should take care to maintain dateValue/value accordingly.",this);}};o.prototype.getDisplayFormatType=function(){return this.getProperty("displayFormatType");};o.prototype._handleDateValidation=function(y){this._bValid=true;if(!y||y.getTime()<this._oMinDate.getTime()||y.getTime()>this._oMaxDate.getTime()){this._bValid=false;L.warning("Value can not be converted to a valid date",this);}this.setProperty("dateValue",y);};o.prototype.setDisplayFormatType=function(y){if(y){var F=false;for(var T in n){if(T==y){F=true;break;}}if(!F){throw new Error(y+" is not a valid calendar type"+this);}}this.setProperty("displayFormatType",y,true);this.setDisplayFormat(this.getDisplayFormat());return this;};o.prototype.setSecondaryCalendarType=function(y){this._bSecondaryCalendarTypeSet=true;this.setProperty("secondaryCalendarType",y,true);if(this._oCalendar){this._oCalendar.setSecondaryCalendarType(y);}return this;};o.prototype.setShowFooter=function(F){var P=this._oPopup,y=this._oCalendar;this.setProperty("showFooter",F);if(!P||!y){return this;}P._getButtonFooter().setVisible(F);return this;};o.prototype.addSpecialDate=function(S){w.call(this,S);this.addAggregation("specialDates",S,true);x.call(this);return this;};o.prototype.insertSpecialDate=function(S,y){w.call(this,S);this.insertAggregation("specialDates",S,y,true);x.call(this);return this;};o.prototype.removeSpecialDate=function(S){var y=this.removeAggregation("specialDates",S,true);x.call(this);return y;};o.prototype.removeAllSpecialDates=function(){var y=this.removeAllAggregation("specialDates",true);x.call(this);return y;};o.prototype.destroySpecialDates=function(){this.destroyAggregation("specialDates",true);x.call(this);return this;};o.prototype.setLegend=function(y){this.setAssociation("legend",y,true);var z=this.getLegend();if(z){var A=sap.ui.require("sap/ui/unified/CalendarLegend");y=sap.ui.getCore().byId(z);if(y&&!(typeof A=="function"&&y instanceof A)){throw new Error(y+" is not an sap.ui.unified.CalendarLegend. "+this);}}if(this._oCalendar){this._oCalendar.setLegend(z);}return this;};o.prototype.onChange=function(y){if(!this.getEditable()||!this.getEnabled()){return;}var V=this._$input.val(),O=this._formatValue(this.getDateValue()),z;if(V==O&&this._bValid){return;}if(this.getShowFooter()&&this._oPopup&&!V){this._oPopup.getBeginButton().setEnabled(false);}this._bValid=true;if(V!=""){z=this._parseValue(V,true);if(!z||z.getTime()<this._oMinDate.getTime()||z.getTime()>this._oMaxDate.getTime()){this._bValid=false;z=undefined;}else{V=this._formatValue(z);}}if(this.getDomRef()&&(this._$input.val()!==V)){this._$input.val(V);this._curpos=this._$input.cursorPos();}if(z){V=this._formatValue(z,true);}if(this._lastValue!==V||(z&&this.getDateValue()&&z.getFullYear()!==this.getDateValue().getFullYear())){this._lastValue=V;this.setProperty("value",V,true);var N=this.getValue();if(this._bValid&&V==N){this.setProperty("dateValue",z,true);}V=N;if(this.isOpen()){if(this._bValid){z=this.getDateValue();}this._oCalendar.focusDate(z);var S=this._oDateRange.getStartDate();if((!S&&z)||(S&&z&&S.getTime()!=z.getTime())){this._oDateRange.setStartDate(new Date(z.getTime()));}else if(S&&!z){this._oDateRange.setStartDate(undefined);}}this.fireChangeEvent(V,{valid:this._bValid});}};o.prototype._getInputValue=function(V){V=(typeof V=="undefined")?this._$input.val():V.toString();var y=this._parseValue(V,true);V=this._formatValue(y,true);return V;};o.prototype.updateDomValue=function(V){if(this.isActive()&&(this._$input.val()!==V)){this._bCheckDomValue=true;V=(typeof V=="undefined")?this._$input.val():V.toString();this._curpos=this._$input.cursorPos();var y=this._parseValue(V,true);V=this._formatValue(y);this._$input.val(V);if(document.activeElement===this._$input[0]){this._$input.cursorPos(this._curpos);}}return this;};o.prototype._storeInputSelection=function(y){if((D.browser.msie||D.browser.edge)&&!D.support.touch){this._oInputSelBeforePopupOpen={iStart:y.selectionStart,iEnd:y.selectionEnd};y.selectionStart=0;y.selectionEnd=0;}};o.prototype._restoreInputSelection=function(y){if((D.browser.msie||D.browser.edge)&&!D.support.touch){y.selectionStart=this._oInputSelBeforePopupOpen.iStart;y.selectionEnd=this._oInputSelBeforePopupOpen.iEnd;}};function _(){this._createPopup();this._createPopupContent();var y;var z=this.getBinding("value");if(z&&z.oType&&z.oType.oOutputFormat){y=z.oType.oOutputFormat.oFormatOptions.calendarType;}else if(z&&z.oType&&z.oType.oFormat){y=z.oType.oFormat.oFormatOptions.calendarType;}if(!y){y=this.getDisplayFormatType();}if(y){this._oCalendar.setPrimaryCalendarType(y);}var V=this._bValid?this._formatValue(this.getDateValue()):this.getValue();if(V!=this._$input.val()){this.onChange();}this._fillDateRange();this._openPopup();this.fireNavigate({dateRange:this._getVisibleDatesRange(this._oCalendar),afterPopupOpened:true});}o.prototype._createPopup=function(){var T="";if(!this._oPopup){this._oPopup=new R(this.getId()+"-RP",{showCloseButton:false,showArrow:false,showHeader:false,placement:l.PlacementType.VerticalPreferedBottom}).addStyleClass("sapMRPCalendar");this._oPopup._getPopup().setAutoClose(true);this._oPopup.attachAfterOpen(t,this);this._oPopup.attachAfterClose(u,this);this._oPopup.setBeginButton(new B({text:r.getText("DATEPICKER_SELECTION_CONFIRM"),press:q.proxy(this._handleOKButton,this)}));if(D.system.phone){T=m.getReferencingLabels(this).concat(this.getAriaLabelledBy()).reduce(function(A,y){var z=E.registry.get(y);return A+" "+(z.getText?z.getText():"");},"").trim();this._oPopup.setTitle(T);this._oPopup.setShowHeader(true);this._oPopup.setShowCloseButton(true);}else{this._oPopup._getPopup().setDurations(0,0);this._oPopup.getBeginButton().setType(l.ButtonType.Emphasized);this._oPopup.setEndButton(new B({text:r.getText("DATEPICKER_SELECTION_CANCEL"),press:q.proxy(this._handleCancelButton,this)}));}this.setAggregation("_popup",this._oPopup,true);}};o.prototype._openPopup=function(){if(!this._oPopup){return;}this._storeInputSelection(this._$input.get(0));this._oPopup._getPopup().setAutoCloseAreas([this.getDomRef()]);this._oPopup.openBy(this);};o.prototype._getVisibleDatesRange=function(y){var V=y._getVisibleDays();return new i({startDate:V[0].toLocalJSDate(),endDate:V[V.length-1].toLocalJSDate()});};o.prototype._createPopupContent=function(){var P=this._getFormatter(true).aFormatArray.map(function(A){return A.type.toLowerCase();}),y=P.indexOf("day")>=0?true:false,M=P.indexOf("month")>=0?true:false,Y=P.indexOf("year")>=0?true:false,z;if(!this._oCalendar){if(y&&M&&Y){z=h;}else if(M&&Y){z=j;}else if(Y){z=k;}else{z=h;L.warning("Not valid date pattern! Openning default Calendar",this);}this._oCalendar=new z(this.getId()+"-cal",{intervalSelection:this._bIntervalSelection,minDate:this.getMinDate(),maxDate:this.getMaxDate(),legend:this.getLegend(),startDateChange:function(){this.fireNavigate({dateRange:this._getVisibleDatesRange(this._oCalendar)});}.bind(this)});this._oDateRange=new i();this._oCalendar.addSelectedDate(this._oDateRange);this._oCalendar._setSpecialDatesControlOrigin(this);if(this.$().closest(".sapUiSizeCompact").length>0){this._oCalendar.addStyleClass("sapUiSizeCompact");}if(this._bSecondaryCalendarTypeSet){this._oCalendar.setSecondaryCalendarType(this.getSecondaryCalendarType());}if(this._bOnlyCalendar){this._oCalendar.attachSelect(this._handleCalendarSelect,this);this._oCalendar.attachCancel(p,this);this._oCalendar.attachEvent("_renderMonth",v,this);this._oCalendar.setPopupMode(true);this._oCalendar._markPopover();this._oPopup._getButtonFooter().setVisible(this.getShowFooter());this._getCalendar()._bSkipCancelButtonRendering=true;this._oPopup.addContent(this._getCalendar());if(!this.getDateValue()){this._oPopup.getBeginButton().setEnabled(false);}}}};o.prototype._fillDateRange=function(){var y=this.getDateValue();if(y&&y.getTime()>=this._oMinDate.getTime()&&y.getTime()<=this._oMaxDate.getTime()){this._oCalendar.focusDate(new Date(y.getTime()));if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!=y.getTime()){this._oDateRange.setStartDate(new Date(y.getTime()));}}else{var z=this.getInitialFocusedDateValue();var F=z?z:new Date();var M=this._oMaxDate.getTime();if(F.getTime()<this._oMinDate.getTime()||F.getTime()>M){F=this._oMinDate;}this._oCalendar.focusDate(F);if(this._oDateRange.getStartDate()){this._oDateRange.setStartDate(undefined);}}};o.prototype.getAccessibilityInfo=function(){var y=this.getRenderer();var z=I.prototype.getAccessibilityInfo.apply(this,arguments);var V=this.getValue()||"";if(this._bValid){var A=this.getDateValue();if(A){V=this._formatValue(A);}}z.type=r.getText("ACC_CTR_TYPE_DATEINPUT");z.description=[V,y.getLabelledByAnnouncement(this),y.getDescribedByAnnouncement(this)].join(" ").trim();return z;};o.prototype._selectDate=function(){var y=this.getDateValue(),z=this._getSelectedDate(),V="";if(!d(z,y)){this.setDateValue(new Date(z.getTime()));V=this.getValue();this.fireChangeEvent(V,{valid:true});this._focusInput();}else if(!this._bValid){V=this._formatValue(z);if(V!=this._$input.val()){this._bValid=true;if(this.getDomRef()){this._$input.val(V);this._lastValue=V;}V=this._formatValue(z,true);this.setProperty("value",V,true);this.fireChangeEvent(V,{valid:true});this._focusInput();}}else if(D.system.desktop||!D.support.touch){this.focus();}this._oPopup.close();};o.prototype._handleCalendarSelect=function(){if(this.getShowFooter()){this._oPopup.getBeginButton().setEnabled(true);return;}this._selectDate();};o.prototype._focusInput=function(){if(this.getDomRef()&&(D.system.desktop||!D.support.touch)){this._curpos=this._$input.val().length;this._$input.cursorPos(this._curpos);}return this;};o.prototype._getCalendar=function(){return this._oCalendar;};o.prototype._getSelectedDate=function(){var S=this._oCalendar.getSelectedDates();var y;if(S.length>0){y=S[0].getStartDate();}return y;};o.prototype._handleOKButton=function(){this._selectDate();};o.prototype._handleCancelButton=function(){if(!this.getDateValue()){this._oPopup.getBeginButton().setEnabled(false);}this._oPopup.close();};function p(y){if(this.isOpen()){this._oPopup.close();if((D.system.desktop||!D.support.touch)){this.focus();}}}function s(N,y){var O=this.getDateValue();var z=this._$input.cursorPos();if(O&&this.getEditable()&&this.getEnabled()){var A;var F=this.getBinding("value");if(F&&F.oType&&F.oType.oOutputFormat){A=F.oType.oOutputFormat.oFormatOptions.calendarType;}else if(F&&F.oType&&F.oType.oFormat){A=F.oType.oFormat.oFormatOptions.calendarType;}if(!A){A=this.getDisplayFormatType();}var G=U.getInstance(new Date(O.getTime()),A);O=U.getInstance(new Date(O.getTime()),A);switch(y){case"day":G.setDate(G.getDate()+N);break;case"month":G.setMonth(G.getMonth()+N);var M=(O.getMonth()+N)%12;if(M<0){M=12+M;}while(G.getMonth()!=M){G.setDate(G.getDate()-1);}break;case"year":G.setFullYear(G.getFullYear()+N);while(G.getMonth()!=O.getMonth()){G.setDate(G.getDate()-1);}break;default:break;}if(G.getTime()<this._oMinDate.getTime()){G=new U(this._oMinDate.getTime());}else if(G.getTime()>this._oMaxDate.getTime()){G=new U(this._oMaxDate.getTime());}if(!d(this.getDateValue(),G.getJSDate())){this.setDateValue(new Date(G.getTime()));this._curpos=z;this._$input.cursorPos(this._curpos);var V=this.getValue();this.fireChangeEvent(V,{valid:true});}}}function t(y){this.addStyleClass(I.ICON_PRESSED_CSS_CLASS);this._renderedDays=this._oCalendar.$("-Month0-days").find(".sapUiCalItem").length;this.$("inner").attr("aria-owns",this.getId()+"-cal");this.$("inner").attr("aria-expanded",true);g.addPopoverInstance(this._oPopup);this._getCalendar().focus();}function u(y){this.removeStyleClass(I.ICON_PRESSED_CSS_CLASS);this.$("inner").attr("aria-expanded",false);this._restoreInputSelection(this._$input.get(0));this._oCalendar._closedPickers();g.removePopoverInstance(this._oPopup);}function v(y){var z=y.getParameter("days"),P=this._oPopup._getPopup();if(z>this._renderedDays){this._renderedDays=z;P._applyPosition(P._oLastPosition);}}function w(S){var y=sap.ui.require("sap/ui/unified/DateTypeRange");if(S&&!(y&&S instanceof y)){throw new Error(S+"is not valid for aggregation \"specialDates\" of "+this);}}function x(){if(this.isOpen()){this._oCalendar._bDateRangeChanged=false;this._oCalendar.invalidate();}}return o;});
