/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','sap/ui/core/Control','sap/ui/core/ValueStateSupport','sap/ui/core/IndicationColorSupport','sap/ui/core/library','sap/ui/base/DataType','sap/ui/core/InvisibleText','./ObjectStatusRenderer'],function(l,C,V,I,c,D,a,O){"use strict";var b=l.ImageHelper;var T=c.TextDirection;var d=c.ValueState;var e=C.extend("sap.m.ObjectStatus",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",designtime:"sap/m/designtime/ObjectStatus.designtime",properties:{title:{type:"string",group:"Misc",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:null},active:{type:"boolean",group:"Misc",defaultValue:false},state:{type:"string",group:"Misc",defaultValue:d.None},inverted:{type:"boolean",group:"Misc",defaultValue:false},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconDensityAware:{type:"boolean",group:"Appearance",defaultValue:true},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"}},events:{press:{}},dnd:{draggable:true,droppable:false}}});e.prototype._createInvisibleTextReferece=function(s){var S;if(s!==d.None){S=V.getAdditionalText(s)?V.getAdditionalText(s):I.getAdditionalText(s);if(this._oInvisibleText){this._oInvisibleText.setText(S);}else{this._oInvisibleText=new a({text:S}).toStatic();}}};e.prototype.exit=function(){if(this._oImageControl){this._oImageControl.destroy();this._oImageControl=null;}if(this._oInvisibleText){this._oInvisibleText.destroy();this._oInvisibleText=null;}};e.prototype._getImageControl=function(){var i=this.getId()+'-icon',f=!this.getText()&&!this.getTitle(),p={src:this.getIcon(),densityAware:this.getIconDensityAware(),useIconTooltip:false};if(f){p.decorative=false;p.alt=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("OBJECT_STATUS_ICON");}this._oImageControl=b.getImageControl(i,this._oImageControl,this,p);return this._oImageControl;};e.prototype.setState=function(v){if(v==null){v=d.None;}else if(!D.getType("sap.ui.core.ValueState").isValid(v)&&!D.getType("sap.ui.core.IndicationColor").isValid(v)){throw new Error('"'+v+'" is not a value of the enums sap.ui.core.ValueState or sap.ui.core.IndicationColor for property "state" of '+this);}this._createInvisibleTextReferece(v);return this.setProperty("state",v);};e.prototype.ontap=function(E){if(this._isClickable(E)){this.firePress();}};e.prototype.onsapenter=function(E){if(this._isActive()){this.firePress();E.setMarked();}};e.prototype.onsapspace=function(E){this.onsapenter(E);};e.prototype._isActive=function(){return this.getActive()&&(this.getText().trim()||this.getIcon().trim());};e.prototype._isEmpty=function(){return!(this.getText().trim()||this.getIcon().trim()||this.getTitle().trim());};e.prototype.ontouchstart=function(E){if(this._isClickable(E)){E.setMarked();}};e.prototype.getAccessibilityInfo=function(){var s=V.getAdditionalText(this.getState());if(this.getState()!=d.None){s=(s!==null)?s:I.getAdditionalText(this.getState());}return{description:((this.getTitle()||"")+" "+(this.getText()||"")+" "+(s!==null?s:"")+" "+(this.getTooltip()||"")).trim()};};e.prototype._isClickable=function(E){var s=E.target.id;return this._isActive()&&(s===this.getId()+"-link"||s===this.getId()+"-text"||s===this.getId()+"-statusIcon"||s===this.getId()+"-icon");};return e;});
