/*
 * ! OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','./P13nPanel','./P13nDimMeasureItem','./SearchField','./Table','./Column','./ColumnListItem','./ScrollContainer','./Text','./Select','./ComboBox','./Button','./OverflowToolbar','./OverflowToolbarLayoutData','./OverflowToolbarButton','./ToolbarSpacer','sap/ui/core/library','sap/ui/model/ChangeReason','sap/ui/model/json/JSONModel','sap/ui/model/BindingMode','sap/ui/core/ResizeHandler','sap/ui/core/Item','sap/ui/core/InvisibleText','sap/ui/core/IconPool',"sap/ui/thirdparty/jquery"],function(l,P,c,S,T,C,d,e,f,g,h,B,O,i,j,k,m,n,J,o,R,I,p,q,Q){"use strict";var r=l.OverflowToolbarPriority;var s=l.ButtonType;var t=l.ToolbarDesign;var L=l.ListType;var u=l.ListMode;var v=l.P13nPanelType;var w=P.extend("sap.m.P13nDimMeasurePanel",{metadata:{library:"sap.m",properties:{chartTypeKey:{type:"string",defaultValue:""}},aggregations:{dimMeasureItems:{type:"sap.m.P13nDimMeasureItem",multiple:true,singularName:"dimMeasureItem",bindable:"bindable"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"},availableChartTypes:{type:"sap.ui.core.Item",multiple:true,singularName:"availableChartType"}},events:{changeDimMeasureItems:{},changeChartType:{}}},renderer:function(a,b){a.write("<div");a.writeControlData(b);a.addClass("sapMP13nColumnsPanel");a.writeClasses();a.write(">");var x=b.getAggregation("content");if(x){x.forEach(function(y){a.renderControl(y);});}a.write("</div>");}});w.prototype.init=function(){var a=this;this._iLiveChangeTimer=0;this._iSearchTimer=0;this._bIgnoreUpdateInternalModel=false;this._bUpdateInternalModel=true;this._bOnAfterRenderingFirstTimeExecuted=false;var b=sap.ui.getCore().getLibraryResourceBundle("sap.m");this.oAvailableRoleTypes={Dimension:[{key:"category",text:b.getText('COLUMNSPANEL_CHARTROLE_CATEGORY')},{key:"category2",text:b.getText('COLUMNSPANEL_CHARTROLE_CATEGORY2')},{key:"series",text:b.getText('COLUMNSPANEL_CHARTROLE_SERIES')}],Measure:[{key:"axis1",text:b.getText('COLUMNSPANEL_CHARTROLE_AXIS1')},{key:"axis2",text:b.getText('COLUMNSPANEL_CHARTROLE_AXIS2')},{key:"axis3",text:b.getText('COLUMNSPANEL_CHARTROLE_AXIS3')},{key:"axis4",text:b.getText('COLUMNSPANEL_CHARTROLE_AXIS4')}]};var M=new J({availableChartTypes:[],selectedChartTypeKey:null,items:[],columnKeyOfMarkedItem:undefined,isMoveDownButtonEnabled:undefined,isMoveUpButtonEnabled:undefined,showOnlySelectedItems:undefined,countOfSelectedItems:0,countOfItems:0});M.setDefaultBindingMode(o.TwoWay);M.setSizeLimit(1000);this.setModel(M,"$sapmP13nDimMeasurePanel");this.setType(v.dimeasure);this.setTitle(b.getText("CHARTPANEL_TITLE"));this._createTable();this._createToolbar();this.setVerticalScrolling(false);var x=new e({horizontal:false,vertical:true,content:[this._oTable],width:'100%',height:'100%'});this.addAggregation("content",x);this._fnHandleResize=function(){var y=false,z,A;if(a.getParent){var $=null,D,H;var E=a.getParent();var F=a._getToolbar();if(E&&E.$){$=E.$("cont");if($.children().length>0&&F.$().length>0){z=x.$()[0].clientHeight;D=$.children()[0].clientHeight;H=F?F.$()[0].clientHeight:0;A=D-H;if(z!==A){x.setHeight(A+'px');y=true;}}}}return y;};this._sContainerResizeListener=R.register(x,this._fnHandleResize);};w.prototype.onBeforeRendering=function(){this._updateInternalModel();if(!this._getInternalModel().getProperty("/columnKeyOfMarkedItem")){this._setColumnKeyOfMarkedItem(this._getColumnKeyByTableItem(this._getVisibleTableItems()[0]));}this._switchMarkedTableItemTo(this._getTableItemByColumnKey(this._getInternalModel().getProperty("/columnKeyOfMarkedItem")));this._updateControlLogic();};w.prototype.onAfterRendering=function(){var a=this;if(!this._bOnAfterRenderingFirstTimeExecuted){this._bOnAfterRenderingFirstTimeExecuted=true;window.clearTimeout(this._iLiveChangeTimer);this._iLiveChangeTimer=window.setTimeout(function(){a._fnHandleResize();a._getToolbar()._resetAndInvalidateToolbar();},0);}};w.prototype.getOkPayload=function(){this._updateInternalModel();this._getInternalModel().getProperty("/items").forEach(function(M){if(this._getDimMeasureItemByColumnKey(M.columnKey)){return;}if(!M.persistentSelected){return;}this.addAggregation("dimMeasureItems",new c({columnKey:M.columnKey,visible:M.persistentSelected,index:M.persistentIndex===-1?undefined:M.persistentIndex,role:M.role}));},this);return{dimMeasureItems:this.getDimMeasureItems(),chartTypeKey:this.getChartTypeKey()};};w.prototype.exit=function(){R.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;this._getToolbar().destroy();this._oTable.destroy();this._oTable=null;if(this._getInternalModel()){this._getInternalModel().destroy();}if(this.oInvisibleChartTypeText){this.oInvisibleChartTypeText.destroy();this.oInvisibleChartTypeText=null;}window.clearTimeout(this._iLiveChangeTimer);window.clearTimeout(this._iSearchTimer);};w.prototype.addItem=function(a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.addAggregation("items",a);return this;};w.prototype.insertItem=function(a,b){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.insertAggregation("items",a,b);return this;};w.prototype.removeItem=function(a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}a=this.removeAggregation("items",a);return a;};w.prototype.removeAllItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAllAggregation("items");};w.prototype.destroyItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.destroyAggregation("items");return this;};w.prototype.addDimMeasureItem=function(D){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.addAggregation("dimMeasureItems",D);return this;};w.prototype.insertDimMeasureItem=function(D,a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.insertAggregation("dimMeasureItems",D,a);return this;};w.prototype.updateDimMeasureItems=function(a){this.updateAggregation("dimMeasureItems");if(a===n.Change&&!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}};w.prototype.removeDimMeasureItem=function(D){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAggregation("dimMeasureItems",D);};w.prototype.removeAllDimMeasureItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAllAggregation("dimMeasureItems");};w.prototype.destroyDimMeasureItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.destroyAggregation("dimMeasureItems");return this;};w.prototype.setChartTypeKey=function(a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.setProperty("chartTypeKey",a);return this;};w.prototype.addAvailableChartType=function(a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.addAggregation("availableChartTypes",a);return this;};w.prototype.insertAvailableChartType=function(a,b){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.insertAggregation("availableChartTypes",a,b);return this;};w.prototype.removeAvailableChartType=function(a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAggregation("availableChartTypes",a);};w.prototype.removeAllAvailableChartType=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAllAggregation("availableChartTypes");};w.prototype.destroyAvailableChartType=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.destroyAggregation("availableChartTypes");return this;};w.prototype._notifyChange=function(){var a=this.getChangeNotifier();if(a){a(this);}};w.prototype._scrollToSelectedItem=function(a){if(!a){return;}sap.ui.getCore().applyChanges();if(!!a.getDomRef()){a.focus();}};w.prototype._getInternalModel=function(){return this.getModel("$sapmP13nDimMeasurePanel");};w.prototype._createTable=function(){var a=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oTable=new T({mode:u.MultiSelect,rememberSelections:false,itemPress:Q.proxy(this._onItemPressed,this),selectionChange:Q.proxy(this._onSelectionChange,this),columns:[new C({vAlign:m.VerticalAlign.Middle,header:new f({text:{parts:[{path:'/countOfSelectedItems'},{path:'/countOfItems'}],formatter:function(b,x){return a.getText('COLUMNSPANEL_SELECT_ALL_WITH_COUNTER',[b,x]);}}})}),new C({vAlign:m.VerticalAlign.Middle,header:new f({text:a.getText('COLUMNSPANEL_COLUMN_TYPE')})}),new C({vAlign:m.VerticalAlign.Middle,header:new f({text:a.getText('COLUMNSPANEL_COLUMN_ROLE')})})],items:{path:"/items",templateShareable:false,template:new d({cells:[new f({text:"{text}"}),new f({text:{path:'',formatter:function(M){if(M.aggregationRole==="Dimension"){return a.getText('COLUMNSPANEL_TYPE_DIMENSION');}if(M.aggregationRole==="Measure"){return a.getText('COLUMNSPANEL_TYPE_MEASURE');}}}}),new g({selectedKey:"{role}",items:{path:'availableRoleTypes',factory:function(b,x){var A=x.getObject();return new I({key:A.key,text:A.text});}},change:Q.proxy(this._onRoleChange,this)})],visible:"{visible}",selected:"{persistentSelected}",tooltip:"{tooltip}",type:L.Active})}});this._oTable.setModel(this._getInternalModel());};w.prototype._createToolbar=function(){var a=this;var b=sap.ui.getCore().getLibraryResourceBundle("sap.m");var x=new p({text:b.getText('COLUMNSPANEL_CHARTTYPE')});this.oInvisibleChartTypeText=x;var y=new h({placeholder:x.getText(),selectedKey:{path:'/selectedChartTypeKey'},ariaLabelledBy:x,items:{path:'/availableChartTypes',templateShareable:false,template:new I({key:"{key}",text:"{text}"})},selectionChange:Q.proxy(this._onChartTypeChange,this),layoutData:new i({moveToOverflow:false,stayInOverflow:false})});var z=new O(this.getId()+"-toolbar",{design:t.Auto,content:[x,y,new k(),new S(this.getId()+"-searchField",{liveChange:function(E){var V=E.getSource().getValue(),D=(V?300:0);window.clearTimeout(a._iSearchTimer);if(D){a._iSearchTimer=window.setTimeout(function(){a._onExecuteSearch();},D);}else{a._onExecuteSearch();}},search:Q.proxy(this._onExecuteSearch,this),layoutData:new i({minWidth:"12.5rem",maxWidth:"23.077rem",shrinkable:true,moveToOverflow:false,stayInOverflow:false})}),new B({text:{path:'/showOnlySelectedItems',formatter:function(A){return A?b.getText('COLUMNSPANEL_SHOW_ALL'):b.getText('COLUMNSPANEL_SHOW_SELECTED');}},tooltip:{path:'/showOnlySelectedItems',formatter:function(A){return A?b.getText('COLUMNSPANEL_SHOW_ALL'):b.getText('COLUMNSPANEL_SHOW_SELECTED');}},type:s.Transparent,press:Q.proxy(this._onSwitchButtonShowSelected,this),layoutData:new i({moveToOverflow:true,priority:r.High})}),new j({icon:q.getIconURI("collapse-group"),text:b.getText('COLUMNSPANEL_MOVE_TO_TOP'),tooltip:b.getText('COLUMNSPANEL_MOVE_TO_TOP'),type:s.Transparent,enabled:{path:'/isMoveUpButtonEnabled'},press:Q.proxy(this.onPressButtonMoveToTop,this),layoutData:new i({moveToOverflow:true,priority:r.Low,group:2})}),new j({icon:q.getIconURI("slim-arrow-up"),text:b.getText('COLUMNSPANEL_MOVE_UP'),tooltip:b.getText('COLUMNSPANEL_MOVE_UP'),type:s.Transparent,enabled:{path:'/isMoveUpButtonEnabled'},press:Q.proxy(this.onPressButtonMoveUp,this),layoutData:new i({moveToOverflow:true,priority:r.High,group:1})}),new j({icon:q.getIconURI("slim-arrow-down"),text:b.getText('COLUMNSPANEL_MOVE_DOWN'),tooltip:b.getText('COLUMNSPANEL_MOVE_DOWN'),type:s.Transparent,enabled:{path:'/isMoveDownButtonEnabled'},press:Q.proxy(this.onPressButtonMoveDown,this),layoutData:new i({moveToOverflow:true,priority:r.High,group:1})}),new j({icon:q.getIconURI("expand-group"),text:b.getText('COLUMNSPANEL_MOVE_TO_BOTTOM'),tooltip:b.getText('COLUMNSPANEL_MOVE_TO_BOTTOM'),type:s.Transparent,enabled:{path:'/isMoveDownButtonEnabled'},press:Q.proxy(this.onPressButtonMoveToBottom,this),layoutData:new i({moveToOverflow:true,priority:r.Low,group:2})})]});z.setModel(this._getInternalModel());this.addAggregation("content",z);};w.prototype.onPressButtonMoveToTop=function(){this._moveMarkedTableItem(this._getMarkedTableItem(),this._getVisibleTableItems()[0]);};w.prototype.onPressButtonMoveUp=function(){var V=this._getVisibleTableItems();this._moveMarkedTableItem(this._getMarkedTableItem(),V[V.indexOf(this._getMarkedTableItem())-1]);};w.prototype.onPressButtonMoveDown=function(){var V=this._getVisibleTableItems();this._moveMarkedTableItem(this._getMarkedTableItem(),V[V.indexOf(this._getMarkedTableItem())+1]);};w.prototype.onPressButtonMoveToBottom=function(){var V=this._getVisibleTableItems();this._moveMarkedTableItem(this._getMarkedTableItem(),V[V.length-1]);};w.prototype._onSwitchButtonShowSelected=function(){this._getInternalModel().setProperty("/showOnlySelectedItems",!this._getInternalModel().getProperty("/showOnlySelectedItems"));this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();this._scrollToSelectedItem(this._getMarkedTableItem());this._updateControlLogic();this._fnHandleResize();};w.prototype._onExecuteSearch=function(){this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();this._updateControlLogic();};w.prototype._switchVisibilityOfUnselectedModelItems=function(){var b=this._isFilteredByShowSelected();var M=this._getInternalModel().getProperty("/items");M.forEach(function(a){if(a.persistentSelected){a.visible=true;return;}a.visible=!b;});this._getInternalModel().setProperty("/items",M);};w.prototype._getVisibleModelItems=function(){return this._getInternalModel().getProperty("/items").filter(function(M){return!!M.visible;});};w.prototype._getVisibleModelItems=function(){return this._getInternalModel().getProperty("/items").filter(function(M){return!!M.visible;});};w.prototype._moveMarkedTableItem=function(a,b){var M=this._getModelItemByColumnKey(this._getColumnKeyByTableItem(a));var x=this._getModelItemByColumnKey(this._getColumnKeyByTableItem(b));var y=this._getModelItemIndexByColumnKey(M.columnKey);var z=this._getModelItemIndexByColumnKey(x.columnKey);this._moveModelItems(y,z);this._scrollToSelectedItem(this._getMarkedTableItem());this._updateControlLogic();this._fireChangeDimMeasureItems();this._notifyChange();};w.prototype._moveModelItems=function(a,b){var M=this._getInternalModel().getProperty("/items");if(a<0||b<0||a>M.length-1||b>M.length-1){return false;}this._removeStyleOfMarkedTableItem();var x=M.splice(a,1);M.splice(b,0,x[0]);this._updateModelItemsPersistentIndex(M);this._updateCounts(M);this._getInternalModel().setProperty("/items",M);this._switchMarkedTableItemTo(this._getMarkedTableItem());return true;};w.prototype._getModelItemByColumnKey=function(a){var M=this._getInternalModel().getProperty("/items").filter(function(b){return b.columnKey===a;});return M[0];};w.prototype._updateCounts=function(M){var a=0;var b=0;M.forEach(function(x){a++;if(x.persistentSelected){b++;}});this._getInternalModel().setProperty("/countOfItems",a);this._getInternalModel().setProperty("/countOfSelectedItems",b);};w.prototype._sortModelItemsByPersistentIndex=function(M){var x;var y=sap.ui.getCore().getConfiguration().getLocale().toString();try{if(typeof window.Intl!=='undefined'){x=window.Intl.Collator(y,{numeric:true});}}catch(E){}M.forEach(function(a,b){a.localIndex=b;});M.sort(function(a,b){if(a.persistentSelected===true&&(b.persistentSelected===false||b.persistentSelected===undefined)){return-1;}else if((a.persistentSelected===false||a.persistentSelected===undefined)&&b.persistentSelected===true){return 1;}else if(a.persistentSelected===true&&b.persistentSelected===true){if(a.persistentIndex>-1&&a.persistentIndex<b.persistentIndex){return-1;}else if(b.persistentIndex>-1&&a.persistentIndex>b.persistentIndex){return 1;}else{return a.localIndex-b.localIndex;}}else if((a.persistentSelected===false||a.persistentSelected===undefined)&&(b.persistentSelected===false||b.persistentSelected===undefined)){return x?x.compare(a.text,b.text):a.text.localeCompare(b.text,y,{numeric:true});}});M.forEach(function(a){delete a.localIndex;});};w.prototype._getColumnKeyByTableItem=function(a){var b=this._oTable.indexOfItem(a);if(b<0){return null;}return this._oTable.getBinding("items").getContexts()[b].getObject().columnKey;};w.prototype._getModelItemIndexByColumnKey=function(a){var b=-1;this._getInternalModel().getData().items.some(function(M,x){if(M.columnKey===a){b=x;return true;}});return b;};w.prototype._getSelectedModelItems=function(){return this._getInternalModel().getProperty("/items").filter(function(M){return M.persistentSelected;});};w.prototype._getVisibleTableItems=function(){return this._oTable.getItems().filter(function(a){return a.getVisible();});};w.prototype._getTableItemByColumnKey=function(a){var b=this._oTable.getBinding("items").getContexts();var x=this._oTable.getItems().filter(function(y,z){return b[z].getObject().columnKey===a;});return x[0];};w.prototype._getToolbar=function(){return sap.ui.getCore().byId(this.getId()+"-toolbar")||null;};w.prototype._getSearchField=function(){return sap.ui.getCore().byId(this.getId()+"-searchField")||null;};w.prototype._getSearchText=function(){var a=this._getSearchField();return a?a.getValue():"";};w.prototype._isFilteredBySearchText=function(){return!!this._getSearchText().length;};w.prototype._isFilteredByShowSelected=function(){return this._getInternalModel().getData().showOnlySelectedItems;};w.prototype._updateControlLogic=function(){var b=this._isFilteredBySearchText();var a=this._isFilteredByShowSelected();var V=this._getVisibleTableItems();this._getInternalModel().setProperty("/isMoveUpButtonEnabled",V.indexOf(this._getMarkedTableItem())>0);this._getInternalModel().setProperty("/isMoveDownButtonEnabled",V.indexOf(this._getMarkedTableItem())>-1&&V.indexOf(this._getMarkedTableItem())<V.length-1);var x=sap.ui.getCore().byId(this._oTable.getId()+'-sa');if(x){x.setEnabled(!b&&!a);}};w.prototype._updateModelItemsPersistentIndex=function(M){var a=-1;M.forEach(function(b){b.persistentIndex=-1;if(b.persistentSelected){a++;b.persistentIndex=a;}});};w.prototype._fireChangeDimMeasureItems=function(){this._bIgnoreUpdateInternalModel=true;this.fireChangeDimMeasureItems({items:this._getInternalModel().getProperty("/items").map(function(M){return{columnKey:M.columnKey,visible:M.persistentSelected,index:M.persistentIndex===-1?undefined:M.persistentIndex,role:M.role};})});this._bIgnoreUpdateInternalModel=false;};w.prototype._fireChangeChartType=function(){this._bIgnoreUpdateInternalModel=true;this.fireChangeChartType({chartTypeKey:this._getInternalModel().getProperty("/selectedChartTypeKey")});this._bIgnoreUpdateInternalModel=false;};w.prototype._getDimMeasureItemByColumnKey=function(a){var D=this.getDimMeasureItems().filter(function(b){return b.getColumnKey()===a;});return D[0];};w.prototype._getMarkedTableItem=function(){return this._getTableItemByColumnKey(this._getInternalModel().getProperty("/columnKeyOfMarkedItem"));};w.prototype._setColumnKeyOfMarkedItem=function(a){this._getInternalModel().setProperty("/columnKeyOfMarkedItem",a);};w.prototype._onItemPressed=function(E){this._switchMarkedTableItemTo(E.getParameter('listItem'));this._updateControlLogic();};w.prototype._onChartTypeChange=function(E){this._fireChangeChartType();this._notifyChange();};w.prototype._onRoleChange=function(E){this._fireChangeDimMeasureItems();this._notifyChange();};w.prototype._onSelectionChange=function(E){if(!E.getParameter("selectAll")&&E.getParameter("listItems").length===1){this._switchMarkedTableItemTo(E.getParameter("listItem"));}this._selectTableItem();};w.prototype._selectTableItem=function(){this._updateControlLogic();var M=this._getInternalModel().getProperty("/items");this._updateModelItemsPersistentIndex(M);this._updateCounts(M);this._getInternalModel().setProperty("/items",M);this._fireChangeDimMeasureItems();this._notifyChange();};w.prototype._switchMarkedTableItemTo=function(a){this._removeStyleOfMarkedTableItem();var b=this._getColumnKeyByTableItem(a);if(b){this._setColumnKeyOfMarkedItem(b);a.addStyleClass("sapMP13nColumnsPanelItemSelected");}};w.prototype._removeStyleOfMarkedTableItem=function(){if(this._getMarkedTableItem()){this._getMarkedTableItem().removeStyleClass("sapMP13nColumnsPanelItemSelected");}};w.prototype._filterModelItemsBySearchText=function(){var a=this._getSearchText();a=a.replace(/(^\s+)|(\s+$)/g,'');a=a.replace(/[-\/\\^$*+?.()|[\]{}]/g,'\\$&');var b=new RegExp(a,'igm');if(!b){return;}this._getVisibleModelItems().forEach(function(M){var x=this._getTableItemByColumnKey(M.columnKey);var y=x.getCells();M.visible=false;if(y[0]&&y[0].getText().match(b)){M.visible=true;}if(y[1]&&y[1].getText().match(b)){M.visible=true;}if(y[2]&&y[2].getSelectedItem()&&y[2].getSelectedItem().getText().match(b)){M.visible=true;}if(M.tooltip&&M.tooltip.match(b)){M.visible=true;}},this);this._getInternalModel().refresh();};w.prototype._updateInternalModel=function(){if(!this._bUpdateInternalModel){return;}this._bUpdateInternalModel=false;this._removeStyleOfMarkedTableItem();this._getInternalModel().setProperty("/items",this.getItems().map(function(a){return{columnKey:a.getColumnKey(),visible:true,text:a.getText(),tooltip:a.getTooltip(),aggregationRole:a.getAggregationRole(),availableRoleTypes:this.oAvailableRoleTypes[a.getAggregationRole()],role:a.getRole(),persistentIndex:-1,persistentSelected:undefined};},this));this._getInternalModel().setProperty("/selectedChartTypeKey",this.getChartTypeKey());this._getInternalModel().setProperty("/availableChartTypes",this.getAvailableChartTypes().map(function(a){return{key:a.getKey(),text:a.getText()};},this));this.getDimMeasureItems().forEach(function(D){var a=this._getModelItemByColumnKey(D.getColumnKey());if(!a){return;}if(D.getIndex()!==undefined){a.persistentIndex=D.getIndex();}if(D.getVisible()!==undefined){a.persistentSelected=D.getVisible();}if(D.getRole()!==undefined){a.role=D.getRole();}},this);this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();var M=this._getInternalModel().getProperty("/items");this._sortModelItemsByPersistentIndex(M);this._updateCounts(M);this._getInternalModel().setProperty("/items",M);this._switchMarkedTableItemTo(this._getMarkedTableItem());};return w;});
