/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/m/delegate/DateNavigation','sap/ui/core/Control','sap/ui/base/ManagedObject','sap/ui/base/ManagedObjectObserver','sap/ui/unified/library','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/calendar/DatesRow','sap/ui/unified/calendar/OneMonthDatesRow','sap/ui/unified/calendar/MonthsRow','sap/ui/unified/calendar/TimesRow','sap/ui/unified/DateRange','sap/ui/unified/CalendarAppointment','sap/ui/unified/CalendarRow','sap/ui/unified/CalendarRowRenderer','sap/ui/Device','sap/ui/core/Element','sap/ui/core/Renderer','sap/ui/core/ResizeHandler','sap/ui/core/InvisibleText','sap/ui/core/Item','sap/ui/core/dnd/DragInfo','sap/ui/core/dnd/DropInfo','sap/ui/core/dnd/DragDropInfo','sap/ui/core/format/DateFormat','sap/m/Select','sap/m/Button','sap/m/OverflowToolbar','sap/m/Toolbar','sap/m/Table','sap/m/Column','sap/m/ColumnListItem','sap/m/ColumnListItemRenderer','sap/m/SegmentedButtonItem','sap/m/StandardListItem','sap/m/StandardListItemRenderer','sap/m/PlanningCalendarHeader','sap/m/PlanningCalendarRow','sap/m/PlanningCalendarRenderer','sap/m/PlanningCalendarView','sap/m/CheckBox','sap/m/library',"sap/base/util/deepEqual","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/control"],function(D,C,M,a,u,b,c,d,O,e,T,f,g,h,k,l,E,R,m,I,n,o,p,q,r,S,B,s,t,v,w,x,y,z,A,F,P,G,H,J,K,L,N,Q,U){"use strict";var V=L.Sticky;var W=u.CalendarDayType;var X=L.ListMode;var Y=L.ToolbarDesign;var Z=L.PlanningCalendarBuiltInView;var $=L.ScreenSize;var _=u.CalendarAppointmentVisualization;var a1=u.GroupAppointmentsMode;var b1=u.CalendarIntervalType;var c1=u.CalendarAppointmentHeight;var d1="DragDropConfig";var e1="ResizeConfig";var f1="CreateConfig";var g1="-CLI";var h1=C.extend("sap.m.PlanningCalendar",{metadata:{library:"sap.m",properties:{startDate:{type:"object",group:"Data"},viewKey:{type:"string",group:"Appearance",defaultValue:b1.Hour},singleSelection:{type:"boolean",group:"Misc",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},showIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showEmptyIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showRowHeaders:{type:"boolean",group:"Appearance",defaultValue:true},noDataText:{type:"string",group:"Misc",defaultValue:null},groupAppointmentsMode:{type:"sap.ui.unified.GroupAppointmentsMode",group:"Appearance",defaultValue:a1.Collapsed},appointmentsReducedHeight:{type:"boolean",group:"Appearance",defaultValue:false},appointmentHeight:{type:"string",group:"Appearance",defaultValue:c1.Regular,visibility:"hidden"},appointmentsVisualization:{type:"sap.ui.unified.CalendarAppointmentVisualization",group:"Appearance",defaultValue:_.Standard},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},showDayNamesLine:{type:"boolean",group:"Appearance",defaultValue:false},showWeekNumbers:{type:"boolean",group:"Appearance",defaultValue:false},builtInViews:{type:"string[]",group:"Appearance",defaultValue:[]},stickyHeader:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{rows:{type:"sap.m.PlanningCalendarRow",multiple:true,singularName:"row"},views:{type:"sap.m.PlanningCalendarView",multiple:true,singularName:"view"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},toolbarContent:{type:"sap.ui.core.Control",multiple:true,singularName:"toolbarContent",forwarding:{getter:"_getHeader",aggregation:"actions"},forwardBinding:true},table:{type:"sap.m.Table",multiple:false,visibility:"hidden"},header:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{appointmentSelect:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},appointments:{type:"sap.ui.unified.CalendarAppointment[]"},multiSelect:{type:"boolean"},domRefId:{type:"string"}}},intervalSelect:{parameters:{startDate:{type:"object"},endDate:{type:"object"},subInterval:{type:"boolean"},row:{type:"sap.m.PlanningCalendarRow"}}},rowSelectionChange:{parameters:{rows:{type:"sap.m.PlanningCalendarRow[]"}}},startDateChange:{},viewChange:{},rowHeaderClick:{row:{type:"sap.m.PlanningCalendarRow"}}},designtime:"sap/m/designtime/PlanningCalendar.designtime"},constructor:function(i,j){C.prototype.constructor.apply(this,arguments);if(typeof i!=="string"){j=i;}if(j&&typeof j.customAppointmentsSorterCallback==="function"){this._fnCustomSortedAppointments=j.customAppointmentsSorterCallback;}}});var i1=["_oTimesRow","_oDatesRow","_oMonthsRow","_oWeeksRow","_oOneMonthsRow"],j1={};j1[b1.Day]={sInstanceName:"_oDatesRow",sIdSuffix:"-DatesRow",oClass:d};j1[b1.Week]={sInstanceName:"_oWeeksRow",sIdSuffix:"-WeeksRow",oClass:d};j1[b1.OneMonth]={sInstanceName:"_oOneMonthsRow",sIdSuffix:"-OneMonthsRow",oClass:O};var k1=$.Desktop;var l1=[Z.Hour,Z.Day,Z.Month,Z.Week,Z.OneMonth];var m1={PHONE:"600",TABLET:"1024"};var n1=["sap.ui.unified.calendar.TimesRow","sap.ui.unified.calendar.DatesRow","sap.ui.unified.calendar.MonthsRow","sap.ui.unified.calendar.OneMonthDatesRow"];var o1=C.extend("CalendarHeader",{metadata:{aggregations:{"toolbar":{type:"sap.m.Toolbar",multiple:false},"allCheckBox":{type:"sap.m.CheckBox",multiple:false}}},renderer:function(i,j){i.write("<div");i.writeControlData(j);i.addClass("sapMPlanCalHead");i.writeClasses();i.write(">");var P1=j.getToolbar();if(P1){i.renderControl(P1);}var Q1=j.getAllCheckBox();if(Q1){i.renderControl(Q1);}i.write("</div>");}});h1.prototype.init=function(){this._dateNav=new D();this._iBreakPointTablet=l.media._predefinedRangeSets[l.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this._iBreakPointDesktop=l.media._predefinedRangeSets[l.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];this._iBreakPointLargeDesktop=l.media._predefinedRangeSets[l.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2];if(l.system.phone||U('html').hasClass("sapUiMedia-Std-Phone")){this._iSize=0;this._iSizeScreen=0;}else if((l.system.tablet||U('html').hasClass("sapUiMedia-Std-Tablet"))&&!(l.system.desktop||U('html').hasClass("sapUiMedia-Std-Desktop"))){this._iSize=1;this._iSizeScreen=1;}else{this._iSize=2;this._iSizeScreen=2;}this.addStyleClass("sapMSize"+this._iSize);this.setAggregation("header",this._createHeader());this._attachHeaderEvents();this._oRB=sap.ui.getCore().getLibraryResourceBundle("sap.m");var i=this.getId();this._oIntervalTypeSelect=this._getHeader()._getOrCreateViewSwitch();this._oIntervalTypeSelect.attachEvent("selectionChange",p1,this);this._oTodayButton=this._getHeader()._getTodayButton();this._oCalendarHeader=new o1(i+"-CalHead",{});this._oInfoToolbar=new t(i+"-InfoToolbar",{height:"auto",design:Y.Transparent,content:[this._oCalendarHeader,this._oTimesRow]});var j=new v(i+"-Table",{sticky:[],infoToolbar:this._oInfoToolbar,mode:X.SingleSelectMaster,columns:[new w({styleClass:"sapMPlanCalRowHead"}),new w({width:"80%",styleClass:"sapMPlanCalAppRow",minScreenWidth:k1,demandPopin:true})],ariaLabelledBy:i+"-Descr"});j.attachEvent("selectionChange",F1,this);j.addDelegate({onBeforeRendering:function(){if(this._rowHeaderClickEvent){this._rowHeaderClickEvent.off();}},onAfterRendering:function(){this._rowHeaderClickEvent=j.$().find(".sapMPlanCalRowHead > div.sapMLIB").click(function(P1){var Q1=U(P1.currentTarget).control(0),R1=B1(Q1.getParent());this.fireRowHeaderClick({row:R1});}.bind(this));this._adjustColumnHeadersTopOffset();}},false,this);this.setAggregation("table",j,true);this.setStartDate(new Date());this._resizeProxy=U.proxy(t1,this);this._fnCustomSortedAppointments=undefined;this.iWidth=0;};h1.prototype.exit=function(){if(this._sResizeListener){m.deregister(this._sResizeListener);this._sResizeListener=undefined;}l.orientation.detachHandler(this._updateStickyHeader,this);if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}var i=this.getAggregation("table");i.removeAllItems();i1.forEach(function(P1){if(this[P1]){this[P1]._oPlanningCalendar=undefined;this[P1].destroy();this[P1]=undefined;}},this);if(this._oViews){for(var j in this._oViews){this._oViews[j].destroy();}}if(this._oSelectAllCheckBox){this._oSelectAllCheckBox.destroy();}if(this._rowHeaderClickEvent){this._rowHeaderClickEvent.off();this._rowHeaderClickEvent=null;}};h1.prototype.onBeforeRendering=function(){this._bBeforeRendering=true;if((!this._oTimesRow&&!this._oDatesRow&&!this._oMonthsRow&&!this._oWeeksRow&&!this._oOneMonthsRow)||this._bCheckView){this.setViewKey(this.getViewKey());this._bCheckView=undefined;}I1.call(this);if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}this._updatePickerSelection();this._updateHeaderButtons();l.orientation.detachHandler(this._updateStickyHeader,this);this._bBeforeRendering=undefined;this._toggleStickyClasses();};h1.prototype.attachEvent=function(i,j,P1,Q1){C.prototype.attachEvent.call(this,i,j,P1,Q1);if(this.hasListeners("intervalSelect")){i1.forEach(function(R1){if(this[R1]){this[R1]._setAriaRole("button");}},this);}return this;};h1.prototype.detachEvent=function(i,j,P1){C.prototype.detachEvent.call(this,i,j,P1);if(!this.hasListeners("intervalSelect")){i1.forEach(function(Q1){if(this[Q1]){this[Q1]._setAriaRole("gridcell");}},this);}return this;};h1.prototype._createHeader=function(){var i=new P(this.getId()+"-Header");i.getAggregation("_actionsToolbar").addAriaLabelledBy(I.getStaticId("sap.m","PC_FUNCTIONS_TOOLBAR"));i.getAggregation("_navigationToolbar").addAriaLabelledBy(I.getStaticId("sap.m","PC_INTERVAL_SELECTION_TOOLBAR"));return i;};h1.prototype._attachHeaderEvents=function(){var i=this._getHeader();i.attachEvent("pressPrevious",this._handlePressArrow,this);i.attachEvent("pressToday",this._handleTodayPress,this);i.attachEvent("pressNext",this._handlePressArrow,this);i.attachEvent("dateSelect",this._handleDateSelect,this);return this;};h1.prototype._handlePressArrow=function(i){this._applyArrowsLogic(i.getId()==="pressPrevious");};h1.prototype._applyArrowsLogic=function(i){if(i){this._dateNav.previous();}else{this._dateNav.next();}if(this.getMinDate()&&this._dateNav.getStart().getTime()<=this.getMinDate().getTime()){this._dateNav.setStart(this.getMinDate());this._dateNav.setCurrent(this.getMinDate());}if(this.getMaxDate()&&this._dateNav.getEnd().getTime()>=this.getMaxDate().getTime()){this._dateNav.setStart(this.getMaxDate());this._dateNav.setCurrent(this.getMaxDate());}var j=this._getRowInstanceByViewKey(this.getViewKey());this.setStartDate(this._dateNav.getStart());j.setDate(this._dateNav.getCurrent());this._updatePickerSelection();this.fireStartDateChange();};h1.prototype._formatPickerText=function(){var i=this._getFirstAndLastRangeDate(),j=b._createLocalDate(i.oStartDate,true),P1=b._createLocalDate(i.oEndDate,true),Q1=this.getViewKey(),R1=b1[Q1]?b1[Q1]:this._getView(Q1).getIntervalType(),S1=sap.ui.getCore().getConfiguration().getRTL(),T1,U1,V1,W1;switch(R1){case b1.Hour:T1=r.getDateInstance({format:"yMMMMd"});V1=T1.format(j);if(j.getDate()!==P1.getDate()){W1=T1.format(P1);}break;case b1.Day:case b1.Week:T1=r.getDateInstance({format:"yMMMMd"});V1=T1.format(j);W1=T1.format(P1);break;case b1.OneMonth:T1=r.getDateInstance({format:"yMMMM"});V1=T1.format(j);break;case b1.Month:T1=r.getDateInstance({format:"y"});V1=T1.format(j);if(j.getFullYear()!==P1.getFullYear()){W1=T1.format(P1);}break;default:throw new Error("Unknown IntervalType: "+Q1+"; "+this);}if(!S1){U1=V1;if(W1){U1+=" - "+W1;}}else{if(W1){U1=W1+" - "+V1;}else{U1=V1;}}return U1;};h1.prototype._getFirstAndLastRangeDate=function(){var i=b._createUniversalUTCDate(this.getStartDate(),"Gregorian",true),j=b._createUniversalUTCDate(this._dateNav.getEnd(),"Gregorian",true);return{oStartDate:i,oEndDate:j};};h1.prototype._getHeader=function(){return this.getAggregation("header");};h1.prototype._toggleStickyClasses=function(){this.toggleStyleClass("sapMPCSticky",this.getStickyHeader());return this;};h1.prototype._adjustColumnHeadersTopOffset=function(){var i=this.getStickyHeader(),j=this.getDomRef().querySelector(".sapMListInfoTBarContainer"),P1;switch(i){case true:P1=this._getHeader().$().outerHeight()+"px";break;default:P1="auto";break;}j.style.top=P1;return this;};h1.prototype.setAppointmentHeight=function(j){var P1=this.getRows(),i;this.setProperty("appointmentHeight",j,true);for(i=0;i<P1.length;i++){var Q1=P1[i];E1(Q1).setProperty("appointmentHeight",j);}return this;};h1.prototype._setAriaRole=function(i){if(this.hasListeners("intervalSelect")){i._setAriaRole("button");}else{i._setAriaRole("gridcell");}};h1.prototype._updateTodayButtonState=function(){if(this._oTodayButton){this._oTodayButton.setEnabled(!this._dateMatchesVisibleRange(new Date(),this.getViewKey()));}};h1.prototype._dateMatchesVisibleRange=function(i,j){var P1=this._getView(j,!this._bBeforeRendering);if(!P1){return false;}var Q1=P1.getIntervalType(),R1=j1[Q1],S1=R1?this[R1.sInstanceName]:null,T1=false;if(S1&&j==="One Month"){return b._isSameMonthAndYear(c.fromLocalJSDate(this.getStartDate()),c.fromLocalJSDate(i));}else if(S1&&j==="Week"){var U1=S1.getDays(),V1=c.fromLocalJSDate(i),W1=c.fromLocalJSDate(this.getStartDate()),X1=c.fromLocalJSDate(this.getStartDate());X1.setDate(X1.getDate()+U1);return V1.isSameOrAfter(W1)&&V1.isBefore(X1);}return T1;};h1.prototype.onAfterRendering=function(i){i.size={width:this.getDomRef().offsetWidth};t1.call(this,i,true);if(!this._sResizeListener){this._sResizeListener=m.register(this,this._resizeProxy);}if(l.system.phone&&this.getStickyHeader()){l.orientation.attachHandler(this._updateStickyHeader,this);}this._updateCurrentTimeVisualization(false);if(this.getHeight()){var j=this.getDomRef().querySelector("table");if(this.getHeight().indexOf("%")>-1){j.style.height=this.getHeight();return;}var P1=this.$().height()-this._oInfoToolbar.$().height()+"px";j.style.height=P1;}this._adjustColumnHeadersTopOffset();};h1.prototype.onThemeChanged=function(){if(this.getDomRef()){this._adjustColumnHeadersTopOffset();}};h1.prototype.addToolbarContent=function(i){if(i&&i.isA("sap.m.Title")){this._observeHeaderTitleText(i);this._getHeader().setTitle(i.getText());i.setVisible(false);}this.addAggregation("toolbarContent",i);return this;};h1.prototype.insertToolbarContent=function(i,j){if(i&&i.isA("sap.m.Title")){this._observeHeaderTitleText(i);this._getHeader().setTitle(i.getText());i.setVisible(false);}this.insertAggregation("toolbarContent",i,j);return this;};h1.prototype.removeToolbarContent=function(i){var j;if(i&&i.isA("sap.m.Title")){this._getHeader().setTitle("");this._disconnectAndDestroyHeaderObserver();}else{j=this.removeAggregation("toolbarContent",i);}return j;};h1.prototype.removeAllToolbarContent=function(){var i=this.removeAllAggregation("toolbarContent");this._getHeader().setTitle("");this._disconnectAndDestroyHeaderObserver();return i;};h1.prototype.destroyToolbarContent=function(){var i=this.destroyAggregation("toolbarContent");this._getHeader().setTitle("");this._disconnectAndDestroyHeaderObserver();return i;};h1.prototype._getHeaderObserver=function(){if(!this._oHeaderObserver){this._oHeaderObserver=new a(this._handleTitleTextChange.bind(this));}return this._oHeaderObserver;};h1.prototype._observeHeaderTitleText=function(i){this._getHeaderObserver().observe(i,{properties:["text"]});};h1.prototype._handleTitleTextChange=function(i){this._getHeader().setTitle(i.current);};h1.prototype._disconnectAndDestroyHeaderObserver=function(){if(this._oHeaderObserver){this._oHeaderObserver.disconnect();this._oHeaderObserver.destroy();this._oHeaderObserver=null;}};h1.prototype.setStartDate=function(i){var j,P1,Q1;if(!i){Q1=new Date();}else{b._checkJSDateObject(i);Q1=new Date(i.getTime());}if(this.getViewKey()===Z.Week){j=b.getFirstDateOfWeek(b._createUniversalUTCDate(Q1,undefined,true));Q1.setTime(b._createLocalDate(j,true).getTime());}if(this.getViewKey()===Z.OneMonth||this.getViewKey()===Z.Month){P1=b.getFirstDateOfMonth(b._createUniversalUTCDate(Q1,undefined,true));Q1.setTime(b._createLocalDate(P1,true).getTime());}if(N(Q1,this.getStartDate())){this._updateTodayButtonState();return this;}var R1=Q1.getFullYear();b._checkYearInValidRange(R1);var S1=this.getMinDate();if(S1&&S1.getTime()>Q1.getTime()){Q.warning("StartDate < minDate -> StartDate set to minDate",this);Q1=new Date(S1.getTime());}else{var T1=this.getMaxDate();if(T1&&T1.getTime()<Q1.getTime()){Q.warning("StartDate > maxDate -> StartDate set to minDate",this);if(S1){Q1=new Date(S1.getTime());}else{Q1=new Date(1,0,1);Q1.setFullYear(1);}}}this.setProperty("startDate",Q1,true);this._dateNav.setStart(Q1);this._dateNav.setCurrent(Q1);this._getHeader().setStartDate(Q1);i1.forEach(function(U1){if(this[U1]){this[U1].setStartDate(new Date(Q1.getTime()));}},this);if(this.getViewKey()===Z.OneMonth&&this._oOneMonthsRow.getMode()<2&&this._oOneMonthsRow.getSelectedDates().length){this._setRowsStartDate(this._oOneMonthsRow.getSelectedDates()[0].getStartDate());}else{this._setRowsStartDate(new Date(Q1.getTime()));}if(this.getViewKey()===Z.Week||this.getViewKey()===Z.OneMonth){this._updateTodayButtonState();}if(this.getDomRef()){this._updateCurrentTimeVisualization(false);this._updatePickerSelection();}this._updateHeaderButtons();return this;};h1.prototype.setMinDate=function(i){if(N(i,this.getMinDate())){return this;}var j=this.getMaxDate(),P1=this._getHeader();if(i){b._checkJSDateObject(i);var Q1=i.getFullYear();b._checkYearInValidRange(Q1);this.setProperty("minDate",i,true);this._bNoStartDateChange=true;P1.getAggregation("_calendarPicker").setMinDate(new Date(i.getTime()));P1.getAggregation("_monthPicker").setMinDate(new Date(i.getTime()));P1.getAggregation("_yearPicker").setMinDate(new Date(i.getTime()));if(j&&j.getTime()<i.getTime()){Q.warning("minDate > maxDate -> maxDate set to end of the month",this);j=new Date(i.getTime());j.setMonth(j.getMonth()+1,0);j.setHours(23);j.setMinutes(59);j.setSeconds(59);j.setMilliseconds(0);this.setMaxDate(j);}this._bNoStartDateChange=undefined;var R1=this.getStartDate();if(R1&&R1.getTime()<i.getTime()){Q.warning("StartDate < minDate -> StartDate set to minDate",this);R1=new Date(i.getTime());this.setStartDate(R1);P1.setPickerText(this._formatPickerText());}}else{this.setProperty("minDate",undefined,true);P1.getAggregation("_calendarPicker").setMinDate();P1.getAggregation("_monthPicker").setMinDate();P1.getAggregation("_yearPicker").setMinDate();}var S1=new Date();if(i&&S1.getTime()<i.getTime()){this._oTodayButton.setVisible(false);}else if(!j||S1.getTime()<j.getTime()){this._oTodayButton.setVisible(true);}return this;};h1.prototype.setMaxDate=function(i){if(N(i,this.getMaxDate())){return this;}var j=this.getMinDate(),P1=this._getHeader();if(i){b._checkJSDateObject(i);var Q1=i.getFullYear();b._checkYearInValidRange(Q1);this.setProperty("maxDate",i,true);this._bNoStartDateChange=true;P1.getAggregation("_calendarPicker").setMaxDate(new Date(i.getTime()));P1.getAggregation("_monthPicker").setMaxDate(new Date(i.getTime()));P1.getAggregation("_yearPicker").setMaxDate(new Date(i.getTime()));if(j&&j.getTime()>i.getTime()){Q.warning("maxDate < minDate -> maxDate set to begin of the month",this);j=new Date(i.getTime());j.setDate(1);j.setHours(0);j.setMinutes(0);j.setSeconds(0);j.setMilliseconds(0);this.setMinDate(j);}this._bNoStartDateChange=undefined;var R1=this.getStartDate();if(R1&&R1.getTime()>i.getTime()){Q.warning("StartDate > maxDate -> StartDate set to minDate",this);if(j){R1=new Date(j.getTime());}else{R1=new Date(1,0,1);R1.setFullYear(1);}this.setStartDate(R1);P1.setPickerText(this._formatPickerText());}}else{this.setProperty("maxDate",undefined,true);P1.getAggregation("_calendarPicker").setMaxDate();P1.getAggregation("_monthPicker").setMaxDate();P1.getAggregation("_yearPicker").setMaxDate();}var S1=new Date();if(i&&S1.getTime()>i.getTime()){this._oTodayButton.setVisible(false);}else if(!j||S1.getTime()>j.getTime()){this._oTodayButton.setVisible(true);}return this;};h1.prototype.removeIntervalInstanceFromInfoToolbar=function(){var i=this._oInfoToolbar.getContent();i.forEach(function(j){if(j.isA(n1)){this._oInfoToolbar.removeContent(j);}}.bind(this));};h1.prototype.setViewKey=function(j){var P1,Q1,R1,S1=this.getViewKey(),T1=this._getHeader(),U1;this.setProperty("viewKey",j,true);this._oIntervalTypeSelect.setSelectedKey(j);this.removeIntervalInstanceFromInfoToolbar();var V1=this.getStartDate();var W1=this.getMinDate();var X1=this.getMaxDate();var Y1=this._getView(j,!this._bBeforeRendering);if(!Y1){this._bCheckView=true;this.invalidate();}else{var Z1=Y1.getIntervalType();var $1=this._getIntervals(Y1);this._bCheckView=false;this._dateNav.setUnit(Z1);this._dateNav.setStep($1);this._dateNav.setCurrent(undefined);switch(Z1){case b1.Hour:if(!this._oTimesRow){this._oTimesRow=new T(this.getId()+"-TimesRow",{startDate:new Date(V1.getTime()),items:$1,legend:this.getLegend()});this._setAriaRole(this._oTimesRow);this._oTimesRow._setLegendControlOrigin(this);this._oTimesRow.attachEvent("focus",this._handleFocus,this);this._oTimesRow.attachEvent("select",this._handleCalendarSelect,this);this._oTimesRow._oPlanningCalendar=this;this._oTimesRow.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates();};}else if(this._oTimesRow.getItems()!==$1){this._oTimesRow.setItems($1);this._dateNav.setStep($1);}this._oTimesRow.addAriaLabelledBy(I.getStaticId("sap.m","PC_INTERVAL_TOOLBAR"));this._insertInterval(this._oTimesRow);T1.setAssociation("currentPicker",T1.getAggregation("_calendarPicker"));break;case b1.Day:case b1.Week:case b1.OneMonth:R1=j1[Z1];P1=this[R1.sInstanceName];if(!P1){P1=new R1.oClass(this.getId()+R1.sIdSuffix,{startDate:new Date(V1.getTime()),days:$1,showDayNamesLine:this.getShowDayNamesLine(),legend:this.getLegend(),showWeekNumbers:this.getShowWeekNumbers()});this._setAriaRole(P1);P1.attachEvent("select",this._handleCalendarSelect,this);P1.attachEvent("focus",this._handleFocus,this);if(j===Z.OneMonth){P1._setRowsStartDate=this._setRowsStartDate.bind(this);}P1._oPlanningCalendar=this;P1.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates();};}else if(P1.getDays()!==$1){P1.setDays($1);this._dateNav.setStep($1);}P1.addAriaLabelledBy(I.getStaticId("sap.m","PC_INTERVAL_TOOLBAR"));this._insertInterval(P1);this[R1.sInstanceName]=P1;if(Z1===b1.OneMonth){T1.setAssociation("currentPicker",T1.getAggregation("_monthPicker"));}else{T1.setAssociation("currentPicker",T1.getAggregation("_calendarPicker"));}break;case b1.Month:if(!this._oMonthsRow){this._oMonthsRow=new e(this.getId()+"-MonthsRow",{startDate:new Date(V1.getTime()),months:$1,legend:this.getLegend()});this._setAriaRole(this._oMonthsRow);this._oMonthsRow._setLegendControlOrigin(this);this._oMonthsRow.attachEvent("focus",this._handleFocus,this);this._oMonthsRow.attachEvent("select",this._handleCalendarSelect,this);this._oMonthsRow._oPlanningCalendar=this;this._oMonthsRow.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates();};}else if(this._oMonthsRow.setMonths()!==$1){this._oMonthsRow.setMonths($1);this._dateNav.setStep($1);}this._oMonthsRow.addAriaLabelledBy(I.getStaticId("sap.m","PC_INTERVAL_TOOLBAR"));this._insertInterval(this._oMonthsRow);T1.setAssociation("currentPicker",T1.getAggregation("_yearPicker"));break;default:throw new Error("Unknown IntervalType: "+Z1+"; "+this);}var _1=this.getRows();for(var i=0;i<_1.length;i++){var a2=_1[i];var b2=E1(a2);b2.setIntervalType(Z1);b2.setIntervals($1);b2.setShowSubIntervals(Y1.getShowSubIntervals());}if(this.getDomRef()){this._updateCurrentTimeVisualization(false);r1.call(this,this.getShowWeekNumbers(),this._viewAllowsWeekNumbers(j));s1.call(this,this.getShowDayNamesLine(),!!P1);}this._updatePickerSelection();}if(j===Z.Week||j===Z.OneMonth||j===Z.Month){Q1=this.getStartDate();this.setStartDate(new Date(Q1.getTime()));if(Q1.getTime()!==this.getStartDate().getTime()){this.fireStartDateChange();}}if(this._oOneMonthsRow&&j===Z.OneMonth){this._oOneMonthsRow.setMode(this._iSize);this._adjustSelectedDate(c.fromLocalJSDate(Q1));if(this._iSize<2){this._setRowsStartDate(Q1);}}else if(this._oOneMonthsRow&&S1===Z.OneMonth&&this._oOneMonthsRow.getSelectedDates().length){U1=this._oOneMonthsRow.getSelectedDates()[0].getStartDate();if(U1){this.setStartDate(U1);}}if(W1){T1.getAggregation("_calendarPicker").setMinDate(new Date(W1.getTime()));T1.getAggregation("_yearPicker").setMinDate(new Date(W1.getTime()));T1.getAggregation("_monthPicker").setMinDate(new Date(W1.getTime()));}if(X1){T1.getAggregation("_calendarPicker").setMaxDate(new Date(X1.getTime()));T1.getAggregation("_yearPicker").setMaxDate(new Date(X1.getTime()));T1.getAggregation("_monthPicker").setMaxDate(new Date(X1.getTime()));}this._updateTodayButtonState();return this;};h1.prototype._handleFocus=function(i){var j=i.getParameter("date");var P1=i.getParameter("restoreOldDate");if(P1){return;}this.shiftToDate(j,i.getParameter("otherMonth"));};h1.prototype.shiftToDate=function(i,j){var P1=this._getRowInstanceByViewKey(this.getViewKey()),Q1,R1;this._dateNav.toDate(i);Q1=this._dateNav.getStart();R1=this._dateNav.getCurrent();if(P1&&!(P1.getMode&&P1.getMode()<2&&!j)){this.setStartDate(Q1);P1.setStartDate(Q1);P1.setDate(R1);}};h1.prototype._updatePickerSelection=function(){var i=this._getFirstAndLastRangeDate(),j=this._getHeader().getAssociation("currentPicker"),P1=sap.ui.getCore().byId(j),Q1;Q1=new f({startDate:b._createLocalDate(i.oStartDate,true),endDate:b._createLocalDate(i.oEndDate,true)});P1.destroySelectedDates();P1.addSelectedDate(Q1);this._getHeader().setPickerText(this._formatPickerText());this._updateTodayButtonState();};h1.prototype._adjustSelectedDate=function(i,j){var P1=j?b._getFirstDateOfMonth(i):i,Q1=P1.toLocalJSDate();if(this._oOneMonthsRow.getMode&&this._oOneMonthsRow.getMode()<2){this._oOneMonthsRow.removeAllSelectedDates();this._oOneMonthsRow.addSelectedDate(new f({startDate:Q1}));this._oOneMonthsRow.selectDate(Q1);}};h1.prototype._insertInterval=function(i){if(this._iSizeScreen>1){this._oInfoToolbar.addContent(i);}else{this._oInfoToolbar.insertContent(i,1);}};h1.prototype._viewAllowsWeekNumbers=function(i){var j=this._getView(i).getIntervalType(),P1=j1[j];return!!P1&&!!P1.oClass.prototype.setShowWeekNumbers;};h1.prototype._viewAllowsDayNamesLine=function(i){var j=this._getView(i).getIntervalType(),P1=j1[j];return!!P1&&!!P1.oClass.prototype.setShowDayNamesLine;};h1.prototype._getRowInstanceByViewKey=function(i){var j=this._getView(i).getIntervalType(),P1=j1[j],Q1;if(P1){Q1=this[P1.sInstanceName];}if(j===b1.Month){Q1=this._oMonthsRow;}if(j===b1.Hour){Q1=this._oTimesRow;}return Q1;};h1.prototype.setShowWeekNumbers=function(i){this.setProperty("showWeekNumbers",i,true);this._getViews().forEach(function(j){var P1=j.getKey(),Q1=this._viewAllowsWeekNumbers(P1),R1=this._getRowInstanceByViewKey(P1);if(R1&&Q1){R1.setShowWeekNumbers(i);}if(this.getDomRef()&&this.getViewKey()===P1){r1.call(this,i,Q1);}},this);return this;};h1.prototype.setShowIntervalHeaders=function(j){this.setProperty("showIntervalHeaders",j,true);var P1=this.getRows();for(var i=0;i<P1.length;i++){var Q1=P1[i];E1(Q1).setShowIntervalHeaders(j);}return this;};h1.prototype.setShowEmptyIntervalHeaders=function(j){this.setProperty("showEmptyIntervalHeaders",j,true);var P1=this.getRows();for(var i=0;i<P1.length;i++){var Q1=P1[i];E1(Q1).setShowEmptyIntervalHeaders(j);}return this;};h1.prototype.setGroupAppointmentsMode=function(j){this.setProperty("groupAppointmentsMode",j,true);var P1=this.getRows();for(var i=0;i<P1.length;i++){var Q1=P1[i];E1(Q1).setGroupAppointmentsMode(j);}return this;};h1.prototype.setAppointmentsReducedHeight=function(j){this.setProperty("appointmentsReducedHeight",j,true);var P1=this.getRows();for(var i=0;i<P1.length;i++){var Q1=P1[i];E1(Q1).setAppointmentsReducedHeight(j);}return this;};h1.prototype.setAppointmentsVisualization=function(j){this.setProperty("appointmentsVisualization",j,true);var P1=this.getRows();for(var i=0;i<P1.length;i++){var Q1=P1[i];E1(Q1).setAppointmentsVisualization(j);}return this;};h1.prototype.setShowRowHeaders=function(i){this.setProperty("showRowHeaders",i,true);var j=this.getAggregation("table");j.getColumns()[0].setVisible(i);this._toggleAppointmentsColumnPopinState(i);this.$().toggleClass("sapMPlanCalNoHead",!i);M1.call(this);N1.call(this);return this;};h1.prototype.setShowDayNamesLine=function(i){var j,P1,Q1,R1=!!this.getDomRef(),S1=this.getViewKey();for(j in j1){P1=j1[j].sInstanceName;if(this[P1]){Q1=this[P1];Q1.setShowDayNamesLine(i);if(R1&&j===S1){s1.call(this,i,true);}}}return this.setProperty("showDayNamesLine",i,false);};h1.prototype.setStickyHeader=function(i){if(this.getStickyHeader()===i){return this;}this.setProperty("stickyHeader",i,true);if(l.system.phone){if(i){l.orientation.attachHandler(this._updateStickyHeader,this);}else{l.orientation.detachHandler(this._updateStickyHeader,this);}}this._updateStickyHeader();return this;};h1.prototype._updateStickyHeader=function(){var i=[],j=this.getStickyHeader(),P1=this.getViewKey()===Z.OneMonth&&this._iSize<2,Q1=j&&!l.system.phone&&!P1,R1=j&&!(l.system.phone&&l.orientation.landscape)&&!P1;if(Q1){i.push(V.HeaderToolbar);}if(this._oInfoToolbar&&R1){i.push(V.InfoToolbar);}this.getAggregation("table").setSticky(i);};h1.prototype.addRow=function(i){this.addAggregation("rows",i,true);this.getAggregation("table").addItem(this._createPlanningCalendarListItem(i));return this;};h1.prototype.insertRow=function(i,j){this.insertAggregation("rows",i,j);this.getAggregation("table").insertItem(this._createPlanningCalendarListItem(i),j,true);return this;};h1.prototype.removeRow=function(i){var j=this.removeAggregation("rows",i,true),P1=this.getAggregation("table");P1.removeItem(C1(j),true);this._handleRowRemoval(j);L1.call(this);N1.call(this);return j;};h1.prototype.removeAllRows=function(){var i=this.removeAllAggregation("rows",true),j=this.getAggregation("table");j.removeAllItems(true);i.forEach(this._handleRowRemoval,this);L1.call(this);N1.call(this);return i;};h1.prototype.destroyRows=function(){var i;var j=this.getAggregation("table");j.destroyItems(true);i=this.destroyAggregation("rows");L1.call(this);N1.call(this);return i;};h1.prototype.setSingleSelection=function(i){this.setProperty("singleSelection",i,true);M1.call(this);N1.call(this);if(i){this.selectAllRows(false);}else{L1.call(this);}this.$().toggleClass("sapMPlanCalMultiSel",!i);return this;};h1.prototype.setNoDataText=function(i){this.setProperty("noDataText",i,true);var j=this.getAggregation("table");j.setNoDataText(i);return this;};h1.prototype.setLegend=function(j){this.setAssociation("legend",j,true);var P1=this.getRows(),Q1=this.getLegend()&&sap.ui.getCore().byId(this.getLegend()),R1;for(var i=0;i<P1.length;i++){var S1=P1[i];E1(S1).setLegend(j);}i1.forEach(function(T1){if(this[T1]){this[T1].setLegend(j);}},this);if(Q1){R1=new a(function(T1){this.invalidate();}.bind(this));R1.observe(Q1,{destroy:true});}return this;};h1.prototype.addAriaLabelledBy=function(i){this.addAssociation("ariaLabelledBy",i,true);var j=this.getAggregation("table");j.addAriaLabelledBy(i);return this;};h1.prototype.removeAriaLabelledBy=function(i){this.removeAssociation("ariaLabelledBy",i,true);var j=this.getAggregation("table");j.removeAriaLabelledBy(i);return this;};h1.prototype.removeAllAriaLabelledBy=function(){this.removeAllAssociation("ariaLabelledBy",true);var i=this.getAggregation("table");i.removeAllAriaLabelledBy();i.addAriaLabelledBy(this.getId()+"-Descr");return this;};h1.prototype.invalidate=function(i){var j=i&&i instanceof f;if(!this._bIsBeingDestroyed&&(this._bDateRangeChanged||j)){if(this.getDomRef()){var P1=this.getViewKey();var Q1=this._getView(P1);var R1=Q1.getIntervalType();switch(R1){case b1.Hour:if(this._oTimesRow){this._oTimesRow.invalidate(arguments);}break;case b1.Day:if(this._oDatesRow){this._oDatesRow.invalidate(arguments);}break;case b1.Month:if(this._oMonthsRow){this._oMonthsRow.invalidate(arguments);}break;case b1.OneMonth:if(this._oOneMonthsRow){this._oOneMonthsRow.invalidate(arguments);}break;case b1.Week:if(this._oWeeksRow){this._oWeeksRow.invalidate(arguments);}break;default:throw new Error("Unknown IntervalType: "+R1+"; "+this);}}this._bDateRangeChanged=undefined;}else{if(i&&i instanceof sap.m.PlanningCalendarView){this._bCheckView=true;}C.prototype.invalidate.apply(this,arguments);}};h1.prototype.addSpecialDate=function(i){this._bDateRangeChanged=true;return C.prototype.addAggregation.call(this,"specialDates",i);};h1.prototype.insertSpecialDate=function(i,j){this._bDateRangeChanged=true;return C.prototype.insertAggregation.call(this,"specialDates",i,j);};h1.prototype.removeSpecialDate=function(i){this._bDateRangeChanged=true;return C.prototype.removeAggregation.call(this,"specialDates",i);};h1.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;return this.removeAllAggregation("specialDates");};h1.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;return this.destroyAggregation("specialDates");};h1.prototype.removeAllViews=function(){this._bCheckView=true;var i=this.removeAllAggregation("views"),j=this.getBuiltInViews();if(j.length){this.setViewKey(j[0]);}else{this.setViewKey(l1[0]);}return i;};h1.prototype.destroyViews=function(){this._bCheckView=true;var i=this.destroyAggregation("views"),j=this.getBuiltInViews();if(j.length){this.setViewKey(j[0]);}else{this.setViewKey(l1[0]);}return i;};h1.prototype.getSelectedRows=function(){return this.getRows().filter(function(i){return i.getSelected();});};h1.prototype.selectAllRows=function(j){var P1=this.getRows();if(!(j&&this.getSingleSelection())){for(var i=0;i<P1.length;i++){var Q1=P1[i];Q1.setSelected(j);}if(this._oSelectAllCheckBox){this._oSelectAllCheckBox.setSelected(j);}}return this;};h1.prototype.onsaphomemodifiers=function(i){if((i.metaKey||i.ctrlKey)&&!i.altKey&&!i.shiftKey){var j=this.getRows();var P1=j[0];var Q1=new U.Event("saphome");Q1._bPlanningCalendar=true;E1(P1).onsaphome(Q1);i.preventDefault();i.stopPropagation();}};h1.prototype.onsapendmodifiers=function(i){if((i.metaKey||i.ctrlKey)&&!i.altKey&&!i.shiftKey){var j=this.getRows();var P1=j[j.length-1];var Q1=new U.Event("sapend");Q1._bPlanningCalendar=true;E1(P1).onsapend(Q1);i.preventDefault();i.stopPropagation();}};h1.prototype.setBuiltInViews=function(i){this.setProperty("builtInViews",i);this.setViewKey(this._getViews()[0].getKey());return this;};h1.prototype.removeView=function(i){var j=this.removeAggregation("views",i);if(!this.getViews().length){this.setViewKey(this._getViews()[0].getKey());}return j;};h1.prototype._getIntervals=function(i){var j=0;switch(this._iSize){case 0:j=i.getIntervalsS();break;case 1:j=i.getIntervalsM();break;default:j=i.getIntervalsL();break;}return j;};h1.prototype._getView=function(j,P1){var Q1=this._getViews();var R1;for(var i=0;i<Q1.length;i++){R1=Q1[i];if(R1.getKey()!=j){R1=undefined;}else{break;}}if(!R1&&!P1){throw new Error("PlanningCalendarView with key "+j+" not assigned "+this);}return R1;};h1.prototype._changeStartDate=function(i){if(this._bNoStartDateChange){return;}this.setStartDate(new Date(i.getTime()));this._updatePickerSelection();this.fireStartDateChange();};h1.prototype._updateCurrentTimeVisualization=function(j){if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}if(j){var P1=this.getRows();for(var i=0;i<P1.length;i++){var Q1=P1[i];E1(Q1).updateCurrentTimeVisualization();}}var R1=new Date();var S1=this.getStartDate();var T1=this.getViewKey();var U1=this._getView(T1);var V1=U1.getIntervalType();var W1=this._getIntervals(U1);var X1=0;var Y1=0;var Z1=0;switch(V1){case b1.Hour:X1=60000;Y1=S1.getTime()-3600000;Z1=S1.getTime()+W1*3600000;break;case b1.Day:case b1.Week:case b1.OneMonth:X1=1800000;Y1=S1.getTime()-3600000;Z1=S1.getTime()+W1*86400000;break;default:X1=-1;break;}if(R1.getTime()<=Z1&&R1.getTime()>=Y1&&X1>0){this._sUpdateCurrentTime=setTimeout(this['_updateCurrentTimeVisualization'].bind(this,true),X1);}};function p1(i){this.setViewKey(i.getParameter("item").getKey());this.fireViewChange();}h1.prototype._handleTodayPress=function(i){var j=new Date(),P1,Q1=this.getViewKey();if(Q1===Z.OneMonth){P1=b.getFirstDateOfMonth(b._createUniversalUTCDate(j,undefined,true));this._adjustSelectedDate(c.fromLocalJSDate(j),false);j=b._createLocalDate(P1,true);}if(Q1===Z.Week){P1=this.getStartDate();j.setHours(P1.getHours());j.setMinutes(P1.getMinutes());j.setSeconds(P1.getSeconds());}this.setStartDate(j);this._dateNav.setCurrent(j);this._updatePickerSelection();this.fireStartDateChange();};h1.prototype._handleStartDateChange=function(i){var j=i.oSource.getStartDate();if(this._getView(this.getViewKey()).getIntervalType()!==b1.Hour){var P1=this.getStartDate();j.setHours(P1.getHours());j.setMinutes(P1.getMinutes());j.setSeconds(P1.getSeconds());}this._changeStartDate(j);};h1.prototype._handleDateSelect=function(i){var j=i.oSource.getStartDate();if(this._getView(this.getViewKey()).getIntervalType()===b1.Hour){var P1=this.getStartDate();j.setHours(P1.getHours());j.setMinutes(P1.getMinutes());j.setSeconds(P1.getSeconds());}this._changeStartDate(j);this._dateNav.setCurrent(j);var Q1=this.getViewKey(),R1=this._getView(Q1),S1=R1.getIntervalType(),T1;if(S1==="Hour"){S1="Time";}else if(S1==="Day"){S1="Date";}else if(S1==="One Month"){S1="OneMonth";}T1="_o"+S1+"sRow";if(this[T1]){this[T1].setDate(j);}};h1.prototype._handleCalendarSelect=function(i){var j=i.getSource().getSelectedDates();if(!j.length){return;}var P1=new Date(j[0].getStartDate());var Q1=b._createUniversalUTCDate(P1,undefined,true);var R1=this.getViewKey();var S1=this._getView(R1);var T1=S1.getIntervalType();if(T1!==b1.OneMonth||this._iSize>1){j[0].setStartDate();}switch(T1){case b1.Hour:Q1.setUTCHours(Q1.getUTCHours()+1);break;case b1.Day:case b1.Week:Q1.setUTCDate(Q1.getUTCDate()+1);break;case b1.OneMonth:if(this._iSize<2){var U1=new Date(P1.getTime());if(b.monthsDiffer(this.getStartDate(),P1)){this.setStartDate(P1);this._getHeader().setPickerText(this._formatPickerText());}this._setRowsStartDate(U1);this._oOneMonthsRow._focusDate(c.fromLocalJSDate(U1),true);}else if(b._isNextMonth(P1,this.getStartDate())){this.shiftToDate(P1);return;}Q1.setUTCDate(Q1.getUTCDate()+1);break;case b1.Month:Q1.setUTCMonth(Q1.getUTCMonth()+1);break;default:throw new Error("Unknown IntervalType: "+T1+"; "+this);}Q1.setUTCMilliseconds(Q1.getUTCMilliseconds()-1);Q1=b._createLocalDate(Q1,true);this._formatPickerText();this.fireIntervalSelect({startDate:P1,endDate:Q1,subInterval:false,row:undefined});};function q1(i){var j=i.getParameter("startDate");var P1=this.getViewKey();var Q1=this._getView(P1);var R1=Q1.getIntervalType();if(R1===b1.OneMonth&&b._isNextMonth(j,this.getStartDate())){this.shiftToDate(j);return;}var S1=i.getParameter("endDate");var T1=i.getParameter("subInterval");var U1=B1(i.oSource.getParent());this._formatPickerText();this.fireIntervalSelect({startDate:j,endDate:S1,subInterval:T1,row:U1});}h1.prototype._applyContextualSettings=function(i){return C.prototype._applyContextualSettings.call(this,i||M._defaultContextualSettings);};function r1(i,j){this.$().toggleClass("sapMPlanCalWithWeekNumbers",i&&j);}function s1(i,j){this.$().toggleClass("sapMPlanCalWithDayNamesLine",i&&j);}function t1(j,P1){if(j.size.width<=0){return;}if(Math.abs(this.iWidth-j.size.width)<15){return;}this.iWidth=j.size.width;this._applyContextualSettings({contextualWidth:this.iWidth});var Q1=this.getRows();var R1;var i=0;var S1=this._iSize;G1.call(this,j.size.width);if(S1!=this._iSize){H1.call(this,this._iSize);var T1=this.getViewKey();var U1=this._getView(T1);var V1=U1.getIntervalType();var W1=this._getIntervals(U1);for(i=0;i<Q1.length;i++){R1=Q1[i];var X1=E1(R1);if(W1!=X1.getIntervals()){X1.setIntervals(W1);}else{X1.handleResize();}}switch(V1){case b1.Hour:if(this._oTimesRow&&this._oTimesRow.getItems()!=W1){this._oTimesRow.setItems(W1);this._dateNav.setStep(W1);}break;case b1.Day:if(this._oDatesRow&&this._oDatesRow.getDays()!=W1){this._oDatesRow.setDays(W1);this._dateNav.setStep(W1);}break;case b1.Month:if(this._oMonthsRow&&this._oMonthsRow.getMonths()!=W1){this._oMonthsRow.setMonths(W1);this._dateNav.setStep(W1);}break;case b1.Week:if(this._oWeeksRow&&this._oWeeksRow.getDays()!=W1){this._oWeeksRow.setDays(W1);this._dateNav.setStep(W1);}break;case b1.OneMonth:if(this._oOneMonthsRow&&this._oOneMonthsRow.getDays()!=W1){this._oOneMonthsRow.setDays(W1);this._dateNav.setStep(W1);if(this._iSize>1){this._setRowsStartDate(new Date(this.getStartDate().getTime()));}}break;default:throw new Error("Unknown IntervalType: "+V1+"; "+this);}M1.call(this);}else if(!P1){for(i=0;i<Q1.length;i++){R1=Q1[i];E1(R1).handleResize();}}if(this._oOneMonthsRow){this._oOneMonthsRow.setMode(this._iSize);this._adjustSelectedDate(c.fromLocalJSDate(this.getStartDate()));}if(this.getStickyHeader()){this._updateStickyHeader();}}function u1(P1){var Q1=P1.getParameter("appointment"),R1=P1.getParameter("multiSelect"),S1=P1.getParameter("appointments"),T1=P1.getParameter("domRefId"),U1,V1,W1,X1,Y1,i,j;if(!R1){V1=this.getRows();for(i=0;i<V1.length;i++){W1=V1[i];if(P1.oSource!=E1(W1)){X1=W1.getAppointments();for(j=0;j<X1.length;j++){Y1=X1[j];Y1.setSelected(false);}}}}U1={appointment:Q1,appointments:S1,multiSelect:R1,domRefId:T1};this.fireAppointmentSelect(U1);}h1.prototype._setRowsStartDate=function(j){var P1=this.getRows(),Q1,i;for(i=0;i<P1.length;i++){Q1=P1[i];E1(Q1).setStartDate(j);}};h1.prototype._toggleAppointmentsColumnPopinState=function(i){var j=this.getAggregation("table"),P1=j.getColumns()[1];P1.setDemandPopin(i);P1.setMinScreenWidth(i?k1:"");};h1.prototype._getViews=function(){var i=this.getViews(),j=this.getBuiltInViews(),P1,Q1=[],R1=Z,S1=b1;if(!this._oViews){this._oViews={};}if(j.length){Q1=j;}else{Q1=i.length?[]:l1;}P1=Q1.map(function(U1){switch(U1){case R1.Hour:return this._oViews[R1.Hour]||(this._oViews[R1.Hour]=new J(this.getId()+"-HourView",{key:R1.Hour,intervalType:S1.Hour,description:this._oRB&&this._oRB.getText("PLANNINGCALENDAR_HOURS"),intervalsS:6,intervalsM:6,intervalsL:12}));case R1.Day:return this._oViews[R1.Day]||(this._oViews[R1.Day]=new J(this.getId()+"-DayView",{key:R1.Day,intervalType:S1.Day,description:this._oRB&&this._oRB.getText("PLANNINGCALENDAR_DAYS"),intervalsS:7,intervalsM:7,intervalsL:14}));case R1.Month:return this._oViews[R1.Month]||(this._oViews[R1.Month]=new J(this.getId()+"-MonthView",{key:R1.Month,intervalType:S1.Month,description:this._oRB&&this._oRB.getText("PLANNINGCALENDAR_MONTHS"),intervalsS:3,intervalsM:6,intervalsL:12}));case R1.Week:return this._oViews[R1.Week]||(this._oViews[R1.Week]=new J(this.getId()+"-WeekView",{key:R1.Week,intervalType:S1.Week,description:this._oRB&&this._oRB.getText("PLANNINGCALENDAR_WEEK"),intervalsS:7,intervalsM:7,intervalsL:7}));case R1.OneMonth:return this._oViews[R1.OneMonth]||(this._oViews[R1.OneMonth]=new J(this.getId()+"-OneMonthView",{key:R1.OneMonth,intervalType:S1.OneMonth,description:this._oRB&&this._oRB.getText("PLANNINGCALENDAR_ONE_MONTH"),intervalsS:1,intervalsM:1,intervalsL:31}));default:Q.error("Cannot get PlanningCalendar views. Invalid view key "+U1);break;}},this);for(var T1 in this._oViews){if(Q1.indexOf(T1)<0){this._oViews[T1].destroy();delete this._oViews[T1];}}if(i.length){P1=P1.concat(i);}return P1;};h1.prototype.getSelectedAppointments=function(){var i=[];this.getRows().filter(function(j){i.push.apply(i,E1(j).aSelectedAppointments);});return i;};h1.prototype.setCustomAppointmentsSorterCallback=function(i){if(typeof i==="function"||i===null||i===undefined){this.getRows().forEach(function(j){E1(j)._setCustomAppointmentsSorterCallback(i);});this._fnCustomSortedAppointments=i;}else{Q.warning("Your custom sort function won't be used, but the old one will be preserved.",this);}return this;};h1.prototype.getCustomAppointmentsSorterCallback=function(){return this._fnCustomSortedAppointments;};h1.prototype._onRowDeselectAppointment=function(){var P1=this.getRows();for(var i=0;i<P1.length;i++){var Q1=E1(P1[i]).aSelectedAppointments;for(var j=0;j<Q1.length;j++){var R1=sap.ui.getCore().byId(Q1[j]);if(R1){R1.setProperty("selected",false,true);R1.$().removeClass("sapUiCalendarAppSel");}}E1(P1[i]).aSelectedAppointments=[];}};h1.prototype._updateRowTimeline=function(i){var j=E1(i),P1,Q1,R1,S1,T1=this.getViewKey()===Z.OneMonth&&this._iSize<2,U1=this.getStartDate();j.setNonWorkingDays(i.getNonWorkingDays());j.setNonWorkingHours(i.getNonWorkingHours());if(T1&&this._oOneMonthsRow&&this._oOneMonthsRow.getSelectedDates().length){U1=this._oOneMonthsRow.getSelectedDates()[0].getStartDate();}j.setStartDate(U1);j.setShowIntervalHeaders(this.getShowIntervalHeaders());j.setShowEmptyIntervalHeaders(this.getShowEmptyIntervalHeaders());j.setGroupAppointmentsMode(this.getGroupAppointmentsMode());j.setAppointmentsReducedHeight(this.getAppointmentsReducedHeight());j.setLegend(this.getLegend());j.setAppointmentsVisualization(this.getAppointmentsVisualization());j.setProperty("appointmentHeight",this.getProperty("appointmentHeight"));j.attachEvent("select",u1,this);j.attachEvent("startDateChange",this._handleStartDateChange,this);j.attachEvent("leaveRow",K1,this);j.attachEvent("intervalSelect",q1,this);L1.call(this);if(O1.call(this)){P1=this.getViewKey();Q1=this._getView(P1);R1=Q1.getIntervalType();S1=this._getIntervals(Q1);j.setIntervalType(R1);j.setIntervals(S1);j.setShowSubIntervals(Q1.getShowSubIntervals());}N1.call(this);if(this._fnCustomSortedAppointments){j._setCustomAppointmentsSorterCallback(this._fnCustomSortedAppointments);}};h1.prototype._observeRowChanges=function(i){var j=C1(i),P1=D1(i),Q1=E1(i);var R1={destroy:function(){j.destroy();},change:{title:function(S1){P1.setProperty(S1.name,S1.current);},icon:function(S1){P1.setProperty(S1.name,S1.current);},text:function(S1){Q1.toggleStyleClass("sapMPlanCalRowLarge",!!S1.current);P1.setProperty("description",S1.current);},enableAppointmentsDragAndDrop:function(S1){this._enableAppointmentsDragAndDrop(i);}.bind(this),enableAppointmentsResize:function(S1){this._enableAppointmentsResize(i);}.bind(this),enableAppointmentsCreate:function(S1){this._enableAppointmentsCreate(i);}.bind(this),nonWorkingDays:function(S1){Q1.setProperty(S1.name,S1.current);},nonWorkingHours:function(S1){Q1.setProperty(S1.name,S1.current);},selected:function(S1){L1.call(this);j.setProperty(S1.name,S1.current);}.bind(this),tooltip:function(S1){if(S1.mutation==="insert"){P1.setTooltip(S1.child);}else if(S1.mutation==="remove"){P1.setTooltip();}},intervalHeaders:function(S1){Q1.invalidate();},appointments:function(S1){Q1.invalidate();}}};new a(function(S1){if(S1.type==="destroy"){R1.destroy();}else if(R1.change[S1.name]){R1.change[S1.name](S1);}}).observe(i,{properties:["icon","text","title","nonWorkingDays","nonWorkingHours","selected","enableAppointmentsDragAndDrop","enableAppointmentsResize","enableAppointmentsCreate"],aggregations:["tooltip","appointments","intervalHeaders","headerContent"],destroy:true});i.invalidate=function(S1){if(!S1||!(S1 instanceof g)){E.prototype.invalidate.apply(this,arguments);}else if(j){Q1.invalidate(S1);}};i.applyFocusInfo=function(S1){Q1.applyFocusInfo(S1);return this;};};h1.prototype._createPlanningCalendarListItem=function(i){var j,P1,Q1;if(i.getHeaderContent().length||i.getBindingInfo("headerContent")){P1=i._getPlanningCalendarCustomRowHeader();}else{P1=new v1(i.getId()+"-Head",{icon:i.getIcon(),description:i.getText(),title:i.getTitle(),tooltip:i.getTooltip(),iconDensityAware:false});}Q1=new x1(i.getId()+"-CalRow",{checkResize:false,updateCurrentTime:false,ariaLabelledBy:P1.getId()});Q1.getAppointments=function(){return i.getAppointments();};Q1.getIntervalHeaders=function(){return i.getIntervalHeaders();};j=new z1(i.getId()+g1,{cells:[P1,Q1]});this._updateRowTimeline(i);this._observeRowChanges(i);this._enableAppointmentsDragAndDrop(i);this._enableAppointmentsResize(i);this._enableAppointmentsCreate(i);return j;};h1.prototype._handleRowRemoval=function(i){var j=E1(i);j.detachEvent("select",u1,this);j.detachEvent("startDateChange",this._handleStartDateChange,this);j.detachEvent("leaveRow",K1,this);j.detachEvent("intervalSelect",q1,this);if(this._fnCustomSortedAppointments){j._fnCustomSortedAppointments=undefined;}C1(i).destroy();};var v1=A.extend("PlanningCalendarRowHeader",{renderer:R.extend(F),TagName:"div"});v1.prototype.isSelectable=function(){return false;};PlanningCalendarRowHeaderRenderer.renderTabIndex=function(i,j){};PlanningCalendarRowHeaderRenderer.getAriaRole=function(i,j){};var w1=R.extend(k);w1.getLegendItems=function(i){var j=[],P1,Q1=i.getLegend();if(Q1){P1=sap.ui.getCore().byId(Q1);if(P1){j=P1.getAppointmentItems?P1.getAppointmentItems():P1.getItems();}else{Q.error("PlanningCalendarLegend with id '"+Q1+"' does not exist!",i);}}return j;};w1.renderBeforeAppointments=function(j,P1){var Q1=B1(P1.getParent()),R1;if(!Q1.getEnableAppointmentsDragAndDrop()&&!Q1.getEnableAppointmentsResize()&&!Q1.getEnableAppointmentsCreate()||P1._isOneMonthsRowOnSmallSizes()){return;}R1=P1.getAggregation("_intervalPlaceholders");j.write("<div class=\"sapUiCalendarRowAppsOverlay\">");if(R1){for(var i=0;i<R1.length;i++){var S1=R1[i];S1.setWidth(100/R1.length+"%");j.renderControl(S1);}}j.write("</div>");};w1.renderResizeHandle=function(i,j,P1){if(!B1(j.getParent()).getEnableAppointmentsResize()||j._isOneMonthsRowOnSmallSizes()||(P1._aAppointments&&P1._aAppointments.length>0)){return;}i.write("<span");i.addClass("sapUiCalendarAppResizeHandle");i.writeClasses();i.write(">");i.write("</span>");};w1.writeCustomAttributes=function(i,j){if(B1(j.getParent()).getEnableAppointmentsCreate()){i.writeAttribute("draggable","true");}};w1.renderInterval=function(j,P1,Q1,R1,S1,T1,U1,V1,W1,X1,Y1,Z1,$1){var _1=P1.getIntervalType();if(_1===b1.Day||_1===b1.Week||_1===b1.OneMonth){var a2=B1(P1.getParent()),b2=a2.getParent(),c2=function(m2){return m2.getType()===W.NonWorking;},d2=a2.getSpecialDates().filter(c2),e2=b2.getSpecialDates().filter(c2),f2=P1.getStartDate(),g2,h2,i2,j2;if(e2&&d2){g2=e2.concat(d2);}else if(d2){g2=d2;}if(g2&&g2.length){var k2=function(m2){return m2===h2.getDay();};h2=new Date(f2.getTime());h2.setHours(0,0,0);h2.setDate(f2.getDate()+Q1);for(var i=0;i<g2.length;i++){if(g2[i].getStartDate()){i2=new Date(g2[i].getStartDate().getTime());}if(g2[i].getEndDate()){j2=new Date(g2[i].getEndDate().getTime());}else{j2=new Date(g2[i].getStartDate().getTime());j2.setHours(23,59,59);}if(h2.getTime()>=i2.getTime()&&h2.getTime()<=j2.getTime()){var l2=T1.some(k2);if(!l2){j.addClass("sapUiCalendarRowAppsNoWork");}}}}}k.renderInterval(j,P1,Q1,R1,S1,T1,U1,V1,W1,X1,Y1,Z1,$1);};var x1=h.extend("PlanningCalendarRowTimeline",{metadata:{aggregations:{intervalHeaders:{type:"sap.ui.unified.CalendarAppointment",multiple:true},_intervalPlaceholders:{type:"IntervalPlaceholder",multiple:true,visibility:"hidden",dnd:{droppable:true}}},dnd:true},renderer:w1});x1.prototype._updatePlaceholders=function(){var j=this.getProperty("intervals");if(this.getIntervalType()===b1.Hour){j*=2;}this.removeAllAggregation("_intervalPlaceholders");for(var i=0;i<j;i++){this.addAggregation("_intervalPlaceholders",new y1());}};x1.prototype.onBeforeRendering=function(){h.prototype.onBeforeRendering.call(this);this._updatePlaceholders();};x1.prototype.onmousedown=function(i){var j=i.target.classList;this._isResizeHandleMouseDownTarget=j.contains("sapUiCalendarAppResizeHandle");this._isRowAppsIntervalMouseDownTarget=j.contains("sapUiCalendarRowAppsInt");};x1.prototype._isResizingPerformed=function(){return this._isResizeHandleMouseDownTarget;};x1.prototype._isDraggingPerformed=function(){return!this._isResizeHandleMouseDownTarget&&!this._isRowAppsIntervalMouseDownTarget;};x1.prototype._isCreatingPerformed=function(){return this._isRowAppsIntervalMouseDownTarget;};var y1=C.extend("IntervalPlaceholder",{metadata:{properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null}}},renderer:function(i,j){i.write("<div");i.writeControlData(j);i.addStyle("width",j.getWidth());i.writeStyles();i.addClass("sapUiCalendarRowAppsPlaceholder");i.writeClasses();i.write("></div>");}});var z1=x.extend("sap.m.internal.PlanningCalendarRowListItem",{metadata:{library:"sap.m"},renderer:y});z1.prototype.getHeader=function(){return this.getCells()[0];};z1.prototype.getTimeline=function(){return this.getCells()[1];};z1.prototype.getCustomData=function(){return B1(this).getCustomData();};h1.prototype._getSelectedDates=function(){var i=this.getViewKey(),j=this._getView(i),P1=j.getIntervalType(),Q1=j1[P1];return this[Q1.sInstanceName].getSelectedDates();};h1.prototype._enableAppointmentsDragAndDrop=function(i){var j=E1(i),P1;if(i.getEnableAppointmentsDragAndDrop()){P1=i.getDragDropConfig().some(function(Q1){return Q1.getGroupName()===d1;});if(!P1){this._addDragDropInfo(i,E1(i));}}else{i.getDragDropConfig().forEach(function(Q1){if(Q1.getGroupName()===d1){i.removeDragDropConfig(Q1);}});j.getDragDropConfig().forEach(function(Q1){if(Q1.getGroupName()===d1){j.removeDragDropConfig(Q1);}});}};h1.prototype._enableAppointmentsResize=function(i){var j=i.getEnableAppointmentsResize(),P1=this._getConfigFromDragDropConfigAggregation(i.getAggregation("dragDropConfig"),e1),Q1=this._getResizeConfig(i);if(j&&!P1){i.addAggregation("dragDropConfig",Q1,true);}if(!j){i.removeAggregation("dragDropConfig",P1,true);}};h1.prototype._enableAppointmentsCreate=function(i){var j=i.getEnableAppointmentsCreate(),P1=E1(i),Q1=this._getConfigFromDragDropConfigAggregation(P1.getAggregation("dragDropConfig"),f1),R1=this._getAppointmentsCreateConfig(i);if(j&&!Q1){P1.addAggregation("dragDropConfig",R1,true);}if(!j){P1.removeAggregation("dragDropConfig",Q1,true);}};h1.prototype._addDragDropInfo=function(i,j){i.addDragDropConfig(new o({groupName:d1,sourceAggregation:"appointments",dragStart:function(P1){var Q1=function(){var R1=U(".sapUiCalendarRowAppsOverlay");setTimeout(function(){R1.addClass("sapUiCalendarRowAppsOverlayDragging");},0);U(document).one("dragend",function(){R1.removeClass("sapUiCalendarRowAppsOverlayDragging");});};if(j._isOneMonthsRowOnSmallSizes()||!j._isDraggingPerformed()){P1.preventDefault();return;}Q1();}}));j.addDragDropConfig(new p({groupName:d1,targetAggregation:"_intervalPlaceholders",dragEnter:function(P1){var Q1=P1.getParameter("dragSession"),R1=Q1.getDragControl(),S1=j.getIntervalType(),T1=j.getStartDate(),U1=j.indexOfAggregation("_intervalPlaceholders",Q1.getDropControl()),V1=j.getId(),W1,X1=function(){var Z1=U(Q1.getIndicator()),$1=Q1.getDropControl().getDomRef().getBoundingClientRect(),_1=sap.ui.getCore().byId(V1).getDomRef().getBoundingClientRect(),a2=Q1.getDragControl().$().outerWidth(),b2=sap.ui.getCore().getConfiguration().getRTL(),c2=b2?Math.ceil($1.right)-_1.left:_1.right-Math.ceil($1.left);Z1.css("min-width",(a2<c2)?a2:c2).css(b2?"border-left-width":"border-right-width",(a2>c2)?"0":"").css("margin-left",b2?-(Z1.outerWidth()-parseFloat(Z1.context.style.width)):"");};if(i.hasListeners("appointmentDragEnter")){if(S1===b1.Hour){W1=this._calcNewHoursAppPos(T1,R1.getStartDate(),R1.getEndDate(),U1);}else if(S1===b1.Day||S1===b1.Week||(S1===b1.OneMonth&&!j._isOneMonthsRowOnSmallSizes())){W1=this._calcNewDaysAppPos(T1,R1.getStartDate(),R1.getEndDate(),U1);}else if(S1===b1.Month){W1=this._calcNewMonthsAppPos(T1,R1.getStartDate(),R1.getEndDate(),U1);}var Y1=i.fireAppointmentDragEnter({appointment:R1,startDate:W1.startDate,endDate:W1.endDate,calendarRow:B1(j.getParent())});if(!Y1){P1.preventDefault();return;}}else if(E1(R1.getParent())!==j){P1.preventDefault();return;}if(j.getIntervalType()!==b1.Hour){return;}if(!Q1.getIndicator()){setTimeout(X1,0);}else{X1();}}.bind(this),drop:function(P1){var Q1=P1.getParameter("dragSession"),R1=Q1.getDragControl(),S1=j.getIntervalType(),T1=j.getStartDate(),U1=j.indexOfAggregation("_intervalPlaceholders",Q1.getDropControl()),V1,W1=P1.getParameter("browserEvent"),X1=(W1.metaKey||W1.ctrlKey);if(S1===b1.Hour){V1=this._calcNewHoursAppPos(T1,R1.getStartDate(),R1.getEndDate(),U1);}else if(S1===b1.Day||S1===b1.Week||(S1===b1.OneMonth&&!j._isOneMonthsRowOnSmallSizes())){V1=this._calcNewDaysAppPos(T1,R1.getStartDate(),R1.getEndDate(),U1);}else if(S1===b1.Month){V1=this._calcNewMonthsAppPos(T1,R1.getStartDate(),R1.getEndDate(),U1);}j.$().find(".sapUiCalendarRowAppsOverlay").removeClass("sapUiCalendarRowAppsOverlayDragging");if(R1.getStartDate().getTime()===V1.startDate.getTime()&&R1.getParent()===B1(j.getParent())){return;}i.fireAppointmentDrop({appointment:R1,startDate:V1.startDate,endDate:V1.endDate,calendarRow:B1(j.getParent()),copy:X1});}.bind(this)}));};h1.prototype._calcNewHoursAppPos=function(i,j,P1,Q1){var R1=new Date(i.getFullYear(),i.getMonth(),i.getDate(),i.getHours());R1=new Date(R1.getTime()+(Q1*30*60*1000));return{startDate:R1,endDate:new Date(R1.getTime()+P1.getTime()-j.getTime())};};h1.prototype._calcNewDaysAppPos=function(i,j,P1,Q1){var R1=new Date(i);R1.setDate(R1.getDate()+Q1);R1=new Date(R1.getFullYear(),R1.getMonth(),R1.getDate(),j.getHours(),j.getMinutes(),j.getSeconds());return{startDate:R1,endDate:new Date(R1.getTime()+P1.getTime()-j.getTime())};};h1.prototype._calcNewMonthsAppPos=function(i,j,P1,Q1){var R1=new Date(i);R1.setMonth(R1.getMonth()+Q1);R1=new Date(R1.getFullYear(),R1.getMonth(),j.getDate(),j.getHours(),j.getMinutes(),j.getSeconds());return{startDate:R1,endDate:new Date(R1.getTime()+P1.getTime()-j.getTime())};};h1.prototype._getResizeConfig=function(i){var j=E1(i),P1=new q({sourceAggregation:"appointments",targetAggregation:"_intervalPlaceholders",targetElement:E1(i),dragStart:function(Q1){if(!i.getEnableAppointmentsResize()||j._isOneMonthsRowOnSmallSizes()||!j._isResizingPerformed()){Q1.preventDefault();return;}var R1=Q1.getParameter("dragSession"),S1=j.$().find(".sapUiCalendarRowAppsOverlay"),T1=U(R1.getIndicator()),U1=R1.getDragControl().$();T1.addClass("sapUiDnDIndicatorHide");setTimeout(function(){S1.addClass("sapUiCalendarRowAppsOverlayDragging");},0);U(document).one("dragend",function(){S1.removeClass("sapUiCalendarRowAppsOverlayDragging");T1.removeClass("sapUiDnDIndicatorHide");U1.css({width:"auto","min-width":"auto","z-index":"auto",opacity:1});});if(!l.browser.msie&&!l.browser.edge){Q1.getParameter("browserEvent").dataTransfer.setDragImage(A1(),0,0);}},dragEnter:function(Q1){var R1=Q1.getParameter("dragSession"),S1=this.getTargetElement(),T1=function(){var X1=U(R1.getIndicator());X1.addClass("sapUiDnDIndicatorHide");},U1=R1.getDropControl().getDomRef().getBoundingClientRect(),V1=sap.ui.getCore().byId(S1).getDomRef().getBoundingClientRect(),W1={width:U1.left+U1.width-(R1.getDragControl().$().position().left+V1.left),"min-width":Math.min(R1.getDragControl().$().outerWidth(),R1.getDropControl().$().outerWidth()),"z-index":1,opacity:0.8};R1.getDragControl().$().css(W1);if(!R1.getIndicator()){setTimeout(T1,0);}else{T1();}},drop:function(Q1){var j=E1(i),R1=Q1.getParameter("dragSession"),S1=R1.getDragControl(),T1=j.getIntervalType(),U1=j.getStartDate(),V1=j.indexOfAggregation("_intervalPlaceholders",R1.getDropControl()),W1;if(T1===b1.Hour){W1=this._calcResizeNewHoursAppPos(U1,S1.getStartDate(),S1.getEndDate(),V1);}else if(T1===b1.Day||T1===b1.Week||(T1===b1.OneMonth&&!j._isOneMonthsRowOnSmallSizes())){W1=this._calcResizeNewDaysAppPos(U1,S1.getStartDate(),S1.getEndDate(),V1);}else if(T1===b1.Month){W1=this._calcResizeNewMonthsAppPos(U1,S1.getStartDate(),S1.getEndDate(),V1);}j.$().find(".sapUiCalendarRowAppsOverlay").removeClass("sapUiCalendarRowAppsOverlayDragging");U(R1.getIndicator()).removeClass("sapUiDnDIndicatorHide");S1.$().css({width:"auto","min-width":"auto","z-index":"auto",opacity:1});if(S1.getEndDate().getTime()===W1.endDate.getTime()){return;}i.fireAppointmentResize({appointment:S1,startDate:W1.startDate,endDate:W1.endDate,calendarRow:i});}.bind(this)});P1.setProperty("groupName",e1);return P1;};h1.prototype._calcResizeNewHoursAppPos=function(i,j,P1,Q1){var R1=new Date(i.getFullYear(),i.getMonth(),i.getDate(),i.getHours()),S1=30*60*1000;R1=new Date(R1.getTime()+((Q1+1)*S1));if(R1.getTime()<=j.getTime()){R1=new Date(j.getTime()+S1);}return{startDate:j,endDate:R1};};h1.prototype._calcResizeNewDaysAppPos=function(i,j,P1,Q1){var R1=new Date(i),S1=R1.getDate()+Q1+1,T1=new Date(R1.getFullYear(),R1.getMonth(),R1.getDate());T1.setDate(S1);if(T1.getTime()<=j.getTime()){S1=j.getDate()+1;}R1.setDate(S1);R1=new Date(R1.getFullYear(),R1.getMonth(),R1.getDate());return{startDate:j,endDate:R1};};h1.prototype._calcResizeNewMonthsAppPos=function(i,j,P1,Q1){var R1=new Date(i),S1=R1.getMonth()+Q1+1;if(S1<=j.getMonth()){S1=j.getMonth()+1;}R1.setMonth(S1);R1=new Date(R1.getFullYear(),R1.getMonth(),1);return{startDate:j,endDate:R1};};h1.prototype._calcCreateNewAppHours=function(i,j,P1){var Q1=30*60*1000,R1=new Date(i.getFullYear(),i.getMonth(),i.getDate(),i.getHours()),S1,T1,U1;S1=R1.getTime();if(j<=P1){T1=new Date(S1+(j*Q1));U1=new Date(S1+((P1+1)*Q1));}else{T1=new Date(S1+(P1*Q1));U1=new Date(S1+(j*Q1));}return{startDate:T1,endDate:U1};};h1.prototype._calcCreateNewAppDays=function(i,j,P1){var Q1=new Date(i),R1=new Date(i);if(j<=P1){Q1=new Date(i.getFullYear(),i.getMonth(),i.getDate()+j);R1=new Date(i.getFullYear(),i.getMonth(),i.getDate()+P1+1);}else{Q1=new Date(i.getFullYear(),i.getMonth(),i.getDate()+P1);R1=new Date(i.getFullYear(),i.getMonth(),i.getDate()+j);}return{startDate:Q1,endDate:R1};};h1.prototype._calcCreateNewAppMonths=function(i,j,P1){var Q1=new Date(i),R1=new Date(i);if(j<=P1){Q1=new Date(i.getFullYear(),i.getMonth()+j,1);R1=new Date(i.getFullYear(),i.getMonth()+P1+1,1);}else{Q1=new Date(i.getFullYear(),i.getMonth()+P1,1);R1=new Date(i.getFullYear(),i.getMonth()+j,1);}return{startDate:Q1,endDate:R1};};h1.prototype._getConfigFromDragDropConfigAggregation=function(j,P1){var Q1=j,R1=Q1&&Q1.length;for(var i=0;i<R1;i++){if(Q1[i].getGroupName()===P1){return Q1[i];}}return null;};h1.prototype._getAppointmentsCreateConfig=function(i){var j=E1(i),P1=new q({targetAggregation:"_intervalPlaceholders",dragStart:function(Q1){if(!i.getEnableAppointmentsCreate()||j._isOneMonthsRowOnSmallSizes()||!j._isCreatingPerformed()){Q1.preventDefault();return;}var R1=Q1.getParameter("dragSession"),S1=j.$().find(".sapUiCalendarRowAppsOverlay"),T1=U(R1.getIndicator());setTimeout(function(){S1.addClass("sapUiCalendarRowAppsOverlayDragging");},0);U(document).one("dragend",function(){S1.removeClass("sapUiCalendarRowAppsOverlayDragging");T1.html("");T1.removeClass("sapUiCalendarApp sapUiCalendarAppType01 sapUiAppCreate");});if(!l.browser.msie&&!l.browser.edge){Q1.getParameter("browserEvent").dataTransfer.setDragImage(A1(),0,0);}},dragEnter:function(Q1){var R1=Q1.getParameter("dragSession"),S1=R1.getDropControl().getDomRef().getBoundingClientRect(),T1=function(){var V1=U(R1.getIndicator());V1.addClass("sapUiCalendarApp sapUiCalendarAppType01 sapUiAppCreate");};var U1=R1.getData("text")?parseFloat(R1.getData("text").split("|")[0]):0;if(U1){if(U1<=S1.left){R1.setIndicatorConfig({left:U1,width:Math.max((S1.left+S1.width-U1),S1.width)});}else{R1.setIndicatorConfig({left:S1.left,width:U1-S1.left});}}else{R1.setData("text",S1.left+"|"+j.indexOfAggregation("_intervalPlaceholders",R1.getDropControl()));}if(!R1.getIndicator()){setTimeout(T1,0);}else{T1();}},drop:function(Q1){var R1=Q1.getParameter("dragSession"),S1=U(R1.getIndicator()),T1=j.getIntervalType(),U1=E1(i).getStartDate(),V1=parseInt(R1.getData("text").split("|")[1]),W1=j.indexOfAggregation("_intervalPlaceholders",R1.getDropControl()),X1;if(T1===b1.Hour){X1=this._calcCreateNewAppHours(U1,V1,W1);}else if(T1===b1.Day||T1===b1.Week||(T1===b1.OneMonth&&!j._isOneMonthsRowOnSmallSizes())){X1=this._calcCreateNewAppDays(U1,V1,W1);}else if(T1===b1.Month){X1=this._calcCreateNewAppMonths(U1,V1,W1);}i.fireAppointmentCreate({startDate:X1.startDate,endDate:X1.endDate,calendarRow:i});S1.html("");S1.removeClass("sapUiCalendarApp sapUiCalendarAppType01 sapUiAppCreate");}.bind(this)});P1.setProperty("groupName",f1);return P1;};h1.prototype._updateHeaderButtons=function(){var i=this.getViewKey(),j=this._getView(i,true),P1=j&&j.getIntervalType(),Q1=new Date(this._dateNav.getStart().getTime()),R1=new Date(this._dateNav.getEnd().getTime()),S1=this.getMinDate()?new Date(this.getMinDate().getTime()):undefined,T1=this.getMaxDate()?new Date(this.getMaxDate().getTime()):undefined;if(P1!=="Hour"){S1&&S1.setHours(0,0,0,0);T1&&T1.setHours(23,59,59,999);Q1.setHours(0,0,0,0);R1.setHours(23,59,59,999);}this._getHeader()._oPrevBtn.setEnabled(!S1||Q1.getTime()>S1.getTime());this._getHeader()._oNextBtn.setEnabled(!T1||R1.getTime()<T1.getTime());};function A1(){var i=U("<span></span>").addClass("sapUiCalAppResizeGhost");i.appendTo(document.body);setTimeout(function(){i.remove();},0);return i.get(0);}function B1(i){var j=i.getId();return sap.ui.getCore().byId(j.substring(0,j.indexOf(g1)));}function C1(i){return sap.ui.getCore().byId(i.getId()+g1);}function D1(i){var j=C1(i);return j?j.getHeader():null;}function E1(i){var j=C1(i);return j?j.getTimeline():null;}function F1(j){var P1=[];var Q1=this.getRows();for(var i=0;i<Q1.length;i++){var R1=Q1[i];var S1=C1(R1);var T1=S1.getSelected();if(R1.getSelected()!=T1){R1.setProperty("selected",T1,true);P1.push(R1);}}if(!this.getSingleSelection()){L1.call(this);}if(P1.length>0){this.fireRowSelectionChange({rows:P1});}}function G1(i){if(i<this._iBreakPointTablet){this._iSize=0;}else if(i<this._iBreakPointDesktop){this._iSize=1;}else{this._iSize=2;}if(i<m1.PHONE){this._iSizeScreen=0;}else if(i<m1.TABLET){this._iSizeScreen=1;}else{this._iSizeScreen=2;}}function H1(j){var P1='sapMSize'+j,i,Q1;for(i=0;i<3;i++){Q1='sapMSize'+i;if(Q1===P1){this.addStyleClass(Q1);}else{this.removeStyleClass(Q1);}}}function I1(){var j=this._getViews();this._oIntervalTypeSelect.destroyItems();var i;var P1;for(i=0;i<j.length;i++){var Q1=j[i];P1=new z(this.getId()+"-"+i,{key:Q1.getKey(),text:Q1.getDescription(),tooltip:Q1.getTooltip()});this._oIntervalTypeSelect.addItem(P1);}if(this._oIntervalTypeSelect.getItems().length>4){this._getHeader()._convertViewSwitchToSelect();}else{this._getHeader()._convertViewSwitchToSegmentedButton();}this._oIntervalTypeSelect.setVisible(!(j.length===1));}function J1(i){var j=i.getParameter("selected");var P1=this.getRows();if(j){P1=this.getRows().filter(function(Q1){return!Q1.getSelected();});}this.selectAllRows(j);this.fireRowSelectionChange({rows:P1});}function K1(j){var P1=j.oSource;var Q1=j.getParameter("type");var R1=this.getRows();var S1;var T1;var U1;var V1;var i=0;var W1=0;var X1;for(i=0;i<R1.length;i++){S1=R1[i];if(E1(S1)==P1){W1=i;break;}}switch(Q1){case"sapup":U1=P1.getFocusedAppointment();V1=U1.getStartDate();if(W1>0){W1--;}T1=R1[W1];E1(T1).focusNearestAppointment(V1);break;case"sapdown":U1=P1.getFocusedAppointment();V1=U1.getStartDate();if(W1<R1.length-1){W1++;}T1=R1[W1];E1(T1).focusNearestAppointment(V1);break;case"saphome":if(W1>0){T1=R1[0];X1=new U.Event(Q1);X1._bPlanningCalendar=true;E1(T1).onsaphome(X1);}break;case"sapend":if(W1<R1.length-1){T1=R1[R1.length-1];X1=new U.Event(Q1);X1._bPlanningCalendar=true;E1(T1).onsapend(X1);}break;default:break;}}function L1(){if(this._oSelectAllCheckBox){var i=this.getRows();var j=this.getSelectedRows();if(i.length==j.length&&j.length>0){this._oSelectAllCheckBox.setSelected(true);}else{this._oSelectAllCheckBox.setSelected(false);}}}function M1(){if(this.getSingleSelection()){if(this._oCalendarHeader.getAllCheckBox()){this._oCalendarHeader.setAllCheckBox();}else if(this._oInfoToolbar.getContent().length>2){this._oInfoToolbar.removeContent(this._oSelectAllCheckBox);}}else{if(!this._oSelectAllCheckBox){this._oSelectAllCheckBox=new K(this.getId()+"-All",{text:this._oRB.getText("COLUMNSPANEL_SELECT_ALL")});this._oSelectAllCheckBox.attachEvent("select",J1,this);}if(this._iSizeScreen<2||!this.getShowRowHeaders()){var i=this._oInfoToolbar.indexOfContent(this._oSelectAllCheckBox);if(this._iSizeScreen<2){if(i<this._oInfoToolbar.getContent().length-1){this._oInfoToolbar.addContent(this._oSelectAllCheckBox);}}else if(i<0||i>1){if(i>1){this._oInfoToolbar.removeContent(this._oSelectAllCheckBox);}this._oInfoToolbar.insertContent(this._oSelectAllCheckBox,1);}}else{this._oCalendarHeader.setAllCheckBox(this._oSelectAllCheckBox);}}}function N1(){var i=this.getAggregation("table");var j=i.getMode();var P1;if(this.getSingleSelection()){if(!this.getShowRowHeaders()&&this.getRows().length==1){P1=X.None;}else{P1=X.SingleSelectMaster;}}else{P1=X.MultiSelect;}if(j!=P1){i.setMode(P1);}}function O1(){return this._oTimesRow||this._oDatesRow||this._oMonthsRow||this._oWeeksRow||this._oOneMonthsRow;}return h1;});
