/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./Dialog','./Popover','./SelectList','./library','sap/ui/core/Core','sap/ui/core/Control','sap/ui/core/EnabledPropagator','sap/ui/core/LabelEnablement','sap/ui/core/Icon','sap/ui/core/IconPool','./Button','./Bar','./Title','./delegate/ValueStateMessage','sap/ui/core/message/MessageMixin','sap/ui/core/library','sap/ui/core/Item','sap/ui/Device','sap/ui/core/InvisibleText','./SelectRenderer',"sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes",'./Text','sap/m/SimpleFixFlex','sap/base/Log','sap/ui/core/ValueStateSupport'],function(D,P,S,l,C,a,E,L,I,b,B,c,T,V,M,d,f,g,h,j,k,K,m,n,o,p){"use strict";var q=l.SelectListKeyboardNavigationMode;var r=l.PlacementType;var s=d.ValueState;var t=d.TextDirection;var u=d.TextAlign;var v=l.SelectType;var w=a.extend("sap.m.Select",{metadata:{interfaces:["sap.ui.core.IFormContent","sap.m.IOverflowToolbarContent","sap.f.IShellBar"],library:"sap.m",properties:{name:{type:"string",group:"Misc",defaultValue:""},enabled:{type:"boolean",group:"Behavior",defaultValue:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"auto"},maxWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},selectedKey:{type:"string",group:"Data",defaultValue:""},selectedItemId:{type:"string",group:"Misc",defaultValue:""},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""},type:{type:"sap.m.SelectType",group:"Appearance",defaultValue:v.Default},autoAdjustWidth:{type:"boolean",group:"Appearance",defaultValue:false},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:u.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:t.Inherit},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:s.None},valueStateText:{type:"string",group:"Misc",defaultValue:""},showSecondaryValues:{type:"boolean",group:"Misc",defaultValue:false},forceSelection:{type:"boolean",group:"Behavior",defaultValue:true},wrapItemsText:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item",bindable:"bindable",forwarding:{getter:"getList",aggregation:"items"}},picker:{type:"sap.ui.core.PopupInterface",multiple:false,visibility:"hidden"},_valueIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_pickerHeader:{type:"sap.m.Bar",multiple:false,visibility:"hidden"},_pickerValueStateContent:{type:"sap.m.Text",multiple:false,visibility:"hidden"}},associations:{selectedItem:{type:"sap.ui.core.Item",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{selectedItem:{type:"sap.ui.core.Item"}}}},designtime:"sap/m/designtime/Select.designtime"}});b.insertFontFaceStyle();E.apply(w.prototype,[true]);M.call(w.prototype);function H(i){if(this._isIconOnly()&&!this.isOpen()){return;}if(i){this.setSelection(i);this.setValue(i.getText());this.scrollToItem(i);}}var A=null;function G(){var i="_sapMSltAnnounceMessage-assertive";return'<span id="'+i+'" data-sap-ui="'+i+'" class="sapUiAnnounceMessageAssertive" role="status" aria-live="assertive">'+'</span>';}function x(){var e=sap.ui.getCore(),i=e.getStaticAreaRef(),N;if(!A){i.insertAdjacentHTML("beforeend",G());A={announce:function(y){N=i.querySelector(".sapUiAnnounceMessageAssertive");N.textContent="";N.textContent=y;}};}return A;}w.prototype._attachHiddenSelectHandlers=function(){var e=this._getHiddenSelect();e.on("focusin",this._addFocusClass.bind(this));e.on("focusout",this._removeFocusClass.bind(this));};w.prototype._addFocusClass=function(){this.$().addClass("sapMSltFocused");};w.prototype._removeFocusClass=function(){this.$().removeClass("sapMSltFocused");};w.prototype._detachHiddenSelectHandlers=function(){var e=this._getHiddenSelect();if(e){e.off("focusin");e.off("focusout");}};w.prototype._getHiddenSelect=function(){return this.$("hiddenSelect");};w.prototype._getHiddenInput=function(){return this.$("hiddenInput");};w.prototype._announceValueStateText=function(){var e=this._getValueStateText();if(this._oInvisibleMessage){this._oInvisibleMessage.announce(e);}};w.prototype._getValueStateText=function(){var e=this.getValueState(),i=C.getLibraryResourceBundle("sap.m").getText("INPUTBASE_VALUE_STATE_"+e.toUpperCase()),y=i+" "+(this.getValueStateText()||p.getAdditionalText(this));return y;};w.prototype._isFocused=function(){return this.getFocusDomRef()===document.activeElement;};w.prototype._isIconOnly=function(){return this.getType()===v.IconOnly;};w.prototype._handleFocusout=function(e){this._bFocusoutDueRendering=this.bRenderingPhase;if(this._bFocusoutDueRendering){this._bProcessChange=false;return;}if(this._bProcessChange){if(!this.isOpen()||e.target===this.getAggregation("picker")){this._checkSelectionChange();}else{this._revertSelection();}this._bProcessChange=false;}else{this._bProcessChange=true;}};w.prototype._checkSelectionChange=function(){var i=this.getSelectedItem();if(this._oSelectionOnFocus!==i){this.fireChange({selectedItem:i});}};w.prototype._revertSelection=function(){var i=this.getSelectedItem();if(this._oSelectionOnFocus!==i){this.setSelection(this._oSelectionOnFocus);this.setValue(this._getSelectedItemText());}};w.prototype._getSelectedItemText=function(i){i=i||this.getSelectedItem();if(!i){i=this.getDefaultSelectedItem();}if(i){return i.getText();}return"";};w.prototype.getOverflowToolbarConfig=function(){var e=["enabled","selectedKey"];if(!this.getAutoAdjustWidth()||this._bIsInOverflow){e.push("selectedItemId");}var i={canOverflow:true,autoCloseEvents:["change"],invalidationEvents:["_itemTextChange"],propsUnrelatedToSize:e};i.onBeforeEnterOverflow=function(y){var z=y.getParent();if(!z.isA("sap.m.OverflowToolbar")){return;}y._prevSelectType=y.getType();y._bIsInOverflow=true;if(y.getType()!==v.Default){y.setProperty("type",v.Default,true);}};i.onAfterExitOverflow=function(y){var z=y.getParent();if(!z.isA("sap.m.OverflowToolbar")){return;}y._bIsInOverflow=false;if(y.getType()!==y._prevSelectType){y.setProperty("type",y._prevSelectType,true);}};return i;};w.prototype.getList=function(){if(this.bIsDestroyed){return null;}return this._oList;};w.prototype.findFirstEnabledItem=function(i){var e=this.getList();return e?e.findFirstEnabledItem(i):null;};w.prototype.findLastEnabledItem=function(i){var e=this.getList();return e?e.findLastEnabledItem(i):null;};w.prototype.setSelectedIndex=function(i,_){var e;_=_||this.getItems();i=(i>_.length-1)?_.length-1:Math.max(0,i);e=_[i];if(e){this.setSelection(e);}};w.prototype.scrollToItem=function(i){var e=this.getPicker().getDomRef(),y=i&&i.getDomRef();if(!e||!y){return;}var z=e.querySelector('.sapUiSimpleFixFlexFlexContent'),F=e.querySelector('.sapMSltPickerValueState'),J=F?F.clientHeight:0,N=z.scrollTop,O=y.offsetTop-J,Q=z.clientHeight,R=y.offsetHeight;if(N>O){z.scrollTop=O;}else if((O+R)>(N+Q)){z.scrollTop=Math.ceil(O+R-Q);}};w.prototype.setValue=function(e){var i=this.getDomRef(),y=i&&i.querySelector(".sapMSelectListItemText"),F=!this.isOpen()&&this._isFocused()&&this._oInvisibleMessage&&g.os.macintosh;if(y){y.textContent=e;}this._setHiddenSelectValue();this._getValueIcon();if(F){this._oInvisibleMessage.announce(e);}};w.prototype._setHiddenSelectValue=function(){var e=this._getHiddenSelect(),i=this._getHiddenInput(),y=this.getSelectedKey(),z=this.getSelectedItem(),F;i.attr("value",y||"");F=z?z.getText():"";e.text(F);};w.prototype._getValueIcon=function(){if(this.bIsDestroyed){return null;}var e=this.getAggregation("_valueIcon"),i=this.getSelectedItem(),y=!!(i&&i.getIcon&&i.getIcon()),z=y?i.getIcon():"sap-icon://pull-down";if(!e){e=new I(this.getId()+"-labelIcon",{src:z,visible:false});this.setAggregation("_valueIcon",e,true);}if(e.getVisible()!==y){e.setVisible(y);e.toggleStyleClass("sapMSelectListItemIcon",y);}if(y&&i.getIcon()!==e.getSrc()){e.setSrc(z);}return e;};w.prototype._isShadowListRequired=function(){if(this.getAutoAdjustWidth()){return false;}else if(this.getWidth()==="auto"){return true;}return false;};w.prototype._handleAriaActiveDescendant=function(i){var e=this.getFocusDomRef(),y=i&&i.getDomRef(),z="aria-activedescendant";if(!e){return;}if(y&&this.isOpen()){e.setAttribute(z,i.getId());}else{e.removeAttribute(z);}};w.prototype.updateItems=function(R){S.prototype.updateItems.apply(this,arguments);this._oSelectionOnFocus=this.getSelectedItem();};w.prototype.refreshItems=function(){S.prototype.refreshItems.apply(this,arguments);};w.prototype.onBeforeOpen=function(e){var i=this["_onBeforeOpen"+this.getPickerType()],y=this.getRenderer().CSS_CLASS;this.addStyleClass(y+"Pressed");this.addStyleClass(y+"Expanded");this.closeValueStateMessage();this.addContent();this.addContentToFlex();i&&i.call(this);};w.prototype.onAfterOpen=function(e){var i=this.getFocusDomRef(),y=null;if(!i){return;}y=this.getSelectedItem();i.setAttribute("aria-expanded","true");i.setAttribute("aria-controls",this.getList().getId());if(y){i.setAttribute("aria-activedescendant",y.getId());this.scrollToItem(y);}};w.prototype.onBeforeClose=function(e){var i=this.getFocusDomRef(),y=this.getRenderer().CSS_CLASS;if(i){i.removeAttribute("aria-controls");i.removeAttribute("aria-activedescendant");if(this.shouldValueStateMessageBeOpened()&&(document.activeElement===i)){this.openValueStateMessage();}}this.removeStyleClass(y+"Expanded");};w.prototype.onAfterClose=function(e){var i=this.getFocusDomRef(),y=this.getRenderer().CSS_CLASS,z=y+"Pressed";if(i){i.setAttribute("aria-expanded","false");i.removeAttribute("aria-activedescendant");}this.removeStyleClass(z);};w.prototype.getPicker=function(){if(this.bIsDestroyed){return null;}return this.createPicker(this.getPickerType());};w.prototype.getSimpleFixFlex=function(){if(this.bIsDestroyed){return null;}else if(this.oSimpleFixFlex){return this.oSimpleFixFlex;}this.oSimpleFixFlex=new n({id:this.getPickerValueStateContentId(),fixContent:this._getPickerValueStateContent().addStyleClass(this.getRenderer().CSS_CLASS+"PickerValueState"),flexContent:this.createList()});return this.oSimpleFixFlex;};w.prototype.setPickerType=function(e){this._sPickerType=e;};w.prototype.getPickerType=function(){return this._sPickerType;};w.prototype._getPickerValueStateContent=function(){if(!this.getAggregation("_pickerValueStateContent")){this.setAggregation("_pickerValueStateContent",new m({wrapping:true,text:this._getTextForPickerValueStateContent()}));}return this.getAggregation("_pickerValueStateContent");};w.prototype._updatePickerValueStateContentText=function(){var e=this.getPicker().getContent()[0].getFixContent(),i;if(e){i=this._getTextForPickerValueStateContent();e.setText(i);}};w.prototype._getTextForPickerValueStateContent=function(){var e=this.getValueStateText(),i;if(e){i=e;}else{i=this._getDefaultTextForPickerValueStateContent();}return i;};w.prototype._getDefaultTextForPickerValueStateContent=function(){var e=this.getValueState(),R,i;if(e===s.None){i="";}else{R=C.getLibraryResourceBundle("sap.ui.core");i=R.getText("VALUE_STATE_"+e.toUpperCase());}return i;};w.prototype._updatePickerValueStateContentStyles=function(){var e=this.getValueState(),i=s,y=this.getRenderer().CSS_CLASS,z=y+"Picker",F=z+e+"State",J=z+"WithSubHeader",N=this.getPicker(),O=N.getContent()[0].getFixContent();if(O){this._removeValueStateClassesForPickerValueStateContent(N);O.addStyleClass(F);if(e!==i.None){N.addStyleClass(J);}else{N.removeStyleClass(J);}}};w.prototype._removeValueStateClassesForPickerValueStateContent=function(e){var i=s,y=this.getRenderer().CSS_CLASS,z=y+"Picker",F=e.getContent()[0].getFixContent();Object.keys(i).forEach(function(J){var O=z+J+"State";F.removeStyleClass(O);});};w.prototype._createPopover=function(){var e=this;var i=new P({showArrow:false,showHeader:false,placement:r.VerticalPreferredBottom,offsetX:0,offsetY:0,initialFocus:this,bounce:false,ariaLabelledBy:this._getPickerHiddenLabelId()});i.addEventDelegate({ontouchstart:function(y){var z=this.getDomRef("cont");if((y.target===z)||(y.srcControl instanceof f)){e._bProcessChange=false;}}},i);this._decoratePopover(i);return i;};w.prototype._decoratePopover=function(e){var i=this;e.open=function(){return this.openBy(i);};};w.prototype._onBeforeRenderingPopover=function(){var e=this.getPicker(),W=this.$().outerWidth()+"px";if(e){e.setContentMinWidth(W);}};w.prototype._createDialog=function(){var e=this;return new D({stretch:true,ariaLabelledBy:this._getPickerHiddenLabelId(),customHeader:this._getPickerHeader(),beforeOpen:function(){e.updatePickerHeaderTitle();}});};w.prototype._getPickerTitle=function(){var e=this.getPicker(),i=e&&e.getCustomHeader();if(i){return i.getContentMiddle()[0];}return null;};w.prototype._getPickerHeader=function(){var i=b.getIconURI("decline"),R;if(!this.getAggregation("_pickerHeader")){R=C.getLibraryResourceBundle("sap.m");this.setAggregation("_pickerHeader",new c({contentMiddle:new T({text:R.getText("SELECT_PICKER_TITLE_TEXT")}),contentRight:new B({icon:i,press:this.close.bind(this)})}));}return this.getAggregation("_pickerHeader");};w.prototype._getPickerHiddenLabelId=function(){return h.getStaticId("sap.m","INPUT_AVALIABLE_VALUES");};w.prototype.getPickerValueStateContentId=function(){return this.getId()+"-valueStateText";};w.prototype.updatePickerHeaderTitle=function(){var e=this.getPicker();if(!e){return;}var i=this.getLabels();if(i.length){var y=i[0],z=this._getPickerTitle();if(y&&(typeof y.getText==="function")){z&&z.setText(y.getText());}}};w.prototype._onBeforeOpenDialog=function(){};w.prototype.init=function(){this.setPickerType(g.system.phone?"Dialog":"Popover");this.createPicker(this.getPickerType());this._oSelectionOnFocus=null;this.bRenderingPhase=false;this._bFocusoutDueRendering=false;this._bProcessChange=false;this.sTypedChars="";this.iTypingTimeoutID=-1;this._oValueStateMessage=new V(this);this._bValueStateMessageOpened=false;this._oInvisibleMessage=null;};w.prototype.onBeforeRendering=function(){if(!this._oInvisibleMessage){this._oInvisibleMessage=x();}this.bRenderingPhase=true;this.synchronizeSelection({forceSelection:this.getForceSelection()});this._updatePickerValueStateContentText();this._updatePickerValueStateContentStyles();this._detachHiddenSelectHandlers();};w.prototype.onAfterRendering=function(){this.bRenderingPhase=false;this._setHiddenSelectValue();this._attachHiddenSelectHandlers();};w.prototype.exit=function(){var e=this.getValueStateMessage(),i=this._getValueIcon();this._oSelectionOnFocus=null;if(e){this.closeValueStateMessage();e.destroy();}if(i){i.destroy();}this._oValueStateMessage=null;this._bValueStateMessageOpened=false;};w.prototype.ontouchstart=function(e){e.setMarked();if(this.getEnabled()&&this.getEditable()&&this.isOpenArea(e.target)){this.addStyleClass(this.getRenderer().CSS_CLASS+"Pressed");}};w.prototype.ontouchend=function(e){e.setMarked();if(this.getEnabled()&&this.getEditable()&&!this.isOpen()&&this.isOpenArea(e.target)){this.removeStyleClass(this.getRenderer().CSS_CLASS+"Pressed");}};w.prototype.ontap=function(e){var i=this.getRenderer().CSS_CLASS;e.setMarked();if(!this.getEnabled()||!this.getEditable()){return;}if(this.isOpenArea(e.target)){if(this.isOpen()){this.close();this.removeStyleClass(i+"Pressed");return;}if(g.system.phone){this.focus();}this.open();}if(this.isOpen()){this.addStyleClass(i+"Pressed");}};w.prototype.onSelectionChange=function(e){var i=e.getParameter("selectedItem");this.close();this.setSelection(i);this.fireChange({selectedItem:i});this.setValue(this._getSelectedItemText());};w.prototype.onkeypress=function(e){if(!this.getEnabled()||!this.getEditable()){return;}e.setMarked();var i=String.fromCharCode(e.which),y;this.sTypedChars+=i;y=(/^(.)\1+$/i).test(this.sTypedChars)?i:this.sTypedChars;clearTimeout(this.iTypingTimeoutID);this.iTypingTimeoutID=setTimeout(function(){this.sTypedChars="";this.iTypingTimeoutID=-1;}.bind(this),1000);H.call(this,this.searchNextItemByText(y));};w.prototype.onsapshow=function(e){if(!this.getEnabled()||!this.getEditable()){return;}e.setMarked();if(e.which===K.F4){e.preventDefault();}this.toggleOpenState();};w.prototype.onsaphide=w.prototype.onsapshow;w.prototype.onmousedown=function(e){e.preventDefault();this._getHiddenSelect().focus();};w.prototype.onsapescape=function(e){if(!this.getEnabled()||!this.getEditable()){return;}if(this.isOpen()){e.setMarked();this.close();this._revertSelection();}};w.prototype.onsapenter=function(e){e.preventDefault();if(!this.getEnabled()||!this.getEditable()){return;}e.setMarked();this.close();this._checkSelectionChange();};w.prototype.onkeydown=function(e){if([K.ARROW_DOWN,K.ARROW_UP,K.SPACE].indexOf(e.which)>-1){e.preventDefault();}};w.prototype.onkeyup=function(e){if(!this.getEnabled()||!this.getEditable()){return;}if(e.which===K.SPACE&&!e.shiftKey){e.setMarked();e.preventDefault();if(this.isOpen()){this._checkSelectionChange();}this.toggleOpenState();}};w.prototype.onsapdown=function(e){if(!this.getEnabled()||!this.getEditable()){return;}e.setMarked();e.preventDefault();var N,i=this.getSelectableItems();N=i[i.indexOf(this.getSelectedItem())+1];H.call(this,N);};w.prototype.onsapup=function(e){if(!this.getEnabled()||!this.getEditable()){return;}e.setMarked();e.preventDefault();var i,y=this.getSelectableItems();i=y[y.indexOf(this.getSelectedItem())-1];H.call(this,i);};w.prototype.onsaphome=function(e){if(!this.getEnabled()||!this.getEditable()){return;}e.setMarked();e.preventDefault();var F=this.getSelectableItems()[0];H.call(this,F);};w.prototype.onsapend=function(e){if(!this.getEnabled()||!this.getEditable()){return;}e.setMarked();e.preventDefault();var i=this.findLastEnabledItem(this.getSelectableItems());H.call(this,i);};w.prototype.onsappagedown=function(e){if(!this.getEnabled()||!this.getEditable()){return;}e.setMarked();e.preventDefault();var i=this.getSelectableItems(),y=this.getSelectedItem();this.setSelectedIndex(i.indexOf(y)+10,i);y=this.getSelectedItem();if(y){this.setValue(y.getText());}this.scrollToItem(y);};w.prototype.onsappageup=function(e){if(!this.getEnabled()||!this.getEditable()){return;}e.setMarked();e.preventDefault();var i=this.getSelectableItems(),y=this.getSelectedItem();this.setSelectedIndex(i.indexOf(y)-10,i);y=this.getSelectedItem();if(y){this.setValue(y.getText());}this.scrollToItem(y);};w.prototype.onsaptabnext=function(e){if(!this.getEnabled()){return;}if(this.isOpen()){this.close();this._checkSelectionChange();}};w.prototype.onsaptabprevious=w.prototype.onsaptabnext;w.prototype.onfocusin=function(e){if(!this._bFocusoutDueRendering&&!this._bProcessChange){this._oSelectionOnFocus=this.getSelectedItem();}this._bProcessChange=true;setTimeout(function(){if(!this.isOpen()&&this.shouldValueStateMessageBeOpened()&&(document.activeElement===this.getFocusDomRef())){this.openValueStateMessage();}}.bind(this),100);if(e.target!==this.getFocusDomRef()){this.focus();}};w.prototype.onfocusout=function(e){this._handleFocusout(e);if(this.bRenderingPhase){return;}this.closeValueStateMessage();};w.prototype.onsapfocusleave=function(e){var i=this.getAggregation("picker");if(!e.relatedControlId||!i){return;}var y=C.byId(e.relatedControlId),F=y&&y.getFocusDomRef();if(g.system.desktop&&k(i.getFocusDomRef(),F)){this.focus();}};w.prototype.getFocusDomRef=function(){return this._getHiddenSelect()[0];};w.prototype.getPopupAnchorDomRef=function(){return this.getDomRef();};w.prototype.setSelection=function(i){var e=this.getList(),y;if(e){e.setSelection(i);}this.setAssociation("selectedItem",i,true);this.setProperty("selectedItemId",(i instanceof f)?i.getId():i,true);if(typeof i==="string"){i=C.byId(i);}y=i?i.getKey():"";this.setProperty("selectedKey",y,true);this._handleAriaActiveDescendant(i);};w.prototype.isSelectionSynchronized=function(){return S.prototype.isSelectionSynchronized.apply(this,arguments);};w.prototype.synchronizeSelection=function(){S.prototype.synchronizeSelection.apply(this,arguments);};w.prototype.addContent=function(e){};w.prototype.addContentToFlex=function(){};w.prototype.createPicker=function(e){var i=this.getAggregation("picker"),y=this.getRenderer().CSS_CLASS;if(i){return i;}i=this["_create"+e]();this.setAggregation("picker",i,true);i.setHorizontalScrolling(false).addStyleClass(y+"Picker").addStyleClass(y+"Picker-CTX").addStyleClass("sapUiNoContentPadding").attachBeforeOpen(this.onBeforeOpen,this).attachAfterOpen(this.onAfterOpen,this).attachBeforeClose(this.onBeforeClose,this).attachAfterClose(this.onAfterClose,this).addEventDelegate({onBeforeRendering:this.onBeforeRenderingPicker,onAfterRendering:this.onAfterRenderingPicker},this).addContent(this.getSimpleFixFlex());return i;};w.prototype.searchNextItemByText=function(e){var y=this.getItems(),z=this.getSelectedIndex(),F=y.splice(z+1,y.length-z),J=y.splice(0,y.length-1);y=F.concat(J);for(var i=0,N;i<y.length;i++){N=y[i];var O=typeof e==="string"&&e!=="";if(N.getEnabled()&&!(N instanceof sap.ui.core.SeparatorItem)&&N.getText().toLowerCase().startsWith(e.toLowerCase())&&O){return N;}}return null;};w.prototype.createList=function(){var e=q,i=g.system.phone?e.Delimited:e.None;this._oList=new S({width:"100%",maxWidth:"600px",keyboardNavigationMode:i}).addStyleClass(this.getRenderer().CSS_CLASS+"List-CTX").addEventDelegate({ontap:function(y){this._checkSelectionChange();this.close();}},this).attachSelectionChange(this.onSelectionChange,this);this._oList.toggleStyleClass("sapMSelectListWrappedItems",this.getWrapItemsText());return this._oList;};w.prototype.setWrapItemsText=function(W){if(this._oList){this._oList.toggleStyleClass("sapMSelectListWrappedItems",W);}return this.setProperty("wrapItemsText",W,true);};w.prototype.hasContent=function(){return this.getItems().length>0;};w.prototype.onBeforeRenderingPicker=function(){var O=this["_onBeforeRendering"+this.getPickerType()];O&&O.call(this);};w.prototype.onAfterRenderingPicker=function(){var O=this["_onAfterRendering"+this.getPickerType()];O&&O.call(this);};w.prototype.open=function(){var e=this.getPicker();if(e){e.open();}return this;};w.prototype.toggleOpenState=function(){if(this.isOpen()){this.close();}else{this.open();}return this;};w.prototype.getVisibleItems=function(){var e=this.getList();return e?e.getVisibleItems():[];};w.prototype.isItemSelected=function(i){return i&&(i.getId()===this.getAssociation("selectedItem"));};w.prototype.getSelectedIndex=function(){var e=this.getSelectedItem();return e?this.indexOfItem(this.getSelectedItem()):-1;};w.prototype.getDefaultSelectedItem=function(i){return this.getForceSelection()?this.findFirstEnabledItem():null;};w.prototype.getSelectableItems=function(){var e=this.getList();return e?e.getSelectableItems():[];};w.prototype.getOpenArea=function(){return this.getDomRef();};w.prototype.isOpenArea=function(e){var O=this.getOpenArea();return O&&O.contains(e);};w.prototype.findItem=function(e,i){var y=this.getList();return y?y.findItem(e,i):null;};w.prototype.clearSelection=function(){this.setSelection(null);};w.prototype.onItemChange=function(e){var i=this.getAssociation("selectedItem"),y=e.getParameter("id"),z=e.getParameter("name"),N=e.getParameter("newValue"),O,F,J,Q;if(z==="key"&&!this.isBound("selectedKey")){F=this.getSelectedKey();J=this.getItemByKey(N);if(N===F&&i!==y&&J&&y===J.getId()){this.setSelection(J);return;}O=e.getParameter("oldValue");if(i===y&&F===O&&!this.getItemByKey(O)){this.setSelectedKey(N);return;}Q=this.getItemByKey(F);if(i===y&&N!==F&&Q){this.setSelection(Q);return;}}if(z==="text"&&i===y){this.fireEvent("_itemTextChange");this.setValue(N);}};w.prototype.fireChange=function(e){this._oSelectionOnFocus=e.selectedItem;return this.fireEvent("change",e);};w.prototype.addAggregation=function(e,O,i){if(e==="items"&&!i&&!this.isInvalidateSuppressed()){this.invalidate(O);}return a.prototype.addAggregation.apply(this,arguments);};w.prototype.destroyAggregation=function(e,i){if(e==="items"&&!i&&!this.isInvalidateSuppressed()){this.invalidate();}return a.prototype.destroyAggregation.apply(this,arguments);};w.prototype.setAssociation=function(e,i,y){var z=this.getList();if(z&&(e==="selectedItem")){S.prototype.setAssociation.apply(z,arguments);}return a.prototype.setAssociation.apply(this,arguments);};w.prototype.setProperty=function(i,y,z){var F=this.getList();if((i==="selectedKey")||(i==="selectedItemId")){F&&S.prototype.setProperty.apply(F,arguments);}try{a.prototype.setProperty.apply(this,arguments);}catch(e){o.warning('Update failed due to exception. Loggable in support mode log',null,null,function(){return{exception:e};});}return this;};w.prototype.removeAllAssociation=function(e,i){var y=this.getList();if(y&&(e==="selectedItem")){S.prototype.removeAllAssociation.apply(y,arguments);}return a.prototype.removeAllAssociation.apply(this,arguments);};w.prototype.clone=function(){var e=a.prototype.clone.apply(this,arguments),i=this.getSelectedItem(),y=this.getSelectedKey();if(!this.isBound("selectedKey")&&!e.isSelectionSynchronized()){if(i&&(y==="")){e.setSelectedIndex(this.indexOfItem(i));}else{e.setSelectedKey(y);}}return e;};w.prototype._updatePickerAriaLabelledBy=function(e){var i=this.getPicker(),y=this.getPickerValueStateContentId();if(e===s.None){i.removeAriaLabelledBy(y);}else{i.addAriaLabelledBy(y);}};w.prototype.getLabels=function(){var e=this.getAriaLabelledBy().concat(L.getReferencingLabels(this));e=e.filter(function(i,y){return e.indexOf(i)===y;}).map(function(i){return C.byId(i);});return e;};w.prototype.getDomRefForValueStateMessage=function(){return this.getFocusDomRef();};w.prototype.getValueStateMessageId=function(){return this.getId()+"-message";};w.prototype.getValueStateMessage=function(){return this._oValueStateMessage;};w.prototype.openValueStateMessage=function(){var e=this.getValueStateMessage();if(e&&!this._bValueStateMessageOpened){this._bValueStateMessageOpened=true;e.open();}};w.prototype.closeValueStateMessage=function(){var e=this.getValueStateMessage();if(e&&this._bValueStateMessageOpened){this._bValueStateMessageOpened=false;e.close();}};w.prototype.shouldValueStateMessageBeOpened=function(){return!this._isIconOnly()&&(this.getValueState()!==s.None)&&this.getEnabled()&&this.getEditable()&&!this._bValueStateMessageOpened;};w.prototype.setShowSecondaryValues=function(e){var i=!this._isShadowListRequired();this.setProperty("showSecondaryValues",e,i);var y=this.getList();if(y){y.setShowSecondaryValues(e);}return this;};w.prototype.addItem=function(i){this.addAggregation("items",i);if(i){i.attachEvent("_change",this.onItemChange,this);}return this;};w.prototype.insertItem=function(i,e){this.insertAggregation("items",i,e);if(i){i.attachEvent("_change",this.onItemChange,this);}return this;};w.prototype.findAggregatedObjects=function(){var e=this.getList();if(e){return S.prototype.findAggregatedObjects.apply(e,arguments);}return[];};w.prototype.getItems=function(){var e=this.getList();return e?e.getItems():[];};w.prototype.setSelectedItem=function(i){if(typeof i==="string"){this.setAssociation("selectedItem",i,true);i=C.byId(i);}if(!(i instanceof f)&&i!==null){return this;}if(!i){i=this.getDefaultSelectedItem();}this.setSelection(i);this.setValue(this._getSelectedItemText(i));this._oSelectionOnFocus=i;return this;};w.prototype.setSelectedItemId=function(i){i=this.validateProperty("selectedItemId",i);if(!i){i=this.getDefaultSelectedItem();}this.setSelection(i);this.setValue(this._getSelectedItemText());this._oSelectionOnFocus=this.getSelectedItem();return this;};w.prototype.setSelectedKey=function(e){e=this.validateProperty("selectedKey",e);var i=(e==="");if(!this.getForceSelection()&&i){this.setSelection(null);this.setValue("");return this;}var y=this.getItemByKey(e);if(y||i){if(!y&&i){y=this.getDefaultSelectedItem();}this.setSelection(y);this.setValue(this._getSelectedItemText(y));this._oSelectionOnFocus=y;return this;}return this.setProperty("selectedKey",e);};w.prototype.setValueState=function(e){var O=this.getValueState();if(e===O){return this;}this.setProperty("valueState",e);this._updatePickerAriaLabelledBy(e);if(this._isFocused()){this._announceValueStateText();}var i=this.getDomRefForValueState();if(!i){return this;}if(!this.isOpen()&&this.shouldValueStateMessageBeOpened()&&document.activeElement===i){this.openValueStateMessage();}else{this.closeValueStateMessage();}this._updatePickerValueStateContentText();this._updatePickerValueStateContentStyles();return this;};w.prototype.setValueStateText=function(e){this.setProperty("valueStateText",e);if(this.getDomRefForValueState()){this._updatePickerValueStateContentText();this._updatePickerValueStateContentStyles();}if(this._isFocused()){this._announceValueStateText();}return this;};w.prototype.getItemAt=function(i){return this.getItems()[+i]||null;};w.prototype.getSelectedItem=function(){var e=this.getAssociation("selectedItem");return(e===null)?null:C.byId(e)||null;};w.prototype.getFirstItem=function(){return this.getItems()[0]||null;};w.prototype.getLastItem=function(){var i=this.getItems();return i[i.length-1]||null;};w.prototype.getEnabledItems=function(i){var e=this.getList();return e?e.getEnabledItems(i):[];};w.prototype.getItemByKey=function(e){var i=this.getList();return i?i.getItemByKey(e):null;};w.prototype.removeItem=function(i){var e;i=this.removeAggregation("items",i);if(this.getItems().length===0){this.clearSelection();}else if(this.isItemSelected(i)){e=this.findFirstEnabledItem();if(e){this.setSelection(e);}}this.setValue(this._getSelectedItemText());if(i){i.detachEvent("_change",this.onItemChange,this);}return i;};w.prototype.removeAllItems=function(){var e=this.removeAllAggregation("items");this.setValue("");if(this._isShadowListRequired()){this.$().find(".sapMSelectListItemBase").remove();}for(var i=0;i<e.length;i++){e[i].detachEvent("_change",this.onItemChange,this);}return e;};w.prototype.destroyItems=function(){this.destroyAggregation("items");this.setValue("");if(this._isShadowListRequired()){this.$().find(".sapMSelectListItemBase").remove();}return this;};w.prototype.isOpen=function(){var e=this.getAggregation("picker");return!!(e&&e.isOpen());};w.prototype.close=function(){var e=this.getAggregation("picker");if(e){e.close();}return this;};w.prototype.getDomRefForValueState=function(){return this.getFocusDomRef();};w.prototype.getAccessibilityInfo=function(){var i=this._isIconOnly(),e={role:this.getRenderer().getAriaRole(this),focusable:this.getEnabled(),enabled:this.getEnabled(),readonly:i?undefined:this.getEnabled()&&!this.getEditable()};if(i){var y=this.getTooltip_AsString();if(!y){var z=b.getIconInfo(this.getIcon());y=z&&z.text?z.text:"";}e.type=C.getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_BUTTON");e.description=y;}else if(this.getType()==="Default"){e.type=C.getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_COMBO");e.description=this._getSelectedItemText();}return e;};w.prototype.getIdForLabel=function(){return this.getId()+"-hiddenSelect";};return w;});
