/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/ui/core/format/DateFormat','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/calendar/CalendarUtils','sap/ui/core/LocaleData','sap/ui/core/Locale','sap/ui/core/delegate/ItemNavigation','sap/ui/core/dnd/DragDropInfo','sap/ui/core/CustomData','sap/ui/events/KeyCodes','sap/base/Log','sap/ui/core/Core','./Link','./PlanningCalendarLegend','./SinglePlanningCalendarMonthGridRenderer'],function(C,D,c,d,L,e,I,f,g,K,h,l,m,P,S){"use strict";var A=1.5625;var n=1.5;var o=2.125;var p=1.75;var q=C.extend("sap.m.SinglePlanningCalendarMonthGrid",{metadata:{library:"sap.m",properties:{startDate:{type:"object",group:"Data"},enableAppointmentsDragAndDrop:{type:"boolean",group:"Misc",defaultValue:false}},aggregations:{appointments:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"appointment",dnd:{draggable:true}},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},_appsPlaceholders:{type:"sap.m.SinglePlanningCalendarMonthGrid._internal.IntervalPlaceholder",multiple:true,visibility:"hidden",dnd:{droppable:true}}},dnd:true,associations:{legend:{type:"sap.m.PlanningCalendarLegend",multiple:false}},events:{cellPress:{parameters:{startDate:{type:"object"},endDate:{type:"object"}}},moreLinkPress:{parameters:{date:{type:"object"}}},appointmentDrop:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},startDate:{type:"object"},endDate:{type:"object"},copy:{type:"boolean"}}}}}});q.prototype.init=function(){this._aLinks=[];this._handleMorePress=this._handleMorePress.bind(this);this._oDateFormat=D.getDateTimeInstance({pattern:"YYYYMMdd"});this._oFormatAriaApp=D.getDateTimeInstance({pattern:"EEEE dd/MM/YYYY 'at' HH:mm:ss a"});this._oFormatAriaFullDayCell=D.getDateTimeInstance({pattern:"EEEE dd/MM/YYYY"});this.setStartDate(new Date());this._configureAppointmentsDragAndDrop();};q.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}for(var i=0;i<this._aLinks.length;i++){if(this._aLinks[i]){this._aLinks[i].destroy();}}delete this._aLinks;};q.prototype.onBeforeRendering=function(){var s=this.getStartDate();this._oAppointmentsToRender=this._calculateAppointmentsNodes(s);this._createAppointmentsDndPlaceholders(s);};q.prototype.onAfterRendering=function(){this._initItemNavigation();};q.prototype._getColumns=function(){return 7;};q.prototype._getRows=function(){return 6;};q.prototype._getDateFormatter=function(){return this._oDateFormat;};q.prototype._getAppointmetsForADay=function(a){return this._oAppointmentsToRender.filter(function(b){return b.start.valueOf()===a.valueOf();});};q.prototype._getPreviousAppointmetsForADay=function(a){return this._oAppointmentsToRender.filter(function(b){return b.start.valueOf()<a.valueOf()&&b.end.valueOf()>=a.valueOf();}).map(function(b){var i={data:b.data,start:b.start,end:b.end,len:b.len,level:b.level,width:b.width};i.width-=d._daysBetween(a,b.start);i.hasPrevious=true;return i;},this);};q.prototype.ontap=function(E){this._fireSelectionEvent(E);};q.prototype.onkeydown=function(E){if(E.which===K.SPACE||E.which===K.ENTER){this._fireSelectionEvent(E);E.preventDefault();}};q.prototype._fireSelectionEvent=function(E){var t=E.srcControl,$=jQuery(E.target).eq(0),a=$.closest('.sapMSPCMonthDay').eq(0),i=$.length&&$[0].classList.contains("sapMLnk"),T,s,b;if(t&&t.isA("sap.m.SinglePlanningCalendarMonthGrid")&&a&&!i){T=parseInt(a.attr("sap-ui-date"));s=new Date(T);s=new Date(s.getFullYear(),s.getMonth(),s.getDate());b=new Date(s);b.setDate(b.getDate()+1);this.fireEvent("cellPress",{startDate:s,endDate:b});this.fireEvent("appointmentSelect",{appointment:undefined,appointments:this._toggleAppointmentSelection(undefined,true)});}else if(t&&t.isA("sap.ui.unified.CalendarAppointment")){this.fireEvent("appointmentSelect",{appointment:t,appointments:this._toggleAppointmentSelection(t,!(E.ctrlKey||E.metaKey))});}};q.prototype._toggleAppointmentSelection=function(a,R){var b=[],j,k,i;if(R){j=this.getAppointments();for(i=0,k=j.length;i<k;i++){if((!a||j[i].getId()!==a.getId())&&j[i].getSelected()){j[i].setProperty("selected",false,true);b.push(j[i]);jQuery('[data-sap-ui='+j[i].getId()+']').attr("aria-selected","false").find(".sapUiCalendarApp").removeClass("sapUiCalendarAppSel");}}}if(a){a.setProperty("selected",!a.getSelected(),true);b.push(a);jQuery('[data-sap-ui='+a.getId()+']').attr("aria-selected",a.getSelected()).find(".sapUiCalendarApp").toggleClass("sapUiCalendarAppSel",a.getSelected());}return b;};q.prototype._getMoreLink=function(a,b,i){var M=l.getLibraryResourceBundle("sap.m").getText("SPC_MORE_LINK",[a.toString()]),j=new m({text:M,press:this._handleMorePress}).addCustomData(new g({key:"date",value:b.valueOf().toString(),writeToDom:true}));if(this._aLinks[i]){this._aLinks[i].destroy();}this._aLinks[i]=j;return j;};q.prototype._handleMorePress=function(E){var t=parseInt(E.getSource().getCustomData()[0].getValue()),a=new Date(t);a=new Date(a.getFullYear(),a.getMonth(),a.getDate());this.fireEvent("moreLinkPress",{date:a});};q.prototype._getCoreLocaleData=function(){var s=l.getConfiguration().getFormatSettings().getFormatLocale().toString(),a=new e(s);return L.getInstance(a);};q.prototype._getCells=function(){return this._getVisibleDays(this.getStartDate());};q.prototype._getVerticalLabels=function(){var a=this._getVisibleDays(this.getStartDate()),b=this._getColumns(),R=[],s=l.getConfiguration().getFormatLocale().toString(),j=this._getCoreLocaleData();for(var i=0;i<this._getRows();i++){R.push(d.calculateWeekNumber(a[i*b].toUTCJSDate(),a[i*b].getYear(),s,j));}return R;};q.prototype._getVisibleDays=function(s){var a,b,j,k,F,t,v=[];if(!s){return v;}a=c.fromLocalJSDate(s);t=this._getCoreLocaleData().getFirstDayOfWeek();F=new c(a);F.setDate(1);k=F.getDay()-t;if(k<0){k=7+k;}if(k>0){F.setDate(1-k);}b=new c(F);for(var i=0;i<this._getColumns()*this._getRows();i++){j=new c(b);v.push(j);b.setDate(b.getDate()+1);}return v;};q.prototype._getAppointmentsToRender=function(){return this._oAppointmentsToRender;};q.prototype._calculateAppointmentsNodes=function(s){var v=this._getVisibleDays(s),F=v[0],t=v[v.length-1],u=this.getAppointments().filter(function(a){var b=a.getStartDate()&&a.getEndDate();if(!b){h.warning("Appointment "+a.getId()+" has no start or no end date. It is ignored.");}return b;}).map(function(a){var b=c.fromLocalJSDate(a.getStartDate()),z=c.fromLocalJSDate(a.getEndDate());return{data:a,start:b,end:z,len:d._daysBetween(z,b)};}).filter(function(a){return d._isBetween(a.start,F,t,true)||d._isBetween(a.end,F,t,true);}).sort(function compare(a,b){return a.start.valueOf()-b.start.valueOf();}),V=[],w,x,E,y,i,j,k;for(i=0;i<v.length;i++){V.push([]);}for(i=0;i<u.length;i++){w=u[i];x=d._daysBetween(w.start,v[0]);E=x+w.len;x=x>0?x:0;E=E<v.length?E:v.length-1;w.width=w.len+1;y=V[x].indexOf(true);if(y===-1){y=V[x].length;}w.level=y;for(j=x;j<=E;j++){V[j][y]=false;for(k=0;k<y;k++){if(V[j][k]===undefined){V[j][k]=true;}}}}this._aAppsLevelsPerDay=V;return u;};q.prototype._getMoreCountPerCell=function(a){var b=this._aAppsLevelsPerDay[a];var M=this._getMaxAppointments();var j=0;var s=0;if(b.length<=M){return 0;}for(var i=0;i<b.length;i++){if(!b[i]){j++;}if(i<M-1){s++;}}return j-s;};q.prototype._configureAppointmentsDragAndDrop=function(){this.addDragDropConfig(new f({sourceAggregation:"appointments",targetAggregation:"_appsPlaceholders",dragStart:function(E){if(!this.getEnableAppointmentsDragAndDrop()){E.preventDefault();return false;}var H=function(){var O=jQuery(".sapMSinglePCOverlay");setTimeout(function(){O.addClass("sapMSinglePCOverlayDragging");});jQuery(document).one("dragend",function(){O.removeClass("sapMSinglePCOverlayDragging");});};H();}.bind(this),dragEnter:function(E){var a=E.getParameter("dragSession"),b=function(){var i=jQuery(a.getIndicator());i.css("min-height",a.getDropControl().$().outerHeight());i.css("min-width",a.getDropControl().$().outerWidth());};if(!a.getIndicator()){setTimeout(b,0);}else{b();}},drop:function(E){var a=E.getParameter("dragSession"),b=a.getDragControl(),i=a.getDropControl(),j=i.getDate(),k=c.fromLocalJSDate(b.getStartDate()),s=c.fromLocalJSDate(b.getEndDate()),O=d._daysBetween(j,k),t=new c(k),u=new c(s),B=E.getParameter("browserEvent"),v=(B.metaKey||B.ctrlKey);t.setDate(t.getDate()+O);u.setDate(u.getDate()+O);this.$().find(".sapMSinglePCOverlay").removeClass("sapMSinglePCOverlayDragging");if(k.valueOf()===j.valueOf()){return;}this.fireAppointmentDrop({appointment:b,startDate:t.toLocalJSDate(),endDate:u.toLocalJSDate(),copy:v});}.bind(this)}));};q.prototype._initItemNavigation=function(){var R=this.getDomRef();this._aGridCells=this.$().find(".sapMSPCMonthDay").toArray();if(!this._oItemNavigation){this._oItemNavigation=new I();this.addDelegate(this._oItemNavigation);this._oItemNavigation.attachEvent(I.Events.BorderReached,this._itemNavigationBorderReached,this);}this._oItemNavigation.setRootDomRef(R);this._oItemNavigation.setItemDomRefs(this._aGridCells);this._oItemNavigation.setCycling(false);this._oItemNavigation.setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"],saphome:["alt","meta"],sapend:["meta"]});this._oItemNavigation.setTableMode(false).setColumns(this._getColumns(),true);this._oItemNavigation.setPageSize(this._aGridCells.length);};q.prototype._itemNavigationBorderReached=function(E){var G,F,i=E.getParameter("event"),O;if(i.target.classList.contains("sapMSPCMonthDay")){G=i.target;F=parseInt(G.getAttribute("sap-ui-date"));switch(i.keyCode){case K.ARROW_LEFT:O=-1;break;case K.ARROW_UP:O=-this._getColumns();break;case K.ARROW_RIGHT:O=1;break;case K.ARROW_DOWN:O=this._getColumns();break;default:break;}this.fireEvent("borderReached",{startDate:F,offset:O});}};q.prototype._createAppointmentsDndPlaceholders=function(s){var a=this._getVisibleDays(s);this.destroyAggregation("_appsPlaceholders");for(var i=0;i<a.length;i++){var b=new r({date:a[i]});this.addAggregation("_appsPlaceholders",b,true);}};var r=C.extend("sap.m.SinglePlanningCalendarMonthGrid._internal.IntervalPlaceholder",{metadata:{properties:{date:{type:"object",group:"Data"}}},renderer:function(R,a){R.write("<div");R.writeControlData(a);R.addClass("sapMSinglePCPlaceholder");R.writeClasses();R.write("></div>");}});q.prototype._getCellStartInfo=function(s){var a=l.getLibraryResourceBundle("sap.ui.unified").getText("CALENDAR_START_TIME");return a+": "+this._oFormatAriaFullDayCell.format(s)+"; ";};q.prototype._getAppointmentAnnouncementInfo=function(a){var u=l.getLibraryResourceBundle("sap.ui.unified"),s=u.getText("CALENDAR_START_TIME"),E=u.getText("CALENDAR_END_TIME"),F=this._oFormatAriaApp.format(a.getStartDate()),b=this._oFormatAriaApp.format(a.getEndDate()),i=s+": "+F+"; "+E+": "+b;return i+"; "+P.findLegendItemForItem(l.byId(this._sLegendId),a);};q.prototype._getMaxAppointments=function(){return this._isCompact()?4:3;};q.prototype._getDensitySizes=function(){return this._isCompact()?{appHeight:A,cellHeaderHeight:n}:{appHeight:o,cellHeaderHeight:p};};q.prototype._isCompact=function(){var a=this.getDomRef()||(this.getParent()&&this.getParent().getDomRef&&this.getParent().getDomRef()||(this.getParent()&&this.getParent().getRootNode&&this.getParent().getRootNode()));while(a&&a.classList){if(a.classList.contains("sapUiSizeCompact")){return true;}a=a.parentNode;}return false;};return q;});
