/*!
 * SAPUI5

        (c) Copyright 2009-2019 SAP SE. All rights reserved
    
 */
sap.ui.define(['sap/ui/thirdparty/jquery','./Calendar','./CalendarDate','./library','sap/ui/core/Control','sap/ui/core/theming/Parameters','sap/ui/core/date/UniversalDate','sap/m/Label','./OverlapCalendarRenderer','sap/base/Log','sap/ui/Device'],function(q,C,a,c,d,P,U,L,O,f,D){"use strict";var g=d.extend("sap.me.OverlapCalendar",{metadata:{library:"sap.me",properties:{startDate:{type:"string",group:"Data",defaultValue:null},weeksPerRow:{type:"int",group:"Appearance",defaultValue:2},firstDayOffset:{type:"int",group:"Appearance",defaultValue:0},showOverlapIndicator:{type:"boolean",group:"Appearance",defaultValue:false},visible:{type:"boolean",group:"Appearance",defaultValue:true},swipeToNavigate:{type:"boolean",group:"Behavior",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'}},aggregations:{calendarEvents:{type:"sap.me.OverlapCalendarEvent",multiple:true,singularName:"calendarEvent"},calendar:{type:"sap.me.Calendar",multiple:false,visibility:"hidden"},typeLabels:{type:"sap.m.Label",multiple:true,singularName:"typeLabel",visibility:"hidden"},nameLabels:{type:"sap.m.Label",multiple:true,singularName:"nameLabel",visibility:"hidden"}},events:{endOfData:{parameters:{before:{type:"boolean"}}},changeDate:{parameters:{firstDate:{type:"object"},lastDate:{type:"object"}}}}}});g.prototype.init=function(){this.setAggregation("calendar",new C({singleRow:true,weeksPerRow:this.getWeeksPerRow(),monthsPerRow:1,monthsToDisplay:1,dayWidth:48,dayHeight:48,swipeToNavigate:this.getSwipeToNavigate()}));this.getCalendar().attachChangeCurrentDate(this.onCurrentDateChanged,this);this._typeWithBgImages=["04","07"];this._oDaysOverlap={};this._bRtl=sap.ui.getCore().getConfiguration().getRTL();};g.prototype.onswiperight=function(e){if(this.getSwipeToNavigate()){this.getCalendar().onswiperight(e);}};g.prototype.onswipeleft=function(e){if(this.getSwipeToNavigate()){this.getCalendar().onswipeleft(e);}};g.prototype.setSwipeToNavigate=function(s){this.getCalendar().setSwipeToNavigate(s);this.setProperty("swipeToNavigate",s,true);return this;};g.prototype._getFirstDateDisplayed=function(){var F=this.getCalendar().getFirstDayOffset();var b=this._createDateInDays(this.getStartDate());var i=b.getDate();var e=b.getDay();b.setDate(1);var h=e+1-F;b.setDate(i-h+1);return b;};g.prototype._getLastDateDisplayed=function(){var w=this.getCalendar().getDays();var W=w.length;var i=this.getCalendar().getWeeksPerRow();var b=i*W;var e=this._getFirstDateDisplayed();var t=this._createDateInDays(e.getTime());t.setDate(t.getDate()+b-1);return t;};g.prototype.setWeeksPerRow=function(w){this.getCalendar().setWeeksPerRow(w);this.setProperty("weeksPerRow",w);return this;};g.prototype.getCalendar=function(){return this.getAggregation("calendar");};g._ctorSafeDate=function(b){var s=b;if(b instanceof U){s=b.getTime();}return s;};g._getJSDate=function(b){var j=b;if(b instanceof U){j=new Date(b.getTime());}return j;};g.prototype.setStartDate=function(s){var b=g._ctorSafeDate(s);this.getCalendar().setFirstDayOffset(0);this.getCalendar().setCurrentDate(b);this.setProperty("startDate",b);var o=this._getDaysOffset(this._createDateInDays(b),this._getFirstDateDisplayed());this.getCalendar().setFirstDayOffset(o);return this;};g.prototype.onCurrentDateChanged=function(e){this.setProperty("startDate",e.getParameter("currentDate"),true);this.getCalendar().invalidate();this._renderCalendarEvents();this.fireChangeDate({firstDate:g._getJSDate(this._getFirstDateDisplayed()),endDate:g._getJSDate(this._getLastDateDisplayed())});};g.prototype.onBeforeRendering=function(){this._cleanUp();this._aRows=[];this._lastDate=null;this._firstDate=null;var b=this.getCalendarEvents();q.each(b,q.proxy(this._parseCalendarEvent,this));};g.prototype.onAfterRendering=function(){this._renderCalendarEvents();D.resize.attachHandler(this._onResize,this);};g.prototype._onResize=function(){if(this._sDelayedResize){clearInterval(this._sDelayedResize);}this._sDelayedResize=setTimeout(this._fireRecomputeElementsSizes.bind(this),200);};g.prototype.exit=function(){this._cleanUp();};g.prototype._cleanUp=function(){D.resize.detachHandler(this._onResize,this);};g.prototype._fireRecomputeElementsSizes=function(){var o=this.$();var e=o.find(".sapMeOverlapCalendarHalfDay");q.merge(e,o.find(".sapMeOverlapCalendarRowLabels"));this._sizeElementsToParent(e);};g.prototype._getDayId=function(b){var e=this._createDateInDays(this._getFirstDateDisplayed());return this._getDaysOffset(e,this._createDateInDays(b));};g.prototype._cleanUpDivs=function(){var o=this.$();o.find(".sapMeOverlapCalendarDay").removeClass().addClass("sapMeOverlapCalendarDay");o.find(".sapMeOverlapCalendarHalfDay").remove();o.find(".sapMeOverlapCalendarDay.sapMeOverlapCalendarDayWithHalf").removeClass(".sapMeOverlapCalendarDayWithHalf");o.find(".sapMeOverlapCalendarOverlap").css("background-color","transparent").css("border","none");o.find(".sapMeOverlapCalendarTypeLbl").remove();};g.prototype._renderCalendarEvents=function(){var i;this._mHalfDays={};this._cleanUpDivs();this._oDaysOverlap={};var b=this.getCalendarEvents();q.each(b,q.proxy(this._renderCalendarEvent,this));q.each(this._mHalfDays,q.proxy(this._renderHalfDayCalendarEvent,this));if(this.getShowOverlapIndicator()){for(i in this._oDaysOverlap){if(this._oDaysOverlap[i]!=undefined&&this._oDaysOverlap[i]>1){var $=q(document.getElementById(this._provideId("overlap",i)));$.css("background-color",P.get("sapMeOverlapCalendarIndicator"));$.css("border-right","1px solid "+P.get("sapMeOverlapCalendarIndicator"));}}}if(this._firstDate&&this._lastDate){var e=this._getFirstDateDisplayed();e.setDate(e.getDate()+7);var h=this._getLastDateDisplayed();h.setDate(h.getDate()-7);if((this._dayIsBefore(this._lastDate,e))){this.fireEndOfData({before:false});}else if(this._dayIsAfter(this._firstDate,h)){this.fireEndOfData({before:true});}}};g.prototype._provideId=function(){var s=q.makeArray(arguments).join("-");return this.getId()+"-"+s;};g.prototype._addToDayOverlap=function(b){if(this._oDaysOverlap[b]==undefined){this._oDaysOverlap[b]=0;}this._oDaysOverlap[b]++;};g.prototype._getDaysOffset=function(b,s){return Math.abs(this._getRawDaysDifference(b,s));};g.prototype._getDaysDifference=function(b,s){return this._getRawDaysDifference(b,s);};g.prototype._getRawDaysDifference=function(b,s){var e=86400000;var h=b.getTime();var i=s.getTime();var j=h-i;return Math.round(j/e);};g.prototype._dayIsAfter=function(b,e){return(this._getDaysDifference(b,e)>0);};g.prototype._dayIsBefore=function(b,e){return(this._getDaysDifference(b,e)<0);};g.prototype._createDateInDays=function(b){var e=g._ctorSafeDate(b);var h=new Date(e);return a.createDate(h.getUTCFullYear(),h.getUTCMonth(),h.getUTCDate());};g.prototype._sizeElementsToParent=function(e){var b=(e!==null&&e.length)?e.length:0;var $,j;var i,w,h;for(i=0;i<b;i++){$=q(e[i]);if($){j=$.parent();w=j.width();h=j.height();$.width(w).height(h);}}};g.prototype._renderHalfDayCalendarEvent=function(k,h){var e=h[0];var $=q(document.getElementById(k));var t=e.getType();var b=this._typeWithBgImages.indexOf(t)>-1;$.addClass("sapMeOverlapCalendarDayWithHalf");var i=q("<div/>");i.addClass("sapMeOverlapCalendarHalfDay").addClass("sapMeOverlapCalendarType"+t+"HalfDayStart");$.append(i);var j=null;if(h.length>1){var l=h[1];var m=l.getType();j=q("<div/>");j.addClass("sapMeOverlapCalendarHalfDay").addClass("sapMeOverlapCalendarType"+m+"HalfDayEnd");}else if(b){j=q("<div/>");j.addClass("sapMeOverlapCalendarHalfDay").addClass("sapMeOverlapCalendarTypeHalfDayEnd");}if(j!==null){$.append(j);}this._sizeElementsToParent([i,j]);};g.prototype._defineFirstAndLastDates=function(s,e){if(this._lastDate==undefined){this._lastDate=e;}if(this._dayIsAfter(e,this._lastDate)){this._lastDate=e;}if(this._firstDate==undefined){this._firstDate=s;}if(this._dayIsBefore(s,this._firstDate)){this._firstDate=s;}};g.prototype._renderCalendarEvent=function(i,o){var s=this._createDateInDays(o.getStartDay());var e=this._createDateInDays(o.getEndDay());this._defineFirstAndLastDates(s,e);var b=this._getFirstDateDisplayed();var l=this._getLastDateDisplayed();if((!this._dayIsBefore(e,b))&&(!this._dayIsAfter(s,l))){var r=o.getRow();var h=this._dayIsAfter(s,b)?s:b;e=this._dayIsAfter(e,l)?l:e;var n=this._getDaysOffset(h,e)+1;var j=this._getDaysOffset(b,h);var k="sapMeOverlapCalendarType"+o.getType();var $;var m;if(o.getHalfDay()===true){m=this._getDayId(h);var p=this._provideId(r,m);if(this._mHalfDays[p]==undefined){this._mHalfDays[p]=[];$=q(document.getElementById(p));}this._mHalfDays[p].push(o);}else{while(!this._dayIsAfter(h,e)){m=this._getDayId(h);this._addToDayOverlap(m);$=q(document.getElementById(this._provideId(r,m)));$.addClass(k);h.setDate(h.getDate()+1);}}if($!=undefined){this._createEventLabel(o,h,n,j);}}};g.prototype._createEventLabel=function(o,b,n,e){var t=o.getTypeName();if(t&&t.length>0){var r=o.getRow();var l=this._provideId(r,this._getDayId(b));var h=this._provideId("row",r,"lbls");var $=q(document.getElementById(h));$.width(q(document.getElementById(this.getId())).width());var i=this._provideId("lbl",l);if(q(document.getElementById(i)).length===0){var j=q("<label dir='Inherit' id='"+i+"'>"+t+"</label>");$.append(j);j.addClass("sapMeOverlapCalendarTypeLbl sapMLabel");this._modifyLabel(j,n,e);}}};g.prototype._modifyLabel=function($,n,b){var e=(100/(this.getCalendar().getWeeksPerRow()*7));var w=(n*e);$.width(w+"%");var o=(b*e);var m=(b==0)?1:0.5;var l=o+"%";if(this._bRtl){$.css("right",l);$.css("padding-right",m+"rem");$.css("text-align","right");}else{$.css("left",l);$.css("padding-left",m+"rem");}};g.prototype._parseCalendarEvent=function(i,o){var r=o.getRow();if(r!=-1){if(o.getName()!=undefined){if(this._aRows[r]==undefined&&o.getName()!=""){this._aRows[r]=o.getName();}}else{f.debug("Calendar event has no name");}}else{f.debug("Invalid calendar event row");}};g.prototype._getLabelForRow=function(i){return this._getLabel(this._aRows[i],"nameLabels").addStyleClass("sapMeOverlapCalendarNameLbl");};g.prototype._getLabel=function(t,A){var l=new L({text:t});this.addAggregation(A,l,true);return l;};return g;},true);
