/*!
 * 
		SAP UI development toolkit for HTML5 (SAPUI5)
		(c) Copyright 2009-2015 SAP SE. All rights reserved
	
 */
sap.ui.define(["sap/ui/thirdparty/jquery",'./library','sap/m/library','sap/ui/base/ManagedObject','sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation','sap/m/ScrollContainer','sap/m/Button','sap/ui/core/delegate/ScrollEnablement','sap/ui/Device','sap/ui/core/ResizeHandler','./HeaderContainerRenderer'],function(q,l,M,a,C,I,S,B,b,D,R,H){"use strict";var c=C.extend("sap.suite.ui.commons.HeaderContainer",{metadata:{deprecated:true,interfaces:["sap.m.ObjectHeaderContainer"],library:"sap.suite.ui.commons",properties:{scrollStep:{type:"int",group:"Misc",defaultValue:300},scrollTime:{type:"int",group:"Misc",defaultValue:500},showDividers:{type:"boolean",group:"Misc",defaultValue:true},view:{type:"sap.suite.ui.commons.HeaderContainerView",group:"Misc",defaultValue:"Horizontal"},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Misc",defaultValue:"Transparent"}},aggregations:{scrollContainer:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},items:{type:"sap.ui.core.Control",multiple:true,singularName:"item"},buttonPrev:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},buttonNext:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}}});c.prototype.init=function(){this._iSelectedCell=0;this._bRtl=sap.ui.getCore().getConfiguration().getRTL();this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.suite.ui.commons");this._oScrollCntr=new S(this.getId()+"-scrl-cntnr",{width:"100%",horizontal:!D.system.desktop,height:"100%"});this.setAggregation("scrollContainer",this._oScrollCntr);if(D.system.desktop){this._oArrowPrev=new B({id:this.getId()+"-scrl-prev-button",tooltip:this._rb.getText("HEADERCONTAINER_BUTTON_PREV_SECTION"),press:function(e){e.cancelBubble();this._scroll(-this.getScrollStep(),this.getScrollTime());}.bind(this)}).addStyleClass("sapSuiteHdrCntrBtn").addStyleClass("sapSuiteHdrCntrLeft");this.setAggregation("buttonPrev",this._oArrowPrev);this._oArrowNext=new B({id:this.getId()+"-scrl-next-button",tooltip:this._rb.getText("HEADERCONTAINER_BUTTON_NEXT_SECTION"),press:function(e){e.cancelBubble();this._scroll(this.getScrollStep(),this.getScrollTime());}.bind(this)}).addStyleClass("sapSuiteHdrCntrBtn").addStyleClass("sapSuiteHdrCntrRight");this.setAggregation("buttonNext",this._oArrowNext);this._oScrollCntr.addDelegate({onAfterRendering:function(){if(D.system.desktop){var f=this.getId()+"-scrl-cntnr-scroll"?window.document.getElementById(this.getId()+"-scrl-cntnr-scroll"):null;var F=q(document.getElementById(this.getId()+"-scrl-cntnr-scroll"));var d=F.find(".sapSuiteHrdrCntrInner").attr("tabindex","0");if(!this._oItemNavigation){this._oItemNavigation=new I();this.addDelegate(this._oItemNavigation);this._oItemNavigation.attachEvent(I.Events.BorderReached,this._handleBorderReached,this);this._oItemNavigation.attachEvent(I.Events.AfterFocus,this._handleBorderReached,this);}this._oItemNavigation.setRootDomRef(f);this._oItemNavigation.setItemDomRefs(d);this._oItemNavigation.setTabIndex0();this._oItemNavigation.setCycling(false);}}.bind(this),onBeforeRendering:function(){if(D.system.desktop){this._oScrollCntr._oScroller=new b(this._oScrollCntr,this._oScrollCntr.getId()+"-scroll",{horizontal:true,vertical:true,zynga:false,preventDefault:false,nonTouchScrolling:true});}}.bind(this)});}};c.prototype._scroll=function(d,i){this.bScrollInProcess=true;setTimeout(function(){this.bScrollInProcess=false;}.bind(this),i+300);if(this.getView()==="Horizontal"){this._hScroll(d,i);}else{this._vScroll(d,i);}};c.prototype._vScroll=function(d,i){var o=this.getId()+"-scrl-cntnr"?window.document.getElementById(this.getId()+"-scrl-cntnr"):null;var s=o.scrollTop;var e=s+d;this._oScrollCntr.scrollTo(0,e,i);};c.prototype._hScroll=function(d,i){var o=this.getId()+"-scrl-cntnr"?window.document.getElementById(this.getId()+"-scrl-cntnr"):null;var s;if(!this._bRtl){var e=o.scrollLeft;s=e+d;this._oScrollCntr.scrollTo(s,0,i);}else{s=q(o).scrollRightRTL()+d;this._oScrollCntr.scrollTo((s>0)?s:0,0,i);}};c.prototype._checkOverflow=function(){if(this.getView()==="Horizontal"){this._checkHOverflow();}else{this._checkVOverflow();}};c.prototype._checkVOverflow=function(){var o=this._oScrollCntr.getDomRef();var s=false;if(o){if(o.scrollHeight>o.clientHeight){s=true;}}this._lastVScrolling=s;if(o){var i=o.scrollTop;var d=false;var e=false;var r=o.scrollHeight;var f=o.clientHeight;if(Math.abs(r-f)===1){r=f;}if(i>0){d=true;}if((r>f)&&(i+f<r)){e=true;}if(!d){this._oArrowPrev.$().hide();}else{this._oArrowPrev.$().show();}if(!e){this._oArrowNext.$().hide();}else{this._oArrowNext.$().show();}}};c.prototype._checkHOverflow=function(){var o=this._oScrollCntr.getDomRef();var d=this.$("scroll-area");var s=false;if(o){if(o.scrollWidth-5>o.clientWidth){s=true;}}this._lastScrolling=s;if(o){var i=o.scrollLeft;var e=false;var f=false;var r=o.scrollWidth;var g=o.clientWidth;if(Math.abs(r-g)===1){r=g;}if(this._bRtl){var h=q(o).scrollLeftRTL();if(h>(D.browser.msie?1:0)){f=true;}}else if(i>1){e=true;}var j=function(){var p=parseFloat(d.css("padding-right"));return D.browser.msie?p+1:p;};if(r-5>g){if(this._bRtl){if(q(o).scrollRightRTL()>1){e=true;}}else if(Math.abs(i+g-r)>j()){f=true;}}var O=this._oArrowPrev.$().is(":visible");if(O&&!e){this._oArrowPrev.$().hide();}if(!O&&e){this._oArrowPrev.$().show();}var k=this._oArrowNext.$().is(":visible");if(k&&!f){this._oArrowNext.$().hide();}if(!k&&f){this._oArrowNext.$().show();}}};c.prototype._handleBorderReached=function(o){if(D.browser.msie&&this.bScrollInProcess){return;}var i=o.getParameter("index");if(i===0){this._scroll(-this.getScrollStep(),this.getScrollTime());}else if(i===this.getItems().length-1){this._scroll(this.getScrollStep(),this.getScrollTime());}};c.prototype.addItem=function(i,s){this._oScrollCntr.addContent(i.addStyleClass("sapSuiteHrdrCntrInner"),s);return this;};c.prototype.insertItem=function(i,d,s){this._oScrollCntr.insertContent(i.addStyleClass("sapSuiteHrdrCntrInner"),d,s);return this;};c.prototype._callMethodInManagedObject=function(f,A){var d=Array.prototype.slice.call(arguments);if(A==="items"){d[1]="content";return this._oScrollCntr[f].apply(this._oScrollCntr,d.slice(1));}else{return a.prototype[f].apply(this,d.slice(1));}};c.prototype.onBeforeRendering=function(){if(D.system.desktop){sap.ui.getCore().attachIntervalTimer(this._checkOverflow,this);this._oArrowPrev.setIcon(this.getView()==="Horizontal"?"sap-icon://navigation-left-arrow":"sap-icon://navigation-up-arrow");this._oArrowNext.setIcon(this.getView()==="Horizontal"?"sap-icon://navigation-right-arrow":"sap-icon://navigation-down-arrow");this.$().unbind("click",this.handleSwipe);}};c.prototype.onAfterRendering=function(){q(document.getElementById(this.getId()+"-scrl-next-button")).attr("tabindex","-1");q(document.getElementById(this.getId()+"-scrl-prev-button")).attr("tabindex","-1");if(D.system.desktop){this.$().bind("swipe",q.proxy(this.handleSwipe,this));}};c.prototype.handleSwipe=function(e){e.preventDefault();e.stopPropagation();this._isDragEvent=true;};c.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();}if(this._sScrollResizeHandlerId){R.deregister(this._sScrollResizeHandlerId);}};c.prototype.onclick=function(e){if(this._isDragEvent){e.preventDefault();e.stopPropagation();this._isDragEvent=false;}};c.prototype.setView=function(v){this.setProperty("view",v,true);if(v===l.HeaderContainerView.Horizontal&&!D.system.desktop){this._oScrollCntr.setHorizontal(true);this._oScrollCntr.setVertical(false);}else if(!D.system.desktop){this._oScrollCntr.setHorizontal(false);this._oScrollCntr.setVertical(true);}return this;};c.prototype.validateAggregation=function(A,o,m){return this._callMethodInManagedObject("validateAggregation",A,o,m);};c.prototype.getAggregation=function(A,o,s){return this._callMethodInManagedObject("getAggregation",A,o,s);};c.prototype.setAggregation=function(A,o,s){this._callMethodInManagedObject("setAggregation",A,o,s);return this;};c.prototype.indexOfAggregation=function(A,o){return this._callMethodInManagedObject("indexOfAggregation",A,o);};c.prototype.insertAggregation=function(A,o,i,s){this._callMethodInManagedObject("insertAggregation",A,o,i,s);return this;};c.prototype.addAggregation=function(A,o,s){this._callMethodInManagedObject("addAggregation",A,o,s);return this;};c.prototype.removeAggregation=function(A,o,s){return this._callMethodInManagedObject("removeAggregation",A,o,s);};c.prototype.removeAllAggregation=function(A,s){return this._callMethodInManagedObject("removeAllAggregation",A,s);};c.prototype.destroyAggregation=function(A,s){this._callMethodInManagedObject("destroyAggregation",A,s);return this;};c.prototype._getParentCell=function(d){return q(d).parents(".sapSuiteHrdrCntrInner").addBack(".sapSuiteHrdrCntrInner").get(0);};c.prototype.onsaptabnext=function(e){this._iSelectedCell=this._oItemNavigation.getFocusedIndex();var f=this.$().find(":focusable");var t=f.index(e.target);var n=f.eq(t+1).get(0);var F=this._getParentCell(e.target);var T;if(n){T=this._getParentCell(n);}if(F&&T&&F.id!==T.id||n&&n.id===this.getId()+"-after"){var L=f.last().get(0);if(L){this._bIgnoreFocusIn=true;L.focus();}}};c.prototype.onsaptabprevious=function(e){var f=this.$().find(":focusable");var t=f.index(e.target);var p=f.eq(t-1).get(0);var F=this._getParentCell(e.target);this._iSelectedCell=this._oItemNavigation.getFocusedIndex();var T;if(p){T=this._getParentCell(p);}if(!T||F&&F.id!==T.id){var s=this.$().attr("tabindex");this.$().attr("tabindex","0");this.$().focus();if(!s){this.$().removeAttr("tabindex");}else{this.$().attr("tabindex",s);}}};c.prototype.onfocusin=function(e){if(this._bIgnoreFocusIn){this._bIgnoreFocusIn=false;return;}if(e.target.id===this.getId()+"-after"){this._restoreLastFocused();}};c.prototype._restoreLastFocused=function(){if(!this._oItemNavigation){return;}var n=this._oItemNavigation.getItemDomRefs();var L=this._oItemNavigation.getFocusedIndex();var $=q(n[L]);var r=$.control(0)||{};var t=r.getTabbables?r.getTabbables():$.find(":sapTabbable");t.eq(-1).add($).eq(-1).focus();};return c;});
