/*!
 * 
		SAP UI development toolkit for HTML5 (SAPUI5)
		(c) Copyright 2009-2015 SAP SE. All rights reserved
	
 */
sap.ui.define(["sap/ui/thirdparty/jquery",'sap/ui/commons/library','sap/ui/ux3/library','sap/ui/commons/Link','sap/ui/commons/MessageBox','sap/ui/core/Control','sap/ui/core/format/DateFormat','sap/ui/ux3/OverlayContainer','sap/ui/commons/Button','sap/ui/core/ListItem','sap/ui/commons/layout/VerticalLayout','sap/ui/commons/layout/HorizontalLayout','sap/ui/layout/HorizontalLayout','sap/ui/core/HTML','sap/ui/commons/TextField','sap/ui/commons/InPlaceEdit','sap/ui/commons/Label','sap/ui/commons/ListBox','sap/ui/commons/TextArea',"sap/base/security/encodeXML","sap/base/security/URLWhitelist","./NoteTakerCardRenderer"],function(q,C,U,L,M,b,D,O,B,c,V,d,f,H,T,I,g,h,j,k,l,N){"use strict";var m=b.extend("sap.suite.ui.commons.NoteTakerCard",{metadata:{deprecated:true,library:"sap.suite.ui.commons",properties:{header:{type:"string",group:"Misc",defaultValue:null},body:{type:"string",group:"Misc",defaultValue:null},timestamp:{type:"object",group:"Misc",defaultValue:new Date()},tags:{type:"object",group:"Misc",defaultValue:[]},viewAllTrigger:{type:"int",group:"Misc",defaultValue:1800},uid:{type:"string",group:"Misc",defaultValue:null},isFiltered:{type:"boolean",group:"Misc",defaultValue:false},thumbUp:{type:"boolean",group:"Misc",defaultValue:null},thumbDown:{type:"boolean",group:"Misc",defaultValue:null},allTags:{type:"object",group:"Misc",defaultValue:[]},attachmentFilename:{type:"string",group:"Misc",defaultValue:null},attachmentUrl:{type:"string",group:"Misc",defaultValue:null}},events:{editNote:{parameters:{title:{type:"string"},body:{type:"string"},timestamp:{type:"string"},uid:{type:"string"},thumbUp:{type:"boolean"},thumbDown:{type:"boolean"},tags:{type:"object"}}},deleteNote:{parameters:{cardId:{type:"string"},title:{type:"string"},body:{type:"string"},timestamp:{type:"string"},uid:{type:"string"},thumbUp:{type:"boolean"},thumbDown:{type:"boolean"}}},attachmentClick:{parameters:{uid:{type:"string"},url:{type:"string"},filename:{type:"string"}}}}}});m.prototype.init=function(){this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.suite.ui.commons");var t=this;this._oEditButton=new B({id:this.getId()+"-edit-button",press:function(e){t._handleEdit();},tooltip:this._rb.getText("NOTETAKERCARD_BUTTON_OPEN_EDIT_TOOLTIP")});this._oEditButton.addStyleClass("sapSuiteUiCommonsNoteTakerCardEditButton");this._oDeleteButton=new B({id:this.getId()+"-delete-button",tooltip:this._rb.getText("NOTETAKERCARD_BUTTON_DELETE_TOOLTIP"),press:function(){t._handleDelete();}});this._oDeleteButton.addStyleClass("sapSuiteUiCommonsNoteTakerCardDeleteButton");this._oViewAllLink=new L({id:this.getId()+"-viewAll-link",text:this._rb.getText("NOTETAKERCARD_LINK_VIEW_ALL_TEXT"),tooltip:this._rb.getText("NOTETAKERCARD_LINK_VIEW_ALL_TOOLTIP"),press:function(){t._openOverlay();}});this._oOverlayCard=new O(this.getId()+"-overlay",{openButtonVisible:false,close:function(e){t._handleOverlayCloseEvent(e.getSource());e.preventDefault();}});this._oOverlayCard.addDelegate({onAfterRendering:function(){var o=q(document.getElementById(t.getId()+"-overlayTimestamp"));if(o){o.html(t.getFormattedTimestamp());}}});this._oOverlayCard._superOnsapselect=this._oOverlayCard.onsapselect;this._oOverlayCard.onsapselect=function(e){var a=e.srcControl.getId();if(a.indexOf("-overlayBody")<0&&a.indexOf("-inputTag")<0&&a.indexOf("-overlayCardTitle")<0){e.stopPropagation();e.preventDefault();}setTimeout(function(){t._oOverlayCard._superOnsapselect(e);},10);};this._oOverlayCard.addStyleClass("sapSuiteCommonsNoteTakerCardOverlayWindow");this._oOverlayCard._tagControls={};};m.prototype.exit=function(){this._oDeleteButton.destroy();this._oDeleteButton=null;this._oEditButton.destroy();this._oEditButton=null;this._oViewAllLink.destroy();this._oViewAllLink=null;this._oOverlayCard.destroy();this._oOverlayCard=null;};m.prototype.getFormattedTimestamp=function(){var o=sap.ui.getCore().getConfiguration().getLocale();var a=D.getDateTimeInstance({style:"medium"},o);return a.format(this.getTimestamp());};m.prototype._handleOverlayCloseEvent=function(o){if(o.bEditMode){var t=this;M.show(this._rb.getText("NOTETAKERCARD_CONFIRMATION_CANCEL_EDIT_MESSAGE"),M.Icon.QUESTION,this._rb.getText("NOTETAKERCARD_CONFIRMATION_CANCEL_EDIT_TITLE"),[M.Action.YES,M.Action.NO],function(r){if(r===M.Action.YES){t._closeOverlay();t._oEditButton.focus();}else{if(t.getId()+"-overlayBody"?window.document.getElementById(t.getId()+"-overlayBody"):null){(t.getId()+"-overlayBody"?window.document.getElementById(t.getId()+"-overlayBody"):null).focus();}}},M.Action.NO);}else{this._closeOverlay();}};m.prototype._closeOverlay=function(){this._oOverlayCard.close();this._destroyTagControls();this._oOverlayCard.bEditMode=false;this._oOverlayCard.destroyContent();};m.prototype._openOverlay=function(e){var i;if(!this._oOverlayCard.isOpen()){this._oOverlayCard.bThumbUp=this.getThumbUp();this._oOverlayCard.bThumbDown=this.getThumbDown();this._prepareOverlayLayouts();this._prepareOverlayToolbar(e);this._prepareOverlayHeaderBtns(e);this._prepareOverlayBody();this._prepareOverlayButtons(e);if(e){i=this.getId()+"-overlayBody";}else{i=this.getId()+"-overlay-close";}this._oOverlayCard.open(i);q(document.getElementById(this.getId()+"-overlay-thumb-down-button")).attr("aria-pressed",this.getThumbDown());q(document.getElementById(this.getId()+"-overlay-thumb-up-button")).attr("aria-pressed",this.getThumbUp());}};m.prototype._getFormattedBody=function(){var a=[];var t=this.getBody();var p;do{p=t.search(/[\s<>]/);var s="",w="";if(p<0){w=t;}else{w=t.slice(0,p);s=t.slice(p,p+1);t=t.slice(p+1);}switch(true){case(this._isFullUrl(w)):this.wrapFullUrl(a,w,s);break;case(this._isShortUrl(w)):this._wrapShortUrl(a,w,s);break;case(this._isEmail(w)):this._wrapEmail(a,w,s);break;default:a.push(k(w+s));}}while(p>=0);return a.join("");};m.prototype._isFullUrl=function(w){return/^(https?|ftp):\/\//i.test(w)&&l.validate(w);};m.prototype._isShortUrl=function(w){return/^(www\.)/i.test(w)&&l.validate("http://"+w);};m.prototype._isEmail=function(w){return/^[\w\.=-]+@[\w\.-]+\.[\w]{2,5}$/.test(w);};m.prototype.wrapFullUrl=function(a,w,s){a.push('<a class="sapUiLnk" ');a.push('href = '+'"'+k(w)+'"');a.push(' target = "_blank" rel="noopener noreferrer"');a.push('>');a.push(k(w));a.push('</a>'+s);};m.prototype._wrapShortUrl=function(a,w,s){a.push('<a class="sapUiLnk" ');a.push('href = '+'"'+k("http://"+w)+'"');a.push(' target = "_blank" rel="noopener noreferrer"');a.push('>');a.push(k(w));a.push('</a>'+s);};m.prototype._wrapEmail=function(a,w,s){a.push('<a class="sapUiLnk" ');a.push('href = "mailto:'+k(w)+'"');a.push('>');a.push(k(w));a.push('</a>'+s);};m.prototype._wrapBodyToDiv=function(t){return"<div class='sapSuiteUiCommonsNoteTakerCardBody'>"+t+"</div>";};m.prototype._wrapTagPanelToDiv=function(t,e){if(e){return"<div class='suiteUiNtcOverlayTagPanelEditMode'>"+t+"</div>";}else{return"<div class='suiteUiNtcOverlayTagPanelViewMode'>"+t+"</div>";}};m.prototype._handleEdit=function(){this._openOverlay(true);};m.prototype._getFormattedTags=function(){var a=[];var t;if(this._oOverlayCard.isOpen()){t=this._oOverlayCard._selectedTags;}else{t=this.getTags();}a.push("<div id='"+this.getId()+"-tag-list' class='sapSuiteUiCommonsNoteTakerCardTagList'>");if(t.length===0){a.push(this._rb.getText("NOTETAKERCARD_LABEL_TAGS_EMPTY"));}else{a.push(this._rb.getText("NOTETAKERCARD_LABEL_TAGS_FULL")+": ");var s=k(t.sort().join(" "));a.push("<span title='"+s+"'>");a.push(s);a.push("</span>");}a.push("</div>");return a.join("");};m.prototype._handleDelete=function(a){var t=this;M.show(this._rb.getText("NOTETAKERCARD_CONFIRMATION_DELETE_MESSAGE"),M.Icon.QUESTION,this._rb.getText("NOTETAKERCARD_CONFIRMATION_DELETE_TITLE"),[M.Action.YES,M.Action.NO],function(r){if(r===M.Action.YES){if(a){t._closeOverlay();}t._handleDeleteClick();}},M.Action.NO);};m.prototype._handleDeleteClick=function(){var e={};e.uid=this.getUid();e.cardId=this.getId();e.title=this.getHeader();e.timestamp=this.getTimestamp();e.body=this.getBody();e.thumbUp=this.getThumbUp();e.thumbDown=this.getThumbDown();this.fireDeleteNote(e);};m.prototype.setUid=function(u){this.setProperty("uid",u,true);return this;};m.prototype._wrapThumbToDiv=function(i){var s=null;var t=null;if(this.getThumbUp()&&!this.getThumbDown()){s="sapSuiteUiCommonsNoteTakerCardThumbUp";t=this._rb.getText("NOTETAKERCARD_ICON_THUMB_UP_TOOLTIP");this._oOverlayCard.removeStyleClass("suiteUiNtcNegativeCard");this._oOverlayCard.addStyleClass("suiteUiNtcPositiveCard");}else if(!this.getThumbUp()&&this.getThumbDown()){s="sapSuiteUiCommonsNoteTakerCardThumbDown";t=this._rb.getText("NOTETAKERCARD_ICON_THUMB_DOWN_TOOLTIP");this._oOverlayCard.removeStyleClass("suiteUiNtcPositiveCard");this._oOverlayCard.addStyleClass("suiteUiNtcNegativeCard");}else{this._oOverlayCard.removeStyleClass("suiteUiNtcPositiveCard");this._oOverlayCard.removeStyleClass("suiteUiNtcNegativeCard");}var a=[];a.push("<div");if(i){a.push(" id='");a.push(i);a.push("'");}if(s){a.push(" class='");a.push(s);a.push("'");a.push(" title='");a.push(t);a.push("'");}a.push("></div>");return a.join("");};m.prototype._handleAddTag=function(t){this._oOverlayCard._selectedTags=[];var n=t.split(new RegExp("\\s+"));var o={};for(var i=0;i<n.length;i++){if(n[i].length!==0){o[n[i]]=0;}}for(var a in o){this._oOverlayCard._selectedTags.push(a);}var e=sap.ui.getCore().byId(this.getId()+'-overlayTagPanel');e.setContent(this._wrapTagPanelToDiv(this._getFormattedTags(),true));this._adjustTagButton();};m.prototype._adjustTagButton=function(){var t=this._oOverlayCard._tagControls.tagButton;if(this._oOverlayCard._selectedTags.length){t.addStyleClass("sapSuiteUiCommonsNoteTakerFeederButtonSelected");}else{t.removeStyleClass("sapSuiteUiCommonsNoteTakerFeederButtonSelected");}};m.prototype._toggleTagPopup=function(){var s=this._oOverlayCard._selectedTags;if(this._bTagPopupOpen){q(document.getElementById(this.getId()+"-selectTag-panel")).slideToggle();this._focusDefaultControl();this._bTagPopupOpen=false;}else{this._addTagsToListBox(this.getAllTags());q(document.getElementById(this.getId()+"-selectTag-panel")).slideToggle();q(document.getElementById(this.getId()+"-inputTag")).val(s.length===0?"":s.join(" ")+" ");this._oOverlayCard._tagControls.tagInput.focus();this._bTagPopupOpen=true;}};m.prototype._focusDefaultControl=function(){this._oOverlayCard._tagControls.tagButton.focus();};m.prototype._handleTagInputLive=function(e){var s=e.getParameter("liveValue");var n=s.split(" ");var a=n[n.length-1];this._filterListBox(a);};m.prototype._filterListBox=function(i){if(i.length===0){this._addTagsToListBox(this.getAllTags());return;}var F=q.grep(this.getAllTags(),function(a){if(a.indexOf(i)>=0){return true;}});this._addTagsToListBox(F);};m.prototype._addTagsToListBox=function(t){var a=q.map(t,function(v,i){return new c({text:v});});this._oOverlayCard._tagControls.tagList.setItems(a,true);this._oOverlayCard._tagControls.tagList.rerender();};m.prototype._handleListSelect=function(e){var s=e.getParameter("selectedItem").getText();var t=this._oOverlayCard._tagControls.tagInput;var a=t.getValue();var n=a.split(" ");n.pop();if(n.length===0){t.setValue(s+" ");}else{t.setValue(n.join(" ")+" "+s+" ");}this._oOverlayCard._tagControls.tagList.setSelectedIndex(-1);t.focus();};m.prototype._destroyTagControls=function(){var t=this._oOverlayCard._tagControls;for(var a in t){t[a].destroy();}this._oOverlayCard._tagControls={};};m.prototype._createTagSelectorControl=function(){var t=this._oOverlayCard._tagControls;var o=new V({id:this.getId()+"-selectTag-panel"});o.addStyleClass("sapSuiteUiCommonsNoteTakerFeederSelectTagPanel");o.addStyleClass("sapUiShd");t.tagSelectorLayout=o;o.addContent(new H(this.getId()+"-selectTag-arrow",{content:"<div class='sapSuiteUiCommonsNoteTakerFeederSelectTagArrow' ></div>"}));o.addContent(new H(this.getId()+"-selectTag-header",{content:["<div class='sapSuiteUiCommonsNoteTakerFeederSelectTagHeader' >",this._rb.getText("NOTETAKERFEEDER_TOOLPOPUP_TITLE"),"</div>"].join("")}));o.addContent(t.tagInput);o.addContent(t.tagList);var a=new d();a.addStyleClass("sapSuiteUiCommonsNoteTakerFeederSelectTagButtons");a.addContent(t.tagApplyBtn);a.addContent(t.tagCancelBtn);o.addContent(a);return o;};m.prototype._prepareAttachmentPanel=function(i){var s=i?"-overlay":"";var a=i?"Overlay":"";var e=[this.getId(),s,"-attachmentPanel"].join("");var o=sap.ui.getCore().byId(e);if(o){o.destroy();}var A=new d(e);A.addStyleClass(["suiteUiNtc",a,"AttachmentPanel"].join(""));A.addContent(new H({content:"<div class='suiteUiNtcAttachmentIcon'></div>"}));var n=new L({id:[this.getId(),s,"-attachmentLink"].join(""),text:this.getAttachmentFilename(),tooltip:this._rb.getText("NOTETAKERCARD_LINK_ATTACHMENT_TOOLTIP"),press:this._handleAttachmentDownload,href:this.getAttachmentUrl()});n._ntc=this;A.addContent(n);return A;};m.prototype._prepareOverlayLayouts=function(){var t=new V();var o=new V();o.addStyleClass("sapSuiteUiCommonsNtcOverlayTitle");var a=new d();a.addStyleClass("sapSuiteUiCommonsNtcHeaderButtons");var e=new d(this.getId()+'-overlayHeader',{content:[o,a]});e.addStyleClass("sapSuiteUiCommonsNtcOverlayHeader");t.addContent(e);var i=new d(this.getId()+'-overlayToolbar');i.addStyleClass("suiteUiNtcToolbar");var n=new d();n.addStyleClass("suiteUiNtcOverlayToolbarLeftPanel");var p=new d();p.addStyleClass("suiteUiNtcOverlayToolbarRightPanel");i.addContent(n);i.addContent(p);t.addContent(i);this._oOverlayCard.addContent(t);var r=new f();r.addStyleClass("sapSuiteUiCommonsNoteTakerCardContent");var s=new d(this.getId()+"-buttons");s.addStyleClass("sapSuiteUiCommonsNoteTakerCardOverlayButtonPanel");this._oOverlayCard.layouts={topSection:t,headerLeft:o,headerRight:a,toolbar:i,toolbarLeft:n,toolbarRight:p,body:r,buttons:s};};m.prototype._prepareOverlayHeaderBtns=function(e){var t=this;var E=new B(this.getId()+"-editButton",{tooltip:this._rb.getText("NOTETAKERCARD_BUTTON_EDIT_TOOLTIP"),press:function(){t._fnEdit();}});t._oOverlayCard.layouts.headerRight.addContent(E,0);if(e){E.setEnabled(false);E.addStyleClass("sapSuiteUiCommonsNoteTakerCardEditButtonDsbl");}else{E.setEnabled(true);E.addStyleClass("sapSuiteUiCommonsNoteTakerCardEditButton");}var o=new B(this.getId()+"-deleteButton",{tooltip:this._rb.getText("NOTETAKERCARD_BUTTON_DELETE_TOOLTIP"),press:function(){t._handleDelete(true);}});o.addStyleClass("sapSuiteUiCommonsNoteTakerCardDeleteButton");t._oOverlayCard.layouts.headerRight.addContent(o,1);var a=new g(this.getId()+"-overlayTimestamp",{text:t.getFormattedTimestamp()});a.addStyleClass("sapSuiteUiCommonsNoteTakerCardTimestamp");t._oOverlayCard.layouts.headerLeft.addContent(a,1);};m.prototype._prepareOverlayToolbar=function(e){this._oOverlayCard._selectedTags=this.getTags();if(this.getAttachmentFilename()!==""){var a=this._prepareAttachmentPanel(true);this._oOverlayCard.layouts.topSection.addContent(a);this._oOverlayCard.layouts.body.addStyleClass("suiteUiNtcOverlayWithAttachment");}else{this._oOverlayCard.layouts.body.addStyleClass("suiteUiNtcOverlayWithoutAttachment");}};m.prototype._prepareOverlayBody=function(){this._oOverlayCard.addContent(this._oOverlayCard.layouts.body);};m.prototype._prepareOverlayButtons=function(e){var t=this;var o=new B(this.getId()+"-closeButton",{text:this._rb.getText("NOTETAKERCARD_BUTTON_CLOSE_OVERLAY"),tooltip:this._rb.getText("NOTETAKERCARD_BUTTON_CLOSE_OVERLAY_TOOLTIP"),press:function(){t._handleOverlayCloseEvent(t._oOverlayCard);}});o.addStyleClass("sapSuiteUiCommonsNoteTakerCardOverlayButtonClose");var s=new B(this.getId()+"-saveButton",{text:this._rb.getText("NOTETAKERCARD_BUTTON_SAVE_TEXT"),tooltip:this._rb.getText("NOTETAKERCARD_BUTTON_SAVE_TOOLTIP"),press:function(){t._fnSave();}});s.addStyleClass("sapSuiteUiCommonsNoteTakerCardOverlayButtonSave");t._oOverlayCard.layouts.buttons.addContent(o,0);t._oOverlayCard.layouts.buttons.addContent(s,1);if(e){s.setEnabled(true);this._fnCreateInEditMode();}else{s.setEnabled(false);this._fnCreateInViewMode();}this._oOverlayCard.addContent(this._oOverlayCard.layouts.buttons);};m.prototype._fnCreateInViewMode=function(){var t=this;t._oOverlayCard.bEditMode=false;var o=new g(t.getId()+"-overlayCardHeader",{text:t.getHeader()});o.addStyleClass("sapSuiteUiCommonsNoteTakerCardTitle");t._oOverlayCard.layouts.headerLeft.insertContent(o,0);var a=new H(t.getId()+'-overlayTagPanel');a.setContent(t._wrapTagPanelToDiv(t._getFormattedTags(),t._oOverlayCard.bEditMode));t._oOverlayCard.layouts.toolbarLeft.addContent(a);var e=new H({id:t.getId()+"-overlay-thumb",content:t._wrapThumbToDiv()});t._oOverlayCard.layouts.toolbarRight.addContent(e);var i=new H(t.getId()+"-overlayBody");i.setContent(t._wrapBodyToDiv(t._getFormattedBody()));i.addStyleClass("sapSuiteUiCommonsNoteTakerCardBody");t._oOverlayCard.layouts.body.addContent(i);var s=t._oOverlayCard.layouts.buttons.getContent()[1];s.setEnabled(false);var E=t._oOverlayCard.layouts.headerRight.getContent()[0];E.setEnabled(true);E.removeStyleClass("sapSuiteUiCommonsNoteTakerCardEditButtonDsbl");E.addStyleClass("sapSuiteUiCommonsNoteTakerCardEditButton");};m.prototype._fnCreateInEditMode=function(){var t=this;t._oOverlayCard.bEditMode=true;var o=new T(t.getId()+"-overlayCardTitle",{maxLength:50});o.setValue(t.getHeader());o.addStyleClass("sapSuiteUiCommonsNoteTakerCardTitle");var a=new I(t.getId()+"-overlayCardTitleEdit",{content:o,tooltip:t._rb.getText("NOTETAKERCARD_EDITFIELD_TITLE_TOOLTIP"),design:C.TextViewDesign.H2,undoEnabled:false});a.addStyleClass("sapSuiteUiCommonsNtcdTitleEdit");t._oOverlayCard.layouts.headerLeft.insertContent(a,0);var i=new H(t.getId()+'-overlayTagPanel');i.setContent(t._wrapTagPanelToDiv(t._getFormattedTags(),t._oOverlayCard.bEditMode));t._oOverlayCard.layouts.toolbarLeft.addContent(i);var n=new B({id:t.getId()+"-tag-button",tooltip:t._rb.getText("NOTETAKERCARD_BUTTON_TAG_TOOLTIP"),press:function(){t._toggleTagPopup();}});n.addStyleClass("sapSuiteUiCommonsNoteTakerFeederTagButton");var p=new h({id:t.getId()+"-tagListBox",visibleItems:10,width:"100%",height:"194px",select:function(e){t._handleListSelect(e);}});var r=new T({id:t.getId()+"-inputTag",liveChange:function(e){t._handleTagInputLive(e);}});r.onsapdown=function(e){e.preventDefault();e.stopPropagation();q("#"+t.getId()+"-tagListBox li:eq(0)").focus();};var s=new B({id:t.getId()+"-cancel-tags-button",text:t._rb.getText("NOTETAKERFEEDER_BUTTON_CANCEL_TAGS"),tooltip:t._rb.getText("NOTETAKERFEEDER_BUTTON_CANCEL_TAGS_TOOLTIP"),press:function(){t._toggleTagPopup();}});s.addStyleClass("sapSuiteUiCommonsNoteTakerFeederCancelTagButton");var A=new B({id:t.getId()+"-add-tags-button",text:t._rb.getText("NOTETAKERFEEDER_BUTTON_ADD_TAGS"),tooltip:t._rb.getText("NOTETAKERFEEDER_BUTTON_ADD_TAGS_TOOLTIP"),press:function(){t._handleAddTag(r.getValue());n.rerender();t._toggleTagPopup();}});t._oOverlayCard._tagControls={tagButton:n,tagList:p,tagInput:r,tagCancelBtn:s,tagApplyBtn:A};t._oOverlayCard.addContent(t._createTagSelectorControl());var u=new B({id:t.getId()+"-overlay-thumb-up-button",press:function(e){t._oOverlayCard.bThumbUp=!t._oOverlayCard.bThumbUp;if(t._oOverlayCard.bThumbUp){t._oOverlayCard.bThumbDown=false;}S();},tooltip:t._rb.getText("NOTETAKERFEEDER_BUTTON_THUMB_UP_TOOLTIP")});u.addStyleClass("sapSuiteUiCommonsNoteTakerThumbUpBtn");var v=new B({id:t.getId()+"-overlay-thumb-down-button",press:function(e){t._oOverlayCard.bThumbDown=!t._oOverlayCard.bThumbDown;if(t._oOverlayCard.bThumbDown){t._oOverlayCard.bThumbUp=false;}S();},tooltip:t._rb.getText("NOTETAKERFEEDER_BUTTON_THUMB_DOWN_TOOLTIP")});v.addStyleClass("sapSuiteUiCommonsNoteTakerThumbDownBtn");function S(){if(t._oOverlayCard.bThumbUp){u.addStyleClass("sapSuiteUiCommonsNoteTakerCardSelectedBtn");t._oOverlayCard.addStyleClass("suiteUiNtcPositiveCard");}else{u.removeStyleClass("sapSuiteUiCommonsNoteTakerCardSelectedBtn");t._oOverlayCard.removeStyleClass("suiteUiNtcPositiveCard");}if(t._oOverlayCard.bThumbDown){v.addStyleClass("sapSuiteUiCommonsNoteTakerCardSelectedBtn");t._oOverlayCard.addStyleClass("suiteUiNtcNegativeCard");}else{v.removeStyleClass("sapSuiteUiCommonsNoteTakerCardSelectedBtn");t._oOverlayCard.removeStyleClass("suiteUiNtcNegativeCard");}q(document.getElementById(u.getId())).attr("aria-pressed",t._oOverlayCard.bThumbUp);q(document.getElementById(v.getId())).attr("aria-pressed",t._oOverlayCard.bThumbDown);}S();t._oOverlayCard.layouts.toolbarLeft.insertContent(n,0);t._oOverlayCard.layouts.toolbarRight.addContent(u);t._oOverlayCard.layouts.toolbarRight.addContent(v);var w=t._oOverlayCard.layouts.buttons.getContent()[1];w.setEnabled(true);var x=new j(t.getId()+"-overlayBody",{required:true,liveChange:function(e){var y=e.getParameter("liveValue");var z=(y!==null)&&!/^\s*$/.test(y);if(z!==w.getEnabled()){w.setEnabled(z);}}});x.setValue(t.getBody());x.addStyleClass("sapSuiteUiCommonsNoteTakerCardBody");t._oOverlayCard.layouts.body.addContent(x);t._oOverlayCard.layouts.body.addContent(new g({required:true}).addStyleClass("sapSuiteRequiredLbl"));var E=t._oOverlayCard.layouts.headerRight.getContent()[0];E.setEnabled(false);E.removeStyleClass("sapSuiteUiCommonsNoteTakerCardEditButton");E.addStyleClass("sapSuiteUiCommonsNoteTakerCardEditButtonDsbl");};m.prototype._fnSave=function(){var t=this;var o=t._oOverlayCard.layouts.headerLeft.getContent()[0];var a=o.getContent();var e=t._oOverlayCard.layouts.body.getContent()[0];if(e.getValue()){if(!this.getBinding("body")){t.setHeader(a.getValue());t.setBody(e.getValue());t.setTimestamp(new Date());t.setThumbUp(t._oOverlayCard.bThumbUp);t.setThumbDown(t._oOverlayCard.bThumbDown);t.setTags(t._oOverlayCard._selectedTags);}var i={};i.uid=t.getUid();i.title=a.getValue();i.body=e.getValue();i.timestamp=new Date();i.thumbUp=t._oOverlayCard.bThumbUp;i.thumbDown=t._oOverlayCard.bThumbDown;i.tags=t._oOverlayCard._selectedTags;t.fireEditNote(i);t._oOverlayCard.layouts.headerLeft.removeContent(o);o.destroy();a.destroy();t._oOverlayCard.layouts.body.removeAllContent();e.destroy();t._destroyTagControls();t._oOverlayCard.layouts.toolbarLeft.destroyContent();t._oOverlayCard.layouts.toolbarRight.destroyContent();t._fnCreateInViewMode();q(document.getElementById(t.getId()+"-overlayTimestamp")).html(t.getFormattedTimestamp());q(document.getElementById(t.getId()+"-overlay-close")).focus();}};m.prototype._fnEdit=function(){var t=this;var o=t._oOverlayCard.layouts.headerLeft.getContent()[0];var a=t._oOverlayCard.layouts.body.getContent()[0];t._oOverlayCard.layouts.topSection.removeContent(o);o.destroy();t._oOverlayCard.layouts.body.removeContent(a);a.destroy();t._oOverlayCard.layouts.toolbarLeft.destroyContent();t._oOverlayCard.layouts.toolbarRight.destroyContent();t._fnCreateInEditMode();t._oOverlayCard.layouts.topSection.rerender();t._oOverlayCard.layouts.body.rerender();if(t.getId()+"-overlayBody"?window.document.getElementById(t.getId()+"-overlayBody"):null){(t.getId()+"-overlayBody"?window.document.getElementById(t.getId()+"-overlayBody"):null).focus();}};m.prototype._handleAttachmentDownload=function(){var e={};e.uid=this._ntc.getUid();e.url=this._ntc.getAttachmentUrl();e.filename=this._ntc.getAttachmentFilename();this._ntc.fireAttachmentClick(e);};return m;});
