/*!
 * 
		SAP UI development toolkit for HTML5 (SAPUI5)
		(c) Copyright 2009-2015 SAP SE. All rights reserved
	
 */
sap.ui.define(["sap/ui/thirdparty/jquery","./library","sap/m/library","sap/ui/core/Control","sap/suite/ui/commons/ProcessFlowConnection","sap/suite/ui/commons/ProcessFlowLaneHeader","sap/ui/Device","sap/ui/core/ResizeHandler","sap/base/Log","sap/ui/events/KeyCodes","./ProcessFlowRenderer"],function(q,l,M,C,P,a,D,R,L,K,b){"use strict";var c=C.extend("sap.suite.ui.commons.ProcessFlow",{metadata:{library:"sap.suite.ui.commons",properties:{foldedCorners:{type:"boolean",group:"Misc",defaultValue:false},scrollable:{type:"boolean",group:"Misc",defaultValue:true},wheelZoomable:{type:"boolean",group:"Behavior",defaultValue:true},showLabels:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"lanes",aggregations:{_connections:{type:"sap.suite.ui.commons.ProcessFlowConnection",multiple:true,singularName:"_connection",visibility:"hidden"},nodes:{type:"sap.suite.ui.commons.ProcessFlowNode",multiple:true,singularName:"node"},lanes:{type:"sap.suite.ui.commons.ProcessFlowLaneHeader",multiple:true,singularName:"lane"},ariaProperties:{type:"sap.suite.ui.commons.AriaProperties",multiple:false,group:"Misc"}},events:{nodeTitlePress:{deprecated:true,parameters:{oEvent:{type:"object"}}},nodePress:{parameters:{oEvent:{type:"object"}}},labelPress:{parameters:{oEvent:{type:"object"}}},headerPress:{parameters:{oEvent:{type:"object"}}},onError:{parameters:{oEvent:{type:"object"}}}},dnd:{draggable:false,droppable:true}}});c.prototype._resBundle=null;c._cellEdgeConstants={"LU":"tl","LD":"lb","DU":"tb","LR":"rl","DR":"rt","UR":"rb"};c._constants={scrollContainer:"scrollContainer",counterLeft:"counterLeft",counterRight:"counterRight",arrowScrollRight:"arrowScrollRight",arrowScrollRightMinus:"-arrowScrollRight",arrowScrollLeft:"arrowScrollLeft",arrowScrollLeftMinus:"-arrowScrollLeft",top:"top",px:"px",parents:"parents",left:"left",right:"right"};c._mouseEvents={mouseMove:"mousemove",mouseDown:"mousedown",mouseUp:"mouseup",mouseLeave:"mouseleave",mouseEnter:"mouseenter",touchStart:"touchstart",sapTouchStart:"saptouchstart",touchEnd:"touchend",sapTouchCancel:"saptouchcancel"};c._enumMoveDirection={"LEFT":"left","RIGHT":"right","UP":"up","DOWN":"down"};c.prototype._zoomLevel=l.ProcessFlowZoomLevel.Two;c.prototype._wheelTimeout=null;c.prototype._isFocusChanged=false;c.prototype._wheelTimestamp=null;c.prototype._wheelCalled=false;c.prototype._internalCalcMatrix=false;c.prototype._internalConnectionMap=null;c.prototype._internalLanes=false;c.prototype._jumpOverElements=5;c.prototype._lastNavigationFocusElement=null;c.prototype._bHighlightedMode=false;c.prototype._isLayoutOptimized=false;c.prototype._defaultCursorClass="sapSuiteUiDefaultCursorPF";if(D.browser.msie||D.browser.edge){c.prototype._grabCursorClass="sapSuiteUiGrabCursorIEPF";c.prototype._grabbingCursorClass="sapSuiteUiGrabbingCursorIEPF";}else{c.prototype._grabCursorClass="sapSuiteUiGrabCursorPF";c.prototype._grabbingCursorClass="sapSuiteUiGrabbingCursorPF";}c.prototype._mousePreventEvents="contextmenu dblclick";c.prototype._mouseEvents="contextmenu mousemove mouseleave mousedown mouseup mouseenter";c.prototype._mouseWheelEvent=D.browser.mozilla?"DOMMouseScroll MozMousePixelScroll":"mousewheel wheel";c.prototype._headerHasFocus=false;c.prototype._isInitialZoomLevelNeeded=true;c.prototype._bDoScroll=!D.system.desktop||D.os.windows&&D.os.version>=8;c.prototype._scrollStep=192;c.prototype._bPreviousScrollForward=false;c.prototype._bPreviousScrollBack=false;c.prototype._iInitialArrowTop=undefined;c.prototype._iInitialCounterTop=undefined;c.prototype._bRtl=false;c.prototype._arrowScrollable=null;c.prototype._iTouchStartScrollTop=undefined;c.prototype._iTouchStartScrollLeft=undefined;c.prototype._bSetFocusOnce=true;c.prototype.init=function(){this._bRtl=sap.ui.getCore().getConfiguration().getRTL();if(!this._resBundle){this._resBundle=sap.ui.getCore().getLibraryResourceBundle("sap.suite.ui.commons");}this._internalLanes=[];if(this._getScrollContainer()){this._getScrollContainer().bind("keydown",q.proxy(this.onkeydown,this));}};c.prototype.exit=function(){var n=this.getNodes(),i;if(n){for(i=0;i<n.length;i++){if(n[i]){n[i].destroy();}}n=null;}if(this._internalLanes){for(i=0;i<this._internalLanes.length;i++){this._internalLanes[i].destroy();}this._internalLanes=null;}var I=this.getAggregation("_connections");if(I){for(i=0;i<I.length;i++){I[i].destroy();}I=null;}if(this._oArrowLeft){this._oArrowLeft.destroy();}if(this._oArrowRight){this._oArrowRight.destroy();}if(this._resizeRegId){R.deregister(this._resizeRegId);}if(this._internalCalcMatrix){delete this._internalCalcMatrix;this._internalCalcMatrix=null;}if(this._getScrollContainer()){this._getScrollContainer().unbind(this._mousePreventEvents,this._handlePrevent);this._getScrollContainer().unbind(this._mouseEvents,q.proxy(this._registerMouseEvents,this));this._getScrollContainer().unbind(this._mouseWheelEvent,q.proxy(this._registerMouseWheel,this));this._getScrollContainer().unbind("keydown",q.proxy(this.onkeydown,this));this._getScrollContainer().unbind("scroll",q.proxy(this._onScroll,this));}};c.prototype.onBeforeRendering=function(){if(this._getScrollContainer()){this._getScrollContainer().unbind(this._mousePreventEvents,this._handlePrevent);this._getScrollContainer().unbind(this._mouseEvents,q.proxy(this._registerMouseEvents,this));this._getScrollContainer().unbind(this._mouseWheelEvent,q.proxy(this._registerMouseWheel,this));this._getScrollContainer().unbind("keydown",q.proxy(this.onkeydown,this));this._getScrollContainer().unbind("scroll",q.proxy(this._onScroll,this));}};c.prototype.onAfterRendering=function(){var s=false,$=this.$("scroll-content"),h,w,S,i;this._checkOverflow(this._getScrollContainer().get(0),this.$());this.iCursorPositionX=0;this.iCursorPositionY=0;if($&&$.length){this._getScrollContainer().find(".sapSuiteUiCommonsProcessFlowNode .sapUiIcon").css("cursor","inherit");if(this.getScrollable()){h=parseInt(this._getScrollContainer().css("height").slice(0,-2),10);w=parseInt(this._getScrollContainer().css("width").slice(0,-2),10);i=$[0].scrollHeight;S=$[0].scrollWidth;if(i<=h&&S<=w){this._clearHandlers(this._getScrollContainer());this._switchCursors(this._getScrollContainer(),this._grabCursorClass,this._defaultCursorClass);}else{this._switchCursors(this._getScrollContainer(),this._defaultCursorClass,this._grabCursorClass);s=true;}}else{this._clearHandlers(this._getScrollContainer());this._switchCursors(this._getScrollContainer(),this._grabCursorClass,this._defaultCursorClass);$.css("position","static");}if(s){if(!this._iInitialArrowTop||!this._iInitialCounterTop){this._iInitialArrowTop=parseInt(this.$(c._constants.arrowScrollRight).css(c._constants.top),10);this._iInitialCounterTop=parseInt(this.$(c._constants.counterRight).css(c._constants.top),10);}if(D.os.windows&&D.system.combi&&D.browser.chrome){this._getScrollContainer().bind(this._mouseEvents,q.proxy(this._registerMouseEvents,this));this._getScrollContainer().css("overflow","auto");}else if(D.os.windows&&(D.browser.msie&&(D.browser.version>9)||D.browser.edge)){this._getScrollContainer().bind(this._mouseEvents,q.proxy(this._registerMouseEvents,this));this._getScrollContainer().css("overflow","auto");this._getScrollContainer().css("-ms-overflow-style","none");}else if(!D.support.touch){this._getScrollContainer().bind(this._mouseEvents,q.proxy(this._registerMouseEvents,this));}else{this._clearHandlers(this._getScrollContainer());this._getScrollContainer().css("overflow","auto");}}else if(this._bDoScroll){this._getScrollContainer().css("overflow","auto");}else{this._getScrollContainer().css("overflow","hidden");}if(this.getWheelZoomable()&&D.system.desktop&&!this._isHeaderMode()){this._getScrollContainer().bind(this._mouseWheelEvent,q.proxy(this._registerMouseWheel,this));}if(this._bDoScroll){this._getScrollContainer().bind("scroll",q.proxy(this._onScroll,this));}this._resizeRegId=R.register(this,q.proxy(c.prototype._onResize,this));if(this._isInitialZoomLevelNeeded){this._initZoomLevel();}if(this._headerHasFocus){var d=this.$("scroll-content").children().children().children(1).children("td[tabindex='0']").first().children();if(d[0]){var n=sap.ui.getCore().byId(d[0].id);this._changeNavigationFocus(null,n);this._headerHasFocus=false;}}}};c.prototype.ontouchend=function(e){if(e.target&&e.target.id.indexOf("arrowScroll")!==-1){this._onArrowClick(e);}else{if(!D.support.touch){this.onAfterRendering();}else{this._adjustAndShowArrow();}if(e===null||e.oSource===undefined){return;}e.preventDefault();if(this._isHeaderMode()){this._internalLanes=[];this.fireHeaderPress(this);}}};c.prototype._handlePrevent=function(e){if(e&&!e.isDefaultPrevented()){e.preventDefault();}if(e&&!e.isPropagationStopped()){e.stopPropagation();}if(e&&!e.isImmediatePropagationStopped()){e.stopImmediatePropagation();}};c.prototype._onResize=function(){var A=new Date().getTime();if(!this._iLastResizeEventTime||((A-this._iLastResizeEventTime)<50)){if(!this._iLastResizeHandlingTime||(A-this._iLastResizeHandlingTime>500)){this.onAfterRendering();this._iLastResizeHandlingTime=new Date().getTime();}}else{this._iLastResizeHandlingTime=null;}this._iLastResizeEventTime=new Date().getTime();};c.prototype._registerMouseEvents=function(e){if(e&&!e.isDefaultPrevented()){e.preventDefault();}switch(e.type){case c._mouseEvents.mouseMove:if(this._getScrollContainer().hasClass(this._grabbingCursorClass)){if(sap.ui.getCore().getConfiguration().getRTL()){this._getScrollContainer().scrollLeftRTL(this.iCursorPositionX-e.pageX);}else{this._getScrollContainer().scrollLeft(this.iCursorPositionX-e.pageX);}this._getScrollContainer().scrollTop(this.iCursorPositionY-e.pageY);this._adjustAndShowArrow();}break;case c._mouseEvents.mouseDown:this._switchCursors(this._getScrollContainer(),this._defaultCursorClass,this._grabbingCursorClass);if(sap.ui.getCore().getConfiguration().getRTL()){this.iCursorPositionX=this._getScrollContainer().scrollLeftRTL()+e.pageX;}else{this.iCursorPositionX=this._getScrollContainer().scrollLeft()+e.pageX;}this.iCursorPositionY=this._getScrollContainer().scrollTop()+e.pageY;if(D.system.combi){this._iTouchStartScrollLeft=this._getScrollContainer().scrollLeft();if(this.getScrollable()){this._iTouchStartScrollTop=this._getScrollContainer().scrollTop();}}break;case c._mouseEvents.mouseUp:this._switchCursors(this._getScrollContainer(),this._grabbingCursorClass,this._grabCursorClass);break;case c._mouseEvents.mouseLeave:this._getScrollContainer().removeClass(this._grabbingCursorClass);this._getScrollContainer().removeClass(this._grabCursorClass);this._getScrollContainer().addClass(this._defaultCursorClass);break;case c._mouseEvents.mouseEnter:this._getScrollContainer().removeClass(this._defaultCursorClass);if(e.buttons===null){if(e.which===1){this._getScrollContainer().addClass(this._grabbingCursorClass);}else{this._getScrollContainer().addClass(this._grabCursorClass);}}else if(e.buttons===0){this._getScrollContainer().addClass(this._grabCursorClass);}else if(e.buttons===1){this._getScrollContainer().addClass(this._grabbingCursorClass);}break;default:}if(e.target&&e.target.parentElement&&e.target.parentElement.parentElement&&e.target.parentElement.parentElement.getMetadata&&e.target.parentElement.parentElement.getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowConnectionLabel"){if(e&&!e.isPropagationStopped()){e.stopPropagation();}if(e&&!e.isImmediatePropagationStopped()){e.stopImmediatePropagation();}}};c.prototype.onfocusin=function(e){var t;if(e&&e.target&&e.target.id){t=sap.ui.getCore().byId(e.target.id);}if(this._isHeaderMode()){this._setFocusOnHeader(true);}else if(this._bSetFocusOnce&&!(t&&e.target.id.indexOf("arrowScroll"))){this._bSetFocusOnce=false;if(t&&t.getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowConnectionLabel"){this._changeNavigationFocus(null,t);}else if(!this._lastNavigationFocusElement){var $=this.$("scroll-content").children().children().children(1).children("td[tabindex='0']").first().children();var n=sap.ui.getCore().byId($[0].id);this._changeNavigationFocus(null,n);}else if(this._lastNavigationFocusElement){this._changeNavigationFocus(null,this._lastNavigationFocusElement);}}};c.prototype.onfocusout=function(){this._bSetFocusOnce=true;if(this._lastNavigationFocusElement&&this._lastNavigationFocusElement._getNavigationFocus()){this._lastNavigationFocusElement._setNavigationFocus(false);if(this._lastNavigationFocusElement.getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowNode"){this._lastNavigationFocusElement.rerender();}}};c.prototype.onsapplus=function(){this._isFocusChanged=true;this.zoomIn();};c.prototype.onsapminus=function(){this._isFocusChanged=true;this.zoomOut();};c.prototype.onsaptabnext=function(e){var f=true;var $=e.target;var A=sap.ui.getCore().byId($.id);if(!A&&$&&$.childElementCount>0){$=$.childNodes[0];A=sap.ui.getCore().byId($.id);}if(!A||(A.getMetadata().getName()!=="sap.suite.ui.commons.ProcessFlowNode"&&A.getMetadata().getName()!=="sap.suite.ui.commons.ProcessFlowConnectionLabel")){if(!this._isHeaderMode()&&!this._lastNavigationFocusElement){var d=this.$("scroll-content").children().children().children(1).children("td[tabindex='0']").first().children();var n=sap.ui.getCore().byId(d[0].id);this._changeNavigationFocus(null,n);f=false;}else if(this._lastNavigationFocusElement){this._changeNavigationFocus(null,this._lastNavigationFocusElement);f=false;}}if(this._isHeaderMode()&&f){if(!this._headerHasFocus){this._setFocusOnHeader(true);}else{this._setFocusOnHeader(false);}}else if(this._lastNavigationFocusElement&&this._lastNavigationFocusElement.getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowNode"){this._lastNavigationFocusElement.rerender();}var N;if(f){N=this.$().nextAll().find(":focusable").first();if(N.length===0){s.apply(this);}N.focus();L.debug("saptabnext: Keyboard focus has been changed to element:  id='"+N.id+"' outerHTML='"+N.outerHTML+"'");N=null;}e.preventDefault();function s(){var g=this.$().parent();do{N=g.next(":focusable");if(N.length===0){N=g.nextAll().find(":focusable").first();}g=g.parent();}while((g.length!==0)&&(N.length===0));if(N.length===0){N=q(":focusable")[0];}}};c.prototype.onsaptabprevious=function(e){var p=null;var $=e.target;if((!this._lastNavigationFocusElement||!this._lastNavigationFocusElement._getNavigationFocus())&&e.target&&e.target.childElementCount>0){$=e.target.childNodes[0];}var A=sap.ui.getCore().byId($.id);if(A&&(A.getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowNode"||A.getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowNode")){if(!this._isHeaderMode()&&!this._lastNavigationFocusElement){var d=this.$("scroll-content").children().children().children(1).children("td[tabindex='0']").first().children();var n=sap.ui.getCore().byId(d[0].id);this._changeNavigationFocus(null,n);}else if(this._lastNavigationFocusElement){this._changeNavigationFocus(null,this._lastNavigationFocusElement);e.preventDefault();return;}}if(this._isHeaderMode()){if(!this._headerHasFocus){this._setFocusOnHeader(true);}else{this._setFocusOnHeader(false);p=this.$().prevAll().find(":focusable").first();}}else{p=this.$().prev(":focusable");if(p.length===0){p=this.$().prevAll().find(":focusable").first();}if(this._lastNavigationFocusElement){this._lastNavigationFocusElement._setNavigationFocus(false);}if(this._lastNavigationFocusElement&&this._lastNavigationFocusElement.getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowNode"){this._lastNavigationFocusElement.rerender();}}if(p){if(p.length===0){s.apply(this);}else if(p.first().length!==0){p=q(p.first());}p.focus();L.debug("saptabnext: Keyboard focus has been set on element:  id='"+p.id+"' outerHTML='"+p.outerHTML+"'");p=null;}e.preventDefault();function s(){var f=this.$();do{p=f.prev(":focusable");if(p.length===0){p=f.prevAll().find(":focusable").last();}f=f.parent();}while((f.length!==0)&&(p.length===0));}};c.prototype._handleKeySelect=function(e){if(this._isHeaderMode()){this._internalLanes=[];this.fireHeaderPress(this);var $=this.$("scroll-content").children().children().children(1).children("td[tabindex='0']").first().children();var n=sap.ui.getCore().byId($[0].id);this._changeNavigationFocus(null,n);}else if(this._lastNavigationFocusElement&&this._lastNavigationFocusElement.getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowNode"&&this._lastNavigationFocusElement._getNavigationFocus()){var f=this._lastNavigationFocusElement;f._handleEvents(e);}};c.prototype.onkeyup=function(e){var k=e.keyCode?e.keyCode:e.which;switch(k){case K.ENTER:case K.SPACE:var f=this._lastNavigationFocusElement;if(f){this.fireNodePress(this._lastNavigationFocusElement);f._handleEvents(e);}break;default:break;}};c.prototype.onkeydown=function(e){var k=(e.keyCode?e.keyCode:e.which);L.debug("ProcessFlow::keyboard input has been catched and action going to start: keycode="+k);var E=false;var d=e.ctrlKey;var f=e.altKey;var p=this._lastNavigationFocusElement;switch(k){case K.ARROW_RIGHT:E=this._moveToNextElement(c._enumMoveDirection.RIGHT);break;case K.ARROW_LEFT:E=this._moveToNextElement(c._enumMoveDirection.LEFT);break;case K.ARROW_DOWN:E=this._moveToNextElement(c._enumMoveDirection.DOWN);break;case K.ARROW_UP:E=this._moveToNextElement(c._enumMoveDirection.UP);break;case K.PAGE_UP:E=this._moveOnePage(c._enumMoveDirection.UP,f);break;case K.PAGE_DOWN:E=this._moveOnePage(c._enumMoveDirection.DOWN,f);break;case K.HOME:E=this._moveHomeEnd(c._enumMoveDirection.LEFT,d);break;case K.END:E=this._moveHomeEnd(c._enumMoveDirection.RIGHT,d);break;case K.NUMPAD_0:case K.DIGIT_0:this._initZoomLevel();break;case K.ENTER:case K.SPACE:this._handleKeySelect(e);e.preventDefault();return;default:return;}e.preventDefault();if(E){this._changeNavigationFocus(p,this._lastNavigationFocusElement);}};c.prototype._onArrowClick=function(e){var t=e.target.id;if(t){var i=this.getId();e.preventDefault();if(t===i+c._constants.arrowScrollLeftMinus&&D.system.desktop){this._scroll(-this._scrollStep,500);}else if(t===i+c._constants.arrowScrollRightMinus&&D.system.desktop){this._scroll(this._scrollStep,500);}}};c.prototype._onScroll=function(){var s=this._getScrollContainer().scrollLeft();var d=Math.abs(s-this._iTouchStartScrollLeft);if(d>(this._scrollStep/4)&&!this._isFocusChanged){this._adjustAndShowArrow();this._iTouchStartScrollLeft=s;}else if(this.getScrollable()){var S=this._getScrollContainer().scrollTop();var i=Math.abs(S-this._iTouchStartScrollTop);if(i>10){this._moveArrowAndCounterVertical();this._iTouchStartScrollTop=S;}}};c.prototype.ontouchstart=function(){this._iTouchStartScrollLeft=this._getScrollContainer().scrollLeft();if(this.getScrollable()){this._iTouchStartScrollTop=this._getScrollContainer().scrollTop();}};c.prototype.ontouchmove=function(e){e.setMarked();};c.prototype._handleLabelClick=function(e){if(e){var o=e.getSource();if(o&&o.getMetadata().getName()==="sap.ui.core.Icon"){o=o.getParent();}if(o&&o.getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowConnectionLabel"){var r=this._getConnectionMapEntries(o);var d=this._createLabelPressEventArgs(o,r);this.fireLabelPress(d);}}};c.prototype._onFocusChanged=function(){var f=this._lastNavigationFocusElement,$=f?f.$():null,s,S,i,d,e,g,h,E,j,p,k,m,n,o,r,t,u=500;if(f&&this.getScrollable()){L.debug("The actually focused element is "+f.getId());if(f.getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowConnectionLabel"){E=$.parent().parent().parent().outerWidth();j=$.parent().parent().parent().outerHeight();p=$.parent().parent().parent().position();}else{E=$.outerWidth();j=$.outerHeight();p=$.position();}L.debug("Element outer width x height ["+E+" x "+j+"]");L.debug("Position of element in the content is ["+p.left+", "+p.top+"]");e=this.$("scroll-content");s=this._getScrollContainer().innerWidth();S=this._getScrollContainer().innerHeight();L.debug("Scroll container inner width x height ["+s+" x "+S+"]");i=this._getScrollContainer().scrollLeft();d=this._getScrollContainer().scrollTop();L.debug("Current scroll offset is ["+i+", "+d+"]");g=e.innerWidth();h=e.innerHeight();L.debug("Scroll content inner width x height ["+g+" x "+h+"]");k=-i+p.left;n=k+E;m=-d+p.top;o=m+j;if((n>s)||(k<0)||(o>S)||(m<0)){r=Math.round((s-E)/2);r=Math.max(s-g+p.left,r);r=Math.min(p.left,r);t=Math.round((S-j)/2);t=Math.max(S-h+p.top,t);t=Math.min(p.top,t);L.debug("Element lies outside the scroll container, scrolling from ["+k+","+m+"] to ["+r+","+t+"]");this._isFocusChanged=true;this._getScrollContainer().animate({scrollTop:p.top-t,scrollLeft:p.left-r},u,"swing",q.proxy(this._adjustAndShowArrow,this));}else{L.debug("Element lies inside the scroll container, no scrolling happens.");this._setFocusToNode(f);}}else{this._setFocusToNode(f);this._adjustAndShowArrow();}};c.prototype._setScrollWidth=function(){switch(this.getZoomLevel()){case(l.ProcessFlowZoomLevel.One):this._scrollStep=240;break;case(l.ProcessFlowZoomLevel.Two):this._scrollStep=192;break;case(l.ProcessFlowZoomLevel.Three):this._scrollStep=168;break;case(l.ProcessFlowZoomLevel.Four):this._scrollStep=128;break;default:this._scrollStep=192;}};c.prototype._getLastNavigationFocusElement=function(){return this._lastNavigationFocusElement;};c.prototype._getNode=function(n,d){for(var i=0;i<d.length;i++){if(d[i].getNodeId()===n.toString()){return d[i];}}};c.prototype._getLane=function(d){for(var i=0;i<this._internalLanes.length;i++){if(this._internalLanes[i].getLaneId()===d){return this._internalLanes[i];}}};c.prototype.destroyLanes=function(){this.removeAllAggregation("lanes");this._internalLanes=[];};c._getChildIdByElement=function(d){if(typeof d==="object"){return d.nodeId;}else{return d;}};c.prototype._isHeaderMode=function(){var n=this.getNodes();return!n||(n.length===0);};c.prototype._getScrollContainer=function(){return this.$(c._constants.scrollContainer);};c.prototype._handleException=function(e){var t=this._resBundle.getText("PF_ERROR_INPUT_DATA");this.fireOnError({text:t});L.error("Error loading data for the process flow with id : "+this.getId());if(e instanceof Array){for(var i=0;i<e.length;i++){L.error("Detailed description ("+i+") :"+e[i]);}}else{L.error("Detailed description  :"+e);}};c.prototype._getAriaText=function(){return this._resBundle.getText("PF_ARIA_PROCESS_FLOW");};c.prototype._updateLanesFromNodes=function(){c.NodeElement._createNodeElementsFromProcessFlowNodes(this.getNodes(),this.getLanes());var i=this._arrangeNodesByParentChildRelation(this.getNodes());this._internalLanes=c.NodeElement._updateLanesFromNodes(this.getLanes(),i).lanes;};c.prototype._getOrCreateLaneMap=function(){if(!this._internalLanes||this._internalLanes.length<=0){this._updateLanesFromNodes();}return c.NodeElement._createMapFromLanes(this._internalLanes,q.proxy(this.ontouchend,this),this._isHeaderMode()).positionMap;};c.prototype._arrangeNodesByParentChildRelation=function(d){var I=d?d.length:0;var e=[];var i,j;if(I>0){this._setParentForNodes(d);for(i=0;i<I;i++){e=d[i].getChildren();if(e){var f=e.length;for(j=0;j<f;j++){e[j]=c._getChildIdByElement(e[j]).toString();}}for(j=0;j<i;j++){if(e&&Array.prototype.indexOf.call(e,d[j].getNodeId())>-1&&d[j].getLaneId()===d[i].getLaneId()){d.splice(j,0,d[i]);d.splice(i+1,1);d=this._arrangeNodesByParentChildRelation(d);break;}}}}return d;};c.prototype._getOrCreateProcessFlow=function(){if(!this._internalLanes||this._internalLanes.length<=0){this._updateLanesFromNodes();}this.applyNodeDisplayState();var I=this.getNodes();var r=c.NodeElement._createNodeElementsFromProcessFlowNodes(I,this._internalLanes);var e=r.elementById;var E=r.elementsByLane;var m=this._calculateMatrix(e);m=this._addFirstAndLastColumn(m);c.NodeElement._calculateLaneStatePieChart(E,this._internalLanes,I,this);for(var i=0;i<m.length;i++){for(var j=0;j<m[i].length;j++){if(m[i][j]instanceof c.NodeElement){m[i][j]=e[m[i][j].nodeId].oNode;}}}this._internalCalcMatrix=m;return m;};c.prototype._isLanesUpdated=function(){var o=this.getLanes();if(o.length!=this._internalLanes.length){return true;}var d;for(var i=0;i<o.length;i++){var e=o[i];d=false;for(var j=0;j<this._internalLanes.length;j++){var f=this._internalLanes[j];if(f.getLaneId()===e.getLaneId()){d=true;break;}}if(!d){return true;}}return false;};c.prototype._resetLanesFromModel=function(){var n=this.getNodes();n.forEach(function(e){e._mergedLaneId=false;});var d=this.getLanes();d.forEach(function(e){e._mergedLanePosition=false;});this._internalLanes=[];if(this._isHeaderMode()){var o=this.getBindingInfo("lanes");if(o&&o.model){this.getModel(o.model).refresh();}}else{var N=this.getBindingInfo("nodes");if(N&&N.model){this.getModel(N.model).refresh();}}};c.prototype._addFirstAndLastColumn=function(d){if(!d||d.length<=0){return[];}var o=d.length;for(var i=0;i<o;i++){d[i].unshift(null);d[i].push(null);}return d;};c.prototype._calculateMatrix=function(n){var I,e,d,r,m;if(!n||(n.length===0)){return[];}I=new c.InternalMatrixCalculation(this);I.checkInputNodeConsistency(n);e=I._retrieveInfoFromInputArray(n);I._resetPositions();d=e.highestLanePosition+1;r=Math.max(Object.keys(n).length,2);m=I._createMatrix(r,d);for(var i=0;i<e.rootElements.length;i++){I.iPositionY=e.rootElements[i].lane;m=I.processCurrentElement(e.rootElements[i],n,m);}if(this._isLayoutOptimized){I._optimizeMatrix(m,n);}m=I._doubleColumnsInMatrix(m);m=I._calculatePathInMatrix(m);m=I._removeEmptyLines(m);return m;};c.NodeElement=function(i,d,n,e){this.nodeId=i;this.lane=d;this.state=n.getState();this.displayState=n._getDisplayState();this.isProcessed=false;if(Array.isArray(e)){this.aParent=e;}else{this.oParent=e;}this.oNode=n;};c.NodeElement._initNodeElement=function(i,d,n,e){return new c.NodeElement(i,d,n,e);};c.NodeElement.prototype={toString:function(){return this.nodeId;},containsChildren:function(e){if(!e){return false;}if(!(e instanceof c.NodeElement)){return false;}if(this.oNode.getChildren()&&e.oNode.getChildren()&&this.oNode.getChildren().length&&e.oNode.getChildren().length){for(var i=0;i<this.oNode.getChildren().length;i++){if(e.oNode.getChildren().indexOf(this.oNode.getChildren()[i])>=0){return true;}}}return false;}};c.NodeElement._calculateLaneStatePieChart=function(d,e,f,p){if(!d||!e||!f){return;}var i;for(i=0;i<f.length;i++){p._bHighlightedMode=f[i].getHighlighted();if(p._bHighlightedMode){break;}}var g,n,N,h,k;for(i=0;i<e.length;i++){var o=e[i];var m=d[o.getLaneId()];if(!m){continue;}g=0;n=0;N=0;h=0;k=0;for(var j=0;j<m.length;j++){if(!p._bHighlightedMode||(m[j].oNode._getDisplayState()===l.ProcessFlowDisplayState.Highlighted||m[j].oNode._getDisplayState()===l.ProcessFlowDisplayState.HighlightedFocused||m[j].oNode._getDisplayState()===l.ProcessFlowDisplayState.SelectedHighlighted||m[j].oNode._getDisplayState()===l.ProcessFlowDisplayState.SelectedHighlightedFocused)){switch(m[j].oNode.getState()){case l.ProcessFlowNodeState.Positive:g++;break;case l.ProcessFlowNodeState.Negative:case l.ProcessFlowNodeState.PlannedNegative:n++;break;case l.ProcessFlowNodeState.Planned:h++;break;case l.ProcessFlowNodeState.Critical:k++;break;case l.ProcessFlowNodeState.Neutral:default:N++;}}}var s=[{state:l.ProcessFlowNodeState.Positive,value:g},{state:l.ProcessFlowNodeState.Negative,value:n},{state:l.ProcessFlowNodeState.Neutral,value:N},{state:l.ProcessFlowNodeState.Planned,value:h},{state:l.ProcessFlowNodeState.Critical,value:k}];o.setState(s);}};c.NodeElement._updateLanesFromNodes=function(p,d){var r=c.NodeElement._createMapFromLanes(p,null,false);var e=r.positionMap;var f=r.idMap;var n={};var t=p.slice();var g;var T={};var h=0;var i;for(i=0;i<d.length;i++){n[d[i].getNodeId()]=d[i];}for(i=0;i<d.length;i++){var o=d[i];var k=o.getChildren()||[];var m=1;var N=null;var s=null;for(var j=0;j<k.length;j++){var u=c._getChildIdByElement(k[j]);var w=n[u];if(w){if(o.getLaneId()===w.getLaneId()){N=w.getLaneId()+m;s=f[N];if(!s){var x=f[o.getLaneId()];s=c.NodeElement._createNewProcessFlowElement(x,N,x.getPosition()+m);f[s.getLaneId()]=s;t.splice(s.getPosition(),0,s);}w._setMergedLaneId(s.getLaneId());}c.NodeElement._changeLaneOfChildren(o.getLaneId(),w,n);}}if(s){T={};g=false;for(var y in e){if(s.getLaneId()===e[y].getLaneId()){g=true;break;}if(parseInt(y,10)>=s.getPosition()){var z=e[y];T[z.getPosition()+m]=z;}}if(!g){for(var A in T){h=parseInt(A,10);T[h]._setMergedPosition(h);}T[s.getPosition()]=s;for(var v=0;v<s.getPosition();v++){T[v]=e[v];}e=T;}}}return{lanes:t,nodes:d};};c.NodeElement._changeLaneOfChildren=function(d,e,n){var f=e.getChildren();if(f){for(var i=0;i<f.length;i++){var s=c._getChildIdByElement(f[i]);var o=n[s];if(o&&o.getLaneId()===d){o._setMergedLaneId(e.getLaneId());c.NodeElement._changeLaneOfChildren(d,o,n);}}}};c.NodeElement._createNewProcessFlowElement=function(o,n,d){return new a({laneId:n,iconSrc:o.getIconSrc(),text:o.getText(),state:o.getState(),position:d,zoomLevel:o.getZoomLevel()});};c.NodeElement._createMapFromLanes=function(p,t,d){var o,e={},f={},g=p?p.length:0,i=0;if(!g){return{};}else{while(i<g){o=p[i];if(o&&o.getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowLaneHeader"){e[o.getPosition()]=o;f[o.getLaneId()]=o;if(t){o.attachPress(t);}o._setHeaderMode(d);}i++;}return{positionMap:e,idMap:f};}};c.NodeElement._createNodeElementsFromProcessFlowNodes=function(p,d){var e={},f={},g={},n,N=p?p.length:0,s,o,h=d?d.length:0,k,m=[],r,t,u,v,i,j,I={};if(N===0){return{elementById:{},elementsByLane:{}};}if(h===0){throw["No lane definition although there is a node definition."];}i=0;while(i<h){o=d[i];k=o.getLaneId();r=o.getPosition();if(e[k]){throw["The lane with id: "+k+" is defined at least twice. (Lane error)"];}e[k]=r;if(m&&Array.prototype.indexOf.call(m,r)>-1){throw["The position "+r+" is defined at least twice. (Lane error)."];}else{m.push(r);}f[k]=[];i++;}i=0;while(i<N){n=p[i];if(n&&n.getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowNode"){s=n.getNodeId();k=n.getLaneId();t=n.getChildren()||[];v=t.length;j=0;while(j<v){u=c._getChildIdByElement(t[j]);g[u]=g[u]||[];g[u].push(s);j++;}}i++;}i=0;while(i<N){n=p[i];if(n&&n.getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowNode"){s=n.getNodeId();if(!s){throw["There is a node which has no node id defined. (Title="+n.getTitle()+") and array position: "+i];}k=n.getLaneId();r=e[k];if(q.type(r)!=="number"){throw["For the node "+s+" position (lane) is not defined."];}if(!I[s]){I[s]=c.NodeElement._initNodeElement(s,r,n,g[s]);f[k].push(I[s]);}else{throw["The node id "+s+" is used second time."];}}i++;}return{elementById:I,elementsByLane:f};};c.InternalMatrixCalculation=function(){this.iPositionX=0;this.iPositionY=0;this.nodePositions={};this.mapChildToNode={};};c.InternalMatrixCalculation.prototype._optimizeMatrix=function(m,e){var d;do{d=false;for(var f=0;f<m[0].length;f++){for(var g=0;g<m.length-1;g++){if(!m[g][f]){var n=false;for(var i=g+1;i<m.length;i++){if(m[i][f]){n=true;break;}}if(!n){break;}if(this._optimizeLane(m,g,f,e)){d=true;}}}}}while(d);};c.InternalMatrixCalculation.prototype._optimizeLane=function(m,r,d,e){for(var i=r+1;i<m.length;i++){if(m[i][d]){var n=m[i][d];if(this._verifyOptimizeLane(m,r,i,d,e)){m[r][d]=n;this.nodePositions[n.nodeId].x=r;m[i][d]=null;return true;}else{return false;}}}return false;};c.InternalMatrixCalculation.prototype._verifyOptimizeLane=function(m,r,d,e,n){var N=m[d][e].oNode;var i,j,f,s;if(N&&N.getChildren()){f=m[d][e].oNode.getChildren();for(i=0;i<f.length;i++){s=c._getChildIdByElement(f[i]);var g=n[s].lane;for(j=e+1;j<g;j++){if(m[r][j]){return false;}}}}var o=m[d][e].nodeId;var O=this.nodePositions[o];var p=m[d][e].aParent;if(p){for(i=0;i<p.length;i++){s=c._getChildIdByElement(p[i]);if(e-1!==n[s].lane){return false;}var h=this.nodePositions[s];if(h.x>=O.x){return false;}}}for(i=0;i<e;i++){for(j=0;j<m.length;j++){if(m[j][i]&&m[j][i].oNode){s=m[j][i].nodeId;var t=this.nodePositions[s];f=m[j][i].oNode.getChildren();if(f){for(var k=0;k<f.length;k++){var u=c._getChildIdByElement(f[k]);var v=this.nodePositions[u];if(n[u].lane>e&&!((t.x<r&&v.x<r)||((t.x>r&&v.x>r)))){return false;}}}}}}if(N._hasChildren()){for(i=0;i<r;i++){if(m[i][e]){f=m[i][e].oNode.getChildren();if(f){for(j=0;j<f.length;j++){s=c._getChildIdByElement(f[j]);var E=n[s];var w=this.nodePositions[s];if(E.lane>e&&w.x>=r&&!N._hasChildrenWithNodeId(s)){return false;}}}}}}return true;};c.InternalMatrixCalculation.prototype._resetPositions=function(){this.iPositionX=0;this.iPositionY=0;delete this.nodePositions;delete this.mapChildToNode;this.nodePositions={};this.mapChildToNode={};};c.InternalMatrixCalculation.prototype._createMatrix=function(d){d=parseInt(d,10);var e=new Array(d||0);var i=d;if(arguments.length>1){var f=Array.prototype.slice.call(arguments,1);while(i--){e[d-1-i]=this._createMatrix.apply(this,f);}}return e;};c.InternalMatrixCalculation.prototype._retrieveInfoFromInputArray=function(e){var i=0,r=[],E;Object.keys(e).forEach(function(s){E=e[s];if(!E.oParent&&!E.aParent){r.push(E);}if(i<E.lane){i=E.lane;}});return{"highestLanePosition":i,"rootElements":r};};c.InternalMatrixCalculation.prototype._doubleColumnsInMatrix=function(d){var m=0,i;for(i=0;i<d.length;i++){m=m>d[i].length?m:d[i].length;}var t=new Array(d.length||0);for(i=0;i<t.length;i++){t[i]=new Array(m*2-1);for(var j=0;j<m;j++){if(d[i][j]){t[i][2*j]=d[i][j];}}}return t;};c.InternalMatrixCalculation.prototype._removeEmptyLines=function(o){var d=0,i,j;for(i=0;i<o.length;i++){for(j=0;j<o[i].length;j++){if(o[i][j]){d++;break;}}}var r=this._createMatrix(d,o[0].length);for(i=0;i<d;i++){for(j=0;j<o[i].length;j++){r[i][j]=null;if(o[i][j]){r[i][j]=o[i][j];}}}return r;};c.InternalMatrixCalculation.prototype._sortBasedOnChildren=function(n,e){var E={},d,s=null,f,i,g,S=[],h,j,p;if(n){n.forEach(function(o){var m=c._getChildIdByElement(o);d=E[e[m].lane];if(!d){E[e[m].lane]=d=[];}d.push(e[m]);});}else{return[];}var k=function(m,o){i=(m.oNode.getChildren()||[]).length;g=(o.oNode.getChildren()||[]).length;return g-i;};f=[];for(s in E){f.push(s);E[s].sort(k);}f=f.sort(function(m,o){return o-m;});var A=function(o){if(p.containsChildren(o)){j.push(o);}};f.forEach(function(m){h=E[m];if(h.length>1){j=[];p=h.shift();while(p){if(j.indexOf(p)<0){j.push(p);}h.forEach(A);p=h.shift();}S=S.concat(j);}else{S=S.concat(h);}});return S;};c.InternalMatrixCalculation.prototype._calculatePathInMatrix=function(o){var d=null;for(var k in this.nodePositions){if(this.nodePositions.hasOwnProperty(k)){d=this.nodePositions[k];var e=d.c.oNode.getChildren();for(var i=0;e&&i<e.length;i++){var s=c._getChildIdByElement(e[i]);var p=this.nodePositions[s];o=this._calculateSingleNodeConnection(d,p,d.x,d.y,p.x,p.y,o);}}}return o;};c.InternalMatrixCalculation.prototype._calculateSingleNodeConnection=function(n,d,p,e,f,g,o){var h=g-e;var v=f-p;if(h<0){throw["Problem with negative horizontal movement","Parent node is "+n.c.toString(),"Children node is "+d.c.toString(),"Coordinates : '"+p+"','"+e+"','"+f+"','"+g+"'"];}else if(v<=-1){var N=this._checkIfHorizontalLinePossible(o,f,e+2,g);var i=g-1;if(N){i=e+1;}var j=p;if(N){j=f;}o[p][i]=this._createConnectionElement(o[p][i],c._cellEdgeConstants.LU,n,d,false);o=this._writeVerticalLine(o,p,f,i,n,d);o[f][i]=this._createConnectionElement(o[f][i],c._cellEdgeConstants.UR,n,d,(i===g-1));var s=e+2;var E=g;if(!N){s=e+1;E=i+1;}o=this._writeHorizontalLine(o,j,s,E,n,d);}else if(v===0){o=this._writeHorizontalLine(o,p,e+1,g,n,d);}else if(v===1){o[p][e+1]=this._createConnectionElement(o[p][e+1],c._cellEdgeConstants.LD,n,d,false);o[f][e+1]=this._createConnectionElement(o[f][e+1],c._cellEdgeConstants.DR,n,d,(e+1)===(g-1));o=this._writeHorizontalLine(o,f,e+2,g,n,d);}else{o[p][e+1]=this._createConnectionElement(o[p][e+1],c._cellEdgeConstants.LD,n,d,false);o=this._writeVerticalLine(o,f,p,e+1,n,d);o[f][e+1]=this._createConnectionElement(o[f][e+1],c._cellEdgeConstants.DR,n,d,(e+1)===(g-1));o=this._writeHorizontalLine(o,f,e+2,g,n,d);}return o;};c.InternalMatrixCalculation.prototype._writeVerticalLine=function(o,f,d,e,n,g){for(var j=f-1;j>d;j--){o[j][e]=this._createConnectionElement(o[j][e],c._cellEdgeConstants.DU,n,g,false);}return o;};c.InternalMatrixCalculation.prototype._checkIfHorizontalLinePossible=function(o,r,f,d){var e=true;for(var i=f;i<d;i++){if(o[r][i]instanceof c.NodeElement){e=false;break;}}return e;};c.InternalMatrixCalculation.prototype._writeHorizontalLine=function(o,r,f,d,n,e){var p=(r===e.x);if(!p){d--;}for(var i=f;i<d;i++){o[r][i]=this._createConnectionElement(o[r][i],c._cellEdgeConstants.LR,n,e,(i===(d-1))&&p);}return o;};c.InternalMatrixCalculation.prototype._createConnectionElement=function(o,f,s,t,h){var n=o;if(!n){n=new P();}if(n.getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowConnection"){var d=this._calculateConnectionDisplayStateBySourceAndTargetNode(s.c.oNode,t.c.oNode);var e={flowLine:f,targetNodeState:t.c.state,displayState:d,hasArrow:h};n.addConnectionData(e);}return n;};c.InternalMatrixCalculation.prototype._calculateConnectionDisplayStateBySourceAndTargetNode=function(s,t){var S=s.getHighlighted();var d=s.getSelected();var e=s._getDimmed();var T=t.getHighlighted();var f=t.getSelected();var g=t._getDimmed();var o=l.ProcessFlowDisplayState.Regular;if(d&&f){o=l.ProcessFlowDisplayState.Selected;}else if(S&&T){o=l.ProcessFlowDisplayState.Highlighted;}else if((e||g)||S&&f||d&&T){o=l.ProcessFlowDisplayState.Dimmed;}return o;};c.prototype.addNode=function(n){return this.addAggregation("nodes",n,false);};c.prototype._switchCursors=function($,d,e){if($.hasClass(d)){$.removeClass(d);}if(!$.hasClass(e)){$.addClass(e);}};c.prototype._clearHandlers=function($){$.bind(this._mousePreventEvents,q.proxy(this._handlePrevent,this));};c.prototype._initZoomLevel=function(){if(this.$()){var w=this.$().width();if(w){if(w<M.ScreenSizes.tablet){this.setZoomLevel(l.ProcessFlowZoomLevel.Four);}else if(w<M.ScreenSizes.desktop){this.setZoomLevel(l.ProcessFlowZoomLevel.Three);}else{this.setZoomLevel(l.ProcessFlowZoomLevel.Two);}}}};c.prototype._registerMouseWheel=function(e){var d=e.originalEvent.wheelDelta||-e.originalEvent.detail;if(d===0){d=-e.originalEvent.deltaY;}if(e&&!e.isDefaultPrevented()){e.preventDefault();e.originalEvent.returnValue=false;}var w=300;var f=function(){var i=new Date()-this._wheelTimestamp;if(i<w){this._wheelTimeout=setTimeout(function(){var m=f.bind(this);if(typeof m==="string"||m instanceof String){m=this[m];}m.apply(this,[]);}.bind(this),w-i);}else{this._wheelTimeout=null;this._wheelCalled=false;}};if(!this._wheelCalled){this._wheelCalled=true;if(d<0){this._isFocusChanged=true;this.zoomOut();}else{this._isFocusChanged=true;this.zoomIn();}}if(!this._wheelTimeout){this._wheelTimestamp=new Date();this._wheelTimeout=setTimeout(function(){var m=f.bind(this);if(typeof m==="string"||m instanceof String){m=this[m];}m.apply(this,[]);}.bind(this),w);}if(e&&!e.isPropagationStopped()){e.stopPropagation();}if(e&&!e.isImmediatePropagationStopped()){e.stopImmediatePropagation();}};c.prototype._setFocusToNode=function(n){if(n){if(n.getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowNode"){q("#"+n.sId).parent().focus();n._setNavigationFocus(true);n.rerender();}else if(n.getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowConnectionLabel"){n.$().focus();n._setNavigationFocus(true);}}else if(this._lastNavigationFocusElement){if(this._lastNavigationFocusElement.getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowNode"){q("#"+this._lastNavigationFocusElement.sId).parent().focus();this._lastNavigationFocusElement._setNavigationFocus(true);this._lastNavigationFocusElement.rerender();}else if(this._lastNavigationFocusElement.getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowConnectionLabel"){this._lastNavigationFocusElement.$().focus();this._lastNavigationFocusElement._setNavigationFocus(true);}}};c.prototype._changeNavigationFocus=function(n,d){if(n&&d&&(n.getId()!==d.getId())){L.debug("Rerendering PREVIOUS node with id '"+n.getId()+"' navigation focus : "+n._getNavigationFocus());n._setNavigationFocus(false);if(n.getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowNode"){n.rerender();}}if(d){L.debug("Rerendering CURRENT node with id '"+d.getId()+"' navigation focus : "+d._getNavigationFocus());d._setNavigationFocus(true);if(d.getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowNode"){d.rerender();}this._lastNavigationFocusElement=d;this._onFocusChanged();}};c.prototype._moveOnePage=function(d,e){d=d||c._enumMoveDirection.UP;e=e||false;var p=0,f=0;var g=0,h=0;var n=0;var N=false,i,j,o;for(i=0;i<this._internalCalcMatrix.length;i++){for(j=0;j<this._internalCalcMatrix[i].length;j++){if(this._internalCalcMatrix[i][j]&&this._internalCalcMatrix[i][j].getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowNode"&&this._internalCalcMatrix[i][j]._getNavigationFocus()){p=i;f=j;break;}else if(this._internalCalcMatrix[i][j]&&this._internalCalcMatrix[i][j].getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowConnection"){o=this._internalCalcMatrix[i][j]._getVisibleLabel();if(o&&o._getNavigationFocus()){p=i;f=j;break;}}}}if(e){if(d===c._enumMoveDirection.UP){for(j=f-1;j>=0&&n<this._jumpOverElements;j--){if(this._internalCalcMatrix[p][j]&&this._internalCalcMatrix[p][j].getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowNode"&&(!this._bHighlightedMode||this._internalCalcMatrix[p][j].getHighlighted())){n++;g=p;h=j;N=true;}else if(this._internalCalcMatrix[p][j]&&this._internalCalcMatrix[p][j].getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowConnection"){o=this._internalCalcMatrix[p][j]._getVisibleLabel();if(this._labelCanGetFocus(o)){n++;g=p;h=j;N=true;}}}}else if(d===c._enumMoveDirection.DOWN){for(j=f+1;j<this._internalCalcMatrix[p].length&&n<this._jumpOverElements;j++){if(this._internalCalcMatrix[p][j]&&this._internalCalcMatrix[p][j].getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowNode"&&(!this._bHighlightedMode||this._internalCalcMatrix[p][j].getHighlighted())){n++;g=p;h=j;N=true;}else if(this._internalCalcMatrix[p][j]&&this._internalCalcMatrix[p][j].getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowConnection"){o=this._internalCalcMatrix[p][j]._getVisibleLabel();if(this._labelCanGetFocus(o)){n++;g=p;h=j;N=true;}}}}}else if(d===c._enumMoveDirection.UP){for(i=p-1;i>=0&&n<this._jumpOverElements;i--){if(this._internalCalcMatrix[i][f]&&this._internalCalcMatrix[i][f].getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowNode"&&(!this._bHighlightedMode||this._internalCalcMatrix[i][f].getHighlighted())){n++;g=i;h=f;N=true;}else if(this._internalCalcMatrix[i][f]&&this._internalCalcMatrix[i][f].getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowConnection"){o=this._internalCalcMatrix[i][f]._getVisibleLabel();if(this._labelCanGetFocus(o)){n++;g=i;h=f;N=true;}}}}else if(d===c._enumMoveDirection.DOWN){for(i=p+1;i<this._internalCalcMatrix.length&&n<this._jumpOverElements;i++){if(this._internalCalcMatrix[i][f]&&this._internalCalcMatrix[i][f].getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowNode"&&(!this._bHighlightedMode||this._internalCalcMatrix[i][f].getHighlighted())){n++;g=i;h=f;N=true;}else if(this._internalCalcMatrix[i][f]&&this._internalCalcMatrix[i][f].getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowConnection"){o=this._internalCalcMatrix[i][f]._getVisibleLabel();if(this._labelCanGetFocus(o)){n++;g=i;h=f;N=true;}}}}if(N){if(this._internalCalcMatrix[p][f]&&this._internalCalcMatrix[p][f].getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowConnection"){this._internalCalcMatrix[p][f]._getVisibleLabel()._setNavigationFocus(false);}else{this._internalCalcMatrix[p][f]._setNavigationFocus(false);}if(this._internalCalcMatrix[g][h]&&this._internalCalcMatrix[g][h].getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowConnection"){o=this._internalCalcMatrix[g][h]._getVisibleLabel();o._setNavigationFocus(true);this._lastNavigationFocusElement=o;}else{this._internalCalcMatrix[g][h]._setNavigationFocus(true);this._lastNavigationFocusElement=this._internalCalcMatrix[g][h];}}return N;};c.prototype._moveHomeEnd=function(d,e){d=d||c._enumMoveDirection.RIGHT;e=e||false;var p=0,f=0;var g=0,h=0;var n=false,i,j,o;for(i=0;i<this._internalCalcMatrix.length;i++){for(j=0;j<this._internalCalcMatrix[i].length;j++){if(this._internalCalcMatrix[i][j]&&this._internalCalcMatrix[i][j].getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowNode"&&this._internalCalcMatrix[i][j]._getNavigationFocus()){p=i;f=j;break;}else if(this._internalCalcMatrix[i][j]&&this._internalCalcMatrix[i][j].getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowConnection"){o=this._internalCalcMatrix[i][j]._getVisibleLabel();if(o&&o._getNavigationFocus()){p=i;f=j;break;}}}}if(e){if(d===c._enumMoveDirection.LEFT){for(i=0;i<p;i++){if(this._internalCalcMatrix[i][f]&&this._internalCalcMatrix[i][f].getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowNode"&&(!this._bHighlightedMode||this._internalCalcMatrix[i][f].getHighlighted())){g=i;h=f;n=true;break;}else if(this._internalCalcMatrix[i][f]&&this._internalCalcMatrix[i][f].getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowConnection"){o=this._internalCalcMatrix[i][f]._getVisibleLabel();if(this._labelCanGetFocus(o)){g=i;h=f;n=true;break;}}}}else if(d===c._enumMoveDirection.RIGHT){for(i=this._internalCalcMatrix.length-1;i>p;i--){if(this._internalCalcMatrix[i][f]&&this._internalCalcMatrix[i][f].getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowNode"&&(!this._bHighlightedMode||this._internalCalcMatrix[i][f].getHighlighted())){g=i;h=f;n=true;break;}else if(this._internalCalcMatrix[i][f]&&this._internalCalcMatrix[i][f].getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowConnection"){o=this._internalCalcMatrix[i][f]._getVisibleLabel();if(this._labelCanGetFocus(o)){g=i;h=f;n=true;break;}}}}}else if(d===c._enumMoveDirection.LEFT){for(j=0;j<f;j++){if(this._internalCalcMatrix[p][j]&&this._internalCalcMatrix[p][j].getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowNode"&&(!this._bHighlightedMode||this._internalCalcMatrix[p][j].getHighlighted())){g=p;h=j;n=true;break;}else if(this._internalCalcMatrix[p][j]&&this._internalCalcMatrix[p][j].getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowConnection"){o=this._internalCalcMatrix[p][j]._getVisibleLabel();if(this._labelCanGetFocus(o)){g=p;h=j;n=true;break;}}}}else if(d===c._enumMoveDirection.RIGHT){for(j=this._internalCalcMatrix[p].length-1;j>f;j--){if(this._internalCalcMatrix[p][j]&&this._internalCalcMatrix[p][j].getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowNode"&&(!this._bHighlightedMode||this._internalCalcMatrix[p][j].getHighlighted())){g=p;h=j;n=true;break;}else if(this._internalCalcMatrix[p][j]&&this._internalCalcMatrix[p][j].getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowConnection"){o=this._internalCalcMatrix[p][j]._getVisibleLabel();if(this._labelCanGetFocus(o)){g=p;h=j;n=true;break;}}}}if(n){if(this._internalCalcMatrix[p][f]&&this._internalCalcMatrix[p][f].getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowConnection"){this._internalCalcMatrix[p][f]._getVisibleLabel()._setNavigationFocus(false);}else{this._internalCalcMatrix[p][f]._setNavigationFocus(false);}if(this._internalCalcMatrix[g][h]&&this._internalCalcMatrix[g][h].getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowConnection"){o=this._internalCalcMatrix[g][h]._getVisibleLabel();o._setNavigationFocus(true);this._lastNavigationFocusElement=o;}else{this._internalCalcMatrix[g][h]._setNavigationFocus(true);this._lastNavigationFocusElement=this._internalCalcMatrix[g][h];}}return n;};c.prototype._moveToNextElement=function(d,s){d=d||c._enumMoveDirection.RIGHT;if(sap.ui.getCore().getConfiguration().getRTL()){if(d===c._enumMoveDirection.RIGHT){d=c._enumMoveDirection.LEFT;}else if(d===c._enumMoveDirection.LEFT){d=c._enumMoveDirection.RIGHT;}}s=s||1;var f=false;var n=false;var p=0,e=1,i,j,o;if(!this._internalCalcMatrix){return false;}var g=0,h=0;for(i=0;i<this._internalCalcMatrix.length;i++){for(j=0;j<this._internalCalcMatrix[i].length;j++){if(this._internalCalcMatrix[i][j]){if(this._internalCalcMatrix[i][j]&&this._internalCalcMatrix[i][j].getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowNode"&&this._internalCalcMatrix[i][j]._getNavigationFocus()){p=g=i;e=h=j;f=true;break;}else if(this._internalCalcMatrix[i][j]&&this._internalCalcMatrix[i][j].getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowConnection"){o=this._internalCalcMatrix[i][j]._getVisibleLabel();if(o&&o._getNavigationFocus()&&o.getEnabled()){p=g=i;e=h=j;f=true;break;}}}}if(f){break;}}if(d===c._enumMoveDirection.RIGHT){for(i=g;i<this._internalCalcMatrix.length;i++){for(j=h+1;j<this._internalCalcMatrix[i].length;j++){if(this._internalCalcMatrix[i][j]&&this._internalCalcMatrix[i][j].getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowNode"){if(f&&(!this._bHighlightedMode||this._internalCalcMatrix[i][j].getHighlighted())){this._internalCalcMatrix[i][j]._setNavigationFocus(true);this._lastNavigationFocusElement=this._internalCalcMatrix[i][j];n=true;break;}}else if(this._internalCalcMatrix[i][j]&&this._internalCalcMatrix[i][j].getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowConnection"){o=this._internalCalcMatrix[i][j]._getVisibleLabel();if(f&&this._labelCanGetFocus(o)){o._setNavigationFocus(true);this._lastNavigationFocusElement=o;n=true;break;}}}h=0;if(n){break;}}}if(d===c._enumMoveDirection.LEFT){for(i=g;i>=0;i--){for(j=h-1;j>=0;j--){if(this._internalCalcMatrix[i][j]&&this._internalCalcMatrix[i][j].getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowNode"){if(f&&(!this._bHighlightedMode||this._internalCalcMatrix[i][j].getHighlighted())){this._lastNavigationFocusElement=this._internalCalcMatrix[i][j]._setNavigationFocus(true);this._lastNavigationFocusElement=this._internalCalcMatrix[i][j];n=true;break;}}else if(this._internalCalcMatrix[i][j]&&this._internalCalcMatrix[i][j].getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowConnection"){o=this._internalCalcMatrix[i][j]._getVisibleLabel();if(f&&this._labelCanGetFocus(o)){o._setNavigationFocus(true);this._lastNavigationFocusElement=o;n=true;break;}}}if(i>0){h=this._internalCalcMatrix[i-1].length;}if(n){break;}}}var k,m,r;if(d===c._enumMoveDirection.UP){for(i=g-1;i>=0;i--){k=0;while(!n){m=h-k;r=h+k;if(m>=0&&this._internalCalcMatrix[i][m]&&this._internalCalcMatrix[i][m].getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowNode"){if(f&&(!this._bHighlightedMode||this._internalCalcMatrix[i][m].getHighlighted())){this._internalCalcMatrix[i][m]._setNavigationFocus(true);this._lastNavigationFocusElement=this._internalCalcMatrix[i][m];n=true;break;}}else if(m>=0&&this._internalCalcMatrix[i][m]&&this._internalCalcMatrix[i][m].getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowConnection"){o=this._internalCalcMatrix[i][m]._getVisibleLabel();if(f&&this._labelCanGetFocus(o)){o._setNavigationFocus(true);this._lastNavigationFocusElement=o;n=true;break;}}if(r<this._internalCalcMatrix[i].length&&this._internalCalcMatrix[i][r]&&this._internalCalcMatrix[i][r].getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowNode"){if(f&&(!this._bHighlightedMode||this._internalCalcMatrix[i][r].getHighlighted())){this._internalCalcMatrix[i][r]._setNavigationFocus(true);this._lastNavigationFocusElement=this._internalCalcMatrix[i][r];n=true;break;}}else if(r>=0&&this._internalCalcMatrix[i][r]&&this._internalCalcMatrix[i][r].getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowConnection"){o=this._internalCalcMatrix[i][r]._getVisibleLabel();if(f&&this._labelCanGetFocus(o)){o._setNavigationFocus(true);this._lastNavigationFocusElement=o;n=true;break;}}if(m<0&&r>this._internalCalcMatrix[i].length){break;}k++;}}}if(d===c._enumMoveDirection.DOWN){for(i=g+1;i<this._internalCalcMatrix.length;i++){k=0;while(!n){m=h-k;r=h+k;if(m>=0&&this._internalCalcMatrix[i][m]&&this._internalCalcMatrix[i][m].getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowNode"){if(f&&(!this._bHighlightedMode||this._internalCalcMatrix[i][m].getHighlighted())){this._lastNavigationFocusElement=this._internalCalcMatrix[i][m]._setNavigationFocus(true);this._lastNavigationFocusElement=this._internalCalcMatrix[i][m];n=true;break;}}else if(m>=0&&this._internalCalcMatrix[i][m]&&this._internalCalcMatrix[i][m].getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowConnection"){o=this._internalCalcMatrix[i][m]._getVisibleLabel();if(f&&this._labelCanGetFocus(o)){o._setNavigationFocus(true);this._lastNavigationFocusElement=o;n=true;break;}}if(r<this._internalCalcMatrix[i].length&&this._internalCalcMatrix[i][r]&&this._internalCalcMatrix[i][r].getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowNode"){if(f&&(!this._bHighlightedMode||this._internalCalcMatrix[i][r].getHighlighted())){this._lastNavigationFocusElement=this._internalCalcMatrix[i][r]._setNavigationFocus(true);this._lastNavigationFocusElement=this._internalCalcMatrix[i][r];n=true;break;}}else if(r>=0&&this._internalCalcMatrix[i][r]&&this._internalCalcMatrix[i][r].getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowConnection"){o=this._internalCalcMatrix[i][r]._getVisibleLabel();if(f&&this._labelCanGetFocus(o)){o._setNavigationFocus(true);this._lastNavigationFocusElement=o;n=true;break;}}if(m<0&&r>this._internalCalcMatrix[i].length){break;}k++;}}}if(n){if(this._internalCalcMatrix[p][e]&&this._internalCalcMatrix[p][e].getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowNode"){this._internalCalcMatrix[p][e]._setNavigationFocus(false);}else{this._internalCalcMatrix[p][e]._getVisibleLabel()._setNavigationFocus(false);}}return n;};c.prototype._getScrollContainerOnZoomChanged=function(s,$){s.scrollLeft=Math.round($.get()[0].scrollWidth/s.scrollWidth*s.scrollLeft);s.scrollTop=Math.round($.get()[0].scrollHeight/s.scrollHeight*s.scrollTop);s.scrollWidth=$.get()[0].scrollWidth;s.scrollHeight=$.get()[0].scrollHeight;return s;};c.prototype._mergeLaneIdNodeStates=function(d){var p=0;var n=0;var N=0;var i=0;var e=0;for(var s=0;s<5;s++){for(var f=0;f<d.length;f++){switch(d[f][s].state){case l.ProcessFlowNodeState.Positive:p=p+d[f][s].value;break;case l.ProcessFlowNodeState.Negative:n=n+d[f][s].value;break;case l.ProcessFlowNodeState.Neutral:N=N+d[f][s].value;break;case l.ProcessFlowNodeState.Planned:i=i+d[f][s].value;break;case l.ProcessFlowNodeState.PlannedNegative:n=n+d[f][s].value;break;case l.ProcessFlowNodeState.Critical:e=e+d[f][s].value;break;default:break;}}}return[{state:l.ProcessFlowNodeState.Positive,value:p},{state:l.ProcessFlowNodeState.Negative,value:n},{state:l.ProcessFlowNodeState.Neutral,value:N},{state:l.ProcessFlowNodeState.Planned,value:i},{state:l.ProcessFlowNodeState.Critical,value:e}];};c.prototype._setFocusOnHeader=function(n){var t=this.$("thead");if(n){t.focus();t.addClass("sapSuiteUiCommonsPFHeaderFocused");this._headerHasFocus=true;}else{t.removeClass("sapSuiteUiCommonsPFHeaderFocused");this._headerHasFocus=false;}};c.prototype._scroll=function(d,e){var o=this._getScrollContainer().get(0);var s=o.scrollLeft;if(!D.browser.msie&&!D.browser.edge&&this._bRtl){d=-d;}var S=s+d;q(o).stop(true,true).animate({scrollLeft:S},e,q.proxy(this._adjustAndShowArrow,this));};c.prototype._adjustAndShowArrow=function(){this._checkOverflow(this._getScrollContainer().get(0),this.$());if(this.getScrollable()){this._moveArrowAndCounterVertical();}if(this._isFocusChanged){this._setFocusToNode(this._lastNavigationFocusElement);this._isFocusChanged=false;}};c.prototype._getScrollingArrow=function(d){var s;if(D.system.desktop){s="sap-icon://navigation-"+d+"-arrow";}else{s="sap-icon://slim-arrow-"+d;}var p={src:s};var e="sapPFHArrowScrollLeft";var r="sapPFHArrowScrollRight";var f=["sapPFHArrowScroll",e];var g=["sapPFHArrowScroll",r];if(d===c._constants.left){if(!this._oArrowLeft){this._oArrowLeft=M.ImageHelper.getImageControl(this.getId()+c._constants.arrowScrollLeftMinus,null,this,p,f);}return this._oArrowLeft;}if(d===c._constants.right){if(!this._oArrowRight){this._oArrowRight=M.ImageHelper.getImageControl(this.getId()+c._constants.arrowScrollRightMinus,null,this,p,g);}return this._oArrowRight;}};c.prototype._checkScrolling=function(s,$){var S=false;if(s){if(s.scrollWidth>s.clientWidth){S=true;}}if(this._arrowScrollable!==S){$.toggleClass("sapPFHScrollable",S);$.toggleClass("sapPFHNotScrollable",!S);this._arrowScrollable=S;}return S;};c.prototype._updateLeftCounter=function(){var s;if(!this._bRtl){s=this._getScrollContainer().scrollLeft();}else{s=this._getScrollContainer().scrollRightRTL();}var i=Math.round(s/this._scrollStep);this.$(c._constants.counterLeft).text(i.toString());return i;};c.prototype._updateRightCounter=function(s,d){var S;var i;if(!this._bRtl){S=this._getScrollContainer().scrollLeft();i=Math.round((d-S-s)/this._scrollStep);}else{S=this._getScrollContainer().scrollLeftRTL();i=Math.round(S/this._scrollStep);}this.$(c._constants.counterRight).text(i.toString());return i;};c.prototype._moveArrowAndCounterVertical=function(){var s=this._getScrollContainer().scrollTop();if(s>0){var A=this._iInitialArrowTop-s;var i=this._iInitialCounterTop-s;var d=this._iInitialCounterTop-this._iInitialArrowTop;if(A>0){this.$(c._constants.arrowScrollRight).css(c._constants.top,A+c._constants.px);this.$(c._constants.arrowScrollLeft).css(c._constants.top,A+c._constants.px);}else{this.$(c._constants.arrowScrollRight).css(c._constants.top,"0px");this.$(c._constants.arrowScrollLeft).css(c._constants.top,"0px");}if(i>d){this.$(c._constants.counterRight).css(c._constants.top,i+c._constants.px);this.$(c._constants.counterLeft).css(c._constants.top,i+c._constants.px);}else{this.$(c._constants.counterRight).css(c._constants.top,d+c._constants.px);this.$(c._constants.counterLeft).css(c._constants.top,d+c._constants.px);}}else{this.$(c._constants.arrowScrollRight).css(c._constants.top,this._iInitialArrowTop+c._constants.px);this.$(c._constants.arrowScrollLeft).css(c._constants.top,this._iInitialArrowTop+c._constants.px);this.$(c._constants.counterRight).css(c._constants.top,this._iInitialCounterTop+c._constants.px);this.$(c._constants.counterLeft).css(c._constants.top,this._iInitialCounterTop+c._constants.px);}};c.prototype._checkOverflow=function(s,$){if(this._checkScrolling(s,$)&&s){this._setScrollWidth();var S=false;var d=false;var o=20;var i=this._getScrollContainer().scrollLeft();var e=s.scrollWidth;var f=s.clientWidth;if(Math.abs(e-f)===1){e=f;}if(!this._bRtl){if(i>o){S=true;}if((e>f)&&(i+f+o<e)){d=true;}}else{var g=q(s);if(g.scrollLeftRTL()>o){d=true;}if(g.scrollRightRTL()>o){S=true;}}this._updateLeftCounter();this._updateRightCounter(f,e);if(d!==this._bPreviousScrollForward||(S!==this._bPreviousScrollBack)){this._bPreviousScrollForward=d;this._bPreviousScrollBack=S;$.toggleClass("sapPFHScrollBack",S);$.toggleClass("sapPFHNoScrollBack",!S);$.toggleClass("sapPFHScrollForward",d);$.toggleClass("sapPFHNoScrollForward",!d);}}else{this._bPreviousScrollForward=false;this._bPreviousScrollBack=false;}};c.prototype._setParentForNodes=function(d){var I=d?d.length:0;var e;var i,j;for(var o in d){d[o].removeAllAssociation(c._constants.parents,true);}for(i=0;i<I;i++){e=d[i].getChildren();if(e){for(j=0;j<e.length;j++){var f=this._getNode(c._getChildIdByElement(e[j]),d);if(f){f.addAssociation(c._constants.parents,d[i],true);}}}}};c.prototype._getConnectionsMap=function(){var d=[];var n=this.getNodes();for(var i=0;i<n.length;i++){var p=this._getPositionOfNodeInMatrix(this._internalCalcMatrix,n[i]);var e=n[i].getChildren();if(e){for(var j=0;j<e.length;j++){var o={};o.sourceNode=n[i];var f=c._getChildIdByElement(e[j]);var g=this._getNode(f,n);if(g){if(typeof e[j]==="object"){o.label=e[j].connectionLabel;}o.targetNode=g;var h=this._getPositionOfNodeInMatrix(this._internalCalcMatrix,o.targetNode);o.connectionParts=this._calculateConnectionParts(p,h);d.push(o);}}}}this._internalConnectionMap=d;return d;};c.prototype._getPositionOfNodeInMatrix=function(m,n){var p={};for(var i=0;i<m.length;i++){var d=m[i];for(var j=0;j<d.length;j++){var e=d[j];if(e&&e.getMetadata().getName()==="sap.suite.ui.commons.ProcessFlowNode"&&e.getNodeId()===n.getNodeId()){p.y=i;p.x=j;return p;}}}return p;};c.prototype._calculateConnectionParts=function(p,d){var e=[];var s=p.y;var S=p.x;S++;e.push({x:S,y:s});if(d.y>=p.y){while(s<d.y){s++;e.push({x:S,y:s});}}else{while(s>d.y){s--;e.push({x:S,y:s});}}while(S<d.x-1){S++;e.push({x:S,y:s});}return e;};c.prototype._getConnectionMapEntries=function(d){var f=[];var o=null;var e=null;if(this._internalConnectionMap){for(var i=0;i<this._internalConnectionMap.length;i++){e=this._internalConnectionMap[i];if(e.label&&e.label.getId()===d.getId()){o=e;break;}}e=null;for(var j=0;j<this._internalConnectionMap.length;j++){e=this._internalConnectionMap[j];if(e.targetNode&&e.targetNode.getNodeId()===o.targetNode.getNodeId()){f.push(e);}}}return f;};c.prototype._createLabelPressEventArgs=function(d,e){var E={};var f=[];if(e){for(var i=0;i<e.length;i++){var o={sourceNode:e[i].sourceNode,targetNode:e[i].targetNode,label:e[i].label};f.push(o);}}E.selectedLabel=d;E.connections=f;return E;};c.prototype.applyNodeDisplayState=function(){var I=this.getNodes(),n=I?I.length:0,i=0;if(n!==0){while(i<n){I[i]._setRegularState();i++;}i=0;while((i<n)&&!I[i].getHighlighted()&&!I[i].getSelected()){i++;}if(i<n){i=0;while(i<n){if(!I[i].getHighlighted()&&!I[i].getSelected()){I[i]._setDimmedState();}i++;}}}};c.InternalMatrixCalculation.prototype.checkInputNodeConsistency=function(e){var E=[],j,s,i,d,o,f=0;Object.keys(e).forEach(function(g){o=e[g];d=o.oNode.getChildren();i=d?d.length:0;if(o.oNode.getFocused()){f++;}j=0;while(j<i){s=c._getChildIdByElement(d[j]);if(!e[s]){E.push("Node identificator "+s+" used in children definition is not presented as the node itself. Element : "+o.nodeId);}j++;}});if(E.length>0){throw E;}return f>1;};c.InternalMatrixCalculation.prototype.processCurrentElement=function(d,e,m){var E,f,n=true,g=true;if(d.isProcessed){return m;}this.nodePositions[d.nodeId]={"c":d,"x":this.iPositionX,"y":this.iPositionY*2};m[this.iPositionX][this.iPositionY++]=d;E=d.oNode.getChildren();d.isProcessed=true;f=this._sortBasedOnChildren(E,e);if(f){f.forEach(function(o){if(!o.isProcessed){g=false;while(this.iPositionY<o.lane){m[this.iPositionX][this.iPositionY++]=null;}m=this.processCurrentElement(o,e,m);}else if(n&&g){this.iPositionX++;n=false;}}.bind(this));}if(!E||g){if(n){this.iPositionX++;}this.iPositionY=0;}return m;};c.prototype.getZoomLevel=function(){return this._zoomLevel;};c.prototype.setZoomLevel=function(z){if(!this._getScrollContainer()){return;}var $=this._getScrollContainer();var s=null;var S;if($.get().length){s={scrollWidth:$.get()[0].scrollWidth,scrollHeight:$.get()[0].scrollHeight,scrollLeft:$.get()[0].scrollLeft,scrollTop:$.get()[0].scrollTop};S=s;if(this._zoomLevel===z){this._isInitialZoomLevelNeeded=false;return;}}if(!(z in l.ProcessFlowZoomLevel)){this._handleException("\""+z+"\" is not a valid entry of the enumeration for property zoom level of ProcessFlow");return;}this._zoomLevel=z;if(this._isInitialZoomLevelNeeded){this._isInitialZoomLevelNeeded=false;this.invalidate();}else{this.rerender();}if(s){if(D.support.touch||q.sap.simulateMobileOnDesktop){var h=parseInt(this._getScrollContainer().css("height").slice(0,-2),10);var w=parseInt(this._getScrollContainer().css("width").slice(0,-2),10);var i=this._getScrollContainer()[0].scrollHeight;var d=this._getScrollContainer()[0].scrollWidth;if(this.getScrollable()&&(i>h||d>w)){this._switchCursors(this._getScrollContainer(),this._defaultCursorClass,this._grabCursorClass);this._getScrollContainer().css("overflow","auto");}}$=this._getScrollContainer();S=this._getScrollContainerOnZoomChanged(s,$);$.scrollLeft(S.scrollLeft);$.scrollTop(S.scrollTop);this._adjustAndShowArrow();if(this._isFocusChanged){this._setFocusToNode();this._isFocusChanged=false;}}};c.prototype.zoomOut=function(){var s=this.getZoomLevel();var n=s;switch(s){case(l.ProcessFlowZoomLevel.One):n=l.ProcessFlowZoomLevel.Two;break;case(l.ProcessFlowZoomLevel.Two):n=l.ProcessFlowZoomLevel.Three;break;case(l.ProcessFlowZoomLevel.Three):n=l.ProcessFlowZoomLevel.Four;break;default:break;}this.setZoomLevel(n);return this.getZoomLevel();};c.prototype.zoomIn=function(){var s=this.getZoomLevel();var n=s;switch(s){case(l.ProcessFlowZoomLevel.Four):n=l.ProcessFlowZoomLevel.Three;break;case(l.ProcessFlowZoomLevel.Three):n=l.ProcessFlowZoomLevel.Two;break;case(l.ProcessFlowZoomLevel.Two):n=l.ProcessFlowZoomLevel.One;break;default:break;}this.setZoomLevel(n);return this.getZoomLevel();};c.prototype.updateModel=function(){var n=this.getNodes();n.forEach(function(e){e._mergedLaneId=false;});var d=this.getLanes();d.forEach(function(e){e._mergedLanePosition=false;});this._internalLanes=[];if(this._isHeaderMode()){var o=this.getBindingInfo("lanes");this.getModel(o.model).refresh();}else{var N=this.getBindingInfo("nodes");this.getModel(N.model).refresh();}this.rerender();};c.prototype.optimizeLayout=function(i){if(i===undefined){i=true;}if(this._isLayoutOptimized!==i){this._isLayoutOptimized=i;this.updateModel();}return this;};c.prototype.getFocusedNode=function(){return this._lastNavigationFocusElement&&this._lastNavigationFocusElement.sId;};c.prototype.updateNodesOnly=function(){var n=this.getBindingInfo("nodes");this.getModel(n.model).refresh();this.rerender();};c.prototype.setSelectedPath=function(s,t){var n=this.getNodes(),i;if(n){if(s&&t){var d=0;for(i=0;i<n.length;i++){if(n[i].getNodeId()===s||n[i].getNodeId()===t){n[i].setSelected(true);d++;}else{n[i].setSelected(false);}}if(d===2){this.rerender();}}else if(!s&&!t){for(i=0;i<n.length;i++){n[i].setSelected(false);}this.rerender();}}};c.prototype.setShowLabels=function(v){var o=this.getShowLabels();if(o&&!v){this.setProperty("showLabels",v,true);if(!this.getShowLabels()){this.setSelectedPath(null,null);}}else{this.setProperty("showLabels",v);}return this;};c.prototype.setFocusToLabel=function(d){this._changeNavigationFocus(this._lastNavigationFocusElement,d);};c.prototype._labelCanGetFocus=function(d){return d&&d.getEnabled()&&(!this._bHighlightedMode||d._bHighlighted);};c.prototype.getNode=function(n){var N=this.getNodes();for(var i=0;i<N.length;i++){if(N[i].getProperty("nodeId")===n){return N[i];}}};c.prototype.getLane=function(s){var d=this.getLanes();for(var i=0;i<d.length;i++){if(d[i].getProperty("laneId")===s){return d[i];}}};c.prototype.removeAllLanes=function(){this.removeAllAggregation("lanes");this._internalLanes=[];};return c;});
