/*!
 * 
		SAP UI development toolkit for HTML5 (SAPUI5)
		(c) Copyright 2009-2015 SAP SE. All rights reserved
	
 */
sap.ui.define(["sap/ui/thirdparty/jquery",'sap/m/Image','./library','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/Device','sap/ui/core/Icon',"./ProcessFlowLaneHeaderRenderer"],function(q,I,l,C,a,D,b,P){"use strict";var c=C.extend("sap.suite.ui.commons.ProcessFlowLaneHeader",{metadata:{library:"sap.suite.ui.commons",properties:{text:{type:"string",group:"Misc",defaultValue:null},iconSrc:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},position:{type:"int",group:"Misc",defaultValue:null},laneId:{type:"string",group:"Misc",defaultValue:null},state:{type:"object",group:"Misc",defaultValue:null},zoomLevel:{type:"sap.suite.ui.commons.ProcessFlowZoomLevel",group:"Misc",defaultValue:null}},events:{press:{parameters:{oEvent:{type:"object"}}}}}});c.prototype._oResBundle=null;c.prototype._mergedLanePosition=null;c.symbolType={startSymbol:"startSymbol",endSymbol:"endSymbol",processSymbol:"processSymbol",standardType:"standardType"};c._constants={halfGapSize:0.0241,minPercentage:0.025,ringThickness:5,ringInnerRadius:24,positionX:32,positionY:32,outerCircleRadius:32,outerCircleStrokeColor:"OuterCircleStrikeColor",outerCircleStrokeWidth:1,sectorPositiveColor:"suiteUiCommonsProcessFlowHeaderPositiveColor",sectorNegativeColor:"suiteUiCommonsProcessFlowHeaderNegativeColor",sectorNeutralColor:"suiteUiCommonsProcessFlowHeaderNeutralColor",sectorCriticalColor:"suiteUiCommonsProcessFlowHeaderCriticalColor",sectorPlannedColor:"suiteUiCommonsProcessFlowHeaderPlannedColor",ellipsis:'...',ellipsisLength:3};c.prototype.init=function(){this._virtualTableSpan=1;if(!this._oResBundle){this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.suite.ui.commons");}};c.prototype.exit=function(){this._destroyImage();this.$().unbind("click",this.ontouchend);};c.prototype.onBeforeRendering=function(){this.$("lh-icon").off('click',q.proxy(this.ontouchend,this));this.$().unbind("click",this.ontouchend);};c.prototype.onAfterRendering=function(){var t=this.$();var $=this.$("lh-icon");var s='click';if(D.support.touch){s='touchend';}if($.length>0){$.on(s,q.proxy(this.ontouchend,this));$.css("cursor","inherit");}this.$().bind("click",q.proxy(this.ontouchend,this));if(this._isHeaderMode()){t.addClass("suiteUiProcessFlowLaneHeaderPointer");}else{t.removeClass("suiteUiProcessFlowLaneHeaderPointer");}if(D.browser.msie||D.browser.mozilla){this.$("lh-text").css("word-break","break-all");}if(!this._ellipsisDisabled&&!c._hasNativeLineClamp){this._clampText();}};c.prototype.ontouchend=function(e){if(e&&!e.isDefaultPrevented()){e.preventDefault();}if(this){this.firePress(this);}if(e&&!e.isPropagationStopped()){e.stopPropagation();}if(e&&!e.isImmediatePropagationStopped()){e.stopImmediatePropagation();}};c.prototype._setMergedPosition=function(p){this._mergedLanePosition=p;};c.prototype._getSymbolType=function(){return this._oSymbolType?this._oSymbolType:c.symbolType.standardType;};c.prototype._setSymbolType=function(s,d){d._oSymbolType=s;};c.prototype._getImage=function(i,s){this._destroyImage();if(this._oImageControl){this._oImageControl.setSrc(s);}else{this._oImageControl=a.createControlByURI(s,I);this._oImageControl.sId=i;this._oImageControl.setParent(this,null,true);}if(this._oImageControl instanceof b){this._oImageControl.setUseIconTooltip(false);}return this._oImageControl;};c.prototype._setHeaderMode=function(i){this._bHeaderMode=i;};c._setVirtualTableSpan=function(e){this._virtualTableSpan=e;};c._getVirtualTableSpan=function(){return this._virtualTableSpan;};c.prototype._isHeaderMode=function(){return this._bHeaderMode;};c.prototype._clampValues=function(d,m,e){var i=d.length-1,f=false,v;while(i>=0){v=d[i];if(v<m){d[i]=e;f=true;}i--;}return f;};c.prototype._rescaleToUnit=function(r,m){var R,i,v,V,d,e;if(!m){m=0;}i=r.length-1;R=0;v=V=0;while(i>=0){d=r[i];if(d>0){if(d<=m){V++;}else{R+=r[i];}v++;}i--;}R-=(v-V)*m;e=(1-v*m)/R;i=r.length-1;while(i>=0){d=r[i];if(d>0){if(d<=m){r[i]=m;}else{r[i]=(d-m)*e+m;}}i--;}};c.prototype._countGaps=function(d){var i=d.length-1,g=0;while(i>=0){if(d[i]>0){g++;}i--;}if(g===1){g=0;}return g;};c.prototype._rescaleByFactor=function(r,f){var i=r.length-1;while(i>=0){r[i]*=f;i--;}};c.prototype._colorMap=[c._constants.sectorPositiveColor,c._constants.sectorNegativeColor,c._constants.sectorNeutralColor,c._constants.sectorPlannedColor,c._constants.sectorCriticalColor];c.prototype._calculateSectorRangeDefinitions=function(d,f){var e=[],g=-Math.PI/2,h,j=d.length,i=0;while(i<j){if(d[i]>0){h=g+2*Math.PI*d[i];e.push({start:g,end:h,color:this._colorMap[i]});g=h+f;}i++;}return e;};c.prototype._renderDonutPercentages=function(r){var s=this.getState(),g=0,S,p=[0,0,0,0],f,d,h=c._constants.halfGapSize,R=c._constants.ringInnerRadius,i=c._constants.ringThickness,e=c._constants.ringInnerRadius+i,o=c._constants.outerCircleStrokeColor,O=c._constants.outerCircleStrokeWidth,j=c._constants.outerCircleRadius,k=c._constants.positionX,m=c._constants.positionY,M=c._constants.minPercentage;if(s&&Object.prototype.toString.call(s)==='[object Array]'&&(s.length>0)){s.forEach(function(n){switch(n.state){case l.ProcessFlowNodeState.Positive:p[0]=n.value;break;case l.ProcessFlowNodeState.Negative:p[1]=n.value;break;case l.ProcessFlowNodeState.Neutral:p[2]=n.value;break;case l.ProcessFlowNodeState.Planned:p[3]=n.value;break;case l.ProcessFlowNodeState.Critical:p[4]=n.value;break;default:p[3]=n.value;}});this._clampValues(p,0,0);this._rescaleToUnit(p);this._rescaleToUnit(p,M);g=this._countGaps(p);f=(1-g*h/Math.PI);this._rescaleByFactor(p,f);this._renderCircle(r,o,O,k,m,j);if(g>0){S=this._calculateSectorRangeDefinitions(p,2*h);this._renderDonutSectors(r,S,k,m,R,e);}else{d=this._selectColor(p);this._renderCircle(r,d,i,k,m,R+i/2);}}else{this._renderCircle(r,o,O,k,m,j);}};c.prototype._renderCircle=function(r,s,d,p,e,f){r.write("<circle");r.writeAttribute("id",this.getId()+"-donut-circle");if(s!==c._constants.outerCircleStrokeColor){r.writeAttributeEscaped("class","suiteUiCommonsProcessFlowHeaderIconFill "+s);}else{r.writeAttribute("class","suiteUiCommonsProcessFlowHeaderIconFill");}r.writeAttributeEscaped("stroke-width",d);r.writeAttributeEscaped("cx",p);r.writeAttributeEscaped("cy",e);r.writeAttributeEscaped("r",f);r.write("></circle>");};c.prototype._renderDonutSectors=function(r,s,p,d,e,f){var i=0,g=s.length,S,h;while(i<g){S=s[i];h=this._getDonutSectorPath(p,d,S.start,S.end,e,f);r.write("<path");r.writeAttribute("id",this.getId()+"-donut-segment-"+i);r.writeAttributeEscaped("d",h);r.writeAttributeEscaped("class",S.color);r.writeAttribute("opacity","1");r.write("></path>");i++;}};c.prototype._selectColor=function(p){var s;if(p[0]){s=c._constants.sectorPositiveColor;}else if(p[1]){s=c._constants.sectorNegativeColor;}else if(p[2]){s=c._constants.sectorNeutralColor;}else if(p[3]){s=c._constants.sectorPlannedColor;}else if(p[4]){s=c._constants.sectorCriticalColor;}else{s=c._constants.sectorNeutralColor;}return s;};c.prototype._getDonutSectorPath=function(p,d,s,e,r,f){var o=0,g,h,i,j,S,k,E,m,n;if((e-s)%(Math.PI*2)>Math.PI){o=1;}k=Math.cos(s);E=Math.cos(e);m=Math.sin(s);n=Math.sin(e);g=(p+r*k).toFixed(3)+','+(d+r*m).toFixed(3);h=(p+f*k).toFixed(3)+','+(d+f*m).toFixed(3);i=(p+f*E).toFixed(3)+','+(d+f*n).toFixed(3);j=(p+r*E).toFixed(3)+','+(d+r*n).toFixed(3);S="M"+g+"L"+h+"A"+f+','+f+" 0 "+o+" 1 "+i+"L"+j+"A"+r+','+r+" 0 "+o+" 0 "+g+"z";return S;};c.prototype._destroyImage=function(){if(this._oImageControl){this._oImageControl.destroy();}this._oImageControl=null;};c.prototype._clampText=function(){var $=this.$("lh-text").length?this.$("lh-text"):null,t=this.getText(),L="",e=c._constants.ellipsis,E=c._constants.ellipsisLength,s=E+1,m,i=t.length,M,v;if($){M=parseInt($.css("height").slice(0,-2),10);if($[0].scrollHeight>M){v=$.css("visibility");$.css("visibility","hidden");L=t;do{m=(s+i)>>1;$.textContent=t.slice(0,m-E)+e;if($.scrollHeight>M){i=m;}else{s=m;L=$.textContent;}}while(i-s>1);$.css("visibility",v);}if($.scrollHeight>M){$.textContent=L;}}};c._hasNativeLineClamp=(function(){return document.documentElement.style.webkitLineClamp!==undefined;}());c.prototype._getAriaText=function(){var A="";var s=this.getState();if(s){var d=[];for(var i in s){d.push(s[i].value);}this._clampValues(d,0,0);this._rescaleToUnit(d);A=this._oResBundle.getText('PF_ARIA_STATUS');for(var j in s){if(s[j].value!==0){var v=" "+Math.round(d[j]*100)+"% "+s[j].state+",";A=A.concat(v);}}A=A.slice(0,-1);}return A;};c.prototype._getSymbolAriaText=function(){var A="";switch(this._getSymbolType()){case c.symbolType.startSymbol:A=this._oResBundle.getText('PF_ARIA_SYMBOL_LANE_START');break;case c.symbolType.endSymbol:A=this._oResBundle.getText('PF_ARIA_SYMBOL_LANE_END');break;case c.symbolType.processSymbol:A=this._oResBundle.getText('PF_ARIA_SYMBOL_LANE_PROCESS');break;default:}return A;};c.createNewStartSymbol=function(i){var s=new c({laneId:"processFlowLaneStart"});s._setSymbolType(c.symbolType.startSymbol,s);s._setHeaderMode(i);return s;};c.createNewEndSymbol=function(i){var e=new c({laneId:"processFlowLaneEnd"});e._setSymbolType(c.symbolType.endSymbol,e);e._setHeaderMode(i);return e;};c.createNewProcessSymbol=function(i){var p=new c({laneId:"processFlowLaneProcess",iconSrc:"sap-icon://process"});p._setSymbolType(c.symbolType.processSymbol,p);p._setHeaderMode(i);return p;};c.enableEllipsisSupportForText=function(i){this._ellipsisDisabled=!i;};c.prototype.getPosition=function(){if(this._mergedLanePosition){return this._mergedLanePosition;}else{return this.getProperty("position");}};return c;});
