/*!
 * 
		SAP UI development toolkit for HTML5 (SAPUI5)
		(c) Copyright 2009-2015 SAP SE. All rights reserved
	
 */
sap.ui.define(["sap/suite/ui/commons/library","sap/ui/thirdparty/jquery","sap/ui/core/Control","./SvgBase","./Node","./Line","./Group","./layout/LayeredLayout","./Tooltip","sap/ui/core/Popup","sap/ui/model/json/JSONModel","sap/m/SuggestionItem","./Utils","sap/m/ButtonType","sap/m/Label","sap/m/OverflowToolbar","sap/m/OverflowToolbarButton","sap/m/SearchField","sap/m/ToolbarSpacer","sap/ui/core/CustomData","sap/ui/model/Filter","sap/m/OverflowToolbarLayoutData","./KeyboardNavigator","sap/ui/core/theming/Parameters","sap/base/Log","sap/ui/performance/Measurement","sap/base/util/uid","sap/base/security/encodeXML","./GraphRenderer","sap/m/ToggleButton","sap/ui/core/routing/HashChanger"],function(l,q,C,S,N,L,G,c,T,P,J,d,U,B,e,O,f,g,h,j,F,k,K,m,n,M,u,o,p,r,H){"use strict";var s=l.networkgraph.Orientation,t=l.networkgraph.LayoutRenderType,R=l.networkgraph.RenderType;var A="nodes",v="lines",w="groups";var Z=[0.05,0.1,0.25,0.33,0.50,0.67,0.75,0.80,0.90,1,1.1,1.25,1.5,1.75,2,2.5,3,4,5],D=1,x=0.4,y=100000;var z={Group:"group",Node:"node",Line:"line",IsLastKey:"islast",TypeKey:"type"};var E=Object.freeze({Node:"Node",Line:"Line",Group:"Group"});var I=sap.ui.getCore().getLibraryResourceBundle("sap.suite.ui.commons");var Q=0,V=100;var W=d.extend("sap.suite.ui.commons.networkgraph.LimitedSuggestionItem",{render:function(a,i,b,Y){if(Q++<V){d.prototype.render.call(this,a,i,b,Y);}}});var X=S.extend("sap.suite.ui.commons.networkgraph.Graph",{metadata:{library:"sap.suite.ui.commons",properties:{height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"100%"},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"100%"},orientation:{type:"sap.suite.ui.commons.networkgraph.Orientation",group:"Behavior",defaultValue:s.LeftRight},enableZoom:{type:"boolean",group:"Behavior",defaultValue:true},enableWheelZoom:{type:"boolean",group:"Behavior",defaultValue:true},backgroundImage:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},backgroundColor:{type:"sap.suite.ui.commons.networkgraph.BackgroundColor",group:"Appearance",defaultValue:"White"},renderType:{type:"sap.suite.ui.commons.networkgraph.RenderType",group:"Appearance",defaultValue:R.Html},noData:{type:"boolean",group:"Behavior",defaultValue:false},noDataText:{type:"string",group:"Behavior",defaultValue:""}},aggregations:{lines:{type:"sap.suite.ui.commons.networkgraph.Line",multiple:true,singularName:"line"},nodes:{type:"sap.suite.ui.commons.networkgraph.Node",multiple:true,singularName:"node"},groups:{type:"sap.suite.ui.commons.networkgraph.Group",multiple:true,singularName:"group"},legend:{type:"sap.ui.core.Control",multiple:false},layoutAlgorithm:{type:"sap.suite.ui.commons.networkgraph.layout.LayoutAlgorithm",multiple:false},statuses:{type:"sap.suite.ui.commons.networkgraph.Status",multiple:true,singularName:"status"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{graphReady:{},afterLayouting:{},beforeLayouting:{},zoomChanged:{},failure:{parameters:{type:"string",message:"string"}},selectionChange:{parameters:{items:{type:"sap.suite.ui.commons.networkgraph.ElementBase[]"}}},searchSuggest:{parameters:{term:{type:"string"}}},search:{parameters:{term:{type:"string"},key:{type:"string"}}}}}});X.FAILURE_TYPE={INCONSISTENT_MODEL:"Inconsistent model",LAYOUT_FAILURE:"Layout failure"};X.prototype.ZOOM_100=D;X.prototype.init=function(){this._fZoomLevel=1;this._mSelectedNodes={};this._mSelectedLines={};this._bIsLayedOut=false;this._bIsFullScreen=false;this._mNodes={};this._bNeedNodeProcessing=true;this._oFullScreenContainer=null;this._bRequiresDataProcessing=true;this._oPanning={};this._oLegendLabels={};this._iRunningLayouts=0;this._oLastLayout=null;this._bIsRtl=sap.ui.getCore().getConfiguration().getRTL();this._oFocus=null;this._tooltip=this._createTooltip();this._bIsInvalid=false;this._oStatuses={};this._aShadedNodes=[];this._createToolbar();this.oHashChanger=new H();this.oHashChanger.init();};X.prototype.onBeforeRendering=function(){this._bIsRtl=sap.ui.getCore().getConfiguration().getRTL();this.setBusy(false);this.setBusyIndicatorDelay(0);this._iNodeMaxWidth=0;this.getNodes().forEach(function(a){a._resetDimensions();var i=a.getMaxWidth();if(i>this._iNodeMaxWidth){this._iNodeMaxWidth=i;}}.bind(this));this.getLines().forEach(function(a){a._resetLayoutData();});if(!this.getNoData()){this._loadData();}};X.prototype.onAfterRendering=function(){var a="",b=this.getNodes(),i=this._bIsRtl?"direction="+"\"rtl\"":"",Y="<rect class=\"sapSuiteFlickerFreeRect\" x=\"0\" y=\"0\"></rect>";this.$divnodes=this.$("divnodes");this.$divgroups=this.$("divgroups");this.$background=this.$("background");this.$tooltips=this.$("tooltiplayer");this.$scroller=this.$("scroller");this._$innerscroller=this.$("innerscroller");this.$legend=this.$("legend");if(this._oFullScreenContainer&&this._bIsFullScreen){this._oFullScreenContainer.$content=this.$();this.$().addClass("sapSuiteUiCommonsNetworkGraphFullScreen");}if(b.length===0||this._bIsInvalid||this.getNoData()){if(this._bIsInvalid){this.$scroller.html("<span class=\"sapSuiteNetworkGraphErrorText\">"+I.getText("NETWORK_GRAPH_WRONGDATA")+"</span>");}if(this._oSuggestionItemsModel){this._oSuggestionItemsModel.setData("");}this.fireGraphReady();return;}this.setBusy(true);b.forEach(function(_){_.bOutput=true;});if(this._isDelayedLayouting()){if(!this._isUseNodeHtml()){b.forEach(function(_){_._setupWidthAndHeight();a+=_._render({sizeDetermination:true});a+="</g>";});}var $=function(){if(this._iNodeMaxWidth){this.$divnodes.css("width",this._iNodeMaxWidth+50);}this._isUseNodeHtml()?this._createDivNodes():this._$innerscroller.append("<svg id=\""+this.getId()+"-sizesvg\""+i+" class=\"sapSuiteUiCommonsNetworkGraphSvg\">"+a+Y+"</svg>");b.forEach(function(_){if(this._isUseNodeHtml()){_._setupDivDimensions();}else{_.calculateSizes();_._setupWidthAndHeight();}}.bind(this));this._preprocessData();sap.ui.getCore().detachThemeChanged($);}.bind(this);if(!sap.ui.getCore().isThemeApplied()){sap.ui.getCore().attachThemeChanged($);}else{$();}}this.oHashChanger.attachEvent("hashChanged",function(){if(this._bIsFullScreen){this.toggleFullScreen();}}.bind(this));};X.prototype.exit=function(){if(this.oHashChanger){this.oHashChanger.destroy();}};X.prototype._beforeRender=function(){this.fireEvent("afterLayouting");};X.prototype._fireFailure=function(a,b){var i=b;if(typeof b==="object"&&b.text){i=b.text;}var Y="Graph failure: "+a+": "+i;if(a===X.FAILURE_TYPE.INCONSISTENT_MODEL){Y+=" This may be due to the model size limitation. For its increase use model's 'setSizeLimit' method.";}this.fireFailure([a.toString(),i]);n.error(Y);};X.prototype.isFullScreen=function(){return this._bIsFullScreen;};X.prototype.toggleFullScreen=function(){this._toggleFullScreen();};X.prototype.preventInvalidation=function(b){this._bPreventInvalidation=b;};X.prototype.scrollToElement=function(a){this._scrollToElement(a);};X.prototype.setSearchSuggestionItems=function(i){var a=[];if(i){i.forEach(function(b){a.push({text:b.getText(),icon:b.getIcon(),key:b.getKey(),description:b.getDescription()});});}this._oSuggestionItemsModel.setData({items:a});};X.prototype.destroyAllElements=function(){this.destroyAggregation(A,false);this.destroyAggregation(w,false);this.destroyAggregation(v,false);};X.prototype.deselect=function(b){var i=[],$=this.$(),a=function(Y){Object.keys(Y).forEach(function(_){i.push(Y[_]);Y[_].setSelected(false);},this);}.bind(this);$.find("."+this.HIGHLIGHT_CLASS).removeClass(this.HIGHLIGHT_CLASS);$.find("."+this.SELECT_CLASS).removeClass(this.SELECT_CLASS);$.find("."+this.VISIBLE_ACTIONS_BUTTONS_CLASS).removeClass(this.VISIBLE_ACTIONS_BUTTONS_CLASS);a(this._mSelectedNodes);a(this._mSelectedLines);this._aShadedNodes.forEach(function(Y){Y._setNodeOpacity(false);});this._aShadedNodes=[];this.$(this.LINEBUTTONSID).hide();if(!b&&i.length){this.fireSelectionChange({items:i});}return i;};X.prototype.getFocus=function(){return this._oFocus;};X.prototype.getToolbar=function(){return this._toolbar;};X.prototype.getNodeByKey=function(a){if(this._bRequiresDataProcessing){this._processData();}return this._mNodes[a];};X.prototype.setCustomLegendLabel=function(a){var b;if(a.isGroup===true){b=E.Group;}else if(a.isLine===true){b=E.Line;}else{b=a.isNode===false?E.Line:E.Node;}if(a.status){this._oLegendLabels[b+a.status]=a.label;this._createLegend();}};X.prototype.updateLegend=function(){this._createLegend();};X.prototype.zoom=function(a){a=a||{};a.deltaY=(a.zoomin!==false)?1:-1;if(a.x&&a.y){a.point={x:a.x,y:a.y};}this._zoom(a);};X.prototype.getZoomLevelMilestones=function(){return Z;};X.prototype.getCurrentZoomLevel=function(){return this._fZoomLevel;};X.prototype.setCurrentZoomLevel=function(a){this._fZoomLevel=a;};X.prototype.getCorrectMousePosition=function(a){var b=this.$svg.offset(),i=1,Y=1;if(this._iWidth!==this.$svg.width()||this._iHeight!==this.$svg.height()){i=this._iWidth/this.$svg.width();Y=this._iHeight/this.$svg.height();}return{x:parseInt((a.x-b.left)*i,10),y:parseInt((a.y-b.top)*Y,10)};};X.prototype._createTooltip=function(){var a=new T(this.getId()+"-tooltip");this.addDependent(a);a.create(this);a.attachEvent("afterClose",function(){this.setFocus(this.getFocus());}.bind(this));return a;};X.prototype.defocus=function(){this.$().find("."+this.FOCUS_CLASS).removeClass(this.FOCUS_CLASS);};X.prototype.setFocus=function(a){if(!a&&!this._oFocus||a&&this._oFocus&&a.item===this._oFocus.item&&a.button===this._oFocus.button){return;}this.defocus();if(this.getFocusDomRef()){this.getFocusDomRef().focus();}if(a){if(a.button){if(a.item instanceof N||a.item instanceof L){a.item._setActionButtonFocus(a.button,true);}else if(a.item instanceof G){if(a.button===G.BUTTONS.MENU){a.item._setMenuButtonFocus(true);}else if(a.button===G.BUTTONS.COLLAPSE){a.item._setCollapseButtonFocus(true);}}}else if(a.item){a.item._setFocus(true);}}this._oFocus=a;this._ensureOnScreen(a?a.item:null);this._updateAccessibility(a);};X.prototype._updateAccessibility=function(a){var b=function(){this._setAccessibilityTitle(I.getText("NETWORK_GRAPH_ACCESSIBILITY_CONTENT"));}.bind(this),i=function(Y){return I.getText("NETWORK_GRAPH_ACCESSIBILITY_ACTION_BUTTON")+" "+Y;};if(a){if(a.button){if(a.item instanceof N){this._setAccessibilityTitle(a.item._getActionButtonTitle(a.button));}else if(a.item instanceof G){if(a.button===G.BUTTONS.MENU){this._setAccessibilityTitle(i(I.getText("NETWORK_GRAPH_GROUP_DETAIL")));}else if(a.button===G.BUTTONS.COLLAPSE){this._setAccessibilityTitle(i(I.getText("NETWORK_GRAPH_EXPAND_COLLAPSE")));}else{b();}}else{b();}}else if(a.item){this._setAccessibilityTitle(a.item._getAccessibilityLabel());}}else{b();}};X.prototype._processProperties=function(){if(this._bNeedNodeProcessing){this._mSelectedNodes={};this._mSelectedLines={};this.getNodes().forEach(function(a){if(a.getSelected()){this._mSelectedNodes[a.getKey()]=a;}if(a.getCollapsed()){a.setCollapsed(true);}},this);this.getLines().forEach(function(a){if(a.getSelected()){this._mSelectedLines[a._getLineId()]=a;}},this);this._bNeedNodeProcessing=false;}};X.prototype._loadData=function(){if(this.getNodes().length>0){if(!this._processData()){return;}if(!this._isDelayedLayouting()){setTimeout(this._preprocessData.bind(this),0);}}};X.prototype._preprocessData=function(){this._bIsLayedOut=false;this._bImageLoaded=false;this.fireBeforeLayouting();this._applyLayout().then(this._render.bind(this));};X.prototype._getAllElements=function(){return this.getNodes().concat(this.getGroups());};X.prototype._render=function(){this._beforeRender();this._iRunningLayouts--;if(this._iRunningLayouts>0){return;}this._oLastLayout=null;this._createSearchSuggestItems();this._innerRender();this._createLegend();this._processProperties();if(this._fZoomLevel!==1){this.$svg[0].setAttribute("viewBox","0 0 "+this.$svg.width()+" "+this.$svg.height());this.$svg.width(this.$svg.width()*this._fZoomLevel);this.$svg.height(this.$svg.height()*this._fZoomLevel);this.$background.width(this.$svg.width()*this._fZoomLevel);this.$background.height(this.$svg.height()*this._fZoomLevel);if(this._isUseNodeHtml()){var a="scale("+this._fZoomLevel+")";this.$("divnodes").css("transform",a);}this.$("tooltiplayer").css("transform",a);this.$("divgroups").css("transform",a);}this._setLineClasses();if(this._selectElementAfterScroll){this._scrollToElement(this._selectElementAfterScroll);this._selectElementAfterScroll=null;}this._bIsLayedOut=true;this._setupEvents();this._setupKeyboardNavigation();this.setFocus(this.getFocus());if(!this.getBackgroundImage()||this._bImageLoaded){this.setBusy(false);this.fireGraphReady();}if(!this._isSwimLane()&&!this._isTwoColumnsLayout()){this.$("innerscroller").addClass(" sapSuiteUiCommonsNetworkGraphInnerScrollerCenter ");}};X.prototype._createDivNodes=function(){var a=sap.ui.getCore().createRenderManager();this.getNodes().forEach(function(i){i._bMainRender=true;a.renderControl(i);i._bMainRender=false;});a.flush(this.$divnodes[0]);a.destroy();};X.prototype._innerRender=function(a){var b=function(e1){var f1="";e1.forEach(function(g1){f1+=g1._render();g1.bOutput=true;});return f1;};var i=function(){this.$svg.find(".sapSuiteFlickerFreeRect").remove();this._bImageLoaded=true;if(this._bIsLayedOut){this.setBusy(false);this.fireGraphReady();}}.bind(this);var Y=function(){var e1=sap.ui.getCore().createRenderManager();this.getGroups().forEach(function(f1){e1.renderControl(f1);});e1.flush(this.$("divgroups")[0],false,true);e1.destroy();}.bind(this);var $=20,_=50,a1=function(){var e1=0,f1=0;var g1=function(j1,k1){if(j1>e1){e1=j1;}if(k1>f1){f1=k1;}};this._iWidth=0;this._iHeight=0;this._getAllElements().forEach(function(j1){if(!j1._isIgnored()){g1(j1._iWidth+j1.getX(),j1._iHeight+j1.getY());}},this);this.getLines().forEach(function(j1){if(!j1._isIgnored()){j1.getCoordinates().forEach(function(k1){g1(k1.getX(),k1.getY());});}},this);if(this.getBackgroundImage()){var h1=new Image();h1.onload=function(){this._iWidth=Math.max(this._iWidth,h1.width);this._iHeight=Math.max(this._iHeight,h1.height);this.$svg.width(this._iWidth);this.$svg.height(this._iHeight);this.$background.width(this._iWidth);this.$background.height(this._iHeight);this.$svg.css("background-image","url("+this.getBackgroundImage()+")");this.$svg.css("background-size","cover");i();}.bind(this);h1.onerror=function(){n.warning("Unable to load background image.");i();};h1.src=this.getBackgroundImage();}this._iWidth=Math.round(e1+(this._isTwoColumnsLayout()?0:_));this._iHeight=Math.round(f1+$);if(this.getWidth()==="auto"){this.$().width(this._iWidth);}if(this.getHeight()==="auto"){this.$("wrapper").height(this._iHeight);}if(this._isTwoColumnsLayout()){var i1=this._$innerscroller.width();if(this._iWidth<i1){this._iWidth=i1;}}this.$svg.width(this._iWidth);this.$svg.height(this._iHeight);this.$background.width(this._iWidth);this.$background.height(this._iHeight);if(this._isUseNodeHtml()){this.$divnodes.width(this._iWidth);this.$divnodes.height(this._iHeight);this.$divnodes.css("opacity",1);}this.$divgroups.width(this._iWidth);this.$divgroups.height(this._iHeight);this.$tooltips.width(this._iWidth);this.$tooltips.height(this._iHeight);}.bind(this);var b1=function(e1){e1.forEach(function(f1){f1.forEach(function(g1){g1._afterRendering();});});};var c1=this.getNodes(),d1=this.getLines();M.start(this.getId(),"Rendering of a network graph");if(!this._isUseNodeHtml()){this.$("sizesvg").remove();}Y();this._$innerscroller.append(this._renderSvg(this._isUseNodeHtml()?[]:b(c1),b(d1)));this.$svg=this.$("networkGraphSvg");this.$background=this.$("background");a1();if(this._isUseNodeHtml()){c1.forEach(function(e1){var f1=e1.$();if(e1._isInCollapsedGroup()){f1.hide();}f1.css("top",e1.getY());f1.css("left",e1.getX());});}b1([this._isUseNodeHtml()?[]:c1,d1]);M.end(this.getId());};X.prototype._renderSvg=function(a,b){var i="",Y="sapSuiteUiCommonsNetworkGraphSvg sapSuiteUiCommonsNetworkGraphNoSelect "+(this._fZoomLevel<x?" sapSuiteUiCommonsNetworkGraphZoomedOut ":"");var $=function(_,a1,Y){i+="<g id=\""+this._getDomId(_)+"\" class=\""+(Y||"")+"\">";i+=a1?a1:"";i+="</g>";}.bind(this);i+="<svg id=\""+this.getId()+"-networkGraphSvg\"";if(this._bIsRtl){i+="direction="+"\"rtl\"";}i+=" style=\"margin:auto;";if(!this._isUseNodeHtml()){i+="position:relative";}i+="\"";i+=" class=\""+Y+"\" preserveAspectRatio=\"none\" ";i+=">";i+="<g id=\""+this.getId()+"-svgbody\">";$("lines",b,"sapSuiteUiCommonsNetworkLines");if(!this._isUseNodeHtml()){$("nodes",a,"sapSuiteUiCommonsNetworkNodes");}i+="</g>";if(this.getBackgroundImage()){i+="<rect class=\"sapSuiteFlickerFreeRect\" x=\"0\" y=\"0\" height=\"100%\" width=\"100%\"></rect>";}i+="</svg>";if(this._isUseNodeHtml()){i+="<div id=\""+this.getId()+"-background\"></div>";}return i;};X.prototype._isProperKey=function(a){return a||(a==="0");};X.prototype._processData=function(){var i=this._isSwimLane();var a=function(){var _=0,a1;this.mGroups={};a1=this.getGroups().some(function(b1){var c1=b1.getKey();b1._iNestedLevel=0;if(!this._isProperKey(c1)){this._fireFailure(X.FAILURE_TYPE.INCONSISTENT_MODEL,"Group without a proper key [index: "+_+"] found.");return true;}b1._bIsSwimLane=i;b1._resetSize();b1._clearChildren();if(this.mGroups[c1]){this._fireFailure(X.FAILURE_TYPE.INCONSISTENT_MODEL,"Group with a duplicit key "+c1+" found.");return true;}this.mGroups[c1]=b1;_++;return false;},this);return a1||this.getGroups().some(function(b1){if(b1.getParentGroupKey()&&!this.mGroups[b1.getParentGroupKey()]){this._fireFailure(X.FAILURE_TYPE.INCONSISTENT_MODEL,"Group '"+b1.getKey()+"' reffers to a nonexistent parent group '"+b1.getParentGroupKey()+"'.");return true;}return false;},this);}.bind(this);var b=function(){var _=0;this._mNodes={};return this.getNodes().some(function(a1){if(!this._isProperKey(a1.getKey())){this._fireFailure(X.FAILURE_TYPE.INCONSISTENT_MODEL,"Node without a proper ID [index: "+_+"] found.");return true;}var b1=a1.getGroup(),c1;a1._oGroup=null;if(b1){c1=this.mGroups[b1];if(c1){a1._oGroup=c1;c1.aNodes.push(a1);}else{this._fireFailure(X.FAILURE_TYPE.INCONSISTENT_MODEL,"Node belonging to a nonexistent group with key "+b1+" found.");return true;}}this._isUseNodeHtml()?a1._resetDimensions():a1._setupWidthAndHeight();a1._clearChildren();a1._rendered=false;if(this._mNodes[a1.getKey()]){this._fireFailure(X.FAILURE_TYPE.INCONSISTENT_MODEL,"Node with a duplicit key "+a1.getKey()+" found.");return true;}this._mNodes[a1.getKey()]=a1;_++;return false;},this);}.bind(this);var Y=function(){return this.getLines().some(function(_,a1){var b1=this.getNodeByKey(_.getFrom()),c1=this.getNodeByKey(_.getTo());if(!b1){this._fireFailure(X.FAILURE_TYPE.INCONSISTENT_MODEL,"Line going from a nonexistent node with key "+_.getFrom()+" found.");return true;}if(!c1){this._fireFailure(X.FAILURE_TYPE.INCONSISTENT_MODEL,"Line going to a nonexistent node with key "+_.getTo()+" found.");return true;}_._rendered=false;_._initialized=false;if(b1&&c1){b1.aChildren.push(c1);b1.aLines.push(_);c1.aParents.push(b1);c1.aParentLines.push(_);_._oFrom=b1;_._oTo=c1;_._sKey="line_"+b1.getKey()+"-"+c1.getKey()+"["+a1+"]";}if(b1._oGroup){b1._oGroup.aLines.push(_);b1._oGroup.aChildren.push(c1);}if(c1._oGroup){c1._oGroup.aParentLines.push(_);c1._oGroup.aParents.push(b1);}return false;},this);}.bind(this);var $=function(){this.getGroups().forEach(function(_){var a1=_.getParentGroupKey();if(a1){var b1=this.mGroups[a1];if(b1){_._oParentGroup=b1;b1.aChildGroups.push(_);}}}.bind(this));this.getGroups().forEach(function(_){var a1=0,b1=_._oParentGroup,c1=false,d1=_;while(b1){if(b1.getCollapsed()&&!c1){_._oCollapsedByParent=b1;c1=true;}d1=b1;b1=b1._oParentGroup;a1++;}_._iNestedLevel=a1;_._oTopParentGroup=d1;});}.bind(this);this._bRequiresDataProcessing=false;if(a()||b()||Y()){this._bIsInvalid=true;return false;}$();this._oStatuses={};this.getStatuses().forEach(function(_){var a1=_.getKey();if(a1){this._oStatuses[a1]=_;}},this);this._bIsInvalid=false;return true;};X.prototype._validateLayout=function(){var b,a,i,Y="";b=this.getNodes().some(function($){if($._isIgnored()){return false;}Y="Missing coordinates: Node("+$.getKey()+")";return!(($._oGroup&&$._oGroup.getCollapsed())||(isFinite($.getX())&&isFinite($.getY())));});if(b){this._fireFailure(X.FAILURE_TYPE.LAYOUT_FAILURE,Y);return false;}if(this._isLayered()){a=this.getGroups().some(function($){if($._isIgnored()){return false;}Y="Missing coordinates: Group("+$.getKey()+")";return!$._isEmpty()&&(!isFinite($.getX())||!isFinite($.getY()));});if(a){this._fireFailure(X.FAILURE_TYPE.LAYOUT_FAILURE,Y);return false;}}i=this.getLines().some(function($){if($._isIgnored()){return false;}Y="Missing coordinates: Line("+$.getKey()+")";return!$._validateLayout();});if(i){this._fireFailure(X.FAILURE_TYPE.LAYOUT_FAILURE,Y);return false;}return true;};X.prototype._suggest=function(a){var b=function(i){i.addCustomData(new j({key:z.IsLastKey,value:"true",writeToDom:true}));};var Y=function(i){var c1=U.find(i.getCustomData(),function(d1){return d1.getKey()===z.IsLastKey;});if(c1){i.removeCustomData(c1);}};var $=function(i){var c1=U.find(i.getCustomData(),function(d1){return d1.getKey()===z.TypeKey;});return c1&&c1.getValue();};var _=function(){var c1=this._searchField.getSuggestionItems(),d1,e1,f1;for(var i=0;i<c1.length;i++){d1=c1[i];Y(d1);if(i<c1.length-1){e1=$(d1);f1=$(c1[i+1]);if(e1&&f1){if((e1===z.Node&&f1===z.Line)||(e1===z.Line&&f1===z.Group)){b(d1);}}}}}.bind(this);var a1=[],b1=this.fireEvent("searchSuggest",{term:a},true);Q=0;if(b1){if(a){a1=[new F([new F("text",function(i){return(i.toLowerCase()||"").indexOf(a.toLowerCase())>-1;}),new F("description",function(i){return(i.toLowerCase()||"").indexOf(a.toLowerCase())>-1;})],false)];}this._searchField.getBinding("suggestionItems").filter(a1);_();}this._searchField.suggest();};X.prototype._getElementSelectFunctionName=function(a){var b="";if(a instanceof N){b="_selectNode";}if(a instanceof L){b="_selectLine";}if(a instanceof G){b="_selectGroup";}return b;};X.prototype._search=function(a,b){var i,Y,$;Y=this.fireEvent("search",{term:a,key:b},true);if(!Y){return;}if(a){$=U.find(this.getNodes(),function($){return b?$.getKey()===b:$.getTitle()===a;});if(!$){$=U.find(this.getLines(),function(_){if(_._isLoop()){return false;}return b?_._getLineId()===b:_._createSuggestionHelpText()===a;});}if(!$){$=U.find(this.getGroups(),function(_){return _.aNodes.length>0&&(b?_.getKey()===b:_.getTitle()===a);});}if($){i=this._getElementSelectFunctionName($);if(i){this[i]({element:$,scroll:true,alwaysSelect:true});}}}else{this.deselect(false);this.setFocus(null);}};X.prototype._createToolbar=function(){var a=this;this._toolbar=new O(this.getId()+"-toolbar",{content:[new h()]}).addStyleClass("sapSuiteUiCommonsNetworkGraphToolbar");this.addDependent(this._toolbar);this._searchField=new g({layoutData:new k({priority:sap.m.OverflowToolbarPriority.NeverOverflow,shrinkable:true}),enableSuggestions:true,suggest:function(b){a._suggest(b.getParameter("suggestValue"));},search:function(b){var i=b.getParameter("query"),Y=b.getParameter("suggestionItem"),$;if(Y){$=Y.getProperty("key");}a._search(i,$);}}).addStyleClass("sapSuiteUiCommonsNetworkGraphSearchField");this._toolbar.addContent(this._searchField);this._toolbar.addContent(new r({type:B.Transparent,icon:"sap-icon://legend",tooltip:I.getText("NETWORK_GRAPH_LEGEND"),press:function(b){if(a.$legend.is(":visible")){a.$legend.hide();}else{a.$legend.show();}}}));if(this.getEnableZoom()){this._zoomLabel=new e({layoutData:new k({group:1,priority:sap.m.OverflowToolbarPriority.Disappear}),text:"100%"});this._zoomIn=new f({layoutData:new k({group:1}),type:B.Transparent,ariaDescribedBy:[this._zoomLabel],text:I.getText("CHARTCONTAINER_ZOOMIN"),icon:"sap-icon://zoom-in",tooltip:I.getText("CHARTCONTAINER_ZOOMIN"),press:function(b){a._zoom({deltaY:1});}});this._toolbar.addContent(this._zoomIn);this._toolbar.addContent(this._zoomLabel);this._zoomOut=new f({layoutData:new k({group:1}),type:B.Transparent,ariaDescribedBy:[this._zoomLabel],text:I.getText("CHARTCONTAINER_ZOOMOUT"),icon:"sap-icon://zoom-out",tooltip:I.getText("CHARTCONTAINER_ZOOMOUT"),press:function(b){a._zoom({deltaY:-1});}});this._toolbar.addContent(this._zoomOut);}this._toolbar.addContent(new f({type:B.Transparent,icon:"sap-icon://sys-monitor",tooltip:I.getText("NETWORK_GRAPH_ZOOMTOFIT"),text:I.getText("NETWORK_GRAPH_ZOOMTOFIT"),press:this._fitToScreen.bind(this)}));this._oFullScreenButton=new f({type:B.Transparent,text:I.getText("CALCULATION_BUILDER_ENTER_FULL_SCREEN_BUTTON"),icon:"sap-icon://full-screen",tooltip:I.getText("CALCULATION_BUILDER_ENTER_FULL_SCREEN_BUTTON"),press:this._toggleFullScreen.bind(this)});this._toolbar.addContent(this._oFullScreenButton);this._oPopup=new P({modal:true,shadow:false,autoClose:false});};X.prototype._fitToScreen=function(){var a=this.$scroller.height()/this._iHeight,b=this.$scroller.width()/this._iWidth,Y=Math.min(a,b),$=Z.slice(-1);for(var i=1;i<Z.length;i++){if(Y<Z[i]){$=Z[i-1];break;}}this._zoom({zoomLevel:$});};X.prototype._getZoomText=function(){return Math.floor((this._fZoomLevel*100))+"%";};X.prototype._toggleFullScreen=function(){var a=function(){this._oFullScreenContainer={};this._oFullScreenContainer.$content=this.$();if(this._oFullScreenContainer.$content){this.$().addClass("sapSuiteUiCommonsNetworkGraphFullScreen");this._oFullScreenContainer.$tempNode=q("<div></div>");this._oFullScreenContainer.$content.before(this._oFullScreenContainer.$tempNode);this._oFullScreenContainer.$overlay=q("<div id='"+u()+"'></div>");this._oFullScreenContainer.$overlay.addClass("sapSuiteUiCommonsNetworkGraphContainerOverlay");this._oFullScreenContainer.$overlay.append(this._oFullScreenContainer.$content);this._oPopup.setContent(this._oFullScreenContainer.$overlay);}this._oPopup.open(200,P.Dock.BeginTop,P.Dock.BeginTop,q("body"));}.bind(this);var b=function(){this.$().removeClass("sapSuiteUiCommonsNetworkGraphFullScreen");this._oFullScreenContainer.$tempNode.replaceWith(this._oFullScreenContainer.$content);this._oPopup.close();this._oFullScreenContainer.$overlay.remove();}.bind(this);var i=function(Y,$){this._oFullScreenButton.setIcon(Y);this._oFullScreenButton.setText($);this._oFullScreenButton.setTooltip($);}.bind(this);if(this._bIsFullScreen){i("sap-icon://full-screen",I.getText("CALCULATION_BUILDER_ENTER_FULL_SCREEN_BUTTON"));b();}else{i("sap-icon://exit-full-screen",I.getText("CALCULATION_BUILDER_EXIT_FULL_SCREEN_BUTTON"));a();}this._bIsFullScreen=!this._bIsFullScreen;};X.prototype._setupKeyboardNavigation=function(){var Y=[],$=[[]],_,a1;if(!this._isLayedOut()){return;}this.getNodes().forEach(function(a){if(a.isHidden()||a._isIgnored()||!a.getVisible()){return;}Y.push({item:a,x:a.getX(),y:a.getY()});});this.getLines().forEach(function(a){if(a.isHidden()||a._isIgnored()||!a.getVisible()||a.getCoordinates().length<2){return;}var b=a.getCoordinates()[0],i=b.getX(),iY=b.getY();a.getCoordinates().forEach(function(b){if(i>b.getX()){i=b.getX();}if(iY>b.getY()){iY=b.getY();}});Y.push({item:a,x:i,y:iY});});this.getGroups().forEach(function(a){if(a.isHidden()||a._isEmpty()||!a.getVisible()){return;}Y.push({item:a,x:a.getX(),y:a.getY()});});Y.sort(function(a,b){if(a.y<b.y){return-1;}else if(a.y>b.y){return 1;}else if(a.x<b.x){return-1;}else if(a.x>b.x){return 1;}else{return 0;}});if(Y.length>0){a1=[Y[0]];$=[a1];_=Y[0];Y.forEach(function(a,i){if(i===0){return;}if(a.y===_.y){a1.push(a);}else{a1=[a];$.push(a1);}_=a;});}$=this._normalizeGrid($,Y);if(!this._oKeyboardNavigator){this._oKeyboardNavigator=new K(this);this.addDelegate(this._oKeyboardNavigator);}this._oKeyboardNavigator.setItems($);this._oKeyboardNavigator.setWrapperDom(this.getFocusDomRef());};X.prototype._normalizeGrid=function(a,b){if(b.length===0){return a;}var Y=b[0],$=Y.x,_=Y.x,a1=1,b1,c1,d1=[],i;b.forEach(function(e1){if(e1.x<$){$=e1.x;}if(e1.x>_){_=e1.x;}});a.forEach(function(e1){if(e1.length>a1){a1=e1.length;}});b1=Math.abs(_-$)/a1;c1=$;for(i=0;i<a1;i++){c1+=b1;d1.push(c1);}return a.map(function(e1){var f1,g1;if(e1.length===a1){f1=e1;}else{f1=[];g1=0;while(g1<(a1-e1.length)&&d1[g1]<e1[0].x){g1++;f1.push(null);}e1.forEach(function(h1){f1.push(h1);g1++;});while(g1<a1){f1.push(null);g1++;}}return f1.map(function(h1){return h1?h1.item:null;});});};X.prototype.getFocusDomRef=function(){return this.getDomRef("wrapper");};X.prototype._setupEvents=function(){var a=5;var i=0,b={},$=this.$("ctrlalert"),Y=this.$scroller;var _=function(o1,o2){return Math.sqrt(Math.pow(o1.clientX-o2.clientX,2)+Math.pow(o1.clientY-o2.clientY,2));};var a1=function(d1){if(d1.touches&&d1.touches.length===2){b={t1:d1.touches[0],t2:d1.touches[1],diff:_(d1.touches[0],d1.touches[1])};}};var b1=function(d1){if(d1.touches&&d1.touches.length===2){if(++i===a){var e1=d1.touches[0],f1=d1.touches[1],g1=_(e1,f1);this._zoom({point:{x:(e1.clientX+f1.clientX)/2,y:(e1.clientY+f1.clientY)/2},deltaY:g1-b.diff});i=0;b={t1:e1,t2:f1,diff:g1};}}}.bind(this);Y.mousemove(function(d1){this._mouseMove(d1.clientX,d1.clientY);}.bind(this));var c1=this._isSwimLane()?this.$svg:this.$divgroups;c1.mousedown(function(d1){this._mouseDown(d1.clientX,d1.clientY);d1.preventDefault();}.bind(this));Y.mouseleave(this._endDragging.bind(this));Y.mouseup(this._mouseUp.bind(this));if(this.getEnableZoom()){Y.bind("wheel",function(d1){if(this._wheel({x:d1.originalEvent.clientX,y:d1.originalEvent.clientY,deltaY:d1.originalEvent.deltaY,div:$,ctrl:d1.ctrlKey})){d1.preventDefault();}}.bind(this));}Y.bind("touchstart",function(d1){a1(d1);});Y.bind("touchmove",function(d1){b1(d1);});};X.prototype._wheel=function(a){if(this.getEnableWheelZoom()||a.ctrl){a.div.css("opacity","0");this._zoom({point:{x:a.x,y:a.y},deltaY:-a.deltaY});this._zoomLabel.setText(this._getZoomText());return true;}};X.prototype._endDragging=function(){this._oPanning.dragging=false;this.$scroller.removeClass("sapSuiteUiCommonsNetworkGraphPanning");};X.prototype._mouseMove=function(i,Y){var a=this.$scroller[0];if(this._oPanning.dragging){if(!this.$scroller.hasClass("sapSuiteUiCommonsNetworkGraphPanning")){this.$scroller.addClass("sapSuiteUiCommonsNetworkGraphPanning");}a.scrollTop=a.scrollTop-(Y-this._oPanning.lastY);a.scrollLeft=a.scrollLeft-(i-this._oPanning.lastX);this._oPanning.lastX=i;this._oPanning.lastY=Y;}};X.prototype._mouseDown=function(i,Y){this.deselect(false);this.setFocus(null);this._oPanning.lastX=i;this._oPanning.lastY=Y;this._oPanning.dragging=true;this._tooltip.instantClose();};X.prototype._mouseUp=function(){this._endDragging();};X.prototype._preventZoomToChangeLineWidth=function(){return this._isLayered()&&(this._fZoomLevel>=0.5&&this._fZoomLevel<2);};X.prototype._setLineClasses=function(){var $=this.$(),a=this._preventZoomToChangeLineWidth()?"addClass":"removeClass",b=(this._fZoomLevel<0.5)?"removeClass":"addClass";$[a]("sapSuiteUiCommonsNetworkGraphDefaultLineWidth");$[b]("sapSuiteUiCommonsNetworkGraphCrispEdges");};X.prototype._zoom=function(a){var b=this.$svg[0].getAttribute("viewBox"),i=a.deltaY<0?-1:1,Y,$,_,a1;var b1=function(c1){var d1=0,e1;Z.forEach(function(f1,g1){var h1=Math.abs(c1-f1);if(h1<e1||e1===undefined){d1=g1;e1=h1;}});return d1;};if(!a.point){a.point={x:this.$scroller.width()/2,y:this.$scroller.height()/2};}Y=this.getCorrectMousePosition({x:a.point.x,y:a.point.y});if(a.zoomLevel||a.zoomLevel===0){this._fZoomLevel=a.zoomLevel;}else{_=b1(this._fZoomLevel);if(Z.indexOf(this._fZoomLevel)<0){if(this._fZoomLevel>Z[_]){_=i<0?_:_+i;}else{_=i>0?_:_+i;}}else{_+=i;}if(_<0){_=0;}else if(_>Z.length-1){_=Z.length-1;}this._fZoomLevel=Z[_];}if(this._fZoomLevel<0){this._fZoomLevel=0;}if(!b){a1="0 0 "+Math.round(this.$svg.width())+" "+Math.round(this.$svg.height());this.$svg[0].setAttribute("viewBox",a1);}this.$svg.width(Math.round(this._iWidth*this._fZoomLevel));this.$svg.height(Math.round(this._iHeight*this._fZoomLevel));this.$background.width(Math.round(this._iWidth*this._fZoomLevel));this.$background.height(Math.round(this._iHeight*this._fZoomLevel));$=this.getCorrectMousePosition({x:a.point.x,y:a.point.y});this.$scroller[0].scrollLeft+=(Y.x-$.x)*this._fZoomLevel;this.$scroller[0].scrollTop+=(Y.y-$.y)*this._fZoomLevel;this._zoomLabel.setText(this._getZoomText());if(this._fZoomLevel<x){this.$svg.addClass("sapSuiteUiCommonsNetworkGraphZoomedOut");}else{this.$svg.removeClass("sapSuiteUiCommonsNetworkGraphZoomedOut");}if(this._isUseNodeHtml()){this.$("divnodes").css("transform","scale("+this._fZoomLevel+")");}this.$("divgroups").css("transform","scale("+this._fZoomLevel+")");this.$tooltips.css("transform","scale("+this._fZoomLevel+")");this._setLineClasses();this.fireEvent("zoomChanged");};X.prototype._createSearchSuggestItems=function(){var a=50;var b={items:[]},i=this.getNodes().sort(function(_,a1){return _.getTitle().localeCompare(a1.getTitle());}),Y=this.getLines().sort(function(_,a1){var b1=_.getTitle(),c1=a1.getTitle();if(b1===c1){return _.getFromNode().getTitle().localeCompare(a1.getFromNode().getTitle());}return b1.localeCompare(c1);}),$=this.getGroups().sort(function(_,a1){return _.getTitle().localeCompare(a1.getTitle());});this._oSuggestionItemsModel=new J();this._oSuggestionItemsModel.setSizeLimit(y);i.forEach(function(_){var a1=U.trimText(_.getTitle(),a);b.items.push({text:a1?a1:_.getKey(),type:z.Node,icon:_.getIcon(),key:_.getKey(),description:"("+I.getText("NETWORK_GRAPH_NODE")+")"});});Y.forEach(function(_){if(_._isLoop()){return;}if(_.getTitle()||_.getFromNode().getTitle()||_.getToNode().getTitle()){b.items.push({text:_._createSuggestionHelpText(),type:z.Line,key:_._getLineId(),description:"("+I.getText("NETWORK_GRAPH_LINE")+")"});}});$.forEach(function(_){var a1=U.trimText(_.getTitle(),a);if(_.aNodes.length>0){b.items.push({text:a1?a1:_.getKey(),key:_.getKey(),type:z.Group,description:"("+I.getText("NETWORK_GRAPH_GROUP")+")"});}});this._oSuggestionItemsModel.setData(b);this._searchField.setModel(this._oSuggestionItemsModel);this._searchField.bindAggregation("suggestionItems",{path:"/items",template:new W({text:"{text}",icon:"{icon}",key:"{key}",description:"{description}",customData:new j({key:"type",value:"{type}"})})});};X.prototype._scrollToElement=function(i){var b=i._oGroup&&i._oGroup.getCollapsed(),a,Y,$,_,a1,b1;if(b){i=i._oGroup;}if(i instanceof L){a1=i.getSource();b1=i.getTarget();$=Math.abs(b1.getX()-a1.getX());_=Math.abs(b1.getY()-a1.getY());a=Math.min(a1.getX(),b1.getX());Y=Math.max(a1.getY(),b1.getY());}else{a=i.getX();Y=i.getY();$=i._iWidth;_=i._iHeight;}this.$scroller.get(0).scrollLeft=((a+($?$:0)/2)*this._fZoomLevel)-(this.$scroller.width()/2);this.$scroller.get(0).scrollTop=((Y+(_?_:0)/2)*this._fZoomLevel)-(this.$scroller.height()/2);};X.prototype._ensureOnScreen=function(i){if(!i||!this.$scroller){return;}var a,b,Y,$=this.$scroller[0],_=$.scrollLeft/this._fZoomLevel,a1=$.scrollTop/this._fZoomLevel,b1=_+this.$scroller.width()/this._fZoomLevel,c1=a1+this.$scroller.height()/this._fZoomLevel;if(!i._isOnScreen(_,b1,a1,c1)){if(i instanceof N){b=i.getX()+i._iWidth/2;Y=i.getY()+i._iHeight/2;}else if(i instanceof L){a=i._getArrowFragmentVector();b=(a.center.x+a.apex.x)/2;Y=(a.center.y+a.apex.y)/2;}else if(i instanceof G){b=i.getX();Y=i.getY();}if(b<_||b>b1){$.scrollLeft=b*this._fZoomLevel-this.$scroller.width()/2;}if(Y<a1||Y>c1){$.scrollTop=Y*this._fZoomLevel-this.$scroller.height()/2;}}};X.prototype._createLegend=function(){var $=this.$("legend"),i="",Y=this,_={},a1={},b1={};var c1=function(a,b){var g1=o(a.getStatus());if(g1){if(b[g1]){b[g1].push(a);}else{b[g1]=[a];}}};var d1=function(a){return Object.keys(a).length>0;};var e1=function(a,b,g1){var h1=this._oStatuses[a],i1=h1&&h1._getLegendColor(),j1=i1?"background-color:"+i1:"";i+=this._renderControl("div",{status:a,elementtype:g1,"class":"sapSuiteUiCommonsNetworkGraphLegendLine"},false);i+=this._renderControl("div",{"class":"sapSuiteUiCommonsNetworkGraphLegendColorLine "+this._getStatusClass(a),"style":j1});i+=this._renderControl("label",{"class":"sapSuiteUiCommonsNetworkGraphLegendLineLabel"},false);i+=o(this._oLegendLabels[g1+a]?this._oLegendLabels[g1+a]:b);i+="</label>";i+="</div>";}.bind(this);var f1=function(g1,h1,i1,j1,k1){g1.forEach(function(a){c1(a,h1);});if(d1(h1)){i+="<div class=\""+i1+"\"><label class=\"sapSuiteUiCommonsNetworkGraphLegendTitle\">"+o(I.getText(j1))+"</label></div>";var l1=Object.keys(h1).reduce(function(a,b){var m1;if(this._oLegendLabels[k1+b]){m1=this._oLegendLabels[k1+b];}else{var n1=this._oStatuses[b];m1=n1?(n1.getTitle()||b):I.getText("NETWORK_GRAPH_"+b.toUpperCase());}a[b]=m1;return a;}.bind(this),{});Object.keys(h1).sort(function(a,b){return(l1[a]||"").localeCompare(l1[b]);}).forEach(function(a){e1(a,l1[a],k1);});}}.bind(this);if(this.getLegend()){return;}if(!$[0]){return;}f1(this.getNodes(),_,"sapSuiteUiCommonsNetworkGraphLegendTitleNode","NETWORK_GRAPH_NODES",E.Node);f1(this.getLines(),a1,"sapSuiteUiCommonsNetworkGraphLegendTitleLine","NETWORK_GRAPH_LINES",E.Line);f1(this.getGroups(),b1,"sapSuiteUiCommonsNetworkGraphLegendTitleLine","NETWORK_GRAPH_GROUPS",E.Group);$.html(i);this.$().find(".sapSuiteUiCommonsNetworkGraphLegendLine").click(function(a){var b=q(this).attr("status"),g1=q(this).attr("elementtype"),h1;if(g1===E.Node){h1=_;}if(g1===E.Line){h1=a1;}if(!a.ctrlKey){Y.deselect(false);Y.setFocus(null);}if(g1!==E.Group&&h1[b]){h1[b].forEach(function(i1){i1.setSelected(true);});}});};X.prototype._selectElement=function(a){var i=a.element&&!a.element.getSelected(),b=[];var Y=function($){a.element.setSelected($);if(a.setFocus!==false){this.setFocus({item:a.element});}}.bind(this);this.$("svg").find("."+this.VISIBLE_ACTIONS_BUTTONS_CLASS).removeClass(this.VISIBLE_ACTIONS_BUTTONS_CLASS);if(!a.preventDeselect){b=this.deselect(true);if(a.setFocus){this.setFocus(null);}if(i||a.alwaysSelect){Y(true);}}else{Y(i);}if(!a.element._hasFocus()&&a.forceFocus){this.setFocus({item:a.element});}if(!b.some(function($){return $===a.element;})){b.push(a.element);}this.fireSelectionChange({items:b});};X.prototype._selectLine=function(a){var b=a.element.getFromNode(),i=a.element.getToNode(),Y=(b._isInCollapsedGroup()&&(b._oGroup===i._oGroup))?i._oGroup:null;if(a.scroll){this._scrollToElement(Y||a.element);}if(!Y){this._selectElement(a);}};X.prototype._selectNode=function(a){var b=a.element._isInCollapsedGroup()?a.element._oGroup:null;if(a.scroll){this._scrollToElement(b||a.element);}if(!b){this._selectElement(a);if(a.renderActionButtons!==false){a.element.showActionButtons(true);}}};X.prototype._selectGroup=function(a){if(a.scroll){this._scrollToElement(a.element);}this.setFocus({item:a.element});};X.prototype._applyLayout=function(){var a;this._iRunningLayouts++;a=this._getLayoutAlgorithm().layout().catch(function(b){this._fireFailure(X.FAILURE_TYPE.LAYOUT_FAILURE,b);return Promise.reject();}.bind(this)).then(function(){return new Promise(function(b,i){if(a.isTerminated()){b();return;}if(this._validateLayout()){b();}else{i();}}.bind(this));}.bind(this));if(this._oLastLayout&&this._iRunningLayouts>1){this._oLastLayout.terminate();}this._oLastLayout=a;return a;};X.prototype._setAccessibilityTitle=function(i){var a,b=this.$("accessibility");if(i===null){a=I.getText("NETWORK_GRAPH_ACCESSIBILITY_CONTENT");}else if(typeof i==="string"){a=i;}else{a=i._getAccessibilityLabel();}if(b){b.html(o(a));}};X.prototype._isTopBottom=function(){return this.getOrientation()===s.TopBottom||this.getOrientation()===s.BottomTop;};X.prototype._getLayoutAlgorithm=function(){return this.getLayoutAlgorithm()||this._getDefalutLayout();};X.prototype._isUseNodeHtml=function(){return this.getRenderType()===R.Html;};X.prototype._getDefalutLayout=function(){if(!this._oDefalutLayout){this._oDefaultLayout=new c();this._oDefaultLayout.setParent(this,null,true);}return this._oDefaultLayout;};X.prototype._isLayered=function(){var a=this._getLayoutAlgorithm().getLayoutRenderType();return a===t.SwimLanes||a===t.LayeredWithGroups||a===t.TwoColumns;};X.prototype._isSwimLane=function(){return this._getLayoutAlgorithm().getLayoutRenderType()===t.SwimLanes;};X.prototype._isTwoColumnsLayout=function(){return this._getLayoutAlgorithm().getLayoutRenderType()===t.TwoColumns;};X.prototype._isDelayedLayouting=function(){if(this._isUseNodeHtml()){return true;}return this.getNodes().some(function(a){var b=a.hasListeners("computeSizes");return b||a._useAutomaticSize()||a.getTitleLineSize()!==1||a._displayDescription();});};X.prototype._isLayedOut=function(){return this._bIsLayedOut;};X.prototype.setEnableZoom=function(b){if(this._toolbar){this._zoomLabel.setVisible(b);this._zoomIn.setVisible(b);this._zoomOut.setVisible(b);}this.setProperty("enableZoom",b);return this;};X.prototype.destroyAggregation=function(a,b){this._bRequiresDataProcessing=true;C.prototype.destroyAggregation.call(this,a,b);};X.prototype.insertAggregation=function(a,b,i,Y){this._bRequiresDataProcessing=true;C.prototype.insertAggregation.call(this,a,b,i,Y);};X.prototype.removeAggregation=function(a,b,i){this._bRequiresDataProcessing=true;C.prototype.removeAggregation.call(this,a,b,i);};X.prototype.addAggregation=function(a,b,i){this._bRequiresDataProcessing=true;C.prototype.addAggregation.call(this,a,b,i);};X.prototype.removeAllAggregation=function(a,b){this._bRequiresDataProcessing=true;C.prototype.removeAllAggregation.call(this,a,b);};X.prototype.updateAggregation=function(a){this._bNeedNodeProcessing=true;C.prototype.updateAggregation.call(this,a);};X.prototype.invalidate=function(){if(this._bPreventInvalidation!==true){C.prototype.invalidate.call(this);}};return X;});
