/*!
 * 
		SAP UI development toolkit for HTML5 (SAPUI5)
		(c) Copyright 2009-2015 SAP SE. All rights reserved
	
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/suite/ui/commons/library","./ElementBase","./ElementAttribute","sap/ui/core/IconPool","sap/ui/Device","sap/base/security/encodeXML","sap/base/security/sanitizeHTML","sap/m/CheckBox","sap/m/Text","./NodeRenderer"],function(q,l,E,a,I,D,b,s,C,T,N){"use strict";var S=l.networkgraph.NodeShape,A=l.networkgraph.ActionButtonPosition,H=l.networkgraph.HeaderCheckboxState;var c=32,d=5,M=80,f=4;var g={Circle:{WIDTH:96,HEIGHT:64},Box:{WIDTH:160,HEIGHT:32},Attributes:{LINE:16,OFFSET:8},ActionButtons:{RADIUS:13,MARGIN:8,OFFSET:4},Title:{LINESIZE:15,OFFSET:8,ICON_SIZE:16,INFO_BOX_SIZE:20,ICON_X_OFFSET:6,IMAGE_OFFSET_Y:6},Description:{LINESIZE:15},Image:{Box:16,Circle:32}};var h={EXPANDED:"Expanded",COLLAPSED:"Collapsed",PARTIAL:"Partial"};var j={EXPAND:"sys-add",COLLAPSE:"sys-minus",PARTIAL:"overlay"};var k=I.getIconInfo(j.EXPAND),m=I.getIconInfo(j.COLLAPSE),n=I.getIconInfo(j.PARTIAL);k=k&&k.content;m=m&&m.content;n=n&&n.content;var r=sap.ui.getCore().getLibraryResourceBundle("sap.suite.ui.commons");var o=E.extend("sap.suite.ui.commons.networkgraph.Node",{metadata:{library:"sap.suite.ui.commons",properties:{headerCheckBoxState:{type:"sap.suite.ui.commons.networkgraph.HeaderCheckboxState",group:"Misc",defaultValue:H.Hidden},collapsed:{type:"boolean",group:"Misc",defaultValue:false},selected:{type:"boolean",group:"Misc",defaultValue:false},group:{type:"string",group:"Misc",defaultValue:null},key:{type:"string",group:"Misc",defaultValue:null},shape:{type:"sap.suite.ui.commons.networkgraph.NodeShape",groups:"Behavior",defaultValue:S.Circle},icon:{type:"string",group:"Appearance",defaultValue:null},statusIcon:{type:"string",group:"Appearance",defaultValue:null},width:{type:"int",group:"Misc",defaultValue:undefined},height:{type:"int",group:"Misc",defaultValue:undefined},maxWidth:{type:"int",group:"Misc",defaultValue:undefined},x:{type:"float",group:"Misc",defaultValue:0},y:{type:"float",group:"Misc",defaultValue:0},showExpandButton:{type:"boolean",defaultValue:true},showActionLinksButton:{type:"boolean",defaultValue:true},showDetailButton:{type:"boolean",defaultValue:true},titleLineSize:{type:"int",defaultValue:1},descriptionLineSize:{type:"int",defaultValue:-1},iconSize:{type:"int",group:"Appearance",defaultValue:undefined},coreNodeSize:{type:"int",group:"Appearance",defaultValue:0},visible:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{actionLinks:{type:"sap.ui.core.Control",multiple:true,singularName:"actionLink"},actionButtons:{type:"sap.suite.ui.commons.networkgraph.ActionButton",multiple:true,singularName:"actionButton"},image:{type:"sap.suite.ui.commons.networkgraph.NodeImage",multiple:false,singularName:"nodeImage"},content:{type:"sap.ui.core.Control",multiple:false},_checkBox:{type:"sap.m.CheckBox",multiple:false,visibility:"hidden"}},events:{headerCheckBoxPress:{parameters:{checked:"boolean"}},press:{},hover:{},collapseExpand:{}}},onAfterRendering:function(){this._afterRenderingBase();}});o.prototype.aProcessRequiredProperties=["key","group"];o.prototype.init=function(O){this._oExpandState=h.EXPANDED;this._oGroup=null;this._iWidth=0;this._iHeight=0;this._iLabelAttrWidth=0;this._iValueAttrWidth=0;this._aTitleLines=[[]];this._aDescriptionLines=[[]];this._bIsHidden=false;this._bActionButtonsRendered=false;this._iCircleSize=0;this._iGroupIndex=-1;this._clearChildren();};o.prototype._clearChildren=function(){this.aChildren=[];this.aParents=[];this.aLines=[];this.aParentLines=[];};o.prototype._afterRendering=function(){var $=this.$();if(this._isInCollapsedGroup()){return;}this._correctTitle("sapSuiteUiCommonsNetworkNodeTitle");this._setupEvents();if(this._bIsHidden){$.hide();}if(!this.getVisible()||(this._oGroup&&!this._oGroup.getVisible())){$.hide();}if(this._oExpandState===h.COLLAPSED){$.addClass("sapSuiteUiCommonsNetworkNodeCollapsed");}if(this._oExpandState===h.PARTIAL){$.addClass("sapSuiteUiCommonsNetworkNodePartialCollapsed");}this.$(this.getId()+"actionbuttons").detach();this._bActionButtonsRendered=false;this._removeFromInvalidatedControls();if(this._isHtml()&&!o.hasNativeLineClamp){this._setTextHeight($.find(".sapSuiteUiCommonsNetworkGraphDivNodeTitle"),this.getTitleLineSize());this._setTextHeight($.find(".sapSuiteUiCommonsNetworkGraphDivNodeDescription"),this.getDescriptionLineSize());}if(this.getSelected()){this.showActionButtons(true);}};o.prototype._render=function(O){var p=this.getParent(),u=p&&p._isUseNodeHtml();if(this._isIgnored()){return"";}O=O||{};if(O.mapRender){if((this._oGroup&&!this._oGroup.getVisible())||!this.getVisible()){return"";}}return u?this._renderHtml(O):this._renderSvg(O);};o.prototype._renderHtmlInfoIcon=function(e){e=e||{};var i="",p=this.getStatusIcon(),t=this._convertToStyle(e);i+="<div title=\""+r.getText("NETWORK_GRAPH_COLLAPSED")+"\" id=\""+this.getId()+"-statusiconwrapper"+"\" "+t+" class=\"sapSuiteUiCommonsNetworkNodeDivInfoWrapper sapSuiteUiCommonsNetworkNodeInfoWrapper\" >";i+="<div class=\"sapSuiteUiCommonsNetworkNodeDivInfoIcon sapSuiteUiCommonsNetworkGraphDivNodeIcon\" >";i+=this._renderHtmlIcon(p||"sap-icon://notification");i+="</div>";i+="</div>";return i;};o.prototype._renderHtmlText=function(t,i,e,p){var u=this._renderHtmlElement("div",{"-webkit-line-clamp":i===0?"":i,"color":p},{"class":"sapSuiteUiCommonsNetworkGraphDivNodeText "+(e||"")+((i===1)?" sapSuiteUiCommonsNetworkGraphDivTextBreakAll ":"")});u+=b(t);u+="</div>";return u;};o.prototype._renderHtmlTitle=function(e){var t=this.getTitle(),i="";if(t){i+=this._renderHtmlText(t,this.getTitleLineSize(),"sapSuiteUiCommonsNetworkGraphDivNodeTitleText sapSuiteUiCommonsNetworkGraphDivNodeTitle",e);i+="<div style=\"clear:both\"></div>";}return i;};o.prototype._renderHtmlDescription=function(e){var i=this.getDescriptionLineSize(),p=this.getDescription();if(p&&i!=-1){return this._renderHtmlText(p,i,"sapSuiteUiCommonsNetworkGraphDivNodeDescription",e);}return"";};o.prototype._renderHtmlTitleAndDescription=function(t){return this._renderHtmlTitle()+this._renderHtmlDescription();};o.prototype._renderHtmlAttributes=function(O){var e=this.getVisibleAttributes();if(!O.renderManager){return;}if(e.length>0){O.renderManager.write("<div class=\"sapSuiteUiCommonsNetworkGraphDivNodeAttributes\">");e.forEach(function(i){this._renderClonedControl(O,i);}.bind(this));O.renderManager.write("</div>");}};o.prototype._showDivActionButtons=function(e){var t=this,$=this.$("rightdivbuttons"),p=this.$("leftdivbuttons");if(e&&!this._bActionButtonsRendered){$.html("");p.html("");var B=0,u=0;if(this.getShowExpandButton()){this._appendActionButton({"class":"sapSuiteUiCommonsNetworkNodeActionCollapseIcon",icon:this._getExpandIcon(true),enable:this._hasVisibleChildren(),title:r.getText("NETWORK_GRAPH_EXPAND_COLLAPSE"),id:this._getDomId("actionCollapse"),click:this._expandClick.bind(this)},$);B++;}if(this.getShowDetailButton()){this._appendActionButton({icon:"sap-icon://menu",enable:this._hasDetailData()||this.getTitle(),id:this._getDomId("actionDetail"),title:r.getText("NETWORK_GRAPH_NODE_DETAILS"),click:function(v){this._detailClick(v.target);}.bind(this)},$);B++;}if(this.getShowActionLinksButton()){this._appendActionButton({icon:"sap-icon://chain-link",enable:this._hasActionLinks(),title:r.getText("NETWORK_GRAPH_NODE_LINKS"),id:this._getDomId("actionLinks"),click:function(v){this._linksClick(v.target);}.bind(this)},$);B++;}for(var i=0;(B+u)<(f*2)&&i<this.getActionButtons().length;i++){(function(v){var P=v.getPosition(),w=P===A.Right?B:u;if(w>=f){P=P===A.Left?A.Right:A.Left;}var x=P===A.Right?$:p;t._appendActionButton({icon:v.getIcon(),enable:v.getEnabled(),title:v.getTitle(),id:v.getId(),click:function(y){v.firePress({buttonElement:y.target});}},x);})(this.getActionButtons()[i]);}this._bActionButtonsRendered=true;}var F=e?"addClass":"removeClass";this.$().find(".sapSuiteUiCommonsNetworkGraphDivActionButtons")[F](this.VISIBLE_ACTIONS_BUTTONS_CLASS);};o.prototype._getCorrectWidth=function(){var w=(this._iWidth||this.getWidth()),i="";if(!w){if(this.getMaxWidth()){i=this.getMaxWidth()+"px";w="";}else{w=g.Box.WIDTH;}}if(w!==""){w+="px";}return{width:w,maxWidth:i};};o.prototype._renderHtml=function(O){var i=this._getElementId(O.idSufix),e=this._isCircle(),w=this._getCorrectWidth();O.renderManager.write(this._renderHtmlElement("div",{width:e?w.width:"","max-width":e?w.maxWidth:"",top:!this._bMainRender&&this.getY()?(this.getY()+"px"):"",left:!this._bMainRender&&this.getX()?(this.getX()+"px"):"","min-width":M+"px"},{id:i,"data-sap-ui":i,"class":this._getNodeClass()}));this._processRenderManager(O.renderManager,this.renderContent(O));O.renderManager&&O.renderManager.write("</div>");};o.prototype._renderHtmlContent=function(O){O=O||{};var i=this._getElementId(O.idSufix),e=this._iHeight||this.getHeight()||g.Circle.HEIGHT,p=this._isCircle();var P=function(){var x=this.getContent();if(x){O.renderManager.write("<div id=\""+this.getId()+"-contentwrapper\">");this._renderClonedControl(O,x);O.renderManager.write("</div>");}else{this._processRenderManager(O.renderManager,this.renderItemContent(O));}}.bind(this);var F=this._getStatusStyle({"border-color":E.ColorType.Focus},true);if(p){this._iCircleSize=this._iCircleSize||e;var t=this._convertToStyle({width:this._iCircleSize+"px",height:this._iCircleSize+"px"},this._getStatusStyle({"border-color":E.ColorType.Border}));var u=this._getStatusStyle({"border-color":E.ColorType.Background},true);var B=this._getStatusStyle({"border-color":E.ColorType.Border,"background-color":this.getSelected()?E.ColorType.SelectedBackground:"","border-width":E.ColorType.BorderWidth,"border-style":E.ColorType.BorderStyle},true);O.renderManager.write("<div id=\""+i+"-wrapperwithbuttons\""+t+" class=\"sapSuiteUiCommonsNetworkGraphDivInnerWrapper\">");O.renderManager.write(this.renderHtmlActionButtons(O));O.renderManager.write("<div id=\""+i+"-wrapper\""+B+" class=\"sapSuiteUiCommonsNetworkGraphDivInner\">");O.renderManager.write("<div class=\"sapSuiteUiCommonsNetworkDivCircleWrapper\">");O.renderManager.write(this._renderHtmlInfoIcon());O.renderManager.write("<div "+F+" id=\""+i+"-focus\" class=\"sapSuiteUiCommonsNetworkDivFocus\">");O.renderManager.write("<div id=\""+i+"-status\""+u+" class=\"sapSuiteUiCommonsNetworkDivCircleStatus\">");this._processRenderManager(O.renderManager,this.renderItemContent(O));O.renderManager.write("</div>");O.renderManager.write("</div>");O.renderManager.write("</div>");O.renderManager.write("</div>");O.renderManager.write("</div>");O.renderManager.write(this._renderHtmlTitleAndDescription());}else{var w=this._getCorrectWidth();var t=this._convertToStyle({width:w.width,"max-width":w.maxWidth?w.maxWidth:"inherit"},this._getStatusStyle({"border-color":E.ColorType.Border,"background-color":this.getSelected()?E.ColorType.SelectedBackground:"","border-width":E.ColorType.BorderWidth,"border-style":E.ColorType.BorderStyle}),false);O.renderManager.write(this.renderHtmlActionButtons(O));O.renderManager.write("<div "+t+" id=\""+i+"-wrapper\" class=\"sapSuiteUiCommonsNetworkGraphDivInner\">");O.renderManager.write("<div "+F+" id=\""+i+"-focus\" class=\"sapSuiteUiCommonsNetworkDivFocus\"></div>");var u=this._getStatusStyle({"background-color":E.ColorType.Background},true);var v=this._getColor(this.getSelected()?E.ColorType.Content:E.ColorType.HeaderContent);O.renderManager.write("<div id=\""+i+"-header\" "+u+" class=\"sapSuiteUiCommonsNetworkGraphDivHeader sapSuiteUiCommonsNetworkGraphDivHeaderColor");if(!this._hasAdditionalContent()){O.renderManager.write(" sapSuiteUiCommonsNetworkGraphDivHeaderOnly");}O.renderManager.write("\">");if(this._showHeaderCheckBox()){this._renderClonedControl(O,this._getHeaderCheckbox());}O.renderManager.write(this._renderHtmlTitleIcon("sapSuiteUiCommonsNetworkGraphDivNodeIconTitle"));O.renderManager.write(this._renderHtmlTitle(v));O.renderManager.write("</div>");P();O.renderManager.write("</div>");O.renderManager.write(this._renderHtmlInfoIcon());}};o.prototype._getHeaderCheckbox=function(){var e=this.getAggregation("_checkBox"),t=this;if(!e){e=new C(this.getId()+"-checkbox").addStyleClass("sapSuiteUiCommonsNetworkGraphHeaderCheckboxInner");e.addEventDelegate({"onAfterRendering":function(){e.$().mousedown(function(i){var p=!e.getSelected();e.setSelected(p);t.fireHeaderCheckBoxPress({checked:p});i.stopPropagation();});}});this.setAggregation("_checkBox",e,true);}return e;};o.prototype._renderHtmlTitleIcon=function(e){var i=this.getIcon(),p=this.getImage(),t=this._getStatusStyle({"color":this._isBox()?E.ColorType.HeaderContent:E.ColorType.Content},true),F=this.getIconSize()?"style=\"font-size:"+this.getIconSize()+"px\"":"";var u="";e=(e||"")+" sapSuiteUiCommonsNetworkGraphDivNodeTitleText sapSuiteUiCommonsNetworkGraphDivNodeIcon";if(p){var v=this._getImageSize();u=this._renderHtmlElement("img",{width:v.width+"px",height:v.height+"px"},{"src":b(p.getSrc()),"class":"sapSuiteUiCommonsNetworkGraphDivNodeImage"});}else if(i){u="<div "+t+" class=\""+e+"\">"+this._renderHtmlIcon(i,"","",F)+"</div>";}return u;};o.prototype._renderHtmlBoxContent=function(O){var e="",i=this._hasAdditionalContent(),p=this._getElementId(O.idSufix);if(i){e+="<div id=\""+p+"-additionalwarpper\" class=\"sapSuiteUiCommonsNetworkGraphDivAdditionalContent\">";var t=this._getColor(E.ColorType.Content);e+=this._renderHtmlDescription(t);this._processRenderManager(O.renderManager,e);e="";this._renderHtmlAttributes(O);e+="</div>";}return e;};o.prototype._renderHtmlCircleContent=function(O){return this._renderHtmlTitleIcon("sapSuiteUiCommonsNetworkGraphDivNodeCircleIcon");};o.prototype._renderSvg=function(O){var i=this._getElementId(O.idSufix);var e=this._renderControl("g",{id:i,"data-sap-ui":i,nodeid:b(this.getKey()),"class":this._getNodeClass()},false);e+=this._renderControl("g",{id:i+"-wrapper","class":"sapSuiteUiCommonsNetworkNodeShape"},false);e+=this._renderContent(O);e+="</g>";e+="</g>";return e;};o.prototype._renderSvgContent=function(O){var e=this._isBox()?this._renderBox(O):this._renderCircle(O);var i=this.getParent()._bIsRtl,x,y;if(this._isCircle()){var p=this._iCircleSize/8,t=this._iCircleSize/5.3;x=i?this._getCirclePosition().x+this._iCircleSize-p:this._getCirclePosition().x+p;y=this.getY()+t;}else{x=this.getX();y=this.getY();}e+=this.renderStatusIcon({x:x-this.getX(),y:y-this.getY()});return e;};o.prototype._renderContent=function(O){return this.renderContent(O);};o.prototype._renderCircleContent=function(){var i=this._iCircleSize,e=this.getParent()._bIsRtl,p=this.getImage(),t,x=this.getX(),y=this.getY(),u="";if(this._displayImage(p)){t=this._getImageSize();u+=this._renderControl("image",{"xlink:href":b(p.getSrc()),x:x+this._iWidth/2-t.width/2,y:y+i/2-t.height/2,width:t.width,height:t.height});}else if(this.getIcon()){u+=this._renderIcon({attributes:{"class":"sapSuiteUiCommonsNetworkGraphIcon sapSuiteUiCommonsNetworkCircleNodeIcon sapSuiteUiCommonsNetworkStatusText",style:(this.getIconSize()?("font-size:"+this.getIconSize()+"px;"):"")+this._getStatusStyle({fill:E.ColorType.Content}),x:x+this._iWidth/2,y:y+i/2},icon:this.getIcon(),height:this.getIconSize()?this.getIconSize()-2:22});}if(this.getTitle()){if(!this._aTitleLines||this._aTitleLines.length===1){u+=this._renderClipPath({id:this.getId()+"-title-clip",x:x,y:y+i+g.Title.OFFSET-10,height:g.Title.LINESIZE*2});u+=this._renderTitle({"class":"sapSuiteUiCommonsNetworkNodeTitle sapSuiteUiCommonsNetworkNodeText",x:x+this._iWidth/2,y:y+i+g.Title.OFFSET,title:s(this.getTitle()),maxWidth:this._iWidth-5});}else{u+=this._renderMultilineTitle({x:x+this._iWidth/2,y:y+i+g.Title.OFFSET*2});}}if(this._displayDescription()){u+=this._renderDescription({x:e?x+this._iWidth-g.Title.OFFSET:x+g.Title.OFFSET,y:y+this._getTitleHeight()+i+g.Title.OFFSET*2+g.Title.OFFSET/2});}return u;};o.prototype._renderCircle=function(){var e="",x=this.getX(),y=this.getY(),i=6,F=2,p=this._iCircleSize;e+=this._renderControl("circle",{id:this.getId()+"-innerBox",cx:x+this._iWidth/2,cy:y+p/2,style:this._getStatusStyle({stroke:E.ColorType.Border}),r:p/2,"class":"sapSuiteUiCommonsNetworkInnerCircle"});e+=this._renderControl("circle",{id:this.getId()+"-statusCircle",cx:x+this._iWidth/2,cy:y+p/2,style:this._getStatusStyle({stroke:E.ColorType.Background}),r:p/2-i,"class":"sapSuiteUiCommonsNetworkInnerCircleStatus"});e+=this._renderControl("circle",{id:this.getId()+"-focusCircle",cx:x+this._iWidth/2,cy:y+p/2,style:this._getStatusStyle({stroke:E.ColorType.Focus}),r:p/2-F,"class":"sapSuiteUiCommonsNetworkCircleFocus"});e+=this.renderItemContent();return e;};o.prototype._renderBoxContent=function(O){var e=c/2,t=g.Title.ICON_X_OFFSET,i=this.getParent()._bIsRtl,p=this.getImage(),y=this.getY(),x=this.getX(),u,v=this._getImageSize(),w="";if(this._displayImage(p)){v=this._getImageSize();w+=this._renderControl("image",{"xlink:href":b(p.getSrc()),x:i?x+this._iWidth-g.Title.ICON_X_OFFSET-v.width:x+g.Title.ICON_X_OFFSET,y:y+g.Title.IMAGE_OFFSET_Y,width:v.width,height:v.height});t+=v.width+g.Title.ICON_X_OFFSET;}else if(this.getIcon()){w+=this._renderIcon({attributes:{style:this._getStatusStyle({fill:E.ColorType.Content}),"class":"sapSuiteUiCommonsNetworkGraphIcon sapSuiteUiCommonsNetworkNodeTitleIcon sapSuiteUiCommonsNetworkStatusText",x:i?x+this._iWidth-g.Title.ICON_X_OFFSET:x+g.Title.ICON_X_OFFSET,y:y+e},icon:this.getIcon(),height:g.Title.LINESIZE});t+=g.Title.ICON_SIZE+g.Title.ICON_X_OFFSET;}if(this.getTitle()){u=this._iWidth-t-d;if(u>0){if(!this._aTitleLines||this._aTitleLines.length===1){w+=this._renderClipPath({id:this.getId()+"-title-clip",x:x,y:y,height:c});w+=this._renderTitle({"class":"sapSuiteUiCommonsNetworkNodeTitle sapSuiteUiCommonsNetworkNodeText sapSuiteUiCommonsNetworkStatusText",style:this._getStatusStyle({fill:E.ColorType.Content}),x:i?x+this._iWidth-t:x+t,y:y+e,maxWidth:u,title:s(this.getTitle())});}else{w+=this._renderMultilineTitle({x:i?x+this._iWidth-t:x+t,y:y+g.Title.OFFSET*2});}}}if(this._displayDescription()){w+=this._renderDescription({x:i?x+this._iWidth-g.Title.OFFSET:x+g.Title.OFFSET-g.Title.OFFSET/3,y:y+this._getTitleHeight()+(this._hasMultiLineTitle()?(g.Title.OFFSET*2+g.Title.OFFSET/2):g.Title.OFFSET*4)});}if(this._displayAttributes()){w+=O.sizeDetermination?this._renderAttributesForSize():this._renderAttributes({y:this.getY()+this._getDescriptionHeight()+this._getTitleHeight()+g.Title.OFFSET+(!this._hasMultiLineTitle()?g.Attributes.OFFSET:0)});}return w;};o.prototype._renderBox=function(O){var d=6,F=4,t=(this._iTitleHeight||this._getTitleHeight())+d,R=3;var y=this.getY(),x=this.getX();var e=this._renderControl("rect",{id:this.getId()+"-innerBox",x:x,y:y,style:this._getStatusStyle({stroke:E.ColorType.Border}),"class":"sapSuiteUiCommonsNetworkInnerRect",rx:R,ry:R,width:this._iWidth,height:this._iHeight,"pointer-events":"fill"});var i=this._iHeight===c;e+=this._renderRoundRect({id:this.getId()+"-innerStatusBox",x:x,y:y,style:this._getStatusStyle({fill:E.ColorType.Background}),"class":"sapSuiteUiCommonsNetworkNodeBoxStatus",topRight:R,topLeft:R,bottomRight:i?R:0,bottomLeft:i?R:0,width:this._iWidth,height:Math.max(t,c),"pointer-events":"fill"});e+=this._renderControl("rect",{id:this.getId()+"-focusCircle",x:x+F,y:y+F,"class":"sapSuiteUiCommonsNetworkBoxFocus",style:this._getStatusStyle({stroke:E.ColorType.Focus}),rx:5,ry:5,width:this._iWidth-F*2,height:this._iHeight-F*2});e+=this.renderItemContent(O);return e;};o.prototype._renderInfoIcon=function(x,y,i,F){var e=this.getStatusIcon(),p=e?"sapSuiteUiCommonsNetworkNodeInfoWrapperCustomIcon":"",t="<g id=\""+this.getId()+"-statusiconwrapper"+"\" class=\"sapSuiteUiCommonsNetworkNodeInfoWrapper "+p+"\">";t+=this._renderControl("circle",{"class":"sapSuiteUiCommonsNetworkNodeInfoBox",cx:x,cy:y,r:i||g.Title.INFO_BOX_SIZE/2},false);t+="<title>"+r.getText("NETWORK_GRAPH_COLLAPSED")+"</title>";t+="</circle>";t+=this._renderIcon({attributes:{id:this.getId()+"-statusicon","class":"sapSuiteUiCommonsNetworkNodeInfoIcon sapSuiteUiCommonsNetworkGraphIcon",x:x+g.Title.INFO_BOX_SIZE/2-10,y:y,style:F?("font-size:"+F):""},icon:e||"sap-icon://notification",height:g.Title.INFO_BOX_SIZE/2+2.5});t+="</g>";return t;};o.prototype._getNodeClass=function(){var e=this.getSelected()?this.SELECT_CLASS:"",i=this._hasCustomStatus()?" sapSuiteUiCommonsNetworkNodeCustomStatus ":"",p="";if(this.aCustomStyleClasses){p=this.aCustomStyleClasses.join(" ");}return(this.getParent()._isUseNodeHtml()?"sapSuiteUiCommonsNetworkGraphDivNode ":"sapSuiteUiCommonsNetworkNode ")+e+i+(this._isBox()?" sapSuiteUiCommonsNetworkBox ":" sapSuiteUiCommonsNetworkNodeCircle ")+this._getStatusClass()+p;};o.prototype._renderAttributesForSize=function(){var L="",v="";this.getVisibleAttributes().forEach(function(i){L+=this._renderText({attributes:{"class":"sapSuiteUiCommonsNetworkGraphAttribute",x:this.getX(),y:this.getY()},text:i.getLabel()});v+=this._renderText({attributes:{"class":"sapSuiteUiCommonsNetworkGraphAttribute",x:this.getX(),y:this.getY()},text:i.getValue()});},this);L="<g id=\""+this.getId()+"-attrLabel\">"+L+"</g>";v="<g id=\""+this.getId()+"-attrValue\">"+v+"</g>";return L+v;};o.prototype._getAttributeColor=function(i,e,t){var p=e+"Status",u=i["get"+p]()||this.getStatus();return this._getColor(t,u);};o.prototype._getAttributeColorString=function(i,e,t){var p=this._getAttributeColor(i,e,t);return p?"fill:"+p:"";};o.prototype._renderAttributes=function(p){p=p||{};var P=2,B=6,e=12;var t=this.getParent()._bIsRtl,L=t?this.getX()+this._iWidth-B:this.getX()+B,u=this._iLabelAttrWidth?this._iLabelAttrWidth:this._iWidth/2-e,v=t?L-u-e:L+u+e,V=t?v-this.getX()-B:(this.getX()+this._iWidth)-v-B;var w=this._renderControl("g",{"clip-path":"url(#"+this.getId()+"-clip-attr-value)",id:this.getId()+"-attrValue"},false),x=this._renderControl("g",{"clip-path":"url(#"+this.getId()+"-clip-attr-label)",id:this.getId()+"-attrLabel"},false),y=p.y,z=this._renderClipPath({id:this.getId()+"-clip-attr-label",x:t?L-u-B+P:L-P,y:y,width:P*2+(t?u+B:u)});z+=this._renderClipPath({id:this.getId()+"-clip-attr-value",x:t?this.getX()+B+P:v-P,y:y,width:P*2+(t?V+B:V)});this.getVisibleAttributes().forEach(function(F,i){var Y=y+g.Attributes.LINE*(i+1);x+=this._renderText({attributes:{style:this._getAttributeColorString(F,a.Type.Label,E.ColorType.Content),"class":"sapSuiteUiCommonsNetworkGraphAttribute sapSuiteUiCommonsNetworkStatusText",x:L,id:F.getId()+"-label",y:Y},text:F.getLabel()});w+=this._renderText({attributes:{style:this._getAttributeColorString(F,a.Type.Value,E.ColorType.Content),"class":"sapSuiteUiCommonsNetworkGraphAttribute sapSuiteUiCommonsNetworkGraphAttributeValue sapSuiteUiCommonsNetworkStatusText",x:v,y:Y,id:F.getId()+"-value"},text:F.getValue()});},this);w+="</g>";x+="</g>";return z+x+w;};o.prototype._detailClick=function(O){O=O||this;this.getParent()._tooltip.openDetail({item:this,opener:O});};o.prototype._linksClick=function(O){O=O||this;this.getParent()._tooltip.openLink({item:this,opener:O});};o.prototype._expandClick=function(){var e=this.fireEvent("collapseExpand",{},true);if(e){this.setCollapsed(this._oExpandState!==h.COLLAPSED);}};o.prototype._setupMaxWidth=function(){var i=this.getMaxWidth();if(i){this._iWidth=i;}};o.prototype._setTextHeight=function($,i){if($[0]&&i>0){var e=this.$().find(".sapSuiteUiCommonsNetworkGraphDivNodeIcon.sapSuiteUiCommonsNetworkGraphDivNodeIconTitle");e.hide();var p=$.height();$.css("white-space","nowrap");var t=$.height();$.height(Math.min(p,i*t));$.css("white-space","");e.show();}};o.prototype._applyMaxWidth=function(){var O=30,d=10;var i,$,e,v=0,L=0,p=0,t,u=this.getMaxWidth();if(this._oGroup&&this._oGroup.getCollapsed()){return;}if(!this.getWidth()&&this.getMaxWidth()){$=this.$("attrLabel");e=this.$("attrValue");if($[0]){L=$[0].getBBox().width;}if(e[0]){v=e[0].getBBox().width;}p=v+L+O;i=Math.max(this.$()[0].getBBox().width+d,p);this._iWidth=Math.max(Math.min(i,u),80);if((v&&L)){t=Math.max(L,v);if(t*2+O/2<this._iWidth){return;}if(p>this._iWidth){if(v<u/2){this._iLabelAttrWidth=this._iWidth-v-O;}if(L<this._iWidth/2){this._iLabelAttrWidth=L+O/4;}}else{this._iLabelAttrWidth=this._iWidth-v-O;}}}};o.prototype._resetDimensions=function(){this._iWidth=0;this._iHeight=0;this._iCircleSize=0;this._iTitleHeight=0;};o.prototype._setupDivDimensions=function(){var $=this.$();this._iWidth=$.width();this._iHeight=$.height();};o.prototype._setupWidthAndHeight=function(R){var t=this._isBox()?"Box":"Circle",i=this._getTitleHeight(),e=this.getTitle()||this._hasDetailData()?g.Title.LINESIZE:0,p=this._getDescriptionHeight();p=p?p+5:0;var G=function(){var v=this._iHeight||this.getHeight();if(this._isBox()&&!v){v=p+(this._hasMultiLineTitle()?i+g.Title.OFFSET:Math.max(i+e,g.Box.HEIGHT));if(this._displayAttributes()){v+=this.getVisibleAttributes().length*g.Attributes.LINE+g.Attributes.OFFSET;}}if(this._isCircle()&&!this._iHeight){v=v?v:g[t].HEIGHT;this._iCircleSize=v;v+=i+p;}return Math.max(v,30);}.bind(this);var u=function(){var w=Math.max(this._iWidth||this.getWidth()||g[t].WIDTH,30);if(this._isCircle()&&w<this._iCircleSize){w=this._iCircleSize;}return w;}.bind(this);this._iHeight=G();this._iWidth=u();};o.prototype._getTitleHeight=function(){var i=0,e=this._getImageSize();if(this._hasMultiLineTitle()){i=(((this.getTitleLineSize()>0)?Math.min(this._aTitleLines.length,this.getTitleLineSize()):this._aTitleLines.length))*g.Title.LINESIZE;}else{i=(this._isBox()||this.getTitle())?g.Title.LINESIZE:0;}return Math.max(e.height,i);};o.prototype._getDescriptionHeight=function(){var i=this.getDescriptionLineSize();if(i===-1||!this._aDescriptionLines||!this.getDescription()){return 0;}return(i>0?Math.min(i,this._aDescriptionLines.length):this._aDescriptionLines.length)*g.Description.LINESIZE;};o.prototype._setupEvents=function(){var $=this.$("wrapper");$.unbind("mousedown");$.unbind("mouseover");$.unbind("mouseout");$.mousedown(function(e){this._mouseDown(e.ctrlKey);e.preventDefault();}.bind(this));$.mouseover(function(e){this._mouseOver();}.bind(this));$.mouseout(function(e){this._mouseOut();}.bind(this));};o.prototype._mouseOut=function(){this.$().removeClass(this.HIGHLIGHT_CLASS);if(!this.getSelected()){this._setStatusColors("");}};o.prototype._mouseOver=function(){var e=this.fireEvent("hover",{},true);if(e){if(!this.getSelected()){this._setStatusColors("Hover");}this.$().addClass(this.HIGHLIGHT_CLASS);}};o.prototype._mouseDown=function(i){var e=this.fireEvent("press",{},true);this.getParent()._selectNode({element:this,forceFocus:true,renderActionButtons:e&&!this.getSelected(),preventDeselect:i});if(!this.getSelected()){this.$().addClass(this.HIGHLIGHT_CLASS);this._setStatusColors("Hover");}};o.prototype._deselect=function(){var $=this.$("innerBox");$.css("stroke",this._getColor(E.ColorType.Border));$.css("fill",this._getColor(E.ColorType.Background));};o.prototype._getExpandIcon=function(R){switch(this._oExpandState){case h.PARTIAL:return R?j.PARTIAL:n;case h.EXPANDED:return R?j.COLLAPSE:m;case h.COLLAPSED:return R?j.EXPAND:k;default:return R?j.EXPAND:k;}};o.prototype._createLineText=function(t,w,e,i){var L=[[]],p=0,R,W,u,v,x,y,z=this._createElement("tspan");if(!t||w<0){return L;}v=t.split(/\s+/).reverse();e.appendChild(z);while(v.length>0){W=v.pop();if(W){u=L[p];u.push(W);z.textContent=L[p].join(" ");if(z.getComputedTextLength()>w){if(u.length>1&&i!==1){v.push(u.pop());}if(u.length===1){y=this._createText(e,{text:u[0],width:w,dots:false});if(y){x=z.textContent;u.pop();u.push(x);R=W.substring(x.length);v.push(R);}}p++;if(i>0&&p>=i){break;}L[p]=[];}}}if(i>0&&v.length>0){L[L.length-1].push("...");}if(L.length>0){y=this._createText(e,{text:L[L.length-1].join(" "),width:w,dots:true});if(y){L[i-1]=[z.textContent];}}return L;};o.prototype._createDescription=function(){var t,w=this._iWidth-g.Title.OFFSET,$=this.$();if(this._displayDescription()&&$[0]){t=this._createElement("text");t.setAttribute("class","sapSuiteUiCommonsNetworkNodeDescription");$[0].appendChild(t);this._aDescriptionLines=this._createLineText(this.getDescription(),w,t,this.getDescriptionLineSize());}};o.prototype._createMultilineTitle=function(){var G=function(){if(this._isBox()){if(this._displayImage()){return this._iWidth-this._getImageSize().width-g.Title.ICON_X_OFFSET*2;}if(this.getIcon()){return this._iWidth-g.Title.ICON_SIZE-g.Title.ICON_X_OFFSET*2;}return this._iWidth-g.Title.OFFSET*2;}return this._iWidth;}.bind(this);var t,w=G(),$=this.$();if(this.getTitleLineSize()!==1&&$[0]&&w>0){t=this._createElement("text");t.setAttribute("class","sapSuiteUiCommonsNetworkNodeTitle sapSuiteUiCommonsNetworkNodeMultipleLineTitle");$[0].appendChild(t);this._aTitleLines=this._createLineText(this.getTitle(),w,t,this.getTitleLineSize());}};o.prototype.getFocusDomRef=function(){return this.getDomRef("wrapper");};o.prototype._renderMultilineText=function(e){var p="",u=this._isBox()&&e.useCustomstyle;if(!e.lines){return"";}for(var i=0;i<e.lines.length;i++){p+=this._renderText({attributes:{style:u?this._getStatusStyle({fill:E.ColorType.Content}):"","class":e.class+(u?" sapSuiteUiCommonsNetworkStatusText ":""),x:e.x,y:e.y+(i*e.lineSize)},close:false});p+=e.lines[i].join(" ");p+="</text>";}return p;};o.prototype._renderDescription=function(e){e.class=" sapSuiteUiCommonsNetworkNodeTitle sapSuiteUiCommonsNetworkNodeMultipleLineTitle";return this._renderMultilineText({lines:this._aDescriptionLines,maxLineSize:this.getDescriptionLineSize(),lineSize:g.Description.LINESIZE,"class":" sapSuiteUiCommonsNetworkNodeDescription ",x:e.x,y:e.y});};o.prototype._sanitizeTitleLines=function(L){for(var i=0;i<L.length;i++){L[i]=s(L[i]);}return L;};o.prototype._renderMultilineTitle=function(e){var i=this._sanitizeTitleLines(this._aTitleLines);return this._renderMultilineText({useCustomStyle:true,lines:i,maxLineSize:this.getTitleLineSize(),lineSize:g.Title.LINESIZE,"class":" sapSuiteUiCommonsNetworkNodeTitle sapSuiteUiCommonsNetworkNodeMultipleLineTitle",x:e.x,y:e.y,trim:this._aTitleLines.length>this.getTitleLineSize()&&this.getTitleLineSize()!==0});};o.prototype._processHideShowParents=function(e,R,i){var p=this._oGroup&&this._oGroup.getCollapsed();var t=function(u){if(u._bIsHidden){return;}var v=false,w;if(u.getKey()!==R){if(u.aChildren.length>0){w=u.aChildren[0]._bIsHidden;u.aChildren.forEach(function(x){if(w!==x._bIsHidden){v=true;}});u._oExpandState=v?h.PARTIAL:w?h.COLLAPSED:h.EXPANDED;if(u._oExpandState===h.COLLAPSED){u.$().addClass("sapSuiteUiCommonsNetworkNodeCollapsed");}else{u.$().removeClass("sapSuiteUiCommonsNetworkNodeCollapsed");}if(u._oExpandState===h.PARTIAL){u.$().addClass("sapSuiteUiCommonsNetworkNodePartialCollapsed");}else{u.$().removeClass("sapSuiteUiCommonsNetworkNodePartialCollapsed");}}}};t(this);this.aParents.forEach(function(u){if(!i[u.getKey()]){t(u);}});if(p){if(this._oGroup._bNeedParentProcessing){this._oGroup.aNodes.forEach(function(G){G.aParents.forEach(function(P){if(!i[P.getKey()]){t(P);}});});this._oGroup._bNeedParentProcessing=false;}}};o.prototype._getAllChildren=function(e,R,i){var p=function(K){if(!i[K]){i[K]=this;return true;}return false;}.bind(this);if(R===this.getKey()){return;}if(this._bIsHidden===e){return;}if(!p(this.getKey())){return;}if(this._oGroup&&this._oGroup.getCollapsed()){this._oGroup.aNodes.forEach(function(t){t._getAllChildren(e,R,i);});}if(this._oExpandState!==h.COLLAPSED){this.aChildren.forEach(function(t){t._getAllChildren(e,R,i);});}};o.prototype._hideShow=function(e){var F=e?"hide":"show",i;this._bIsHidden=e;this.aLines.forEach(function(L){L._hideShow(e);});this.aParentLines.forEach(function(L){L._hideShow(e);});if(this._oGroup&&!this._oGroup._bIsSwimLane){if(this._oGroup.getCollapsed()){this._oGroup._hideShow(e);}else{i=this._oGroup._hasVisibleNodes();if((i&&!e)||(!i&&e)){this._oGroup._hideShow(e);}}}if(this._isInCollapsedGroup()&&this._isHtml()){return;}if(this.$()){this.$()[F]();}};o.prototype._setActionButtonFocus=function(i,F){this.$().removeClass(this.FOCUS_CLASS);this.$().find("."+this.FOCUS_CLASS).removeClass(this.FOCUS_CLASS);var e=F?"addClass":"removeClass";q(i)[e](this.FOCUS_CLASS);};o.prototype._getActionButtonTitle=function(i){if(this.getParent().getRenderType()==="Html"){var F=q(i).attr("title");return r.getText("NETWORK_GRAPH_ACCESSIBILITY_ACTION_BUTTON")+(F?" "+F:"");}else{var e=q(i).find("title")[0];return r.getText("NETWORK_GRAPH_ACCESSIBILITY_ACTION_BUTTON")+(e?" "+e.textContent:"");}};o.prototype._getAccessibilityLabel=function(){var L=r.getText("NETWORK_GRAPH_NODE")+" "+this.getTitle();if(this._isBox()){this.getVisibleAttributes().forEach(function(e){L+=" "+e.getLabel()+" "+e.getValue();});}return L;};o.prototype._setStatusColors=function(t){var e=function(F,G){if(G&&F){var J=this._getColor(E.ColorType[t+"Content"],G),K=u?"color":"fill";q(F).css(K,J||i);}}.bind(this);var u=this.getParent()&&this.getParent()._isUseNodeHtml();if(this._hasCustomStatus()){var i=this._getColor(E.ColorType[t+"Content"]),B=this._getColor(E.ColorType[t+"Background"]),p=this._getColor(E.ColorType[t+"Border"]);var v=(t==="Selected"||t==="Hover");if(!u){var $=this.$("innerBox"),w=x?this.$("statusCircle"):this.$("innerStatusBox"),x=this._isCircle();w.css(x?"stroke":"fill",v?"none":B);$.css("fill",v?B:"");$.css("stroke",p);this.$().find(".sapSuiteUiCommonsNetworkStatusText").css("fill",i);this.$("focusCircle").css("stroke",this._getColor(E.ColorType[t+"Focus"]));}else{var y=this.$("wrapper"),z=this.$().find(".sapSuiteUiCommonsNetworkGraphDivNodeTitleText");y.css("border-color",p);this.$("focus").css("border-color",this._getColor(E.ColorType[t+"Focus"]));if(this._isBox()){this.$().find(".sapSuiteUiCommonsNetworkGraphDivNodeText").css("color",i);this.$("header").css("background-color",v&&!B?"":B);z.css("color",v?i:this._getColor(E.ColorType.HeaderContent));y.css("background-color",v&&B?B:"");}else{this.$("status").css("border-color",B);y.css("background-color",v&&B?B:"");this.$().find(".sapSuiteUiCommonsNetworkGraphDivNodeCircleIcon").css("color",i);}}}this.getAttributes().forEach(function(F){if(F&&F.getVisible()){var L=F.getLabelStatus(),V=F.getValueStatus();if(L){e(F.$("icon"),L);e(F.$("label"),L);}if(V){e(F.$("value"),V);}}});};o.prototype._setNodeOpacity=function(e){if(this._isCircle()){this.$("wrapper").css("opacity",e?0.3:"");this.$().find(".sapSuiteUiCommonsNetworkGraphDivNodeTitleText").css("opacity",e?0.3:"");if(e){this.$("wrapperwithbuttons").append(q("<div/>",{"class":"sapSuiteUiCommonsNetworkGraphDivInnerCloned sapSuiteUiCommonsNetworkGraphDivInner"}));}else{this.$("wrapperwithbuttons").find(".sapSuiteUiCommonsNetworkGraphDivInnerCloned").detach();}return;}this.$().css("opacity",e?0.3:"");};o.prototype._getContentRect=function(){var e=this._getCirclePosition(),i=this._isCircle();var x=i?e.x:this.getX(),y=i?e.y:this.getY(),p=i?this._iCircleSize:this._iHeight,w=i?this._iCircleSize:this._iWidth;return{p1:{x:x,y:y},p2:{x:x+w,y:y+p}};};o.prototype._setFocus=function(F){E.prototype._setFocus.apply(this,arguments);var t=F?"Selected":"";this.$("focus").css("border-color",this._getColor(E.ColorType[t+"Focus"]));};o.prototype.getHeaderCheckbox=function(){return this._getHeaderCheckbox();};o.prototype.computeTextDimensions=function(i){var p=this.getDomRef(),t,u,v;if(p){t=this._createElement("text",i.attributes);p.appendChild(t);try{u=this._createLineText(i.text,i.width,t,i.maxLines);v=t.getBBox().height;}catch(e){}q(t).detach();return{text:u,lineHeight:v};}};o.prototype.renderText=function(e){var p=16;var t="",L=e.lines;if(!L){if(e.text){L=[e.text.split(" ")];}else{return"";}}for(var i=0;i<L.length;i++){t+=this._renderText({attributes:Object.assign({x:e.x+this.getX(),y:this.getY()+e.y+(i*(e.lineSize||p))},e.attributes),close:false});t+=L[i].join(" ");t+="</text>";}return t;};o.prototype.renderIcon=function(e){e.attributes=e.attributes||{};Object.assign(e.attributes,{"font-family":"SAP-icons"});e.attributes.x=this.getX()+(e.x||0);e.attributes.y=this.getY()+(e.y||0);return this._renderIcon({attributes:e.attributes,icon:e.icon});};o.prototype.renderHtmlIcon=function(i){return this._renderHtmlIcon(i,"sapSuiteUiCommonsNetworkGraphDivNodeIcon");};o.prototype.renderHtmlActionButtons=function(O){O=O||{};var R=this._getElementId(O.idSufix)+"-rightdivbuttons",L=this._getElementId(O.idSufix)+"-leftdivbuttons";var e="<div id=\""+R+"\" class=\"sapSuiteUiCommonsNetworkGraphDivActionButtons sapSuiteUiCommonsNetworkGraphDivActionButtonsRight\"></div>",i="<div id=\""+L+"\" class=\"sapSuiteUiCommonsNetworkGraphDivActionButtons sapSuiteUiCommonsNetworkGraphDivActionButtonsLeft\"></div>";return i+e;};o.prototype.renderHtmlInfoIcon=function(e){return this._renderHtmlInfoIcon(e);};o.prototype.renderContent=function(O){return this._isHtml()?this._renderHtmlContent(O):this._renderSvgContent(O);};o.prototype.renderItemContent=function(O){if(this._isHtml()){return this._isBox()?this._renderHtmlBoxContent(O):this._renderHtmlCircleContent(O);}return this._isBox()?this._renderBoxContent(O):this._renderCircleContent(O);};o.prototype.calculateSizes=function(){this._setupMaxWidth();this._createMultilineTitle();this._createDescription();this._resetDimensions();this._applyMaxWidth();};o.prototype.renderElement=function(e,i,p){return this._renderControl(e,i,p);};o.prototype.renderStatusIcon=function(p){return this._renderInfoIcon(this.getX()+p.x,this.getY()+p.y,p.size,p.iconSize);};o.prototype.setSize=function(e){if(e){if(e.width){this._iWidth=e.width;}if(e.height){this._iHeight=e.height;}if(e.titleHeight){this._iTitleHeight=e.titleHeight;}}};o.prototype.hasVisibleActionButtons=function(){return this.$("actionButtons").hasClass(this.VISIBLE_ACTIONS_BUTTONS_CLASS)||this.$().find(".sapSuiteUiCommonsNetworkGraphDivActionButtons").hasClass(this.VISIBLE_ACTIONS_BUTTONS_CLASS);};o.prototype.getEnabledActionButtons=function(){return this.$().find(".sapSuiteUiCommonsNetworkNodeActionButton, .sapSuiteUiCommonsNetworkGraphDivActionButton:not(.sapSuiteUiCommonsNetworkGraphDivActionButtonDisabled)").parent().toArray();};o.prototype.showActionButtons=function(e){if(!this.getParent()){return;}var R,p,t=this,B=0,u=0,v=this.getParent()._bIsRtl,w,x,y,z,F,G,L;if(this._isHtml()){this._showDivActionButtons(e);return;}var J=function(){var y=this.getParent()._bIsRtl?-g.ActionButtons.RADIUS-g.ActionButtons.MARGIN:g.ActionButtons.RADIUS+g.ActionButtons.MARGIN,F=g.ActionButtons.RADIUS,Q=[[y,F]];for(var i=1;i<R;i++){Q.push([y,F+g.ActionButtons.RADIUS*2*i+g.ActionButtons.OFFSET*i]);}return Q;}.bind(this);var K=function(){var Q=this.getActionButtons().length;if(this.getShowExpandButton()){Q++;}if(this.getShowDetailButton()){Q++;}if(this.getShowActionLinksButton()){Q++;}return Q;}.bind(this);var O=function(Q){var U=13,V=2,W=Q.position&&Q.position===A.Left,X=(W&&!v)||(!W&&v);Q.x=Q.x+(X?z:y);var Y={cx:Q.x,cy:Q.y,id:Q.id+"-circle","class":"sapSuiteUiCommonsNetworkNodeActionButton",r:g.ActionButtons.RADIUS},Z={"class":"sapSuiteUiCommonsNetworkGraphIcon sapSuiteUiCommonsNetworkNodeActionIcon "+(Q.class?Q.class:""),x:Q.x,y:Q.y},$,_,a1,b1,c1,d1;if(!Q.enable){Y.class="sapSuiteUiCommonsNetworkNodeActionButtonDisabledBackground";w.appendChild(this._createElement("circle",Y));Y.class="sapSuiteUiCommonsNetworkNodeActionButtonDisabled";Z.class+=" sapSuiteUiCommonsNetworkNodeActionButtonDisabled";}c1=this._createElement("g",{id:Q.id});$=this._createElement("circle",{id:Q.id+"-circle",cx:Q.x,cy:Q.y,r:g.ActionButtons.RADIUS-V,"class":"sapSuiteUiCommonsNetworkActionButtonFocusCircle"});a1=this._createElement("circle",Y);b1=this._createIcon(Z,Q.icon,U);if(Q.title){_=this._createElement("title");_.textContent=Q.title;a1.appendChild(_);}c1.appendChild(a1);c1.appendChild(b1);c1.appendChild($);w.appendChild(c1);d1=q(a1);if(Q.enable){d1.click(function(){this._setActionButtonFocus(c1,true);this._setFocus(false);if(this.getParent()){this.getParent().setFocus({item:this,button:c1});}}.bind(this));q(a1).click(Q.click);}W?u++:B++;return{icon:b1,wrapper:a1};}.bind(this);R=K();p=J();if(R===0){return;}if(e&&!this._bActionButtonsRendered){F=this.getY();if(this._isCircle()){y=this.getX()+(this._iWidth/2+this._iCircleSize/2);z=this.getX()+(this._iWidth/2-this._iCircleSize/2);}else{y=this.getX()+this._iWidth;z=this.getX();}var w=this.$("actionButtons")[0];if(!w){w=this._createElement("g",{"class":"sapSuiteUiCommonsNetworkNodeActionButtonWrapper",id:this._getDomId("actionButtons")});}else{q(w).children().remove();}if(this.getParent()._isUseNodeHtml()){this.getParent().$("actiionbuttons")[0].appendChild(w);}else{this.$()[0].appendChild(w);}if(this.getShowExpandButton()){x=O({x:p[B][0],y:F+p[B][1],icon:this._getExpandIcon(true),"class":"sapSuiteUiCommonsNetworkNodeActionCollapseIcon",enable:this._hasVisibleChildren(),title:r.getText("NETWORK_GRAPH_EXPAND_COLLAPSE"),id:this._getDomId("actionCollapse"),click:this._expandClick.bind(this)});this._expandIcon=x.icon;}if(this.getShowDetailButton()){G=O({x:p[B][0],y:F+p[B][1],icon:"sap-icon://menu",enable:this._hasDetailData()||this.getTitle(),id:this._getDomId("actionDetail"),title:r.getText("NETWORK_GRAPH_NODE_DETAILS"),click:function(){this._detailClick(G.wrapper);}.bind(this)});}if(this.getShowActionLinksButton()){L=O({x:p[B][0],y:F+p[B][1],icon:"sap-icon://chain-link",enable:this._hasActionLinks(),title:r.getText("NETWORK_GRAPH_NODE_LINKS"),id:this._getDomId("actionLinks"),click:function(){this._linksClick(L.wrapper);}.bind(this)});}for(var i=0;(B+u)<(f*2)&&i<this.getActionButtons().length;i++){(function(Q){var U=Q.getPosition(),V=U===A.Right?B:u;if(V>=f){U=U===A.Left?A.Right:A.Left;V=U===A.Right?B:u;}var W=O({x:p[V][0],y:F+p[V][1],icon:Q.getIcon(),title:Q.getTitle(),id:Q.getId(),click:function(X){Q.firePress({buttonElement:W.wrapper});},enable:Q.getEnabled(),position:U});})(this.getActionButtons()[i]);}this._bActionButtonsRendered=true;}else if(this._expandIcon){this._expandIcon.textContent=t._getExpandIcon();this.$().find("."+this.FOCUS_CLASS).removeClass(this.FOCUS_CLASS);}var P=e?"addClass":"removeClass";this.$("actionButtons")[P](this.VISIBLE_ACTIONS_BUTTONS_CLASS);};o.prototype.getChildNodes=function(){this._checkForProcessData();return this.aChildren;};o.prototype.getChildLines=function(){this._checkForProcessData();return this.aLines;};o.prototype.getParentNodes=function(){this._checkForProcessData();return this.aParents;};o.prototype.getParentLines=function(){this._checkForProcessData();return this.aParentLines;};o.prototype.isHidden=function(){return this._bIsHidden;};o.prototype.setHidden=function(v){var t=this;var p=function(L){L.forEach(function(e){var i=e.getFromNode()===t?e.getToNode():e.getFromNode();e.setHidden(v||i.isHidden());});};p(this.getChildLines());p(this.getParentLines());this.$()[v?"hide":"show"]();this._bIsHidden=v;if(this._oGroup){this._oGroup.setHidden(!this._oGroup._hasVisibleNodes());}};o.prototype.getCenterPosition=function(){var e,i;if(this._isBox()){return{x:this.getX()+this._iWidth/2,y:this.getY()+this._iHeight/2};}e=this._getCirclePosition();i=this._getCircleSize()/2;return{x:e.x+i,y:e.y+i};};o.prototype.setHeaderCheckBoxState=function(v){this._setHeaderCheckBoxState(v);return this;};o.prototype.setX=function(x){this.setProperty("x",x,true);return this;};o.prototype.setY=function(y){this.setProperty("y",y,true);return this;};o.prototype.setSelected=function(e){var p=this.getParent(),F=e?"addClass":"removeClass",K=this.getKey();this.setProperty("selected",e,true);if(p){this._setStatusColors(e?"Selected":"");this.$()[F](this.SELECT_CLASS);if(e){p._mSelectedNodes[K]=this;}else{delete p._mSelectedNodes[K];}}return this;};o.prototype.setCollapsed=function(e){var i={},p,P,F=e?"addClass":"removeClass",$=this.$().find(".sapSuiteUiCommonsNetworkGraphDivActionButtons, .sapSuiteUiCommonsNetworkNodeActionButtonWrapper").find(".sapSuiteUiCommonsNetworkNodeActionCollapseIcon");this.setProperty("collapsed",e,true);this._oExpandState=e?h.COLLAPSED:h.EXPANDED;this.aChildren.forEach(function(t){t._getAllChildren(e,this.getKey(),i);},this);p=Object.keys(i);p.forEach(function(K){i[K]._hideShow(e,this.getKey());},this);p.forEach(function(K){i[K]._processHideShowParents(e,this.getKey(),i);},this);this.aLines.forEach(function(L){L._hideShow(e);});if($[0]){$[0].textContent=this._getExpandIcon();}this.$().removeClass("sapSuiteUiCommonsNetworkNodePartialCollapsed");this.$()[F]("sapSuiteUiCommonsNetworkNodeCollapsed");P=this.getParent();if(P){P._setupKeyboardNavigation();if(e&&!(P.getFocus()&&P.getFocus().item===this)){P.setFocus({item:this});}}return this;};o.prototype.setGroup=function(G){this.setProperty("group",G,true);this._invalidateParent();return this;};o.prototype.setShape=function(e){this.setProperty("shape",e,true);this._invalidateParent();return this;};o.prototype.setWidth=function(w){this.setProperty("width",w,true);if(this.getParent()&&this.getParent()._bPreventInvalidation){this._iWidth=w;}else{this._iWidth=0;}this._invalidateParent();return this;};o.prototype.setHeight=function(i){this.setProperty("height",i,true);if(this.getParent()&&this.getParent()._bPreventInvalidation){this._iHeight=i;}else{this._iHeight=0;}this._invalidateParent();return this;};o.prototype.setMaxWidth=function(i){this.setProperty("maxWidth",i,true);this._invalidateParent();return this;};o.prototype.setTitleLineSize=function(t){this.setProperty("titleLineSize",t,true);this._invalidateParent();return this;};o.prototype.addAttribute=function(){E.prototype.addAttribute.apply(this,arguments);this._invalidateParent();return this;};o.prototype.insertAttribute=function(){E.prototype.insertAttribute.apply(this,arguments);this._invalidateParent();return this;};o.prototype.removeAllAttributes=function(){E.prototype.removeAllAttributes.apply(this,arguments);this._invalidateParent();return this;};o.prototype.removeAttribute=function(){E.prototype.removeAttribute.apply(this,arguments);this._invalidateParent();return this;};o.prototype.addAttribute=function(){E.prototype.addAttribute.apply(this,arguments);this._invalidateParent();return this;};o.prototype.insertAttribute=function(){E.prototype.insertAttribute.apply(this,arguments);this._invalidateParent();return this;};o.prototype.removeAllAttributes=function(){E.prototype.removeAllAttributes.apply(this,arguments);this._invalidateParent();};o.prototype.removeAttribute=function(){E.prototype.removeAttribute.apply(this,arguments);this._invalidateParent();};o.prototype.getHeaderCheckBoxState=function(){if(this.getProperty("headerCheckBoxState")===H.Hidden){return H.Hidden;}return this.getHeaderCheckbox().getSelected()?H.Checked:H.Unchecked;};o.prototype._processRenderManager=function(R,e){if(R&&e){R.write(e);}return"";};o.prototype._hasAdditionalContent=function(){return this._displayAttributes()||this._displayDescription()||this.getContent();};o.hasNativeLineClamp=typeof document.documentElement.style.webkitLineClamp!="undefined"&&D.browser.chrome;o.prototype._invalidateParent=function(){var p=this.getParent();if(p){p.invalidate();}};o.prototype._isIgnored=function(){var p=this.getParent(),e=p&&p._isSwimLane(),i=this._isInCollapsedGroup();if(e&&this._isHtml()){i=false;}return i||this._isInIgnoredGroup()||!this._useInLayout();};o.prototype._getImageSize=function(){var R=function(w,e){return{width:w?parseInt(w,10):0,height:e?parseInt(e,10):0};};var t=this._isBox()?"Box":"Circle",i=this.getImage();if(!this._displayImage(i)){return R();}return R(i.getWidth()?i.getWidth():g.Image[t],i.getHeight()?i.getHeight():g.Image[t]);};o.prototype._displayImage=function(i){i=i||this.getImage();return i&&i.getSrc();};o.prototype._isHtml=function(){return this.getParent()&&this.getParent()._isUseNodeHtml();};o.prototype._isInCollapsedGroup=function(){return this._oGroup&&this._oGroup._isCollapsed();};o.prototype._isInIgnoredGroup=function(){return this._oGroup&&this._oGroup._isIgnored();};o.prototype._displayAttributes=function(){return this.getVisibleAttributes().length!==0&&this._isBox();};o.prototype._displayDescription=function(){return this.getDescriptionLineSize()!==-1&&this.getDescription();};o.prototype._hasTitle=function(){return this.getTitle()||this.getIcon();};o.prototype._isBox=function(){return this.getShape()===S.Box&&this.getParent()._isLayered();};o.prototype._isCircle=function(){return this.getShape()===S.Circle;};o.prototype._isCustom=function(){return this.getShape()===S.Custom;};o.prototype._hasChildren=function(){return this.aChildren.length>0;};o.prototype._showHeaderCheckBox=function(){return this.getHeaderCheckBoxState()!==H.Hidden&&this._isBox();};o.prototype._hasVisibleChildren=function(){return this.aChildren.some(function(e){return!(e._oGroup&&!e._oGroup.getVisible())&&e.getVisible();});};o.prototype._hasDetailData=function(){return this.getDescription()||this.getAttributes().length>0;};o.prototype._hasActionLinks=function(){return this.getActionLinks().some(function(L){return L.getVisible();});};o.prototype._useAutomaticSize=function(){return!this.getWidth()&&this.getMaxWidth()>0;};o.prototype._getShapeSize=function(e){if(this._isCircle()){return this._getCircleSize();}var i=this._isCustom()?this.getCoreNodeSize():0;return i||(e?this._iWidth:this._iHeight);};o.prototype._getCircleSize=function(){return this._isBox()?undefined:this._iCircleSize;};o.prototype._hasMultiLineTitle=function(){return this._aTitleLines&&this._aTitleLines.length>1;};o.prototype._getCirclePosition=function(){return this._isBox()?undefined:{x:this.getX()+(this._iWidth-this._getCircleSize())/2,y:this.getY()};};o.prototype._isOnScreen=function(L,R,t,B){var x=this.getX(),y=this.getY();return E._isRectOnScreen(x,x+this._iWidth,y,y+this._iHeight,L,R,t,B);};o.prototype.getFocusDomRef=function(){return this.getDomRef("wrapper");};o.prototype.setVisible=function(v){this.setProperty("visible",v);var p=this.getParent();if(p&&p._bIsLayedOut){this.getParentNodes().forEach(function(e){e._bActionButtonsRendered=false;});}return this;};o.prototype.setStatusIcon=function(i){var e=this.$("statusicon")[0],p=I.getIconInfo(i),t=p&&p.content;this.$("statusiconwrapper")[i?"addClass":"removeClass"]("sapSuiteUiCommonsNetworkNodeInfoWrapperCustomIcon");e&&(e.textContent=t);this.setProperty("statusIcon",i,true);return this;};return o;});
