/*!
 * 
		SAP UI development toolkit for HTML5 (SAPUI5)
		(c) Copyright 2009-2015 SAP SE. All rights reserved
	
 */
sap.ui.define(["sap/ui/core/Control","sap/ui/core/Core","sap/ui/core/Configuration","sap/suite/ui/commons/statusindicator/util/ProgressHandler","sap/base/Log"],function(C,a,b,P,L){"use strict";var S=C.extend("sap.suite.ui.commons.statusindicator.ShapeGroup",{metadata:{library:"sap.suite.ui.commons",properties:{weight:{type:"int",defaultValue:10}},defaultAggregation:"shapes",aggregations:{shapes:{type:"sap.suite.ui.commons.statusindicator.Shape",multiple:true}}}});S.prototype.init=function(){this._iTargetValue=0;this._oAnimationPropertiesResolver=null;this._iLastDirectValueUpdate=0;};S.prototype.discreteThresholdsChangeHandler=function(c){var n=this._oAnimationPropertiesResolver._getGroupValue(this,c);if(n!==this._iLastDirectValueUpdate){this.getShapes().forEach(function(s){s._updateDom(n,true);});this._iLastDirectValueUpdate=n;}};S.prototype.propertyThresholdsChangeHandler=function(n){this.getShapes().forEach(function(s){if(s.getDisplayedValue()!==0){s.getRenderer()._updateDomColor(s,n);}});};S.prototype._injectAnimationPropertiesResolver=function(A){this._oAnimationPropertiesResolver=A;this._oAnimationPropertiesResolver.addDiscreteThresholdChange(this.discreteThresholdsChangeHandler.bind(this));this._oAnimationPropertiesResolver.addPropertyThresholdChange(this.propertyThresholdsChangeHandler.bind(this));this.getShapes().forEach(function(s){s._injectAnimationPropertiesResolver(A);});};S.prototype.addShape=function(s){this.addAggregation("shapes",s,true);s._injectAnimationPropertiesResolver(this._oAnimationPropertiesResolver);return this;};S.prototype._setValue=function(v,n){var t=this;n=n||false;this._iTargetValue=v;if(!this._isAnimationAllowed()||n){this.getShapes().forEach(function(s){s._updateDom(t._iTargetValue);});return Promise.resolve();}this.getShapes().forEach(function(s){if(!s.getAnimationOnChange()){s._updateDom(t._iTargetValue);}});if(this.oCurrentProgressHandler&&this.oCurrentProgressHandler.isInProgress()){this.oCurrentProgressHandler.cancel();}this.oCurrentProgressHandler=new P(function(p){var N=performance.now();t._animationStep(N,p,N);});return this.oCurrentProgressHandler.start();};S.prototype._animationStep=function(l,p,c){L.debug("AnimationStep at time: "+c.toString(10),null,this);c=Math.max(c,l);if(p.isCanceled()){p.stop({cancelled:true});return;}var A=true;var t=this._iTargetValue;this.getShapes().forEach(function(s){var d=s.getDisplayedValue();if(d===t){return;}var T=l+s.getFullAnimationDuration()*Math.abs(t-d)/100;var v=t;if(c<T){var D=t-d;var i=T-l;var e=(c-l)/i;v=D*e+d;A=false;}s._updateDom(v);});if(A){p.finish();}else{window.requestAnimationFrame(this._animationStep.bind(this,c,p));}};S.prototype._showsFullProgress=function(){return!this.getShapes().some(function(s){return s.getDisplayedValue()!==100;});};S.prototype._setInitialValue=function(i){this._iTargetValue=i;this._iLastDirectValueUpdate=i;this.getShapes().forEach(function(s){s._setInitialValue(i);});};S.prototype._isAnimationAllowed=function(){var A=a.getConfiguration();var s=A.getAnimationMode();return s!==b.AnimationMode.none;};return S;});
