/*!
 * SAPUI5

(c) Copyright 2009-2019 SAP SE. All rights reserved
 */
sap.ui.define(["sap/ui/thirdparty/jquery","./library","sap/ui/core/Control","sap/ui/Device","sap/m/FlexBox","sap/suite/ui/microchart/MicroChartUtils","sap/base/Log","sap/ui/events/KeyCodes","sap/ui/core/theming/Parameters","sap/m/library","sap/ui/core/ResizeHandler","./AreaMicroChartRenderer"],function(q,l,C,D,F,M,L,K,P,b,R){"use strict";var V=b.ValueColor;var S=b.Size;var A=l.AreaMicroChartViewType;var c=C.extend("sap.suite.ui.microchart.AreaMicroChart",{metadata:{library:"sap.suite.ui.microchart",properties:{size:{type:"sap.m.Size",group:"Misc",defaultValue:"Auto"},width:{type:"sap.ui.core.CSSSize",group:"Misc"},height:{type:"sap.ui.core.CSSSize",group:"Misc"},maxXValue:{type:"float",group:"Misc",defaultValue:null},minXValue:{type:"float",group:"Misc",defaultValue:null},maxYValue:{type:"float",group:"Misc",defaultValue:null},minYValue:{type:"float",group:"Misc",defaultValue:null},view:{type:"sap.suite.ui.microchart.AreaMicroChartViewType",group:"Appearance",defaultValue:"Normal"},colorPalette:{type:"string[]",group:"Appearance",defaultValue:[]},showLabel:{type:"boolean",group:"Misc",defaultValue:true},isResponsive:{type:"boolean",group:"Appearance",defaultValue:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{}},defaultAggregation:"lines",aggregations:{chart:{multiple:false,type:"sap.suite.ui.microchart.AreaMicroChartItem",bindable:"bindable"},maxThreshold:{multiple:false,type:"sap.suite.ui.microchart.AreaMicroChartItem"},innerMaxThreshold:{multiple:false,type:"sap.suite.ui.microchart.AreaMicroChartItem"},innerMinThreshold:{multiple:false,type:"sap.suite.ui.microchart.AreaMicroChartItem"},minThreshold:{multiple:false,type:"sap.suite.ui.microchart.AreaMicroChartItem"},target:{multiple:false,type:"sap.suite.ui.microchart.AreaMicroChartItem",bindable:"bindable"},firstXLabel:{multiple:false,type:"sap.suite.ui.microchart.AreaMicroChartLabel"},firstYLabel:{multiple:false,type:"sap.suite.ui.microchart.AreaMicroChartLabel"},lastXLabel:{multiple:false,type:"sap.suite.ui.microchart.AreaMicroChartLabel"},lastYLabel:{multiple:false,type:"sap.suite.ui.microchart.AreaMicroChartLabel"},maxLabel:{multiple:false,type:"sap.suite.ui.microchart.AreaMicroChartLabel"},minLabel:{multiple:false,type:"sap.suite.ui.microchart.AreaMicroChartLabel"},lines:{multiple:true,type:"sap.suite.ui.microchart.AreaMicroChartItem",bindable:"bindable"}}}});c.THRESHOLD_LOOK_XS=1.125;c.THRESHOLD_LOOK_S=3.5;c.THRESHOLD_LOOK_M=4.5;c.THRESHOLD_LOOK_L=5.875;c.THRESHOLD_WIDTH_NO_LABEL=6;c.THRESHOLD_WIDE_HEIGHT_NO_LABEL=2.25;c.ITEM_NEUTRAL_COLOR="sapSuiteAMCSemanticColorNeutral";c.ITEM_NEUTRAL_NOTHRESHOLD_CSSCLASS="sapSuiteAMCNeutralNoThreshold";c._CHARTITEM_AGGREGATIONS=["chart","target","minThreshold","maxThreshold","innerMinThreshold","innerMaxThreshold"];c.prototype.init=function(){this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.suite.ui.microchart");this.setAggregation("tooltip","((AltText))",true);this._bThemeApplied=true;if(!sap.ui.getCore().isInitialized()){this._bThemeApplied=false;sap.ui.getCore().attachInit(this._handleCoreInitialized.bind(this));}else{this._handleCoreInitialized();}};c.prototype._handleCoreInitialized=function(){this._bThemeApplied=sap.ui.getCore().isThemeApplied();sap.ui.getCore().attachThemeChanged(this._handleThemeApplied,this);sap.ui.getCore().attachLocalizationChanged(this._handleThemeApplied,this);};c.prototype._handleThemeApplied=function(){this._bThemeApplied=true;this.invalidate();};c.prototype._getCssValues=function(){this._$CssHelper.className=Array.prototype.slice.call(arguments).join(" ");var s=window.getComputedStyle(this._$CssHelper);if(!s.backgroundColor){s.backgroundColor=s["background-color"];}if(!s.outlineStyle){s.outlineStyle=s["outline-style"];}if(!s.outlineWidth){s.outlineWidth=s["outline-width"];}return s;};c.prototype.__fillThresholdArea=function(a,p,d,e){a.beginPath();a.moveTo(p[0].x,p[0].y);for(var i=1,f=p.length;i<f;i++){a.lineTo(p[i].x,p[i].y);}for(var j=d.length-1;j>=0;j--){a.lineTo(d[j].x,d[j].y);}a.closePath();a.fillStyle="white";a.fill();a.fillStyle=e;a.fill();a.lineWidth=1;a.strokeStyle="white";a.stroke();a.strokeStyle=e;a.stroke();};c.prototype._renderDashedLine=function(a,p,d){if(a.setLineDash){a.setLineDash(d);this._renderLine(a,p);a.setLineDash([]);}else{a.beginPath();for(var i=0,e=p.length-1;i<e;i++){a._dashedLine(p[i].x,p[i].y,p[i+1].x,p[i+1].y,d);}a.stroke();}};c.prototype._renderLine=function(a,p){a.beginPath();a.moveTo(p[0].x,p[0].y);for(var i=1,d=p.length;i<d;i++){a.lineTo(p[i].x,p[i].y);}a.stroke();};c.prototype._getItemColor=function(a,t){var i;if(t&&this.getTarget()){i="sapSuiteAMCSemanticColor"+this.getTarget().getColor();}else if(!t&&this.getChart()){i="sapSuiteAMCSemanticColor"+this.getChart().getColor();}if((i===c.ITEM_NEUTRAL_COLOR)&&!this._isThresholdPresent(a)){return c.ITEM_NEUTRAL_NOTHRESHOLD_CSSCLASS;}else{return i;}};c.prototype._isThresholdPresent=function(a){var t=[a.minThreshold.length,a.maxThreshold.length,a.innerMinThreshold.length,a.innerMaxThreshold.length];for(var i=0;i<t.length;i++){if(t[i]>1){return true;}}return false;};c.prototype._renderTarget=function(a,d){if(d.target.length>1){var s=this._getItemColor(d,true);var o=this._getCssValues("sapSuiteAMCTarget",s);a.strokeStyle=o.color;a.lineWidth=parseFloat(o.width);if(o.outlineStyle=="dotted"){this._renderDashedLine(a,d.target,[parseFloat(o.outlineWidth),3]);}else{this._renderLine(a,d.target,d);}}else if(d.target.length==1){L.warning("Target is not rendered because only 1 point was given");}};c.prototype._renderThresholdLine=function(a,p){if(p&&p.length){var s=this._getCssValues("sapSuiteAMCThreshold");a.strokeStyle=s.color;a.lineWidth=s.width;this._renderLine(a,p);}};c.prototype._fillMaxThreshold=function(a,d){if(d.maxThreshold.length>1){var s=this._getCssValues("sapSuiteAMCThreshold","sapSuiteAMCSemanticColor"+this.getMaxThreshold().getColor());this.__fillThresholdArea(a,d.maxThreshold,[{x:d.maxThreshold[0].x,y:d.minY},{x:d.maxThreshold[d.maxThreshold.length-1].x,y:d.minY}],s.backgroundColor);this._renderThresholdLine(a,d.maxThreshold,d);}else if(d.maxThreshold.length==1){L.warning("Max Threshold is not rendered because only 1 point was given");}};c.prototype._fillMinThreshold=function(a,d){if(d.minThreshold.length>1){var s=this._getCssValues("sapSuiteAMCThreshold","sapSuiteAMCSemanticColor"+this.getMinThreshold().getColor());this.__fillThresholdArea(a,d.minThreshold,[{x:d.minThreshold[0].x,y:d.maxY},{x:d.minThreshold[d.minThreshold.length-1].x,y:d.maxY}],s.backgroundColor);}else if(d.minThreshold.length==1){L.warning("Min Threshold is not rendered because only 1 point was given");}};c.prototype._fillThresholdArea=function(a,d){if(d.minThreshold.length>1&&d.maxThreshold.length>1){var s=this._getCssValues("sapSuiteAMCThreshold","sapSuiteAMCSemanticColorCritical");this.__fillThresholdArea(a,d.maxThreshold,d.minThreshold,s.backgroundColor);}};c.prototype._fillInnerThresholdArea=function(a,d){if(d.innerMinThreshold.length>1&&d.innerMaxThreshold.length>1){var s=this._getCssValues("sapSuiteAMCThreshold","sapSuiteAMCSemanticColor"+this.getInnerMaxThreshold().getColor());this.__fillThresholdArea(a,d.innerMaxThreshold,d.innerMinThreshold,s.backgroundColor);}else if(d.innerMinThreshold.length||d.innerMaxThreshold.length){L.warning("Inner threshold area is not rendered because inner min and max threshold were not correctly set");}};c.prototype._renderChart=function(a,d){if(d.chart.length>1){var s=this._getItemColor(d);var o=this._getCssValues("sapSuiteAMCChart",s);a.strokeStyle=o.color;a.lineWidth=parseFloat(o.width);this._renderLine(a,d.chart,d);}else if(d.chart.length==1){L.warning("Actual values are not rendered because only 1 point was given");}};c.prototype._renderLines=function(a,d){var e=this.getColorPalette().length,f=0,s=this._getCssValues("sapSuiteAMCLine"),g=d.lines.length;var n=function(h){if(e){if(f===e){f=0;}h=this.getColorPalette()[f++].trim();}if(V[h]){s=this._getCssValues("sapSuiteAMCLine","sapSuiteAMCSemanticColor"+h);return s.color;}return P.get(h)||h;}.bind(this);a.lineWidth=parseFloat(s.width);for(var i=0;i<g;i++){if(d.lines[i].length>1){a.strokeStyle=n(this.getLines()[i].getColor());this._renderLine(a,d.lines[i],d);}}};c.prototype._renderCanvas=function(){if(!this._hasData()){return;}this._$CssHelper=this.getDomRef("css-helper");var $=this.$();var o=this.getDomRef("canvas");var a=window.getComputedStyle(o);var w=parseFloat(a.width);o.setAttribute("width",w||360);var h=parseFloat(a.height);o.setAttribute("height",h||242);var r=o.getContext("2d");r.lineJoin="round";r._dashedLine=this._drawDashedLine;var d=this._calculateDimensions(o.width,o.height);if(this._isThresholdPresent(d)){$.find(".sapSuiteAMCCanvasContainer").addClass("sapSuiteAMCWithThreshold");}this._fillMaxThreshold(r,d);this._fillMinThreshold(r,d);this._fillThresholdArea(r,d);this._renderThresholdLine(r,d.minThreshold,d);this._renderThresholdLine(r,d.maxThreshold,d);this._fillInnerThresholdArea(r,d);this._renderThresholdLine(r,d.innerMinThreshold,d);this._renderThresholdLine(r,d.innerMaxThreshold,d);this._renderTarget(r,d);this._renderChart(r,d);this._renderLines(r,d);};c.prototype._drawDashedLine=function(x,y,a,d,e){var f=e.length;this.moveTo(x,y);var g=(a-x),h=(d-y),s=g?h/g:1e15,r=Math.sqrt(g*g+h*h),i=0,j=true;while(r>=0.1){var k=e[i++%f];if(k>r){k=r;}var m=Math.sqrt(k*k/(1+s*s));if(g<0){m=-m;}x+=m;y+=s*m;this[j?"lineTo":"moveTo"](x,y);r-=k;j=!j;}};c.prototype._calculateDimensions=function(w,h){var m,f,d,e;function g(){if(!this._isMinXValue||!this._isMaxXValue||!this._isMinYValue||!this._isMaxYValue){var u=this.getLines();if(this.getMaxThreshold()){u.push(this.getMaxThreshold());}if(this.getMinThreshold()){u.push(this.getMinThreshold());}if(this.getChart()){u.push(this.getChart());}if(this.getTarget()){u.push(this.getTarget());}if(this.getInnerMaxThreshold()){u.push(this.getInnerMaxThreshold());}if(this.getInnerMinThreshold()){u.push(this.getInnerMinThreshold());}for(var i=0,v=u.length;i<v;i++){var x=u[i].getPoints();for(var k=0,a=x.length;k<a;k++){var y=x[k].getXValue();if(y>m||m===undefined){m=y;}if(y<d||d===undefined){d=y;}var z=x[k].getYValue();if(z>f||f===undefined){f=z;}if(z<e||e===undefined){e=z;}}}}if(this._isMinXValue){d=this.getMinXValue();}if(this._isMaxXValue){m=this.getMaxXValue();}if(this._isMinYValue){e=this.getMinYValue();}if(this._isMaxYValue){f=this.getMaxYValue();}}g.call(this);var r={minY:0,minX:0,maxY:h,maxX:w,lines:[]};var j;var n=m-d;if(n>0){j=w/n;}else if(n==0){j=0;r.maxX/=2;}else{L.warning("Min X is greater than max X.");}var o;var p=f-e;if(p>0){o=h/(f-e);}else if(p==0){o=0;r.maxY/=2;}else{L.warning("Min Y is greater than max Y.");}function s(a){var k=sap.ui.getCore().getConfiguration().getRTL();var u=function(N){var x=j*(N-d);if(k){x=r.maxX-x;}return x;};var v=function(x){return r.maxY-o*(x-e);};var y=[];if(a&&j!==undefined&&o!==undefined){var z=a.getPoints();var t=z.length;var B,E,G,H;if(t==1){G=z[0].getXValue();H=z[0].getYValue();if(G==undefined^H==undefined){var I,J;if(G==undefined){J=E=v(H);B=r.minX;I=r.maxX;}else{I=B=u(G);E=r.minY;J=r.maxY;}y.push({x:B,y:E},{x:I,y:J});}else{L.warning("Point with coordinates ["+G+" "+H+"] ignored");}}else{for(var i=0;i<t;i++){G=z[i].getXValue();H=z[i].getYValue();if(G!=undefined&&H!=undefined){B=u(G);E=v(H);y.push({x:B,y:E});}else{L.warning("Point with coordinates ["+G+" "+H+"] ignored");}}}}return y;}r.maxThreshold=s(this.getMaxThreshold());r.minThreshold=s(this.getMinThreshold());r.chart=s(this.getChart());r.target=s(this.getTarget());r.innerMaxThreshold=s(this.getInnerMaxThreshold());r.innerMinThreshold=s(this.getInnerMinThreshold());var t=this.getLines().length;for(var i=0;i<t;i++){r.lines.push(s(this.getLines()[i]));}return r;};c.prototype.setMinXValue=function(v,s){this._isMinXValue=this._isNumber(v);return this.setProperty("minXValue",this._isMinXValue?v:NaN,s);};c.prototype.setMaxXValue=function(v,s){this._isMaxXValue=this._isNumber(v);return this.setProperty("maxXValue",this._isMaxXValue?v:NaN,s);};c.prototype.setMinYValue=function(v,s){this._isMinYValue=this._isNumber(v);return this.setProperty("minYValue",this._isMinYValue?v:NaN,s);};c.prototype.setMaxYValue=function(v,s){this._isMaxYValue=this._isNumber(v);return this.setProperty("maxYValue",this._isMaxYValue?v:NaN,s);};c.prototype._isNumber=function(n){return typeof n==="number"&&!isNaN(n)&&isFinite(n);};c.prototype.onBeforeRendering=function(){if(this._bUseIndex){this._indexChartItems();}if(this._sChartResizeHandlerId){R.deregister(this._sChartResizeHandlerId);}this._unbindMouseEnterLeaveHandler();};c.prototype.onAfterRendering=function(){l._checkControlIsVisible(this,this._onControlIsVisible);this._bindMouseEnterLeaveHandler();};c.prototype.setSize=function(s){if(this.getSize()!==s){if(s===S.Responsive){this.setProperty("isResponsive",true);}else{this.setProperty("isResponsive",false);}this.setProperty("size",s);}return this;};c.prototype.setIsResponsive=function(i){var s,a=this.getSize();this.setProperty("isResponsive",i);if(i){s=S.Responsive;}else{s=a===S.Responsive?S.Auto:a;}this.setProperty("size",s);return this;};c.prototype._onControlIsVisible=function(){this._onResize();this._sChartResizeHandlerId=R.register(this,this._onResize.bind(this));};c.prototype._indexChartItems=function(){var o,n=c._CHARTITEM_AGGREGATIONS.length;for(var i=0;i<n;i++){o=this.getAggregation(c._CHARTITEM_AGGREGATIONS[i]);if(o){this._indexChartItemPoints(o);}}};c.prototype._indexChartItemPoints=function(a){var p=a.getPoints();for(var i=0;i<p.length;i++){p[i].setProperty("x",i,true);}};c.prototype.enableXIndexing=function(u){this._bUseIndex=u;};c.prototype._onResize=function(){var $=this.$(),i=parseInt($.width()),a=parseInt($.height()),m=$.find(".sapSuiteAMCPositionCenter"),t=$.find(".sapSuiteAMCPositionTop .sapSuiteAMCPositionLeft, .sapSuiteAMCPositionTop .sapSuiteAMCPositionRight,"+".sapSuiteAMCSideLabels .sapSuiteAMCLbl:first-child");$.removeClass("sapSuiteAMCNoLabels sapSuiteAMCLookM sapSuiteAMCLookS sapSuiteAMCLookXS sapSuiteAMCNoMinMaxLabels sapSuiteAMCNoTopLabels");if(i<=this.convertRemToPixels(c.THRESHOLD_WIDTH_NO_LABEL)){$.addClass("sapSuiteAMCNoLabels");}if(a<this.convertRemToPixels(c.THRESHOLD_WIDE_HEIGHT_NO_LABEL)){$.addClass("sapSuiteAMCLookXS");}else if(a<this.convertRemToPixels(c.THRESHOLD_LOOK_S)&&this.getView()===A.Normal){$.addClass("sapSuiteAMCLookXS");}else if(a<this.convertRemToPixels(c.THRESHOLD_LOOK_M)){$.addClass("sapSuiteAMCLookS");}else if(a<this.convertRemToPixels(c.THRESHOLD_LOOK_L)){$.addClass("sapSuiteAMCLookM");}if(this._isAnyLabelTruncated(t)||this._isAnyLabelVerticallyTruncated(t)){$.addClass("sapSuiteAMCNoMinMaxLabels");if(this._isAnyLabelTruncated(t)){$.removeClass("sapSuiteAMCNoMinMaxLabels");$.addClass("sapSuiteAMCNoTopLabels");}}if(this._isAnyLabelTruncated(m)){$.addClass("sapSuiteAMCNoMinMaxLabels");}this._renderCanvas();};c.prototype._isLabelTruncated=function(a){var s;if(D.browser.msie||D.browser.edge){s=1;}else{s=0;}return a.offsetWidth<a.scrollWidth-s;};c.prototype.ontap=function(e){if(D.browser.msie){this.$().focus();}this.firePress();};c.prototype.onkeydown=function(e){if(e.which==K.SPACE){e.preventDefault();}};c.prototype.onkeyup=function(e){if(e.which==K.ENTER||e.which==K.SPACE){this.firePress();e.preventDefault();}};c.prototype.attachEvent=function(){C.prototype.attachEvent.apply(this,arguments);if(this.hasListeners("press")){this.$().attr("tabindex",0).addClass("sapSuiteUiMicroChartPointer");}return this;};c.prototype.detachEvent=function(){C.prototype.detachEvent.apply(this,arguments);if(!this.hasListeners("press")){this.$().removeAttr("tabindex").removeClass("sapSuiteUiMicroChartPointer");}return this;};c.prototype._getLocalizedColorMeaning=function(a){return V[a]?this._oRb.getText(("SEMANTIC_COLOR_"+a).toUpperCase()):"";};c.prototype._getAltHeaderText=function(I){var a=this._oRb.getText("AREAMICROCHART");if(I){a+=" "+this._oRb.getText("IS_ACTIVE");}if(!this._hasData()){a+="\n"+this._oRb.getText("NO_DATA");return a;}var f=this.getFirstXLabel();var o=this.getFirstYLabel();var d=this.getLastXLabel();var e=this.getLastYLabel();var m=this.getMinLabel();var g=this.getMaxLabel();var h=this.getChart();var t=this.getTarget();if(f&&f.getLabel()||o&&o.getLabel()){a+="\n"+this._oRb.getText(("AREAMICROCHART_START"))+": "+(f?f.getLabel():"")+" "+(o?o.getLabel()+" "+this._getLocalizedColorMeaning(o.getColor()):"");}if(d&&d.getLabel()||e&&e.getLabel()){a+="\n"+this._oRb.getText(("AREAMICROCHART_END"))+": "+(d?d.getLabel():"")+" "+(e?e.getLabel()+" "+this._getLocalizedColorMeaning(e.getColor()):"");}if(m&&m.getLabel()){a+="\n"+this._oRb.getText(("AREAMICROCHART_MINIMAL_VALUE"))+": "+m.getLabel()+" "+this._getLocalizedColorMeaning(m.getColor());}if(g&&g.getLabel()){a+="\n"+this._oRb.getText(("AREAMICROCHART_MAXIMAL_VALUE"))+": "+g.getLabel()+" "+this._getLocalizedColorMeaning(g.getColor());}if(h&&h.getPoints()&&h.getPoints().length>0){a+="\n"+this._oRb.getText(("AREAMICROCHART_ACTUAL_VALUES"))+":";var k=h.getPoints();for(var i=0;i<k.length;i++){a+=" "+k[i].getY();}}if(t&&t.getPoints()&&t.getPoints().length>0){a+="\n"+this._oRb.getText(("AREAMICROCHART_TARGET_VALUES"))+":";var T=t.getPoints();for(var j=0;j<T.length;j++){a+=" "+T[j].getY();}}return a;};c.prototype._getAltSubText=function(i){var a="";for(var k=0;k<this.getLines().length;k++){var o=this.getLines()[k],s=o.getTooltip_AsString(),d="",t="";if(!s){continue;}if(o.getPoints()&&o.getPoints().length>0){t+=(i?"":"\n")+(o.getTitle()?o.getTitle():this._oRb.getText("AREAMICROCHART_LINE",[k+1]))+":";var e=o.getPoints();for(var y=0;y<e.length;y++){d+=" "+e[y].getY();}if(this.getColorPalette().length===0){d+=" "+this._getLocalizedColorMeaning(o.getColor());}}d=s.split("((AltText))").join(d);if(d){a+=t+d;i=false;}}return a;};c.prototype._getAccessibilityControlType=function(){return this._oRb.getText("ACC_CTR_TYPE_AREAMICROCHART");};c.prototype.clone=function(){var o=C.prototype.clone.apply(this,arguments);o._isMinXValue=this._isMinXValue;o._isMaxXValue=this._isMaxXValue;o._isMinYValue=this._isMinYValue;o._isMaxYValue=this._isMaxYValue;return o;};c.prototype.exit=function(){R.deregister(this._sChartResizeHandlerId);sap.ui.getCore().detachThemeChanged(this._handleThemeApplied,this);sap.ui.getCore().detachLocalizationChanged(this._handleThemeApplied,this);};c.prototype._addTitleAttribute=function(){if(!this.$().attr("title")&&this._hasData()){this.$().attr("title",this.getTooltip_AsString());}};c.prototype._removeTitleAttribute=function(){if(this.$().attr("title")){this.$().removeAttr("title");}};c.prototype._bindMouseEnterLeaveHandler=function(){if(!this._oMouseEnterLeaveHandler){this._oMouseEnterLeaveHandler={mouseEnterChart:this._addTitleAttribute.bind(this),mouseLeaveChart:this._removeTitleAttribute.bind(this)};}this.$().bind("mouseenter",this._oMouseEnterLeaveHandler.mouseEnterChart);this.$().bind("mouseleave",this._oMouseEnterLeaveHandler.mouseLeaveChart);};c.prototype._unbindMouseEnterLeaveHandler=function(){if(this._oMouseEnterLeaveHandler){this.$().unbind("mouseenter",this._oMouseEnterLeaveHandler.mouseEnterChart);this.$().unbind("mouseleave",this._oMouseEnterLeaveHandler.mouseLeaveChart);}};c.prototype._hasData=function(){return this.getLines().length>0||this.getChart();};c.prototype.firePress=function(){if(this._hasData()){C.prototype.fireEvent.call(this,"press",arguments);}};M.extendMicroChart(c);return c;});
