/*!
 * SAPUI5

(c) Copyright 2009-2019 SAP SE. All rights reserved
 */
sap.ui.define(["sap/ui/thirdparty/jquery","./library","sap/m/library","sap/ui/core/Control","sap/m/FlexBox","sap/ui/Device","sap/ui/core/ResizeHandler","sap/ui/events/KeyCodes","sap/m/Size","sap/suite/ui/microchart/MicroChartUtils","./BulletMicroChartRenderer"],function(q,l,M,C,F,D,R,K,S,a){"use strict";var B=C.extend("sap.suite.ui.microchart.BulletMicroChart",{metadata:{library:"sap.suite.ui.microchart",properties:{size:{type:"sap.m.Size",group:"Misc",defaultValue:"Auto"},mode:{type:"sap.suite.ui.microchart.BulletMicroChartModeType",group:"Misc",defaultValue:"Actual"},scale:{type:"string",group:"Misc",defaultValue:""},forecastValue:{type:"float",group:"Misc",defaultValue:null},targetValue:{type:"float",group:"Misc",defaultValue:null},minValue:{type:"float",group:"Misc",defaultValue:null},maxValue:{type:"float",group:"Misc",defaultValue:null},showActualValue:{type:"boolean",group:"Misc",defaultValue:true},showDeltaValue:{type:"boolean",group:"Misc",defaultValue:true},showActualValueInDeltaMode:{type:"boolean",group:"Misc",defaultValue:false},showTargetValue:{type:"boolean",group:"Misc",defaultValue:true},showValueMarker:{type:"boolean",group:"Misc",defaultValue:false},showThresholds:{type:"boolean",group:"Misc",defaultValue:true},actualValueLabel:{type:"string",group:"Misc",defaultValue:""},deltaValueLabel:{type:"string",group:"Misc",defaultValue:""},targetValueLabel:{type:"string",group:"Misc",defaultValue:""},width:{type:"sap.ui.core.CSSSize",group:"Misc"},height:{type:"sap.ui.core.CSSSize",group:"Misc"},scaleColor:{type:"sap.suite.ui.microchart.CommonBackgroundType",group:"Misc",defaultValue:"MediumLight"},isResponsive:{type:"boolean",group:"Appearance",defaultValue:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},defaultAggregation:"actual",aggregations:{actual:{type:"sap.suite.ui.microchart.BulletMicroChartData",multiple:false,bindable:"bindable"},thresholds:{type:"sap.suite.ui.microchart.BulletMicroChartData",multiple:true,singularName:"threshold",bindable:"bindable"}},events:{press:{}}}});B.THRESHOLD_SMALL_LABEL=3.5;B.THRESHOLD_BIG_LABEL=4.5;B.THRESHOLD_SMALL_LOOK=3.5;B.THRESHOLD_EXTRASMALL_LOOK=1.3125;B.THRESHOLD_THRESHOLDS=6;B.prototype.init=function(){this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.suite.ui.microchart");this.setAggregation("tooltip","((AltText))",true);this._bThemeApplied=true;if(!sap.ui.getCore().isInitialized()){this._bThemeApplied=false;sap.ui.getCore().attachInit(this._handleCoreInitialized.bind(this));}else{this._handleCoreInitialized();}};B.prototype._handleCoreInitialized=function(){this._bThemeApplied=sap.ui.getCore().isThemeApplied();if(!this._bThemeApplied){sap.ui.getCore().attachThemeChanged(this._handleThemeApplied,this);}};B.prototype._handleThemeApplied=function(){this._bThemeApplied=true;this.invalidate();sap.ui.getCore().detachThemeChanged(this._handleThemeApplied,this);};B.prototype._calculateChartData=function(){var s=98,t=this.getThresholds(),c=[],T=this.getTargetValue(),f=this.getForecastValue(),A=this.getActual()&&this.getActual().getValue()?this.getActual().getValue():0,v=[],L=0,h=0,b=0,i;if(this.getActual()&&this.getActual()._isValueSet){v.push(A);}if(this._isForecastValueSet){v.push(f);}if(this._isTargetValueSet){v.push(T);}if(this._isMinValueSet){v.push(this.getMinValue());}if(this._isMaxValueSet){v.push(this.getMaxValue());}for(i=0;i<t.length;i++){v.push(t[i].getValue());}if(v.length>0){L=h=v[0];for(i=0;i<v.length;i++){if(v[i]<L){L=v[i];}if(v[i]>h){h=v[i];}}h=(h<0&&h<3*(L-h))?0:h;L=(L>0&&L>3*(h-L))?0:L;b=h-L;for(i=0;i<t.length;i++){c[i]={color:t[i].getColor(),valuePct:(!t[i]._isValueSet||b===0)?0:((t[i].getValue()-L)*s/b).toFixed(2)};}}var n,d;if(this.getMode()===l.BulletMicroChartModeType.Delta){n=(!this.getActual()||!this.getActual()._isValueSet||b===0)?49:(0.05+(A-L)*s/b).toFixed(2);d=(!this._isTargetValueSet||b===0)?49:((T-L)*s/b).toFixed(2);}else{n=(!this.getActual()||!this.getActual()._isValueSet||b===0||L===0&&this.getActual().getValue()===0)?0:(0.05+(A-L)*s/b).toFixed(2);d=(!this._isTargetValueSet||b===0)?0:((T-L)*s/b).toFixed(2);}return{actualValuePct:n,targetValuePct:d,forecastValuePct:(!this._isForecastValueSet||b===0)?0:((f-L)*s/b).toFixed(2),thresholdsPct:c,fScaleWidthPct:s};};B.prototype._calculateDeltaValue=function(){if(!this.getActual()._isValueSet||!this._isTargetValueSet){return 0;}else{var A=this.getActual().getValue();var t=this.getTargetValue();return Math.abs(A-t).toFixed(Math.max(this._digitsAfterDecimalPoint(A),this._digitsAfterDecimalPoint(t)));}};B.prototype.setMinValue=function(m){this._isMinValueSet=this._fnIsNumber(m);return this.setProperty("minValue",this._isMinValueSet?m:NaN);};B.prototype.setMaxValue=function(m){this._isMaxValueSet=this._fnIsNumber(m);return this.setProperty("maxValue",this._isMaxValueSet?m:NaN);};B.prototype.setTargetValue=function(t){this._isTargetValueSet=this._fnIsNumber(t);return this.setProperty("targetValue",this._isTargetValueSet?t:NaN);};B.prototype.setForecastValue=function(f){this._isForecastValueSet=this._fnIsNumber(f);return this.setProperty("forecastValue",this._isForecastValueSet?f:NaN);};B.prototype.setSize=function(s){if(this.getSize()!==s){if(s===S.Responsive){this.setProperty("isResponsive",true);}else{this.setProperty("isResponsive",false);}this.setProperty("size",s,false);}return this;};B.prototype.setIsResponsive=function(i){var s,c=this.getSize();this.setProperty("isResponsive",i);if(i){s=S.Responsive;}else{s=c===S.Responsive?S.Auto:c;}this.setProperty("size",s);return this;};B.prototype.ontap=function(e){if(D.browser.msie){this.$().focus();}this.firePress();};B.prototype.onkeydown=function(e){if(e.which===K.SPACE){e.preventDefault();}};B.prototype.onkeyup=function(e){if(e.which===K.ENTER||e.which===K.SPACE){this.firePress();e.preventDefault();}};B.prototype._fnIsNumber=function(v){return typeof v==='number'&&!isNaN(v)&&isFinite(v);};B.prototype.attachEvent=function(e,d,f,L){C.prototype.attachEvent.call(this,e,d,f,L);if(this.hasListeners("press")){this.$().attr("tabindex",0).addClass("sapSuiteUiMicroChartPointer");}return this;};B.prototype.detachEvent=function(e,f,L){C.prototype.detachEvent.call(this,e,f,L);if(!this.hasListeners("press")){this.$().removeAttr("tabindex").removeClass("sapSuiteUiMicroChartPointer");}return this;};B.prototype.onBeforeRendering=function(){if(this._sChartResizeHandlerId){R.deregister(this._sChartResizeHandlerId);}this._unbindMouseEnterLeaveHandler();};B.prototype.onAfterRendering=function(){l._checkControlIsVisible(this,this._onControlIsVisible);this._bindMouseEnterLeaveHandler();};B.prototype._onControlIsVisible=function(){this._onResize();this._sChartResizeHandlerId=R.register(this,this._onResize.bind(this));};B.prototype._onResize=function(){var $=this.$(),c=parseInt($.css("height")),i=parseInt($.css("width"));if(this.getShowValueMarker()){this._adjustValueToMarker();}$.removeClass("sapSuiteBMCSmallFont sapSuiteBMCNoLabels sapSuiteBMCSmallLook sapSuiteBMCExtraSmallLook sapSuiteBMCThresholdHidden");if(c<=this.convertRemToPixels(B.THRESHOLD_EXTRASMALL_LOOK)){$.addClass("sapSuiteBMCExtraSmallLook");}else if(c<=this.convertRemToPixels(B.THRESHOLD_SMALL_LOOK)){$.addClass("sapSuiteBMCSmallLook");}if(c>=this.convertRemToPixels(B.THRESHOLD_SMALL_LABEL)&&c<=this.convertRemToPixels(B.THRESHOLD_BIG_LABEL)){$.addClass("sapSuiteBMCSmallFont");}if(c<this.convertRemToPixels(B.THRESHOLD_SMALL_LABEL)||this._isAnyChartLabelTruncated()){$.addClass("sapSuiteBMCNoLabels");}if(i<this.convertRemToPixels(B.THRESHOLD_THRESHOLDS)){$.addClass("sapSuiteBMCThresholdHidden");}this._adjustLabelsPos();};B.prototype._isAnyChartLabelTruncated=function(){var L=this.$().find(".sapSuiteBMCItemValue, .sapSuiteBMCTargetValue");return this._isAnyLabelTruncated(L);};B.prototype.exit=function(){R.deregister(this._sChartResizeHandlerId);};B.prototype._adjustLabelsPos=function(){var r=sap.ui.getCore().getConfiguration().getRTL();var t=this.$("bc-target-bar-value");var c=this.$("chart-bar");var f=c.width();if(f){var T=0;if(t&&t.offset()){T=t.offset().left-c.offset().left;if(r){T=f-T;}this._adjustLabelPos(this.$("bc-target-value"),f,T,r);}var b=this.$("bc-bar-value");if(b&&b.offset()){var A=b.offset().left+b.width()-c.offset().left;if(r){A=f-(b.offset().left-c.offset().left);}if(this.getMode()===l.BulletMicroChartModeType.Delta){A=b.width();if(!this.getShowActualValueInDeltaMode()){A=A/2;}var s=this.getTargetValue()<this.getActual().getValue()?1:-1;A=t.offset().left-c.offset().left+(A*s);}this._adjustLabelPos(this.$("bc-item-value"),f,A,r);}}};B.prototype._adjustLabelPos=function(L,f,o,r){var d=r?"right":"left";var b=L.width();if(b>f){L.css(d,"0");}else{var c=o-0.5*b;if(c<0){c=0;}if(c+b>f){c=f-b;}L.css(d,c);}};B.prototype._adjustValueToMarker=function(){var v=this.$("bc-bar-value");var m=this.$("bc-bar-value-marker");var c=this.$().find(".sapSuiteBMCVerticalAlignmentContainer");if(v.offset()&&m.offset()){var V=v.width();var f=v.offset().left;var b=m.width();var d=m.offset().left;if(sap.ui.getCore().getConfiguration().getRTL()){if(d<f){m.css("right","");m.offset({left:f});}if(d+b>f+V){m.css("right","");m.offset({left:f+V-b});}}else{if(d<f){m.offset({left:f});}if(d+b>f+V){v.width((d+b-f)/c.width()*100+"%");}}}};B.prototype._getLocalizedColorMeaning=function(c){return this._oRb.getText(("SEMANTIC_COLOR_"+c).toUpperCase());};B.prototype._getAltHeaderText=function(i){var A=this._oRb.getText("BULLETMICROCHART");if(i){A+=" "+this._oRb.getText("IS_ACTIVE");}if(!this._hasData()){A+="\n"+this._oRb.getText("NO_DATA");return A;}var I=this.getActual()&&this.getActual()._isValueSet;var s=this.getScale();var t=this.getTargetValueLabel();var m=!this.getActual()||!this.getActual().getColor()?"":this._getLocalizedColorMeaning(this.getActual().getColor());if(I){var b=this.getActualValueLabel();var c=(b)?b:""+this.getActual().getValue();A+="\n"+this._oRb.getText("BULLETMICROCHART_ACTUAL_TOOLTIP",[c+s,m]);}if(this.getMode()===l.BulletMicroChartModeType.Delta){if(this._isTargetValueSet&&I){var d=this.getDeltaValueLabel();var e=(d)?d:""+this._calculateDeltaValue();A+="\n"+this._oRb.getText("BULLETMICROCHART_DELTA_TOOLTIP",[e+s,m]);}}else if(this._isForecastValueSet){A+=(this._isForecastValueSet)?"\n"+this._oRb.getText("BULLETMICROCHART_FORECAST_TOOLTIP",[this.getForecastValue()+s,m]):"";}if(this._isTargetValueSet){var T=(t)?t:""+this.getTargetValue();A+="\n"+this._oRb.getText("BULLETMICROCHART_TARGET_TOOLTIP",[T+s]);}return A;};B.prototype._getAltSubText=function(I){var A="";var t=this.getThresholds().sort(function(f,o){return f.getValue()-o.getValue();});for(var i=0;i<t.length;i++){var T=t[i],s=T.getTooltip_AsString(),b="";if(!s){continue;}b+=(I?"":"\n")+this._oRb.getText("BULLETMICROCHART_THRESHOLD_TOOLTIP",[T.getValue()+this.getScale(),this._getLocalizedColorMeaning(T.getColor())]);b=s.split("((AltText))").join(b);if(b){A+=b;I=false;}}return A;};B.prototype._getAccessibilityControlType=function(){return this._oRb.getText("ACC_CTR_TYPE_BULLETMICROCHART");};B.prototype.clone=function(i,L,o){var c=C.prototype.clone.apply(this,arguments);c._isMinValueSet=this._isMinValueSet;c._isMaxValueSet=this._isMaxValueSet;c._isForecastValueSet=this._isForecastValueSet;c._isTargetValueSet=this._isTargetValueSet;return c;};B.prototype._addTitleAttribute=function(){if(!this.$().attr("title")&&this._hasData()){this.$().attr("title",this.getTooltip_AsString());}};B.prototype._removeTitleAttribute=function(){if(this.$().attr("title")){this.$().removeAttr("title");}};B.prototype._bindMouseEnterLeaveHandler=function(){if(!this._oMouseEnterLeaveHandler){this._oMouseEnterLeaveHandler={mouseEnterChart:this._addTitleAttribute.bind(this),mouseLeaveChart:this._removeTitleAttribute.bind(this)};}this.$().bind("mouseenter",this._oMouseEnterLeaveHandler.mouseEnterChart);this.$().bind("mouseleave",this._oMouseEnterLeaveHandler.mouseLeaveChart);};B.prototype._unbindMouseEnterLeaveHandler=function(){if(this._oMouseEnterLeaveHandler){this.$().unbind("mouseenter",this._oMouseEnterLeaveHandler.mouseEnterChart);this.$().unbind("mouseleave",this._oMouseEnterLeaveHandler.mouseLeaveChart);}};B.prototype._hasData=function(){return this.getActual();};B.prototype.firePress=function(){if(this._hasData()){C.prototype.fireEvent.call(this,"press",arguments);}};a.extendMicroChart(B);return B;});
