/*!
 * SAPUI5

(c) Copyright 2009-2019 SAP SE. All rights reserved
 */
sap.ui.define(["sap/ui/thirdparty/jquery","./library","sap/ui/core/Control","sap/m/Size","sap/ui/Device","sap/m/FlexBox","sap/suite/ui/microchart/MicroChartUtils","sap/m/library","sap/ui/core/ResizeHandler","./ComparisonMicroChartRenderer"],function(q,l,C,S,D,F,M,m,R){"use strict";var V=m.ValueColor;var a=l.ComparisonMicroChartViewType;var b=C.extend("sap.suite.ui.microchart.ComparisonMicroChart",{metadata:{library:"sap.suite.ui.microchart",properties:{size:{type:"sap.m.Size",group:"Misc",defaultValue:"Auto"},scale:{type:"string",group:"Misc",defaultValue:""},minValue:{type:"float",group:"Appearance",defaultValue:null},maxValue:{type:"float",group:"Appearance",defaultValue:null},view:{type:"sap.suite.ui.microchart.ComparisonMicroChartViewType",group:"Appearance",defaultValue:"Normal"},colorPalette:{type:"string[]",group:"Appearance",defaultValue:[]},shrinkable:{type:"boolean",group:"Misc",defaultValue:false},width:{type:"sap.ui.core.CSSSize",group:"Appearance"},height:{type:"sap.ui.core.CSSSize",group:"Appearance"},isResponsive:{type:"boolean",group:"Appearance",defaultValue:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},defaultAggregation:"data",aggregations:{data:{type:"sap.suite.ui.microchart.ComparisonMicroChartData",multiple:true,bindable:"bindable"}},events:{press:{}}}});b.THRESHOLD_LOOK_XS=6;b.THRESHOLD_LOOK_S=8.25;b.THRESHOLD_LOOK_M=10.5;b.THRESHOLD_LOOK_L=12;b.prototype.attachEvent=function(e,d,f,L){C.prototype.attachEvent.call(this,e,d,f,L);if(this.hasListeners("press")){this.$().attr("tabindex",0).addClass("sapSuiteUiMicroChartPointer");}return this;};b.prototype.detachEvent=function(e,f,L){C.prototype.detachEvent.call(this,e,f,L);if(!this.hasListeners("press")){this.$().removeAttr("tabindex").removeClass("sapSuiteUiMicroChartPointer");}return this;};b.prototype.ontap=function(e){if(D.browser.edge){this.onclick(e);}};b.prototype.onclick=function(e){if(!this.fireBarPress(e)){this.firePress();if(D.browser.msie||D.browser.edge){this.$().focus();e.preventDefault();}}};b.prototype.fireBarPress=function(e){var B=q(e.target);if(B&&B.attr("data-bar-index")){var i=parseInt(B.attr("data-bar-index"));var c=this.getData()[i];if(c&&c.hasListeners("press")){c.firePress();e.preventDefault();e.stopImmediatePropagation();if(D.browser.msie){q(document.getElementById(this.getId()+"-chart-item-bar-"+i)).focus();}var $=this.$().find(".sapSuiteCpMCChartBar");var d=$.index(this.$().find(".sapSuiteCpMCChartBar[tabindex='0']"));this._switchTabindex(d,i,$);return true;}}return false;};b.prototype.onsaptabprevious=function(){this.$().css("outline-color","");};b.prototype.onsaptabnext=function(){var n=this.$().next();if(n.hasClass("sapSuiteCpMC")&&n.attr("tabindex")){n.css("outline-color","");}};b.prototype.onsapenter=function(e){if(!this.fireBarPress(e)){this.firePress();e.preventDefault();e.stopImmediatePropagation();}};b.prototype.onsapspace=b.prototype.onsapenter;b.prototype.onsapup=function(e){var B=this.$().find(".sapSuiteUiMicroChartPointer");if(B.length>0){var i=B.index(e.target);this._switchTabindex(i,i-1,B);}e.preventDefault();e.stopImmediatePropagation();};b.prototype.onsapdown=function(e){var B=this.$().find(".sapSuiteUiMicroChartPointer");if(B.length>0){var i=B.index(e.target);this._switchTabindex(i,i+1,B);}e.preventDefault();e.stopImmediatePropagation();};b.prototype.onsaphome=function(e){var B=this.$().find(".sapSuiteUiMicroChartPointer");var i=B.index(e.target);if(i!==0&&B.length>0){this._switchTabindex(i,0,B);}e.preventDefault();e.stopImmediatePropagation();};b.prototype.onsapend=function(e){var B=this.$().find(".sapSuiteUiMicroChartPointer");var i=B.index(e.target),L=B.length;if(i!==L-1&&L>0){this._switchTabindex(i,L-1,B);}e.preventDefault();e.stopImmediatePropagation();};b.prototype.onsapleft=b.prototype.onsapup;b.prototype.onsapright=b.prototype.onsapdown;b.prototype.setMinValue=function(f){this._isMinValueSet=q.isNumeric(f);return this.setProperty("minValue",this._isMinValueSet?f:NaN);};b.prototype.setMaxValue=function(f){this._isMaxValueSet=q.isNumeric(f);return this.setProperty("maxValue",this._isMaxValueSet?f:NaN);};b.prototype.setSize=function(s){if(this.getSize()!==s){if(s===S.Responsive){this.setProperty("isResponsive",true);}else{this.setProperty("isResponsive",false);}this.setProperty("size",s,false);}return this;};b.prototype.setIsResponsive=function(i){var s,c=this.getSize();this.setProperty("isResponsive",i);if(i){s=S.Responsive;}else{s=c===S.Responsive?S.Auto:c;}this.setProperty("size",s);return this;};b.prototype.init=function(){this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.suite.ui.microchart");this.setAggregation("tooltip","((AltText))",true);this._isMinValueSet=false;this._isMaxValueSet=false;this._bThemeApplied=true;if(!sap.ui.getCore().isInitialized()){this._bThemeApplied=false;sap.ui.getCore().attachInit(this._handleCoreInitialized.bind(this));}else{this._handleCoreInitialized();}};b.prototype._handleCoreInitialized=function(){this._bThemeApplied=sap.ui.getCore().isThemeApplied();if(!this._bThemeApplied){sap.ui.getCore().attachThemeChanged(this._handleThemeApplied,this);}};b.prototype._handleThemeApplied=function(){this._bThemeApplied=true;this.invalidate();sap.ui.getCore().detachThemeChanged(this._handleThemeApplied,this);};b.prototype.onBeforeRendering=function(){if(this._sChartResizeHandlerId){R.deregister(this._sChartResizeHandlerId);}this._unbindMouseEnterLeaveHandler();};b.prototype.onAfterRendering=function(){l._checkControlIsVisible(this,this._onControlIsVisible);this._bindMouseEnterLeaveHandler();};b.prototype._onControlIsVisible=function(){this._onResize();this._sChartResizeHandlerId=R.register(this,this._onResize.bind(this));};b.prototype.setBarPressable=function(B,p){if(p){var s=this._getBarAltText(B);q(document.getElementById(this.getId()+"-chart-item-bar-"+B)).addClass("sapSuiteUiMicroChartPointer").attr("tabindex",0).attr("title",s).attr("role","presentation").attr("aria-label",s);}else{q(document.getElementById(this.getId()+"-chart-item-bar-"+B)).removeAttr("tabindex").removeClass("sapSuiteUiMicroChartPointer").removeAttr("title").removeAttr("role").removeAttr("aria-label");}};b.prototype._getAltHeaderText=function(i){var A=this._oRb.getText("COMPARISONMICROCHART");if(i){A+=" "+this._oRb.getText("IS_ACTIVE");}if(!this._hasData()){A+="\n"+this._oRb.getText("NO_DATA");return A;}return A;};b.prototype._getAltSubText=function(I){var A="";for(var i=0;i<this.getData().length;i++){var B=this.getData()[i],s=this._getBarAltText(i),c=B.getTooltip_AsString(),d="";if(!c){continue;}d=c.split("((AltText))").join(s);if(d){A+=(I?"":"\n")+d;I=false;}}return A;};b.prototype._getAccessibilityControlType=function(){return this._oRb.getText("ACC_CTR_TYPE_COMPARISONMICROCHART");};b.prototype.exit=function(){R.deregister(this._sChartResizeHandlerId);};b.prototype._calculateChartData=function(){var r=[];var d=this.getData();var c=d.length;var e=0;var f=0;var t;var g;var h;var i;for(i=0;i<c;i++){var j=isNaN(d[i].getValue())?0:d[i].getValue();e=Math.max(e,j);f=Math.min(f,j);}if(this._isMinValueSet){f=Math.min(f,this.getMinValue());}if(this._isMaxValueSet){e=Math.max(e,this.getMaxValue());}t=e-f;g=(t==0)?0:Math.round(e*100/t);if(g==0&&e!=0){g=1;}else if(g==100&&f!=0){g=99;}h=100-g;for(i=0;i<c;i++){var I={};var k=isNaN(d[i].getValue())?0:d[i].getValue();I.value=(t==0)?0:Math.round(k*100/t);if(I.value==0&&k!=0){I.value=(k>0)?1:-1;}else if(I.value==100){I.value=g;}else if(I.value==-100){I.value=-h;}if(I.value>=0){I.negativeNoValue=h;I.positiveNoValue=g-I.value;}else{I.value=-I.value;I.negativeNoValue=h-I.value;I.positiveNoValue=g;}r.push(I);}return r;};b.prototype._getLocalizedColorMeaning=function(c){return V[c]?this._oRb.getText(("SEMANTIC_COLOR_"+c).toUpperCase()):"";};b.prototype._getBarAltText=function(B){var o=this.getData()[B],s=C.prototype.getTooltip_AsString.apply(o,arguments),c=this.getColorPalette().length?"":this._getLocalizedColorMeaning(o.getColor()),d=o.getTitle()+" "+(o.getDisplayValue()?o.getDisplayValue():o.getValue())+this.getScale()+" "+c;if(!s){return"";}return s.split("((AltText))").join(d);};b.prototype._onResize=function(){this.$().find(".sapSuiteCpMCChartItem").show();this._resizeHorizontally();this._resizeVertically();};b.prototype._resizeVertically=function(){var I,f,B,c,s,d,e,r,g,h=this.getData(),$=this.$(),j,k=$.find(".sapSuiteCpMCChartItem"),n=$.find(".sapSuiteCpMCChartBar");k.css("margin-bottom","");k.css("height","");n.css("height","");if(h.length>0&&h[0].getDomRef()){I=h[0].getDomRef().getBoundingClientRect().height;f=parseFloat(h[0].$().css("margin-bottom"));B=n.height();d=$.width();e=this._getCurrentBaseWidth();if(e>0){r=e/I;I=d/r;k.css("height",I);r=e/f;f=d/r;k.css("margin-bottom",f);r=e/B;n.css("height",d/r);}c=$.find(".sapSuiteCpMCVerticalAlignmentContainer")[0].getBoundingClientRect().height;s=0;for(var i=0;i<h.length;i++){s+=I;if(s>c){h[i].$().hide();}s+=f;}j=this.$().find(".sapSuiteCpMCVerticalAlignmentContainer .sapSuiteCpMCChartItem:visible:last");if(j.length===1&&!this.getShrinkable()){j.css("margin-bottom","");g=this.getDomRef().getBoundingClientRect().bottom-j[0].getBoundingClientRect().bottom;if(g<f){j.css("margin-bottom",g<0?0:g);}}}};b.prototype._resizeHorizontally=function(){var $=this.$();var f=0;var c=0;var d=this.$().find(".sapSuiteCpMCChartItemTitle");var e=this.$().find(".sapSuiteCpMCChartItemValue");var B;var L;$.removeClass("sapSuiteCpMCLookL sapSuiteCpMCLookM sapSuiteCpMCLookS sapSuiteCpMCLookXS sapSuiteCpMCLookWide");L=this._getCurrentLookClass();$.addClass(L);if(!$.hasClass("sapSuiteCpMCLookXS")){this._hideTruncatedLabels(".sapSuiteCpMCChartItemValue");}d.width("auto");e.width("auto");if($.hasClass("sapSuiteCpMCLookWide")){d.each(function(){B=this.getBoundingClientRect();if(B.width>f){f=Math.ceil(B.width);}});d.width(f);e.each(function(){B=this.getBoundingClientRect();if(B.width>c){c=Math.ceil(B.width);}});e.width(c);}};b.prototype._getCurrentBaseWidth=function(){var $=this.$();var w=parseInt($.width());var B;if(this.getView()===a.Wide||w>this.convertRemToPixels(b.THRESHOLD_LOOK_L)||this.getSize()!==S.Responsive){B=0;}else if(w>this.convertRemToPixels(b.THRESHOLD_LOOK_M)){B=this.convertRemToPixels(b.THRESHOLD_LOOK_L);}else if(w>this.convertRemToPixels(b.THRESHOLD_LOOK_S)){B=this.convertRemToPixels(b.THRESHOLD_LOOK_M);}else if(w>this.convertRemToPixels(b.THRESHOLD_LOOK_XS)){B=this.convertRemToPixels(b.THRESHOLD_LOOK_S);}else{B=0;}return B;};b.prototype._getCurrentLookClass=function(){var $=this.$();var w=parseInt($.width());var L;if(this._shouldUseWideView()){L="sapSuiteCpMCLookWide";}else if(this.getSize()!==S.Responsive){L="sapSuiteCpMCLook"+this._getSize();}else if(w>this.convertRemToPixels(b.THRESHOLD_LOOK_M)){L="sapSuiteCpMCLookL";}else if(w>this.convertRemToPixels(b.THRESHOLD_LOOK_S)){L="sapSuiteCpMCLookM";}else if(w>this.convertRemToPixels(b.THRESHOLD_LOOK_XS)){L="sapSuiteCpMCLookS";}else{L="sapSuiteCpMCLookXS";}return L;};b.prototype._getSize=function(){var s=this.getSize();if(s===S.Auto){if(D.system.phone){s=S.S;}else{s=S.M;}}return s;};b.prototype._shouldUseWideView=function(){var w=parseInt(this.$().width());return this.getView()===a.Wide||(this.getView()===a.Responsive&&w>this.convertRemToPixels(b.THRESHOLD_LOOK_L));};b.prototype._hideTruncatedLabels=function(c){var $=this.$();var L=$.find(c);for(var i=0;i<L.length;i++){q(L[i]).removeClass("sapSuiteCpMCChartItemHiddenLabel");if(this._isLabelTruncated(L[i])){q(L[i]).addClass("sapSuiteCpMCChartItemHiddenLabel");}}};b.prototype._addTitleAttribute=function(){var t=this.getTooltip_AsString();if(!l._isTooltipSuppressed(t)&&this._hasData()){if(this.getIsResponsive()){this.$().find(".sapSuiteCpMCVerticalAlignmentContainer").attr("title",t);}else{this.$().attr("title",t);}}};b.prototype._removeTitleAttribute=function(){if(this.getIsResponsive()){this.$().find(".sapSuiteCpMCVerticalAlignmentContainer").removeAttr("title");}else{this.$().removeAttr("title");}};b.prototype._resolveFocus=function(e){var B=q(e.target);if(B&&B.attr("data-bar-index")){var i=parseInt(B.attr("data-bar-index"));var d=this.getData()[i];if(d&&d.hasListeners("press")){this.$().css("outline-color","transparent");}else{this.$().css("outline-color","");}}else{this.$().css("outline-color","");}};b.prototype._switchTabindex=function(o,n,c){if(o>=0&&o<c.length&&n>=0&&n<c.length){c.eq(o).removeAttr("tabindex");c.eq(n).attr("tabindex","0").focus();}};b.prototype._bindMouseEnterLeaveHandler=function(){if(!this._oMouseEnterLeaveHandler){this._oMouseEnterLeaveHandler={mouseEnterChart:this._addTitleAttribute.bind(this),mouseLeaveChart:this._removeTitleAttribute.bind(this),mouseDownChart:this._resolveFocus.bind(this)};}this.$().bind("mouseenter",this._oMouseEnterLeaveHandler.mouseEnterChart);this.$().bind("mouseleave",this._oMouseEnterLeaveHandler.mouseLeaveChart);this.$().bind("mousedown",this._oMouseEnterLeaveHandler.mouseDownChart);};b.prototype._unbindMouseEnterLeaveHandler=function(){if(this._oMouseEnterLeaveHandler){this.$().unbind("mouseenter",this._oMouseEnterLeaveHandler.mouseEnterChart);this.$().unbind("mouseleave",this._oMouseEnterLeaveHandler.mouseLeaveChart);this.$().unbind("mousedown",this._oMouseEnterLeaveHandler.mouseDownChart);}};b.prototype._hasData=function(){return this.getData().length>0;};b.prototype.firePress=function(){if(this._hasData()){C.prototype.fireEvent.call(this,"press",arguments);}};M.extendMicroChart(b);return b;});
