/*!
 * SAPUI5

(c) Copyright 2009-2019 SAP SE. All rights reserved
 */
sap.ui.define(["sap/ui/thirdparty/jquery","./library","sap/m/library","sap/m/FlexBox","sap/ui/core/Control","sap/ui/Device","sap/ui/core/ResizeHandler","sap/ui/events/KeyCodes","sap/suite/ui/microchart/MicroChartUtils","./DeltaMicroChartRenderer"],function(q,l,M,F,C,D,R,K,a){"use strict";var V=M.ValueColor;var S=M.Size;var b=l.DeltaMicroChartViewType;var c=C.extend("sap.suite.ui.microchart.DeltaMicroChart",{metadata:{library:"sap.suite.ui.microchart",properties:{value1:{type:"float",group:"Misc",defaultValue:null},value2:{type:"float",group:"Misc",defaultValue:null},title1:{type:"string",group:"Misc",defaultValue:null},title2:{type:"string",group:"Misc",defaultValue:null},displayValue1:{type:"string",group:"Misc",defaultValue:null},displayValue2:{type:"string",group:"Misc",defaultValue:null},deltaDisplayValue:{type:"string",group:"Misc",defaultValue:null},color:{type:"sap.m.ValueCSSColor",group:"Misc",defaultValue:"Neutral"},view:{type:"sap.suite.ui.microchart.DeltaMicroChartViewType",group:"Appearance",defaultValue:"Normal"},width:{type:"sap.ui.core.CSSSize",group:"Misc"},height:{group:"Misc",type:"sap.ui.core.CSSSize"},size:{type:"sap.m.Size",group:"Misc",defaultValue:"Auto"},isResponsive:{type:"boolean",group:"Appearance",defaultValue:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{}}}});c.THRESHOLD_LOOK_XS=1.125;c.THRESHOLD_LOOK_S=3.5;c.THRESHOLD_LOOK_M=4.5;c.THRESHOLD_LOOK_L=5.875;c.THRESHOLD_WIDTH_NO_LABEL=6;c.THRESHOLD_WIDTH_WIDE_MODE=12;c.prototype.init=function(){this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.suite.ui.microchart");this.setAggregation("tooltip","((AltText))",true);this._bThemeApplied=true;if(!sap.ui.getCore().isInitialized()){this._bThemeApplied=false;sap.ui.getCore().attachInit(this._handleCoreInitialized.bind(this));}else{this._handleCoreInitialized();}};c.prototype.setSize=function(s){if(this.getSize()!==s){if(s===S.Responsive){this.setProperty("isResponsive",true,true);}else{this.setProperty("isResponsive",false,true);}this.setProperty("size",s,false);}return this;};c.prototype.setIsResponsive=function(i){var s,d=this.getSize();this.setProperty("isResponsive",i);if(i){s=S.Responsive;}else{s=d===S.Responsive?S.Auto:d;}this.setProperty("size",s);return this;};c.prototype._handleCoreInitialized=function(){this._bThemeApplied=sap.ui.getCore().isThemeApplied();if(!this._bThemeApplied){sap.ui.getCore().attachThemeChanged(this._handleThemeApplied,this);}};c.prototype._handleThemeApplied=function(){this._bThemeApplied=true;this.invalidate();sap.ui.getCore().detachThemeChanged(this._handleThemeApplied,this);};c.prototype._calcChartData=function(){var v=this.getValue1();var f=this.getValue2();var m=Math.min(v,f,0);var d=Math.max(v,f,0);var t=d-m;function e(h){return(t===0?0:Math.abs(h)/t*100).toFixed(2);}var o={};var g=v-f;o.delta={left:d===0,width:e(g),isFirstStripeUp:v<f,isMax:(v<0&&f>=0)||(v>=0&&f<0),isZero:v===0&&f===0,isEqual:g===0};o.bar1={left:f>=0,width:e(v),isSmaller:Math.abs(v)<Math.abs(f)};o.bar2={left:v>=0,width:e(f),isSmaller:Math.abs(f)<Math.abs(v)};return o;};c.prototype._getDeltaValue=function(){var v=this.getValue1(),f=this.getValue2();return Math.abs(v-f).toFixed(Math.max(this._digitsAfterDecimalPoint(v),this._digitsAfterDecimalPoint(f)));};c.prototype._getLocalizedColorMeaning=function(s){return V[s]?this._oRb.getText(("SEMANTIC_COLOR_"+s).toUpperCase()):"";};c.prototype._getAltHeaderText=function(i){var A=this._oRb.getText("DELTAMICROCHART");if(i){A+=" "+this._oRb.getText("IS_ACTIVE");}A+="\n";if(!this._hasData()){A+=this._oRb.getText("NO_DATA");return A;}var d=this.getDisplayValue1();var s=this.getDisplayValue2();var e=this.getDeltaDisplayValue();var v=this.getValue1();var f=this.getValue2();var g=d?d:""+v;var h=s?s:""+f;var j=e?e:""+Math.abs(v-f).toFixed(Math.max(this._digitsAfterDecimalPoint(v),this._digitsAfterDecimalPoint(f)));var m=this._getLocalizedColorMeaning(this.getColor());A+=this.getTitle1()+" "+g+"\n"+this.getTitle2()+" "+h+"\n"+this._oRb.getText("DELTAMICROCHART_DELTA_TOOLTIP",[j,m]);return A;};c.prototype._getAccessibilityControlType=function(){return this._oRb.getText("ACC_CTR_TYPE_DELTAMICROCHART");};c.prototype.onBeforeRendering=function(){this._oChartData=this._calcChartData();if(this._sResizeHandlerId){R.deregister(this._sResizeHandlerId);}this.$().unbind("mouseenter");this.$().unbind("mouseleave");};c.prototype.onAfterRendering=function(){l._checkControlIsVisible(this,this._onControlIsVisible);this.$().bind("mouseenter",this._addTitleAttribute.bind(this));this.$().bind("mouseleave",this._removeTitleAttribute.bind(this));};c.prototype._onControlIsVisible=function(){if(this._hasData()){this._onResize();this._sResizeHandlerId=R.register(this,this._onResize.bind(this));}};c.prototype.exit=function(){R.deregister(this._sResizeHandlerId);};c.prototype._onResize=function(){var $=this.$(),i=parseInt($.width()),d=parseInt($.height()),r=$.find(".sapSuiteDMCLbls .sapSuiteDMCLabel"),v=this.getView();$.removeClass("sapSuiteDMCNoLabels sapSuiteDMCNoRightLabels sapSuiteDMCLookM sapSuiteDMCLookS sapSuiteDMCLookXS");if(v===b.Responsive){$.removeClass("sapSuiteDMCWideMode");}if(i<=this.convertRemToPixels(c.THRESHOLD_WIDTH_NO_LABEL)||d<=this.convertRemToPixels(c.THRESHOLD_LOOK_XS)){$.addClass("sapSuiteDMCNoLabels");}if(v===b.Responsive&&i>this.convertRemToPixels(c.THRESHOLD_WIDTH_WIDE_MODE)){$.addClass("sapSuiteDMCWideMode");}if(d<this.convertRemToPixels(c.THRESHOLD_LOOK_S)){$.addClass("sapSuiteDMCLookXS");}else if(d<this.convertRemToPixels(c.THRESHOLD_LOOK_M)){$.addClass("sapSuiteDMCLookS");}else if(d<this.convertRemToPixels(c.THRESHOLD_LOOK_L)){$.addClass("sapSuiteDMCLookM");}if(this._isAnyLabelTruncated(r)){$.addClass("sapSuiteDMCNoRightLabels");}};c.prototype.attachEvent=function(e,d,f,L){C.prototype.attachEvent.call(this,e,d,f,L);if(this.hasListeners("press")){this.$().attr("tabindex",0).addClass("sapSuiteUiMicroChartPointer");}return this;};c.prototype.detachEvent=function(e,f,L){C.prototype.detachEvent.call(this,e,f,L);if(!this.hasListeners("press")){this.$().removeAttr("tabindex").removeClass("sapSuiteUiMicroChartPointer");}return this;};c.prototype.ontap=function(e){if(D.browser.msie){this.$().focus();}this.firePress();};c.prototype.onkeydown=function(e){if(e.which===K.SPACE){e.preventDefault();}};c.prototype.onkeyup=function(e){if(e.which===K.ENTER||e.which===K.SPACE){this.firePress();e.preventDefault();}};c.prototype._addTitleAttribute=function(){if(!this.$().attr("title")&&this._hasData()){this.$().attr("title",this.getTooltip_AsString());}};c.prototype._removeTitleAttribute=function(){if(this.$().attr("title")){this.$().removeAttr("title");}};c.prototype._hasData=function(){return true;};c.prototype.firePress=function(){if(this._hasData()){C.prototype.fireEvent.call(this,"press",arguments);}};a.extendMicroChart(c);return c;});
