/*!
 * SAPUI5

(c) Copyright 2009-2019 SAP SE. All rights reserved
 */
sap.ui.define(["sap/ui/thirdparty/jquery","./library","sap/m/library","sap/ui/core/Control","sap/ui/Device","sap/ui/events/KeyCodes","sap/suite/ui/microchart/MicroChartUtils","sap/ui/core/ResizeHandler","./HarveyBallMicroChartRenderer"],function(q,l,M,C,D,K,a,R){"use strict";var V=M.ValueColor;var S=M.Size;var H=C.extend("sap.suite.ui.microchart.HarveyBallMicroChart",{metadata:{library:"sap.suite.ui.microchart",properties:{total:{group:"Misc",type:"float",defaultValue:null},totalLabel:{group:"Misc",type:"string"},totalScale:{group:"Misc",type:"string"},formattedLabel:{group:"Misc",type:"boolean",defaultValue:false},showTotal:{group:"Misc",type:"boolean",defaultValue:true},showFractions:{group:"Misc",type:"boolean",defaultValue:true},size:{group:"Misc",type:"sap.m.Size",defaultValue:"Auto"},colorPalette:{type:"string[]",group:"Appearance",defaultValue:[]},width:{type:"sap.ui.core.CSSSize",group:"Misc"},height:{type:"sap.ui.core.CSSSize",group:"Misc"},alignContent:{group:"Misc",type:"sap.suite.ui.microchart.HorizontalAlignmentType",defaultValue:"Left"},isResponsive:{type:"boolean",group:"Appearance",defaultValue:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},defaultAggregation:"items",aggregations:{items:{multiple:true,type:"sap.suite.ui.microchart.HarveyBallMicroChartItem",bindable:"bindable"}},events:{press:{}}}});H.VALUE_TRUNCATION_DIGITS=5;H.THRESHOLD_LOOK_XS=1.125;H.THRESHOLD_LOOK_S=3.5;H.THRESHOLD_LOOK_M=4.5;H.THRESHOLD_LOOK_L=5.875;H.prototype._getAltHeaderText=function(i){var A=this._oRb.getText("HARVEYBALLMICROCHART");if(i){A+=" "+this._oRb.getText("IS_ACTIVE");}if(!this._hasData()){A+="\n"+this._oRb.getText("NO_DATA");return A;}return A;};H.prototype._getAltSubText=function(i){var A="";var I=this.getItems();I.forEach(function(o){var s=o.getColor(),b=o.getTooltip_AsString(),c="";if(!b){return;}var d=(this.getColorPalette().length===0&&V[s])?this._oRb.getText(("SEMANTIC_COLOR_"+s).toUpperCase()):"";var L=o.getFractionLabel();var e=o.getFractionScale();if(!L&&e){L=o.getFormattedLabel()?o.getFraction():o.getFraction()+o.getFractionScale().substring(0,3);}else if(!o.getFormattedLabel()&&o.getFractionLabel()&&e){L+=o.getFractionScale().substring(0,3);}c+=L+" "+d;c=b.split("((AltText))").join(c);if(c){A+="\n"+c;i=false;}}.bind(this));if(this.getTotal()){var t=this.getTotalLabel();if(!t){t=this.getFormattedLabel()?this.getTotal():this.getTotal()+this.getTotalScale().substring(0,3);}else if(!this.getFormattedLabel()&&this.getTotalScale()){t+=this.getTotalScale().substring(0,3);}A+=(i?"":"\n")+this._oRb.getText("HARVEYBALLMICROCHART_TOTAL_TOOLTIP")+" "+t;}return A;};H.prototype.getTooltip_AsString=function(i){var t=C.prototype.getTooltip_AsString.apply(this,arguments),T=this._getAltHeaderText(i),I=false;if(t){T=t.split("((AltText))").join(T);}if(!t||!T){T="";I=true;}T+=this._getAltSubText(I);return T;};H.prototype._getAccessibilityControlType=function(){return this._oRb.getText("ACC_CTR_TYPE_HARVEYBALLMICROCHART");};H.prototype.init=function(){this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.suite.ui.microchart");this.setAggregation("tooltip","((AltText))",true);D.media.attachHandler(this.rerender,this,D.media.RANGESETS.SAP_STANDARD);this._sChartResizeHandlerId=null;this._bThemeApplied=true;if(!sap.ui.getCore().isInitialized()){this._bThemeApplied=false;sap.ui.getCore().attachInit(this._handleCoreInitialized.bind(this));}else{this._handleCoreInitialized();}};H.prototype.setSize=function(s){if(this.getSize()!==s){if(s===S.Responsive){this.setProperty("isResponsive",true);}else{this.setProperty("isResponsive",false);}this.setProperty("size",s,false);}return this;};H.prototype.setIsResponsive=function(i){var s,c=this.getSize();this.setProperty("isResponsive",i);if(i){s=S.Responsive;}else{s=c===S.Responsive?S.Auto:c;}this.setProperty("size",s);return this;};H.prototype._handleCoreInitialized=function(){this._bThemeApplied=sap.ui.getCore().isThemeApplied();if(!this._bThemeApplied){sap.ui.getCore().attachThemeChanged(this._handleThemeApplied,this);}};H.prototype._handleThemeApplied=function(){this._bThemeApplied=true;this.invalidate();sap.ui.getCore().detachThemeChanged(this._handleThemeApplied,this);};H.prototype.onBeforeRendering=function(){if(this._sChartResizeHandlerId){R.deregister(this._sChartResizeHandlerId);}this._unbindMouseEnterLeaveHandler();};H.prototype.onAfterRendering=function(){l._checkControlIsVisible(this,this._onControlIsVisible);this._bindMouseEnterLeaveHandler();};H.prototype._onControlIsVisible=function(){this._onResize();this._sChartResizeHandlerId=R.register(this,this._onResize.bind(this));};H.prototype._onResize=function(){var c=this.$(),f=c.height(),p=c.find(".sapSuiteHBMCChart").first(),t=c.find(".sapSuiteHBMCTextContainer").first(),b,P;c.removeClass("sapSuiteHBMCLookL sapSuiteHBMCLookM sapSuiteHBMCLookS sapSuiteHBMCLookXS");t.removeClass("sapSuiteHBMCTextContainerHide");p.css("width",p.css("height"));var s=c.find(".sapSuiteHBMCChartSvg")[0];if(s){s.setAttribute("viewBox","0 0 72 72");}if(f<this.convertRemToPixels(H.THRESHOLD_LOOK_S)){c.addClass("sapSuiteHBMCLookXS");if(s){s.setAttribute("viewBox","5 5 62 62");}}else if(f<this.convertRemToPixels(H.THRESHOLD_LOOK_M)){c.addClass("sapSuiteHBMCLookS");}else if(f<this.convertRemToPixels(H.THRESHOLD_LOOK_L)){c.addClass("sapSuiteHBMCLookM");}else{c.addClass("sapSuiteHBMCLookL");}b=c.width();P=p.width()+t.outerWidth();if(b<P){t.addClass("sapSuiteHBMCTextContainerHide");}};H.prototype._parseFormattedValue=function(v){return{scale:v.replace(/.*?([^+-.,\d]*)$/g,"$1").trim(),value:v.replace(/(.*?)[^+-.,\d]*$/g,"$1").trim()};};H.prototype.ontap=function(e){if(D.browser.msie){this.$().focus();}this.firePress();};H.prototype.onkeydown=function(e){if(e.which==K.SPACE){e.preventDefault();}};H.prototype.onkeyup=function(e){if(e.which===K.ENTER||e.which===K.SPACE){this.firePress();e.preventDefault();}};H.prototype.attachEvent=function(e,d,f,L){C.prototype.attachEvent.call(this,e,d,f,L);if(this.hasListeners("press")){this.$().attr("tabindex",0).addClass("sapSuiteUiMicroChartPointer");}return this;};H.prototype.detachEvent=function(e,f,L){C.prototype.detachEvent.call(this,e,f,L);if(!this.hasListeners("press")){this.$().removeAttr("tabindex").removeClass("sapSuiteUiMicroChartPointer");}return this;};H.prototype.exit=function(e){D.media.detachHandler(this.rerender,this,D.media.RANGESETS.SAP_STANDARD);R.deregister(this._sChartResizeHandlerId);};H.prototype._addTitleAttribute=function(){if(!this.$().attr("title")&&this._hasData()){this.$().attr("title",this.getTooltip_AsString());}};H.prototype._removeTitleAttribute=function(){if(this.$().attr("title")){this.$().removeAttr("title");}};H.prototype._bindMouseEnterLeaveHandler=function(){this.$().bind("mouseenter.tooltip",this._addTitleAttribute.bind(this));this.$().bind("mouseleave.tooltip",this._removeTitleAttribute.bind(this));};H.prototype._unbindMouseEnterLeaveHandler=function(){this.$().unbind("mouseenter.tooltip");this.$().unbind("mouseleave.tooltip");};H._truncateValue=function(v,d){var h=v[d-1]==="."||v[d-1]===",";if(v.length>=d&&h){return v.substring(0,d-1);}else{return v.substring(0,d);}};H.prototype._hasData=function(){return this.getItems().length>0;};H.prototype.firePress=function(){if(this._hasData()){C.prototype.fireEvent.call(this,"press",arguments);}};a.extendMicroChart(H);return H;});
