/*
 * ! SAPUI5

		(c) Copyright 2009-2019 SAP SE. All rights reserved
	
 */
sap.ui.define(['sap/ui/thirdparty/jquery','sap/ui/comp/library','sap/ui/core/Element','./Factory','sap/ui/model/json/JSONModel','sap/ui/comp/odata/MetadataAnalyser','sap/ui/model/BindingMode','sap/base/Log'],function(q,l,E,F,J,M,B,L){"use strict";var S=E.extend("sap.ui.comp.navpopover.SemanticObjectController",{metadata:{library:"sap.ui.comp",properties:{ignoredFields:{type:"string",group:"Misc",defaultValue:null},prefetchNavigationTargets:{type:"boolean",group:"Misc",defaultValue:false},fieldSemanticObjectMap:{type:"object",group:"Misc",defaultValue:null},entitySet:{type:"string",group:"Misc",defaultValue:null},contactAnnotationPaths:{type:"object",defaultValue:null},enableAvailableActionsPersonalization:{type:"object",defaultValue:null},mapFieldToSemanticObject:{type:"boolean"},forceLinkRendering:{type:"object",defaultValue:null}},events:{navigationTargetsObtained:{parameters:{mainNavigation:{type:"sap.ui.comp.navpopover.LinkData"},actions:{type:"sap.ui.comp.navpopover.LinkData[]"},ownNavigation:{type:"sap.ui.comp.navpopover.LinkData"},popoverForms:{type:"sap.ui.layout.form.SimpleForm[]"},semanticObject:{type:"string"},semanticAttributes:{type:"object"},originalId:{type:"string"},show:{type:"function"}}},beforePopoverOpens:{parameters:{semanticObject:{type:"string"},semanticAttributes:{type:"object"},semanticAttributesOfSemanticObjects:{type:"object"},setSemanticAttributes:{type:"function"},setAppStateKey:{type:"function"},originalId:{type:"string"},open:{type:"function"}}},navigate:{parameters:{text:{type:"string"},href:{type:"string"},semanticObject:{type:"string"},semanticAttributes:{type:"object"},originalId:{type:"string"}}},prefetchDone:{parameters:{semanticObjects:{type:"object"}}}}}});S.oSemanticObjects={};S.oNavigationTargetActions={};S.bHasPrefetchedDistinctSemanticObjects=false;S.bHasPrefetchedNavigationTargetActions=false;S.oPromise=null;S.oPromiseActions=null;S.prototype.init=function(){S.prefetchDistinctSemanticObjects();this._proxyOnBeforePopoverOpens=this._onBeforePopoverOpens.bind(this);this._proxyOnTargetsObtained=this._onTargetsObtained.bind(this);this._proxyOnNavigate=this._onNavigate.bind(this);this._aRegisteredControls=[];};S.prototype.isControlRegistered=function(c){return this._aRegisteredControls.indexOf(c)>-1;};S.prototype.registerControl=function(c){if(!c||!(c.isA("sap.ui.comp.navpopover.SmartLink")||c.isA("sap.ui.comp.navpopover.NavigationPopoverHandler"))){L.warning("sap.ui.comp.navpopover.SemanticObjectController: "+(c.getMetadata?c.getMetadata():"parameter")+" is neither of SmartLink nor of NavigationPopoverHandler instance");return;}if(this.isControlRegistered(c)){return;}if(c.attachBeforePopoverOpens){c.attachBeforePopoverOpens(this._proxyOnBeforePopoverOpens);}if(c.attachNavigationTargetsObtained){c.attachNavigationTargetsObtained(this._proxyOnTargetsObtained);}if(c.attachInnerNavigate){c.attachInnerNavigate(this._proxyOnNavigate);}this._aRegisteredControls.push(c);};S.prototype.unregisterControl=function(c){if(!c){return;}if(!this.isControlRegistered(c)){return;}if(c.detachBeforePopoverOpens){c.detachBeforePopoverOpens(this._proxyOnBeforePopoverOpens);}if(c.detachNavigationTargetsObtained){c.detachNavigationTargetsObtained(this._proxyOnTargetsObtained);}if(c.detachInnerNavigate){c.detachInnerNavigate(this._proxyOnNavigate);}this._aRegisteredControls.splice(this._aRegisteredControls.indexOf(c),1);};S.prototype._onBeforePopoverOpens=function(e){var p=e.getParameters();if(this.hasListeners("beforePopoverOpens")){this.fireBeforePopoverOpens({semanticObject:p.semanticObject,semanticAttributes:p.semanticAttributes,semanticAttributesOfSemanticObjects:p.semanticAttributesOfSemanticObjects,setSemanticAttributes:p.setSemanticAttributes,setAppStateKey:p.setAppStateKey,originalId:p.originalId,open:p.open});}else{p.open();}};S.prototype._onTargetsObtained=function(e){var p=e.getParameters();if(!this.hasListeners("navigationTargetsObtained")){p.show();return;}this.fireNavigationTargetsObtained({mainNavigation:p.mainNavigation,actions:p.actions,ownNavigation:p.ownNavigation,popoverForms:p.popoverForms,semanticObject:p.semanticObject,semanticAttributes:p.semanticAttributes,originalId:p.originalId,show:p.show});};S.prototype._onNavigate=function(e){var p=e.getParameters();this.fireNavigate({text:p.text,href:p.href,originalId:p.originalId,semanticObject:p.semanticObject,semanticAttributes:p.semanticAttributes});};S.prototype.setIgnoredState=function(s){if(s&&s.isA("sap.ui.comp.navpopover.SmartLink")){s._updateEnabled();}};S.prototype.setIgnoredFields=function(i){this.setProperty("ignoredFields",i);this._aRegisteredControls.forEach(function(r){if(r._updateEnabled){r._updateEnabled();}});return this;};S.prototype.setPrefetchNavigationTargets=function(p){this.setProperty("prefetchNavigationTargets",p);if(p!==true){return this;}L.error("sap.ui.comp.navpopover.SemanticObjectController: Please be aware that in case of a large amount of semantic objects the performance may suffer significantly and the received links will be created out of context");var t=this;S.getDistinctSemanticObjects().then(function(s){S.getNavigationTargetActions(s).then(function(n){t.firePrefetchDone({semanticObjects:n});});});return this;};S.prototype.getFieldSemanticObjectMap=function(){var m=this.getProperty("fieldSemanticObjectMap");if(m){return m;}if(!this.getEntitySet()){L.warning("sap.ui.comp.navpopover.SemanticObjectController: FieldSemanticObjectMap is not set on SemanticObjectController, retrieval without EntitySet not possible");return null;}var o=new M(this.getModel());m=o.getFieldSemanticObjectMap(this.getEntitySet());if(m){this.setProperty("fieldSemanticObjectMap",m,true);}return m;};S.prototype.getEntitySet=function(){var e=this.getProperty("entitySet");if(e){return e;}var p=this.getParent();while(p){if(p.getEntitySet){e=p.getEntitySet();if(e){this.setProperty("entitySet",e,true);break;}}p=p.getParent();}return e;};S.prototype.hasSemanticObjectLinks=function(s){return S.hasDistinctSemanticObject([s],S.oSemanticObjects);};S.prefetchDistinctSemanticObjects=function(){S.getJSONModel();if(!S.bHasPrefetchedDistinctSemanticObjects){S.getDistinctSemanticObjects();}};S.getDistinctSemanticObjects=function(){if(S.bHasPrefetchedDistinctSemanticObjects){return Promise.resolve(S.oSemanticObjects);}if(!S.oPromise){S.oPromise=new Promise(function(r){var c=F.getService("CrossApplicationNavigation");if(!c){L.error("sap.ui.comp.navpopover.SemanticObjectController: Service 'CrossApplicationNavigation' could not be obtained");S.bHasPrefetchedDistinctSemanticObjects=true;return r({});}c.getDistinctSemanticObjects().then(function(s){s.forEach(function(a){S.oSemanticObjects[a]={};});var m=S.getJSONModel();m.setProperty("/distinctSemanticObjects",S.oSemanticObjects);S.bHasPrefetchedDistinctSemanticObjects=true;return r(S.oSemanticObjects);},function(){L.error("sap.ui.comp.navpopover.SemanticObjectController: getDistinctSemanticObjects() of service 'CrossApplicationNavigation' failed");S.bHasPrefetchedDistinctSemanticObjects=true;return r({});});});}return S.oPromise;};S.getNavigationTargetActions=function(s){if(S.bHasPrefetchedNavigationTargetActions){return Promise.resolve(S.oNavigationTargetActions);}if(!S.oPromiseLinks){S.oPromiseLinks=new Promise(function(r){var c=F.getService("CrossApplicationNavigation");var u=F.getService("URLParsing");if(!c||!u){L.error("sap.ui.comp.navpopover.SemanticObjectController: Service 'CrossApplicationNavigation' or 'URLParsing' could not be obtained");S.bHasPrefetchedNavigationTargetActions=true;return r({});}var a=Object.keys(s);var p=a.map(function(b){return[{semanticObject:b}];});c.getLinks(p).then(function(b){a.forEach(function(d,i){S.oNavigationTargetActions[d]=[];b[i][0].forEach(function(o){var e=u.parseShellHash(o.intent);if(e&&e.semanticObject===d){S.oNavigationTargetActions[d].push(e.action);}});});var m=S.getJSONModel();m.setProperty("/navigationTargetActions",S.oNavigationTargetActions);S.bHasPrefetchedNavigationTargetActions=true;return r(S.oNavigationTargetActions);},function(){L.error("sap.ui.comp.navpopover.SemanticObjectController: getLinks() of service 'CrossApplicationNavigation' failed");S.bHasPrefetchedNavigationTargetActions=true;return r({});});});}return S.oPromiseLinks;};S.hasDistinctSemanticObject=function(s,o){return s.some(function(a){return!!o[a];});};S.getJSONModel=function(){var m=sap.ui.getCore().getModel("$sapuicompSemanticObjectController_DistinctSemanticObjects");if(m&&!q.isEmptyObject(m.getData())){return m;}m=new J({distinctSemanticObjects:{}});m.setDefaultBindingMode(B.OneTime);m.setSizeLimit(1000);sap.ui.getCore().setModel(m,"$sapuicompSemanticObjectController_DistinctSemanticObjects");return m;};S.destroyDistinctSemanticObjects=function(){S.oSemanticObjects={};S.oNavigationTargetActions={};S.oPromise=null;S.oPromiseActions=null;S.bHasPrefetchedDistinctSemanticObjects=false;S.bHasPrefetchedNavigationTargetActions=false;var m=sap.ui.getCore().getModel("$sapuicompSemanticObjectController_DistinctSemanticObjects");if(m){m.destroy();}};return S;},true);
