/*
 * ! SAPUI5

		(c) Copyright 2009-2019 SAP SE. All rights reserved
	
 */
sap.ui.define(['sap/ui/thirdparty/jquery','sap/ui/base/ManagedObject','sap/m/library','sap/ui/comp/library','./ColumnsController','./FilterController','./GroupController','./SortController','./DimeasureController','./SelectionController','./Util','./ChartWrapper','./SelectionWrapper','./ColumnHelper','sap/m/P13nDialog','./Validator','sap/ui/model/json/JSONModel','sap/ui/Device','sap/ui/model/BindingMode'],function(q,M,a,C,b,F,G,S,D,c,U,d,e,f,P,V,J,g,B){"use strict";var h=M.extend("sap.ui.comp.personalization.Controller",{constructor:function(i,s){M.apply(this,arguments);},metadata:{library:"sap.ui.comp",properties:{setting:{type:"object",defaultValue:{}},resetToInitialTableState:{type:"boolean",defaultValue:true},columnKeys:{type:"string[]",defaultValue:[]}},associations:{table:{type:"object",multiple:false}},events:{beforePotentialTableChange:{},afterPotentialTableChange:{},afterP13nModelDataChange:{parameters:{persistentData:{type:"object"},persistentDataChangeType:{type:"sap.ui.comp.personalization.ChangeType"},runtimeDeltaData:{type:"object"},runtimeDeltaDataChangeType:{type:"sap.ui.comp.personalization.ChangeType"}}},requestColumns:{parameters:{columnKeys:{type:"string"}}},dialogAfterClose:{},dialogAfterOpen:{},dialogConfirmedReset:{}}}});h.prototype.applySettings=function(s){M.prototype.applySettings.apply(this,arguments);this._initialize();};h.prototype._initialize=function(){this._bInitCalled=true;var t=this.getTable();if(!t){throw"The table instance should be passed into constructor.";}this._createSettingCurrent(this.getSetting());var i=t.getColumns();if(!this.getColumnKeys().length){this.setProperty("columnKeys",U.getColumnKeys(i),true);}var m=this._createInternalModel(this.getColumnKeys());this._callControllers(this._oSettingCurrent,"initializeInternalModel",m);this._oColumnHelper=new f({callbackOnSetVisible:this._onSetVisible.bind(this),callbackOnSetSummed:this._onSetSummed.bind(this)});this._oColumnHelper.addColumns(i);this._callControllers(this._oSettingCurrent,"setColumnHelper",this._oColumnHelper);this._callControllers(this._oSettingCurrent,"setTriggerModelChangeOnColumnInvisible");this._callControllers(this._oSettingCurrent,"setTable",t);this._callControllers(this._oSettingCurrent,"setColumnKeys",this.getColumnKeys());this._callControllers(this._oSettingCurrent,"setIgnoreColumnKeys");this._callControllers(this._oSettingCurrent,"checkConsistency");this._callControllers(this._oSettingCurrent,"calculateIgnoreData");var j=h._getOrderedColumnKeys(this._oColumnHelper.getColumnMap(),this.getColumnKeys());this._extendModelStructure(j);this._callControllers(this._oSettingCurrent,"calculateControlData");this._suspendTable();this._syncTableUi();this._resumeTable(true);this._fireChangeEvent();};h.prototype.init=function(){this._oDialog=null;this._bInitCalled=false;this._bSuspend=false;this._bUnconfirmedResetPressed=false;this._oColumnHelper=null;this._oSettingCurrent={};};h.prototype.setSetting=function(s){if(this._bInitCalled){throw"The setting instance should be passed only into constructor.";}s=this.validateProperty("setting",s);this.setProperty("setting",s,true);return this;};h.prototype.setResetToInitialTableState=function(r){if(this._bInitCalled){throw"The resetToInitialTableState property should be passed only into constructor.";}r=this.validateProperty("resetToInitialTableState",r);this.setProperty("resetToInitialTableState",r,true);return this;};h.prototype.setColumnKeys=function(i){if(this._bInitCalled){throw"The columnKeys array should be passed only into constructor.";}i=this.validateProperty("columnKeys",i);var j=i.filter(function(s,I){var k=i.indexOf(s,I+1)>-1;if(k){q.sap.log.warning("The provided columnKeys is inconsistent as columnKey "+s+" is not unique and therefore the duplicate entry is deleted from columnKeys.");}return!k;});this.setProperty("columnKeys",j,true);return this;};h.prototype.setTable=function(t){if(this._bInitCalled){throw"The table instance should be passed only into constructor.";}this.setAssociation("table",t);return this;};h.prototype._createSettingCurrent=function(s){var t=U.getTableType(this.getTable());var i,T;switch(t){case C.personalization.TableType.ChartWrapper:i=[a.P13nPanelType.dimeasure,a.P13nPanelType.sort,a.P13nPanelType.filter];break;case C.personalization.TableType.SelectionWrapper:i=[a.P13nPanelType.selection];break;default:i=[a.P13nPanelType.columns,a.P13nPanelType.sort,a.P13nPanelType.filter,a.P13nPanelType.group];}for(T in s){if(s[T].visible===false&&i.indexOf(T)>-1){i.splice(i.indexOf(T),1);}if(s[T].visible===true&&i.indexOf(T)<0){i.push(T);}}i.forEach(function(T){this._oSettingCurrent[T]={visible:true,controller:(s[T]&&s[T].controller)?s[T].controller:this._controllerFactory(T),payload:(s[T]&&s[T].payload)?s[T].payload:undefined,ignoreColumnKeys:(s[T]&&s[T].ignoreColumnKeys)?s[T].ignoreColumnKeys:[],triggerModelChangeOnColumnInvisible:(s[T]&&s[T].triggerModelChangeOnColumnInvisible)?s[T].triggerModelChangeOnColumnInvisible:undefined};},this);};h.prototype._mixSetting=function(s,o){if(!o){return s;}for(var t in o){if(o[t].visible===true&&s[t]&&s[t].visible===true){o[t].controller=s[t].controller;o[t].payload=o[t].payload||s[t].payload;}}return o;};h.prototype.openDialog=function(s){this._suspendTable();this._prepareDialogUi();var o=this._mixSetting(this._oSettingCurrent,s);this._oDialog=new P(this.getId()+"-P13nDialog",{stretch:g.system.phone,showReset:(s&&s.showReset!==undefined)?s.showReset:true,showResetEnabled:{path:'$sapuicomppersonalizationBaseController>/isDirty'},initialVisiblePanelType:this._oInitialVisiblePanelType,validationExecutor:function(){var T=U.getTableType(this.getTable());var j=this._oColumnHelper.getColumnMap();var k=this._callControllers(o,"getUnionData",this._getControlDataInitial(),this._getControlDataReduce());return V.checkGroupAndColumns(T,o,j,k,[]).then(function(r){var l=this._callControllers(o,"getUnionData",this._getControlDataBase(),this._getControlDataReduce());var m=this._callControllers(o,"getUnionData",this._getControlDataInitial(),l);var n=this._callControllers(o,"getChangeData",m,this._getAlreadyKnownPersistentData());return V.checkSaveChanges(T,o,n,r);}.bind(this)).then(function(r){return V.checkChartConsistency(T,o,k,r);}).then(function(r){return r;});}.bind(this)});this._oDialog.setModel(this._getInternalModel(),"$sapuicomppersonalizationBaseController");this._oDialog.toggleStyleClass("sapUiSizeCompact",!!q(this.getTable().getDomRef()).closest(".sapUiSizeCompact").length);if(s&&s.contentWidth){this._oDialog.setContentWidth(s.contentWidth);}if(s&&s.contentHeight){this._oDialog.setContentHeight(s.contentHeight);}if(s&&s.styleClass){this._oDialog.addStyleClass(s.styleClass);}var p=this._callControllers(o,"getPanel");var i=[];for(var t in p){if(p[t]){i.push(p[t]);}}Promise.all(i).then(function(j){j.forEach(function(k){this._oDialog.addPanel(k);},this);this._oDialog.attachOk(this._handleDialogOk,this);this._oDialog.attachCancel(this._handleDialogCancel,this);this._oDialog.attachReset(this._handleDialogReset,this);this._oDialog.attachAfterClose(this._handleDialogAfterClose,this);this._oDialog.open();this.fireDialogAfterOpen();}.bind(this));};h.prototype.addColumns=function(o){var t=this.getTable();Object.keys(o).forEach(function(s){if(!o[s].getParent()){t.addDependent(o[s]);}});this._oColumnHelper.addColumnMap(o);};h.prototype.getDataSuiteFormatSnapshot=function(){this._callControllers(this._oSettingCurrent,"calculateControlData");var r={};this._callControllers(this._oSettingCurrent,"getDataSuiteFormatSnapshot",r);return r;};h.prototype.setDataSuiteFormatSnapshot=function(r,p,i){if(i){U.convertSelectOptions(r,this._oColumnHelper.getColumnMap());U.convertFilters(p,this._oColumnHelper.getColumnMap());}var R=this._callControllers(this._oSettingCurrent,"getDataSuiteFormat2Json",r);this._setRuntimeAndPersonalizationData(R,p);};h.prototype.setPersonalizationDataAsDataSuiteFormat=function(r,i){if(i){U.convertSelectOptions(r,this._oColumnHelper.getColumnMap());}var R=this._callControllers(this._oSettingCurrent,"getDataSuiteFormat2Json",r);this._setRuntimeAndPersonalizationData(R,R);};h.prototype.setPersonalizationData=function(p,i){if(i){U.convertFilters(p,this._oColumnHelper.getColumnMap());}this._setRuntimeAndPersonalizationData(p,p);};h.prototype.resetPersonalization=function(r){r=this._determineResetType(r);if(r===C.personalization.ResetType.ResetFull){this._resetFull();}else{this._resetPartial();}this._setRuntimeAndPersonalizationData(this._getControlDataBase(),this._getVariantData());};h.prototype.addToSettingIgnoreColumnKeys=function(i){if(this._isEqualAdditionalIgnoreColumnKeys(i)){return this;}this._callControllers(this._oSettingCurrent,"setAdditionalIgnoreColumnKeys",i);this._callControllers(this._oSettingCurrent,"calculateIgnoreData");this._requestMissingColumnsWithoutIgnore(this._getControlDataBase());this._suspendTable();this._syncTableUi();this._resumeTable(true);this._fireChangeEvent();return this;};h.prototype._handleDialogReset=function(){this._bUnconfirmedResetPressed=true;var r=this._determineResetType();if(r===C.personalization.ResetType.ResetFull){this._resetFull();}else{this._resetPartial();}this._syncDialogUi();};h.prototype._handleDialogOk=function(){this._oDialog.detachOk(this._handleDialogOk,this);if(this._bUnconfirmedResetPressed){this.fireDialogConfirmedReset();}setTimeout(function(){this._postDialogUi(this._getControlDataReduce());this._syncTableUi();var i=function(E){var m=false;for(var t in this._oSettingCurrent){m=m||E.getParameter("runtimeDeltaDataChangeType")[t]==="ModelChanged";if(m){break;}}var I=!m;this._resumeTable(I);};this.attachEventOnce("afterP13nModelDataChange",i,this);this._fireChangeEvent();}.bind(this),0);this._oDialog.close();};h.prototype._handleDialogCancel=function(){this._oDialog.detachCancel(this._handleDialogCancel,this);setTimeout(function(){this._postDialogUi(this._getBeforeOpenData());this._resumeTable(false);}.bind(this),0);this._oDialog.close();};h.prototype._handleDialogAfterClose=function(){this._oInitialVisiblePanelType=this._oDialog.getVisiblePanel()?this._oDialog.getVisiblePanel().getType():this._getInitialVisiblePanelType();this._bUnconfirmedResetPressed=false;this.fireDialogAfterClose();if(this._oDialog){this._oDialog.destroy();this._oDialog=null;}};h.prototype._getInitialVisiblePanelType=function(){for(var t in this._oSettingCurrent){return t;}};h.prototype._suspendTable=function(){if(U.getTableBaseType(this.getTable())===C.personalization.TableType.Table){this._bSuspend=true;}};h.prototype._resumeTable=function(i){i=(i===undefined)?true:i;var t=this.getTable();if(this._bSuspend){if(t){if(i){t.invalidate();}}this._bSuspend=false;}};h.prototype._requestMissingColumnsWithoutIgnore=function(j){var o=this._callControllers(this._oSettingCurrent,"determineMissingColumnKeys",j);var m=U.getUnionOfColumnKeys(o);if(!m.length){return[];}this.fireRequestColumns({columnKeys:m});return m;};h.prototype._extendModelStructure=function(i){if(!i.length){return;}var j=this._callControllers(this._oSettingCurrent,"createColumnKeysStructure",i);var o=this._callControllers(this._oSettingCurrent,"getTable2Json",j);this._callControllers(this._oSettingCurrent,"extendControlDataInitial",o);this._callControllers(this._oSettingCurrent,"extendVariantDataInitial",o);this._callControllers(this._oSettingCurrent,"extendControlDataBase",o);this._callControllers(this._oSettingCurrent,"extendAlreadyKnownRuntimeData",o);this._callControllers(this._oSettingCurrent,"extendAlreadyKnownPersistentData",o);};h.prototype._setRuntimeAndPersonalizationData=function(r,p){r=(r===null?{}:r);if(!this._sanityCheck(r)){return;}p=(p===null?{}:p);if(!this._sanityCheck(p)){return;}this._setVariantData(p);this._extendModelStructure(this._requestMissingColumnsWithoutIgnore(r));var j=this._callControllers(this._oSettingCurrent,"getUnionData",this._getControlDataInitial(),p);this._callControllers(this._oSettingCurrent,"setVariantDataInitial2Model",j);var R=this._callControllers(this._oSettingCurrent,"getUnionData",this._getControlDataInitial(),r);this._callControllers(this._oSettingCurrent,"fixConflictWithIgnore",R,this._getIgnoreData());this._callControllers(this._oSettingCurrent,"setControlDataBase2Model",R);for(var t in this._oSettingCurrent){this._calculateChangeType(t,R);}this._suspendTable();this._syncTableUi();this._resumeTable(true);this._fireChangeEvent();};h.prototype._prepareDialogUi=function(){var j=this._callControllers(this._oSettingCurrent,"createColumnKeysStructure",this.getColumnKeys());this._extendModelStructure(this._requestMissingColumnsWithoutIgnore(j));this._callControllers(this._oSettingCurrent,"setBeforeOpenData2Model",this._getControlDataBase());this._callControllers(this._oSettingCurrent,"calculateControlDataReduce");var o=this._callControllers(this._oSettingCurrent,"getTable2JsonTransient",j);this._callControllers(this._oSettingCurrent,"calculateTransientData",o);};h.prototype._postDialogUi=function(j){this._callControllers(this._oSettingCurrent,"updateControlDataBaseFromJson",j);this._callControllers(this._oSettingCurrent,"setBeforeOpenData2Model",undefined);this._callControllers(this._oSettingCurrent,"setControlDataReduce2Model",undefined);this._callControllers(this._oSettingCurrent,"setTransientData2Model",undefined);};h.prototype._syncDialogUi=function(){this._callControllers(this._oSettingCurrent,"calculateControlDataReduce");};h.prototype._syncTableUi=function(){this._callControllers(this._oSettingCurrent,"calculateControlData");this._callControllers(this._oSettingCurrent,"syncJson2Table",this._getControlData());};h.prototype._resetFull=function(){this._setVariantData(undefined);this._callControllers(this._oSettingCurrent,"setControlDataBase2Model",this._getControlDataInitial());};h.prototype._resetPartial=function(){this._callControllers(this._oSettingCurrent,"setControlDataBase2Model",this._getVariantDataInitial());};h.prototype._calculateChangeType=function(t,j){var s={};s[t]=this._oSettingCurrent[t];this._callControllers(s,"calculatePersistentChangeTypesFromJson",j,this._determineResetType());var p=this._getPersistentDataChangeType();var i=false;for(t in this._oSettingCurrent){if(p[t]!==C.personalization.ChangeType.Unchanged){i=true;}}this._setIsDirty(i);};h.prototype._fireChangeEvent=function(r){var o={};var i=this._callControllers(this._oSettingCurrent,"getUnionData",this._getControlDataInitial(),this._getControlData());o.runtimeDeltaDataChangeType=this._callControllers(this._oSettingCurrent,"getChangeType",i,this._getAlreadyKnownRuntimeData());o.persistentDeltaDataChangeType=this._getPersistentDeltaDataChangeType();o.persistentDataChangeType=this._getPersistentDataChangeType();if(!U.hasChangedType(o.runtimeDeltaDataChangeType)&&!U.hasChangedType(o.persistentDeltaDataChangeType)){return;}var j=this._callControllers(this._oSettingCurrent,"getChangeData",i,this._getAlreadyKnownRuntimeData());o.runtimeDeltaData=U.removeEmptyProperty(U.copy(j));var p=this._callControllers(this._oSettingCurrent,"getChangeData",this._getControlDataBase(),this._getControlDataInitial());o.persistentData=U.removeEmptyProperty(p);this._callControllers(this._oSettingCurrent,"setAlreadyKnownRuntimeData2Model",this._getControlData());this._callControllers(this._oSettingCurrent,"setAlreadyKnownPersistentData2Model",this._getControlDataBase());delete o.persistentDeltaDataChangeType;this.fireAfterP13nModelDataChange(o);};h.prototype._onSetVisible=function(v,s){if(v){var i=U.getUnionOfAttribute(this._oSettingCurrent,"ignoreColumnKeys");if(i.indexOf(s)>-1){throw"The provided 'ignoreColumnKeys' are inconsistent. No column specified as ignored is allowed to be visible. "+this;}}};h.prototype._onSetSummed=function(i,o){this._oSettingCurrent.columns.controller._onColumnTotal({column:o,isSummed:i});};h.prototype._getArgumentsByType=function(A,t){var r=[],o=null;if(A&&A.length&&t){A.forEach(function(i){if(i&&i[t]&&typeof i[t]!=="function"){o={};o[t]=i[t];r.push(o);}else{r.push(i);}});}return r;};h.prototype._callControllers=function(s,m){var o,i,A;var r={},j=Array.prototype.slice.call(arguments,2);for(var t in s){o=i=A=null;o=s[t];i=o.controller;if(!i||!o.visible||!i[m]){continue;}A=this._getArgumentsByType(j,t);if(m==="getPanel"){A.push(o.payload);}else if(m==="setIgnoreColumnKeys"){A.push(o.ignoreColumnKeys);}else if(m==="setTriggerModelChangeOnColumnInvisible"){A.push(o.triggerModelChangeOnColumnInvisible);}var R=i[m].apply(i,A);if(R!==null&&R!==undefined&&R[t]!==undefined){r[t]=R[t];}else{r[t]=R;}}return r;};h.prototype._sanityCheck=function(j){return true;};h.prototype._createInternalModel=function(i){var m=new J();m.setDefaultBindingMode(B.TwoWay);m.setSizeLimit(10000);this.setModel(m,"$sapuicomppersonalizationBaseController");return m;};h.prototype._getInternalModel=function(){return this.getModel("$sapuicomppersonalizationBaseController");};h.prototype._getInternalModelData=function(s){return this._getInternalModel().getProperty("/"+s);};h.prototype._getControlDataInitial=function(){return this._getInternalModelData("controlDataInitial");};h.prototype._getControlDataBase=function(){return this._getInternalModelData("controlDataBase");};h.prototype._getIgnoreData=function(){return this._getInternalModelData("ignoreData");};h.prototype._getPersistentDataChangeType=function(){return this._getInternalModelData("persistentDataChangeType");};h.prototype._getPersistentDeltaDataChangeType=function(){return this._getInternalModelData("persistentDeltaDataChangeType");};h.prototype._getControlData=function(){return this._getInternalModelData("controlData");};h.prototype._getControlDataReduce=function(){return this._getInternalModelData("controlDataReduce");};h.prototype._getTransientData=function(){return this._getInternalModelData("transientData");};h.prototype._getAlreadyKnownRuntimeData=function(){return this._getInternalModelData("alreadyKnownRuntimeData");};h.prototype._getAlreadyKnownPersistentData=function(){return this._getInternalModelData("alreadyKnownPersistentData");};h.prototype._getVariantDataInitial=function(){return this._getInternalModelData("variantDataInitial");};h.prototype._getBeforeOpenData=function(){return this._getInternalModelData("beforeOpenData");};h.prototype._setVariantData=function(j){this._getInternalModel().setProperty("/variantData",j?U.copy(j):undefined);};h.prototype._setIsDirty=function(i){this._getInternalModel().setProperty("/isDirty",i);};h.prototype._getVariantData=function(){return this._getInternalModel().getProperty("/variantData");};h.prototype._getControllers=function(){return this._oSettingCurrent;};h.prototype._controllerFactory=function(t){var i=this;switch(t){case a.P13nPanelType.columns:return new b({afterColumnsModelDataChange:function(){i._fireChangeEvent();},beforePotentialTableChange:function(){i.fireBeforePotentialTableChange();},afterPotentialTableChange:function(){i.fireAfterPotentialTableChange();},afterPotentialModelChange:function(E){i._calculateChangeType(t,E.getParameter("json"));}});case a.P13nPanelType.sort:return new S({afterSortModelDataChange:function(){i._fireChangeEvent();},beforePotentialTableChange:function(){i.fireBeforePotentialTableChange();},afterPotentialTableChange:function(){i.fireAfterPotentialTableChange();},afterPotentialModelChange:function(E){i._calculateChangeType(t,E.getParameter("json"));}});case a.P13nPanelType.filter:return new F({afterFilterModelDataChange:function(){i._fireChangeEvent();},beforePotentialTableChange:function(){i.fireBeforePotentialTableChange();},afterPotentialTableChange:function(){i.fireAfterPotentialTableChange();},afterPotentialModelChange:function(E){i._calculateChangeType(t,E.getParameter("json"));}});case a.P13nPanelType.group:return new G({afterGroupModelDataChange:function(){i._fireChangeEvent();},beforePotentialTableChange:function(){i.fireBeforePotentialTableChange();},afterPotentialTableChange:function(){i.fireAfterPotentialTableChange();},afterPotentialModelChange:function(E){i._calculateChangeType(t,E.getParameter("json"));}});case a.P13nPanelType.dimeasure:return new D({afterDimeasureModelDataChange:function(){i._fireChangeEvent();},beforePotentialTableChange:function(){i.fireBeforePotentialTableChange();},afterPotentialTableChange:function(){i.fireAfterPotentialTableChange();},afterPotentialModelChange:function(E){i._calculateChangeType(t,E.getParameter("json"));}});case a.P13nPanelType.selection:return new c({afterSelectionModelDataChange:function(){i._fireChangeEvent();},beforePotentialTableChange:function(){i.fireBeforePotentialTableChange();},afterPotentialTableChange:function(){i.fireAfterPotentialTableChange();},afterPotentialModelChange:function(E){i._calculateChangeType(t,E.getParameter("json"));}});default:throw"Panel type '"+t+"' is not valid";}};h.prototype.getTable=function(){var t=this.getAssociation("table");if(typeof t==="string"){t=sap.ui.getCore().byId(t);}return t;};h._getOrderedColumnKeys=function(o,i){var m=Object.keys(o);return i.reduce(function(r,s){if(m.indexOf(s)>-1){r.push(s);}return r;},[]);};h.prototype.exit=function(){var t;this._resumeTable(false);if(this._oDialog){this._oDialog.destroy();this._oDialog=null;}this._callControllers(this._oSettingCurrent,"destroy");for(t in this._oSettingCurrent){this._oSettingCurrent[t]=null;}this._oSettingCurrent=null;this._oColumnHelper=null;};h.prototype._determineResetType=function(r){r=r||(this.getResetToInitialTableState()?C.personalization.ResetType.ResetFull:C.personalization.ResetType.ResetPartial);if(r===C.personalization.ResetType.ResetFull||this._getVariantData()===undefined){return C.personalization.ResetType.ResetFull;}return C.personalization.ResetType.ResetPartial;};h.prototype._isEqualAdditionalIgnoreColumnKeys=function(i){var j=this._callControllers(this._oSettingCurrent,"isEqualAdditionalIgnoreColumnKeys",i);var I=true;for(var t in j){I=I&&j[t];}return I;};h.SyncReason={ResetFull:14,ResetPartial:15,NewModelDataMixedWithVariant:7};return h;},true);
