/*
 * ! SAPUI5

		(c) Copyright 2009-2019 SAP SE. All rights reserved
	
 */
sap.ui.define(['sap/ui/thirdparty/jquery','sap/ui/comp/library','sap/ui/base/EventProvider','sap/ui/comp/odata/ODataType','sap/ui/comp/odata/MetadataAnalyser','sap/ui/comp/util/FormatUtil','sap/ui/comp/util/DateTimeUtil','sap/base/Log','sap/m/Token','sap/ui/model/Filter','sap/ui/model/FilterOperator'],function(q,l,E,O,M,F,D,L,T,a,b){"use strict";var c=l.smartfilterbar.DisplayBehaviour;var A=l.ANALYTICAL_PARAMETER_PREFIX;var d;var B=E.extend("sap.ui.comp.providers.BaseValueListProvider",{constructor:function(p){E.call(this);this.sFieldName=p.fieldName;this.oControl=p.control;this.oODataModel=p.model;this.oFilterModel=p.filterModel;this.oFilterProvider=p.filterProvider;this.sDisplayFormat=p.displayFormat;this._oDateFormatSettings=p.dateFormatSettings;if(!this._oDateFormatSettings){this._oDateFormatSettings={};}if(!this._oDateFormatSettings.hasOwnProperty("UTC")){this._oDateFormatSettings["UTC"]=true;}this._fieldViewMetadata=p.fieldViewMetadata;this.sValueListEntitySetName=null;this.bResolveInOutParams=(p.resolveInOutParams===false)?false:true;this.sDisplayBehaviour=p.displayBehaviour;this.sDDLBDisplayBehaviour=this.sDisplayBehaviour;if(!this.sDDLBDisplayBehaviour||this.sDDLBDisplayBehaviour===c.auto){this.sDDLBDisplayBehaviour=this.oFilterProvider?this.oFilterProvider.sDefaultDropDownDisplayBehaviour:c.descriptionOnly;}this._sType=p.type;this._sMaxLength=p.maxLength;this.sPropertyTypePath="";if(this.bResolveInOutParams&&!this.oFilterModel&&!this.oFilterProvider){this._resolvePropertyPath();}if(p.loadAnnotation&&p.fullyQualifiedFieldName){this._oMetadataAnalyser=p.metadataAnalyser;this._sFullyQualifiedFieldName=p.fullyQualifiedFieldName;this._attachAnnotationLoadOnRender();}else{if(p.loadAnnotation){L.error("BaseValueListProvider","loadAnnotation is true, but no fullyQualifiedFieldName set for field '"+(this._sFullyQualifiedFieldName||this.sFieldName)+"'! Please check your annotations");}this._onAnnotationLoad({primaryValueListAnnotation:p.annotation,additionalAnnotations:p.additionalAnnotations});}}});B.prototype._attachAnnotationLoadOnRender=function(){this.oBeforeRenderingEventDelegate={onBeforeRendering:function(){this.oControl.removeEventDelegate(this.oBeforeRenderingEventDelegate,this);delete this.oBeforeRenderingEventDelegate;if(!this._bValueListRequested){if(this.bInitialised){if(this._onMetadataInitialised&&this.sAggregationName&&!this.bTypeAheadEnabled&&this.oControl.$()){this._onMetadataInitialised();}}else{this._loadAnnotation();}}}};this.oControl.addEventDelegate(this.oBeforeRenderingEventDelegate,this);};B.prototype.loadAnnotation=function(){if(this.oBeforeRenderingEventDelegate){this.oControl.removeEventDelegate(this.oBeforeRenderingEventDelegate,this);delete this.oBeforeRenderingEventDelegate;}if(this.oAfterRenderingEventDelegate){this.oControl.removeEventDelegate(this.oAfterRenderingEventDelegate,this);delete this.oAfterRenderingEventDelegate;}this._loadAnnotation();};B.prototype._loadAnnotation=function(){if(!this._bValueListRequested){this._bValueListRequested=true;if(!this._oMetadataAnalyser){this._oMetadataAnalyser=new M(this.oODataModel);this._bCleanupMetadataAnalyser=true;}this._oMetadataAnalyser.getValueListAnnotationLazy(this._sFullyQualifiedFieldName).then(this._onAnnotationLoad.bind(this),function(e){this._oError=e;this.bInitialised=true;L.debug(e);}.bind(this));}};B.prototype.attachValueListChanged=function(f,o){this.attachEvent("valueListChanged",f,o);};B.prototype.detachValueListChanged=function(f,o){this.detachEvent("valueListChanged",f,o);};B.prototype._onAnnotationLoad=function(v){this.oPrimaryValueListAnnotation=v.primaryValueListAnnotation;this.additionalAnnotations=v.additionalAnnotations;this._resolveAnnotationData(this.oPrimaryValueListAnnotation);this.bInitialised=true;if(this._fBaseValueListProviderResolve){this._fBaseValueListProviderResolve();}if(this._onMetadataInitialised&&this.sAggregationName&&!this.bTypeAheadEnabled&&this.oControl.$()){this._onMetadataInitialised();}};B.prototype._resolvePropertyPath=function(){var o=this.oControl.getBindingInfo("value"),p,P,e;if(o&&o.parts){p=o.parts[0]?o.parts[0].path:"";}if(p){e=p.split("/");if(e.length>1){P=e[e.length-1];this.sPropertyTypePath=p.replace("/"+P,"");}}};B.prototype._resolveAnnotationData=function(o){var e=0,i=0,C,f,t,g,h,j;if(this.oODataModel&&o){this.bSupportBasicSearch=o.isSearchSupported;this.sValueListTitle=o.valueListTitle||o.qualifier;this.sKey=o.keyField;this._aKeys=o.keys;this.sValueListEntitySetName=o.valueListEntitySetName;this.mInParams=o.inParams;this.mOutParams=o.outParams;this.sTokenDisplayBehaviour=this.sDisplayBehaviour;if(!this.sTokenDisplayBehaviour||this.sTokenDisplayBehaviour===c.auto){this.sTokenDisplayBehaviour=this.oFilterProvider?this.oFilterProvider.sDefaultTokenDisplayBehaviour:c.descriptionAndId;}if(!o.descriptionField){this.sTokenDisplayBehaviour=c.idOnly;}this.sDescription=o.descriptionField||this.sKey;if(this.sValueListEntitySetName&&this.sKey){this._aCols=[];this.aSelect=[];C=o.valueListFields;e=C.length;for(i=0;i<e;i++){f=C[i];t=null;g=null;h=undefined;j=undefined;if(f.type==="Edm.Boolean"){t="boolean";}else if(f.type==="Edm.DateTime"&&f.displayFormat==="Date"){t="date";j=this._oDateFormatSettings;h={displayFormat:"Date"};}else if(f.type==="Edm.Decimal"){t="decimal";h={precision:f.precision,scale:f.scale};}else if(f.type==="Edm.String"){if(f.isCalendarDate){t="stringdate";}else{t="string";}}g=O.getType(f.type,j,h,f.isCalendarDate);if(f.visible){this._aCols.push({label:f.fieldLabel,tooltip:f.quickInfo||f.fieldLabel,type:t,oType:g,width:F.getWidth(f,15),template:f.name,sort:f.sortable?f.name:undefined,sorted:f.sortable&&f.name===this.sKey,sortOrder:"Ascending"});}this.aSelect.push(f.name);}if(o.descriptionField){this.aSelect.push(o.descriptionField);}}else{if(!this.sKey){L.error("BaseValueListProvider","key for ValueListEntitySetName '"+this.sValueListEntitySetName+"' missing! Please check your annotations");}}}};B.prototype._getFilterData=function(){var o,f={};if(this.oFilterProvider&&this.oFilterProvider._oSmartFilter){o=this.oFilterProvider._oSmartFilter.getFilterData();if(this.sFieldName&&(this.sFieldName.indexOf(A)===0)){Object.keys(o).forEach(function(n){var e=n.split(A);f[e[e.length-1]]=o[n];});return f;}}return o;};B.prototype._setFilterData=function(f){var o=f,e={};if(this.oFilterProvider){if(this.sFieldName&&(this.sFieldName.indexOf(A)===0)){Object.keys(f).forEach(function(n){e[A+n]=f[n];});o=e;}this.oFilterProvider.setFilterData(o);}};B.prototype._adaptEdmDateTimePropertyValue=function(v,V){var r=V;if(V instanceof Date&&this.oPrimaryValueListAnnotation&&this.oPrimaryValueListAnnotation.fields){var p=null;this.oPrimaryValueListAnnotation.fields.some(function(P){if(P.name===v){p=P;}return p!==null;});if(p&&p.type==="Edm.DateTime"&&p.displayFormat==="Date"){r=D.utcToLocal(V);}}return r;};B.prototype._calculateFilterInputData=function(){var s,v,o=null,e;delete this.mFilterInputData;if(this.oFilterProvider&&this.oFilterProvider._oSmartFilter){o=this._getFilterData();}else if(this.oFilterModel){o=this.oFilterModel.getData();}if(this.mInParams&&o){this.mFilterInputData={};this.aFilterField=[];for(s in this.mInParams){if(s){v=this.mInParams[s];v=v.replace("/",".");if(v!==this.sKey){if(o[s]){this.mFilterInputData[v]=o[s];if(typeof this.mFilterInputData[v]==="object"){if(this.mFilterInputData[v].ranges&&this.mFilterInputData[v].ranges.length>0){for(var i=0;i<this.mFilterInputData[v].ranges.length;i++){this.mFilterInputData[v].ranges[i].keyField=v;}}}this.aFilterField.push(v);}}}}}else if(this.oODataModel&&this.bResolveInOutParams){e=this.oControl.getBindingContext();if(this.mInParams&&e){this.mFilterInputData={};this.aFilterField=[];for(s in this.mInParams){if(s){v=this.mInParams[s];v=v.replace("/",".");if(v!==this.sKey){var p=this.sPropertyTypePath?this.sPropertyTypePath+"/"+s:s;var V=e.getProperty(p);if(V){V=this._adaptEdmDateTimePropertyValue(v,V);this.mFilterInputData[v]=V;this.aFilterField.push(v);}}}}}}};B.prototype._calculateAndSetFilterOutputData=function(e){var s,v,f=null,o,g,n,i,h,j,k;if(this.mOutParams&&e&&(this.oFilterProvider||this.oFilterModel)){f={};h=function(I){return I.key===n.key;};j=function(R){if(n.value1 instanceof Date&&R.value1 instanceof Date){return R.operation==="EQ"&&n.value1.getTime()===R.value1.getTime();}return R.operation==="EQ"&&n.value1===R.value1;};k=function(R){return R.operation==="EQ"&&n.key===R.value1;};for(s in this.mOutParams){if(s){var m=this.oFilterProvider&&this.oFilterProvider._getFieldMetadata(s);v=this.mOutParams[s];if(v!==this.sKey){g=null;i=e.length;while(i--){o=e[i];if(o[v]){var V=o[v];var p=m&&(m.type==="Edm.DateTime"||!m.hasValueListAnnotation);if(p){if(m.type==="Edm.DateTime"&&this._oDateFormatSettings.UTC==true){V=D.utcToLocal(V);}n={"exclude":false,"operation":"EQ","keyField":s,"value1":V,"value2":null};}else{n={key:V};}if(!f[s]){if(!g&&this.oFilterModel){g=this.oFilterModel.getData();}if(g&&g[s]&&g[s].items){f[s]=g[s];if(!f[s].ranges){f[s].ranges=[];}}else{f[s]={items:[],ranges:[]};}}var r=f[s];if(p){if(r.ranges.filter(j).length<=0){r.ranges.push(n);}}else if(r.items.filter(h).length<=0){if(!r.ranges||r.ranges.filter(k).length<=0){r.items.push(n);}}}}}}}if(f){if(this.oFilterProvider){this._setFilterData(f);if(!q.isEmptyObject(f)){this.fireEvent("valueListChanged",{"changes":Object.keys(f)});}}else if(this.oFilterModel){this.oFilterModel.setData(f,true);}}}else if(this.oODataModel&&this.bResolveInOutParams){this._calculateAndSetODataModelOutputData(e[0]);}};B.prototype._calculateAndSetODataModelOutputData=function(o){var e,s,v,p,V,C={};if(o&&this.mOutParams){e=this.oControl.getBindingContext();for(s in this.mOutParams){if(s){v=this.mOutParams[s];if(v!==this.sKey){V=o[v];C[s]=V;p=this.sPropertyTypePath?this.sPropertyTypePath+"/"+s:s;this.oODataModel.setProperty(p,V,e,true);}}}if(C&&!q.isEmptyObject(C)){this.fireEvent("valueListChanged",{"changes":C});}}};B.prototype._handleRowsSelect=function(e){var i,j,k,t,o,f=[],C,g;if(!(this.oControl&&this.oControl.addToken)){return;}C=this.oControl.getTokens();for(i=0;i<e.length;i++){k=e[i][this.sKey];t=e[i][this.sDescription];if(k||(k==="")){t=F.getFormattedExpressionFromDisplayBehaviour(this.sTokenDisplayBehaviour,k,t);o=new T({key:k,text:t,tooltip:t});o.data("row",e[i]);f.push(o);for(j=0;j<C.length;j++){g=C[j];var s=g.getKey();if(s&&s===k){break;}else if(g.data("range")&&(!g.data("range").exclude)&&(g.data("range").operation==="EQ")&&(g.data("range").value1===k)){break;}}if(j<C.length){C.splice(j,1);}}}if(f.length){this.oControl.setTokens(C.concat(f));}};B.prototype.readData=function(I){if(!d){d=sap.ui.require("sap/ui/comp/smartfilterbar/FilterProvider");}var f=[],s;this._oReadPromise=new Promise(function(r){this._fBaseValueListProviderResolve=r;}.bind(this));if(this.bInitialised){this._fBaseValueListProviderResolve();}this._oReadPromise.then(function(){this._fBaseValueListProviderResolve=null;for(var i=0;i<I.length;i++){s=(this.sDisplayFormat==="UpperCase")?I[i].toUpperCase():I[i];f.push(new a(this.sKey,b.EQ,s));}if(!this.sValueListEntitySetName){return;}this.oODataModel.read("/"+this.sValueListEntitySetName,{filters:f,success:function(r,e){if(r){if(r.results&&r.results.length!==I.length){L.error("Expecting "+I.length+" result rows, but received "+r.results.length+" rows...");return;}var g=r.results;if(this.oControl&&this.oControl.isA("sap.m.MultiInput")&&this.oControl.getTokens().length!==I.length){g=this._getUpdatedDataModelRows(g);}this._handleRowsSelect(g);}}.bind(this),error:function(e){L.error("Error occured reading /"+this.sValueListEntitySetName);}.bind(this)});}.bind(this));};B.prototype._getUpdatedDataModelRows=function(e){var C=this.oControl.getTokens(),f=[];for(var i=0;i<C.length;i++){var o=C[i];var s=o.getKey();if(s){f.push(s);}else if(o.data("range")&&o.data("range").value1){f.push(o.data("range").value1);}}var r=[];for(var i=0;i<e.length;i++){var R=e[i][this.sKey];if(f.indexOf(R)!==-1){r.push(e[i]);}}return r;};B.prototype.destroy=function(){E.prototype.destroy.apply(this,arguments);if(this._bCleanupMetadataAnalyser&&this._oMetadataAnalyser){this._oMetadataAnalyser.destroy();}this._oMetadataAnalyser=null;if(this.oBeforeRenderingEventDelegate){this.oControl.removeEventDelegate(this.oBeforeRenderingEventDelegate);delete this.oBeforeRenderingEventDelegate;}if(this.oAfterRenderingEventDelegate){this.oControl.removeEventDelegate(this.oAfterRenderingEventDelegate);delete this.oAfterRenderingEventDelegate;}this.oControl=null;this.sFieldName=null;this.mFilterInputData=null;this.aFilterField=null;this.sValueListEntitySetName=null;this.oODataModel=null;this.oFilterModel=null;this.oFilterProvider=null;this.oPrimaryValueListAnnotation=null;this.additionalAnnotations=null;this.sDisplayFormat=null;this.bSupportBasicSearch=null;this.bInitialised=null;this._oError=null;this.sValueListTitle=null;this.sKey=null;this._aKeys=null;this.mInParams=null;this.mOutParams=null;this.sDescription=null;this.aSelect=null;this._aCols=null;this.sDDLBDisplayBehaviour=null;this.sTokenDisplayBehaviour=null;this._oDateFormatSettings=null;this._fieldViewMetadata=null;this.bIsDestroyed=true;};return B;},true);
