/*
 * SAPUI5

		(c) Copyright 2009-2019 SAP SE. All rights reserved
	
 */
sap.ui.define(["sap/ui/comp/library","sap/ui/comp/odata/MetadataAnalyser","sap/ui/comp/smartfield/AnnotationHelper","sap/base/Log","sap/ui/model/odata/_ODataMetaModelUtils","sap/ui/model/odata/ODataUtils","sap/base/assert"],function(l,M,A,L,O,a,b){"use strict";var T=l.TextArrangementType;var c=function(m,u,o){if(m){this.oMeta=m.getMetaModel();}if(o){this.oMeta=o;}this._oModel=m;this._oUtil=u;this.oAnnotation=new A();};c.prototype.getAnalyzer=function(m){if(!this._oAnalyzer){this._oAnalyzer=new M(this._oModel||m);}return this._oAnalyzer;};c.prototype.checkNavigationProperty=function(m,C){var p,P,d,r;if(C&&m){p=this._oUtil.getNavigationProperties(C);d=p.paths.length;while(d--){P=p.paths.shift();P=this._oUtil.correctPath(P);if(P===""||P===m.entitySet.name){continue;}r=this.getNavigationProperty(m.entityType,P);if(r.entitySet){m.entitySet=r.entitySet;m.entityType=r.entityType;}}}};c.prototype.getNavigationProperty=function(e,p){var n=this._getNamedProperty(p,"navigationProperty",e),t,r={};if(n){t=this.oMeta.getODataAssociationSetEnd(e,n.name);r.entitySet=this.oMeta.getODataEntitySet(t.entitySet);if(r.entitySet){r.entityType=this.oMeta.getODataEntityType(r.entitySet.entityType);}}return r;};c.prototype.startWithNavigationProperty=function(p,m){var P=p.split("/"),o;if(P&&P.length>1){o=this._getNamedProperty(P.shift(),"navigationProperty",m.entityType);}if(o){return o.name;}return null;};c.prototype.getProperty=function(m){var n=[],d,p,P,s,e,r={entityType:m.entityType,entitySet:m.entitySet};if(m){p=m.path.split("/");d=p.length;if(d>1){while(r.entityType){s=p[0];r=this.getNavigationProperty(r.entityType,s);if(r.entityType){m.entityType=r.entityType;m.entitySet=r.entitySet;n.push(p.shift());d--;}}}m.navigationPath=n.join("/");if(d>1){P=this.oMeta.getODataProperty(m.entityType,p[0]);if(P){m.property=this._getComplex(P,p,d);}return;}if(m.navigationPath){e=m.path.replace(m.navigationPath+"/","");}else{e=m.path;}P=this.oMeta.getODataProperty(m.entityType,e);m.property={property:P,typePath:m.path,valueListAnnotation:null,valueListKeyProperty:null,valueListEntitySet:null,valueListEntityType:null};}};c.prototype._getComplex=function(p,P,i){var o=p,t,C=[];while(i--){if(o){if(i===0){t=o.name;o=this._getNamedProperty(P[0],"property",o);return{typePath:t+"/"+P[0],property:o,complex:true,parents:C};}o=this.oMeta.getODataComplexType(o.type);if(o){C.push(o);}}P.shift();}};c.prototype._getNamedProperty=function(n,s,p){var r;if(p[s]){for(var i=0;i<p[s].length;i++){if(p[s][i].name===n){r=p[s][i];break;}}}return r;};c.prototype.getTextProperty2=function(m){var s,o;s=this.oAnnotation.getText(m.property.property);if(s){o=this._preprocAnnotation(s,m);this.getProperty(o);this._postprocAnnotation(o,m);}return o;};c.prototype.getUnitOfMeasure2=function(m){var s,o;s=this.oAnnotation.getUnit(m.property.property);if(s){o=this._preprocAnnotation(s,m);this.getProperty(o);this._postprocAnnotation(o,m);}return o;};c.prototype._preprocAnnotation=function(s,m){var p,o;o=this.traverseNavigationProperties(s,m.entityType);if(!o.navigationPath){o.entitySet=m.entitySet;}if(m.navigationPath){o.path=m.path.replace(m.navigationPath+"/","");}else{o.path=m.path;}if(o.navigationPath){p=s.replace(o.navigationPath+"/","");}else{p=s;}o.path=o.path.replace(m.property.property.name,p);if(o.navigationPath){o.navigationPathHelp=o.navigationPath;}return o;};c.prototype._postprocAnnotation=function(m,o){var p;if(m.navigationPathHelp){m.navigationPath=m.navigationPathHelp;}if(m.navigationPath){p=m.navigationPath;}else{p="";}if(o.navigationPath){if(p){p=o.navigationPath+"/"+p;}else{p=o.navigationPath;}}m.navigationPath=p;if(m.navigationPath){m.path=m.navigationPath+"/"+m.path;}};c.prototype.traverseNavigationProperties=function(p,e){var r={},R={},P,s,d;P=p.split("/");d=P.length;r.entityType=e;R.entityType=e;while(d--){s=P.shift();if(s===""){continue;}R=this.getNavigationProperty(r.entityType,s);if(!R.entitySet){break;}r.entityType=R.entityType;r.entitySet=R.entitySet;if(r.navigationPath){r.navigationPath=r.navigationPath+"/"+s;}else{r.navigationPath=s;}}return r;};c.prototype.getValueListAnnotationPath=function(m){var p,d;if(m.property.complex){d=m.property.parents.length-1;p=m.property.parents[d].namespace;p=p+"."+m.property.typePath;}else{p=m.entitySet.entityType+"/"+m.property.property.name;}return p;};c.prototype.getUOMValueListAnnotationPath=function(m){var p;if(m.annotations.uom){p=this.getValueListAnnotationPath(m.annotations.uom);}if(p){m.annotations.valuelistuom=p;}};c.prototype.getUOMTextAnnotation=function(m){if(m&&m.annotations&&m.annotations.uom){m.annotations.textuom=this.getTextProperty2(m.annotations.uom);}};c.prototype.geValueListEntitySet=function(m){if(m&&m.annotations&&m.annotations.valuelist){if(m.annotations.valuelist.primaryValueListAnnotation&&m.annotations.valuelist.primaryValueListAnnotation.valueListEntitySetName){m.annotations.valuelistentityset=this.oMeta.getODataEntitySet(m.annotations.valuelist.primaryValueListAnnotation.valueListEntitySetName);}}};c.prototype.getEdmProperty=function(m){var o=m.property;return(o&&o.property)||null;};c.prototype.getValueListData=function(m){var o=this.getEdmProperty(m),d=m.annotations;if(M.isValueList(o)){d.valuelist=this.getValueListAnnotationPath(m);var v=M.getValueListMode(o);if(v){d.valuelistType=v;}else{d.valuelistType=this.getAnalyzer().getValueListSemantics(o["com.sap.vocabularies.Common.v1.ValueList"]);}}};c.prototype.findProperty=function(p,P){return O.findObject(p,P);};c.prototype.getAssociation=function(e,n){var N;if(e){N=this.findProperty(e.navigationProperty,n);}if(N){return O.getObject(this.oMeta.oModel,"association",N.relationship);}return null;};c.prototype.getToRoleAssociationEnd=function(d,n){if(Array.isArray(d)){for(var i=0;i<d.length;i++){var o=d[i];if(o.role===n){return o;}}}return null;};c.prototype.getToRoleAssociationEndMultiplicity=function(d,n){var o=this.getToRoleAssociationEnd(d,n);return o?o.multiplicity:"";};c.prototype.checkNavigationPropertyRequiredMetadata=function(m){var e=m.propertyName,t=m.textAnnotation,s=t?t.Path:"",E=m.entityType,d=E.namespace+"."+E.name,C="sap.ui.comp.smartfield.ODataHelper",f="com.sap.vocabularies.Common.v1.Text";if(!t){L.info('Missing "'+f+'" annotation for "'+e+'" EDM property of "'+d+'" entity type.',C);return false;}if(s===undefined){b(false,'Missing "Path" attribute of "'+f+'" annotation for "'+e+'" EDM property of "'+d+'" entity type. - '+C);return false;}if(s===""){b(false,'Missing URL path name of "'+f+'" annotation for "'+e+'" EDM property of "'+d+'" entity type. - '+C);return false;}var g="com.sap.vocabularies.UI.v1.TextArrangement",o=t[g];if(!o){L.info('Missing "'+g+'" annotation for "'+e+'" EDM property of "'+d+'" entity type.',C);return false;}var v=o.EnumMember;if(v===undefined){b(false,'Missing "EnumMember" attribute of "'+g+'" annotation for "'+e+'" EDM property of "'+d+'" entity type. - '+C);return false;}if(!(v.split("/")[1]in T)){b(false,'Invalid "'+v+'" Text annotation enumeration member for "'+e+'" EDM property of "'+d+'" entity type. - '+C);return false;}if(o.EnumMember===T.TextSeparate){return false;}if(s.indexOf("/")===-1){b(false,'Invalid navigation property URL path name specified in the "'+f+'" annotation of the "'+e+'" EDM property of the "'+d+'" entity type. - '+C);return false;}var n=s.split("/")[0],N=this.findProperty(E.navigationProperty,n);if(!N){b(false,'The navigation property URL path name "'+n+'" (specified in the Text annotation of the "'+e+'" EDM property) was not found in the "'+d+'" entity type of the service metadata document. - '+C);return false;}var h=this.getAssociation(E,n);if(!h){b(false,'Missing "'+N.relationship+'" association for "'+N.name+'" EDM navigation property of the "'+d+'" entity type. - '+C);return false;}var r=h.referentialConstraint;if(!r){b(false,'Missing referential constraint for "'+N.relationship+'" association in the service metadata document. - '+C);return false;}if(!Array.isArray(h.end)||!(h.end.length>0)){b(false,'Missing association end for "'+N.relationship+'" association in the service metadata document. - '+C);return false;}var i=this.getToRoleAssociationEndMultiplicity(h.end,N.toRole);if(i!=="1"){b(false,'Expected multiplicity of 1 for "'+N.toRole+'" association end of the "'+N.relationship+'" association in the service metadata document. - '+C);return false;}if((r.principal.propertyRef.length!==1)||(r.dependent.propertyRef.length!==1)){b(false,'Expected the single "'+e+'" foreign key EDM property as '+'referential constraint in the "'+N.relationship+'" association. - '+C);return false;}var j=m.entityTypeOfNavigationProperty||this.getNavigationProperty(E,n).entityType;if(j.key.propertyRef.length!==1){b(false,'Expected a single key property in the lookup "'+j.namespace+"."+j.name+'" entity type. - '+C);return false;}var R=r.principal.propertyRef[0].name;if(R!==j.key.propertyRef[0].name){b(false,'Expected a property named "'+R+'" to be the single key property in the lookup "'+j.namespace+"."+j.name+'" entity type. - '+C);return false;}return true;};c.prototype.checkValueListRequiredMetadataForTextArrangment=function(m){var v=m.valueListAnnotation,C="sap.ui.comp.smartfield.ODataHelper";if(!v){var e=m.entityType,E=e.namespace+"."+e.name;b(false,'Missing "ValueList" annotation for "'+m.propertyName+'" EDM property of "'+E+'" entity type. - '+C);return false;}if(!Array.isArray(v.fields)){b(false,'Missing fields for "'+v.valueListEntityName+'" entity. - '+C);return false;}var d=v.descriptionField,V=this.findProperty(v.fields,d);if(!V){b(false,'The "'+d+'" description field was not found '+'in the service metadata document. - '+C);return false;}if(V["sap:filterable"]==="false"){b(false,'Expected the "'+V.fullName+'" field to be filterable. - '+C);return false;}return true;};c.prototype.getEdmDisplayPath=function(m){var t=m.annotations.text;if(t){return t.path;}return m.path;};c.prototype.getTextAnnotationPropertyPath=function(t){return t?t.path:"";};c.prototype.getAbsolutePropertyPathToValueListEntity=function(s){var v=s.property,V=v&&v["com.sap.vocabularies.Common.v1.Text"],B=s.bindingContextPath;if((typeof B==="string")&&(B!=="")){return B+"/"+V.Path;}var o=s.entitySet,e=s.entityID,d;if((e==null)||(e==="")){return"";}if(V&&o){if(s.property.type=="Edm.Guid"){d=s.entityID.toLowerCase();}else{d=s.entityID;}d=a.formatValue(d,s.property.type,true);return"/"+o.name+"("+d+")"+"/"+V.Path;}return"";};c.prototype.getODataValueListKeyProperty=function(v){for(var i=0;i<v.fields.length;i++){var f=v.fields[i];if(f.name===v.keyField){return f;}}};c.prototype.getUOMPath=function(m){if(m&&m.annotations&&m.annotations.uom){return m.annotations.uom.path;}return null;};c.prototype.getUOMTypePath=function(m){if(m.property.complex){return m.property.typePath.replace(m.property.property.name,m.annotations.uom.property.name);}return m.annotations.uom.property.name;};c.prototype.getUOMChangeHandler=function(C,u){return function(p){try{C.fireChange({value:p.mParameters.value,newValue:p.mParameters.value,unitChanged:u,validated:p.mParameters["validated"]});}catch(e){L.warning(e);}};};c.prototype.getSelectionChangeHandler=function(C){return function(p){var k="";try{var i=p.getParameter("selectedItem");if(i){k=i.getKey();}C.fireChange({value:k,newValue:k,selectionChange:true});}catch(e){L.warning(e);}};};c.prototype.destroy=function(){if(this._oAnalyzer){this._oAnalyzer.destroy();}if(this.oAnnotation){this.oAnnotation.destroy();}this._oUtil=null;this.oMeta=null;this.oAnalyzer=null;this.oAnnotation=null;};c.prototype.getAutoExpandProperties=function(m){var n=[],d=[];for(var s in m){switch(s){case"com.sap.vocabularies.Common.v1.Text":case"Org.OData.Measures.V1.Unit":case"Org.OData.Measures.V1.ISOCurrency":case"com.sap.vocabularies.Common.v1.FieldControl":if(m[s].Path){d=m[s].Path.split("/");}break;}if(d.length>1&&n.indexOf(d[0])<0){n.push(d[0]);}}return n.join(",");};c.prototype.loadValueListAnnotation=function(p){var P=this.getAnalyzer().getValueListAnnotationLazy(p);P.catch(function(){L.error("The value list annotation could not be loaded.",undefined,"sap.ui.comp.smartfield.ODataHelper.loadValueListAnnotation");});return P;};return c;},true);
