/*
 * SAPUI5

		(c) Copyright 2009-2019 SAP SE. All rights reserved
	
 */
sap.ui.define(["sap/ui/model/SimpleType","sap/ui/core/format/NumberFormat","sap/ui/model/odata/type/Boolean","sap/ui/comp/smartfield/type/Double","sap/ui/comp/smartfield/type/DateTime","sap/ui/comp/odata/type/StringDate","sap/ui/comp/smartfield/type/DateTimeOffset","sap/ui/comp/smartfield/type/Decimal","sap/ui/comp/smartfield/type/Int16","sap/ui/comp/smartfield/type/Int32","sap/ui/comp/smartfield/type/Int64","sap/ui/comp/smartfield/type/Byte","sap/ui/comp/smartfield/type/SByte","sap/ui/comp/smartfield/type/String","sap/ui/comp/smartfield/type/TextArrangementString","sap/ui/comp/smartfield/type/TextArrangementGuid","sap/ui/comp/smartfield/type/AbapBool","sap/ui/comp/smartfield/type/Currency","sap/ui/comp/smartfield/type/Time","sap/ui/comp/smartfield/type/Guid","sap/ui/comp/odata/MetadataAnalyser"],function(S,N,B,D,a,b,c,d,I,e,f,g,h,i,T,j,A,C,k,G,M){"use strict";var O=function(p){this._oParent=p;};O.prototype.getType=function(p,F,n,s){s=s||{};var q=this._oParent.getBindingInfo("value"),t=q&&q.type,r=s.composite&&(t instanceof S);if(t&&!r){return l(t);}if(p&&p.property&&p.property.type){if(!t){n=this.getConstraints(p.property,n);}switch(p.property.type){case"Edm.Boolean":return new B(F,n);case"Edm.Double":return new D(F,n);case"Edm.Decimal":case"Edm.Single":return new d(F,this._getDecimalConstraints(p,n));case"Edm.Int16":return new I(F,n);case"Edm.Int32":return new e(F,n);case"Edm.Int64":return new f(F,n);case"Edm.Byte":return new g(F,n);case"Edm.SByte":return new h(F,n);case"Edm.DateTimeOffset":return new c(F,n);case"Edm.DateTime":return new a(F,this._getDateTimeConstraints(p,n));case"Edm.String":if(this.isCalendarDate(p)){return new b(F);}if(!t){n=this._getStringConstraints(p);}if(s.composite){F=Object.assign({},F,this._getTextArrangementFormatOptions());return new T(F,n,this._getTextArrangementOptions(s));}return new i(F,n);case"Edm.Time":return new k(F,n);case"Edm.Guid":if(s.composite){F=Object.assign({},F,this._getTextArrangementFormatOptions());return new j(F,n,this._getTextArrangementOptions(s));}return new G(F,n);default:return null;}}return null;};function l(t){var p=t.parseValue,n=t.destroy;t.parseValue=function(v,s){var P=p.apply(this,arguments);if(typeof this.oFieldControl==="function"){this.oFieldControl(v,s);}return P;};t.destroy=function(){n.apply(this,arguments);this.oFieldControl=null;};return t;}O.prototype.getConstraints=function(p,n){return Object.assign({},n,{nullable:M.isNullable(p)});};O.prototype._getDateTimeConstraints=function(p,q){var r={},n;if((p.property["sap:display-format"]==="Date")||this.isCalendarDate(p)){r={displayFormat:"Date"};}for(n in q){r[n]=q[n];}return r;};O.prototype.getMaxLength=function(p,n){var v=[],V,r=0;if(n&&n.constraints){if(n.constraints.maxLength&&n.constraints.maxLength>-1){v.push(n.constraints.maxLength);}}if(n&&n.type&&n.type.oConstraints){if(n.type.oConstraints.maxLength&&n.type.oConstraints.maxLength>-1){v.push(n.type.oConstraints.maxLength);}}if(p&&p.property&&p.property.maxLength){var P=parseInt(p.property.maxLength);if(P>-1){v.push(P);}}var F=this._oParent.getMaxLength();if(F>0){v.push(F);}var q=v.length;while(q--){V=v[q];if(V>0){if(r>0){if(V<r){r=V;}}else{r=V;}}}return r;};O.prototype._getDecimalConstraints=function(p,n){n=n||{};if(p.property.precision){n.precision=parseInt(p.property.precision);}if(p.property.scale){n.scale=parseInt(p.property.scale);}return n;};O.prototype._getTextArrangementFormatOptions=function(){return{textArrangement:this._oParent.getControlFactory()._getDisplayBehaviourConfiguration()};};O.prototype._getStringConstraints=function(p,n){n=n||{};var q=this._oParent.getBindingInfo("value"),r=this.getMaxLength(p,q),E;if(q&&q.type&&q.type.oConstraints){if(q.type.oConstraints.equals){E=q.type.oConstraints.equals;}}if(r>0||E){if(r>0){n.maxLength=r;}if(E){n.equals=E;}}if(M.isDigitSequence(p.property)){n.isDigitSequence=true;}return n;};O.prototype._getTextArrangementOptions=function(n){var t=this._oParent.getControlFactory().oTextArrangementDelegate;return{keyField:n.keyField,descriptionField:n.descriptionField,onBeforeValidateValue:t.onBeforeValidateValue.bind(t)};};O.prototype.isCalendarDate=function(p){var n=p.property["com.sap.vocabularies.Common.v1.IsCalendarDate"];if(n&&n.Bool){return n.Bool?n.Bool!=="false":true;}return false;};O.prototype.getDisplayFormatter=function(p,s){s=s||{};if(s.currency){return this.getCurrencyDisplayFormatter(s);}return this.getUOMDisplayFormatter(p);};O.prototype.getCurrencyDisplayFormatter=function(s){var F=N.getCurrencyInstance({showMeasure:false});return function(n,p){var v,q,P;if(!n||!p||p==="*"){return"";}if(!s.currency){v=n+="\u2008";return v;}q=F.oLocaleData.getCurrencyDigits(p);v=F.format(n,p);if(q===0){v+="\u2008";}P=3-q;if(P){v=v.padEnd(v.length+P,"\u2007");}if(s.mask){return O.maskValue(v);}return v;};};O.prototype.getUOMDisplayFormatter=function(p){var F={};if(p.scale){F.maxFractionDigits=parseInt(p.scale);}if(p.precision){F.precision=parseInt(p.precision);}var n=N.getFloatInstance(F);return function(v,u){if((v==null)||!u||(u==="*")){return"";}if(isNaN(parseFloat(v))){return v.toString()+"\u2008";}return n.format(v,u)+"\u2008";};};O.maskValue=function(t){if(t){return t.replace(new RegExp(".","igm"),"*");}return t;};O.prototype.getCurrencyType=function(p){if(p){var n=this._getDecimalConstraints(p),F=m(n),q=o(n);return new C(F,this.getConstraints(p.property,q));}return null;};function m(n){return{showMeasure:false,parseAsString:true,emptyString:0,precision:n.precision};}function o(n){return{precision:n.precision,scale:n.scale};}O.prototype.getAbapBoolean=function(){return new A();};O.prototype.destroy=function(){this._oParent=null;};return O;},true);
