/*
 * ! SAPUI5

		(c) Copyright 2009-2019 SAP SE. All rights reserved
	
 */
sap.ui.define(["sap/ui/comp/library","sap/ui/core/Control","sap/ui/comp/providers/ChartProvider","sap/suite/ui/microchart/library","sap/m/library","sap/ui/core/CustomData","sap/ui/comp/smartmicrochart/SmartMicroChartBase","sap/base/Log","./SmartMicroChartRenderer"],function(C,a,b,M,c,d,S,L){"use strict";var e=c.Size;var f=a.extend("sap.ui.comp.smartmicrochart.SmartMicroChart",{metadata:{library:"sap.ui.comp",designtime:"sap/ui/comp/designtime/smartmicrochart/SmartMicroChart.designtime",properties:{entitySet:{type:"string",group:"Misc",defaultValue:null},showLabel:{type:"boolean",group:"Appearance",defaultValue:true},enableAutoBinding:{type:"boolean",group:"Misc",defaultValue:false},chartBindingPath:{type:"string",group:"Misc",defaultValue:null},chartType:{type:"string",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Misc"},height:{type:"sap.ui.core.CSSSize",group:"Misc"},size:{type:"sap.m.Size",group:"Misc",defaultValue:"Auto"},isResponsive:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"_chart",aggregations:{_chart:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{chartTitle:{type:"sap.m.Label",group:"Misc",multiple:false},chartDescription:{type:"sap.m.Label",group:"Misc",multiple:false},unitOfMeasure:{type:"sap.m.Label",group:"Misc",multiple:false},freeText:{type:"sap.m.Label",group:"Misc",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{initialize:{}}}});f.prototype.init=function(){this._bIsInitialized=false;this._bMetaModelLoadAttached=false;};f.prototype.setChartType=function(){return this;};f.prototype.getChartType=function(){return this.getAggregation("_chart").getChartType();};f.prototype.propagateProperties=function(){if(a.prototype.propagateProperties){a.prototype.propagateProperties.apply(this,arguments);}this._initializeMetadata();};f.prototype.onBeforeRendering=function(){var o=this.getAggregation("_chart");if(o){if(o.getMetadata().hasProperty("height")){o.setHeight(this.getHeight(),true);}if(o.getMetadata().hasProperty("width")){o.setWidth(this.getWidth(),true);}if(o.getMetadata().hasProperty("size")){o.setSize(this.getSize(),true);}M._passParentContextToChild(this,o);if(o.getMetadata().hasProperty("showLabel")){o.setShowLabel(this.getShowLabel(),true);}if(o.getMetadata().hasAssociation("chartTitle")){o.setAssociation("chartTitle",this.getChartTitle(),true);}if(o.getMetadata().hasAssociation("chartDescription")){o.setAssociation("chartDescription",this.getChartDescription(),true);}if(o.getMetadata().hasAssociation("unitOfMeasure")){o.setAssociation("unitOfMeasure",this.getUnitOfMeasure(),true);}if(o.getMetadata().hasAssociation("freeText")){o.setAssociation("freeText",this.getFreeText(),true);}}};f.prototype.setSize=function(s){if(this.getSize()!==s){if(s===e.Responsive){this.setProperty("isResponsive",true);}else{this.setProperty("isResponsive",false);}this.setProperty("size",s);}return this;};f.prototype.setIsResponsive=function(i){var s,g=this.getSize();this.setProperty("isResponsive",i);if(i){s=e.Responsive;}else{s=g===e.Responsive?e.Auto:g;}this.setProperty("size",s);return this;};f.prototype.addAriaLabelledBy=function(A){this.addAssociation("ariaLabelledBy",A,true);this.getAggregation("_chart").addAriaLabelledBy(A);return this;};f.prototype.removeAriaLabelledBy=function(A){this.removeAssociation("ariaLabelledBy",A,true);this.getAggregation("_chart").removeAriaLabelledBy(A);return this;};f.prototype.removeAllAriaLabelledBy=function(){this.removeAllAssociation("ariaLabelledBy",true);this.getAggregation("_chart").removeAllAriaLabelledBy();return this;};f.prototype._initializeMetadata=function(){if(!this._bIsInitialized){var m=this.getModel();if(m&&(m.getMetadata().getName()==="sap.ui.model.odata.v2.ODataModel"||m.getMetadata().getName()==="sap.ui.model.odata.ODataModel")){if(!this._bMetaModelLoadAttached){m.getMetaModel().loaded().then(this._onMetadataInitialized.bind(this));this._bMetaModelLoadAttached=true;}}else if(m){this._onMetadataInitialized();}}};f.prototype._createChartProvider=function(){var E=this.getEntitySet(),m=this.getModel();if(m&&E){this._oChartProvider=new b({entitySet:E,model:m,chartQualifier:this.data("chartQualifier")});}};f.prototype._onMetadataInitialized=function(){var q,D;this._bMetaModelLoadAttached=false;if(!this._bIsInitialized){this._createChartProvider();if(this._oChartProvider){this._oChartViewMetadata=this._oChartProvider.getChartViewMetadata();if(this._oChartViewMetadata){this._bIsInitialized=true;this._createInnerChart();}else{q=this.data("chartQualifier");D=this._oChartProvider.getChartDataPointMetadata();if(D){D=q?D.additionalAnnotations[q]:D.primaryAnnotation;if(D){this._bIsInitialized=true;this._createInnerChartFromDataPoint(D);}else{L.error("There is no UI.Chart annotation nore DataPoint annotation. We cannot initialize SmartMicroChart.");}}else{L.error("There is no UI.Chart annotation nore DataPoint annotation. We cannot initialize SmartMicroChart.");}}}}};f.prototype._createInnerChartFromDataPoint=function(D){var t=D.Visualization.EnumMember;if(S._isBulletVizualizationType(t)){this._buildSmartBulletMicroChart();}else{L.error("Only Bullet chart can be initialize with just DataPoint annotation. Type: "+t+" is not a Bullet chart type.");return;}this.invalidate();};f.prototype._createInnerChart=function(){if(!this._checkChartMetadata()){L.error("Created annotations not valid. Please review the annotations and metadata.");return;}var s=this._oChartViewMetadata.chartType;switch(s){case"line":case"area":var t=this._oChartViewMetadata.annotation.ChartType.EnumMember.split("/").pop().toLowerCase();if(t==="area"){this._buildSmartAreaMicroChart();}else if(t==="line"){this._buildSmartLineMicroChart();}else{L.error("Not supported chart type used.");return;}break;case"bullet":this._buildSmartBulletMicroChart();break;case"donut":this._buildSmartRadialMicroChart();break;case"stacked_bar":this._buildSmartStackedBarMicroChart();break;case"column":this._buildSmartColumnMicroChart();break;case"pie":this._buildSmartHarveyBallMicroChart();break;default:L.error("Not supported chart type used.");return;}this.invalidate();};f.prototype._buildSmartLineMicroChart=function(){this._buildSmartMicroChart(C.smartmicrochart.SmartLineMicroChart);};f.prototype._buildSmartAreaMicroChart=function(){this._buildSmartMicroChart(C.smartmicrochart.SmartAreaMicroChart);};f.prototype._buildSmartBulletMicroChart=function(){this._buildSmartMicroChart(C.smartmicrochart.SmartBulletMicroChart);};f.prototype._buildSmartRadialMicroChart=function(){this._buildSmartMicroChart(C.smartmicrochart.SmartRadialMicroChart);};f.prototype._buildSmartStackedBarMicroChart=function(){this._buildSmartMicroChart(C.smartmicrochart.SmartStackedBarMicroChart);};f.prototype._buildSmartColumnMicroChart=function(){this._buildSmartMicroChart(C.smartmicrochart.SmartColumnMicroChart);};f.prototype._buildSmartHarveyBallMicroChart=function(){this._buildSmartMicroChart(C.smartmicrochart.SmartHarveyBallMicroChart);};f.prototype._buildSmartMicroChart=function(g){var o=new g({entitySet:this.getEntitySet(),chartBindingPath:this.getChartBindingPath(),initialize:[this._onChartInitialized,this],customData:[new d({key:"chartQualifier",value:this.data("chartQualifier")})]});if(o.getMetadata().hasProperty("enableAutoBinding")){o.setProperty("enableAutoBinding",this.getEnableAutoBinding(),true);}this.setAggregation("_chart",o,true);};f.prototype._onChartInitialized=function(){this.fireInitialize();};f.prototype._checkChartMetadata=function(){if(this._oChartViewMetadata.chartType&&this._oChartViewMetadata.annotation&&this._oChartViewMetadata.annotation.ChartType&&this._oChartViewMetadata.annotation.ChartType.EnumMember&&this._oChartViewMetadata.annotation.ChartType.EnumMember.length>0){return true;}else{return false;}};f.prototype.getAccessibilityInfo=function(){var A={};var i=this.getAggregation("_chart");if(i&&i.getAccessibilityInfo){A=i.getAccessibilityInfo();}return A;};return f;});
