/*
 * ! SAPUI5

		(c) Copyright 2009-2019 SAP SE. All rights reserved
	
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/comp/library","sap/m/library","sap/ui/comp/providers/ChartProvider","sap/ui/core/format/NumberFormat","sap/ui/core/format/DateFormat","sap/ui/model/type/Date","sap/base/Log","sap/ui/core/Control"],function(q,l,M,C,N,D,a,L,b){"use strict";var V=M.ValueColor;var S=M.Size;var c=b.extend("sap.ui.comp.smartmicrochart.SmartMicroChartBase",{metadata:{"abstract":true,library:"sap.ui.comp",properties:{entitySet:{type:"string",group:"Misc",defaultValue:null},chartType:{type:"string",group:"Misc"},chartBindingPath:{type:"string",group:"Misc",defaultValue:null},showLabel:{type:"boolean",group:"Appearance",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Misc"},height:{type:"sap.ui.core.CSSSize",group:"Misc"},size:{type:"sap.m.Size",group:"Misc",defaultValue:"Auto"},isResponsive:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"_chart",aggregations:{_chart:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{chartTitle:{type:"sap.m.Label",group:"Misc",multiple:false},chartDescription:{type:"sap.m.Label",group:"Misc",multiple:false},unitOfMeasure:{type:"sap.m.Label",group:"Misc",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{initialize:{}}}});c._MINIMIZE="com.sap.vocabularies.UI.v1.ImprovementDirectionType/Minimize";c._MAXIMIZE="com.sap.vocabularies.UI.v1.ImprovementDirectionType/Maximize";c._TARGET="com.sap.vocabularies.UI.v1.ImprovementDirectionType/Target";c._DELTABULLET="com.sap.vocabularies.UI.v1.VisualizationType/DeltaBulletChart";c._BULLET="com.sap.vocabularies.UI.v1.VisualizationType/BulletChart";c._CALENDAR_TERMS_PATTERNS={"com.sap.vocabularies.Common.v1.IsCalendarYear":"yyyy","com.sap.vocabularies.Common.v1.IsCalendarQuarter":"Q","com.sap.vocabularies.Common.v1.IsCalendarMonth":"MM","com.sap.vocabularies.Common.v1.IsCalendarWeek":"ww","com.sap.vocabularies.Common.v1.IsCalendarDate":"yyyyMMdd","com.sap.vocabularies.Common.v1.IsCalendarYearMonth":"yyyyMM"};c._ASSOCIATIONS=["chartTitle","chartDescription","unitOfMeasure","freeText"];c._ASSOCIATIONS_ANNOTATIONS_MAP={chartDescription:"Description",chartTitle:"Title",unitOfMeasure:{propertyAnnotationPath:"Value",propertyAnnotationProperties:["ISOCurrency","Unit"]},freeText:{propertyAnnotationPath:"Value",propertyAnnotationProperties:["Label"]}};c._isBulletVizualizationType=function(t){return(t===c._BULLET)||(t===c._DELTABULLET);};c.prototype._initializeMetadata=function(){if(!this._bIsInitialized){var m=this.getModel();if(m&&(m.getMetadata().getName()==="sap.ui.model.odata.v2.ODataModel"||m.getMetadata().getName()==="sap.ui.model.odata.ODataModel")){if(!this._bMetaModelLoadAttached){m.getMetaModel().loaded().then(this._onMetadataInitialized.bind(this));this._bMetaModelLoadAttached=true;}}else if(m){this._onMetadataInitialized.call(this);}}};c.prototype._onMetadataInitialized=function(){this._bMetaModelLoadAttached=false;if(this._bIsInitialized){return;}this._createChartProvider.call(this);this._oChartViewMetadata=this._oChartProvider.getChartViewMetadata();this._oDataPointMetadata=this._oChartProvider.getChartDataPointMetadata();this._bIsInitialized=true;this.fireInitialize();if(this.getEnableAutoBinding&&this.getEnableAutoBinding()){if(this.getChartBindingPath()){this.bindElement(this.getChartBindingPath());}else{L.error("The property chartBindingPath needs to be set in order for property enableAutoBinding to be applied.");}}if(this._checkChartMetadata.call(this)){this._aDataPointAnnotations=this._getDataPointAnnotations.call(this);this._oDataPointAnnotations=this._aDataPointAnnotations[0];if(this._aDataPointAnnotations.every(this._checkDataPointAnnotation.bind(this))){this._createAndBindInnerChart();}}else{L.error("Created annotations not valid. Please review the annotations and metadata.");}};c.prototype._getDataPointAnnotations=function(){var A=[],o;if(this._oChartViewMetadata&&this._oChartViewMetadata.measureFields){for(var i=0;i<this._oChartViewMetadata.measureFields.length;i++){o=this._getDataPointAnnotation.call(this,this._oChartViewMetadata.measureFields[i]);A.push(o);}}else{o=this._getDataPointAnnotation.call(this);A.push(o);}return A;};c.prototype._cleanup=function(){if(this._oDateType){this._oDateType.destroy();this._oDateType=null;}};c.prototype._createChartProvider=function(){var m,e;e=this.getEntitySet();m=this.getModel();if(m&&e){this._oChartProvider=new C({entitySet:e,model:m,chartQualifier:this.data("chartQualifier")});}else{L.error("Property entitySet is not set or no model has been attached to the control.");}};c.prototype._checkChartMetadata=function(){if(q.isEmptyObject(this._oChartViewMetadata)){if(q.isEmptyObject(this._oDataPointMetadata)){L.error("DataPoint annotation must be provided if chart annotation is missing.");return false;}return true;}else{if(!this._oChartViewMetadata.fields||this._oChartViewMetadata.fields.length===0){L.error("No fields exist in the metadata.");return false;}if(this._hasMember(this,"_oChartViewMetadata.annotation.ChartType")){return this._checkChartType.call(this);}else if(this.getChartType()==="Comparison"||this.getChartType()==="Delta"){return true;}else{L.error("The Chart annotation is invalid.");return false;}}};c.prototype._checkChartType=function(){var t=this._getSupportedChartTypes();for(var i=0;i<t.length;i++){if(this._oChartViewMetadata.annotation.ChartType.EnumMember==="com.sap.vocabularies.UI.v1.ChartType/"+t[i]){return true;}}L.error("The ChartType property in the Chart annotation is not part of the list of valid types: \""+t.toString()+"\".");return false;};c.prototype._getDataPointQualifier=function(m){var o;if(!this._oChartViewMetadata&&this._oDataPointMetadata){return this.data("chartQualifier");}if(!this._hasMember(this,"_oChartViewMetadata.annotation.MeasureAttributes.length")||!this._oChartViewMetadata.annotation.MeasureAttributes.length){return"";}if(m&&this._oChartViewMetadata.measureAttributes&&this._oChartViewMetadata.measureAttributes[m]){return(this._oChartViewMetadata.measureAttributes[m].dataPoint.match(/\#([^\#]*)$/)||[])[1]||"";}o=this._oChartViewMetadata.annotation.MeasureAttributes[0];if(this._hasMember(o,"DataPoint.AnnotationPath")){return(o.DataPoint.AnnotationPath.match(/\#([^\#]*)$/)||[])[1]||"";}};c.prototype._getDataPointAnnotation=function(m){var Q=this._getDataPointQualifier.call(this,m),A;if(Q){A=this._oDataPointMetadata.additionalAnnotations[Q];}else{A=this._oDataPointMetadata.primaryAnnotation;}return A;};c.prototype._checkDataPointAnnotation=function(d){var v=null;if(q.isEmptyObject(d)){L.error("The DataPoint annotation is empty. Please check it!");return false;}if(this._hasMember(d,"Visualization.EnumMember")){v=d.Visualization.EnumMember;if(!c._isBulletVizualizationType(v)){L.error("The only support visualization types for micro charts are BulletChart and DeltaBulletChart.");return false;}}if(q.isEmptyObject(this._oChartViewMetadata)&&(v===null)){L.error("If only DataPoint annotation is provided the VisualizationType is expected to be set.");return false;}if(this._hasMember(d,"Value.Path")){if(q.isEmptyObject(d.Criticality)){this._checkCriticalityMetadata(d.CriticalityCalculation);}return true;}else{L.error("The Value property does not exist in the DataPoint annotation. This property is essential for creating the smart chart.");return false;}};c.prototype._checkCriticalityMetadata=function(o){if(q.isEmptyObject(o)){L.warning("The CriticalityCalculation property in DataPoint annotation is not provided.");return false;}if(this._hasMember(o,"ImprovementDirection.EnumMember")){var i=o.ImprovementDirection.EnumMember;switch(i){case c._MINIMIZE:return this._checkCriticalityMetadataForMinimize(o);case c._MAXIMIZE:return this._checkCriticalityMetadataForMaximize(o);case c._TARGET:return this._checkCriticalityMetadataForTarget(o);default:L.warning("The improvement direction in DataPoint annotation must be either Minimize, Maximize or Target.");}}else{L.warning("The ImprovementDirection property in DataPoint annotation is not provided.");}return false;};c.prototype._checkCriticalityMetadataForMinimize=function(o){if(!this._hasMember(o,"ToleranceRangeHighValue.Path")){L.warning("The ToleranceRangeHighValue property in DataPoint annotation is missing for Minimize improvement direction.");return false;}if(!this._hasMember(o,"DeviationRangeHighValue.Path")){L.warning("The DeviationRangeHighValue property in DataPoint annotation is missing for Minimize improvement direction.");return false;}return true;};c.prototype._checkCriticalityMetadataForMaximize=function(o){if(!this._hasMember(o,"ToleranceRangeLowValue.Path")){L.warning("The ToleranceRangeLowValue property in DataPoint annotation is missing for Minimize improvement direction.");return false;}if(!this._hasMember(o,"DeviationRangeLowValue.Path")){L.warning("The DeviationRangeLowValue property in DataPoint annotation is missing for Minimize improvement direction.");return false;}return true;};c.prototype._checkCriticalityMetadataForTarget=function(o){if(!this._hasMember(o,"ToleranceRangeLowValue.Path")){L.warning("The DeviationRangeLowValue property in DataPoint annotation is missing for Target improvement direction.");return false;}if(!this._hasMember(o,"ToleranceRangeHighValue.Path")){L.warning("The ToleranceRangeHighValue property in DataPoint annotation is missing for Target improvement direction.");return false;}if(!this._hasMember(o,"DeviationRangeLowValue.Path")){L.warning("The ToleranceRangeLowValue property in DataPoint annotation is missing for Target improvement direction.");return false;}if(!this._hasMember(o,"DeviationRangeHighValue.Path")){L.warning("The DeviationRangeHighValue property in DataPoint annotation is missing for Target improvement direction.");return false;}return true;};c.prototype._mapCriticalityTypeWithColor=function(t){var T;if(!t){return V.Neutral;}else{T=t.toString();}T=(T.match(/(?:CriticalityType\/)?([^\/]*)$/)||[])[1]||"";switch(T){case"Negative":case"1":return V.Error;case"Critical":case"2":return V.Critical;case"Positive":case"3":return V.Good;default:return V.Neutral;}};c.prototype._getThresholdValues=function(o){var t={},d=this.getBindingContext();for(var k in o){if(o.hasOwnProperty(k)&&k!=="ImprovementDirection"){t[k]=o[k].Path&&d&&d.getProperty(o[k].Path)||o[k].Decimal||0;}}return t;};c.prototype._getValueColorForMinimize=function(v,t,d){if(v<=t){return this._mapCriticalityTypeWithColor("Positive");}else if(v>t&&v<=d){return this._mapCriticalityTypeWithColor("Critical");}else if(v>d){return this._mapCriticalityTypeWithColor("Negative");}};c.prototype._getValueColorForMaximize=function(v,t,d){if(v>=t){return this._mapCriticalityTypeWithColor("Positive");}else if(v<t&&v>=d){return this._mapCriticalityTypeWithColor("Critical");}else if(v<d){return this._mapCriticalityTypeWithColor("Negative");}};c.prototype._getValueColorForTarget=function(v,t,d,T,i){if(v>=t&&v<=T){return this._mapCriticalityTypeWithColor("Positive");}else if((v>=d&&v<t)||(v>T&&v<=i)){return this._mapCriticalityTypeWithColor("Critical");}else if(v<d||v>i){return this._mapCriticalityTypeWithColor("Negative");}};c.prototype._getValueColor=function(v,s){var o=this._oDataPointAnnotations.CriticalityCalculation,t,d;v=parseFloat(v)||0;if(typeof s==="string"){d=this._mapCriticalityTypeWithColor(s);}else if(o&&typeof v!=="undefined"&&v!==null){t=this._getThresholdValues.call(this,o);d=this._criticalityCalculation(v,o.ImprovementDirection.EnumMember,t);}return d||this._mapCriticalityTypeWithColor();};c.prototype._getTopLabelColor=function(v,d,i){var o=this._aDataPointAnnotations[i].CriticalityCalculation,e=parseFloat(v)||0,t={},s;for(var k in o){if(o.hasOwnProperty(k)&&k!=="ImprovementDirection"){t[k]=d[o[k].Path];}}if(o&&typeof e!=="undefined"&&e!==null){s=this._criticalityCalculation(e,o.ImprovementDirection.EnumMember,t);}return s;};c.prototype._criticalityCalculation=function(v,i,t){var s;switch(i){case c._MINIMIZE:s=this._getValueColorForMinimize(v,t.ToleranceRangeHighValue,t.DeviationRangeHighValue);break;case c._MAXIMIZE:s=this._getValueColorForMaximize(v,t.ToleranceRangeLowValue,t.DeviationRangeLowValue);break;case c._TARGET:s=this._getValueColorForTarget(v,t.ToleranceRangeLowValue,t.DeviationRangeLowValue,t.ToleranceRangeHighValue,t.DeviationRangeHighValue);break;default:L.warning("The improvement direction in DataPoint annotation must be either Minimize, Maximize or Target.");}return s;};c.prototype._getAnnotation=function(d){var A=c._ASSOCIATIONS_ANNOTATIONS_MAP[d];if(!A){L.warning("No annotation connected to association \""+d+"\".");return{};}if(!q.isEmptyObject(this._oChartViewMetadata)&&typeof A==="string"){return this._oChartViewMetadata.annotation[A];}if(!q.isEmptyObject(this._oDataPointAnnotations)&&this._hasMember(A,"propertyAnnotationPath")&&this._hasMember(A,"propertyAnnotationProperties")){var p;if(this._hasMember(this._oDataPointAnnotations,A.propertyAnnotationPath+".Path")){p=this._getPropertyAnnotation.call(this,this._oDataPointAnnotations[A.propertyAnnotationPath].Path);}if(p){return this._getValueFromPropertyAnnotation(p,A.propertyAnnotationProperties);}}return{};};c.prototype._getValueFromPropertyAnnotation=function(p,P){for(var s in p){for(var i=0;i<P.length;i++){if(s.indexOf(P[i])>-1){return p[s];}}}return{};};c.prototype._updateAssociation=function(d,e){var A,o;if(this.getMetadata().hasAssociation(d)){A=sap.ui.getCore().byId(this.getAssociation(d));if(A&&A.getMetadata().hasProperty("text")){o=this._getAnnotation.call(this,d);this._setAssociationText(A,o,e);}}};c.prototype._updateAssociations=function(B){var o=B&&B.getContexts(0,1)[0],d=o&&o.getObject();var n=c._ASSOCIATIONS.length;for(var i=0;i<n;i++){this._updateAssociation.call(this,c._ASSOCIATIONS[i],d);}};c.prototype.updateChartLabels=function(B){var m={value:Infinity},o={value:-Infinity},d={value:Infinity},e={value:-Infinity},f,g,x,y,h;h=B.getContexts();h.forEach(function(j){for(var i=0;i<this._oChartViewMetadata.dimensionFields.length;i++){x=this._oChartViewMetadata.dimensionFields[i];f=j.getProperty(x);y=this._oChartViewMetadata.measureFields[i];g=j.getProperty(y);m=(f<m.value)?{context:j,value:f,index:i}:m;o=(f>o.value)?{context:j,value:f,index:i}:o;d=(g<d.value)?{context:j,value:g,index:i}:d;e=(g>e.value)?{context:j,value:g,index:i}:e;}},this);if(d.context&&m.context&&e.context&&o.context){this._updateTopLabel.call(this,this._getLabelsMap()["leftTop"],d.context.getObject(),d.index);this._updateBottomLabel.call(this,this._getLabelsMap()["leftBottom"],m.context.getObject(),m.index);this._updateTopLabel.call(this,this._getLabelsMap()["rightTop"],e.context.getObject(),e.index);this._updateBottomLabel.call(this,this._getLabelsMap()["rightBottom"],o.context.getObject(),o.index);}};c.prototype._updateTopLabel=function(n,d,i){var v=d[this._aDataPointAnnotations[i].Value.Path],s=this._getTopLabelColor.call(this,v,d,i),f=this._getLabelNumberFormatter.call(this,this._aDataPointAnnotations[i].Value.Path),F;F=f.format(v);this._updateLabel(n,{text:F,color:s});};c.prototype._updateBottomLabel=function(n,d,i){var A,o,v,f;A=this._oChartViewMetadata.dimensionFields[i];if(A){v=d[A];o=this._getPropertyAnnotation.call(this,this._oChartViewMetadata.dimensionFields[i]);if(o.hasOwnProperty("sap:text")||o.hasOwnProperty("com.sap.vocabularies.Common.v1.Text")){var p=o["sap:text"]||o["com.sap.vocabularies.Common.v1.Text"].Path;f=d[p];}else{f=this._formatBottomLabel.call(this,v,o);}if(f){this._updateLabel(n,{text:f});}}};c.prototype._formatBottomLabel=function(v,d){var p=this._getSemanticsPattern.call(this,d);if(p){return this._formatSemanticsValue.call(this,v,p);}p=this._getCalendarPattern.call(this,d);if(p){return this._formatSemanticsValue.call(this,v,p);}return this._formatDateAndNumberValue.call(this,v);};c.prototype._formatSemanticsValue=function(v,p){if(p){if(this._oDateType){this._oDateType.setFormatOptions({style:"short",source:{pattern:p}});}else{this._oDateType=new a({style:"short",source:{pattern:p}});}return this._oDateType.formatValue(v,"string");}return null;};c.prototype._formatDateAndNumberValue=function(v){if(v instanceof Date){return this._getLabelDateFormatter.call(this).format(v);}else if(!isNaN(v)){return this._getLabelNumberFormatter.call(this,this._oChartViewMetadata.dimensionFields[0]).format(v);}else{return null;}};c.prototype._getSemanticsPattern=function(d){if(d.hasOwnProperty("sap:semantics")){switch(d["sap:semantics"]){case"yearmonthday":return"yyyyMMdd";case"yearmonth":return"yyyyMM";case"year":return"yyyy";default:return null;}}return null;};c.prototype._getCalendarPattern=function(d){for(var s in c._CALENDAR_TERMS_PATTERNS){if(d.hasOwnProperty(s)){return c._CALENDAR_TERMS_PATTERNS[s];}}return null;};c.prototype._getLabelNumberFormatter=function(p){var P=this._getPropertyAnnotation.call(this,p).precision||null;return N.getInstance({style:"short",showScale:true,precision:P});};c.prototype._getLabelDateFormatter=function(){return D.getInstance({style:"short"});};c.prototype._setAssociationText=function(d,e,f){if(!e){return;}if(e.Path&&f){d.setProperty("text",f[e.Path],false);}else if(e.Path){d.bindProperty("text",{path:e.Path,mode:sap.ui.model.BindingMode.OneWay});d.invalidate();}else if(e.String){if(e.String.indexOf("{")===0){var p=e.String.split(">");d.bindProperty("text",{path:p[1].substr(0,p[1].length-1),model:p[0].substr(1),mode:sap.ui.model.BindingMode.OneWay});d.invalidate();}else{d.setProperty("text",e.String,false);}}};c.prototype._getPropertyAnnotation=function(p){var m,e,E,P;m=this.getModel().getMetaModel();e=this._oChartProvider._oMetadataAnalyser.getEntityTypeNameFromEntitySetName(this.getEntitySet());E=m.getODataEntityType(e);P=m.getODataProperty(E,p);return P;};c.prototype._hasMember=function(o,p){var d=".",P=p.split(d),m=P.shift();return!!o&&((P.length>0)?this._hasMember(o[m],P.join(d)):o.hasOwnProperty(m));};c.prototype.getAccessibilityInfo=function(){var A={};var i=this.getAggregation("_chart");if(i&&i.getAccessibilityInfo){A=i.getAccessibilityInfo();}return A;};c.prototype._formatDimension=function(v){if(typeof v==="string"){var A=this._getPropertyAnnotation.call(this,this._oChartViewMetadata.dimensionFields[0]),p=this._getSemanticsPattern.call(this,A);if(p){v=D.getInstance({pattern:p}).parse(v);}}if(v instanceof Date){return parseFloat(v.getTime());}else if(!isNaN(v)){return parseFloat(v);}else{this.getAggregation("_chart").enableXIndexing(true);return 0;}};c.prototype.exit=function(){this._cleanup.call(this);};c.prototype.setEntitySet=function(e){if(this.getProperty("entitySet")!==e){this.setProperty("entitySet",e,true);this._initializeMetadata.call(this);}return this;};c.prototype.addAriaLabelledBy=function(A){this.addAssociation("ariaLabelledBy",A,true);this.getAggregation("_chart").addAriaLabelledBy(A);return this;};c.prototype.removeAriaLabelledBy=function(A){this.removeAssociation("ariaLabelledBy",A,true);this.getAggregation("_chart").removeAriaLabelledBy(A);return this;};c.prototype.removeAllAriaLabelledBy=function(){this.removeAllAssociation("ariaLabelledBy",true);this.getAggregation("_chart").removeAllAriaLabelledBy();return this;};c.prototype.setChartType=function(){return this;};c.prototype.propagateProperties=function(){if(b.prototype.propagateProperties){b.prototype.propagateProperties.apply(this,arguments);}this._initializeMetadata.call(this);};c.prototype._getBindingPath=function(){if(this.getChartBindingPath()){return this.getChartBindingPath();}else if(this.getEntitySet()){return"/"+this.getEntitySet();}else{return"";}};c.prototype._getSupportedChartTypes=function(){return this._CHART_TYPE;};c.prototype.setSize=function(s){if(this.getSize()!==s){if(s===S.Responsive){this.setProperty("isResponsive",true);}else{this.setProperty("isResponsive",false);}this.setProperty("size",s);}return this;};c.prototype.setIsResponsive=function(i){var s,d=this.getSize();this.setProperty("isResponsive",i);if(i){s=S.Responsive;}else{s=d===S.Responsive?S.Auto:d;}this.setProperty("size",s);return this;};c.prototype.setAssociation=function(A,i,s){if(b.prototype.setAssociation){b.prototype.setAssociation.apply(this,arguments);}this._updateAssociation.call(this,A);return this;};return c;});
