/*!
 * SAPUI5

		(c) Copyright 2009-2019 SAP SE. All rights reserved
	
 */
sap.ui.define(['jquery.sap.global','./library','./ExportDialog','sap/ui/base/EventProvider','sap/ui/Device','sap/ui/export/SpreadsheetExport','sap/base/Log','sap/base/assert','sap/ui/export/ExportUtils'],function(q,l,E,a,D,S,L,b,c){'use strict';var d=a.extend('sap.ui.export.Spreadsheet',{constructor:function(s){a.call(this);this.mSettings=q.extend(true,{},s);}});d.prototype.attachBeforeSave=function(o,h,f){this.attachEvent('beforeSave',o,h,f);return this;};d.prototype.detachBeforeSave=function(h,o){this.detachEvent('beforeSave',h,o);return this;};d.prototype.destroy=function(){a.prototype.destroy.apply(this,arguments);this.cancel();this.mSettings=null;this.bIsDestroyed=true;};d.prototype.cancel=function(){if(this.process){this.process.cancel();this.process=null;}};d.prototype.onprogress=function(P){L.debug("Spreadsheet export: "+P+"% loaded.");};var p=(function(){var r={};for(var k in l.EdmType){r[k.toLowerCase()]=k;}return r;})();var e="Spreadsheet export: ";function v(P){var f=e;var o="odata";var s=".xlsx";var g=P.count;var h;P.fileName=P.fileName||'export';if(!P.fileName.endsWith(s)){P.fileName+=s;}b(P.dataSource,f+"data source is not specified.");var i=P.dataSource;if(typeof i==="string"){P.dataSource={dataUrl:i,type:o,count:g};P.count=g;}else if(Array.isArray(i)){P.dataSource={data:i,type:"array"};}else if(i&&i.dataUrl){h=(i.type||o).toLowerCase();b([o].indexOf(h)>=0,f+"unsupported data source type.");P.dataSource.type=h;if(i.useBatch){b(i.serviceUrl,f+"serviceUrl is required for OData batch requests.");b(i.headers,f+"model.headers is required for OData batch requests.");}}var j=P.dataSource.sizeLimit;g=P.dataSource.count||g||1;if(P.dataSource.type===o&&(!j||isNaN(j))){j=Math.round(g/1000)*200;j=Math.min(10000,Math.max(j,200));L.info(f+"dataSource.sizeLimit is not provided. sizeLimit is set to "+j);P.dataSource.sizeLimit=j;}var k=P&&P.workbook;b(k&&Array.isArray(k.columns),f+"column configuration is not provided. Export is not possible");k.columns.forEach(function(m){b(m,f+"column configuration is not provided. Export is not possible.");b(m.property,f+"column property is not provided. The column is not exported.");b(m.label,f+"column label is not provided.");m.label=m.label||(m.property instanceof Array?m.property[0]:m.property)||"";var w=m.width;if(typeof w==="string"){var W=w.toLowerCase();w=parseFloat(W);if(W.indexOf("em")>0){w=w*2;}else if(W.indexOf("px")>0){w=w/8;}}if(isNaN(w)||w<1){w=10;}if(m.label.length<30){w=Math.max(m.label.length,w);}m.width=Math.round(w);if(m.type){m.type=m.type.toLowerCase();if(!p[m.type]){L.warning(f+"unsupported column property type "+m.type+". Type is reverted to 'string'.");m.type="";}if(m.type==="currency"&&!m.unitProperty){L.warning(f+"missing unit property for currency column. Type is reverted to 'string'.");m.type="";}}var n=m.scale;if(m.type==="number"&&isNaN(n)&&n!=="variable"){L.warning(f+"scale parameter for numerical column configuration is missing.");}if(typeof n==="string"){n=parseInt(n);}if(isNaN(n)){n=null;}m.scale=n;var t=(m.textAlign+"").toLowerCase();if(["begin","end"].indexOf(t)>-1){var r=["left","right"];t=(sap.ui.getCore().getConfiguration().getRTL()?r.reverse():r)[["begin","end"].indexOf(t)];}if(t!==""&&["left","right","center","begin","end"].indexOf(t)==-1){L.warning(f+"incorrect column alignment property: "+t+". Default alignment is used.");t="";}m.textAlign=t;});}d.prototype.build=function(){var s=this;var P=this.mSettings;if(this.bIsDestroyed){var m=e+'Cannot trigger build - the object has been destroyed';L.error(m);return Promise.reject(m);}v(P);return new Promise(function(r,R){var f;var g=D.system.desktop?2000000:100000;var n=P.dataSource.type=='array'?P.dataSource.data.length:P.dataSource.count;var h=P.workbook.columns.length;function o(j){if(!isNaN(j.progress)){if(f){f.updateStatus(j.progress);}s.onprogress(j.progress);}if(j.finish){s.process=null;if(!j.data){R('Spreadsheet export: The process was canceled');return;}var k=s.fireEvent('beforeSave',{data:j.data},true,true);if(f){window.setTimeout(function(){f.finish();},1000);}if(k){c.saveAsFile(new Blob([j.data],{type:'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'}),P.fileName);}r();}if(typeof j.error!='undefined'){s.process=null;if(f){f.finish();}R(j.error);E.showErrorMessage(j.error);}}function i(){if(P.showProgress===false){if(s.process){R("Cannot start export: the process is already running");return;}s.process=S.execute(P,o);return;}E.getProgressDialog().then(function(j){f=j;if(s.process){R("Cannot start export: the process is already running");return;}f.oncancel=function(){return s.process&&s.process.cancel();};f.open();s.process=S.execute(P,o);});}if(h<=0){R('No columns to export.');}else if(n*h>g||!n){E.showWarningDialog({rows:n,columns:h}).then(i).catch(function(){R('Export cancelled by the user.');});}else{i();}});};return d;},true);
