//@ui5-bundle sap/ui/export/library-preload.js
/*
 * ! SAPUI5

		(c) Copyright 2009-2019 SAP SE. All rights reserved
	
 */
sap.ui.predefine('sap/ui/export/library',['jquery.sap.global','sap/ui/core/library'],function(q,l){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.export",dependencies:["sap.ui.core"],types:["sap.ui.export.EdmType"],interfaces:[],controls:[],elements:[],version:"1.71.34"});sap.ui.export.EdmType={BigNumber:"BigNumber",Boolean:"Boolean",Currency:"Currency",Date:"Date",DateTime:"DateTime",Enumeration:"Enumeration",Number:"Number",String:"String",Time:"Time"};q.sap.registerModuleShims({'sap/ui/export/js/XLSXBuilder':{amd:true,exports:'XLSXBuilder'},'sap/ui/export/js/XLSXExportUtils':{amd:true,exports:'XLSXExportUtils'}});return sap.ui.export;});
/*!
 * SAPUI5

		(c) Copyright 2009-2019 SAP SE. All rights reserved
	
 */
sap.ui.predefine('sap/ui/export/ExportDialog',['sap/ui/core/library','sap/m/library','sap/m/Dialog','sap/m/Button','sap/m/ProgressIndicator','sap/m/Text','sap/m/MessageBox'],function(c,M,D,B,P,T,a){'use strict';var V=c.ValueState;var b=M.DialogType;var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.export",true);
function d(){return new Promise(function(R,f){var g;r.then(function(o){var h=new B({text:o.getText("CANCEL_BUTTON"),press:function(){if(g&&g.oncancel){g.oncancel();}g.finish();}});var p=new P({showValue:false,height:"0.75rem"});p.addStyleClass("sapUiMediumMarginTop");var m=new T({text:o.getText("PROGRESS_FETCHING_MSG")});g=new D({title:o.getText("PROGRESS_TITLE"),type:b.Message,contentWidth:"500px",content:[m,p],endButton:h,ariaLabelledBy:[m]});g.updateStatus=function(n){if(n>=100){h.setEnabled(false);m.setText(o.getText("PROGRESS_BUNDLE_MSG"));}p.setPercentValue(n);};g.finish=function(){g.close();g.destroy();};R(g);});});}
function s(p){return new Promise(function(R,f){r.then(function(o){var C,w,W,g;C=false;g=p.rows?o.getText("SIZE_WARNING_MSG",[p.rows,p.columns]):o.getText("NO_COUNT_WARNING_MSG");W=new T({text:g});w=new D({title:o.getText('PROGRESS_TITLE'),type:b.Message,state:V.Warning,content:W,ariaLabelledBy:W,beginButton:new B({text:o.getText("CANCEL_BUTTON"),press:function(){w.close();}}),endButton:new B({text:o.getText("EXPORT_BUTTON"),press:function(){C=true;w.close();}}),afterClose:function(){w.destroy();C?R():f();}});w.open();});});}
function e(m){r.then(function(R){var f=m||R.getText('PROGRESS_ERROR_DEFAULT');a.error(R.getText("PROGRESS_ERROR_MSG")+"\n"+f,{title:R.getText("PROGRESS_ERROR_TITLE")});});}
return{getProgressDialog:d,showErrorMessage:e,showWarningDialog:s};},true);
sap.ui.predefine('sap/ui/export/ExportUtils',['sap/ui/core/library','sap/m/library','sap/ui/model/json/JSONModel','sap/m/Dialog','sap/m/Text','sap/m/Label','sap/m/Input','sap/m/CheckBox','sap/m/Button','sap/m/Select','sap/m/VBox','sap/ui/core/Item','sap/base/util/uid','sap/ui/core/syncStyleClass','sap/base/Log','sap/ui/util/openWindow'],function(c,l,J,D,T,L,I,C,B,S,V,a,u,s,b,o){'use strict';var d=l.ButtonType;var e=c.ValueState;var r=sap.ui.getCore().getLibraryResourceBundle('sap.ui.export',true);
function g(f,R){var h={fileName:'Standard',fileType:[{key:'xlsx'}],selectedFileType:'xlsx',splitCells:false,includeFilterSettings:false,addDateTime:false};var E=Object.assign({},h,f||{});for(var i=0;i<E.fileType.length;i++){var j;if(!E.fileType[i].text){E.fileType[i].text=R.getText(E.fileType[i].key.toUpperCase()+'_FILETYPE');}if(E.fileType[i].key===E.selectedFileType){j=E.fileType[i].key;}}if(!j){E.selectedFileType=E.fileType[0].key;}return E;}
var U={_INTERCEPTSERVICE:'sap/ushell/cloudServices/interceptor/InterceptService',interceptUrl:function(f){var h=sap.ui.require(U._INTERCEPTSERVICE);if(h){var i=h.getInstance();if(i&&i.interceptUrl){f=i.interceptUrl(f);}}return f;},openExportSettingsDialog:function(f,O){return new Promise(function(R,h){var i;var j=new Promise(function(k,m){i=k;});var H={getUserInput:function(){return j;},cancel:function(){if(H._oExportSettingsDialog){H._oExportSettingsDialog.close();}}};r.then(function(k){var E=new J();E.setData(g(f,k));var m=u();H._oExportSettingsDialog=new D({id:m,title:k.getText('EXPORT_SETTINGS_TITLE'),horizontalScrolling:false,verticalScrolling:false,content:[new V({renderType:'Bare',width:'100%',items:[new L({text:k.getText('FILE_NAME'),labelFor:m+'-fileName'}),new I({id:m+'-fileName',value:'{/fileName}',liveChange:function(n){var p=n.getSource();var F=n.getParameter('value');var q=/[\\/:|?"*<>]/;var t=sap.ui.getCore().byId(m+'-export');var v=q.test(F);if(v){p.setValueState(e.Error);p.setValueStateText(k.getText('FILENAME_ERROR'));}else if(F.length>100){p.setValueState(e.Warning);p.setValueStateText(k.getText('FILENAME_WARNING'));}else{p.setValueState(e.None);p.setValueStateText(null);}t.setEnabled(!v);}}).addStyleClass('sapUiTinyMarginBottom'),new L({text:k.getText('SELECT_FORMAT'),labelFor:m+'-fileType',visible:false}),new S({id:m+'-fileType',width:'100%',selectedKey:'{/selectedFileType}',visible:false,items:{path:'/fileType',template:new a({key:'{key}',text:'{text}'})}}),new C({id:m+'-splitCells',selected:'{/splitCells}',text:k.getText('SPLIT_CELLS')}),new C({id:m+'-includeFilterSettings',selected:'{/includeFilterSettings}',text:k.getText('INCLUDE_FILTER_SETTINGS')}),new C({id:m+'-addDateTime',selected:'{/addDateTime}',text:k.getText('ADD_DATE_TIME'),visible:false})]}).addStyleClass('sapUiExportSettingsLabel')],endButton:new B({id:m+'-cancel',text:k.getText('CANCEL_BUTTON'),press:function(){H.cancel();}}),beginButton:new B({id:m+'-export',text:k.getText('EXPORT_BUTTON'),type:d.Emphasized,press:function(){if(H._oExportSettingsDialog){H._oExportSettingsDialog._bSuccess=true;i(E.getData());H._oExportSettingsDialog.close();}}}),afterClose:function(){if(!H._oExportSettingsDialog._bSuccess){i(null);}H._oExportSettingsDialog.destroy();H._oExportSettingsDialog=null;}});H._oExportSettingsDialog.addStyleClass('sapUiContentPadding sapUiExportSettings');H._oExportSettingsDialog.setModel(E);if(O){s('sapUiSizeCompact',O,H._oExportSettingsDialog);}H._oExportSettingsDialog.open();R(H);});});},_getReadableFilterValue:function(f){switch(f.op||f.name){case'==':return'='+f.right.value;case'>':case'<':case'!=':case'<=':case'>=':return f.op+f.right.value;case'between':return f.args[1].value+'...'+f.args[2].value;case'contains':return'*'+f.args[1].value+'*';case'endswith':return'*'+f.args[1].value;case'startswith':return f.args[1].value+'*';default:throw Error('getReadableFilter');}},_parseFilter:function(f){switch(f.type){case'Logical':return U._parseLogical(f);case'Binary':return U._parseBinary(f);case'Unary':return U._parseUnary(f);case'Call':return U._parseCall(f);default:throw Error('Filter type '+f.type+' not supported');}},_parseLogical:function(f){if(f.op=='&&'&&f.left.type==='Binary'&&f.right.type==='Binary'&&f.left.op==='>='&&f.right.op==='<='&&f.left.left.path===f.right.left.path){return U._parseCall({args:[{path:f.left.left.path,type:'Reference'},{type:'Literal',value:f.left.right.value},{type:'Literal',value:f.right.right.value}],name:'between',type:'Call'});}return U._parseFilter(f.left).concat(U._parseFilter(f.right));},_parseBinary:function(f){if(!f.left||f.left.type!='Reference'||!f.right||f.right.type!='Literal'){return[];}return[{key:f.left.path,value:U._getReadableFilterValue(f)}];},_parseUnary:function(f){var h;if(!f.arg){return[];}h=U._parseFilter(f.arg);h[0].value='!'+h[0].value;return h;},_parseCall:function(f){if(!f.args||f.args.length<2){return[];}return[{key:f.args[0].path,value:U._getReadableFilterValue(f)}];},parseFilterConfiguration:function(f,h){return new Promise(function(R,i){r.then(function(j){var F,k;F={name:j.getText('FILTER_HEADER'),items:[]};if(!f||!(f.isA('sap.ui.model.ListBinding')||f.isA('sap.ui.model.TreeBinding'))){b.error('A ListBinding is required for parsing the filter settings');i();return null;}var m=f.getFilterInfo();if(m){F.items=U._parseFilter(m);}if(typeof h==='function'){F.items.forEach(function(n){k=h(n.key);n.key=k&&typeof k==='string'?k:n.key;});}R(F);});});},getAvailableCloudExportTargets:function(){var f=U.getCloudExportService();return f.then(function(h){return h&&h.getSupportedTargets?h.getSupportedTargets():[];}).catch(function(){return[];});},getCloudExportService:function(){return sap.ushell&&sap.ushell.Container&&sap.ushell.Container.getServiceAsync?sap.ushell.Container.getServiceAsync('ProductivityIntegration'):Promise.reject();},saveAsFile:function(f,F){var h,i,j;if(!(f instanceof Blob)){return;}h=document.createElementNS('http://www.w3.org/1999/xhtml','a');i='download'in h;if(i){j=function(k,m){h.download=m;h.href=URL.createObjectURL(k);h.dispatchEvent(new MouseEvent('click'));};}if(typeof j==='undefined'){j=function(k){var m=new FileReader();m.onloadend=function(){var n,p;p=m.result.replace(/^data:[^;]*;/,'data:attachment/file;');n=o(p,'_blank');if(!n){window.location.href=p;}};m.readAsDataURL(k);};}if(typeof navigator!=='undefined'&&navigator.msSaveOrOpenBlob){j=function(k,m){window.navigator.msSaveOrOpenBlob(k,m);};}j(f,F);}};return U;},true);
sap.ui.predefine('sap/ui/export/Spreadsheet',['jquery.sap.global','./library','./ExportDialog','sap/ui/base/EventProvider','sap/ui/Device','sap/ui/export/SpreadsheetExport','sap/base/Log','sap/base/assert','sap/ui/export/ExportUtils'],function(q,l,E,a,D,S,L,b,c){'use strict';
var d=a.extend('sap.ui.export.Spreadsheet',{constructor:function(s){a.call(this);this.mSettings=q.extend(true,{},s);}});
d.prototype.attachBeforeSave=function(o,h,f){this.attachEvent('beforeSave',o,h,f);return this;};
d.prototype.detachBeforeSave=function(h,o){this.detachEvent('beforeSave',h,o);return this;};
d.prototype.destroy=function(){a.prototype.destroy.apply(this,arguments);this.cancel();this.mSettings=null;this.bIsDestroyed=true;};
d.prototype.cancel=function(){if(this.process){this.process.cancel();this.process=null;}};
d.prototype.onprogress=function(P){L.debug("Spreadsheet export: "+P+"% loaded.");};
var p=(function(){var r={};for(var k in l.EdmType){r[k.toLowerCase()]=k;}return r;})();var e="Spreadsheet export: ";
function v(P){var f=e;var o="odata";var s=".xlsx";var g=P.count;var h;P.fileName=P.fileName||'export';if(!P.fileName.endsWith(s)){P.fileName+=s;}b(P.dataSource,f+"data source is not specified.");var i=P.dataSource;if(typeof i==="string"){P.dataSource={dataUrl:i,type:o,count:g};P.count=g;}else if(Array.isArray(i)){P.dataSource={data:i,type:"array"};}else if(i&&i.dataUrl){h=(i.type||o).toLowerCase();b([o].indexOf(h)>=0,f+"unsupported data source type.");P.dataSource.type=h;if(i.useBatch){b(i.serviceUrl,f+"serviceUrl is required for OData batch requests.");b(i.headers,f+"model.headers is required for OData batch requests.");}}var j=P.dataSource.sizeLimit;g=P.dataSource.count||g||1;if(P.dataSource.type===o&&(!j||isNaN(j))){j=Math.round(g/1000)*200;j=Math.min(10000,Math.max(j,200));L.info(f+"dataSource.sizeLimit is not provided. sizeLimit is set to "+j);P.dataSource.sizeLimit=j;}var k=P&&P.workbook;b(k&&Array.isArray(k.columns),f+"column configuration is not provided. Export is not possible");k.columns.forEach(function(m){b(m,f+"column configuration is not provided. Export is not possible.");b(m.property,f+"column property is not provided. The column is not exported.");b(m.label,f+"column label is not provided.");m.label=m.label||(m.property instanceof Array?m.property[0]:m.property)||"";var w=m.width;if(typeof w==="string"){var W=w.toLowerCase();w=parseFloat(W);if(W.indexOf("em")>0){w=w*2;}else if(W.indexOf("px")>0){w=w/8;}}if(isNaN(w)||w<1){w=10;}if(m.label.length<30){w=Math.max(m.label.length,w);}m.width=Math.round(w);if(m.type){m.type=m.type.toLowerCase();if(!p[m.type]){L.warning(f+"unsupported column property type "+m.type+". Type is reverted to 'string'.");m.type="";}if(m.type==="currency"&&!m.unitProperty){L.warning(f+"missing unit property for currency column. Type is reverted to 'string'.");m.type="";}}var n=m.scale;if(m.type==="number"&&isNaN(n)&&n!=="variable"){L.warning(f+"scale parameter for numerical column configuration is missing.");}if(typeof n==="string"){n=parseInt(n);}if(isNaN(n)){n=null;}m.scale=n;var t=(m.textAlign+"").toLowerCase();if(["begin","end"].indexOf(t)>-1){var r=["left","right"];t=(sap.ui.getCore().getConfiguration().getRTL()?r.reverse():r)[["begin","end"].indexOf(t)];}if(t!==""&&["left","right","center","begin","end"].indexOf(t)==-1){L.warning(f+"incorrect column alignment property: "+t+". Default alignment is used.");t="";}m.textAlign=t;});}
d.prototype.build=function(){var s=this;var P=this.mSettings;if(this.bIsDestroyed){var m=e+'Cannot trigger build - the object has been destroyed';L.error(m);return Promise.reject(m);}v(P);return new Promise(function(r,R){var f;var g=D.system.desktop?2000000:100000;var n=P.dataSource.type=='array'?P.dataSource.data.length:P.dataSource.count;var h=P.workbook.columns.length;function o(j){if(!isNaN(j.progress)){if(f){f.updateStatus(j.progress);}s.onprogress(j.progress);}if(j.finish){s.process=null;if(!j.data){R('Spreadsheet export: The process was canceled');return;}var k=s.fireEvent('beforeSave',{data:j.data},true,true);if(f){window.setTimeout(function(){f.finish();},1000);}if(k){c.saveAsFile(new Blob([j.data],{type:'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'}),P.fileName);}r();}if(typeof j.error!='undefined'){s.process=null;if(f){f.finish();}R(j.error);E.showErrorMessage(j.error);}}function i(){if(P.showProgress===false){if(s.process){R("Cannot start export: the process is already running");return;}s.process=S.execute(P,o);return;}E.getProgressDialog().then(function(j){f=j;if(s.process){R("Cannot start export: the process is already running");return;}f.oncancel=function(){return s.process&&s.process.cancel();};f.open();s.process=S.execute(P,o);});}if(h<=0){R('No columns to export.');}else if(n*h>g||!n){E.showWarningDialog({rows:n,columns:h}).then(i).catch(function(){R('Export cancelled by the user.');});}else{i();}});};
return d;},true);
sap.ui.predefine('sap/ui/export/SpreadsheetExport',['jquery.sap.global','sap/base/Log','sap/ui/Device'],function(q,L,D){'use strict';var a='sap/ui/export/js/libs/JSZip3',b='sap/ui/export/js/XLSXExportUtils',c='sap/ui/export/js/XLSXBuilder';
function d(p,C){function f(m){return C&&C(m);}function o(v){f({progress:v});}function g(e){f({error:e.message||e});}function h(A){f({finish:true,data:A});}function i(){var S;var e;var t;function m(X,x){e=X.oData.getConverter(p);S=new x(p.workbook.columns,p.workbook.context,p.workbook.hierarchyLevel,p.customizing);o(0);t=window.setTimeout(r,0);}function r(){if(S){var x=p.dataSource.data||[];var R=e(x.slice());S.append(R);o(50);t=window.setTimeout(u,0);}}function u(){if(S){S.build().then(v);}}function v(x){h(x);S=null;}function w(){window.clearTimeout(t);v();}sap.ui.require([b,c,a],m);return{cancel:w};}function n(u){if(!u){return u;}try{return new URL(u,document.baseURI).toString();}catch(e){return window.URI(u).absoluteTo(document.baseURI).toString();}}function j(){var S,r;function e(X,v){S=new v(p.workbook.columns,p.workbook.context,p.workbook.hierarchyLevel,p.customizing);r=X.oData.fetch(p,m);o(0);}function m(M){if(M.rows){S.append(M.rows);}if(M.progress){o(M.progress);}if(M.error||typeof M.error==='string'){S=null;return g(M.error);}return M.finished&&S.build().then(t);}function t(v){h(v);S=null;}function u(){r.cancel();h();S=null;}sap.ui.require([b,c,a],e);return{cancel:u};}function k(){var m;var r=q.extend(true,{},p);var w=typeof r.worker==='object'?r.worker:{};var t=function(){m.postMessage({cancel:true});h();};function u(z){var A=new Worker(z);A.onmessage=function(e){if(e.data.status){o(e.data.status);}else if(e.data.error||typeof e.data.error==='string'){g(e.data.error);}else{h(e.data);}};A.postMessage(r);return A;}function v(){L.warning('Direct worker is not allowed. Load the worker via blob.');var e=window.URI(w.base).absoluteTo("").search("").hash("").toString();w.src=e+w.ref;var z='self.origin = "'+e+'"; '+'importScripts("'+w.src+'")';var A=new Blob([z]);var B=window.URL.createObjectURL(A);return u(B);}function x(){L.warning('Blob worker is not allowed. Use in-process export.');t=j(r).cancel;}function y(X){try{m=u(w.src);m.addEventListener('error',function(e){m=v();m.addEventListener('error',function(e){x();e.preventDefault();});e.preventDefault();});}catch(z){try{m=v();}catch(A){x();}}}r.dataSource.dataUrl=n(r.dataSource.dataUrl);r.dataSource.serviceUrl=n(r.dataSource.serviceUrl);w.base=w.base||sap.ui.require.toUrl('sap/ui/export/js/','');w.ref=w.ref||'SpreadsheetWorker.js';w.src=w.base+w.ref;sap.ui.require([b],y);return{cancel:function(){t();}};}var l=sap.ui.getCore().getConfiguration().getFormatSettings().getCustomCurrencies();if(l){var s;p.customizing=p.customizing||{};p.customizing.currency={};for(s in l){p.customizing.currency[s]={scale:l[s].digits};}}if(p.dataSource.type==='array'){return i();}else if(p.worker===false||sap.ui.disableExportWorkers===true||(D.browser.msie&&p.dataSource.dataUrl.indexOf('.')===0)){return j();}else{return k();}}
return{execute:d};},true);
sap.ui.require.preload({
	"sap/ui/export/manifest.json":'{"_version":"1.9.0","sap.app":{"id":"sap.ui.export","type":"library","embeds":[],"applicationVersion":{"version":"1.71.34"},"title":"UI5 library: sap.ui.export","description":"UI5 library: sap.ui.export","ach":"CA-UI5-TBL","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_belize","sap_belize_plus","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.71","libs":{"sap.ui.core":{"minVersion":"1.71.34"}}},"library":{"i18n":"messagebundle.properties","content":{"controls":[],"elements":[],"types":["sap.ui.export.EdmType"],"interfaces":[]}}}}'
},"sap/ui/export/library-preload"
);
//# sourceMappingURL=library-preload.js.map