/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/ui/model/resource/ResourceModel","sap/base/util/ObjectPath","sap/base/util/merge","sap/base/util/deepClone","sap/ui/model/json/JSONModel","sap/base/i18n/ResourceBundle"],function(C,R,O,m,d,J,a){"use strict";var B=C.extend("sap.ui.integration.designtime.controls.BaseEditor",{metadata:{properties:{"config":{type:"object"},"json":{type:"object"},"_defaultConfig":{type:"object",visibility:"hidden",defaultValue:{}}},aggregations:{"_propertyEditors":{type:"sap.ui.core.Control",visibility:"hidden"}},events:{jsonChanged:{parameters:{json:{type:"object"}}},propertyEditorsReady:{parameters:{propertyEditors:{type:"array"}}}}},renderer:function(r,e){r.openStart("div",e);r.openEnd();e.getPropertyEditors().forEach(function(p){r.renderControl(p);});r.close("div");},exit:function(){this._cleanup();},setJson:function(j){var o;if(typeof j==="string"){o=JSON.parse(j);}else{o=d(j);}var r=this.setProperty("json",o,false);this._initialize();return r;},addDefaultConfig:function(c){this.setProperty("_defaultConfig",this._mergeConfig(this.getProperty("_defaultConfig"),c));this.setConfig(this._oUnmergedConfig||{});return this;},setConfig:function(c){this._oUnmergedConfig=c;return this._setConfig(this._mergeConfig(this.getProperty("_defaultConfig"),c));},getPropertyEditor:function(p){return this._mPropertyEditors[p];},getPropertyEditors:function(t){var h=function(p,T){return p.getConfig().tags&&(p.getConfig().tags.indexOf(T)!==-1);};if(!t){return this.getAggregation("_propertyEditors")||[];}else if(typeof t==="string"){return this.getPropertyEditors().filter(function(p){return h(p,t);});}else if(Array.isArray(t)){return this.getPropertyEditors().filter(function(p){return t.every(function(T){return h(p,T);});});}else{return[];}}});B.prototype._mergeConfig=function(t,s){var r=m({},t,s);r.i18n=[].concat(t.i18n||[],s.i18n||[]);return r;};B.prototype._setConfig=function(c){var r=this.setProperty("config",c,false);this._initialize();return r;};B.prototype._cleanup=function(c){if(this._oI18nModel){this._oI18nModel.destroy();delete this._oI18nModel;}if(this._oContextModel){this._oContextModel.destroy();delete this._oContextModel;}delete this._mEditorClasses;this._mPropertyEditors={};this.destroyAggregation("_propertyEditors");};B.prototype._initialize=function(){this._cleanup();var j=this.getJson();var c=this.getConfig();if(j&&c&&c.properties){var o=j;if(c.context){o=O.get(c.context.split("/"),this.getJson());}this._oContextModel=new J(o);this._oContextModel.setDefaultBindingMode("OneWay");this._createI18nModel();this._createEditors();}};B.prototype._createI18nModel=function(){var c=this.getConfig();c.i18n.forEach(function(i){a.create({url:sap.ui.require.toUrl(i),async:true}).then(function(b){if(!this._oI18nModel){this._oI18nModel=new R({bundle:b});this.setModel(this._oI18nModel,"i18n");this._oI18nModel.setDefaultBindingMode("OneWay");}else{this._oI18nModel.enhance(b);}}.bind(this));}.bind(this));};B.prototype._createEditors=function(){var c=this.getConfig();var t=Object.keys(c.propertyEditors);var M=t.map(function(T){return c.propertyEditors[T];});this._mEditorClasses={};this._iCreateEditorsCallCount=(this._iCreateEditorsCallCount||0)+1;var i=this._iCreateEditorsCallCount;sap.ui.require(M,function(){if(this._iCreateEditorsCallCount===i){Array.from(arguments).forEach(function(E,I){this._mEditorClasses[t[I]]=E;}.bind(this));Object.keys(c.properties).forEach(function(p){var P=this.getConfig().properties[p];var e=this.createPropertyEditor(P);if(e){this._mPropertyEditors[p]=e;this.addAggregation("_propertyEditors",this._mPropertyEditors[p]);}}.bind(this));this.firePropertyEditorsReady({propertyEditors:this.getPropertyEditors()});}}.bind(this));};B.prototype.createPropertyEditor=function(p){var E=this._mEditorClasses[p.type];if(E){var P=new E({editor:this});P.setModel(this._oContextModel,"_context");P.setConfig(d(p));P.attachPropertyChanged(this._onPropertyChanged.bind(this));P.addStyleClass("sapUiTinyMargin");return P;}};B.prototype._onPropertyChanged=function(e){var p=e.getParameter("path");var P=p.split("/");this._oContext=this._oContextModel.getData();O.set(P,e.getParameter("value"),this._oContext);this._oContextModel.checkUpdate();this.fireJsonChanged({json:d(this.getJson())});};return B;});
