/*
 * ! SAPUI5

		(c) Copyright 2009-2019 SAP SE. All rights reserved
	
 */
sap.ui.define(['sap/ui/mdc/link/ILinkHandler','sap/ui/mdc/link/LinkItem','sap/ui/mdc/link/Factory','sap/ui/mdc/link/Log','sap/base/Log','sap/base/util/isPlainObject'],function(I,L,F,a,S,i){"use strict";var b=I.extend("sap.ui.mdc.link.FlpLinkHandler",{metadata:{library:"sap.ui.mdc",properties:{semanticObjects:{type:"string[]",defaultValue:[]},mainSemanticObject:{type:"string"},textOfMainItem:{type:"string"},descriptionOfMainItem:{type:"string"},iconOfMainItem:{type:"string"}},aggregations:{semanticObjectMappings:{type:"sap.ui.mdc.link.SemanticObjectMapping",multiple:true,singularName:"semanticObjectMapping"},semanticObjectUnavailableActions:{type:"sap.ui.mdc.link.SemanticObjectUnavailableAction",multiple:true,singularName:"semanticObjectUnavailableAction"}}}});b.prototype._getInfoLog=function(){if(this._oInfoLog){return this._oInfoLog;}if(S.getLevel()>=S.Level.INFO){this._oInfoLog=new a();this._oInfoLog.initialize(this.getSemanticObjects(),this._getContextObject());return this._oInfoLog;}return undefined;};b.prototype._getLogFormattedText=function(){return(this._oInfoLog&&!this._oInfoLog.isEmpty())?"---------------------------------------------\nsap.ui.mdc.field.FlpLinkHandler:\nBelow you can see detailed information regarding semantic attributes which have been calculated for one or more semantic objects defined in a FlpLinkHandler control. Semantic attributes are used to create the URL parameters. Additionally you can see all links containing the URL parameters.\n"+this._oInfoLog.getFormattedText():"No logging data available";};b.prototype.hasPotentialLinks=function(){if(!!this.getModifyItemsCallback()){return Promise.resolve(true);}if(this.getItems().length){return Promise.resolve(true);}return b.hasDistinctSemanticObject(this.getSemanticObjects());};b.prototype.determineItems=function(){var c=this._getContextObject();var o=this._getInfoLog();if(o){o.initialize(this.getSemanticObjects());this.getItems().forEach(function(d){o.addIntent(a.IntentType.API,{text:d.getText(),intent:d.getHref()});});}if(this.getModifyItemsCallback()){return this.getModifyItemsCallback()(c,this).then(function(){if(o){this.getItems().forEach(function(d){o.addIntent(a.IntentType.BREAKOUT,{text:d.getText(),intent:d.getHref()});});S.info(this._getLogFormattedText());}return this.getItems();}.bind(this));}else{var s=this.calculateSemanticAttributes(c);return this.retrieveNavigationTargets("",s).then(function(l,O){var d=this.getItems();var f=function(k){return d.some(function(g){return g.getKey()===k;});};l.forEach(function(g){if(!f(g.getKey())){this.addItem(g);}}.bind(this));var t=this.getTextOfMainItem();var D=this.getDescriptionOfMainItem();var e=this.getIconOfMainItem();var m=this.getItems().filter(function(g){return g.getIsMain()===true;});if(m.length===0&&(!!t||!!D||!!e)){this.addItem(new L({key:this.getId()+"-defaultMainItem",isMain:true,text:t?t:undefined,description:D?D:undefined,icon:e?e:undefined}));}if(o){S.info(this._getLogFormattedText());}return this.getItems();}.bind(this));}};b.prototype._getContextObject=function(){var c=sap.ui.getCore().byId(this.getSourceControl());var B=c&&c.getBindingContext()||this.getBindingContext();return B?B.getObject(B.getPath()):undefined;};b.prototype._convertSemanticObjectMapping=function(){var u=this.getSemanticObjectMappings();if(!u.length){return undefined;}var s={};u.forEach(function(U){if(!U.getSemanticObject()){throw Error("FlpLinkHandler: 'semanticObject' property with value '"+U.getSemanticObject()+"' is not valid");}s[U.getSemanticObject()]=U.getItems().reduce(function(m,o){m[o.getKey()]=o.getValue();return m;},{});});return s;};b.prototype._convertSemanticObjectUnavailableAction=function(){var u=this.getSemanticObjectUnavailableActions();if(!u.length){return undefined;}var s={};u.forEach(function(U){if(!U.getSemanticObject()){throw Error("FlpLinkHandler: 'semanticObject' property with value '"+U.getSemanticObject()+"' is not valid");}s[U.getSemanticObject()]=U.getActions();});return s;};b.prototype.calculateSemanticAttributes=function(c){var o=this._getInfoLog();var s=this._convertSemanticObjectMapping();var d=this.getSemanticObjects();if(!d.length){d.push("");}var r={};d.forEach(function(e){if(o){o.addContextObject(e,c);}r[e]={};for(var A in c){var f=null,t=null;if(o){f=o.getSemanticObjectAttribute(e,A);if(!f){f=o.createAttributeStructure();o.addSemanticObjectAttribute(e,A,f);}}if(c[A]===undefined||c[A]===null){if(f){f.transformations.push({value:undefined,description:"\u2139 Undefined and null values have been removed in FlpLinkHandler."});}continue;}if(i(c[A])){if(f){f.transformations.push({value:undefined,description:"\u2139 Plain objects has been removed in FlpLinkHandler."});}continue;}var g=(s&&s[e]&&s[e][A])?s[e][A]:A;if(f&&A!==g){t={value:undefined,description:"\u2139 The attribute "+A+" has been renamed to "+g+" in FlpLinkHandler.",reason:"\ud83d\udd34 A com.sap.vocabularies.Common.v1.SemanticObjectMapping annotation is defined for semantic object "+e+" with source attribute "+A+" and target attribute "+g+". You can modify the annotation if the mapping result is not what you expected."};}if(r[e][g]){S.error("FlpLinkHandler: The attribute "+A+" can not be renamed to the attribute "+g+" due to a clash situation. This can lead to wrong navigation later on.");}r[e][g]=c[A];if(f){if(t){f.transformations.push(t);var h=o.createAttributeStructure();h.transformations.push({value:c[A],description:"\u2139 The attribute "+g+" with the value "+c[A]+" has been added due to a mapping rule regarding the attribute "+A+" in FlpLinkHandler."});o.addSemanticObjectAttribute(e,g,h);}}}});return r;};b.prototype.retrieveNavigationTargets=function(A,s){var N={ownNavigation:undefined,availableActions:[]};return sap.ui.getCore().loadLibrary('sap.ui.fl',{async:true}).then(function(){return new Promise(function(r){sap.ui.require(['sap/ui/fl/Utils'],function(U){var c=F.getService("CrossApplicationNavigation");var u=F.getService("URLParsing");if(!c||!u){S.error("FlpLinkHandler: Service 'CrossApplicationNavigation' or 'URLParsing' could not be obtained");return r(N.availableActions,N.ownNavigation);}var d=this.getSemanticObjects();var C=sap.ui.getCore().byId(this.getSourceControl());var o=U.getAppComponentForControl(C);var p=d.map(function(e){return[{semanticObject:e,params:s?s[e]:undefined,appStateKey:A,ui5Component:o,sortResultsBy:"text"}];});return new Promise(function(){c.getLinks(p).then(function(l){if(!l||!l.length){return r(N.availableActions,N.ownNavigation);}var m=this.getMainSemanticObject();var t=this.getTextOfMainItem();var D=this.getDescriptionOfMainItem();var e=this.getIconOfMainItem();var f=this._convertSemanticObjectUnavailableAction();var g=c.hrefForExternal();var h=this._getInfoLog();if(g&&g.indexOf("?")!==-1){g=g.split("?")[0];}if(g){g+="?";}var j=function(q,v){return!!f&&!!f[q]&&f[q].indexOf(v)>-1;};var k=function(q){var v=u.parseShellHash(q.intent);if(j(v.semanticObject,v.action)){return;}var H=c.hrefForExternal({target:{shellHash:q.intent}},o);if(q.intent&&q.intent.indexOf(g)===0){N.ownNavigation=new L({href:H,text:q.text});return;}var w=v.semanticObject===m&&v.action&&(v.action==='displayFactSheet');var x=new L({key:(v.semanticObject&&v.action)?(v.semanticObject+"-"+v.action):undefined,text:w&&t?t:q.text,description:w&&D?D:undefined,href:H,icon:w?e:undefined,isMain:w,isSuperior:(q.tags&&q.tags.indexOf("superiorAction")>-1)});N.availableActions.push(x);if(h){h.addSemanticObjectIntent(v.semanticObject,{intent:x.getHref(),text:x.getText()});}};for(var n=0;n<d.length;n++){l[n][0].forEach(k);}return r(N.availableActions,N.ownNavigation);}.bind(this),function(){S.error("FlpLinkHandler: 'retrieveNavigationTargets' failed executing getLinks method");return r(N.availableActions,N.ownNavigation);});}.bind(this));}.bind(this));}.bind(this));}.bind(this));};b.mSemanticObjects={};b.oPromise=null;b.hasDistinctSemanticObject=function(s){if(b._haveBeenRetrievedAllSemanticObjects(s)){return Promise.resolve(b._atLeastOneExistsSemanticObject(s));}return b._retrieveDistinctSemanticObjects().then(function(){return b._atLeastOneExistsSemanticObject(s);});};b._haveBeenRetrievedAllSemanticObjects=function(s){return s.filter(function(c){return!b.mSemanticObjects[c];}).length===0;};b._atLeastOneExistsSemanticObject=function(s){return s.some(function(c){return b.mSemanticObjects[c]&&b.mSemanticObjects[c].exists===true;});};b._retrieveDistinctSemanticObjects=function(){if(!b.oPromise){b.oPromise=new Promise(function(r){var c=F.getService("CrossApplicationNavigation");if(!c){S.error("FlpLinkHandler: Service 'CrossApplicationNavigation' could not be obtained");return r({});}c.getDistinctSemanticObjects().then(function(d){d.forEach(function(s){b.mSemanticObjects[s]={exists:true};});b.oPromise=null;return r(b.mSemanticObjects);},function(){S.error("FlpLinkHandler: getDistinctSemanticObjects() of service 'CrossApplicationNavigation' failed");return r({});});});}return b.oPromise;};b.destroyDistinctSemanticObjects=function(){b.mSemanticObjects={};};return b;},true);
