/*
 * ! SAPUI5

		(c) Copyright 2009-2019 SAP SE. All rights reserved
	
 */
sap.ui.define(["sap/ui/core/Control","sap/m/List","sap/m/StandardListItem","sap/m/OverflowToolbar","sap/m/ToolbarSpacer","sap/m/Title","sap/m/Button","sap/m/SearchField","sap/m/FlexBox","sap/ui/model/json/JSONModel","sap/ui/model/Filter","sap/ui/core/dnd/DragDropInfo"],function(C,L,S,O,T,a,B,b,F,J,c,D){"use strict";var d=C.extend("sap.ui.mdc.p13n.SortableUI",{library:"sap.ui.mdc",metadata:{defaultAggregation:"template",properties:{fetchFields:{type:"function"},title:{type:"string",defaultValue:""},noData:{type:"string",defaultValue:""},multiSelection:{type:"boolean",defaultValue:false}},aggregations:{_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},template:{type:"sap.ui.core.Control",multiple:false}}},init:function(){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");this._oList=new L(this.getId()+"-list",{growing:true,growingThreshold:50,growingScrollToLoad:true,mode:"SingleSelectMaster",includeItemInSelection:true,rememberSelections:false,noDataText:this.getNoData(),sticky:["HeaderToolbar"],headerToolbar:new O({content:[new a(this.getId()+"-title",{text:this.getTitle()})].concat(this.getToolbarActions()).concat([new b({width:"15rem",liveChange:[this._onSearch,this]}),new B({icon:"sap-icon://collapse-group",tooltip:r.getText("sortableui.MOVE_TO_TOP"),press:[this._onMoveTop,this]}),new B({icon:"sap-icon://slim-arrow-up",tooltip:r.getText("sortableui.MOVE_UP"),press:[this._onMoveUp,this]}),new B({icon:"sap-icon://slim-arrow-down",tooltip:r.getText("sortableui.MOVE_DOWN"),press:[this._onMoveDown,this]}),new B({icon:"sap-icon://expand-group",tooltip:r.getText("sortableui.MOVE_TO_BOTTOM"),press:[this._onMoveBottom,this]})])}),dragDropConfig:[new D({sourceAggregation:"items",targetAggregation:"items",dropPosition:"Between",drop:[this._onRearrange,this],dragStart:[this._onDragStart,this]})]});this._oModel=new J([]);this._oList.setModel(this._oModel);this.setAggregation("_content",this._oList);},renderer:function(r,o){r.write("<div");r.writeControlData(o);r.addClass("sapUiMDCSortableUI");r.writeClasses();r.write(">");r.renderControl(o.getAggregation("_content"));r.write("</div>");}});d.prototype.exit=function(){this._oList=null;this._oModel.destroy();this._oModel=null;};d.prototype.getList=function(){return this._oList;};d.prototype.setTitle=function(t){this.setProperty("title",t,true);sap.ui.getCore().byId(this.getId()+"-title").setText(t);return this;};d.prototype.setNoData=function(n){this.setProperty("noData",n,true);this._oList.setNoData(n);return this;};d.prototype.setMultiSelection=function(m){this.setProperty("multiSelection",m,true);this._oList.setMode(this.getMultiSelection()?"MultiSelect":"SingleSelectMaster");return this;};d.prototype.getToolbarActions=function(){return[new T()];};d.prototype.getDefaultTemplate=function(){return new S({title:"{label}"});};d.prototype.bindListItems=function(m){this._oList.bindItems(Object.assign({path:"/",key:"label",templateShareable:false,template:this.getTemplate()?this.getTemplate().clone():this.getDefaultTemplate()},m));};d.prototype.setTemplate=function(t){this.setAggregation("template",t);this.bindListItems();return this;};d.prototype.setFetchFields=function(f){this.setProperty("fetchFields",f,true);this.refreshFields();return this;};d.prototype.refreshFields=function(){var f=this.getFetchFields()()||[];f.sort(function(m,e){if(m.selected&&e.selected){return(m.position||0)-(e.position||0);}else if(m.selected){return-1;}else if(e.selected){return 1;}return 0;});this._oModel.setData(f);if(!this.getTemplate()){this.bindListItems();}};d.prototype.getFields=function(){return this._oModel.getData().slice();};d.prototype.getSelectedFields=function(){return this._oList.getSelectedItems().map(function(i){return i.getBindingContext();});};d.prototype._onSearch=function(e){this._oList.getBinding("items").filter(new c("label","Contains",e.getParameter("newValue")));};d.prototype._moveItem=function(i,n){var I=this._oList.getItems();var f=this._oModel.getData();var o=f.indexOf(i.getBindingContext().getObject());n=(n<=0)?0:Math.min(n,I.length-1);n=f.indexOf(I[n].getBindingContext().getObject());if(n==o){return;}f.splice(n,0,f.splice(o,1)[0]);this._oModel.setData(f);I=this._oList.getItems();I[n].setSelected(true).focus();};d.prototype._moveSelectedItem=function(n){var i=this._oList.getItems();var s=this._oList.getSelectedItem();var e=i.indexOf(s);if(e<0){return;}var N=(typeof n=="number")?n:e+(n=="Up"?-1:1);this._moveItem(s,N,true);};d.prototype._onMoveTop=function(e){this._moveSelectedItem(0);};d.prototype._onMoveUp=function(e){this._moveSelectedItem("Up");};d.prototype._onMoveDown=function(e){this._moveSelectedItem("Down");};d.prototype._onMoveBottom=function(e){this._moveSelectedItem(this._oList.getItems().length-1);};d.prototype._onRearrange=function(e){var o=e.getParameter("draggedControl");var f=e.getParameter("droppedControl");var s=e.getParameter("dropPosition");var i=this._oList.indexOfItem(o);var g=this._oList.indexOfItem(f);var A=g+(s=="Before"?0:1)+(i<g?-1:0);this._moveItem(o,A);};d.prototype._onDragStart=function(e){e.getParameter("target").setSelected(true);};return d;},true);
