/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/model/TreeBinding','sap/ui/model/ChangeReason','sap/ui/model/Filter','sap/ui/model/FilterOperator','sap/ui/model/FilterProcessor','sap/ui/model/FilterType','sap/ui/model/Sorter','sap/ui/model/odata/CountMode','sap/ui/model/TreeAutoExpandMode','./odata4analytics','./BatchResponseCollector','./AnalyticalVersionInfo',"sap/base/util/uid","sap/ui/thirdparty/jquery","sap/base/Log"],function(T,C,F,a,b,c,S,d,f,t,B,A,u,Q,L){"use strict";var v="sap.ui.model.analytics.AnalyticalBinding",w=L.getLogger(v);function x(o){var e=new t.QueryResultRequest(o.oAnalyticalQueryResult),g,s,h,i,j,m,n,p,k=o.mParameters.select.split(","),l=D(k,o.sPath);e.setAggregationLevel(o.aMaxAggregationLevel);e.setMeasures(o.aMeasureName);Object.keys(o.oDimensionDetailsSet).forEach(function(q){h=o.oDimensionDetailsSet[q];e.includeDimensionKeyTextAttributes(q,true,h.textPropertyName!==undefined,h.aAttributeName);});Object.keys(o.oMeasureDetailsSet).forEach(function(M){m=o.oMeasureDetailsSet[M];e.includeMeasureRawFormattedValueUnit(M,m.rawValuePropertyName!==undefined,m.formattedValuePropertyName!==undefined,m.unitPropertyName!==undefined);});s=e.getURIQueryOptionValue("$select");if(s){g=s.split(",");for(i=0,n=g.length;i<n;i++){p=g[i];j=k.indexOf(p);if(j<0){w.warning("Ignored the 'select' binding parameter, because"+" it does not contain the property '"+p+"'",o.sPath);l=true;}else{k.splice(j,1);}}}for(i=0,n=k.length;i<n;i++){p=k[i];h=o.oAnalyticalQueryResult.findDimensionByPropertyName(p);if(h&&o.oDimensionDetailsSet[h.getName()]===undefined){y(o.sPath,p,h);l=true;}m=o.oAnalyticalQueryResult.findMeasureByPropertyName(p);if(m&&o.oMeasureDetailsSet[m.getName()]===undefined){y(o.sPath,p,m);l=true;}}return l?[]:k;}function y(p,s,o){var e=o instanceof sap.ui.model.analytics.odata4analytics.Dimension?"dimension":"measure";if(o.getName()===s){w.warning("Ignored the 'select' binding parameter, because it contains"+" the "+e+" property '"+s+"' which is not contained in the analytical info (see updateAnalyticalInfo)",p);}else{w.warning("Ignored the 'select' binding parameter, because the property '"+s+"' is associated with the "+e+" property '"+o.getName()+"' which is not contained in the analytical"+" info (see updateAnalyticalInfo)",p);}}function D(s,p){var e,g=false,i,n;for(i=0,n=s.length;i<n;i++){s[i]=s[i].trim();}for(i=s.length-1;i>=0;i--){e=s[i];if(s.indexOf(e)!==i){w.warning("Ignored the 'select' binding parameter, because it"+" contains the property '"+e+"' multiple times",p);s.splice(i,1);g=true;}}return g;}var E=T.extend("sap.ui.model.analytics.AnalyticalBinding",{constructor:function(m,p,o,s,e,P){T.call(this,m,p,o,e,P);this.aAdditionalSelects=[];this.sEntitySetName=(P&&P.entitySet)?P.entitySet:undefined;this.bArtificalRootContext=false;this.aApplicationFilter=this._convertDeprecatedFilterObjects(e);this.aControlFilter=undefined;this.aSorter=s?s:[];this.aMaxAggregationLevel=[];this.aAggregationLevel=[];this.oPendingRequests={};this.oPendingRequestHandle=[];this.oGroupedRequests={};this.bUseBatchRequests=(P&&P.useBatchRequests===true)?true:false;this.bProvideTotalSize=(P&&P.provideTotalResultSize===false)?false:true;this.bProvideGrandTotals=(P&&P.provideGrandTotals===false)?false:true;this.bReloadSingleUnitMeasures=(P&&P.reloadSingleUnitMeasures===false)?false:true;this.bUseAcceleratedAutoExpand=(P&&P.useAcceleratedAutoExpand===false)?false:true;this.bNoPaging=(P&&P.noPaging===true)?true:false;this.iTotalSize=-1;this.mServiceKey={};this.mServiceLength={};this.mServiceFinalLength={};this.mKeyIndex={};this.mFinalLength=this.mServiceFinalLength;this.mLength={};this.mMultiUnitKey={};this.aMultiUnitLoadFactor={};this.bNeedsUpdate=false;this.bApplySortersToGroups=true;this.sLastAutoExpandMode=undefined;this.mEntityKey={};this.sCustomParams=this.oModel.createCustomParams({custom:this.mParameters.custom});this.oAnalyticalQueryResult=null;this.aAnalyticalInfo=[];this.mAnalyticalInfoByProperty={};this.aBatchRequestQueue=[];if(P&&P.countMode==d.None){w.fatal("requested count mode is ignored; OData requests will include $inlinecout options");}else if(P&&(P.countMode==d.Request||P.countMode==d.Both)){w.warning("default count mode is ignored; OData requests will include $inlinecout options");}else if(this.oModel.sDefaultCountMode==d.Request){w.warning("default count mode is ignored; OData requests will include $inlinecout options");}this.iModelVersion=A.getVersion(this.oModel);if(this.iModelVersion===null){w.error("The AnalyticalBinding does not support Models other than sap.ui.model.odata.ODataModel version 1 or 2.");return;}this.aAllDimensionSortedByName=null;this.aInitialAnalyticalInfo=(P==undefined?[]:P.analyticalInfo);this.bInitial=true;}});function G(o,e){return function(){if(!o.__supportUID){o.__supportUID=u();}return{type:v,analyticalError:e,analyticalBindingId:o.__supportUID};};}E.prototype.setContext=function(o){var r;if(this.oContext!==o){this.oContext=o;if(!this.isRelative()){return;}this.oDataState=null;this.bApplySortersToGroups=true;this.iTotalSize=-1;this._abortAllPendingRequests();r=this.oModel.resolve(this.sPath,this.oContext);if(r){this.resetData();this._initialize();this._fireChange({reason:C.Context});}else{this.bInitial=true;}}};E.prototype.initialize=function(){if(this.oModel.oMetadata&&this.oModel.oMetadata.isLoaded()&&this.isInitial()){var i=this.isRelative();if(!i||(i&&this.oContext)){this._initialize();}this._fireRefresh({reason:C.Refresh});}return this;};E.prototype._initialize=function(){if(this.oModel.oMetadata&&this.oModel.oMetadata.isLoaded()){this.bInitial=false;this.oAnalyticalQueryResult=this.oModel.getAnalyticalExtensions().findQueryResultByName(this._getEntitySet());if(!this.oAnalyticalQueryResult){throw("Error in AnalyticalBinding - The QueryResult '"+this._getEntitySet()+"' could not be retrieved. Please check your service definition.");}this.updateAnalyticalInfo(this.aInitialAnalyticalInfo);this.aAllDimensionSortedByName=this.oAnalyticalQueryResult.getAllDimensionNames().concat([]).sort();this._fireRefresh({reason:C.Refresh});}};E.prototype.getRootContexts=function(p){if(this.isInitial()){return[];}var i=(p&&p.numberOfExpandedLevels?p.numberOfExpandedLevels+1:1);var r=null;var R=this._getRequestId(E._requestType.groupMembersQuery,{groupId:null});if(this.bArtificalRootContext&&!this._cleanupGroupingForCompletedRequest(R)){return r;}r=this._getContextsForParentContext(null);if(r.length==1){return r;}if(i<=1){if(i==1){this._considerRequestGrouping([R,this._getRequestId(E._requestType.groupMembersQuery,{groupId:"/"})]);this.getNodeContexts(this.getModel().getContext("/"),{startIndex:p.startIndex,length:p.length,threshold:p.threshold,level:0,numberOfExpandedLevels:0});}}else{var e=this._prepareGroupMembersAutoExpansionRequestIds("/",p.numberOfExpandedLevels);e.push(R);this._considerRequestGrouping(e);this.getNodeContexts(this.getModel().getContext("/"),{startIndex:p.startIndex,length:p.length,threshold:p.threshold,level:0,numberOfExpandedLevels:p.numberOfExpandedLevels});}if(r.length>1){w.fatal("assertion failed: grand total represented by a single entry");}return r;};E.prototype.getNodeContexts=function(o,p){if(this.isInitial()){return[];}var s,l,i,e,n,g;if(typeof p=="object"){s=p.startIndex;l=p.length;i=p.threshold;e=p.level;n=p.numberOfExpandedLevels;g=p.supressRequest;}else{s=arguments[1];l=arguments[2];i=arguments[3];e=arguments[4];n=arguments[5];g=arguments[6];}var h=this._getContextsForParentContext(o,s,l,i,e,n,g);return h;};E.prototype.ContextsAvailabilityStatus={ALL:2,SOME:1,NONE:0};E.prototype.hasAvailableNodeContexts=function(o,l){var g=this._getGroupIdFromContext(o,l);if(this._getKeys(g)!=undefined){if(this.mFinalLength[g]==true){return E.prototype.ContextsAvailabilityStatus.ALL;}else{return E.prototype.ContextsAvailabilityStatus.SOME;}}else{return E.prototype.ContextsAvailabilityStatus.NONE;}};E.prototype.getGroupSize=function(o,l){if(o===undefined){return 0;}var g=this._getGroupIdFromContext(o,l);return this.mFinalLength[g]?this.mLength[g]:-1;};E.prototype.getTotalSize=function(){if(!this.bProvideTotalSize){w.fatal("total size of result explicitly turned off, but getter invoked");}return+this.iTotalSize;};E.prototype.hasChildren=function(o,p){if(o===undefined){return false;}if(o==null){return true;}var i=p.level;if(i==0){return true;}if(this.aAggregationLevel.length<i){return false;}return this.aMaxAggregationLevel.indexOf(this.aAggregationLevel[i-1])<this.aMaxAggregationLevel.length-1;};E.prototype.hasMeasures=function(){var h=false;for(var p in this.oMeasureDetailsSet){if(this.oMeasureDetailsSet.hasOwnProperty(p)){h=true;break;}}return h;};E.prototype.getDimensionDetails=function(){return this.oDimensionDetailsSet;};E.prototype.getMeasureDetails=function(){return this.oMeasureDetailsSet;};E.prototype.providesGrandTotal=function(){return this.bProvideGrandTotals;};E.prototype.getProperty=function(p){if(this.isInitial()){return{};}return this.oAnalyticalQueryResult.getEntityType().findPropertyByName(p);};E.prototype.getFilterablePropertyNames=function(){if(this.isInitial()){return[];}return this.oAnalyticalQueryResult.getEntityType().getFilterablePropertyNames();};E.prototype.getSortablePropertyNames=function(){if(this.isInitial()){return[];}return this.oAnalyticalQueryResult.getEntityType().getSortablePropertyNames();};E.prototype.getPropertyLabel=function(p){if(this.isInitial()){return"";}return this.oAnalyticalQueryResult.getEntityType().getLabelOfProperty(p);};E.prototype.getPropertyHeading=function(p){if(this.isInitial()){return"";}return this.oAnalyticalQueryResult.getEntityType().getHeadingOfProperty(p);};E.prototype.getPropertyQuickInfo=function(p){if(this.isInitial()){return"";}return this.oAnalyticalQueryResult.getEntityType().getQuickInfoOfProperty(p);};E.prototype.isMeasure=function(p){return this.aMeasureName&&this.aMeasureName.indexOf(p)!==-1;};E.prototype.filter=function(e,s){if(!e){e=[];}if(e instanceof F){e=[e];}e=this._convertDeprecatedFilterObjects(e);if(s==c.Application){this.aApplicationFilter=e;}else{this.aControlFilter=e;}this.iTotalSize=-1;this._abortAllPendingRequests();this.resetData();this.bApplySortersToGroups=true;this._fireRefresh({reason:C.Filter});return this;};E.prototype.getFilterInfo=function(i){var o=b.combineFilters(this.aControlFilter,this.aApplicationFilter);if(o){return o.getAST(i);}return null;};E.prototype.sort=function(s){if(s instanceof S){s=[s];}this.aSorter=s?s:[];this._abortAllPendingRequests();this.resetData(undefined,{reason:C.Sort});this._fireRefresh({reason:C.Sort});return this;};E.prototype.getGroupName=function(o,l){if(o===undefined){return"";}var g=this.aAggregationLevel[l-1],e=this.oAnalyticalQueryResult.findDimensionByPropertyName(g),V=this.mAnalyticalInfoByProperty[g]&&this.mAnalyticalInfoByProperty[g].formatter,p=o.getProperty(g),s,h,i,j,k,m,n,q;if(e&&this.oDimensionDetailsSet[g].textPropertyName){k=e.getTextProperty();}if(k){m=k.name;q=this.mAnalyticalInfoByProperty[m]&&this.mAnalyticalInfoByProperty[m].formatter;n=o.getProperty(m);s=V?V(p,n):p;h=q?q(n,p):n;}else{s=V?V(p):p;}j=e.getLabelText&&e.getLabelText();i=(j?j+': ':'')+s;if(h){i+=' - '+h;}return i;};E.prototype.updateAnalyticalInfo=function(e,g){var h,o,k,H,l=this;function m(K){var N=K.level,O=K.name;H=H||k.getAllHierarchyPropertyNames();H.forEach(function(R){var V=l.oAnalyticalQueryResult.findDimensionByPropertyName(R).getHierarchy(),W=null,X=V.getNodeIDProperty().name,Y;if(X===O){W=n(V);}else{Y=V.getNodeExternalKeyProperty();if(Y&&Y.name===O){W=n(V);W.nodeExternalKeyName=O;}else{Y=k.getTextPropertyOfProperty(X);if(Y&&Y.name===O){W=n(V);W.nodeTextName=O;}}}if(W&&"level"in K){if(typeof N==="number"){if("level"in W&&W.level!==N){throw new Error("Multiple different level filter for hierarchy '"+X+"' defined");}W.level=N;W.grouped=!!K.grouped;}else{throw new Error("The level of '"+X+"' has to be an integer value");}}});}function n(K){var N=K.getNodeIDProperty().name,O,R=l.mHierarchyDetailsByName[N];if(!R){O=K.getNodeLevelProperty();R={dimensionName:K.getNodeValueProperty().name,nodeIDName:N,nodeLevelName:O&&O.name};l.mHierarchyDetailsByName[N]=R;}return R;}if(!this.oModel.oMetadata||!this.oModel.oMetadata.isLoaded()||this.isInitial()){this.aInitialAnalyticalInfo=e;return;}h=t.helper.deepEqual(this._aLastChangedAnalyticalInfo,e,function(K){l.mAnalyticalInfoByProperty[K.name].formatter=K.formatter;});if(h){this._aLastChangedAnalyticalInfo=[];for(var j=0;j<e.length;j++){this._aLastChangedAnalyticalInfo[j]=Q.extend({},e[j]);}}if(h<2){if(g||h){setTimeout(function(){this._fireChange({reason:C.Change});}.bind(this),0);}return;}var p=this.oDimensionDetailsSet||{},P=this.oMeasureDetailsSet||{};this.mAnalyticalInfoByProperty={};this.aMaxAggregationLevel=[];this.aAggregationLevel=[];this.aMeasureName=[];if(this.iAnalyticalInfoVersionNumber==undefined){this.iAnalyticalInfoVersionNumber=1;}else if(this.iAnalyticalInfoVersionNumber>999){this.iAnalyticalInfoVersionNumber=1;}else{this.iAnalyticalInfoVersionNumber=this.iAnalyticalInfoVersionNumber+1;}this.oMeasureDetailsSet={};this.oDimensionDetailsSet={};this.aAdditionalSelects=[];this.mHierarchyDetailsByName={};k=this.oAnalyticalQueryResult.getEntityType();for(var i=0;i<e.length;i++){var q=this.oAnalyticalQueryResult.findDimensionByPropertyName(e[i].name);if(q&&(e[i].inResult==true||e[i].visible==true)){e[i].dimensionPropertyName=q.getName();o=this.oDimensionDetailsSet[q.getName()];if(!o){o={};o.name=q.getName();o.aAttributeName=[];o.grouped=false;this.oDimensionDetailsSet[q.getName()]=o;this.aMaxAggregationLevel.push(o.name);if(e[i].grouped==true){this.aAggregationLevel.push(o.name);}}if(e[i].grouped==true){if(!this.getSortablePropertyNames()||this.getSortablePropertyNames().indexOf(q.getName())==-1){w.fatal("property "+q.getName()+" must be sortable in order to be used as grouped dimension");}o.grouped=true;}if(q.getName()==e[i].name){o.keyPropertyName=e[i].name;}var r=q.getTextProperty();if(r&&r.name==e[i].name){o.textPropertyName=e[i].name;}if(q.findAttributeByName(e[i].name)){o.aAttributeName.push(e[i].name);}o.analyticalInfo=e[i];}var M=this.oAnalyticalQueryResult.findMeasureByPropertyName(e[i].name);if(M&&(e[i].inResult==true||e[i].visible==true)){e[i].measurePropertyName=M.getName();var s=this.oMeasureDetailsSet[M.getName()];if(!s){s={};s.name=M.getName();this.oMeasureDetailsSet[M.getName()]=s;this.aMeasureName.push(s.name);}if(M.getRawValueProperty().name==e[i].name){s.rawValuePropertyName=e[i].name;}var z=M.getFormattedValueProperty();if(z&&z.name==e[i].name){s.formattedValuePropertyName=e[i].name;}s.analyticalInfo=e[i];}if(!q&&!M){m(e[i]);}this.mAnalyticalInfoByProperty[e[i].name]=e[i];}Object.keys(this.mHierarchyDetailsByName).forEach(function(N){var K=l.mHierarchyDetailsByName[N];if(!("level"in K)){delete l.mHierarchyDetailsByName[N];if(w.isLoggable(L.Level.INFO)){w.info("No level specified for hierarchy node '"+N+"'; ignoring hierarchy","");}}else if(!l.oDimensionDetailsSet[N]){l.oDimensionDetailsSet[N]={aAttributeName:[],grouped:K.grouped,isHierarchyDimension:true,name:N};l.aMaxAggregationLevel.push(N);if(K.grouped){l.aAggregationLevel.push(N);}}});for(var I in this.oMeasureDetailsSet){var U=this.oAnalyticalQueryResult.findMeasureByName(I).getUnitProperty();if(U){this.oMeasureDetailsSet[I].unitPropertyName=U.name;}}var J=Object.keys(p).sort().join(";")!==Object.keys(this.oDimensionDetailsSet).sort().join(";");if(J){this.iTotalSize=-1;}if(J||Object.keys(P).sort().join(";")!==Object.keys(this.oMeasureDetailsSet).sort().join(";")){this.bApplySortersToGroups=true;}this.aAnalyticalInfo=e;this.resetData();this.bNeedsUpdate=false;if(this.mParameters.select){this.aAdditionalSelects=x(this);}if(g){this._fireChange({reason:C.Change});}};E.prototype.getAnalyticalInfoForColumn=function(s){return this.mAnalyticalInfoByProperty[s];};E.prototype.loadGroups=function(g){var e=[];for(var s in g){e.push(s);this._resetData(s);var h=g[s];for(var i=0;i<h.length;i++){var o=h[i];this._getContextsForParentGroupId(s,o.startIndex,o.length,o.threshold);}var r=[];for(var j=-1,k;(k=e[++j])!==undefined;){r.push(this._getRequestId(E._requestType.groupMembersQuery,{groupId:k}));}this._considerRequestGrouping(r);}};E.prototype.getAnalyticalQueryResult=function(){return this.oAnalyticalQueryResult;};E._requestType={groupMembersQuery:1,totalSizeQuery:2,groupMembersAutoExpansionQuery:3,levelMembersQuery:4,reloadMeasuresQuery:5};E._artificialRootContextGroupId="artificialRootContext";E._addHierarchyLevelFilters=function(e,o){e.forEach(function(g){o.removeConditions(g.propertyName);o.addCondition(g.propertyName,a.EQ,g.level);});};E.prototype._getContextsForParentContext=function(p,s,l,i,e,n,g){if(p===undefined){return[];}if(p&&p.getPath()=="/"+E._artificialRootContextGroupId){p=this.getModel().getContext("/");}var P=this._getGroupIdFromContext(p,e);return this._getContextsForParentGroupId(P,s,l,i,n,g);};E.prototype._getContextsForParentGroupId=function(p,s,l,e,n,g){if(p===undefined){return[];}if(!s){s=0;}if(!l){l=this.oModel.iSizeLimit;}if(this.mFinalLength[p]&&this.mLength[p]<s+l){l=this.mLength[p]-s;if(l<0){w.fatal("invalid start index greater than total group length passed");}}if(!e){e=0;}if(!n){n=0;}if(p==null){if(n>0){w.fatal("invalid request to determine nodes of root context");return null;}}else{if(this._getGroupIdLevel(p)>=this.aAggregationLevel.length&&n>0){w.fatal("invalid request to determine nodes of context with group ID "+p);return null;}if(this._getGroupIdLevel(p)+n>this.aAggregationLevel.length){n=this.aAggregationLevel.length-this._getGroupIdLevel(p)-1;}}var h=[],k,o,m,q;var r=p==null?0:this._getGroupIdLevel(p)+1;if(!this.aMultiUnitLoadFactor[r]){this.aMultiUnitLoadFactor[r]=1;}var z=n>0&&p!=null;if(z){var M=this._getGroupIdLevel(p);var H=M+n;var I=true;if(!g){m=this._calculateRequiredGroupExpansion(p,H,s,l+e);I=m.groupId_Missing==null;I=I||m.groupId_Missing.length<p.length||m.groupId_Missing.substring(0,p.length)!=p;}if(I){h=this._getLoadedContextsForGroup(p,s,l);}else{q=l+e;}k=!I;q=Math.ceil(q*this.aMultiUnitLoadFactor[r]);}else{h=this._getLoadedContextsForGroup(p,s,l,g);k=false;if(!g){if(this._oWatermark&&p===this._oWatermark.groupID){e=10000;}o=this._calculateRequiredGroupSection(p,s,l,e);var P=o.length>0&&l<o.length;k=(h.length!=l&&!(this.mFinalLength[p]&&h.length>=this.mLength[p]-s))||P;o.length=Math.ceil(o.length*this.aMultiUnitLoadFactor[r]);}}if(!k){this._cleanupGroupingForCompletedRequest(this._getRequestId(E._requestType.groupMembersQuery,{groupId:p}));}var J=false;if(this.oModel.getServiceMetadata()){if(k){var N=this.bProvideTotalSize&&this.iTotalSize==-1&&!this._isRequestPending(this._getRequestId(E._requestType.totalSizeQuery));J=true;var K;if(this.bUseBatchRequests){if(z){K=this._prepareGroupMembersAutoExpansionRequestIds(p,n);for(var i=-1,R;(R=K[++i])!==undefined;){if(this._isRequestPending(R)){J=false;break;}}if(J){this.aBatchRequestQueue.push([E._requestType.groupMembersAutoExpansionQuery,p,m,q,n]);}}else{J=o.length&&!this._isRequestPending(this._getRequestId(E._requestType.groupMembersQuery,{groupId:p}));if(J){this.aBatchRequestQueue.push([E._requestType.groupMembersQuery,p,o.startIndex,o.length]);K=[this._getRequestId(E._requestType.groupMembersQuery,{groupId:p})];}}if(J&&N){K.push(this._getRequestId(E._requestType.totalSizeQuery));this._considerRequestGrouping(K);this.aBatchRequestQueue.push([E._requestType.totalSizeQuery]);}if(J){if(p==null){this._abortAllPendingRequests();}Promise.resolve().then(E.prototype._processRequestQueue.bind(this));}}else{var O;if(z){K=this._prepareGroupMembersAutoExpansionRequestIds(p,n);for(var j=-1,U;(U=K[++j])!==undefined;){if(this._isRequestPending(U)){J=false;break;}}if(J){O=this._prepareGroupMembersAutoExpansionQueryRequest(E._requestType.groupMembersAutoExpansionQuery,p,m,q,n);}}else{J=o.length&&!this._isRequestPending(this._getRequestId(E._requestType.groupMembersQuery,{groupId:p}));if(J){O=this._prepareGroupMembersQueryRequest(E._requestType.groupMembersQuery,p,o.startIndex,o.length);K=[O.sRequestId];}}if(J){if(p==null){this._abortAllPendingRequests();}this._executeQueryRequest(O);if(N&&!O.bIsFlatListRequest){K.push(this._getRequestId(E._requestType.totalSizeQuery));this._considerRequestGrouping(K);this._executeQueryRequest(this._prepareTotalSizeQueryRequest(E._requestType.totalSizeQuery));}}}}}return h;};E.prototype._getHierarchyLevelFiltersAndAddRecursiveHierarchy=function(o,g){var h,H=[],e=this;if(g===null){return H;}h=Object.keys(this.mHierarchyDetailsByName);if(h.length>0&&g!=="/"){w.error("Hierarchy cannot be requested for members of a group",g);return H;}h.forEach(function(s){var i=e.mHierarchyDetailsByName[s];o.addRecursiveHierarchy(i.dimensionName,!!i.nodeExternalKeyName,!!i.nodeTextName);H.push({propertyName:i.nodeLevelName,level:i.level});});return H;};E.prototype._getNonHierarchyDimensions=function(e){var g=this;return e.filter(function(s){return!g.oDimensionDetailsSet[s].isHierarchyDimension;});};E.prototype._processRequestQueue=function(r){if(r===undefined||r===null){r=this.aBatchRequestQueue||[];}if(r.length==0){return;}var R=[];var e=false;var i,o,g;for(i=-1;(g=r[++i])!==undefined;){if(g[0]==E._requestType.groupMembersQuery){o=E.prototype._prepareGroupMembersQueryRequest.apply(this,g);e=e||o.bIsFlatListRequest;R.push(o);}}for(i=-1;(g=r[++i])!==undefined;){o=null;switch(g[0]){case E._requestType.groupMembersQuery:continue;case E._requestType.totalSizeQuery:if(!e){o=E.prototype._prepareTotalSizeQueryRequest.apply(this,g);R.push(o);}break;case E._requestType.groupMembersAutoExpansionQuery:o=E.prototype._prepareGroupMembersAutoExpansionQueryRequest.apply(this,g);for(var j=-1,l;(l=o.aGroupMembersAutoExpansionRequestDetails[++j])!==undefined;){R.push(l);}break;case E._requestType.reloadMeasuresQuery:{var h=g[1];for(var k=-1,m;(m=h[++k])!==undefined;){R.push(m);}break;}default:w.fatal("unhandled request type "+r[i][0]);continue;}}if(R.length>1){this._executeBatchRequest(R);}else{this._executeQueryRequest(R[0]);}if(r===this.aBatchRequestQueue){this.aBatchRequestQueue=[];}};E.prototype._prepareGroupMembersQueryRequest=function(r,g,s,e){var h=[],m=[],H;var o=new t.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());o.getSortExpression().clear();var p=0,q=-1;if(g){h=this._getGroupIdComponents(g);p=q=h.length;var U=0;for(var j=0,z=0;j<p;z++){if(this.oDimensionDetailsSet[this.aMaxAggregationLevel[z]].grouped==false){++U;}else{++j;}}p=q=p+U;if(this.aMaxAggregationLevel.length>0){while(this.oDimensionDetailsSet[this.aMaxAggregationLevel[q]].grouped==false){if(++q==this.aMaxAggregationLevel.length){break;}}}}var I=q>=this.aMaxAggregationLevel.length-1;H=this._getHierarchyLevelFiltersAndAddRecursiveHierarchy(o,g);var J=this.aMaxAggregationLevel.slice(0,q+1);var K=this._getNonHierarchyDimensions(J);o.setAggregationLevel(K);for(var i=0;i<K.length;i++){var M=this.oDimensionDetailsSet[K[i]];var N=(M.textPropertyName!=undefined);o.includeDimensionKeyTextAttributes(M.name,true,N,M.aAttributeName);if(M.grouped){m.push({sPath:K[i],bDescending:false});}}var O=o.getFilterExpression();O.clear();if(this.aApplicationFilter){O.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){O.addUI5FilterConditions(this.aControlFilter);}if(p>=1){for(var k=0,l=h.length;k<l;k++){O.removeConditions(this.aAggregationLevel[k]);O.addCondition(this.aAggregationLevel[k],a.EQ,h[k]);}}E._addHierarchyLevelFilters(H,O);var P;var R;var V;var W;var X=[];if(g!=null||this.bProvideGrandTotals||(this._canApplySortersToGroups()&&this.aSorter.length>0)){o.setMeasures(this.aMeasureName);for(var Y in this.oMeasureDetailsSet){W=this.oMeasureDetailsSet[Y];if(!I&&this._isSkippingTotalForMeasure(Y)){P=false;R=false;V=false;}else{P=(W.rawValuePropertyName!=undefined);R=(W.formattedValuePropertyName!=undefined);V=(W.unitPropertyName!=undefined);if(V){if(X.indexOf(W.unitPropertyName)==-1){X.push(W.unitPropertyName);}}}o.includeMeasureRawFormattedValueUnit(W.name,P,R,V);}for(var n in K){var Z;if((Z=X.indexOf(K[n]))!=-1){X.splice(Z,1);}}}if(g){this._addSorters(o.getSortExpression(),m);}if(e==0){w.fatal("unhandled case: load 0 entities of sub group");}var $=this._getKeyIndexMapping(g,s);if(!this.bNoPaging){o.setResultPageBoundaries($.iServiceKeyIndex+1,$.iServiceKeyIndex+e);}o.setRequestOptions(null,!this.mFinalLength[g]);return{iRequestType:r,sRequestId:this._getRequestId(E._requestType.groupMembersQuery,{groupId:g}),oAnalyticalQueryRequest:o,sGroupId:g,aSelectedUnitPropertyName:X,aAggregationLevel:J,bIsFlatListRequest:I&&p==0,bIsLeafGroupsRequest:I,iStartIndex:s,iLength:e,oKeyIndexMapping:$};};E.prototype._prepareTotalSizeQueryRequest=function(r){var h;var o=new t.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());h=this._getHierarchyLevelFiltersAndAddRecursiveHierarchy(o,"/");o.setAggregationLevel(this._getNonHierarchyDimensions(this.aMaxAggregationLevel));o.setMeasures([]);var e=o.getFilterExpression();e.clear();if(this.aApplicationFilter){e.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){e.addUI5FilterConditions(this.aControlFilter);}E._addHierarchyLevelFilters(h,e);o.setRequestOptions(null,null,true);o.setRequestOptions(null,true);return{iRequestType:r,sRequestId:this._getRequestId(E._requestType.totalSizeQuery),oAnalyticalQueryRequest:o};};E.prototype._prepareGroupMembersAutoExpansionQueryRequest=function(r,g,o,e,n){var h=this;var p=function(o,s){var I=[];if(o.groupId_Missing==null){w.fatal("missing group Id not present");return I;}var z=h._getGroupIdComponents(o.groupId_Missing);var H=z.length;if(H>s){w.fatal("the given group ID is too deep for requested level for auto expansion");return I;}var k=[];for(var i=0;i<H;i++){var l=h.aAggregationLevel[i];var Y=z[i];var Z=h._getFilterOperatorMatchingPropertySortOrder(l);k[i]=new F(l,Z,Y);}var $=null;if(o.startIndex_Missing>0){var _=h._getKey(o.groupId_Missing,o.startIndex_Missing-1);var a1=h.oModel.getObject("/"+_);var b1=h.aAggregationLevel[H];var c1=a1[b1];$=new F(b1,h._getFilterOperatorMatchingPropertySortOrder(b1,false),c1);}for(var K=0;K<s;K++){var d1=[];var e1=Math.min(H,K+1);for(var f1=0;f1<e1;f1++){var g1=[];var h1=Math.min(H,f1+1);var i1=o.startIndex_Missing>0;for(var j1=0;j1<h1;j1++){var k1=new F("x",a.EQ,"x");k1=Q.extend(true,k1,k[j1]);if(h1>1&&j1<h1-1){k1.sOperator=a.EQ;}if(j1==H-1&&K>H-1&&!i1){if(k1.sOperator==a.GT){k1.sOperator=a.GE;}else{k1.sOperator=a.LE;}}g1.push(k1);}if(g1.length>0){d1.push(new F(g1,true));if(K>H-1&&f1==H-1&&i1){var l1=[];for(var j=0;j<g1.length;j++){var m1=new F("x",a.EQ,"x");m1=Q.extend(true,m1,g1[j]);l1.push(m1);}l1[H-1].sOperator=a.EQ;l1.push($);d1.push(new F(l1,true));break;}}}if(d1.length>0){I[K]=new F(d1,false);}else{I[K]=null;}}return I;};var m=function(r,g,K,Y,M,e,Z,$){var _;var a1=new t.QueryResultRequest(h.oAnalyticalQueryResult);a1.setResourcePath(h._getResourcePath());a1.getSortExpression().clear();var b1=0,c1=-1;b1=c1=K-1;var d1=0;for(var i=0,e1=0;i<b1;e1++){if(h.oDimensionDetailsSet[h.aMaxAggregationLevel[e1]].grouped==false){++d1;}else{++i;}}b1=c1=b1+d1;if(h.aMaxAggregationLevel.length>0){while(h.aMaxAggregationLevel[c1]&&h.oDimensionDetailsSet[h.aMaxAggregationLevel[c1]].grouped==false){if(++c1==h.aMaxAggregationLevel.length){break;}}}var f1=c1>=h.aMaxAggregationLevel.length-1;_=h._getHierarchyLevelFiltersAndAddRecursiveHierarchy(a1,g);var g1=h.aMaxAggregationLevel.slice(0,c1+1);a1.setAggregationLevel(g1);for(var l=0;l<g1.length;l++){var h1=h.oDimensionDetailsSet[g1[l]];var i1=(h1.textPropertyName!=undefined);a1.includeDimensionKeyTextAttributes(h1.name,true,i1,h1.aAttributeName);if(h1.grouped){a1.getSortExpression().addSorter(g1[l],t.SortOrder.Ascending);}}var j1=a1.getFilterExpression();j1.clear();if(h.aApplicationFilter){j1.addUI5FilterConditions(h.aApplicationFilter);}if(h.aControlFilter){j1.addUI5FilterConditions(h.aControlFilter);}if(Y){j1.addUI5FilterConditions([Y]);}E._addHierarchyLevelFilters(_,j1);var k1;var l1;var m1;var n1;var o1=[];a1.setMeasures(h.aMeasureName);for(var p1 in h.oMeasureDetailsSet){n1=h.oMeasureDetailsSet[p1];if(!f1&&h._isSkippingTotalForMeasure(p1)){k1=false;l1=false;m1=false;}else{k1=(n1.rawValuePropertyName!=undefined);l1=(n1.formattedValuePropertyName!=undefined);m1=(n1.unitPropertyName!=undefined);if(m1){if(o1.indexOf(n1.unitPropertyName)==-1){o1.push(n1.unitPropertyName);}}}a1.includeMeasureRawFormattedValueUnit(n1.name,k1,l1,m1);}for(var j in g1){var q1;if((q1=o1.indexOf(g1[j]))!=-1){o1.splice(q1,1);}}var r1=a1.getSortExpression();for(var k=0;k<h.aSorter.length;k++){if(h.aSorter[k]){r1.addSorter(h.aSorter[k].sPath,h.aSorter[k].bDescending?t.SortOrder.Descending:t.SortOrder.Ascending);}}if(e==0){w.fatal("unhandled case: load 0 entities of sub group");}var s1=M;if(!$){s1=0;}else{var t1=0;for(var u1 in h.mServiceKey){if(u1.split("/").length===K+1){t1+=h.mServiceKey[u1].length;}}s1=Math.max(s1,t1);}if(!h.bNoPaging){a1.setResultPageBoundaries(s1+1,s1+e);}return{iRequestType:r,sRequestId:null,oAnalyticalQueryRequest:a1,iLevel:K,aSelectedUnitPropertyName:o1,aAggregationLevel:g1,bIsFlatListRequest:f1,bIsLeafGroupsRequest:f1,iStartIndex:M,iLength:e,bAvoidLengthUpdate:Z};};var q=[];var R=[];if(!o){w.fatal("no first missing group member specified");}var s=this._getGroupIdLevel(g)+n+1;var z=h._getGroupIdComponents(o.groupId_Missing);var H=z.length;var I=p(o,s);var J;for(var K=1;K<=s;K++){var M;if(K>=H+2){M=0;J=undefined;}else if(K==H+1){M=o.startIndex_Missing;J=o.groupId_Missing;}else if(H>0){if(K==H){J=o.groupId_Missing;}else{J=this._getGroupIdAncestors(o.groupId_Missing,-(H-K))[0];}var N=this._getGroupIdAncestors(o.groupId_Missing,-(H-K+1))[0];if(!N){w.fatal("failed to determine group id at parent level; group ID = "+g+", level = "+K);}M=this._findKeyIndex(N,this.mEntityKey[J]);if(M==-1){w.fatal("failed to determine position of value "+J+" in group "+N);}J=N;M++;}var O=e>K?Math.ceil((e-K)/(s-K+1)):e;var P=I[K-1];if(this.bUseAcceleratedAutoExpand){var U=m(E._requestType.levelMembersQuery,g,K,P,M,O,false,P==null?true:false);U.sGroupId_Missing_AtLevel=J;U.sRequestId=this._getRequestId(E._requestType.levelMembersQuery,{groupId:g,level:K});q.push(U);R.push(U.sRequestId);}else if(P&&P.aFilters.length>0){if(!P._bMultiFilter||P.bAnd){w.fatal("level filter in wrong shape; cannot break it up");}for(var i=0;i<P.aFilters.length;i++){var V=P.aFilters[i];var W=m(E._requestType.levelMembersQuery,g,K,V,M,O,false,P==null?true:false);W.sGroupId_Missing_AtLevel=J;W.sRequestId=this._getRequestId(E._requestType.levelMembersQuery,{groupId:g,level:K,tupleIndex:i});q.push(W);R.push(W.sRequestId);}}else{var X=m(E._requestType.levelMembersQuery,g,K,null,M,O,false,P==null?true:false);X.sGroupId_Missing_AtLevel=J;X.sRequestId=this._getRequestId(E._requestType.levelMembersQuery,{groupId:g,level:K});q.push(X);R.push(X.sRequestId);}}return{iRequestType:r,aRequestId:R,aGroupMembersAutoExpansionRequestDetails:q,sGroupId:g,iLength:e};};E.prototype._prepareReloadMeasurePropertiesQueryRequest=function(r,g,m){var o=new t.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());o.getSortExpression().clear();var e=g.aAggregationLevel;o.setAggregationLevel(e);var I=g.bIsLeafGroupsRequest;var h=o.getFilterExpression();h.clear();if(this.aApplicationFilter){h.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){h.addUI5FilterConditions(this.aControlFilter);}var k=[];for(var i=0;i<e.length;i++){var l=new F(e[i],a.EQ,m.oEntry[e[i]]);k.push(l);}h.addUI5FilterConditions(k);var n;var p;var q;var M;var s=[];o.setMeasures(m.aReloadMeasurePropertyName);for(var z in this.oMeasureDetailsSet){M=this.oMeasureDetailsSet[z];if(!m.aReloadMeasurePropertyName||m.aReloadMeasurePropertyName.indexOf(M.name)==-1){continue;}if(!I&&this._isSkippingTotalForMeasure(z)){n=false;p=false;q=false;}else{n=(M.rawValuePropertyName!=undefined);p=(M.formattedValuePropertyName!=undefined);q=(M.unitPropertyName!=undefined);if(q){if(s.indexOf(M.unitPropertyName)==-1){s.push(M.unitPropertyName);}}}o.includeMeasureRawFormattedValueUnit(M.name,n,p,q);}for(var j in e){var H;if((H=s.indexOf(e[j]))!=-1){s.splice(H,1);}}return{iRequestType:r,sRequestId:this._getRequestId(E._requestType.reloadMeasuresQuery,{multiUnitEntryKey:this.oModel.getKey(m.oEntry)}),oAnalyticalQueryRequest:o,aSelectedUnitPropertyName:s,aAggregationLevel:e,oMultiUnitRepresentative:m};};E.prototype._prepareGroupMembersAutoExpansionRequestIds=function(g,n){var m=this._getGroupIdLevel(g)+1;var i=m+n;var r=[];for(var l=m;l<=i;l++){r.push(this._getRequestId(E._requestType.levelMembersQuery,{groupId:g,level:l}));}return r;};E.prototype._getQueryODataRequestOptions=function(o,g,p){var i;p=p||{};try{o.getFilterExpression().checkValidity();}catch(e){w.fatal("filter expression is not valid",e.toString());return undefined;}var s=o.getURIQueryOptionValue("$select");var h=o.getURIQueryOptionValue("$filter");var O=o.getURIQueryOptionValue("$orderby");var j=o.getURIQueryOptionValue("$skip");var k=o.getURIQueryOptionValue("$top");var I=o.getURIQueryOptionValue("$inlinecount");if(g&&this.aAdditionalSelects.length>0){s=(s?s.split(","):[]).concat(this.aAdditionalSelects).join(",");}if(this.mParameters&&this.mParameters["filter"]){if(h===null){h=this.mParameters["filter"];}else{h+="and ("+this.mParameters["filter"]+")";}}var P=[];if(s!==null){P.push("$select="+s);}if(h!==null){P.push("$filter="+h);}if(O!==null){P.push("$orderby="+O);}if(j!==null){P.push("$skip="+j);}if(k!==null){P.push("$top="+k);}if(I!==null){P.push("$inlinecount="+I);}if(p.encode===true){for(i=0;i<P.length;i++){P[i]=P[i].replace(/\ /g,"%20");}}return P;};E.prototype._executeBatchRequest=function(r){var e=this.iAnalyticalInfoVersionNumber,R,g=this;var h=[],l=[];function m(){g.fireDataReceived({__simulateAsyncAnalyticalBinding:true});}var o=new B();function s(j,k){o.success(k);}function n(j,k){o.error(k||j);}this.bNeedsUpdate=true;for(var p=0;p<r.length;p++){var q=r[p];if(q.aAggregationLevel&&q.aAggregationLevel.length>0){this.bNeedsUpdate=false;}}for(var i=-1,z;(z=r[++i])!==undefined;){var H=z.oAnalyticalQueryRequest,I=z.sGroupId;if(H.getURIQueryOptionValue("$select")==null){this.fireDataRequested({__simulateAsyncAnalyticalBinding:true});I=null;this.mServiceLength[I]=this.mLength[I]=1;this.mServiceFinalLength[I]=true;this._setServiceKey(this._getKeyIndexMapping(I,0),E._artificialRootContextGroupId);setTimeout(m);this.bArtificalRootContext=true;continue;}var P=H.getURIToQueryResultEntries();if(!this.oContext&&P[0]!=="/"){P="/"+P;}if(!this._isRequestPending(z.sRequestId)){this._registerNewRequest(z.sRequestId);if(this.iModelVersion===A.V1){h.push(this.oModel.createBatchOperation(P.replace(/\ /g,"%20"),"GET"));}else if(this.iModelVersion===A.V2){var U=this._getQueryODataRequestOptions(H,z.bIsLeafGroupsRequest,{encode:true});if(this.sCustomParams){U.push(this.sCustomParams);}var J=this.oModel.read(P.replace(/\ /g,"%20"),{success:s,error:n,context:this.oContext,urlParameters:U});h.push(J);}l.push(z);}}if(h.length>0){w.debug("AnalyticalBinding: executing batch request with "+l.length+" operations");var K;R=this._getIdForNewRequestHandle();this.fireDataRequested();if(this.iModelVersion===A.V1){this.oModel.addBatchReadOperations(h);K=this.oModel.submitBatch(M,N,true,true);this.oModel.fireRequestSent({url:this.oModel.sServiceUrl+"/$batch",type:"POST",async:true,info:"",infoObject:{}});}else{K={abort:function(){for(var j=0;j<h.length;j++){h[j].abort();}}};o.setup({executedRequests:l,binding:this,success:M,error:N});}this._registerNewRequestHandle(R,K);}function M(O,V){g._deregisterHandleOfCompletedRequest(R);if(l.length!=O.__batchResponses.length){w.fatal("assertion failed: received "+O.__batchResponses.length+" responses for "+l.length+" read operations in the batch request");}if(e!=g.iAnalyticalInfoVersionNumber){for(var j=0;j<l.length;j++){var W=l[j].sRequestId;if(W!==undefined){g._deregisterCompletedRequest(W);g._cleanupGroupingForCompletedRequest(W);}}g.fireDataReceived({data:[]});return;}var X=0;for(var k=0;k<O.__batchResponses.length;k++){if(O.__batchResponses[k].data!=undefined){if(O.__batchResponses[k].data.results.length==0){X++;}switch(l[k].iRequestType){case E._requestType.groupMembersQuery:g._processGroupMembersQueryResponse(l[k],O.__batchResponses[k].data);break;case E._requestType.totalSizeQuery:g._processTotalSizeQueryResponse(l[k],O.__batchResponses[k].data);break;case E._requestType.levelMembersQuery:g._processLevelMembersQueryResponse(l[k],O.__batchResponses[k].data);break;case E._requestType.reloadMeasuresQuery:g._processReloadMeasurePropertiesQueryResponse(l[k],O.__batchResponses[k].data);break;default:w.fatal("invalid request type "+l[k].iRequestType);continue;}}g._deregisterCompletedRequest(l[k].sRequestId);g._cleanupGroupingForCompletedRequest(l[k].sRequestId);}if(g.mParameters&&g.mParameters.numberOfExpandedLevels>0){if(X==O.__batchResponses.length){g.mLength["/"]=0;g.mFinalLength["/"]=true;}}var Y=true;var Z;g.fireDataReceived({data:O});var $={};if(g.iModelVersion===A.V1){Z=g.oModel._getBatchErrors(O);if(Z.length>0){Y=false;$=g.oModel._handleError(Z[0]);}g.oModel.fireRequestCompleted({url:V.requestUri,type:"POST",async:true,info:"",infoObject:{},success:Y,errorobject:Y?{}:$});if(Y){g.oModel.checkUpdate();}}}function N(k){if(k&&k.statusText!="abort"){g._deregisterHandleOfCompletedRequest(R);for(var j=-1,O;(O=l[++j])!==undefined;){g._deregisterCompletedRequest(O.sRequestId);g._cleanupGroupingForCompletedRequest(O.sRequestId);}}if(e!=g.iAnalyticalInfoVersionNumber){return;}var V=k;if(g.iModelVersion===A.V1){V=g.oModel._handleError(k);}g.oModel.fireRequestCompleted({url:"",type:"POST",async:true,info:"",infoObject:{},success:false,errorobject:V});if(g.iModelVersion===A.V1){g.oModel.fireRequestFailed(V);}g.fireDataReceived();}};E.prototype._executeQueryRequest=function(r){if(r.iRequestType==E._requestType.groupMembersAutoExpansionQuery){for(var i=-1,o;(o=r.aGroupMembersAutoExpansionRequestDetails[++i])!==undefined;){this._executeQueryRequest(o);}return;}var e=this.iAnalyticalInfoVersionNumber;var g=r.oAnalyticalQueryRequest,s=r.sGroupId;var p=g.getURIToQueryResultEntitySet();var P=this._getQueryODataRequestOptions(g,r.bIsLeafGroupsRequest);if(!P){return;}var h=this;if(g.getURIQueryOptionValue("$select")==null){this.fireDataRequested({__simulateAsyncAnalyticalBinding:true});s=null;this.mServiceLength[s]=this.mLength[s]=1;this.mServiceFinalLength[s]=true;this._setServiceKey(this._getKeyIndexMapping(s,0),E._artificialRootContextGroupId);this.bNeedsUpdate=true;setTimeout(function(){if(h._cleanupGroupingForCompletedRequest(r.sRequestId)){h.fireDataReceived({__simulateAsyncAnalyticalBinding:true});}});this.bArtificalRootContext=true;return;}this._registerNewRequest(r.sRequestId);this.fireDataRequested();for(var j=0;j<P.length;j++){P[j]=P[j].replace(/\ /g,"%20");}w.debug("AnalyticalBinding: executing query request");var R=this._getIdForNewRequestHandle();if(this.iModelVersion===A.V1){this.oModel._loadData(p,P,l,n,false,U,m);}else{if(this.sCustomParams){P.push(this.sCustomParams);}var k=this.oModel.read(p.replace(/ /g,"%20"),{success:l,error:n,context:this.oContext,urlParameters:P});h._registerNewRequestHandle(R,k);}function l(q){h._deregisterHandleOfCompletedRequest(R);if(e!=h.iAnalyticalInfoVersionNumber){h._deregisterCompletedRequest(r.sRequestId);return;}switch(r.iRequestType){case E._requestType.groupMembersQuery:h._processGroupMembersQueryResponse(r,q);break;case E._requestType.totalSizeQuery:h._processTotalSizeQueryResponse(r,q);break;case E._requestType.levelMembersQuery:h._processLevelMembersQueryResponse(r,q);break;case E._requestType.reloadMeasuresQuery:h._processReloadMeasurePropertiesQueryResponse(r,q);break;default:w.fatal("invalid request type "+r.iRequestType);break;}h._deregisterCompletedRequest(r.sRequestId);if(h.iModelVersion===A.V2){m(q);}}function m(q){if(e!=h.iAnalyticalInfoVersionNumber){return;}if(h._cleanupGroupingForCompletedRequest(r.sRequestId)){h.fireDataReceived({data:q});}}function n(q){if(q&&q.statusText=="abort"){h.fireDataReceived();return;}h._deregisterHandleOfCompletedRequest(R);h._deregisterCompletedRequest(r.sRequestId);h._cleanupGroupingForCompletedRequest(r.sRequestId);if(e!=h.iAnalyticalInfoVersionNumber){return;}h.fireDataReceived();}function U(k){h._registerNewRequestHandle(R,k);}};E.prototype._abortAllPendingRequests=function(){this._abortAllPendingRequestsByHandle();this._clearAllPendingRequests();};E.prototype._processGroupMembersQueryResponse=function(R,e){var s,n=R.sGroupId,H=this.aSorter.length>0,z=R.aSelectedUnitPropertyName,I=R.aAggregationLevel,J=R.oKeyIndexMapping.iIndex,K=R.oKeyIndexMapping.iServiceKeyIndex,M=R.iLength,N=R.oKeyIndexMapping,O=n==null?0:this._getGroupIdLevel(n)+1,U=(z.length>0),P,V,W,X=0,Y,Z,$=[];var _=e.results.length;if(n===null&&_>1&&this._canApplySortersToGroups()){this._warnNoSortingOfGroups(H?"binding is refreshed":undefined);if(H){setTimeout(this.refresh.bind(this),0);return;}}var a1=this._getServiceKeys(n,N.iIndex-1);P=undefined;if(a1&&a1.length>0){for(var i=0,b1=a1.length;i<b1;i++){e.results[i-b1]=this.oModel.getObject("/"+a1[i]);}var c1=e.results[-a1.length];P="";for(var j=0;j<I.length;j++){P+=c1[I[j]]+"|";}}Y=a1&&a1.length==1;for(var h=0;h<_;h++){var d1=e.results[h];if(U){V="";for(var g=0;g<I.length;g++){V+=d1[I[g]]+"|";}if(P==V){this._warnNoSortingOfGroups();if(W===undefined){if(h==0){W=-a1.length;N.iServiceKeyIndex-=a1.length-1;}else{W=h-1;}}var e1=-1,f1=e.results[h-1];for(var k=0;k<z.length;k++){if(f1[z[k]]!=d1[z[k]]){e1=k;break;}}if(e1==-1){w.fatal("assertion failed: no deviating units found for result entries "+(h-1)+" and "+h,null,null,G(this,"NO_DEVIATING_UNITS"));}}if((P!=V||h==_-1)&&W!==undefined){var g1=[];for(var l=W;l<h;l++){g1.push(e.results[l]);}if(P==V){g1.push(e.results[h]);}var h1=[];for(var m=0;m<z.length;m++){var i1=z[m];for(var o=1;o<g1.length;o++){if(g1[o-1][i1]!=g1[o][i1]){h1.push(i1);break;}}}var j1=this._createMultiUnitRepresentativeEntry(n,e.results[W],z,h1,R.bIsFlatListRequest);if(j1.aReloadMeasurePropertyName.length>0){Z=this._prepareReloadMeasurePropertiesQueryRequest(E._requestType.reloadMeasuresQuery,R,j1);if(Z.oAnalyticalQueryRequest&&Z.oAnalyticalQueryRequest.getURIQueryOptionValue("$select")!=null){$.push(Z);}}var k1=this._setAdjacentMultiUnitKeys(N,j1,g1);var l1;if(j1.bIsNewEntry){l1=g1.length-1;}else{l1=k1;}if(Y){Y=false;}if(l1<0){w.fatal("assertion failed: iDiscardedEntriesCount must be non-negative");}X+=l1;var m1=this.oModel._getKey(j1.oEntry);var n1=this.oModel.getContext('/'+m1);this._getGroupIdFromContext(n1,O);this.mEntityKey[s]=m1;W=undefined;if(P!=V){Y=this._setServiceKey(N,this.oModel._getKey(d1));}}else if(P!=V){Y=this._setServiceKey(N,this.oModel._getKey(d1));}P=V;}else{this._setServiceKey(N,this.oModel._getKey(d1));}if(!R.bIsLeafGroupsRequest){var o1=this._getKey(n,N.iIndex-1);s=this._getGroupIdFromContext(this.oModel.getContext('/'+o1),O);this.mEntityKey[s]=o1;}}var p1=[];if(this.bReloadSingleUnitMeasures&&$.length>0){if(this.bUseBatchRequests){this.aBatchRequestQueue.push([E._requestType.reloadMeasuresQuery,$]);Promise.resolve().then(E.prototype._processRequestQueue.bind(this));}else{for(var q=0;q<$.length;q++){var q1=$[q];this._executeQueryRequest(q1);}}for(var p=0;p<$.length;p++){var r1=$[p];p1.push(r1.sRequestId);}this._considerRequestGrouping(p1);}if(a1&&a1.length>0){for(var r=0,s1=a1.length;r<s1;r++){delete e.results[r-s1];}}if(U){X+=this._mergeLoadedKeyIndexWithSubsequentIndexes(N,I,z,R.bIsFlatListRequest);}if(!R.bAvoidLengthUpdate){var t1=false;if(e.__count){this.mServiceLength[n]=parseInt(e.__count);this.mLength[n]=this.mServiceLength[n]-X;this.mFinalLength[n]=true;if(R.bIsFlatListRequest){this.iTotalSize=e.__count;}t1=true;}if(!(n in this.mServiceLength)||this.mServiceLength[n]<K+_){this.mServiceLength[n]=K+_;this.mLength[n]=J+_-X;this.mFinalLength[n]=false;}if(_<M||M===undefined){this.mServiceLength[n]=K+_;this.mLength[n]=J+N.iIndex-J;this.mFinalLength[n]=true;t1=true;}if(_==0){this.mLength[n]=this.mServiceLength[n]=0;this.mFinalLength[n]=true;t1=true;}if(!t1&&this.mLength[n]!==undefined&&X>0){this.mLength[n]-=X;}}this.bNeedsUpdate=true;if(X>0){if(e.results.length-X>0){this.aMultiUnitLoadFactor[I.length]=e.results.length/(e.results.length-X);}if(this.aMultiUnitLoadFactor[I.length]<1.5){this.aMultiUnitLoadFactor[I.length]=2;}}w.info("MultiUnit Situation in Group ("+n+"), discarded: "+X+", load-factor is now: "+this.aMultiUnitLoadFactor[I.length]);};E.prototype._processTotalSizeQueryResponse=function(r,o){if(o.__count==undefined){w.fatal("missing entity count in query result");return;}this.iTotalSize=o.__count;};E.prototype._processLevelMembersQueryResponse=function(r,o){var e=this;var p,P;var g=function(h,I){var l={iRequestType:E._requestType.groupMembersQuery,sRequestId:e._getRequestId(E._requestType.groupMembersQuery,{groupId:p}),oAnalyticalQueryRequest:r.oAnalyticalQueryRequest,sGroupId:p,aSelectedUnitPropertyName:r.aSelectedUnitPropertyName,aAggregationLevel:r.aAggregationLevel,bIsFlatListRequest:r.bIsFlatListRequest,bIsLeafGroupsRequest:r.bIsLeafGroupsRequest,iStartIndex:h?r.iStartIndex:0,iLength:r.iLength,bAvoidLengthUpdate:r.bAvoidLengthUpdate};if(h&&r.iStartIndex>0&&(r.sGroupId_Missing_AtLevel!=l.sGroupId||e._getKeys(l.sGroupId)===undefined)){var s=e._getParentGroupId(l.sGroupId);var m=e._findKeyIndex(s,e.mEntityKey[l.sGroupId]);if(m<0){w.fatal("assertion failed: failed to determine position of "+l.sGroupId+" in group "+s);}else if(!m){e.mFinalLength[r.sGroupId_Missing_AtLevel]=true;}else if(e._getKey(s,m-1)!==undefined){var n=e._getKey(s,m-1);var q=e._getGroupIdFromContext(e.oModel.getContext('/'+n),e._getGroupIdLevel(l.sGroupId));e.mFinalLength[q]=true;l.iStartIndex=0;}}if(I){l.iLength=P.length;}l.oKeyIndexMapping=e._getKeyIndexMapping(l.sGroupId,l.iStartIndex);var z=Q.extend(true,{},o);z.results=P;e._processGroupMembersQueryResponse(l,z);};if(o.results.length==0){return;}p=this._getGroupIdFromContext(this.oModel.getContext("/"+this.oModel._getKey(o.results[0])),r.iLevel-1);P=[];var h=true;for(var i=0;i<o.results.length;i++){var j=o.results[i];var k=this.oModel.getContext("/"+this.oModel._getKey(o.results[i]));var s=this._getGroupIdFromContext(k,r.iLevel-1);if(p==s){P.push(j);if(i<o.results.length-1){continue;}}g(h,o.results.length==r.iLength&&i==o.results.length-1);h=false;if(p!=s){P=[j];}p=s;}if(o.results.length>1&&P.length==1){g(h,o.results.length==r.iLength);}};E.prototype._processReloadMeasurePropertiesQueryResponse=function(r,o){var m=r.oMultiUnitRepresentative;var M=this.oModel.getKey(m.oEntry);if(o.results.length!=1){w.fatal("assertion failed: more than one entity for reloaded measure properties of entity with key "+M);return;}var R=o.results[0];var e=this.oModel.getObject("/"+M);if(!e){w.fatal("assertion failed: no entity found with key "+M);return;}var g=m.aReloadMeasurePropertyName;for(var i=0;i<g.length;i++){e[g[i]]=R[g[i]];}};E.prototype._getLoadedContextsForGroup=function(g,s,l,e){var h=[],o,i,k=this._getKeys(g),K;if(!k){return h;}if(!s){s=0;}if(!l){l=this.oModel.iSizeLimit;if(this.mFinalLength[g]){l=this.mLength[g];}}if(e){i=s||0;K=k(i);while(K){o=this.oModel.getContext('/'+K);h.push(o);i++;K=k(i);}return h;}for(i=s;i<s+l;i++){K=k(i);if(!K){break;}o=this.oModel.getContext('/'+K);h.push(o);}return h;};E.prototype._calculateRequiredGroupSection=function(g,s,l,i){var e=this._getKeys(g);if(s>=i){s-=i;l+=i;}else{l+=s;s=0;}l+=i;if(this.mFinalLength[g]&&s+l>this.mLength[g]){l=this.mLength[g]-s;}if(e){while(l&&e(s)){s+=1;l-=1;}while(l&&e(s+l-1)){l-=1;}}return{startIndex:s,length:l};};E.prototype._calculateRequiredGroupExpansion=function(g,e,s,l){var n={groupId_Missing:null,length_Missing:0};var h=this;var j=function(g,e,s,l){var k=h._getGroupIdLevel(g);if(k==e){var H=h._getLoadedContextsForGroup(g,s,l);var I=s+H.length-1;if(H.length>=l){return n;}else if(h.mFinalLength[g]){if(H.length>=h.mLength[g]){return{groupId_Missing:null,length_Missing:l-H.length};}else{return{groupId_Missing:g,startIndex_Missing:I+1,length_Missing:l-H.length};}}else{return{groupId_Missing:g,startIndex_Missing:I+1,length_Missing:l-H.length};}}var J=h._getLoadedContextsForGroup(g,s,l);var m=l,K=s+J.length-1;for(var i=-1,M;(M=J[++i])!==undefined;){m--;var p=j(h._getGroupIdFromContext(M,k+1),e,0,m);if(p.groupId_Missing==null){if(p.length_Missing==0){return p;}else{m=p.length_Missing;}}else{return p;}if(m==0){break;}}if(h.mFinalLength[g]||m==0){return{groupId_Missing:null,length_Missing:m};}else{return{groupId_Missing:g,startIndex_Missing:K+1,length_Missing:m};}};var k=this._getGroupIdLevel(g);if(k==e+1){g=this._getParentGroupId(g);--k;}if(g==null||k>e){return n;}var m=l,o=s;while(g!=null){var p=j(g,e,o,m);if(p.groupId_Missing!=null){return p;}else if(p.length_Missing==0){return p;}else{var q=false;while(!q){var P=this._getParentGroupId(g);if(P==null){g=P;--k;break;}var r=this.mEntityKey[g];if(!r){return n;}var z=this._findKeyIndex(P,r);if(z==-1){return n;}if(z==this._getKeyCount(P)-1){if(this.mFinalLength[P]){g=P;--k;continue;}else{return{groupId_Missing:P,startIndex_Missing:z+1,length_Missing:m};}}else{r=this._getKey(P,z+1);g=this._getGroupIdFromContext(this.oModel.getContext('/'+r),k);q=true;}}o=0;m=p.length_Missing;}}return{groupId_Missing:null,length_Missing:m};};E.prototype._getResourcePath=function(){return this.isRelative()?this.oModel.resolve(this.sPath,this.getContext()):this.sPath;};E.prototype._getEntitySet=function(){var e=this.sEntitySetName;if(!e){e=this.sPath.split("/")[1];if(e.indexOf("(")!=-1){e=e.split("(")[0]+"Results";}}return e;};E.prototype._getEffectiveSortOrder=function(p){for(var i=0;i<this.aSorter.length;i++){if(this.aSorter[i]&&this.aSorter[i].sPath==p){return this.aSorter[i].bDescending?t.SortOrder.Descending:t.SortOrder.Ascending;}}return null;};E.prototype._getFilterOperatorMatchingPropertySortOrder=function(p,W){var s;switch(this._getEffectiveSortOrder(p)){case t.SortOrder.Ascending:if(W){s=a.GE;}else{s=a.GT;}break;case t.SortOrder.Descending:if(W){s=a.LE;}else{s=a.LT;}break;default:s=a.GT;}return s;};E.prototype._convertDeprecatedFilterObjects=function(e){if(!e){return e;}var O=sap.ui.require("sap/ui/model/odata/Filter");if(typeof O==='function'){for(var i=0,l=e.length;i<l;i++){if(e[i]instanceof O){e[i]=e[i].convert();}}}return e;};E.prototype._getGroupIdFromContext=function(o,l){if(!o){return null;}var g="/";var s=null;if(l>this.aAggregationLevel.length){w.fatal("assertion failed: aggregation level deeper than number of current aggregation levels");}for(var i=0;i<l;i++){s=o.getProperty(this.aAggregationLevel[i]);if(s!=null){if(s.__edmType==="Edm.Time"){s=s.ms;}g+=encodeURIComponent(s)+"/";}else{g+="@/";}}return g;};E.prototype._getGroupIdLevel=function(g){if(g==null){w.fatal("assertion failed: no need to determine level of group ID = null");return-1;}return g.split("/").length-2;};E.prototype._getGroupIdComponents=function(g){if(g==null){return null;}var e=g.split("/");var h=[];for(var i=1;i<e.length-1;i++){if(e[i]=="@"){h[i-1]=null;}else{h[i-1]=decodeURIComponent(e[i]);}}return h;};E.prototype._getGroupIdAncestors=function(g,n){if(!n){return[];}if(g==null){w.fatal("group ID null does not have ancestors");return[];}if(g=="/"){if(Math.abs(n)==1){return[null];}else{w.fatal("invalid level count "+n+" for ancestors of groupId "+g);return[];}}var e=g.split("/");var h=[],s="";var k=0,l=e.length-3;if(n>0){if(n-1>l){w.fatal("invalid level count "+n+" for ancestors of groupId "+g);}else{l=n-1;}}else if(-(n+1)>l){w.fatal("invalid level count "+n+" for ancestors of groupId "+g);}else{k=l+1+n;for(var i=0;i<k;i++){s+=e[i]+"/";}}for(var j=k;j<=l;j++){s+=e[j]+"/";h.push(s);}return h;};E.prototype._getParentGroupId=function(g){return this._getGroupIdAncestors(g,-1)[0];};E.prototype._removeDuplicatesFromStringArray=function(e){var o={};for(var i=0;i<e.length;i++){o[e[i]]=true;}var U=[];for(var s in o){U.push(s);}return U;};E.prototype._getIdForNewRequestHandle=function(){if(this.oPendingRequestHandle===undefined){this.oPendingRequestHandle=[];}for(var i=0;i<this.oPendingRequestHandle.length;i++){if(this.oPendingRequestHandle[i]===undefined){return i;}}this.oPendingRequestHandle[this.oPendingRequestHandle.length]=undefined;return this.oPendingRequestHandle.length-1;};E.prototype._registerNewRequestHandle=function(r,R){if(this.oPendingRequestHandle[r]!==undefined){w.fatal("request handle ID already in use");}this.oPendingRequestHandle[r]=R;};E.prototype._deregisterHandleOfCompletedRequest=function(r){if(Q.isEmptyObject(this.oPendingRequestHandle)){w.warning("No request handles to be cleared. Previous abort/resetData?");return;}if(this.oPendingRequestHandle[r]===undefined){w.fatal("no handle found for this request ID");}this.oPendingRequestHandle[r]=undefined;};E.prototype._abortAllPendingRequestsByHandle=function(){for(var i=0;i<this.oPendingRequestHandle.length;i++){if(this.oPendingRequestHandle[i]){if(this.oPendingRequestHandle[i]!==undefined){this.oPendingRequestHandle[i].abort();}}}this.oPendingRequestHandle=[];};E.prototype._getRequestId=function(r,p){switch(r){case E._requestType.groupMembersQuery:if(p.groupId===undefined){w.fatal("missing group ID");}return E._requestType.groupMembersQuery+(p.groupId==null?"":p.groupId);case E._requestType.levelMembersQuery:if(p.level===undefined){w.fatal("missing level");}if(p.groupId===undefined){w.fatal("missing groupId");}return""+E._requestType.levelMembersQuery+p.level+(p.tupleIndex?"-"+p.tupleIndex:"");case E._requestType.totalSizeQuery:return E._requestType.totalSizeQuery;case E._requestType.reloadMeasuresQuery:if(!p.multiUnitEntryKey){w.fatal("missing multi unit entry key");}return E._requestType.reloadMeasuresQuery+p.multiUnitEntryKey;default:w.fatal("invalid request type "+r);return-1;}};E.prototype._registerNewRequest=function(r){if(r==undefined||r==""){w.fatal("missing request ID");return;}if(!this.oPendingRequests[r]){this.oPendingRequests[r]=1;}else{++this.oPendingRequests[r];}};E.prototype._considerRequestGrouping=function(r){for(var i=-1,R;(R=r[++i])!==undefined;){if(this.oGroupedRequests[R]===undefined){this.oGroupedRequests[R]={};}var g=this.oGroupedRequests[R];for(var j=0;j<r.length;j++){g[r[j]]=true;}}};E.prototype._isRequestPending=function(r){return this.oPendingRequests[r]!=undefined&&this.oPendingRequests[r]>0;};E.prototype._deregisterCompletedRequest=function(r){if(Q.isEmptyObject(this.oPendingRequests)){w.warning("There are no pending requests which could be set to 'completed'.");return;}if(!this.oPendingRequests[r]){w.fatal("assertion failed: there is no pending request ID "+r);}if(this.oPendingRequests[r]==1){delete this.oPendingRequests[r];}else{--this.oPendingRequests[r];}};E.prototype._cleanupGroupingForCompletedRequest=function(r){if(this._isRequestPending(r)){return false;}var g=true;if(this.oGroupedRequests[r]!=undefined){for(var o in this.oGroupedRequests[r]){if(this.oPendingRequests[o]){g=false;break;}}}if(g){var R=this.oGroupedRequests[r];delete this.oGroupedRequests[r];for(var O in R){if(O!=r){this._cleanupGroupingForCompletedRequest(O);}}}return g;};E.prototype._getKeyIndexMapping=function(g,s){var k=this.mKeyIndex[g];var e=this.mServiceKey[g];var i=s;if(k!==undefined){var l=s;if(l>0){while(--l>0){if(k[l]!==undefined){break;}}}var h;if(l==0){h=0;}else{if(k[l]>=0){h=k[l];}else if(k[l+1]===undefined){h=k[l]=="ZERO"?0:-k[l];while(e[h+1]!==undefined){++h;}}else{h=Math.abs(k[l+1])-1;}if(e[h]===undefined){w.fatal("assertion failed: no service key at iLastOccupiedServiceKeyIndex = "+h);}}var j=s-l;i=h+j;}var K={sGroupId:g,iIndex:s,iServiceKeyIndex:i};return K;};E.prototype._moveKeyIndexMapping=function(k,i){return this._getKeyIndexMapping(k.sGroupId,k.iIndex+i);};E.prototype._getKey=function(g,i){var s=this.mKeyIndex[g][i];if(s===undefined){return undefined;}if(s>=0){return this.mServiceKey[g][s];}if(this.mMultiUnitKey[g]===undefined){w.fatal("assertion failed: missing expected multi currency key for group with ID "+g);return null;}var k=this.mMultiUnitKey[g][i];if(k===undefined){w.fatal("assertion failed: missing expected multi currency key for group with ID "+g+" at pos "+i);return null;}return k;};E.prototype._getKeys=function(g){if(this.mKeyIndex[g]===undefined){return undefined;}var e=this;return function(i){return e._getKey(g,i);};};E.prototype._getServiceKeys=function(g,I){var k=this.mKeyIndex[g];if(k===undefined){return undefined;}var s=this.mServiceKey[g],e=k[I];if(e===undefined){return undefined;}if(e>=0){return[s[e]];}var h=[];if(k[I+1]===undefined){e=k[I]=="ZERO"?0:-k[I];while(s[e]!==undefined){h.push(s[e++]);}}else{e=k[I]=="ZERO"?0:-k[I];for(var i=e,n=Math.abs(k[I+1]);i<n;i++){h.push(s[i]);}}return h;};E.prototype._getKeyCount=function(g){if(this.mKeyIndex[g]===undefined){return undefined;}return this.mKeyIndex[g].length;};E.prototype._findKeyIndex=function(g,k){var K=this.mKeyIndex[g];var s=this.mServiceKey[g];var m=this.mMultiUnitKey[g];for(var i=0;i<this.mLength[g];i++){if(K[i]<0){if(m[i]==k){return i;}}else if(s[K[i]]==k){return i;}}return-1;};E.prototype._setServiceKey=function(k,s){if(!this.mServiceKey[k.sGroupId]){this.mServiceKey[k.sGroupId]=[];}if(!this.mKeyIndex[k.sGroupId]){this.mKeyIndex[k.sGroupId]=[];}var n=this.mServiceKey[k.sGroupId][k.iServiceKeyIndex]===undefined;this.mServiceKey[k.sGroupId][k.iServiceKeyIndex++]=s;this.mKeyIndex[k.sGroupId][k.iIndex++]=k.iServiceKeyIndex-1;return n;};E.prototype._setAdjacentMultiUnitKeys=function(k,m,M){if(!this.mServiceKey[k.sGroupId]){this.mServiceKey[k.sGroupId]=[];}if(!this.mKeyIndex[k.sGroupId]){this.mKeyIndex[k.sGroupId]=[];}if(!this.mMultiUnitKey[k.sGroupId]){this.mMultiUnitKey[k.sGroupId]=[];}--k.iIndex;--k.iServiceKeyIndex;this.mMultiUnitKey[k.sGroupId][k.iIndex]=this.oModel._getKey(m.oEntry);this.mKeyIndex[k.sGroupId][k.iIndex++]=k.iServiceKeyIndex>0?-k.iServiceKeyIndex:"ZERO";var n=0;for(var i=0;i<M.length;i++){if(!this.mServiceKey[k.sGroupId][k.iServiceKeyIndex]){++n;}this.mServiceKey[k.sGroupId][k.iServiceKeyIndex++]=this.oModel._getKey(M[i]);}return n;};E.prototype._mergeLoadedKeyIndexWithSubsequentIndexes=function(k,e,s,I){var K=this.mKeyIndex[k.sGroupId],g=this.mServiceKey[k.sGroupId],m=this.mMultiUnitKey[k.sGroupId],h=0,n=k.iServiceKeyIndex,j=k.iIndex;var M,o;if(K===undefined){return h;}var N=false;var p=g[n-1],l=g[n];if(l===undefined){return h;}if(p===undefined){w.fatal("assertion failed: missing expected entry before given key index");return h;}var P=this.oModel.getObject("/"+p);var q=this.oModel.getObject("/"+l);var r="",z="";for(var i=0;i<e.length;i++){r+=P[e[i]]+"|";z+=q[e[i]]+"|";}N=r==z;var H=j;if(H>=this.mLength[k.sGroupId]){w.fatal("assertion failed: service key exists,but no corresponding key index found");return h;}while(K[H]===undefined||Math.abs(K[H])<n){++H;}if(N){if(Math.abs(K[H])==n&&K[H]<0){if(H>j){if(K[j-1]<0){m[H]=undefined;K.splice(j,H-j+1);m.splice(j,H-j+1);}else{K[j-1]=-K[j-1];m[j-1]=m[H];m[H]=undefined;K.splice(j,H-j+1);m.splice(j,H-j+1);h=1;}}}else if(Math.abs(K[H])>n){var J=H-1;if(K[J]>0){M=this._createMultiUnitRepresentativeEntry(k.sGroupId,P,s,undefined,I);o=this.oModel._getKey(M.oEntry);K[J]=-K[J];m[J]=o;if(J>j){K.splice(j,J-j);m.splice(j,J-j);}if(M.bIsNewEntry){h=1;}else{h=0;}}else if(K[j-1]<0){if(H>j){m[J]=undefined;K.splice(j,J-j+1);m.splice(j,J-j+1);}}else{K[j-1]=-K[j-1];m[j-1]=m[J];m[J]=undefined;K.splice(j,J-j+1);m.splice(j,J-j+1);}}else if(K[H]==n){if(H>j){if(K[j-1]<0){K.splice(j,H-j+1);m.splice(j,H-j+1);h=1;}else{M=this._createMultiUnitRepresentativeEntry(k.sGroupId,P,s,undefined,I);o=this.oModel._getKey(M.oEntry);if(!M.bIsNewEntry){w.fatal("assertion failed: multi-unit entry already existed before");}K[j-1]=-K[j-1];m[j-1]=o;K.splice(j,H-j+1);m.splice(j,H-j+1);h=1;}}}else{w.fatal("assertion failed: uncovered case detected");return h;}}else if(K[H]>n){w.fatal("unstable query result for group ID "+k.sGroupId+": entries have been removed or added. Complete reload required");}else if(H-j>0){K.splice(j,H-j);m.splice(j,H-j);}return h;};E.prototype._createMultiUnitRepresentativeEntry=function(g,r,s,e,i){var m=Q.extend(true,{},r);var R=[];for(var M in this.oMeasureDetailsSet){var o=this.oMeasureDetailsSet[M];if(!i&&this._isSkippingTotalForMeasure(M)){if(o.rawValuePropertyName!=undefined){m[o.rawValuePropertyName]=undefined;}if(o.formattedValuePropertyName!=undefined){m[o.formattedValuePropertyName]=undefined;}}else{if(o.rawValuePropertyName!=undefined){m[o.rawValuePropertyName]=null;}if(o.formattedValuePropertyName!=undefined){m[o.formattedValuePropertyName]="*";}}if(e){if(!o.unitPropertyName||e.indexOf(o.unitPropertyName)==-1){R.push(o.rawValuePropertyName||o.name);}}}for(var k=0;k<s.length;k++){if(e.indexOf(s[k])!=-1){m[s[k]]="*";}}var h="";for(var l=0;l<this.aAllDimensionSortedByName.length;l++){var j=m[this.aAllDimensionSortedByName[l]];var n=j===""?'""':j;n=n===undefined?"":n;h+=(encodeURIComponent(n)+",");}h+="-multiple-units-not-dereferencable";var p;if(this.mMultiUnitKey[g]&&(p=this.mMultiUnitKey[g].indexOf(h))!=-1){return{oEntry:this.oModel.getObject("/"+h),bIsNewEntry:false,iIndex:p,aReloadMeasurePropertyName:R};}m.__metadata.uri=h;delete m.__metadata["self"];delete m.__metadata["self_link_extensions"];m["^~volatile"]=true;this.oModel._importData(m,{},{});var q=this.oModel._getKey(m);this.oModel.getContext('/'+q)["_volatile"]=true;return{oEntry:m,bIsNewEntry:true,aReloadMeasurePropertyName:R};};E.prototype._clearAllPendingRequests=function(){this.oPendingRequests={};this.oGroupedRequests={};};E.prototype.resetData=function(o){var g=o?o.getPath():undefined;this._resetData(g);};E.prototype._resetData=function(g){if(g){delete this.mServiceKey[g];delete this.mServiceLength[g];delete this.mServiceFinalLength[g];delete this.mKeyIndex[g];delete this.mLength[g];delete this.mMultiUnitKey[g];delete this.mEntityKey[g];}else{this.mServiceKey={};this.mServiceLength={};this.mServiceFinalLength={};this.mFinalLength=this.mServiceFinalLength;this.mKeyIndex={};this.mLength={};this.mMultiUnitKey={};this.mEntityKey={};}};E.prototype.refresh=function(e){E.prototype._refresh.apply(this,arguments);};E.prototype._refresh=function(e,m,g){var h=false;if(!e){if(g){var r=this.oModel.resolve(this.sPath,this.oContext);var o=this.oModel.oMetadata._getEntityTypeByPath(r);if(o&&(o.entityType in g)){h=true;}}if(m&&!h){Q.each(this.mServiceKey,function(i,n){Q.each(n,function(i,k){if(k in m){h=true;return false;}});if(h){return false;}});}if(!m&&!g){h=true;}}if(e||h){this.iTotalSize=-1;this._abortAllPendingRequests();this.resetData();this.bNeedsUpdate=false;this._fireRefresh({reason:C.Refresh});}};E.prototype.checkUpdate=function(e,m){var g=false;if(!e){if(this.bNeedsUpdate||!m){g=true;}else{Q.each(this.mServiceKey,function(i,n){Q.each(n,function(i,k){if(k in m){g=true;return false;}});if(g){return false;}});}}if(e||g){this.bNeedsUpdate=false;this._fireChange({reason:C.Change});}};E.prototype.getDownloadUrl=function(s){var e,p,z;var o=new t.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());var g=[];var h=[];for(var n in this.oDimensionDetailsSet){g.push(n);}o.setAggregationLevel(g);for(var q in this.oDimensionDetailsSet){var r=this.oDimensionDetailsSet[q];var I=(r.textPropertyName!=undefined);o.includeDimensionKeyTextAttributes(r.name,true,I,r.aAttributeName);}for(var M in this.oMeasureDetailsSet){h.push(M);}o.setMeasures(h);for(var H in this.oMeasureDetailsSet){var J=this.oMeasureDetailsSet[H];var K=(J.rawValuePropertyName!=undefined);var N=(J.formattedValuePropertyName!=undefined);var O=(J.unitPropertyName!=undefined);o.includeMeasureRawFormattedValueUnit(J.name,K,N,O);}var P=o.getSortExpression();P.clear();for(var i=0;i<this.aSorter.length;i++){if(this.aSorter[i]){P.addSorter(this.aSorter[i].sPath,this.aSorter[i].bDescending?t.SortOrder.Descending:t.SortOrder.Ascending);}}var R=o.getFilterExpression();R.clear();if(this.aApplicationFilter){R.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){R.addUI5FilterConditions(this.aControlFilter);}var U=o.getURIToQueryResultEntitySet();var V=this._getQueryODataRequestOptions(o,true);if(!V){return undefined;}var W=[];for(var k=0,m=this.aAnalyticalInfo.length;k<m;k++){var X=this.aAnalyticalInfo[k];if((X.visible||X.inResult)&&X.name!==""&&X.name!==W[W.length-1]){W.push(X.name);if(this.oMeasureDetailsSet[X.name]!=undefined&&this.oMeasureDetailsSet[X.name].unitPropertyName!=undefined){W.push(this.oMeasureDetailsSet[X.name].unitPropertyName);}}}for(var j=0,l=V.length;j<l;j++){if(/^\$select/i.test(V[j])){if(this.mParameters.select){e=V[j].slice(8).split(",");for(z=0;z<e.length;z++){p=e[z];if(W.indexOf(p)===-1){W.push(p);}}}V[j]="$select="+W.join(",");break;}}if(s){V.splice(0,0,"$format="+encodeURIComponent(s));}if(this.sCustomParams){V.push(this.sCustomParams);}if(U){return this.oModel._createRequestUrl(U,null,V).replace(/ /g,"%20");}};E.prototype._addSorters=function(s,g){var e=this._canApplySortersToGroups()?[].concat(this.aSorter).concat(g):[].concat(g).concat(this.aSorter);e.forEach(function(o){s.addSorter(o.sPath,o.bDescending?t.SortOrder.Descending:t.SortOrder.Ascending);});};E.prototype._canApplySortersToGroups=function(){var s=this._autoExpandMode;if(this.bApplySortersToGroups){if(this.aSorter.length>0){if(s!==this.sLastAutoExpandMode&&s!==f.Sequential){w.warning("Applying sorters to groups is only possible with auto"+" expand mode 'Sequential'; current mode is: "+s,this.sPath);}this.sLastAutoExpandMode=s;}return s===f.Sequential;}return false;};E.prototype._warnNoSortingOfGroups=function(s){var m;if(this.bApplySortersToGroups){m="Detected a multi-unit case, so sorting is only possible on leaves";if(s){m+="; "+s;}w.warning(m,this.sPath);}this.bApplySortersToGroups=false;};E.prototype._isSkippingTotalForMeasure=function(m){var o=this.mAnalyticalInfoByProperty[m];return!!o&&o.total==false;};E.Logger=w;return E;});
