/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/ManagedObject","sap/ui/fl/Utils","sap/ui/rta/command/Settings","sap/ui/rta/command/CompositeCommand","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/write/api/PersistenceWriteAPI"],function(M,F,S,C,J,P){"use strict";var a=M.extend("sap.ui.rta.command.Stack",{metadata:{library:"sap.ui.rta",properties:{},aggregations:{commands:{type:"sap.ui.rta.command.BaseCommand",multiple:true}},events:{modified:{},commandExecuted:{parameters:{command:{type:"object"},undo:{type:"boolean"}}}}}});a.initializeWithChanges=function(c,f){var s=new a();s._aPersistedChanges=f;var m={};if(f&&f.length>0){var o=F.getComponentForControl(c);var A=sap.ui.fl.Utils.getAppDescriptor(o)["sap.app"].id;var p={oComponent:o,appName:A,selector:c,invalidateCache:false};return P._getUIChanges(p).then(function(b){var d={};b.forEach(function(e){d[e.getDefinition().fileName]=e;});f.forEach(function(e){var g=d[e];var h=g.getSelector();var i=new S({selector:h,changeType:g.getDefinition().changeType,element:J.bySelector(h,o)});i._oPreparedChange=g;if(g.getUndoOperations()){i._aRecordedUndo=g.getUndoOperations();g.resetUndoOperations();}var j=g.getDefinition().support.compositeCommand;if(j){if(!m[j]){m[j]=new C();s.pushExecutedCommand(m[j]);}m[j].addCommand(i);}else{s.pushExecutedCommand(i);}});return s;});}return Promise.resolve(s);};a.prototype.addCommandExecutionHandler=function(h){this._aCommandExecutionHandler.push(h);};a.prototype.removeCommandExecutionHandler=function(h){var i=this._aCommandExecutionHandler.indexOf(h);if(i>-1){this._aCommandExecutionHandler.splice(i,1);}};a.prototype.init=function(){this._aCommandExecutionHandler=[];this._toBeExecuted=-1;this._oLastCommand=Promise.resolve();};a.prototype._waitForCommandExecutionHandler=function(p){return Promise.all(this._aCommandExecutionHandler.map(function(h){return h(p);}));};a.prototype._getCommandToBeExecuted=function(){return this.getCommands()[this._toBeExecuted];};a.prototype.pushExecutedCommand=function(c){this.push(c,true);};a.prototype.push=function(c,e){if(this._bUndoneCommands){this._bUndoneCommands=false;while(this._toBeExecuted>-1){this.pop();}}this.insertCommand(c,0);if(!e){this._toBeExecuted++;}this.fireModified();};a.prototype.top=function(){return this.getCommands()[0];};a.prototype.pop=function(){if(this._toBeExecuted>-1){this._toBeExecuted--;}return this.removeCommand(0);};a.prototype.removeCommand=function(o,s){var r=this.removeAggregation("commands",o,s);this.fireModified();return r;};a.prototype.removeAllCommands=function(s){var c=this.removeAllAggregation("commands",s);this._toBeExecuted=-1;this.fireModified();return c;};a.prototype.isEmpty=function(){return this.getCommands().length===0;};a.prototype.execute=function(){this._oLastCommand=this._oLastCommand.catch(function(){}).then(function(){var c=this._getCommandToBeExecuted();if(c){return c.execute().then(function(){this._toBeExecuted--;var p={command:c,undo:false};this.fireCommandExecuted(p);this.fireModified();return this._waitForCommandExecutionHandler(p);}.bind(this)).catch(function(e){e=e||new Error("Executing of the change failed.");e.index=this._toBeExecuted;e.command=this.removeCommand(this._toBeExecuted);this._toBeExecuted--;return Promise.reject(e);}.bind(this));}}.bind(this));return this._oLastCommand;};a.prototype._unExecute=function(){if(this.canUndo()){this._bUndoneCommands=true;this._toBeExecuted++;var c=this._getCommandToBeExecuted();if(c){return c.undo().then(function(){var p={command:c,undo:true};this.fireCommandExecuted(p);this.fireModified();return this._waitForCommandExecutionHandler(p);}.bind(this));}return Promise.resolve();}return Promise.resolve();};a.prototype.canUndo=function(){return(this._toBeExecuted+1)<this.getCommands().length;};a.prototype.undo=function(){return this._unExecute();};a.prototype.canRedo=function(){return!!this._getCommandToBeExecuted();};a.prototype.redo=function(){return this.execute();};a.prototype.pushAndExecute=function(c){this.push(c);return this.execute();};a.prototype.getAllExecutedCommands=function(){var A=[];var c=this.getCommands();for(var i=c.length-1;i>this._toBeExecuted;i--){var s=this.getSubCommands(c[i]);A=A.concat(s);}return A;};a.prototype.getSubCommands=function(c){var b=[];if(c.getCommands){c.getCommands().forEach(function(s){var d=this.getSubCommands(s);b=b.concat(d);},this);}else{b.push(c);}return b;};return a;},true);
