/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/dt/Plugin","sap/ui/fl/registry/ChangeRegistry","sap/ui/dt/OverlayRegistry","sap/ui/dt/OverlayUtil","sap/ui/dt/ElementOverlay","sap/ui/fl/changeHandler/JsControlTreeModifier","sap/ui/rta/util/hasStableId"],function(P,C,O,a,E,J,h){"use strict";var B=P.extend("sap.ui.rta.plugin.Plugin",{metadata:{"abstract":true,library:"sap.ui.rta",properties:{commandFactory:{type:"object",multiple:false}},events:{elementModified:{command:{type:"sap.ui.rta.command.BaseCommand"}}}}});B.prototype._isEditable=function(){};B.prototype.executeWhenVisible=function(e,c){var g=function(o){if(o.getSource().getGeometry()&&o.getSource().getGeometry().visible){e.detachEvent('geometryChanged',g,this);c();}};if(!e.getGeometry()||!e.getGeometry().visible){e.attachEvent('geometryChanged',g,this);}else{c();}};var _=function(e){var p=e.getParameters();var r;var o=e.getSource();if(p.type==="propertyChanged"&&p.name==="visible"){r=this._getRelevantOverlays(o);if(p.value===true){this.executeWhenVisible(o,function(){this.evaluateEditable(r,{onRegistration:false});}.bind(this));}else{this.evaluateEditable(r,{onRegistration:false});}}else if(p.type==="afterRendering"){if(this.getDesignTime().getStatus()==='synced'){this.evaluateEditable([o],{onRegistration:false});}else{this.getDesignTime().attachEventOnce("synced",function(){this.evaluateEditable([o],{onRegistration:false});},this);}}else if(p.type==="insertAggregation"||p.type==="removeAggregation"){r=this._getRelevantOverlays(o,p.name);this.evaluateEditable(r,{onRegistration:false});}else if(p.type==="addOrSetAggregation"){if(this.getDesignTime().getStatus()==='synced'){r=this._getRelevantOverlays(o,p.name);this.evaluateEditable(r,{onRegistration:false});}else{this.getDesignTime().attachEventOnce("synced",function(){r=this._getRelevantOverlays(o,p.name);this.evaluateEditable(r,{onRegistration:false});},this);}}};B.prototype._getRelevantOverlays=function(o,A){var b=o.getRelevantOverlays();if(b.length===0){var r=a.findAllOverlaysInContainer(o);if(A){var c=o.getAggregationOverlay(A);var d=c?c.getChildren():[];d=d.filter(function(e){return r.indexOf(e)===-1;});r=r.concat(d);}o.setRelevantOverlays(r);return r;}return b;};B.prototype.evaluateEditable=function(o,p){var b=[];if(!p.onRegistration&&this.getDesignTime()&&this.getDesignTime().getBusyPlugins().length){return;}this.setProcessingStatus(true);o.forEach(function(c){var e=c.getElement()&&c.getDesignTimeMetadata()&&!c.getDesignTimeMetadata().markedAsNotAdaptable()&&this._isEditable(c,p);if(e&&typeof e.then==="function"){e.then(function(v){this._handleModifyPluginList(c,v);}.bind(this));b.push(e);}else{this._handleModifyPluginList(c,e);}}.bind(this));if(b.length){Promise.all(b).then(function(){this.setProcessingStatus(false);}.bind(this)).catch(function(){this.setProcessingStatus(false);}.bind(this));}else{this.setProcessingStatus(false);}};B.prototype._handleModifyPluginList=function(o,e){if(e!==undefined&&e!==null){if(typeof e==="boolean"){this._modifyPluginList(o,e);}else{this._modifyPluginList(o,e.asChild,false);this._modifyPluginList(o,e.asSibling,true);}}};B.prototype._modifyPluginList=function(o,i,b){if(i){this.addToPluginsList(o,b);}else{this.removeFromPluginsList(o,b);}};B.prototype._retrievePluginName=function(s){var n=this.getMetadata().getName();if(s!==undefined){n+=s?".asSibling":".asChild";}return n;};B.prototype._isEditableByPlugin=function(o,s){var p=this._retrievePluginName(s);var b=o.getEditableByPlugins();return b.indexOf(p)>-1;};B.prototype.registerElementOverlay=function(o){this.executeWhenVisible(o,function(){this.evaluateEditable([o],{onRegistration:true});o.attachElementModified(_,this);}.bind(this));};B.prototype.deregisterElementOverlay=function(o){this.removeFromPluginsList(o);this.removeFromPluginsList(o,true);this.removeFromPluginsList(o,false);o.detachElementModified(_,this);};B.prototype.hasStableId=function(o){return h(o);};B.prototype.getVariantManagementReference=function(o){var v;if(o.getVariantManagement){v=o.getVariantManagement();}return v;};B.prototype.checkAggregationsOnSelf=function(o,A,p){var d=o.getDesignTimeMetadata();var e=o.getElement();var b=d.getActionDataFromAggregations(A,o.getElement());var c=b.filter(function(g){if(g&&p){return g.aggregation===p;}return true;})[0];var s=c?c.changeType:null;var f=c&&c.changeOnRelevantContainer;if(f){e=o.getRelevantContainer();var r=O.getOverlay(e);if(!this.hasStableId(r)){return Promise.resolve(false);}}if(s){return this.hasChangeHandler(s,e).then(function(H){return H;});}return Promise.resolve(false);};B.prototype.removeFromPluginsList=function(o,s){var n=this._retrievePluginName(s);o.removeEditableByPlugin(n);if(!o.getEditableByPlugins().length){o.setEditable(false);}};B.prototype.addToPluginsList=function(o,s){var n=this._retrievePluginName(s);var p=o.getEditableByPlugins();if(p.indexOf(n)===-1){o.addEditableByPlugin(n);o.setEditable(true);}};B.prototype.hasChangeHandler=function(c,e){return this._getChangeHandler(c,e).then(function(o){return!!o;});};B.prototype._getChangeHandler=function(c,e,s){if(!s){s=e.getMetadata().getName();}var l=this.getCommandFactory().getFlexSettings().layer;return C.getInstance().getChangeHandler(c,s,e,J,l);};B.prototype.isAvailable=function(e){return e.every(function(o){return this._isEditableByPlugin(o);},this);};B.prototype._checkRelevantContainerStableID=function(A,e){if(A.changeOnRelevantContainer){var r=e.getRelevantContainer();var R=O.getOverlay(r);if(!this.hasStableId(R)){return false;}}return true;};return B;},true);
