/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/ui/core/theming/Parameters','sap/ui/Device','./library',"./Column",'./TableUtils',"./TableExtension",'sap/ui/core/Renderer','sap/ui/core/IconPool',"sap/base/Log"],function(C,P,D,a,b,T,c,R,I,L){"use strict";var V=a.VisibleRowCountMode;var S=a.SortOrder;var f={Begin:"flex-start",End:"flex-end",Left:undefined,Right:undefined,Center:"center"};var d={apiVersion:2};d.render=function(r,t){delete t._iHeaderRowCount;f.Left=t._bRtlMode?"flex-end":"flex-start";f.Right=t._bRtlMode?"flex-start":"flex-end";T.getResourceBundle();r.openStart("div",t);t._getAccRenderExtension().writeAriaAttributesFor(r,t,"ROOT");r.class("sapUiTable");if(D.browser.chrome&&window.devicePixelRatio<1){r.class("sapUiTableZoomout");}if('ontouchstart'in document){r.class("sapUiTableTouch");}r.class("sapUiTableSelMode"+t.getSelectionMode());if(t.getColumnHeaderVisible()){r.class("sapUiTableCHdr");}if(T.hasRowHeader(t)){r.class("sapUiTableRowSelectors");}if(T.hasRowHighlights(t)){r.class("sapUiTableRowHighlights");}var s=a.TableHelper.addTableClass();if(s){r.class(s);}var o=t._getScrollExtension();if(o.isVerticalScrollbarRequired()&&!o.isVerticalScrollbarExternal()){r.class("sapUiTableVScr");}if(t.getEditable()){r.class("sapUiTableEdt");}if(T.hasRowActions(t)){var i=T.getRowActionCount(t);r.class(i==1?"sapUiTableRActS":"sapUiTableRAct");}if(T.isNoDataVisible(t)&&!T.hasPendingRequests(t)){r.class("sapUiTableEmpty");}if(t.getShowOverlay()){r.class("sapUiTableOverlay");}var m=T.Grouping.getModeCssClass(t);if(m){r.class(m);}r.style("width",t.getWidth());t._getRowMode().applyTableStyles(r);if(t._bFirstRendering){r.class("sapUiTableNoOpacity");}r.openEnd();this.renderTabElement(r,"sapUiTableOuterBefore");if(t.getTitle()){this.renderHeader(r,t,t.getTitle());}if(t.getToolbar()){this.renderToolbar(r,t,t.getToolbar());}if(t.getExtension()&&t.getExtension().length>0){this.renderExtensions(r,t,t.getExtension());}r.openStart("div",t.getId()+"-sapUiTableCnt");r.class("sapUiTableCnt");r.attr("data-sap-ui-fastnavgroup","true");r.openEnd();r.openStart("div",t.getId()+"-sapUiTableGridCnt");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"CONTENT");r.openEnd();this.renderColRsz(r,t);this.renderColHdr(r,t);this.renderTable(r,t);r.close("div");var e=t.getCreationRow();if(e){r.renderControl(e);this.renderHSbBackground(r,t);this.renderHSb(r,t);}t._getAccRenderExtension().writeHiddenAccTexts(r,t);r.openStart("div",t.getId()+"-overlay");r.class("sapUiTableOverlayArea");r.attr("tabindex","0");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"OVERLAY");r.openEnd();r.close("div");r.close("div");if(t.getFooter()){this.renderFooter(r,t,t.getFooter());}if(t.getVisibleRowCountMode()==V.Interactive){this.renderVariableHeight(r,t);}this.renderBottomPlaceholder(r,t);this.renderTabElement(r,"sapUiTableOuterAfter");r.close("div");};d.renderHeader=function(r,t,o){r.openStart("div");r.class("sapUiTableHdr");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLEHEADER");r.openEnd();r.renderControl(o);r.close("div");};d.renderToolbar=function(r,t,o){if(!T.isA(o,"sap.ui.core.Toolbar")){return;}r.openStart("div");r.class("sapUiTableTbr");if(typeof o.getStandalone==="function"&&o.getStandalone()){o.setStandalone(false);}if(o.isA("sap.m.Toolbar")){o.setDesign("Transparent",true);o.addStyleClass("sapMTBHeader-CTX");r.class("sapUiTableMTbr");}t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLESUBHEADER");r.openEnd();r.renderControl(o);r.close("div");};d.renderExtensions=function(r,t,e){for(var i=0,l=e.length;i<l;i++){this.renderExtension(r,t,e[i]);}};d.renderExtension=function(r,t,e){r.openStart("div");r.class("sapUiTableExt");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLESUBHEADER");r.openEnd();r.renderControl(e);r.close("div");};d.renderTable=function(r,t){this.renderTabElement(r,"sapUiTableCtrlBefore");r.openStart("div",t.getId()+"-tableCCnt");t._getRowMode().applyRowContainerStyles(r);r.class("sapUiTableCCnt");r.openEnd();this.renderTableCCnt(r,t);r.close("div");this.renderTabElement(r,"sapUiTableCtrlAfter");if(!t._getScrollExtension().isVerticalScrollbarExternal()){this.renderVSbBackground(r,t);this.renderVSb(r,t);}var o=t.getCreationRow();if(!o){this.renderHSbBackground(r,t);this.renderHSb(r,t);}};d.renderTableCCnt=function(r,t){this.renderTableCtrl(r,t);this.renderRowHdr(r,t);this.renderRowActions(r,t);r.openStart("div",t.getId()+"-noDataCnt");r.class("sapUiTableCtrlEmpty");r.attr("tabindex","0");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"NODATA");r.openEnd();if(t.getNoData()instanceof C){r.renderControl(t.getNoData());}else{r.openStart("span",t.getId()+"-noDataMsg");r.class("sapUiTableCtrlEmptyMsg");r.openEnd();r.text(T.getNoDataText(t));r.close("span");}r.close("div");};d.renderFooter=function(r,t,F){r.openStart("div");r.class("sapUiTableFtr");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLEFOOTER");r.openEnd();r.renderControl(F);r.close("div");};d.renderVariableHeight=function(r,t){r.openStart("div",t.getId()+"-sb");r.attr("tabindex","-1");r.class("sapUiTableHeightResizer");r.style("height","5px");r.openEnd();r.close("div");};d.renderBottomPlaceholder=function(r,t){var p=t._getRowMode().getTableBottomPlaceholderStyles();if(p===undefined){return;}r.openStart("div",t.getId()+"-placeholder-bottom");r.class("sapUiTablePlaceholder");t._getRowMode().applyTableBottomPlaceholderStyles(r);r.openEnd();r.close("div");};d.renderColHdr=function(r,t){var n=T.getHeaderRowCount(t);var e=t.getColumns();var F=t.getComputedFixedColumnCount();r.openStart("div");r.class("sapUiTableColHdrCnt");r.openEnd();this.renderColRowHdr(r,t);if(F>0){r.openStart("div");r.class("sapUiTableCHA");r.class("sapUiTableCtrlScrFixed");r.class("sapUiTableNoOpacity");r.openEnd();this.renderTableControlCnt(r,t,true,0,F,true,false,0,n,true);r.close("div");}r.openStart("div",t.getId()+"-sapUiTableColHdrScr");r.class("sapUiTableCHA");r.class("sapUiTableCtrlScr");if(e.length==0){r.class("sapUiTableHasNoColumns");}if(F>0){if(t._bRtlMode){r.style("margin-right","0");}else{r.style("margin-left","0");}}r.openEnd();this.renderTableControlCnt(r,t,false,F,e.length,false,false,0,n,true);r.close("div");if(T.hasRowActions(t)){r.openStart("div");r.attr("id",t.getId()+"-rowacthdr");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"ROWACTIONHEADER");r.class("sapUiTableCell");r.class("sapUiTableHeaderCell");r.class("sapUiTableRowActionHeaderCell");r.openEnd();r.openStart("span");r.openEnd();r.text(T.getResourceText("TBL_ROW_ACTION_COLUMN_LABEL"));r.close("span");r.close("div");}r.close("div");};d.renderColRowHdr=function(r,t){var e=false;var s=false;var m=t._getSelectionPlugin().getRenderConfig();r.openStart("div",t.getId()+"-selall");r.class("sapUiTableCell");r.class("sapUiTableHeaderCell");r.class("sapUiTableRowSelectionHeaderCell");var g;if(m.headerSelector.visible){var A=T.areAllRowsSelected(t);if(m.headerSelector.type==="toggle"){g=A?"TBL_DESELECT_ALL":"TBL_SELECT_ALL";}else if(m.headerSelector.type==="clear"){g="TBL_DESELECT_ALL";}if(t._getShowStandardTooltips()&&g){r.attr("title",T.getResourceText(g));}if(!A){r.class("sapUiTableSelAll");}else{s=true;}r.class("sapUiTableSelAllEnabled");e=true;}else{r.class("sapUiTableSelAllDisabled");}r.attr("tabindex","-1");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"COLUMNROWHEADER",{enabled:e,checked:s});r.openEnd();if(m.headerSelector.visible){if(m.headerSelector.type==="clear"&&m.headerSelector.icon){r.renderControl(m.headerSelector.icon);}else{r.openStart("div");r.class("sapUiTableSelectAllCheckBox");r.openEnd();r.close("div");}}r.close("div");};d.renderCol=function(r,t,o,h,n,i,e,g,j){var l,k=!n,m=o.getIndex(),p=o.getMultiLabels();if(p.length>0){l=p[h];}else if(h==0){l=o.getLabel();}var H=o.getId();if(h===0){r.openStart("td",o);}else{H=H+"_"+h;r.openStart("td",H);}r.attr('data-sap-ui-colid',o.getId());r.attr("data-sap-ui-colindex",m);r.attr("tabindex","-1");var A={column:o,headerId:H,index:m};if(n>1){r.attr("colspan",n);A.colspan=true;}if(j){var F=o.getFiltered();var s=o.getSorted();if(F){r.class("sapUiTableColFiltered");}if(s){r.class("sapUiTableColSorted");if(o.getSortOrder()===S.Descending){r.class("sapUiTableColSortedD");}}}t._getAccRenderExtension().writeAriaAttributesFor(r,t,"COLUMNHEADER",A);r.class("sapUiTableCell");r.class("sapUiTableHeaderCell");r.class("sapUiTableHeaderDataCell");if(t.getEnableColumnReordering()||t.hasListeners("columnSelect")||o._menuHasItems()){r.class("sapUiTableHeaderCellActive");}if(i){r.class("sapUiTableCellFirst");}if(e){r.class("sapUiTableCellLastFixed");}if(g){r.class("sapUiTableCellLast");}if(k){r.class("sapUiTableHidden");}if(t.getColumnHeaderHeight()>0){r.style("height",t.getColumnHeaderHeight()+"px");}var q=o.getTooltip_AsString();if(q){r.attr("title",q);}r.openEnd();r.openStart("div");r.class("sapUiTableCellInner");r.attr("id",H+"-inner");var u=o.getHAlign();var v=R.getTextAlign(u);if(v){r.style("text-align",v);}r.openEnd();r.openStart("div");r.style("justify-content",f[u]);r.openEnd();if(l){r.renderControl(l);}r.close("div");r.close("div");r.close("td");};d.renderColRsz=function(r,t){r.openStart("div",t.getId()+"-rsz");r.class("sapUiTableColRsz");r.openEnd();r.close("div");};d.renderRowHdr=function(r,t){r.openStart("div",t.getId()+"-sapUiTableRowHdrScr");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"PRESENTATION");r.class("sapUiTableRowHdrScr");r.class("sapUiTableNoOpacity");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"ROWHEADER_COL");r.openEnd();for(var e=0,g=t.getRows().length;e<g;e++){this.renderRowAddon(r,t,t.getRows()[e],e,true);}r.close("div");};d.renderRowActions=function(r,t){if(!T.hasRowActions(t)){return;}r.openStart("div",t.getId()+"-sapUiTableRowActionScr");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"PRESENTATION");r.class("sapUiTableRowActionScr");r.class("sapUiTableNoOpacity");r.openEnd();for(var e=0,g=t.getRows().length;e<g;e++){this.renderRowAddon(r,t,t.getRows()[e],e,false);}r.close("div");};d.addRowCSSClasses=function(r,t,i){var m=t._getRowCounts();var F=T.getFirstFixedBottomRowIndex(t);if(i===0){r.class("sapUiTableFirstRow");}else if(i===t.getRows().length-1){r.class("sapUiTableLastRow");}if(m.fixedTop>0){if(i==m.fixedTop-1){r.class("sapUiTableRowLastFixedTop");}}if(F>=0&&F===i){r.class("sapUiTableRowFirstFixedBottom");}else if(F>=1&&F-1===i){r.class("sapUiTableRowLastScrollable");}};d.renderRowAddon=function(r,t,o,i,h){var e=t._getSelectionPlugin().isIndexSelected(o.getIndex());r.openStart("div");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TR",{index:i,rowHidden:o._bHidden});r.attr("data-sap-ui-related",o.getId());r.attr("data-sap-ui-rowindex",i);r.class("sapUiTableRow");r.class("sapUiTableContentRow");if(o._bHidden){r.class("sapUiTableRowHidden");}else if(e){r.class("sapUiTableRowSel");}if(i%2!=0&&t.getAlternateRowColors()&&!T.Grouping.isTreeMode(t)){r.class("sapUiTableRowAlternate");}this.addRowCSSClasses(r,t,i);r.openEnd();r.openStart("div",t.getId()+(h?"-rowsel":"-rowact")+i);r.class("sapUiTableCell");r.class("sapUiTableContentCell");r.class(h?"sapUiTableRowSelectionCell":"sapUiTableRowActionCell");t._getRowMode().renderRowStyles(r);r.attr("tabindex","-1");t._getAccRenderExtension().writeAriaAttributesFor(r,t,h?"ROWHEADER":"ROWACTION",{rowSelected:e,rowHidden:o._bHidden});r.openEnd();if(h){this.writeRowHighlightContent(r,t,o,i);this.writeRowSelectorContent(r,t,o,i);}else{var A=o.getRowAction();if(A){r.renderControl(A);}}r.close("div");r.close("div");};d.renderTableCtrl=function(r,t){if(t.getComputedFixedColumnCount()>0){r.openStart("div");r.attr("id",t.getId()+"-sapUiTableCtrlScrFixed");r.class("sapUiTableCtrlScrFixed");r.openEnd();this.renderTableControl(r,t,true);r.close("div");}r.openStart("div",t.getId()+"-sapUiTableCtrlScr");r.class("sapUiTableCtrlScr");if(t.getComputedFixedColumnCount()>0){if(t._bRtlMode){r.style("margin-right","0");}else{r.style("margin-left","0");}}r.openEnd();r.openStart("div",t.getId()+"-tableCtrlCnt");r.class("sapUiTableCtrlCnt");r.openEnd();this.renderTableControl(r,t,false);r.close("div");r.close("div");};d.renderTableControl=function(r,t,F){var s,e;if(F){s=0;e=t.getComputedFixedColumnCount();}else{s=t.getComputedFixedColumnCount();e=t.getColumns().length;}var m=t._getRowCounts();var g=t.getRows();if(m.fixedTop>0){this.renderTableControlCnt(r,t,F,s,e,true,false,0,m.fixedTop);}this.renderTableControlCnt(r,t,F,s,e,false,false,m.fixedTop,g.length-m.fixedBottom);if(m.fixedBottom>0&&g.length>0){this.renderTableControlCnt(r,t,F,s,e,false,true,g.length-m.fixedBottom,g.length);}};d.renderTableControlCnt=function(r,t,F,s,e,g,h,i,E,H){var j=H?"-header":"-table";var k=t.getId()+j;var l=[];if(F){k+="-fixed";l.push("sapUiTableCtrlFixed");}else{l.push("sapUiTableCtrlScroll");}if(g){k+="-fixrow";l.push("sapUiTableCtrlRowFixed");}else if(h){k+="-fixrow-bottom";l.push("sapUiTableCtrlRowFixedBottom");}else{l.push("sapUiTableCtrlRowScroll");}r.openStart("table",k);l.forEach(function(J){r.class(J);});t._getAccRenderExtension().writeAriaAttributesFor(r,t,H?"COLUMNHEADER_TABLE":"TABLE");r.class("sapUiTableCtrl");if(H){r.class("sapUiTableCHT");}r.style(F?"width":"min-width",t._getColumnsWidth(s,e)+"px");r.openEnd();r.openStart("thead").openEnd();r.openStart("tr");r.class("sapUiTableCtrlCol");if(i==0){r.class("sapUiTableCtrlFirstCol");}if(H){r.class("sapUiTableCHTHR");}r.openEnd();var m=t.getColumns();var n=new Array(e);var o;var p;var q=!F&&e>s;for(o=s;o<e;o++){p=m[o];var u={shouldRender:!!(p&&p.shouldRender())};if(u.shouldRender){var w=p.getWidth();if(T.isVariableWidth(w)){q=false;if(F){p._iFixWidth=p._iFixWidth||160;w=p._iFixWidth+"px";}}else if(F){delete p._iFixWidth;}u.width=w;}n[o]=u;}if(m.length===0){r.openStart("th").openEnd().close("th");}for(o=s;o<e;o++){j=H?"_hdr":"_col";p=m[o];u=n[o];if(u.shouldRender){if(i==0){r.openStart("th",t.getId()+j+o);t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TH",{column:p});}else{r.openStart("th");}r.style("width",u.width);r.attr("data-sap-ui-headcolindex",o);r.attr("data-sap-ui-colid",p.getId());r.openEnd();if(i==0&&T.getHeaderRowCount(t)==0&&!H){if(p.getMultiLabels().length>0){r.renderControl(p.getMultiLabels()[0]);}else{r.renderControl(p.getLabel());}}r.close("th");}}if(q){r.openStart("th",H&&t.getId()+"-dummycolhdr");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"PRESENTATION");r.openEnd().close("th");}r.close("tr");r.close("thead");r.openStart("tbody").openEnd();var v=t._getVisibleColumns();var x=t.getRows();var y;var z;if(H){for(y=i,z=E;y<z;y++){this.renderColumnHeaderRow(r,t,y,F,s,e,q,y===z-1);}}else{var A=t._getAccExtension().getAriaTextsForSelectionMode(true);var B=T.isRowSelectionAllowed(t);var G=t.getDragDropConfig().some(function(J){return J.getMetadata().isInstanceOf("sap.ui.core.dnd.IDragInfo")&&J.getSourceAggregation()==="rows";});for(y=i,z=E;y<z;y++){this.renderTableRow(r,t,x[y],y,F,s,e,false,v,q,A,B,G);}}r.close("tbody");r.close("table");};d.writeRowSelectorContent=function(r,t,o,i){t._getAccRenderExtension().writeAccRowSelectorText(r,t,o,i);if(T.Grouping.isGroupMode(t)){r.openStart("div");r.class("sapUiTableGroupShield");r.openEnd();r.close("div");r.openStart("div",o.getId()+"-groupHeader");r.class("sapUiTableGroupIcon");r.openEnd();r.close("div");if(T.Grouping.showGroupMenuButton(t)){var e=I.getIconInfo("sap-icon://drop-down-list");r.openStart("div").class("sapUiTableGroupMenuButton").openEnd();r.text(e.content);r.close("div");}}};d.writeRowHighlightContent=function(r,t,o,i){if(!T.hasRowHighlights(t)){return;}var e=o.getAggregation("_settings");var h=e._getHighlightCSSClassName();r.openStart("div",o.getId()+"-highlight");r.class("sapUiTableRowHighlight");r.class(h);r.openEnd();t._getAccRenderExtension().writeAccRowHighlightText(r,t,o,i);r.close("div");};d.renderColumnHeaderRow=function(r,t,i,F,s,e,h,l){r.openStart("tr");r.class("sapUiTableRow");r.class("sapUiTableHeaderRow");r.class("sapUiTableColHdrTr");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"COLUMNHEADER_ROW");r.openEnd();var g,n=0,j=-1;g=t.getColumns().slice(s,e).filter(function(o){return o&&o.shouldRender();});function k(o,p,q){var u=T.Column.getHeaderSpan(o,i),v;if(n<1){if(u>1){v=o.getIndex();u=q.slice(p+1,p+u).reduce(function(w,x){return x.getIndex()-v<u?w+1:w;},1);}o._nSpan=n=u;j=p;}else{o._nSpan=0;}n--;}g.forEach(k);function m(o,p){this.renderCol(r,t,o,i,o._nSpan,p===0,F&&(p==j),!F&&(p==j),o._nSpan===1&&!o._bIconsRendered);o._bIconsRendered=o._bIconsRendered||o._nSpan===1;delete o._nSpan;if(l){delete o._bIconsRendered;}}g.forEach(m.bind(this));if(!F&&h&&g.length>0){r.openStart("td").class("sapUiTableCellDummy");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"PRESENTATION");r.openEnd().close("td");}r.close("tr");};d.renderTableRow=function(r,t,o,i,F,s,e,g,v,h,m,j,k){if(!o){return;}var l=t._getSelectionPlugin();if(F){r.openStart("tr",o.getId()+"-fixed");r.attr("data-sap-ui-related",o.getId());}else{r.openStart("tr",o);}if(o._bDummyRow){r.style("opacity","0");}r.class("sapUiTableRow");r.class("sapUiTableContentRow");r.class("sapUiTableTr");if(o._bHidden){r.class("sapUiTableRowHidden");}else{if(k&&F){r.attr("draggable",true);}if(l.isIndexSelected(o.getIndex())){r.class("sapUiTableRowSel");}}if(i%2!=0&&t.getAlternateRowColors()&&!T.Grouping.isTreeMode(t)){r.class("sapUiTableRowAlternate");}this.addRowCSSClasses(r,t,i);r.attr("data-sap-ui-rowindex",i);t._getRowMode().renderRowStyles(r);t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TR",{index:i,rowHidden:o._bHidden});r.openEnd();var n=!o._bHidden&&l.isIndexSelected(o.getIndex());var p=o.getCells();for(var q=0,u=p.length;q<u;q++){this.renderTableCell(r,t,o,p[q],q,F,s,e,v,n);}if(!F&&h&&p.length>0){r.openStart("td").class("sapUiTableCellDummy");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"PRESENTATION");r.openEnd();r.close("td");}r.close("tr");};d.renderTableCell=function(r,t,o,e,i,F,s,E,v,g){var h=b.ofCell(e);var j=h.getIndex();var l=t.getColumns()[t.getFixedColumnCount()-1];if(h.shouldRender()&&s<=j&&E>j){var k=o.getId()+"-col"+i;r.openStart("td",k);r.attr("tabindex","-1");r.attr("data-sap-ui-colid",h.getId());var n=v.length;var m=n>0&&v[0]===h;var p=n>0&&v[n-1]===h;var q=F&l===h;t._getAccRenderExtension().writeAriaAttributesFor(r,t,"DATACELL",{index:j,column:h,row:o,fixed:F,rowSelected:g});var u=R.getTextAlign(h.getHAlign());if(u){r.style("text-align",u);}r.class("sapUiTableCell");r.class("sapUiTableContentCell");r.class("sapUiTableDataCell");if(m){r.class("sapUiTableCellFirst");}if(q){r.class("sapUiTableCellLastFixed");}if(p){r.class("sapUiTableCellLast");}var B=t.getBinding("rows");if(B&&h.getLeadingProperty&&B.isMeasure(h.getLeadingProperty())){r.class("sapUiTableMeasureCell");}r.openEnd();r.openStart("div");r.class("sapUiTableCellInner");if(m&&T.Grouping.isTreeMode(t)){r.class("sapUiTableCellFlex");}t._getRowMode().renderCellContentStyles(r);r.openEnd();this.renderTableCellControl(r,t,e,m);r.close("div");r.close("td");}};d.renderTableCellControl=function(r,t,o,i){if(i&&T.Grouping.isTreeMode(t)&&!t._bFlatMode){var e=o.getParent();r.openStart("span",e.getId()+"-treeicon");r.class("sapUiTableTreeIcon");r.attr("tabindex","-1");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TREEICON",{row:e});r.openEnd();r.close("span");}r.renderControl(o);};d.renderVSb=function(r,t,m){m=Object.assign({cssClass:"sapUiTableVSb",tabIndex:true,hidden:true},m);m.id=t.getId()+"-vsb";var s=t._getScrollExtension();r.openStart("div",m.id);r.class(m.cssClass);if(m.hidden){r.class("sapUiTableHidden");}if(m.tabIndex){r.attr("tabindex","-1");}r.style("max-height",s.getVerticalScrollbarHeight()+"px");var e=t._getRowCounts();if(e.fixedTop>0){t._iVsbTop=e.fixedTop*t._getBaseRowHeight()-1;r.style("top",t._iVsbTop+'px');}r.openEnd();r.openStart("div",m.id+"-content");r.class("sapUiTableVSbContent");r.style("height",s.getVerticalScrollHeight()+"px");r.openEnd();r.close("div");r.close("div");};d.renderVSbExternal=function(r,t){if(c.isEnrichedWith(t,"sap.ui.table.TableSyncExtension")){this.renderVSb(r,t,{cssClass:"sapUiTableVSbExternal",tabIndex:false});}else{L.error("This method can only be used with synchronization enabled.",t,"TableRenderer.renderVSbExternal");}};d.renderVSbBackground=function(r,t){r.openStart("div",t.getId()+"-vsb-bg");r.class("sapUiTableVSbBg");r.openEnd().close("div");};d.renderHSb=function(r,t,m){m=Object.assign({id:t.getId()+"-hsb",cssClass:"sapUiTableHSb",tabIndex:true,hidden:true,scrollWidth:0},m);r.openStart("div",m.id);r.class(m.cssClass);if(m.hidden){r.class("sapUiTableHidden");}if(m.tabIndex){r.attr("tabindex","-1");}r.openEnd();r.openStart("div",m.id+"-content");r.class("sapUiTableHSbContent");if(m.scrollWidth>0){r.style("width",m.scrollWidth+"px");}r.openEnd();r.close("div");r.close("div");};d.renderHSbExternal=function(r,t,i,s){if(c.isEnrichedWith(t,"sap.ui.table.TableSyncExtension")){this.renderHSb(r,t,{id:i,cssClass:"sapUiTableHSbExternal",tabIndex:false,hidden:false,scrollWidth:s});}else{L.error("This method can only be used with synchronization enabled.",t,"TableRenderer.renderVSbExternal");}};d.renderHSbBackground=function(r,t){r.openStart("div",t.getId()+"-hsb-bg");r.class("sapUiTableHSbBg");r.openEnd().close("div");};d.renderTabElement=function(r,s){r.openStart("div");if(s){r.class(s);}r.attr("tabindex","0");r.openEnd().close("div");};return d;},true);
