/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/Device','sap/ui/core/Control','sap/ui/core/Locale','sap/ui/core/LocaleData','sap/ui/core/Renderer','sap/ui/core/format/DateFormat','./calendar/CalendarUtils','./calendar/CustomYearPicker','./calendar/Header','./calendar/MonthsRow','./calendar/YearPicker','./calendar/CalendarDate','./CalendarMonthIntervalRenderer',"sap/ui/dom/containsOrEquals","sap/base/util/deepEqual","sap/ui/core/Popup","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/unified/DateRange"],function(D,C,L,a,R,b,c,d,H,M,Y,e,f,g,h,P,i,q,j){"use strict";var k=C.extend("sap.ui.unified.CalendarMonthInterval",{metadata:{library:"sap.ui.unified",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},startDate:{type:"object",group:"Data"},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},months:{type:"int",group:"Appearance",defaultValue:12},pickerPopup:{type:"boolean",group:"Appearance",defaultValue:false},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},monthsRow:{type:"sap.ui.unified.calendar.MonthsRow",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"},calendarPicker:{type:"sap.ui.unified.Calendar",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{}}}});k.prototype.init=function(){this._iMode=0;this.data("sap-ui-fastnavgroup","true",true);this._oYearFormat=b.getDateInstance({format:"y"});this._oMinDate=c._minDate();this._oMaxDate=c._maxDate();this._initializeHeader();this._initializeMonthsRow();this._initilizeYearPicker();this._iDaysMonthsHead=15;};k.prototype.exit=function(){if(this._sInvalidateContent){clearTimeout(this._sInvalidateContent);}};k.prototype.onBeforeRendering=function(){var N=this.getAggregation("monthsRow");var O=this._getFocusedDate();r.call(this);N.displayDate(O.toLocalJSDate());};k.prototype._setAriaRole=function(N){var O=this.getAggregation("monthsRow");O._setAriaRole(N);O.invalidate();return this;};k.prototype._initializeHeader=function(){var N=new H(this.getId()+"--Head",{visibleButton0:false,visibleButton1:false,visibleButton2:true});N.attachEvent("pressPrevious",this._handlePrevious,this);N.attachEvent("pressNext",this._handleNext,this);N.attachEvent("pressButton2",x,this);this.setAggregation("header",N);};k.prototype._initializeMonthsRow=function(){var N=new M(this.getId()+"--MonthsRow");N.attachEvent("focus",A,this);N.attachEvent("select",z,this);N._bNoThemeChange=true;this.setAggregation("monthsRow",N);};k.prototype._initilizeYearPicker=function(){this.setAggregation("yearPicker",this._createYearPicker());};k.prototype._createYearPicker=function(){var N=new Y(this.getId()+"--YP",{columns:0,years:6});N.attachEvent("select",E,this);N.attachEvent("pageChange",K,this);N._oMinDate.setYear(this._oMinDate.getYear());N._oMaxDate.setYear(this._oMaxDate.getYear());return N;};k.prototype._getCalendarPicker=function(){var N=this.getAggregation("calendarPicker");if(!N){N=new d(this.getId()+"--Cal");N.setPopupMode(true);N.attachEvent("select",B,this);N.attachEvent("cancel",function(O){this._oPopup.close();var Q=this.getAggregation("header").getDomRef("B2");if(Q){Q.focus();}},this);this.setAggregation("calendarPicker",N);}return N;};k.prototype.setStartDate=function(S){c._checkJSDateObject(S);if(h(this.getStartDate(),S)){return this;}var N=S.getFullYear();c._checkYearInValidRange(N);this.setProperty("startDate",S,true);this._oStartDate=e.fromLocalJSDate(S);this._oStartDate.setDate(1);var O=this.getAggregation("monthsRow");O.setStartDate(S);r.call(this);var Q=this._getFocusedDate().toLocalJSDate();if(!O.checkDateFocusable(Q)){this._setFocusedDate(this._oStartDate);O.displayDate(S);}return this;};k.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof j))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&this._iMode==0&&!this._sInvalidateContent){this._sInvalidateContent=setTimeout(F.bind(this),0);}};k.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var N=this.removeAllAggregation("selectedDates");return N;};k.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var N=this.destroyAggregation("selectedDates");return N;};k.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var N=this.removeAllAggregation("specialDates");return N;};k.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var N=this.destroyAggregation("specialDates");return N;};k.prototype.setLocale=function(N){if(this._sLocale!=N){this._sLocale=N;this._oLocaleData=undefined;this.invalidate();}return this;};k.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};k.prototype._getFocusedDate=function(){if(!this._oFocusedDate){n.call(this);}return this._oFocusedDate;};k.prototype._setFocusedDate=function(N){c._checkCalendarDate(N);this._oFocusedDate=new e(N);};k.prototype.focusDate=function(N){var O=false;var Q=this.getAggregation("monthsRow");if(N&&!Q.checkDateFocusable(N)){G.call(this,e.fromLocalJSDate(N));O=true;}w.call(this,N,false);if(O){this.fireStartDateChange();}return this;};k.prototype.displayDate=function(N){w.call(this,N,true);return this;};k.prototype.setMonths=function(N){this.setProperty("months",N,true);N=this._getMonths();var O=this.getAggregation("monthsRow");O.setMonths(N);if(!O.checkDateFocusable(this._getFocusedDate().toLocalJSDate())){var S=l.call(this);this._setFocusedDate(this._oStartDate);O.setDate(S.toLocalJSDate());}if(!this.getPickerPopup()){var Q=this.getAggregation("yearPicker");var T=Math.floor(N/2);if(T>20){T=20;}Q.setYears(T);}r.call(this);if(this.getDomRef()){if(this._getShowItemHeader()){this.$().addClass("sapUiCalIntHead");}else{this.$().removeClass("sapUiCalIntHead");}}return this;};k.prototype._getMonths=function(){var N=this.getMonths();if(D.system.phone&&N>6){return 6;}else{return N;}};k.prototype._getLocaleData=function(){if(!this._oLocaleData){var N=this.getLocale();var O=new L(N);this._oLocaleData=a.getInstance(O);}return this._oLocaleData;};k.prototype.setPickerPopup=function(N){var O;this.setProperty("pickerPopup",N,true);if(N){if(this.getAggregation("yearPicker")){this.getAggregation("yearPicker").destroy();}}else{if(!this.getAggregation("yearPicker")){this.setAggregation("yearPicker",this._createYearPicker());}O=this.getAggregation("yearPicker");O.setColumns(0);O.setYears(6);}return this;};k.prototype.setMinDate=function(N){if(h(N,this.getMinDate())){return this;}if(!N){this._oMinDate=c._minDate();}else{c._checkJSDateObject(N);this._oMinDate=e.fromLocalJSDate(N);this._oMinDate.setDate(1);var O=this._oMinDate.getYear();c._checkYearInValidRange(O);if(this._oMaxDate.isBefore(this._oMinDate)){i.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=e.fromLocalJSDate(N);this._oMaxDate.setDate(c._daysInMonth(this._oMaxDate));this.setProperty("maxDate",this._oMaxDate.toLocalJSDate(),true);}if(this._oFocusedDate){if(this._oFocusedDate.isBefore(this._oMinDate)){i.warning("focused date < minDate -> minDate focused",this);this.focusDate(N);}}if(this._oStartDate&&this._oStartDate.isBefore(this._oMinDate)){i.warning("start date < minDate -> minDate set as start date",this);_.call(this,new e(this._oMinDate),true,true);}}this.setProperty("minDate",N,false);if(this.getPickerPopup()){var Q=this._getCalendarPicker();Q.setMinDate(N);}else{var S=this.getAggregation("yearPicker");S._oMinDate.setYear(this._oMinDate.getYear());}return this;};k.prototype.setMaxDate=function(N){if(h(N,this.getMaxDate())){return this;}if(!N){this._oMaxDate=c._maxDate();}else{c._checkJSDateObject(N);this._oMaxDate=e.fromLocalJSDate(N);this._oMaxDate.setDate(c._daysInMonth(this._oMaxDate));var O=this._oMaxDate.getYear();c._checkYearInValidRange(O);if(this._oMinDate.isAfter(this._oMaxDate)){i.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=e.fromLocalJSDate(N);this._oMinDate.setDate(1);this.setProperty("minDate",this._oMinDate.toLocalJSDate(),true);}if(this._oFocusedDate){if(this._oFocusedDate.isAfter(this._oMaxDate)){i.warning("focused date > maxDate -> maxDate focused",this);this.focusDate(N);}}if(this._oStartDate){var Q=new e(this._oStartDate);Q.setDate(1);Q.setMonth(Q.getMonth()+this._getMonths());Q.setDate(0);if(Q.isAfter(this._oMaxDate)){var S=new e(this._oMaxDate);S.setDate(1);S.setMonth(S.getMonth()-this._getMonths()+1);if(S.isSameOrAfter(this._oMinDate)){i.warning("end date > maxDate -> maxDate set as end date",this);_.call(this,S,true,true);}}}}this.setProperty("maxDate",N,false);if(this.getPickerPopup()){var T=this._getCalendarPicker();T.setMaxDate(N);}else{var U=this.getAggregation("yearPicker");U._oMaxDate.setYear(this._oMaxDate.getYear());}return this;};k.prototype.onclick=function(N){if(N.isMarked("delayedMouseEvent")){return;}if(N.target.id==this.getId()+"-cancel"){this.onsapescape(N);}};k.prototype.onmousedown=function(N){N.preventDefault();N.setMark("cancelAutoClose");};k.prototype.onsapescape=function(N){if(this.getPickerPopup()){y.call(this);this.fireCancel();}else{switch(this._iMode){case 0:this.fireCancel();break;case 1:p.call(this);break;}}};k.prototype.onsaptabnext=function(N){var O=this.getAggregation("header"),Q,S;if(g(this.getDomRef("content"),N.target)){if(O.getDomRef("B2")){O.getDomRef("B2").focus();}if(!this._bPoupupMode){S=this.getAggregation("monthsRow");q(S._oItemNavigation.getItemDomRefs()[S._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(!this.getPickerPopup()){Q=this.getAggregation("yearPicker");if(Q.getDomRef()){q(Q._oItemNavigation.getItemDomRefs()[Q._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}N.preventDefault();}};k.prototype.onsaptabprevious=function(N){var O=this.getAggregation("header"),Q,S;if(g(this.getDomRef("content"),N.target)){if(this._bPoupupMode){if(O.getDomRef("B2")){O.getDomRef("B2").focus();}N.preventDefault();}}else if(N.target.id==O.getId()+"-B2"){switch(this._iMode){case 0:Q=this.getAggregation("monthsRow");Q._oItemNavigation.focusItem(Q._oItemNavigation.getFocusedIndex());break;case 1:if(!this.getPickerPopup()){S=this.getAggregation("yearPicker");S._oItemNavigation.focusItem(S._oItemNavigation.getFocusedIndex());}break;}N.preventDefault();}};k.prototype.onfocusin=function(N){if(N.target.id==this.getId()+"-end"){var O=this.getAggregation("header"),Q,S;if(O.getDomRef("B2")){O.getDomRef("B2").focus();}if(!this._bPoupupMode){Q=this.getAggregation("monthsRow");q(Q._oItemNavigation.getItemDomRefs()[Q._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(!this.getPickerPopup()){S=this.getAggregation("yearPicker");if(S.getDomRef()){q(S._oItemNavigation.getItemDomRefs()[S._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}}this.$("end").attr("tabindex","-1");};k.prototype.onsapfocusleave=function(N){var O,Q;if(!N.relatedControlId||!g(this.getDomRef(),sap.ui.getCore().byId(N.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){switch(this._iMode){case 0:O=this.getAggregation("monthsRow");q(O._oItemNavigation.getItemDomRefs()[O._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;case 1:if(!this.getPickerPopup()){Q=this.getAggregation("yearPicker");q(Q._oItemNavigation.getItemDomRefs()[Q._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;}}}};k.prototype._handlePrevious=function(N){var O,Q,S,T;switch(this._iMode){case 0:O=this._getFocusedDate();Q=this._getMonths();S=new e(l.call(this));S.setMonth(S.getMonth()-Q);O.setMonth(O.getMonth()-Q);this._setFocusedDate(O);_.call(this,S,true);break;case 1:if(!this.getPickerPopup()){T=this.getAggregation("yearPicker");T.previousPage();t.call(this);}break;}};k.prototype._handleNext=function(N){var O,Q,S,T;switch(this._iMode){case 0:O=this._getFocusedDate();Q=this._getMonths();S=new e(l.call(this));S.setMonth(S.getMonth()+Q);O.setMonth(O.getMonth()+Q);this._setFocusedDate(O);_.call(this,S,true);break;case 1:if(!this.getPickerPopup()){T=this.getAggregation("yearPicker");T.nextPage();t.call(this);}break;}};k.prototype._showOverlay=function(){this.$("contentOver").css("display","");};k.prototype._hideOverlay=function(){this.$("contentOver").css("display","none");};k.prototype._getShowItemHeader=function(){var N=this.getMonths();if(N>this._iDaysMonthsHead){return true;}else{return false;}};function _(S,N,O){var Q=new e(this._oMaxDate);Q.setDate(1);Q.setMonth(Q.getMonth()-this._getMonths()+1);if(Q.isBefore(this._oMinDate)){Q=new e(this._oMinDate);Q.setMonth(Q.getMonth()+this._getMonths()-1);}if(S.isBefore(this._oMinDate)){S=new e(this._oMinDate);}else if(S.isAfter(Q)){S=Q;}S.setDate(1);var T=S.toLocalJSDate();this.setProperty("startDate",T,true);this._oStartDate=S;var U=this.getAggregation("monthsRow");U.setStartDate(T);r.call(this);if(N){var V=this._getFocusedDate().toLocalJSDate();if(!U.checkDateFocusable(V)){this._setFocusedDate(S);U.setDate(T);}else{U.setDate(V);}}if(!O){this.fireStartDateChange();}}function l(){if(!this._oStartDate){this._oStartDate=this._getFocusedDate();this._oStartDate.setDate(1);}return this._oStartDate;}function m(N){var O=this._getFocusedDate();var Q=this.getAggregation("monthsRow");if(!N){Q.setDate(O.toLocalJSDate());}else{Q.displayDate(O.toLocalJSDate());}r.call(this);}function n(){var S=this.getSelectedDates();if(S&&S[0]&&S[0].getStartDate()){this._oFocusedDate=e.fromLocalJSDate(S[0].getStartDate());}else{this._oFocusedDate=new e();}this._oFocusedDate.setDate(1);if(this._oFocusedDate.isBefore(this._oMinDate)){this._oFocusedDate=new e(this._oMinDate);}else if(this._oFocusedDate.isAfter(this._oMaxDate)){this._oFocusedDate=new e(this._oMaxDate);}}function o(){var N=this._getFocusedDate();var O=this.getAggregation("yearPicker");if(O.getDomRef()){O.$().css("display","");}else{var Q=sap.ui.getCore().createRenderManager();var $=this.$("content");Q.renderControl(O);Q.flush($[0],false,true);Q.destroy();}this._showOverlay();O.setDate(N.toLocalJSDate());if(this._iMode==0){var S=this.getAggregation("monthsRow");q(S._oItemNavigation.getItemDomRefs()[S._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}t.call(this);this._iMode=1;}function p(N){this._iMode=0;var O=this.getAggregation("yearPicker");O.$().css("display","none");this._hideOverlay();if(!N){m.call(this);var Q=this.getAggregation("monthsRow");q(Q._oItemNavigation.getItemDomRefs()[Q._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}function r(){u.call(this);s.call(this);}function s(){var N=new e(l.call(this));var O=this._getMonths();var Q=N.getYear();var S=this._oMaxDate.getYear();var T=this._oMinDate.getYear();var U=N.getMonth();var V=this._oMaxDate.getMonth();var W=this._oMinDate.getMonth();var X=this.getAggregation("header");if(Q<T||(Q==T&&U<=W)){X.setEnabledPrevious(false);}else{X.setEnabledPrevious(true);}N.setMonth(N.getMonth()+O-1);Q=N.getYear();U=N.getMonth();if(Q>S||(Q==S&&U>=V)){X.setEnabledNext(false);}else{X.setEnabledNext(true);}}function t(){var N=this.getAggregation("yearPicker");var O=N.getYears();var Q=e.fromLocalJSDate(N.getFirstRenderedDate());Q.setYear(Q.getYear()+Math.floor(O/2));var S=this.getAggregation("header");var T=new e(this._oMaxDate);T.setYear(T.getYear()-Math.ceil(O/2));T.setMonth(11,31);var U=new e(this._oMinDate);U.setYear(U.getYear()+Math.floor(O/2)+1);U.setMonth(0,1);S.setEnabledNext(!Q.isAfter(T));S.setEnabledPrevious(!Q.isBefore(U));}function u(){var T;var S=l.call(this);var N=this._oYearFormat.format(S.toUTCJSDate(),true);var O=new e(S);O.setMonth(O.getMonth()+this._getMonths()-1);var Q=this._oYearFormat.format(O.toUTCJSDate(),true);if(N!=Q){var U=this._getLocaleData();var V=U.getIntervalPattern();T=V.replace(/\{0\}/,N).replace(/\{1\}/,Q);}else{T=N;}var W=this.getAggregation("header");W.setTextButton2(T);}function v(N,O){var Q;var S=false;if(N.isBefore(this._oMinDate)){Q=this._oMinDate;S=true;}else if(N.isAfter(this._oMaxDate)){Q=this._oMaxDate;S=true;}else{Q=N;}this._setFocusedDate(Q);if(S||O){G.call(this,Q);m.call(this,false);this.fireStartDateChange();}}function w(N,S){if(!N){return;}var O=e.fromLocalJSDate(N);if(this._oFocusedDate&&this._oFocusedDate.isSame(O)){return;}var Q=O.getYear();c._checkYearInValidRange(Q);if(c._isOutside(O,this._oMinDate,this._oMaxDate)){throw new Error("Date must not be in valid range (minDate and maxDate); "+this);}this._setFocusedDate(O);if(this.getDomRef()&&this._iMode==0){m.call(this,S);}}function x(N){if(this.getPickerPopup()){this._showCalendarPicker();}else{if(this._iMode!=1){o.call(this);}else{p.call(this);}}}k.prototype._showCalendarPicker=function(){var N=this._getFocusedDate(true).toLocalJSDate();var O=this._getCalendarPicker();var S=new j({startDate:N});O.displayDate(N,false);O.removeAllSelectedDates();O.addSelectedDate(S);O.setMinDate(this.getMinDate());O.setMaxDate(this.getMaxDate());I.call(this,O);this._showOverlay();};function y(N){if(this._oPopup&&this._oPopup.isOpen()){this._oPopup.close();}this._hideOverlay();if(!N){m.call(this);var O=this.getAggregation("monthsRow");q(O._oItemNavigation.getItemDomRefs()[O._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}function z(N){this.fireSelect();}function A(N){var O=e.fromLocalJSDate(N.getParameter("date"));var Q=N.getParameter("notVisible");v.call(this,O,Q);}function B(N){var O=new e(this._getFocusedDate());var Q=this._getCalendarPicker();var S=Q.getSelectedDates()[0].getStartDate();var T=e.fromLocalJSDate(S);T.setMonth(O.getMonth());T.setDate(O.getDate());v.call(this,T,true);y.call(this);}function E(N){var O=new e(this._getFocusedDate());var Q=this.getAggregation("yearPicker");var S=e.fromLocalJSDate(Q.getDate());S.setMonth(O.getMonth());S.setDate(O.getDate());O=S;v.call(this,O,true);p.call(this);}function F(){this._sInvalidateContent=undefined;var N=this.getAggregation("monthsRow");if(N){N._bDateRangeChanged=true;N._bInvalidateSync=true;N.invalidate();N._bInvalidateSync=undefined;}this._bDateRangeChanged=undefined;}function G(N){var O=this.getAggregation("monthsRow");var S=l.call(this);var Q=O._oItemNavigation.getFocusedIndex();S=new e(N);S.setMonth(S.getMonth()-Q);_.call(this,S,false,true);}function I(N){if(!this._oPopup){this._oPopup=new P();this._oPopup.setAutoClose(true);this._oPopup.setAutoCloseAreas([this.getDomRef()]);this._oPopup.setDurations(0,0);this._oPopup._oCalendar=this;this._oPopup.attachClosed(J,this);this._oPopup.onsapescape=function(S){this._oCalendar.onsapescape(S);};}this._oPopup.setContent(N);var O=this.getAggregation("header");var Q=P.Dock;this._oPopup.open(0,Q.CenterTop,Q.CenterTop,O,null,"flipfit",true);}function J(N){y.call(this);}function K(N){t.call(this);}return k;});
